/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-07-27 06:53:02 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text COLLATE utf8mb4_unicode_520_ci COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `route_post_id` bigint unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint unsigned DEFAULT NULL,
  `element_id` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `position` text COLLATE utf8mb4_unicode_520_ci COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `is_resolved` tinyint(1) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `hash_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `main_meta_id` bigint unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint unsigned NOT NULL,
  `referer` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer_title` varchar(300) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `element_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `campaign_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip` varchar(46) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actions_count` int DEFAULT '0',
  `actions_succeeded_count` int DEFAULT '0',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL,
  `action_name` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_label` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log` text COLLATE utf8mb4_unicode_520_ci,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint unsigned NOT NULL DEFAULT '0',
  `key` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_post_types` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_520_ci,
  `status` text COLLATE utf8mb4_unicode_520_ci,
  `labels` longtext COLLATE utf8mb4_unicode_520_ci,
  `args` longtext COLLATE utf8mb4_unicode_520_ci,
  `meta_fields` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_smart_filters_indexer` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `item_id` int unsigned DEFAULT NULL,
  `item_query` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `item_key` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `item_value` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_jet_taxonomies` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `slug` text COLLATE utf8mb4_unicode_520_ci,
  `object_type` text COLLATE utf8mb4_unicode_520_ci,
  `status` text COLLATE utf8mb4_unicode_520_ci,
  `labels` longtext COLLATE utf8mb4_unicode_520_ci,
  `args` longtext COLLATE utf8mb4_unicode_520_ci,
  `meta_fields` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url_id` bigint NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint NOT NULL COMMENT 'mobile=1',
  `webp` tinyint NOT NULL COMMENT 'webp=1',
  `expired` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=6579 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21624 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1881 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_snippets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tags` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scope` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'global',
  `priority` smallint NOT NULL DEFAULT '10',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `revision` bigint NOT NULL DEFAULT '1',
  `cloud_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2025-05-21 19:21:50", "2025-05-21 15:51:50", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20250628_d981d8b1d988d8b4daafd8a7d987d8", "d87d2e15e0f4a8712700_20250628055929", "100", "2025-06-28 06:00:20", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-28 05:59:29\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"d87d2e15e0f4a8712700_20250628055929\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"157.55 sec.\";s:7:\"ExeSize\";s:7:\"73.51KB\";s:7:\"ZipSize\";s:7:\"109.2MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:29:\"/home/heqcbspg/public_html/en\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/heqcbspg/public_html\";s:4:\"Size\";i:114506588;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:6596;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:38316;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:12845;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/heqcbspg/public_html/wp-admin\";i:1;s:38:\"/home/heqcbspg/public_html/wp-includes\";i:2;s:47:\"/home/heqcbspg/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/heqcbspg/public_html\";i:1;s:26:\"/home/heqcbspg/public_html\";i:2;s:37:\"/home/heqcbspg/public_html/wp-content\";i:3;s:45:\"/home/heqcbspg/public_html/wp-content/uploads\";i:4;s:45:\"/home/heqcbspg/public_html/wp-content/plugins\";i:5;s:48:\"/home/heqcbspg/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/heqcbspg/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929_installer.php.bak\";s:4:\"Size\";i:75275;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:110:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_d87d2e1-28055929/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:90:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_d87d2e1-28055929\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:26:\"/home/heqcbspg/public_html\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/heqcbspg/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3527:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the website, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'heqcbspg_test\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'heqcbspg_test\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\ndefine( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\ndefine( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\ndefine( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\ndefine( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\ndefine( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\ndefine( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\ndefine( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n *\n * At the installation time, database tables are created with the specified prefix.\n * Changing this value after WordPress is installed will make your site think\n * it has not been installed.\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/#table-prefix\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:16:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:37:\"define( \'DB_NAME\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:37:\"define( \'DB_USER\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:40:\"define( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\";s:5:\"value\";s:14:\"\'G{Bn(iWh{i}a\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:17:\", \'G{Bn(iWh{i}a\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\";s:5:\"value\";s:66:\"\'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\";s:5:\"value\";s:66:\"\'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\";s:5:\"value\";s:66:\"\'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\";s:5:\"value\";s:66:\"\'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\";s:5:\"value\";s:66:\"\'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\";s:5:\"value\";s:66:\"\'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\";s:5:\"value\";s:66:\"\'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\";s:5:\"value\";s:66:\"\'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:37837483;s:4:\"File\";s:88:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:1:{i:0;s:7:\"utf8mb4\";}s:13:\"collationList\";a:1:{i:0;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"heqcbspg_test\";s:15:\"tablesBaseCount\";i:23;s:16:\"tablesFinalCount\";i:23;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:14479;s:16:\"tablesSizeOnDisk\";i:54673408;s:10:\"tablesList\";a:23:{s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:12;s:4:\"size\";i:294912;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:16384;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:41;s:4:\"size\";i:49152;}s:17:\"wp_jet_post_types\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:6;s:4:\"size\";i:16384;}s:28:\"wp_jet_smart_filters_indexer\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wp_jet_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:321;s:12:\"insertedRows\";i:340;s:4:\"size\";i:3227648;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:12716;s:12:\"insertedRows\";i:11064;s:4:\"size\";i:25346048;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:1147;s:12:\"insertedRows\";i:1545;s:4:\"size\";i:24903680;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:165;s:12:\"insertedRows\";i:170;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:19;s:12:\"insertedRows\";i:31;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:19;s:12:\"insertedRows\";i:31;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:38;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-28 05:59:29\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"d87d2e15e0f4a8712700_20250628055929\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_d87d2e15e0f4a8712700_20250628055929\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:227;s:13:\"BuildProgress\";r:361;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20250628_d981d8b1d988d8b4daafd8a7d987d8", "902edc1e9b49bd9e9053_20250630052659", "100", "2025-06-30 05:28:21", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-30 05:26:59\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"902edc1e9b49bd9e9053_20250630052659\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"164.87 sec.\";s:7:\"ExeSize\";s:7:\"73.51KB\";s:7:\"ZipSize\";s:8:\"109.73MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:60:\"/home/heqcbspg/public_html/en;/home/heqcbspg/public_html/en2\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/heqcbspg/public_html\";s:4:\"Size\";i:115062749;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:6359;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:32497;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:12946;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/heqcbspg/public_html/wp-admin\";i:1;s:38:\"/home/heqcbspg/public_html/wp-includes\";i:2;s:47:\"/home/heqcbspg/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/heqcbspg/public_html\";i:1;s:26:\"/home/heqcbspg/public_html\";i:2;s:37:\"/home/heqcbspg/public_html/wp-content\";i:3;s:45:\"/home/heqcbspg/public_html/wp-content/uploads\";i:4;s:45:\"/home/heqcbspg/public_html/wp-content/plugins\";i:5;s:48:\"/home/heqcbspg/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/heqcbspg/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659_installer.php.bak\";s:4:\"Size\";i:75275;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:110:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_902edc1-30052659/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:90:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_902edc1-30052659\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:26:\"/home/heqcbspg/public_html\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/heqcbspg/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3527:\"<?php\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the website, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/\n *\n * @package WordPress\n */\n\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'heqcbspg_test\' );\n\n/** Database username */\ndefine( \'DB_USER\', \'heqcbspg_test\' );\n\n/** Database password */\ndefine( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\n\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\ndefine( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\ndefine( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\ndefine( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\ndefine( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\ndefine( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\ndefine( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\ndefine( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\n\n/**#@-*/\n\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n *\n * At the installation time, database tables are created with the specified prefix.\n * Changing this value after WordPress is installed will make your site think\n * it has not been installed.\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/#table-prefix\n */\n$table_prefix = \'wp_\';\n\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n\n/* Add any custom values between this line and the \"stop editing\" line. */\n\n\n\n/* That\'s all, stop editing! Happy publishing. */\n\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:16:{s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:37:\"define( \'DB_NAME\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:37:\"define( \'DB_USER\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:40:\"define( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\";s:5:\"value\";s:14:\"\'G{Bn(iWh{i}a\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:17:\", \'G{Bn(iWh{i}a\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\";s:5:\"value\";s:66:\"\'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\";s:5:\"value\";s:66:\"\'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\";s:5:\"value\";s:66:\"\'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\";s:5:\"value\";s:66:\"\'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\";s:5:\"value\";s:66:\"\'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\";s:5:\"value\";s:66:\"\'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\";s:5:\"value\";s:66:\"\'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\";s:5:\"value\";s:66:\"\'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:42553928;s:4:\"File\";s:88:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:1:{i:0;s:7:\"utf8mb4\";}s:13:\"collationList\";a:1:{i:0;s:22:\"utf8mb4_unicode_520_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"heqcbspg_test\";s:15:\"tablesBaseCount\";i:23;s:16:\"tablesFinalCount\";i:23;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:14490;s:16:\"tablesSizeOnDisk\";i:54673408;s:10:\"tablesList\";a:23:{s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:32768;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:12;s:4:\"size\";i:294912;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:2;s:4:\"size\";i:16384;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:39;s:12:\"insertedRows\";i:41;s:4:\"size\";i:49152;}s:17:\"wp_jet_post_types\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:6;s:4:\"size\";i:16384;}s:28:\"wp_jet_smart_filters_indexer\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wp_jet_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:332;s:12:\"insertedRows\";i:339;s:4:\"size\";i:3227648;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:12716;s:12:\"insertedRows\";i:12382;s:4:\"size\";i:25346048;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:1147;s:12:\"insertedRows\";i:1644;s:4:\"size\";i:24903680;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:165;s:12:\"insertedRows\";i:176;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:19;s:12:\"insertedRows\";i:31;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:8;s:12:\"insertedRows\";i:8;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:19;s:12:\"insertedRows\";i:31;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:38;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-30 05:26:59\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"902edc1e9b49bd9e9053_20250630052659\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_902edc1e9b49bd9e9053_20250630052659\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:227;s:13:\"BuildProgress\";r:361;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("3", "20250628_d981d8b1d988d8b4daafd8a7d987d8", "e15fcb9979d057e55719_20250709070356", "100", "2025-07-09 07:05:46", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-09 07:03:56\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:3;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"e15fcb9979d057e55719_20250709070356\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"161.15 sec.\";s:7:\"ExeSize\";s:7:\"73.51KB\";s:7:\"ZipSize\";s:8:\"113.66MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:60:\"/home/heqcbspg/public_html/en;/home/heqcbspg/public_html/en2\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/heqcbspg/public_html\";s:4:\"Size\";i:119185562;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2157;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11113;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13269;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/heqcbspg/public_html/wp-admin\";i:1;s:38:\"/home/heqcbspg/public_html/wp-includes\";i:2;s:47:\"/home/heqcbspg/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/heqcbspg/public_html\";i:1;s:26:\"/home/heqcbspg/public_html\";i:2;s:37:\"/home/heqcbspg/public_html/wp-content\";i:3;s:45:\"/home/heqcbspg/public_html/wp-content/uploads\";i:4;s:45:\"/home/heqcbspg/public_html/wp-content/plugins\";i:5;s:48:\"/home/heqcbspg/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/heqcbspg/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356_installer.php.bak\";s:4:\"Size\";i:75275;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:110:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_e15fcb9-09070356/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:90:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_e15fcb9-09070356\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:26:\"/home/heqcbspg/public_html\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/heqcbspg/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3538:\"<?php\ndefine( \'WP_CACHE\', true );\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the website, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/\n *\n * @package WordPress\n */\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'heqcbspg_test\' );\n/** Database username */\ndefine( \'DB_USER\', \'heqcbspg_test\' );\n/** Database password */\ndefine( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\ndefine( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\ndefine( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\ndefine( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\ndefine( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\ndefine( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\ndefine( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\ndefine( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\n/**#@-*/\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n *\n * At the installation time, database tables are created with the specified prefix.\n * Changing this value after WordPress is installed will make your site think\n * it has not been installed.\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/#table-prefix\n */\n$table_prefix = \'wp_\';\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n/* Add any custom values between this line and the \"stop editing\" line. */\n/* That\'s all, stop editing! Happy publishing. */\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:37:\"define( \'DB_NAME\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:37:\"define( \'DB_USER\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:40:\"define( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\";s:5:\"value\";s:14:\"\'G{Bn(iWh{i}a\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:17:\", \'G{Bn(iWh{i}a\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\";s:5:\"value\";s:66:\"\'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\";s:5:\"value\";s:66:\"\'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\";s:5:\"value\";s:66:\"\'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\";s:5:\"value\";s:66:\"\'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\";s:5:\"value\";s:66:\"\'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\";s:5:\"value\";s:66:\"\'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\";s:5:\"value\";s:66:\"\'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\";s:5:\"value\";s:66:\"\'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7813201;s:4:\"File\";s:88:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:1:{i:0;s:7:\"utf8mb4\";}s:13:\"collationList\";a:2:{i:0;s:22:\"utf8mb4_unicode_520_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"heqcbspg_test\";s:15:\"tablesBaseCount\";i:25;s:16:\"tablesFinalCount\";i:25;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:3194;s:16:\"tablesSizeOnDisk\";i:13467648;s:10:\"tablesList\";a:25:{s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:3;s:4:\"size\";i:98304;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:12;s:4:\"size\";i:294912;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:131072;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:41;s:12:\"insertedRows\";i:41;s:4:\"size\";i:49152;}s:17:\"wp_jet_post_types\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:16384;}s:28:\"wp_jet_smart_filters_indexer\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wp_jet_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:16:\"wp_litespeed_url\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_litespeed_url_file\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:554;s:12:\"insertedRows\";i:568;s:4:\"size\";i:3325952;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:2090;s:12:\"insertedRows\";i:1931;s:4:\"size\";i:5881856;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:248;s:12:\"insertedRows\";i:246;s:4:\"size\";i:2670592;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:138;s:12:\"insertedRows\";i:138;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:26;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:26;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:38;s:12:\"insertedRows\";i:38;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-09 07:03:56\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"e15fcb9979d057e55719_20250709070356\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_e15fcb9979d057e55719_20250709070356\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:377;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("4", "20250628_d981d8b1d988d8b4daafd8a7d987d8", "2c36fff522d1b7c03276_20250714093641", "100", "2025-07-14 09:37:12", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-14 09:36:41\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"2c36fff522d1b7c03276_20250714093641\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"161.87 sec.\";s:7:\"ExeSize\";s:7:\"73.51KB\";s:7:\"ZipSize\";s:8:\"113.68MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:60:\"/home/heqcbspg/public_html/en;/home/heqcbspg/public_html/en2\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/heqcbspg/public_html\";s:4:\"Size\";i:119198742;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2157;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11115;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13271;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/heqcbspg/public_html/wp-admin\";i:1;s:38:\"/home/heqcbspg/public_html/wp-includes\";i:2;s:47:\"/home/heqcbspg/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/heqcbspg/public_html\";i:1;s:26:\"/home/heqcbspg/public_html\";i:2;s:37:\"/home/heqcbspg/public_html/wp-content\";i:3;s:45:\"/home/heqcbspg/public_html/wp-content/uploads\";i:4;s:45:\"/home/heqcbspg/public_html/wp-content/plugins\";i:5;s:48:\"/home/heqcbspg/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/heqcbspg/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641_installer.php.bak\";s:4:\"Size\";i:75275;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:110:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_2c36fff-14093641/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:90:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/original_files_2c36fff-14093641\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:26:\"/home/heqcbspg/public_html\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/heqcbspg/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3538:\"<?php\ndefine( \'WP_CACHE\', true );\n/**\n * The base configuration for WordPress\n *\n * The wp-config.php creation script uses this file during the installation.\n * You don\'t have to use the website, you can copy this file to \"wp-config.php\"\n * and fill in the values.\n *\n * This file contains the following configurations:\n *\n * * Database settings\n * * Secret keys\n * * Database table prefix\n * * ABSPATH\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/\n *\n * @package WordPress\n */\n// ** Database settings - You can get this info from your web host ** //\n/** The name of the database for WordPress */\ndefine( \'DB_NAME\', \'heqcbspg_test\' );\n/** Database username */\ndefine( \'DB_USER\', \'heqcbspg_test\' );\n/** Database password */\ndefine( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\n/** Database hostname */\ndefine( \'DB_HOST\', \'localhost\' );\n/** Database charset to use in creating database tables. */\ndefine( \'DB_CHARSET\', \'utf8mb4\' );\n/** The database collate type. Don\'t change this if in doubt. */\ndefine( \'DB_COLLATE\', \'\' );\n/**#@+\n * Authentication unique keys and salts.\n *\n * Change these to different unique phrases! You can generate these using\n * the {@link https://api.wordpress.org/secret-key/1.1/salt/ WordPress.org secret-key service}.\n *\n * You can change these at any point in time to invalidate all existing cookies.\n * This will force all users to have to log in again.\n *\n * @since 2.6.0\n */\ndefine( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\ndefine( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\ndefine( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\ndefine( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\ndefine( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\ndefine( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\ndefine( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\ndefine( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\n/**#@-*/\n/**\n * WordPress database table prefix.\n *\n * You can have multiple installations in one database if you give each\n * a unique prefix. Only numbers, letters, and underscores please!\n *\n * At the installation time, database tables are created with the specified prefix.\n * Changing this value after WordPress is installed will make your site think\n * it has not been installed.\n *\n * @link https://developer.wordpress.org/advanced-administration/wordpress/wp-config/#table-prefix\n */\n$table_prefix = \'wp_\';\n/**\n * For developers: WordPress debugging mode.\n *\n * Change this to true to enable the display of notices during development.\n * It is strongly recommended that plugin and theme developers use WP_DEBUG\n * in their development environments.\n *\n * For information on other constants that can be used for debugging,\n * visit the documentation.\n *\n * @link https://developer.wordpress.org/advanced-administration/debug/debug-wordpress/\n */\ndefine( \'WP_DEBUG\', false );\n/* Add any custom values between this line and the \"stop editing\" line. */\n/* That\'s all, stop editing! Happy publishing. */\n/** Absolute path to the WordPress directory. */\nif ( ! defined( \'ABSPATH\' ) ) {\n	define( \'ABSPATH\', __DIR__ . \'/\' );\n}\n/** Sets up WordPress vars and included files. */\nrequire_once ABSPATH . \'wp-settings.php\';\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:8:\"WP_CACHE\";a:3:{s:3:\"src\";s:27:\"define( \'WP_CACHE\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_CACHE\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:37:\"define( \'DB_NAME\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_NAME\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:37:\"define( \'DB_USER\', \'heqcbspg_test\' );\";s:5:\"value\";s:15:\"\'heqcbspg_test\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_USER\'\";i:1;s:18:\", \'heqcbspg_test\' \";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:40:\"define( \'DB_PASSWORD\', \'G{Bn(iWh{i}a\' );\";s:5:\"value\";s:14:\"\'G{Bn(iWh{i}a\'\";s:5:\"parts\";a:3:{i:0;s:21:\"define( \'DB_PASSWORD\'\";i:1;s:17:\", \'G{Bn(iWh{i}a\' \";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:33:\"define( \'DB_HOST\', \'localhost\' );\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define( \'DB_HOST\'\";i:1;s:14:\", \'localhost\' \";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:34:\"define( \'DB_CHARSET\', \'utf8mb4\' );\";s:5:\"value\";s:9:\"\'utf8mb4\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_CHARSET\'\";i:1;s:12:\", \'utf8mb4\' \";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:27:\"define( \'DB_COLLATE\', \'\' );\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'DB_COLLATE\'\";i:1;s:5:\", \'\' \";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_KEY\',         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' );\";s:5:\"value\";s:66:\"\'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'AUTH_KEY\'\";i:1;s:77:\",         \'nh}MpWJfL+?+WWKRlL#KF6&]$[nKpo#xzWf5vAG/)^%g^2TDgj_HegGgK:k|gu}S\' \";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_KEY\',  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' );\";s:5:\"value\";s:66:\"\'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define( \'SECURE_AUTH_KEY\'\";i:1;s:70:\",  \'aknRbA~P~;vWV{mckvthHKYSTA-%6uVBalBHjT0B|&K1ly3=qIxN~VzP;@<v3WW1\' \";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_KEY\',    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' );\";s:5:\"value\";s:66:\"\'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define( \'LOGGED_IN_KEY\'\";i:1;s:72:\",    \'Z4g#tR1A,_9FasUyp|<<c;|f;vzh3O*q*R3?Z/;lQ79[(c.A`SYK|TgNkU<CV)|R\' \";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_KEY\',        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' );\";s:5:\"value\";s:66:\"\'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'NONCE_KEY\'\";i:1;s:76:\",        \'rJb >aQYxUs~{e}iDM rq$+>/iTV%ruE#QF^V]VR:mF3`3apv[.jNhqT.UXAI]G]\' \";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'AUTH_SALT\',        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' );\";s:5:\"value\";s:66:\"\'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define( \'AUTH_SALT\'\";i:1;s:76:\",        \'(,hN,ZAq{HFb#E.Az9}X91Jj5Vm-4I^Pe>+KE$MSP(06 I;S$Ja,tGW_/%%h=~je\' \";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'SECURE_AUTH_SALT\', \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' );\";s:5:\"value\";s:66:\"\'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\'\";s:5:\"parts\";a:3:{i:0;s:26:\"define( \'SECURE_AUTH_SALT\'\";i:1;s:69:\", \'0t/c(kK@16G[*dKIU&{KC)Pv8uh;}Ho2YI1j1^I iX)cn<JN)&?qt%K+vY|,b.j<\' \";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'LOGGED_IN_SALT\',   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' );\";s:5:\"value\";s:66:\"\'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define( \'LOGGED_IN_SALT\'\";i:1;s:71:\",   \'V+]4fFf<IPYX[dS7{69Odl1$E)WP7.MhEWq=&wA81.^)4@N*lw~gp;1Bbh6lwE:)\' \";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:97:\"define( \'NONCE_SALT\',       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' );\";s:5:\"value\";s:66:\"\'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define( \'NONCE_SALT\'\";i:1;s:75:\",       \'S(M2[KJzA~Rxin[lLx<$b]C+3Quxs2FZvo3&.6[vb`@vJGN#H>=m#HO)_fpv9zZ|\' \";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:28:\"define( \'WP_DEBUG\', false );\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:18:\"define( \'WP_DEBUG\'\";i:1;s:8:\", false \";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:36:\"	define( \'ABSPATH\', __DIR__ . \'/\' );\";s:5:\"value\";s:13:\"__DIR__ . \'/\'\";s:5:\"parts\";a:3:{i:0;s:18:\"	define( \'ABSPATH\'\";i:1;s:16:\", __DIR__ . \'/\' \";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:22:\"$table_prefix = \'wp_\';\";s:5:\"value\";s:5:\"\'wp_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:7:\" \'wp_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7900869;s:4:\"File\";s:88:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:1:{i:0;s:7:\"utf8mb4\";}s:13:\"collationList\";a:2:{i:0;s:22:\"utf8mb4_unicode_520_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:1:{i:0;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:0;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:13:\"heqcbspg_test\";s:15:\"tablesBaseCount\";i:25;s:16:\"tablesFinalCount\";i:25;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:3199;s:16:\"tablesSizeOnDisk\";i:13451264;s:10:\"tablesList\";a:25:{s:14:\"wp_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:11:\"wp_comments\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:98304;}s:22:\"wp_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:4;s:4:\"size\";i:98304;}s:11:\"wp_e_events\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:32768;}s:10:\"wp_e_notes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:196608;}s:26:\"wp_e_notes_users_relations\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:65536;}s:16:\"wp_e_submissions\";a:3:{s:14:\"inaccurateRows\";i:12;s:12:\"insertedRows\";i:12;s:4:\"size\";i:294912;}s:28:\"wp_e_submissions_actions_log\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:131072;}s:23:\"wp_e_submissions_values\";a:3:{s:14:\"inaccurateRows\";i:41;s:12:\"insertedRows\";i:41;s:4:\"size\";i:49152;}s:17:\"wp_jet_post_types\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:16384;}s:28:\"wp_jet_smart_filters_indexer\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:16384;}s:17:\"wp_jet_taxonomies\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:16384;}s:8:\"wp_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:16:\"wp_litespeed_url\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"wp_litespeed_url_file\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:10:\"wp_options\";a:3:{s:14:\"inaccurateRows\";i:559;s:12:\"insertedRows\";i:571;s:4:\"size\";i:3309568;}s:11:\"wp_postmeta\";a:3:{s:14:\"inaccurateRows\";i:2090;s:12:\"insertedRows\";i:1947;s:4:\"size\";i:5881856;}s:8:\"wp_posts\";a:3:{s:14:\"inaccurateRows\";i:248;s:12:\"insertedRows\";i:246;s:4:\"size\";i:2670592;}s:11:\"wp_snippets\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:49152;}s:21:\"wp_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:138;s:12:\"insertedRows\";i:138;s:4:\"size\";i:32768;}s:16:\"wp_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:26;s:4:\"size\";i:49152;}s:11:\"wp_termmeta\";a:3:{s:14:\"inaccurateRows\";i:3;s:12:\"insertedRows\";i:3;s:4:\"size\";i:49152;}s:8:\"wp_terms\";a:3:{s:14:\"inaccurateRows\";i:26;s:12:\"insertedRows\";i:26;s:4:\"size\";i:49152;}s:11:\"wp_usermeta\";a:3:{s:14:\"inaccurateRows\";i:38;s:12:\"insertedRows\";i:38;s:4:\"size\";i:49152;}s:8:\"wp_users\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-14 09:36:41\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"2c36fff522d1b7c03276_20250714093641\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_2c36fff522d1b7c03276_20250714093641\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:377;}}}");
INSERT INTO `wp_duplicator_packages` VALUES("5", "20250628_d981d8b1d988d8b4daafd8a7d987d8", "31dbf334864cbca79181_20250727065033", "20", "2025-07-27 06:53:02", "admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-27 06:50:33\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"31dbf334864cbca79181_20250727065033\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.8\";s:6:\"WPUser\";s:5:\"admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:60:\"/home/heqcbspg/public_html/en;/home/heqcbspg/public_html/en2\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/heqcbspg/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2157;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11103;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-27 06:50:33\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"31dbf334864cbca79181_20250727065033\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/heqcbspg/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:147:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp/20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/heqcbspg/public_html/wp-admin\";i:1;s:38:\"/home/heqcbspg/public_html/wp-includes\";i:2;s:47:\"/home/heqcbspg/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/heqcbspg/public_html\";i:1;s:26:\"/home/heqcbspg/public_html\";i:2;s:37:\"/home/heqcbspg/public_html/wp-content\";i:3;s:45:\"/home/heqcbspg/public_html/wp-content/uploads\";i:4;s:45:\"/home/heqcbspg/public_html/wp-content/plugins\";i:5;s:48:\"/home/heqcbspg/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/heqcbspg/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_events */
INSERT INTO `wp_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2025-05-21T19:29:12.117-04:30\"}", "2025-05-22 03:29:12");

/* INSERT TABLE DATA: wp_e_submissions */
INSERT INTO `wp_e_submissions` VALUES("1", "submission", "cb02ecb1-f12d-4ba7-b0c9-046ed01ed02b", "2", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم جدید", "0", "1", "5.239.173.113", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 18:48:03", "2025-06-09 18:48:04", "2025-06-09 22:18:03", "2025-06-09 22:18:04");
INSERT INTO `wp_e_submissions` VALUES("2", "submission", "6ec326cc-4acb-4ffa-9f21-7080e6d529b0", "4", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "1", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:25:10", "2025-06-09 19:25:10", "2025-06-09 22:55:10", "2025-06-09 22:55:10");
INSERT INTO `wp_e_submissions` VALUES("3", "submission", "908c2ad4-0c23-4a43-8932-ca7c4c80456e", "8", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "0", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 Edg/137.0.0.0", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:36:26", "2025-06-09 19:36:26", "2025-06-09 23:06:26", "2025-06-09 23:06:26");
INSERT INTO `wp_e_submissions` VALUES("4", "submission", "5a9c1ae9-41c6-41d7-8d1f-4a51989b7d7c", "12", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "0", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 Edg/137.0.0.0", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:39:43", "2025-06-09 19:39:43", "2025-06-09 23:09:43", "2025-06-09 23:09:43");
INSERT INTO `wp_e_submissions` VALUES("5", "submission", "f80a40e3-cc5d-423f-9e10-3fbab7a91e74", "16", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "0", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 Edg/137.0.0.0", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:40:15", "2025-06-09 19:40:15", "2025-06-09 23:10:15", "2025-06-09 23:10:15");
INSERT INTO `wp_e_submissions` VALUES("6", "submission", "83eeb58a-2bef-43fb-a634-deb81cdcd95b", "20", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "0", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 Edg/137.0.0.0", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:41:48", "2025-06-09 19:41:48", "2025-06-09 23:11:48", "2025-06-09 23:11:48");
INSERT INTO `wp_e_submissions` VALUES("7", "submission", "36e2aa28-33ea-4c0a-8088-85d9f24ba762", "24", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "1", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:45:01", "2025-06-09 19:45:01", "2025-06-09 23:15:01", "2025-06-09 23:15:01");
INSERT INTO `wp_e_submissions` VALUES("8", "submission", "c9c708fe-f342-41cc-9e3f-db16dd3e0b62", "28", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "0", "5.239.173.113", "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36 Edg/137.0.0.0", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:46:43", "2025-06-09 19:46:43", "2025-06-09 23:16:43", "2025-06-09 23:16:43");
INSERT INTO `wp_e_submissions` VALUES("9", "submission", "a2735e50-1213-47b4-b3bf-f1cd3584992c", "32", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "0", "5.239.173.113", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36 Edg/137.0.0.0", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:48:56", "2025-06-09 19:48:56", "2025-06-09 23:18:56", "2025-06-09 23:18:56");
INSERT INTO `wp_e_submissions` VALUES("10", "submission", "b547b2e3-0c02-41ce-b353-f083dee01412", "36", "506", "https://desing85.ir/test/", "ٌصفحه اصلی (Test)", "0fa6f6f", "فرم ثبت سفارش", "0", "1", "5.239.173.113", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36", "0", "0", "new", "0", "{\"edit_post_id\":\"506\"}", "2025-06-09 19:51:00", "2025-06-09 19:51:00", "2025-06-09 23:21:00", "2025-06-09 23:21:00");
INSERT INTO `wp_e_submissions` VALUES("11", "submission", "f7c4940b-66d1-4d52-b2ef-dc54f1a235d0", "40", "646", "https://desing85.ir/", "", "e57a69c", "خبر نامه", "0", "0", "5.239.173.171", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"646\"}", "2025-06-27 12:01:14", "2025-06-27 12:01:14", "2025-06-27 15:31:14", "2025-06-27 15:31:14");
INSERT INTO `wp_e_submissions` VALUES("12", "submission", "1f602e6d-3392-4d8d-8af0-5216429c8269", "41", "646", "https://desing85.ir/", "", "e57a69c", "خبر نامه", "0", "0", "5.239.173.171", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Safari/537.36", "0", "0", "new", "0", "{\"edit_post_id\":\"646\"}", "2025-06-27 12:02:42", "2025-06-27 12:02:42", "2025-06-27 15:32:42", "2025-06-27 15:32:42");

/* INSERT TABLE DATA: wp_e_submissions_actions_log */
INSERT INTO `wp_e_submissions_actions_log` VALUES("1", "1", "email", "ایمیل", "success", NULL, "2025-06-09 18:48:04", "2025-06-09 18:48:04", "2025-06-09 22:18:04", "2025-06-09 22:18:04");
INSERT INTO `wp_e_submissions_actions_log` VALUES("2", "11", "email", "آدرس ایمیل", "success", NULL, "2025-06-27 12:01:14", "2025-06-27 12:01:14", "2025-06-27 15:31:14", "2025-06-27 15:31:14");

/* INSERT TABLE DATA: wp_e_submissions_values */
INSERT INTO `wp_e_submissions_values` VALUES("1", "1", "name", "علی مشهدی");
INSERT INTO `wp_e_submissions_values` VALUES("2", "1", "email", "ali@gmail.com");
INSERT INTO `wp_e_submissions_values` VALUES("3", "1", "message", "sdsdsdd");
INSERT INTO `wp_e_submissions_values` VALUES("4", "2", "fullname", "علی مشهدی");
INSERT INTO `wp_e_submissions_values` VALUES("5", "2", "phoneNumber", "09109669653");
INSERT INTO `wp_e_submissions_values` VALUES("6", "2", "field_de3fff6", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("7", "2", "message", "تست دوم");
INSERT INTO `wp_e_submissions_values` VALUES("8", "3", "fullname", "تسیسی");
INSERT INTO `wp_e_submissions_values` VALUES("9", "3", "phoneNumber", "02132323");
INSERT INTO `wp_e_submissions_values` VALUES("10", "3", "field_de3fff6", "232323");
INSERT INTO `wp_e_submissions_values` VALUES("11", "3", "message", "2323");
INSERT INTO `wp_e_submissions_values` VALUES("12", "4", "fullname", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("13", "4", "phoneNumber", "0434343");
INSERT INTO `wp_e_submissions_values` VALUES("14", "4", "field_de3fff6", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("15", "4", "message", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("16", "5", "fullname", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("17", "5", "phoneNumber", "23232332");
INSERT INTO `wp_e_submissions_values` VALUES("18", "5", "field_de3fff6", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("19", "5", "message", "dfdf");
INSERT INTO `wp_e_submissions_values` VALUES("20", "6", "fullname", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("21", "6", "phoneNumber", "23232332");
INSERT INTO `wp_e_submissions_values` VALUES("22", "6", "field_de3fff6", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("23", "6", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("24", "7", "fullname", "علی مشهدی");
INSERT INTO `wp_e_submissions_values` VALUES("25", "7", "phoneNumber", "09109669653");
INSERT INTO `wp_e_submissions_values` VALUES("26", "7", "field_de3fff6", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("27", "7", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("28", "8", "fullname", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("29", "8", "phoneNumber", "23232332");
INSERT INTO `wp_e_submissions_values` VALUES("30", "8", "field_de3fff6", "sdsdsd");
INSERT INTO `wp_e_submissions_values` VALUES("31", "8", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("32", "9", "fullname", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("33", "9", "phoneNumber", "09109669653");
INSERT INTO `wp_e_submissions_values` VALUES("34", "9", "field_de3fff6", "تست شرکت");
INSERT INTO `wp_e_submissions_values` VALUES("35", "9", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("36", "10", "fullname", "علی مشهدی");
INSERT INTO `wp_e_submissions_values` VALUES("37", "10", "phoneNumber", "09109669653");
INSERT INTO `wp_e_submissions_values` VALUES("38", "10", "field_de3fff6", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("39", "10", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("40", "11", "email", "alimashhadi910@gmail.com");
INSERT INTO `wp_e_submissions_values` VALUES("41", "12", "email", "alimashhadi910@gmail.com");

/* INSERT TABLE DATA: wp_jet_post_types */
INSERT INTO `wp_jet_post_types` VALUES("1", "products", "publish", "a:1:{s:4:\"name\";s:14:\"محصولات\";}", "a:24:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:14:\"custom_storage\";b:0;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:12:\"rewrite_slug\";s:8:\"products\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:-1;s:9:\"menu_icon\";s:18:\"dashicons-products\";s:8:\"supports\";a:5:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:8:\"comments\";i:4;s:7:\"excerpt\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:3:{i:0;a:12:{s:5:\"title\";s:30:\"مناسب برای خودرو\";s:4:\"name\";s:18:\"vehicle-compatible\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:1:{i:0;a:5:{s:5:\"title\";s:17:\"نام خودرو\";s:4:\"name\";s:12:\"vehicle-name\";s:4:\"type\";s:4:\"text\";s:14:\"options_source\";s:6:\"manual\";s:2:\"id\";i:6329;}}s:4:\"type\";s:8:\"repeater\";s:2:\"id\";i:3496;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:20:\"repeater_title_field\";s:12:\"vehicle-name\";s:18:\"repeater_collapsed\";b:1;}i:1;a:11:{s:5:\"title\";s:21:\"توضیح کوتاه\";s:4:\"name\";s:17:\"short_description\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:8270;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:11:\"description\";s:101:\"نکته : پیشنهاد میشود در این بخش مدل محصول را وارد نمایید.\";}i:2;a:11:{s:5:\"title\";s:23:\"گالری تصاویر\";s:4:\"name\";s:13:\"image-gallery\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:7:\"gallery\";s:2:\"id\";i:5849;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:12:\"value_format\";s:2:\"id\";}}");
INSERT INTO `wp_jet_post_types` VALUES("2", NULL, "glossary", "a:1:{s:4:\"name\";s:14:\"iran_provinces\";}", "a:4:{s:6:\"source\";s:6:\"manual\";s:9:\"value_col\";s:5:\"value\";s:9:\"label_col\";s:5:\"label\";s:11:\"source_file\";a:3:{s:2:\"id\";s:3:\"162\";s:4:\"name\";s:9:\"CITY.json\";s:3:\"url\";s:56:\"https://desing85.ir/wp-content/uploads/2025/05/CITY.json\";}}", "a:31:{i:0;a:3:{s:5:\"value\";s:5:\"IR-01\";s:5:\"label\";s:27:\"آذربایجان شرقی\";s:10:\"is_checked\";b:0;}i:1;a:3:{s:5:\"value\";s:5:\"IR-02\";s:5:\"label\";s:27:\"آذربایجان غربی\";s:10:\"is_checked\";b:0;}i:2;a:3:{s:5:\"value\";s:5:\"IR-03\";s:5:\"label\";s:12:\"اردبیل\";s:10:\"is_checked\";b:0;}i:3;a:3:{s:5:\"value\";s:5:\"IR-04\";s:5:\"label\";s:12:\"اصفهان\";s:10:\"is_checked\";b:0;}i:4;a:3:{s:5:\"value\";s:5:\"IR-05\";s:5:\"label\";s:10:\"ایلام\";s:10:\"is_checked\";b:0;}i:5;a:3:{s:5:\"value\";s:5:\"IR-06\";s:5:\"label\";s:10:\"بوشهر\";s:10:\"is_checked\";b:0;}i:6;a:3:{s:5:\"value\";s:5:\"IR-07\";s:5:\"label\";s:10:\"تهران\";s:10:\"is_checked\";b:0;}i:7;a:3:{s:5:\"value\";s:5:\"IR-08\";s:5:\"label\";s:34:\"چهارمحال و بختیاری\";s:10:\"is_checked\";b:0;}i:8;a:3:{s:5:\"value\";s:5:\"IR-10\";s:5:\"label\";s:14:\"خوزستان\";s:10:\"is_checked\";b:0;}i:9;a:3:{s:5:\"value\";s:5:\"IR-11\";s:5:\"label\";s:10:\"زنجان\";s:10:\"is_checked\";b:0;}i:10;a:3:{s:5:\"value\";s:5:\"IR-12\";s:5:\"label\";s:10:\"سمنان\";s:10:\"is_checked\";b:0;}i:11;a:3:{s:5:\"value\";s:5:\"IR-13\";s:5:\"label\";s:32:\"سیستان و بلوچستان\";s:10:\"is_checked\";b:0;}i:12;a:3:{s:5:\"value\";s:5:\"IR-14\";s:5:\"label\";s:8:\"فارس\";s:10:\"is_checked\";b:0;}i:13;a:3:{s:5:\"value\";s:5:\"IR-15\";s:5:\"label\";s:10:\"کرمان\";s:10:\"is_checked\";b:0;}i:14;a:3:{s:5:\"value\";s:5:\"IR-16\";s:5:\"label\";s:14:\"کردستان\";s:10:\"is_checked\";b:0;}i:15;a:3:{s:5:\"value\";s:5:\"IR-17\";s:5:\"label\";s:16:\"کرمانشاه\";s:10:\"is_checked\";b:0;}i:16;a:3:{s:5:\"value\";s:5:\"IR-18\";s:5:\"label\";s:36:\"کهگیلویه و بویراحمد\";s:10:\"is_checked\";b:0;}i:17;a:3:{s:5:\"value\";s:5:\"IR-19\";s:5:\"label\";s:10:\"گیلان\";s:10:\"is_checked\";b:0;}i:18;a:3:{s:5:\"value\";s:5:\"IR-20\";s:5:\"label\";s:12:\"لرستان\";s:10:\"is_checked\";b:0;}i:19;a:3:{s:5:\"value\";s:5:\"IR-21\";s:5:\"label\";s:16:\"مازندران\";s:10:\"is_checked\";b:0;}i:20;a:3:{s:5:\"value\";s:5:\"IR-22\";s:5:\"label\";s:10:\"مرکزی\";s:10:\"is_checked\";b:0;}i:21;a:3:{s:5:\"value\";s:5:\"IR-23\";s:5:\"label\";s:14:\"هرمزگان\";s:10:\"is_checked\";b:0;}i:22;a:3:{s:5:\"value\";s:5:\"IR-24\";s:5:\"label\";s:10:\"همدان\";s:10:\"is_checked\";b:0;}i:23;a:3:{s:5:\"value\";s:5:\"IR-25\";s:5:\"label\";s:6:\"یزد\";s:10:\"is_checked\";b:0;}i:24;a:3:{s:5:\"value\";s:5:\"IR-26\";s:5:\"label\";s:4:\"قم\";s:10:\"is_checked\";b:0;}i:25;a:3:{s:5:\"value\";s:5:\"IR-27\";s:5:\"label\";s:12:\"گلستان\";s:10:\"is_checked\";b:0;}i:26;a:3:{s:5:\"value\";s:5:\"IR-28\";s:5:\"label\";s:10:\"قزوین\";s:10:\"is_checked\";b:0;}i:27;a:3:{s:5:\"value\";s:5:\"IR-29\";s:5:\"label\";s:23:\"خراسان جنوبی\";s:10:\"is_checked\";b:0;}i:28;a:3:{s:5:\"value\";s:5:\"IR-30\";s:5:\"label\";s:21:\"خراسان رضوی\";s:10:\"is_checked\";b:0;}i:29;a:3:{s:5:\"value\";s:5:\"IR-31\";s:5:\"label\";s:23:\"خراسان شمالی\";s:10:\"is_checked\";b:0;}i:30;a:3:{s:5:\"value\";s:5:\"IR-32\";s:5:\"label\";s:10:\"البرز\";s:10:\"is_checked\";b:0;}}");
INSERT INTO `wp_jet_post_types` VALUES("3", "representatives", "publish", "a:1:{s:4:\"name\";s:18:\"نمایندگان\";}", "a:24:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:14:\"custom_storage\";b:0;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:12:\"rewrite_slug\";s:15:\"representatives\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:-1;s:9:\"menu_icon\";s:25:\"dashicons-format-standard\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:7:\"excerpt\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:1:{i:0;a:17:{s:5:\"title\";s:23:\"انتخاب استان\";s:4:\"name\";s:8:\"province\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"select\";s:2:\"id\";i:6960;s:8:\"isNested\";b:0;s:14:\"options_source\";s:8:\"glossary\";s:11:\"glossary_id\";s:1:\"2\";s:18:\"check_radio_layout\";s:8:\"vertical\";s:11:\"placeholder\";s:52:\"استان مورد نظر انتخاب کنید ...\";s:9:\"min_input\";s:1:\"2\";s:11:\"is_required\";b:1;s:11:\"description\";s:68:\"این فیلد برای نمایش در نقشه ضروری است.\";s:12:\"show_in_rest\";b:1;}}");
INSERT INTO `wp_jet_post_types` VALUES("4", "price_list", "page", "a:2:{s:4:\"name\";s:17:\"لیست قیمت\";s:9:\"menu_name\";s:17:\"لیست قیمت\";}", "a:7:{s:6:\"parent\";s:0:\"\";s:4:\"icon\";s:19:\"dashicons-list-view\";s:10:\"capability\";s:14:\"manage_options\";s:8:\"position\";i:-1;s:12:\"storage_type\";s:7:\"default\";s:13:\"option_prefix\";b:0;s:16:\"hide_field_names\";b:0;}", "a:1:{i:0;a:14:{s:5:\"title\";s:24:\"آیتم های لیست\";s:4:\"name\";s:10:\"list_items\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:4:{i:0;a:5:{s:5:\"title\";s:8:\"نامک\";s:4:\"name\";s:4:\"slug\";s:4:\"type\";s:4:\"text\";s:14:\"options_source\";s:6:\"manual\";s:2:\"id\";i:7820;}i:1;a:5:{s:5:\"title\";s:19:\"عنوان آیتم\";s:4:\"name\";s:5:\"title\";s:4:\"type\";s:4:\"text\";s:14:\"options_source\";s:6:\"manual\";s:2:\"id\";i:9157;}i:2;a:6:{s:5:\"title\";s:17:\"قیمت آیتم\";s:4:\"name\";s:5:\"price\";s:4:\"type\";s:4:\"text\";s:14:\"options_source\";s:6:\"manual\";s:2:\"id\";i:5964;s:9:\"min_value\";s:1:\"0\";}i:3;a:8:{s:5:\"title\";s:19:\"مکان نمایش\";s:4:\"name\";s:10:\"show_place\";s:4:\"type\";s:8:\"checkbox\";s:14:\"options_source\";s:6:\"manual\";s:2:\"id\";i:1108;s:7:\"options\";a:3:{i:0;a:4:{s:3:\"key\";s:9:\"top-items\";s:5:\"value\";s:32:\"نمایش بالای جداول\";s:2:\"id\";i:5887;s:10:\"is_checked\";s:0:\"\";}i:1;a:3:{s:3:\"key\";s:11:\"right-table\";s:5:\"value\";s:24:\"جدول سمت راست\";s:2:\"id\";i:5618;}i:2;a:3:{s:3:\"key\";s:10:\"left-table\";s:5:\"value\";s:20:\"جدول سمت چپ\";s:2:\"id\";i:6934;}}s:11:\"placeholder\";s:70:\"لطفا مکان نمایش آِیتم را انتخاب کنید ...\";s:8:\"is_array\";b:1;}}s:4:\"type\";s:8:\"repeater\";s:2:\"id\";i:8097;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:18:\"repeater_collapsed\";b:1;s:20:\"repeater_title_field\";s:5:\"title\";s:11:\"is_required\";b:1;s:11:\"description\";s:0:\"\";}}");
INSERT INTO `wp_jet_post_types` VALUES("5", "business-partners", "publish", "a:14:{s:4:\"name\";s:21:\"شرکای تجاری\";s:13:\"singular_name\";s:19:\"شریک تجاری\";s:9:\"menu_name\";s:23:\"َشرکای تجاری\";s:14:\"name_admin_bar\";s:19:\"شریک تجاری\";s:7:\"add_new\";s:39:\"اضافه کردن شریک تجاری\";s:12:\"add_new_item\";s:39:\"اضافه کردن شریک تجاری\";s:8:\"new_item\";s:28:\"شریک تجاری جدید\";s:9:\"edit_item\";s:32:\"ویرایش شریک تجاری\";s:9:\"view_item\";s:32:\"مشاهده شریک تجاری\";s:9:\"all_items\";s:28:\"همه شرکای تجاری\";s:12:\"search_items\";s:41:\"جستجو برای شرکای تجاری\";s:9:\"not_found\";s:36:\"شریک تجاری یافت نشد!\";s:18:\"not_found_in_trash\";s:58:\"شریک تجاری در سطل زباله یافت نشد\";s:14:\"featured_image\";s:19:\"تصویر ویژه\";}", "a:24:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:12:\"map_meta_cap\";b:0;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:14:\"custom_storage\";b:0;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:12:\"rewrite_slug\";s:17:\"business-partners\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";i:-1;s:9:\"menu_icon\";s:22:\"dashicons-image-filter\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:7:\"excerpt\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:0:{}");
INSERT INTO `wp_jet_post_types` VALUES("6", NULL, "query", "a:1:{s:4:\"name\";s:13:\"popular_posts\";}", "a:19:{s:10:\"query_type\";s:5:\"posts\";s:5:\"posts\";a:6:{s:7:\"orderby\";a:1:{i:0;a:5:{s:3:\"_id\";i:22784;s:9:\"collapsed\";b:0;s:7:\"orderby\";s:14:\"meta_value_num\";s:8:\"meta_key\";s:10:\"post_views\";s:5:\"order\";s:4:\"DESC\";}}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:10:\"date_query\";a:0:{}s:9:\"post_type\";a:1:{i:0;s:4:\"post\";}s:11:\"post_status\";a:1:{i:0;s:7:\"publish\";}}s:15:\"__dynamic_posts\";a:3:{s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:10:\"date_query\";a:0:{}}s:12:\"show_preview\";b:0;s:11:\"cache_query\";b:1;s:12:\"api_endpoint\";b:0;s:16:\"avoid_duplicates\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;s:13:\"api_namespace\";N;s:8:\"api_path\";N;s:10:\"api_access\";N;s:14:\"api_access_cap\";N;s:15:\"api_access_role\";N;s:10:\"api_schema\";N;s:13:\"cache_expires\";N;}", "a:0:{}");

/* INSERT TABLE DATA: wp_jet_taxonomies */
INSERT INTO `wp_jet_taxonomies` VALUES("1", "products-category", "a:1:{i:0;s:8:\"products\";}", "publish", "a:1:{s:4:\"name\";s:32:\"دسته بندی محصولات\";}", "a:17:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:7:\"rewrite\";b:1;s:12:\"hierarchical\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:16:\"hide_field_names\";b:0;s:15:\"delete_metadata\";b:0;s:20:\"rewrite_hierarchical\";b:0;s:9:\"query_var\";s:0:\"\";s:12:\"rewrite_slug\";s:17:\"products-category\";s:15:\"capability_type\";s:0:\"\";s:11:\"description\";s:0:\"\";}", "a:1:{i:0;a:11:{s:5:\"title\";s:19:\"تصویر شاخص\";s:4:\"name\";s:5:\"image\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:5:\"media\";s:9:\"collapsed\";b:0;s:2:\"id\";i:4235;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";}}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:15:{i:1753599224;a:1:{s:19:\"litespeed_task_lqip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:16:\"litespeed_filter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:60;}}}i:1753602711;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1753631511;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753631532;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753631535;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753635110;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753636910;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753637280;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1753638710;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1753698600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1753730714;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1753890801;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1753977111;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1754069466;a:1:{s:26:\"wpcode_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://desing85.ir", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://desing85.ir", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "فروشگاه خرید عمده قطعات خودرو", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "alimashhadi910@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:228:{s:11:\"jsf/(.*)/?$\";s:25:\"index.php?jsf=$matches[1]\";s:52:\"([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/jsf/(.*)/?$\";s:96:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&jsf=$matches[5]\";s:41:\"([0-9]{4})/([0-9]{2})/([^/]+)/jsf/(.*)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&jsf=$matches[4]\";s:29:\"archives/([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:20:\"([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:19:\"(.?.+?)/jsf/(.*)/?$\";s:46:\"index.php?pagename=$matches[1]&jsf=$matches[2]\";s:19:\"([^/]+)/jsf/(.*)/?$\";s:42:\"index.php?name=$matches[1]&jsf=$matches[2]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:20:\"business-partners/?$\";s:37:\"index.php?post_type=business-partners\";s:50:\"business-partners/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=business-partners&feed=$matches[1]\";s:45:\"business-partners/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=business-partners&feed=$matches[1]\";s:37:\"business-partners/page/([0-9]{1,})/?$\";s:55:\"index.php?post_type=business-partners&paged=$matches[1]\";s:18:\"representatives/?$\";s:35:\"index.php?post_type=representatives\";s:48:\"representatives/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=representatives&feed=$matches[1]\";s:43:\"representatives/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=representatives&feed=$matches[1]\";s:35:\"representatives/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=representatives&paged=$matches[1]\";s:11:\"products/?$\";s:28:\"index.php?post_type=products\";s:41:\"products/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=products&feed=$matches[1]\";s:36:\"products/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=products&feed=$matches[1]\";s:28:\"products/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=products&paged=$matches[1]\";s:34:\"wpcode/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"wpcode/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"wpcode/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpcode/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpcode/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"wpcode/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"wpcode/([^/]+)/embed/?$\";s:39:\"index.php?wpcode=$matches[1]&embed=true\";s:27:\"wpcode/([^/]+)/trackback/?$\";s:33:\"index.php?wpcode=$matches[1]&tb=1\";s:35:\"wpcode/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?wpcode=$matches[1]&paged=$matches[2]\";s:42:\"wpcode/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?wpcode=$matches[1]&cpage=$matches[2]\";s:31:\"wpcode/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?wpcode=$matches[1]&page=$matches[2]\";s:23:\"wpcode/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"wpcode/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"wpcode/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"wpcode/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"wpcode/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"wpcode/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"wpcode_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_type=$matches[1]&feed=$matches[2]\";s:47:\"wpcode_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_type=$matches[1]&feed=$matches[2]\";s:28:\"wpcode_type/([^/]+)/embed/?$\";s:44:\"index.php?wpcode_type=$matches[1]&embed=true\";s:40:\"wpcode_type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wpcode_type=$matches[1]&paged=$matches[2]\";s:22:\"wpcode_type/([^/]+)/?$\";s:33:\"index.php?wpcode_type=$matches[1]\";s:56:\"wpcode_location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?wpcode_location=$matches[1]&feed=$matches[2]\";s:51:\"wpcode_location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?wpcode_location=$matches[1]&feed=$matches[2]\";s:32:\"wpcode_location/([^/]+)/embed/?$\";s:48:\"index.php?wpcode_location=$matches[1]&embed=true\";s:44:\"wpcode_location/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?wpcode_location=$matches[1]&paged=$matches[2]\";s:26:\"wpcode_location/([^/]+)/?$\";s:37:\"index.php?wpcode_location=$matches[1]\";s:52:\"wpcode_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_tags=$matches[1]&feed=$matches[2]\";s:47:\"wpcode_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_tags=$matches[1]&feed=$matches[2]\";s:28:\"wpcode_tags/([^/]+)/embed/?$\";s:44:\"index.php?wpcode_tags=$matches[1]&embed=true\";s:40:\"wpcode_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wpcode_tags=$matches[1]&paged=$matches[2]\";s:22:\"wpcode_tags/([^/]+)/?$\";s:33:\"index.php?wpcode_tags=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"products-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=products-category&term=$matches[1]&feed=$matches[2]\";s:53:\"products-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=products-category&term=$matches[1]&feed=$matches[2]\";s:34:\"products-category/([^/]+)/embed/?$\";s:64:\"index.php?taxonomy=products-category&term=$matches[1]&embed=true\";s:46:\"products-category/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?taxonomy=products-category&term=$matches[1]&paged=$matches[2]\";s:28:\"products-category/([^/]+)/?$\";s:53:\"index.php?taxonomy=products-category&term=$matches[1]\";s:45:\"business-partners/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"business-partners/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"business-partners/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"business-partners/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"business-partners/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"business-partners/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"business-partners/([^/]+)/embed/?$\";s:50:\"index.php?business-partners=$matches[1]&embed=true\";s:38:\"business-partners/([^/]+)/trackback/?$\";s:44:\"index.php?business-partners=$matches[1]&tb=1\";s:58:\"business-partners/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?business-partners=$matches[1]&feed=$matches[2]\";s:53:\"business-partners/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?business-partners=$matches[1]&feed=$matches[2]\";s:46:\"business-partners/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?business-partners=$matches[1]&paged=$matches[2]\";s:53:\"business-partners/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?business-partners=$matches[1]&cpage=$matches[2]\";s:42:\"business-partners/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?business-partners=$matches[1]&page=$matches[2]\";s:34:\"business-partners/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"business-partners/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"business-partners/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"business-partners/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"business-partners/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"business-partners/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"representatives/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"representatives/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"representatives/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"representatives/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"representatives/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"representatives/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"representatives/([^/]+)/embed/?$\";s:48:\"index.php?representatives=$matches[1]&embed=true\";s:36:\"representatives/([^/]+)/trackback/?$\";s:42:\"index.php?representatives=$matches[1]&tb=1\";s:56:\"representatives/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?representatives=$matches[1]&feed=$matches[2]\";s:51:\"representatives/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?representatives=$matches[1]&feed=$matches[2]\";s:44:\"representatives/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?representatives=$matches[1]&paged=$matches[2]\";s:51:\"representatives/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?representatives=$matches[1]&cpage=$matches[2]\";s:40:\"representatives/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?representatives=$matches[1]&page=$matches[2]\";s:32:\"representatives/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"representatives/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"representatives/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"representatives/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"representatives/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"representatives/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"products/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"products/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"products/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"products/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"products/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"products/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"products/([^/]+)/embed/?$\";s:41:\"index.php?products=$matches[1]&embed=true\";s:29:\"products/([^/]+)/trackback/?$\";s:35:\"index.php?products=$matches[1]&tb=1\";s:49:\"products/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?products=$matches[1]&feed=$matches[2]\";s:44:\"products/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?products=$matches[1]&feed=$matches[2]\";s:37:\"products/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?products=$matches[1]&paged=$matches[2]\";s:44:\"products/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?products=$matches[1]&cpage=$matches[2]\";s:33:\"products/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?products=$matches[1]&page=$matches[2]\";s:25:\"products/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"products/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"products/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"products/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"products/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"products/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=434&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:13:{i:0;s:33:\"classic-editor/classic-editor.php\";i:1;s:32:\"duplicate-page/duplicatepage.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:31:\"elementor-pro/elementor-pro.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:38:\"flexy-breadcrumb2/flexy-breadcrumb.php\";i:6;s:36:\"insert-headers-and-footers2/ihaf.php\";i:7;s:26:\"jet-engine2/jet-engine.php\";i:8;s:40:\"jet-smart-filters2/jet-smart-filters.php\";i:9;s:35:\"litespeed-cache/litespeed-cache.php\";i:10;s:22:\"negarara2/negarara.php\";i:11;s:28:\"svg-support2/svg-support.php\";i:13;s:30:\"wp-parsidate2/wp-parsidate.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "hello-elementor", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "hello-elementor", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "blank", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "3", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:27:\"wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "434", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "661", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1763394710", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:71:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:20:\"wpcode_edit_snippets\";b:1;s:24:\"wpcode_activate_snippets\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("126", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("127", "theme_mods_twentytwentyfive", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1747842951;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("128", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"e4db2e247eccf33a2af3e11c37e80bd8\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("154", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("155", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("158", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("160", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("174", "current_theme", "Hello Elementor", "auto");
INSERT INTO `wp_options` VALUES("175", "theme_mods_hello-elementor", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1747842945;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:609;}", "on");
INSERT INTO `wp_options` VALUES("176", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("177", "hello_theme_version", "3.4.2", "auto");
INSERT INTO `wp_options` VALUES("180", "elementor_connect_site_key", "982fb5d9ca79b454c06cbe058beb0053", "auto");
INSERT INTO `wp_options` VALUES("181", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1753642201;s:5:\"value\";s:7532:\"[{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("204", "elementor_active_kit", "6", "auto");
INSERT INTO `wp_options` VALUES("205", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("208", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("209", "elementor_version", "3.29.2", "auto");
INSERT INTO `wp_options` VALUES("210", "elementor_install_history", "a:2:{s:6:\"3.29.0\";i:1747843144;s:6:\"3.29.2\";i:1751269136;}", "auto");
INSERT INTO `wp_options` VALUES("211", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("213", "elementor_checklist", "{\"last_opened_timestamp\":1747843980,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}", "auto");
INSERT INTO `wp_options` VALUES("214", "elementor_onboarded", "1", "auto");
INSERT INTO `wp_options` VALUES("215", "_elementor_installed_time", "1747843156", "auto");
INSERT INTO `wp_options` VALUES("216", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("217", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:100:\"Introducing Elementor 3.30: new Editor V4 capabilities, full Website Templates in the cloud, & more!\";s:7:\"excerpt\";s:361:\"Elementor 3.30 is here and it includes upgrades that accelerate your workflow, bring you a step closer to the full power of Editor V4, and help you deliver beautiful, accessible websites faster than ever. From advanced styling tools and smarter editing to full Website Templates in the cloud, this release enhances both the way you design and the way you scale.\";s:7:\"created\";i:1751974442;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-330-v4-alpha-website-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:57:\"Introducing Cloud Templates: your personal design library\";s:7:\"excerpt\";s:153:\"Transform your workflow with Elementor\'s new Cloud Templates – create, save, and access your templates across all your websites with just a few clicks.\";s:7:\"created\";i:1749048239;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:127:\"https://elementor.com/blog/introducing-cloud-templates/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:74:\"Introducing Editor V4 Alpha: The Future of Website Building with Elementor\";s:7:\"excerpt\";s:242:\"Editor V4 Alpha introduces a CSS-first framework with reusable Classes and States, improved performance, a unified styling system, and fully responsive style controls—all designed to make your website building more efficient and consistent.\";s:7:\"created\";i:1748357309;s:5:\"badge\";s:4:\" NEW\";s:3:\"url\";s:119:\"https://elementor.com/blog/editor-v4-1st-alpha/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("222", "elementor_pro_license_key", "activated", "auto");
INSERT INTO `wp_options` VALUES("223", "_elementor_pro_license_v2_data", "a:2:{s:7:\"timeout\";i:1751014798;s:5:\"value\";s:71:\"{\"success\":true,\"license\":\"valid\",\"expires\":\"01.01.2030\",\"features\":[]}\";}", "auto");
INSERT INTO `wp_options` VALUES("224", "elementor_pro_version", "3.29.2", "auto");
INSERT INTO `wp_options` VALUES("225", "elementor_pro_install_history", "a:3:{s:6:\"3.26.2\";i:1747843238;s:6:\"3.28.4\";i:1747843259;s:6:\"3.29.2\";i:1750960109;}", "auto");
INSERT INTO `wp_options` VALUES("226", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("227", "_elementor_pro_installed_time", "1747843238", "auto");
INSERT INTO `wp_options` VALUES("228", "elementor_submissions_db_version", "5", "auto");
INSERT INTO `wp_options` VALUES("229", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1753598995;}", "auto");
INSERT INTO `wp_options` VALUES("233", "elementor_log", "a:28:{s:32:\"1f51d3b78e3565835056b25635cb813a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-21 19:30:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-21 19:30:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"024368ac0dc812af28fc99453edb73ec\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-21 19:30:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-21 19:30:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"478243f7936ab926c160e24d638d39fd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-21 19:30:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-21 19:30:59\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e4dac01ac4ce06613a6a30df1b054649\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-21 19:30:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-21 19:30:59\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a4b8ae222ed79f6ade7649495443b295\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-21 19:30:59\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-21 19:30:59\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.26.2\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"1a48d9e9962fdab7a00bd435a4e1ad19\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:83:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:113;s:7:\"\0*\0date\";s:19:\"2025-05-21 19:43:16\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:5;s:14:\"\0*\0times_dates\";a:5:{i:0;s:19:\"2025-05-21 19:43:16\";i:1;s:19:\"2025-05-21 19:43:25\";i:2;s:19:\"2025-05-21 20:00:01\";i:3;s:19:\"2025-05-21 20:11:37\";i:4;s:19:\"2025-05-21 20:12:33\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:83:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:113;s:5:\"trace\";b:1;}}s:32:\"f3926008caad789235bd907e6c7a4743\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:93:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:7:\"\0*\0line\";i:363;s:7:\"\0*\0date\";s:19:\"2025-05-21 20:00:35\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: editor_post_id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:10;s:14:\"\0*\0times_dates\";a:10:{i:0;s:19:\"2025-05-21 20:00:35\";i:1;s:19:\"2025-05-21 21:04:56\";i:2;s:19:\"2025-05-21 22:20:30\";i:3;s:19:\"2025-06-12 14:24:01\";i:4;s:19:\"2025-06-14 10:50:01\";i:5;s:19:\"2025-06-14 19:20:37\";i:6;s:19:\"2025-06-14 23:23:18\";i:7;s:19:\"2025-06-14 23:30:28\";i:8;s:19:\"2025-06-26 11:51:52\";i:9;s:19:\"2025-06-27 18:59:50\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: editor_post_id\";s:4:\"file\";s:93:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:4:\"line\";i:363;s:5:\"trace\";b:1;}}s:32:\"58fb37337126433428b9342b4ff6938d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"28760\";s:7:\"\0*\0file\";s:129:\"https://desing85.ir/wp-admin/load-scripts.php?c=0&amp;loadchunk_0=jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.8.1\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-05-21 18:44:47\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of undefined (reading &#039;value&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:21;s:14:\"\0*\0times_dates\";a:21:{i:0;s:19:\"2025-05-21 18:44:47\";i:1;s:19:\"2025-06-06 15:01:02\";i:2;s:19:\"2025-06-06 15:04:38\";i:3;s:19:\"2025-06-06 15:17:04\";i:4;s:19:\"2025-06-06 15:17:12\";i:5;s:19:\"2025-06-06 17:34:51\";i:6;s:19:\"2025-06-06 17:35:08\";i:7;s:19:\"2025-06-09 07:06:07\";i:8;s:19:\"2025-06-09 07:45:46\";i:9;s:19:\"2025-06-09 07:45:53\";i:10;s:19:\"2025-06-09 15:20:43\";i:11;s:19:\"2025-06-09 15:20:51\";i:12;s:19:\"2025-06-09 17:22:57\";i:13;s:19:\"2025-06-09 17:23:05\";i:14;s:19:\"2025-06-10 14:45:16\";i:15;s:19:\"2025-06-10 14:45:23\";i:16;s:19:\"2025-06-15 18:55:46\";i:17;s:19:\"2025-06-15 18:55:55\";i:18;s:19:\"2025-06-27 04:20:03\";i:19;s:19:\"2025-06-27 06:37:03\";i:20;s:19:\"2025-06-27 06:37:10\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1747853087\";s:7:\"message\";s:53:\"Cannot read properties of undefined (reading \'value\')\";s:3:\"url\";s:129:\"https://desing85.ir/wp-admin/load-scripts.php?c=0&amp;loadchunk_0=jquery-core,jquery-migrate,utils,moxiejs,plupload&amp;ver=6.8.1\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"28760\";}}s:32:\"5233349576763ba60bdfa2d85fb96534\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:98:\"/home/heqcbspg/public_html/wp-content/plugins/elementor-pro/modules/forms/classes/ajax-handler.php\";s:7:\"\0*\0line\";i:76;s:7:\"\0*\0date\";s:19:\"2025-06-09 22:27:57\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:24:\"Undefined index: form_id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-09 22:27:57\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:24:\"Undefined index: form_id\";s:4:\"file\";s:98:\"/home/heqcbspg/public_html/wp-content/plugins/elementor-pro/modules/forms/classes/ajax-handler.php\";s:4:\"line\";i:76;s:5:\"trace\";b:1;}}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"886171\";s:7:\"\0*\0file\";s:83:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.0\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-06-10 18:27:37\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:21;s:14:\"\0*\0times_dates\";a:21:{i:0;s:19:\"2025-06-10 18:27:37\";i:1;s:19:\"2025-06-10 18:27:37\";i:2;s:19:\"2025-06-10 18:27:37\";i:3;s:19:\"2025-06-10 18:27:38\";i:4;s:19:\"2025-06-10 18:35:11\";i:5;s:19:\"2025-06-10 18:35:11\";i:6;s:19:\"2025-06-10 18:35:12\";i:7;s:19:\"2025-06-10 18:35:12\";i:8;s:19:\"2025-06-10 18:35:12\";i:9;s:19:\"2025-06-10 18:35:12\";i:10;s:19:\"2025-06-10 18:35:12\";i:11;s:19:\"2025-06-10 18:35:13\";i:12;s:19:\"2025-06-27 08:25:05\";i:13;s:19:\"2025-06-27 08:25:05\";i:14;s:19:\"2025-06-27 14:46:36\";i:15;s:19:\"2025-06-27 14:46:38\";i:16;s:19:\"2025-06-27 14:46:38\";i:17;s:19:\"2025-06-27 14:46:38\";i:18;s:19:\"2025-06-27 14:46:38\";i:19;s:19:\"2025-06-27 14:46:38\";i:20;s:19:\"2025-06-27 14:46:39\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1749580057\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:83:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.0\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"886171\";}}s:32:\"9a265cd7ec074eda7c026c6297c590e1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"885664\";s:7:\"\0*\0file\";s:83:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.0\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-06-11 14:55:03\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:69:\"Cannot read properties of undefined (reading &#039;toLowerCase&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-06-11 14:55:03\";i:1;s:19:\"2025-06-27 08:40:49\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1749653703\";s:7:\"message\";s:59:\"Cannot read properties of undefined (reading \'toLowerCase\')\";s:3:\"url\";s:83:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.29.0\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"885664\";}}s:32:\"a3fb41180c189b77f11971180fe4b77d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:103:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php\";s:7:\"\0*\0line\";i:30;s:7:\"\0*\0date\";s:19:\"2025-06-13 23:09:38\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1033:\"Uncaught TypeError: Argument 1 passed to Elementor\\Modules\\Home\\Transformations\\Filter_Plugins::get_add_ons_installation_status() must be of the type array, null given, called in /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php on line 21 and defined in /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php:30\nStack trace:\n#0 /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php(21): Elementor\\Modules\\Home\\Transformations\\Filter_Plugins-&gt;get_add_ons_installation_status(NULL)\n#1 /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/classes/transformations-manager.php(57): Elementor\\Modules\\Home\\Transformations\\Filter_Plugins-&gt;transform(Array)\n#2 /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/api.php(25): Elementor\\Modules\\Home\\Classes\\Transformations_Manager-&gt;run_transformations()\n#3 /home/heqcbspg/public_html/wp-content/p\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-06-13 23:09:38\";i:1;s:19:\"2025-06-13 23:09:45\";i:2;s:19:\"2025-06-13 23:09:48\";i:3;s:19:\"2025-06-14 22:14:24\";i:4;s:19:\"2025-06-15 22:12:36\";i:5;s:19:\"2025-06-26 11:27:23\";i:6;s:19:\"2025-06-26 12:50:42\";i:7;s:19:\"2025-06-26 18:34:56\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:1024:\"Uncaught TypeError: Argument 1 passed to Elementor\\Modules\\Home\\Transformations\\Filter_Plugins::get_add_ons_installation_status() must be of the type array, null given, called in /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php on line 21 and defined in /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php:30\nStack trace:\n#0 /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php(21): Elementor\\Modules\\Home\\Transformations\\Filter_Plugins->get_add_ons_installation_status(NULL)\n#1 /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/classes/transformations-manager.php(57): Elementor\\Modules\\Home\\Transformations\\Filter_Plugins->transform(Array)\n#2 /home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/api.php(25): Elementor\\Modules\\Home\\Classes\\Transformations_Manager->run_transformations()\n#3 /home/heqcbspg/public_html/wp-content/p\";s:4:\"file\";s:103:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/modules/home/transformations/filter-plugins.php\";s:4:\"line\";i:30;s:5:\"trace\";b:1;}}s:32:\"13297aebef0a19fe74a5e4fe2e839171\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:74:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/includes/embed.php\";s:7:\"\0*\0line\";i:186;s:7:\"\0*\0date\";s:19:\"2025-06-14 10:12:15\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type null\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-06-14 10:12:15\";i:1;s:19:\"2025-06-14 10:12:19\";i:2;s:19:\"2025-06-14 10:12:23\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type null\";s:4:\"file\";s:74:\"/home/heqcbspg/public_html/wp-content/plugins/elementor/includes/embed.php\";s:4:\"line\";i:186;s:5:\"trace\";b:1;}}s:32:\"1d4fb5814e80d65c6058c6f92b4d57bd\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:84:\"/home/heqcbspg/public_html/wp-content/plugins/elementor-pro/modules/popup/module.php\";s:7:\"\0*\0line\";i:188;s:7:\"\0*\0date\";s:19:\"2025-06-14 19:52:24\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:1000:\"Uncaught Error: Call to undefined method Elementor\\Core\\Kits\\Documents\\Kit::save_display_settings_data() in /home/heqcbspg/public_html/wp-content/plugins/elementor-pro/modules/popup/module.php:188\nStack trace:\n#0 [internal function]: ElementorPro\\Modules\\Popup\\Module-&gt;save_display_settings(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#1 /home/heqcbspg/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php(176): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /home/heqcbspg/public_html/wp-includes/class-wp-hook.php(324): Elementor\\Core\\Common\\Modules\\Ajax\\Module-&gt;handle_ajax_request(&#039;&#039;)\n#3 /home/heqcbspg/public_html/wp-includes/class-wp-hook.php(348): WP_Hook-&gt;apply_filters(&#039;&#039;, Array)\n#4 /home/heqcbspg/public_html/wp-includes/plugin.php(517): WP_Hook-&gt;do_action(Array)\n#5 /home/heqcbspg/public_html/wp-admin/admin-ajax.php(192): do_action(&#039;wp_ajax_element...&#039;)\n#6 {main}\n  thrown\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-14 19:52:24\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:5:\"error\";s:7:\"message\";s:958:\"Uncaught Error: Call to undefined method Elementor\\Core\\Kits\\Documents\\Kit::save_display_settings_data() in /home/heqcbspg/public_html/wp-content/plugins/elementor-pro/modules/popup/module.php:188\nStack trace:\n#0 [internal function]: ElementorPro\\Modules\\Popup\\Module->save_display_settings(Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#1 /home/heqcbspg/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php(176): call_user_func(Array, Array, Object(Elementor\\Core\\Common\\Modules\\Ajax\\Module))\n#2 /home/heqcbspg/public_html/wp-includes/class-wp-hook.php(324): Elementor\\Core\\Common\\Modules\\Ajax\\Module->handle_ajax_request(\'\')\n#3 /home/heqcbspg/public_html/wp-includes/class-wp-hook.php(348): WP_Hook->apply_filters(\'\', Array)\n#4 /home/heqcbspg/public_html/wp-includes/plugin.php(517): WP_Hook->do_action(Array)\n#5 /home/heqcbspg/public_html/wp-admin/admin-ajax.php(192): do_action(\'wp_ajax_element...\')\n#6 {main}\n  thrown\";s:4:\"file\";s:84:\"/home/heqcbspg/public_html/wp-content/plugins/elementor-pro/modules/popup/module.php\";s:4:\"line\";i:188;s:5:\"trace\";b:1;}}s:32:\"862b354848f8cbd976eeac5356ce0394\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:4:\"7612\";s:7:\"\0*\0file\";s:93:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/3ac06e8b9c2e8f04c57d.bundle.min.js\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-06-14 20:51:22\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:60:\"Cannot read properties of null (reading &#039;dataset&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-06-14 20:51:22\";i:1;s:19:\"2025-06-14 20:51:24\";i:2;s:19:\"2025-06-27 08:41:06\";i:3;s:19:\"2025-06-27 08:41:08\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1749934282\";s:7:\"message\";s:50:\"Cannot read properties of null (reading \'dataset\')\";s:3:\"url\";s:93:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/3ac06e8b9c2e8f04c57d.bundle.min.js\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:4:\"7612\";}}s:32:\"d53501bd385b1cce2c35af4b88603a79\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"68374\";s:7:\"\0*\0file\";s:87:\"https://desing85.ir/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=3.28.4\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-06-15 20:38:52\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:42:\"Cannot convert undefined or null to object\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-06-15 20:38:52\";i:1;s:19:\"2025-06-15 20:39:31\";i:2;s:19:\"2025-06-15 20:40:00\";i:3;s:19:\"2025-06-15 20:40:36\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1750019932\";s:7:\"message\";s:42:\"Cannot convert undefined or null to object\";s:3:\"url\";s:87:\"https://desing85.ir/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=3.28.4\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"68374\";}}s:32:\"7429493758b3bdf000438aac4d3c9b49\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"63978\";s:7:\"\0*\0file\";s:91:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.29.0\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-06-26 07:55:25\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:24:\"elementor is not defined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-06-26 07:55:25\";i:1;s:19:\"2025-06-27 04:20:44\";i:2;s:19:\"2025-06-27 04:21:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1750924525\";s:7:\"message\";s:24:\"elementor is not defined\";s:3:\"url\";s:91:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/common-modules.min.js?ver=3.29.0\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"63978\";}}s:32:\"2ab4ce66bb60b99b8eb6c727cc27e84c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-26 21:18:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-26 21:18:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"a185306d4591ca903d86bdf110f1cfbd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-26 21:18:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-26 21:18:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"837685407b18661cf6a36983c399946e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-26 21:18:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-26 21:18:29\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"14e2b7f7cab5f25648319862f0552cd2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-26 21:18:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-26 21:18:29\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fa88271293bde3fcb303b7ea380af19d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-26 21:18:29\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-26 21:18:29\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f91b81c6d584233495709706d317920f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"22022\";s:7:\"\0*\0file\";s:91:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.29.0\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-06-27 12:01:39\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;cid&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-27 12:01:39\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1751025699\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'cid\')\";s:3:\"url\";s:91:\"https://desing85.ir/wp-content/plugins/elementor/assets/js/editor-modules.min.js?ver=3.29.0\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:5:\"22022\";}}s:32:\"d03d92197ae7d29f2b10fb184e6c8c65\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-30 11:08:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-30 11:08:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"52c462b84f455ce9b86f5153821093c2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-30 11:08:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-30 11:08:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3a65d9eda2c15d4e88bb9226cf95bf28\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-30 11:08:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-30 11:08:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"36da697c62b5fbc847a2ac88cd4cc7c3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-30 11:08:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-30 11:08:56\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b2996b2c8b35695b5809bddd3154afa9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-30 11:08:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-30 11:08:56\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.29.0\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("240", "jet-license-data", "a:1:{s:12:\"license-list\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("249", "elementor_pro_theme_builder_conditions", "a:7:{s:7:\"archive\";a:6:{i:1673;a:1:{i:0;s:22:\"include/archive/search\";}i:1633;a:1:{i:0;s:28:\"include/archive/post_archive\";}i:1284;a:1:{i:0;s:24:\"include/archive/category\";}i:1241;a:1:{i:0;s:39:\"include/archive/representatives_archive\";}i:868;a:1:{i:0;s:41:\"include/archive/business-partners_archive\";}i:639;a:2:{i:0;s:33:\"include/archive/products-category\";i:1;s:32:\"include/archive/products_archive\";}}s:14:\"elementor_head\";a:2:{i:1570;a:1:{i:0;s:15:\"include/general\";}i:553;a:1:{i:0;s:25:\"include/singular/page/434\";}}s:6:\"single\";a:3:{i:1363;a:1:{i:0;s:21:\"include/singular/post\";}i:850;a:1:{i:0;s:34:\"include/singular/business-partners\";}i:750;a:1:{i:0;s:25:\"include/singular/products\";}}s:6:\"footer\";a:1:{i:646;a:1:{i:0;s:15:\"include/general\";}}s:18:\"elementor_body_end\";a:1:{i:196;a:2:{i:0;s:23:\"include/singular/page/9\";i:1;s:25:\"include/singular/page/434\";}}s:20:\"elementor_body_start\";a:1:{i:195;a:2:{i:0;s:23:\"include/singular/page/9\";i:1;s:25:\"include/singular/page/434\";}}s:6:\"header\";a:1:{i:23;a:1:{i:0;s:15:\"include/general\";}}}", "auto");
INSERT INTO `wp_options` VALUES("250", "elementor_fonts_manager_font_types", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("251", "elementor_fonts_manager_fonts", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("252", "elementor_custom_icon_sets_config", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("253", "_elementor_local_google_fonts", "a:3:{s:6:\"roboto\";a:2:{s:3:\"url\";s:76:\"https://desing85.ir/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1747843755;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:80:\"https://desing85.ir/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1747843776;}s:9:\"vazirmatn\";a:2:{s:3:\"url\";s:79:\"https://desing85.ir/wp-content/uploads/elementor/google-fonts/css/vazirmatn.css\";s:7:\"version\";i:1747844620;}}", "auto");
INSERT INTO `wp_options` VALUES("254", "e_editor_counter", "296", "auto");
INSERT INTO `wp_options` VALUES("255", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1751657008;s:5:\"value\";s:12765:\"[{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"send-notification-june\",\"title\":\"A whole new onboarding experience\",\"description\":\"Try the new onboarding now: Launch abandoned cart recovery, welcome flows & more in minutes. No setup stress\\u2014just smarter automation from day one.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-june.png\",\"chipTags\":[\"New Features\"],\"cta\":\"Check Out\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/New_June\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"classes-3.29\",\"title\":\"Classes: Style Once, Apply Everywhere\",\"description\":\"Create Classes to define styling patterns once and apply them across your entire site with a single click. Add States for stunning hover and focus effects\\u2014no coding needed!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"style-tab-3.29\",\"title\":\"Consistent Styling Everywhere\",\"description\":\"Every V4 element shares the same styling capabilities in the same logical order and location. Plus, we\'ve streamlined from 3 tabs to just 2\\u2014content in one, styling in the other!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-style-tab.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"responsive-3.29\",\"title\":\"Fully Responsive Design\",\"description\":\"With Editor V4, every single style property can be customized per device. Complete creative control for desktop, tablet, and mobile!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-responsive.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-connect\",\"title\":\"More Integrations, More Impact\",\"description\":\"Discover Send\\u2019s new features: Behavior-based triggers, win-back email campaigns, expanded form integrations, and more! Explore how marketing automation features can boost your store.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/send-connect.png\",\"chipTags\":[\"New Features\"],\"cta\":\"Check Out\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/newmay\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"performance-3.29\",\"title\":\"Blazing fast performance\",\"description\":\"In Editor V4, each element uses one clean div instead of multiple nested divs like in the current version\\u2014your sites will load lightning-fast with cleaner code!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/v4-performance.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-editor-v4\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"grid-span-3.27\",\"title\":\"Design Grid layouts that fit your exact vision\",\"description\":\"Advanced column and row span controls give you the power to design Grid Container layouts that fit your exact vision.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/grid-span-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-grid-span-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"local-fonts-3.27\",\"title\":\"Load Google Fonts safer and faster\",\"description\":\"Once enabled, Google Fonts are served directly from your server, streamlining the loading process and enhancing security.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/local-google-fonts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-local-fonts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"video-shorts-3.27\",\"title\":\"Showcase short-form, vertical videos\",\"description\":\"The Video widget now supports YouTube Shorts in a vertical 9:16 ratio, the go-to format for engaging audiences.\",\"topic\":\"Elementor 3.27\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/video-shorts-3.27.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.27-video-shorts-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"dynamic-off-canvas-3.26\",\"title\":\"Dynamic Off-Canvas for Loop Grids\",\"description\":\"Create richer, more interactive designs by linking Dynamic Content to the Off Canvas widget, delivering seamless user experiences.\",\"topic\":\"Elementor Pro 3.26\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas-loop-grids.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.26-loop-off-canvas\\/\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("260", "_transient_timeout__elementor_ab_test_plg_site_mailer_submission", "1755619736", "off");
INSERT INTO `wp_options` VALUES("261", "_transient__elementor_ab_test_plg_site_mailer_submission", "1", "off");
INSERT INTO `wp_options` VALUES("289", "bodhi_svgs_settings", "a:3:{s:22:\"sanitize_svg_front_end\";s:2:\"on\";s:8:\"restrict\";a:1:{i:0;s:13:\"administrator\";}s:24:\"sanitize_on_upload_roles\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("290", "bodhi_svgs_plugin_version", "2.5.14", "auto");
INSERT INTO `wp_options` VALUES("292", "elementor_unfiltered_files_upload", "1", "auto");
INSERT INTO `wp_options` VALUES("295", "site_logo", "609", "auto");
INSERT INTO `wp_options` VALUES("298", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("299", "elementor_library_category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("322", "negarara_delete_original", "1", "auto");
INSERT INTO `wp_options` VALUES("323", "negarara_formats", "a:3:{i:0;s:4:\"jpeg\";i:1;s:3:\"jpg\";i:2;s:3:\"png\";}", "auto");
INSERT INTO `wp_options` VALUES("331", "jet_engine_set_entry_types", "1", "off");
INSERT INTO `wp_options` VALUES("337", "negarara_quality", "80", "auto");
INSERT INTO `wp_options` VALUES("373", "duplicate_post_show_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("374", "duplicate_post_copytitle", "1", "auto");
INSERT INTO `wp_options` VALUES("375", "duplicate_post_copydate", "0", "auto");
INSERT INTO `wp_options` VALUES("376", "duplicate_post_copystatus", "0", "auto");
INSERT INTO `wp_options` VALUES("377", "duplicate_post_copyslug", "0", "auto");
INSERT INTO `wp_options` VALUES("378", "duplicate_post_copyexcerpt", "1", "auto");
INSERT INTO `wp_options` VALUES("379", "duplicate_post_copycontent", "1", "auto");
INSERT INTO `wp_options` VALUES("380", "duplicate_post_copythumbnail", "1", "auto");
INSERT INTO `wp_options` VALUES("381", "duplicate_post_copytemplate", "1", "auto");
INSERT INTO `wp_options` VALUES("382", "duplicate_post_copyformat", "1", "auto");
INSERT INTO `wp_options` VALUES("383", "duplicate_post_copyauthor", "0", "auto");
INSERT INTO `wp_options` VALUES("384", "duplicate_post_copypassword", "0", "auto");
INSERT INTO `wp_options` VALUES("385", "duplicate_post_copyattachments", "0", "auto");
INSERT INTO `wp_options` VALUES("386", "duplicate_post_copychildren", "0", "auto");
INSERT INTO `wp_options` VALUES("387", "duplicate_post_copycomments", "0", "auto");
INSERT INTO `wp_options` VALUES("388", "duplicate_post_copymenuorder", "1", "auto");
INSERT INTO `wp_options` VALUES("389", "duplicate_post_taxonomies_blacklist", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("390", "duplicate_post_blacklist", "", "auto");
INSERT INTO `wp_options` VALUES("391", "duplicate_post_types_enabled", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "auto");
INSERT INTO `wp_options` VALUES("392", "duplicate_post_show_original_column", "0", "auto");
INSERT INTO `wp_options` VALUES("393", "duplicate_post_show_original_in_post_states", "0", "auto");
INSERT INTO `wp_options` VALUES("394", "duplicate_post_show_original_meta_box", "0", "auto");
INSERT INTO `wp_options` VALUES("395", "duplicate_post_show_link", "a:3:{s:9:\"new_draft\";s:1:\"1\";s:5:\"clone\";s:1:\"1\";s:17:\"rewrite_republish\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("396", "duplicate_post_show_link_in", "a:4:{s:3:\"row\";s:1:\"1\";s:8:\"adminbar\";s:1:\"1\";s:9:\"submitbox\";s:1:\"1\";s:11:\"bulkactions\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("397", "duplicate_post_version", "4.5", "auto");
INSERT INTO `wp_options` VALUES("425", "duplicate_page_options", "a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}", "auto");
INSERT INTO `wp_options` VALUES("456", "code_snippets_version", "3.6.8", "auto");
INSERT INTO `wp_options` VALUES("457", "code_snippets_settings", "a:2:{s:7:\"general\";a:8:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:18:\"visual_editor_rows\";i:5;s:10:\"list_order\";s:12:\"priority-asc\";s:13:\"disable_prism\";b:0;s:17:\"hide_upgrade_menu\";b:0;s:18:\"complete_uninstall\";b:0;}s:6:\"editor\";a:11:{s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:10:\"wrap_lines\";b:1;s:12:\"code_folding\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;s:6:\"keymap\";s:7:\"default\";s:5:\"theme\";s:7:\"default\";}}", "auto");
INSERT INTO `wp_options` VALUES("460", "recently_activated_snippets", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("478", "wpcode_usage_tracking_config", "a:6:{s:3:\"day\";i:5;s:4:\"hour\";i:17;s:6:\"minute\";i:31;s:6:\"second\";i:6;s:6:\"offset\";i:495066;s:8:\"initsend\";i:1748626266;}", "off");
INSERT INTO `wp_options` VALUES("479", "ihaf_activated", "a:2:{s:6:\"wpcode\";i:1747858659;s:7:\"version\";s:5:\"2.2.8\";}", "auto");
INSERT INTO `wp_options` VALUES("481", "wpcode_snippets", "a:1:{s:10:\"everywhere\";a:8:{i:0;a:14:{s:2:\"id\";i:1322;s:5:\"title\";s:9:\"Post View\";s:4:\"code\";s:400:\"function set_post_views($postID) {\r\n    $key = \'post_views\';\r\n    $views = get_post_meta($postID, $key, true);\r\n    $views = $views == \'\' ? 0 : $views;\r\n    $views++;\r\n    update_post_meta($postID, $key, $views);\r\n}\r\n\r\nfunction track_post_views($post) {\r\n    if (is_single()) {\r\n        $post_id = get_the_ID();\r\n        set_post_views($post_id);\r\n    }\r\n}\r\nadd_action(\'wp_head\', \'track_post_views\');\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-26 13:04:39\";}i:1;a:14:{s:2:\"id\";i:1277;s:5:\"title\";s:19:\"PriceList ShortCode\";s:4:\"code\";s:13609:\"function price_list_shortcode($atts) {\r\n    ob_start();\r\n    ?>\r\n\r\n<style>\r\n    .price-list {\r\n		font-family:\"vazirmatn\";\r\n        position: relative;\r\n		width:100%;\r\n    }\r\n\r\n    .price-list-item {\r\n        position: relative;\r\n    }\r\n\r\n    .price-list .list-error {\r\n        position: absolute;\r\n        display: flex;\r\n        justify-content: center;\r\n        align-items: center;\r\n        left: 0;\r\n        top: 0;\r\n        width: 100%;\r\n        height: 100%;\r\n        background-color: #e4e4e4;\r\n        border-radius: 20px;\r\n        gap: 10px;\r\n        color: #616161;\r\n        opacity: 0;\r\n        visibility: hidden;\r\n        transition: 0.5s;\r\n    }\r\n\r\n    .price-list .important-price-list {\r\n        width: 100%;\r\n        display: flex;\r\n        flex-wrap: wrap;\r\n        gap: 40px 20px;\r\n        justify-content: space-between;\r\n    }\r\n\r\n    .price-list .price-item {\r\n        width: 215px;\r\n        background-color: white;\r\n        border-radius: 10px;\r\n        box-shadow: 2px 2px 45px 0px #00000012;\r\n    }\r\n\r\n    .price-list .price-item ul {\r\n        list-style-type: none;\r\n        margin: 0;\r\n        padding: 0;\r\n    }\r\n\r\n    .price-list .price-item .title {\r\n        display: flex;\r\n        justify-content: center;\r\n        align-items: center;\r\n        gap: 10px;\r\n        background-color: #f0f0f0;\r\n        padding: 10px;\r\n        font-size: 18px;\r\n        font-weight: 500;\r\n    }\r\n	\r\n	\r\n\r\n    .price-list .price-item .current-price {\r\n        padding: 15px;\r\n        display: flex;\r\n        justify-content: center;\r\n    }\r\n\r\n    .price-list .price-item .changed-price,\r\n    .price-list .price-item .low-price,\r\n    .price-list .price-item .high-price {\r\n        display: flex;\r\n        justify-content: space-between;\r\n        padding: 10px;\r\n        border-top: 1px solid #D9D9D9\r\n    }\r\n\r\n    .pi-icon.up path {\r\n        stroke: #2EAB3C;\r\n    }\r\n\r\n    .pi-icon.down path {\r\n        stroke: #BE3D26;\r\n        rotate: 180;\r\n    }\r\n\r\n    .pi-icon.neutral {\r\n        display: none;\r\n    }\r\n\r\n    .skeleton-box {\r\n        width: 215px;\r\n        height: 245px;\r\n        border-radius: 10px;\r\n        position: relative;\r\n        overflow: hidden;\r\n        animation: skeleton-loading 3s linear infinite alternate;\r\n    }\r\n\r\n\r\n    @keyframes skeleton-loading {\r\n        0% {\r\n            background-color: #e6e5e5\r\n        }\r\n\r\n        100% {\r\n            background-color: hsl(0, 0%, 80%);\r\n        }\r\n    }\r\n\r\n    .price-list.has-error .list-error {\r\n        opacity: 1;\r\n        visibility: visible;\r\n    }\r\n\r\n    .price-tables {\r\n        display: flex;\r\n		align-items: start;\r\n        gap: 50px;\r\n        margin-top: 50px;\r\n    }\r\n\r\n    .price-tables .right-table,\r\n    .price-tables .left-table {\r\n        width: 50%;\r\n        border-radius: 8px;\r\n        overflow: hidden;\r\n        box-shadow: 2px 2px 45px 0px #00000012;\r\n    }\r\n\r\n    .price-tables table {\r\n		all: unset;\r\n        width: 100%;\r\n		display: inline-table;\r\n        border-collapse: collapse;\r\n    }\r\n\r\n    .price-tables table thead th {\r\n        color: #3D3D3D;\r\n        background-color: #f0f0f0;\r\n    }\r\n\r\n    .price-tables table th {\r\n        padding: 15px 0;\r\n		border:none !important;\r\n    }\r\n\r\n    .price-tables table td {\r\n        text-align: center;\r\n        padding: 15px 0;\r\n        font-size: 12px;\r\n		border:none;\r\n        border-top: 1px solid #D9D9D9 !important;\r\n    }\r\n\r\n    .price-tables table tr td:first-child {\r\n        font-weight: 500;\r\n        font-size: 16px;\r\n    }\r\n\r\n    .price-tables table tbody {\r\n        background-color: #fff;\r\n    }\r\n\r\n	@media screen and (max-width: 705px) {\r\n		.price-tables{\r\n			flex-wrap:wrap;\r\n		}\r\n		.price-tables .left-table,\r\n		.price-tables .right-table{\r\n			width:100%;\r\n		}\r\n		.price-list .price-item{\r\n			width:170px\r\n		}\r\n		.price-list .price-item .title{\r\n			font-size:14px;\r\n		}\r\n		.price-list .price-item .title svg{\r\n			width:20px !important;\r\n			height:20px !important;\r\n		}\r\n		.price-list{\r\n			font-size:12px\r\n		}\r\n		 .price-list .price-item .changed-price,\r\n    .price-list .price-item .low-price,\r\n		.price-list .price-item .high-price{\r\n			padding:8px;\r\n		}\r\n		.price-list .price-item .current-price{\r\n			padding:10px\r\n		}\r\n		.price-list .important-price-list{\r\n			justify-content:center\r\n		}\r\n		.price-tables table tr td:first-child{\r\n			font-size:14px\r\n		}\r\n		.price-tables table tr td{\r\n			padding:10px\r\n		}\r\n		.skeleton-box{\r\n			width:170px;\r\n			height:184px;\r\n		}\r\n	}\r\n	\r\n	@media screen and (max-width: 440px) {\r\n		.price-list .price-item{\r\n			width:150px\r\n		}\r\n		.price-list .important-price-list{\r\n			gap:20px;\r\n		}\r\n		.skeleton-box{\r\n			width:150px;\r\n			height:184px;\r\n		}\r\n	}\r\n\r\n    .table-row-loading {\r\n        animation: skeleton-loading 3s linear infinite alternate;\r\n        border-radius: 20px;\r\n    }\r\n\r\n    .table-row-loading td {\r\n        height: 200px;\r\n    }\r\n\r\n    .price-tables .right-table,\r\n    .price-tables .left-table {\r\n        position: relative;\r\n    }\r\n</style>\r\n        <div class=\"price-list\">\r\n        <div class=\"price-list-item\">\r\n            <div class=\"important-price-list\">\r\n                <div class=\"skeleton-box\"></div>\r\n                <div class=\"skeleton-box\"></div>\r\n                <div class=\"skeleton-box\"></div>\r\n                <div class=\"skeleton-box\"></div>\r\n                <div class=\"skeleton-box\"></div>\r\n            </div>\r\n            <div class=\"list-error\">\r\n                <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\">\r\n                    <circle cx=\"11\" cy=\"8\" r=\"1\" fill=\"currentColor\" />\r\n                    <circle cx=\"11\" cy=\"16\" r=\"1\" fill=\"currentColor\" />\r\n                    <circle cx=\"11\" cy=\"24\" r=\"1\" fill=\"currentColor\" />\r\n                    <path fill=\"currentColor\"\r\n                        d=\"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h10v-2H8v-6h18V5a2 2 0 0 0-2-2m0 16H8v-6h16Zm0-8H8V5h16Z\" />\r\n                    <path fill=\"currentColor\"\r\n                        d=\"M29 24.415L27.586 23L25 25.587L22.414 23L21 24.415L23.586 27L21 29.586L22.414 31L25 28.414L27.586 31L29 29.586L26.414 27z\" />\r\n                </svg>\r\n                متاسفانه دریافت اطلاعات با مشکل مواجه شده است!\r\n            </div>\r\n        </div>\r\n        <div class=\"price-tables\">\r\n            <div class=\"right-table\">\r\n                <table>\r\n                    <thead>\r\n                        <tr>\r\n                            <th>محصولات</th>\r\n                            <th>نرخ انس</th>\r\n                            <th>تغییرات</th>\r\n                            <th>کمترین</th>\r\n                            <th>بیشترین</th>\r\n                        </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                        <tr class=\"table-row-loading\">\r\n                            <td colspan=\"5\">\r\n                                در حال بارگزاری ...\r\n                            </td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table>\r\n                <div class=\"list-error\">\r\n                    <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\">\r\n                        <circle cx=\"11\" cy=\"8\" r=\"1\" fill=\"currentColor\" />\r\n                        <circle cx=\"11\" cy=\"16\" r=\"1\" fill=\"currentColor\" />\r\n                        <circle cx=\"11\" cy=\"24\" r=\"1\" fill=\"currentColor\" />\r\n                        <path fill=\"currentColor\"\r\n                            d=\"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h10v-2H8v-6h18V5a2 2 0 0 0-2-2m0 16H8v-6h16Zm0-8H8V5h16Z\" />\r\n                        <path fill=\"currentColor\"\r\n                            d=\"M29 24.415L27.586 23L25 25.587L22.414 23L21 24.415L23.586 27L21 29.586L22.414 31L25 28.414L27.586 31L29 29.586L26.414 27z\" />\r\n                    </svg>\r\n                    متاسفانه دریافت اطلاعات با مشکل مواجه شده است!\r\n                </div>\r\n            </div>\r\n            <div class=\"left-table\">\r\n                <table>\r\n                    <thead>\r\n                        <tr>\r\n                            <th>محصولات</th>\r\n                            <th>نرخ انس</th>\r\n                            <th>تغییرات</th>\r\n                            <th>کمترین</th>\r\n                            <th>بیشترین</th>\r\n                        </tr>\r\n                    </thead>\r\n                    <tbody>\r\n                        <tr class=\"table-row-loading\">\r\n                            <td colspan=\"5\">\r\n                                در حال بارگزاری ...\r\n                            </td>\r\n                        </tr>\r\n                    </tbody>\r\n                </table>\r\n                <div class=\"list-error\">\r\n                    <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" height=\"32\" viewBox=\"0 0 32 32\">\r\n                        <circle cx=\"11\" cy=\"8\" r=\"1\" fill=\"currentColor\" />\r\n                        <circle cx=\"11\" cy=\"16\" r=\"1\" fill=\"currentColor\" />\r\n                        <circle cx=\"11\" cy=\"24\" r=\"1\" fill=\"currentColor\" />\r\n                        <path fill=\"currentColor\"\r\n                            d=\"M24 3H8a2 2 0 0 0-2 2v22a2 2 0 0 0 2 2h10v-2H8v-6h18V5a2 2 0 0 0-2-2m0 16H8v-6h16Zm0-8H8V5h16Z\" />\r\n                        <path fill=\"currentColor\"\r\n                            d=\"M29 24.415L27.586 23L25 25.587L22.414 23L21 24.415L23.586 27L21 29.586L22.414 31L25 28.414L27.586 31L29 29.586L26.414 27z\" />\r\n                    </svg>\r\n                    متاسفانه دریافت اطلاعات با مشکل مواجه شده است!\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <script>\r\n        const priceListElem = document.querySelector(\".price-list\");\r\n        const importantPriceListElem = priceListElem.querySelector(\".important-price-list\");\r\n        const rightTableElem = document.querySelector(\".price-tables .right-table table tbody\")\r\n        const leftTableElem = document.querySelector(\".price-tables .left-table table tbody\")\r\n		const isShowError = false;\r\n        const getPriceListData = () => {\r\n            fetch(\"https://desing85.ir/wp-json/myapi/v1/price-list\")\r\n                .then(res => res.json())\r\n                .then(data => {\r\n                    priceListElem.classList.remove(\"has-error\");\r\n                    generatePriceItems(data)\r\n                }).catch(() => {\r\n					if(!isShowError){\r\n						 priceListElem.classList.add(\"has-error\");\r\n						  isShowError = true;\r\n					}\r\n                })\r\n        }\r\n\r\n        const generatePriceItems = (data) => {\r\n            const template = { top: [], right: [], left: [] }\r\n            data.top.forEach((itemData) => {\r\n                template.top.push(importantItemTemplate(itemData))\r\n            })\r\n\r\n            data.right.forEach((itemData) => {\r\n                template.right.push(tableItemTemplate(itemData))\r\n            })\r\n\r\n            data.left.forEach((itemData) => {\r\n                template.left.push(tableItemTemplate(itemData))\r\n            })\r\n\r\n            importantPriceListElem.innerHTML = template.top.join(\"\")\r\n            rightTableElem.innerHTML = template.right.join(\"\")\r\n            leftTableElem.innerHTML = template.left.join(\"\")\r\n        }\r\n\r\n        const importantItemTemplate = (priceItem) => {\r\n            return `\r\n                <div class=\"price-item\">\r\n                    <ul>\r\n                        <li class=\"title\">\r\n                            <svg class=\"pi-icon ${priceItem.rial_price.change_direction}\" width=\"30\" height=\"30\" viewBox=\"0 0 30 30\" fill=\"none\"\r\n                                xmlns=\"http://www.w3.org/2000/svg\">\r\n                                <path d=\"M22.5879 11.9624L15.0004 4.3749L7.41289 11.9624\" stroke=\"#2EAB3C\" stroke-width=\"2\"\r\n                                    stroke-miterlimit=\"10\" stroke-linecap=\"round\" stroke-linejoin=\"round\" />\r\n                                <path d=\"M15 25.625V4.5875\" stroke=\"#2EAB3C\" stroke-width=\"2\" stroke-miterlimit=\"10\"\r\n                                    stroke-linecap=\"round\" stroke-linejoin=\"round\" />\r\n                            </svg>\r\n                            ${priceItem.title}\r\n                        </li>\r\n                        <li class=\"current-price\">(${priceItem.rial_price.change_percent}%) ${priceItem.rial_price.now} </li>\r\n                        <li class=\"changed-price\"><span>تغییرات</span><span>${priceItem.rial_price.change}</span></li>\r\n                        <li class=\"low-price\"><span>کمترین</span><span>${priceItem.rial_price.low}</span></li>\r\n                        <li class=\"high-price\"><span>بیشترین</span><span>${priceItem.rial_price.high}</span></li>\r\n                    </ul>\r\n                </div>            \r\n            `\r\n        }\r\n\r\n        const tableItemTemplate = (priceItem) => {\r\n            return `\r\n                    <tr>\r\n                        <td>${priceItem.title}</td>\r\n                        <td>${priceItem.rial_price.now} (${priceItem.rial_price.change_percent}%)</td>\r\n                        <td>${priceItem.rial_price.change}</td>\r\n                        <td>${priceItem.rial_price.low}</td>\r\n                        <td>${priceItem.rial_price.high}</td>\r\n                    </tr>\r\n            `\r\n        }\r\n        getPriceListData()\r\n\r\n        setInterval(() => {\r\n            getPriceListData()\r\n        }, 20000);\r\n    </script>\r\n    <?php\r\n    return ob_get_clean();\r\n}\r\nadd_shortcode(\'price_list_shortcode\', \'price_list_shortcode\');\r\n\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-27 16:23:53\";}i:2;a:14:{s:2:\"id\";i:1269;s:5:\"title\";s:51:\"Representatives Map (RepresentativesPage) ShortCode\";s:4:\"code\";s:264923:\"function representatives_map_2_shortcode($atts) {\r\n    ob_start();\r\n    ?>\r\n	<!-- Styles	-->\r\n  	<style>\r\n        .representatives-map {\r\n            position: relative;\r\n            opacity: 1;\r\n            transition: 0.3s;\r\n			font-family: var(--e-global-typography-primary-font-family);\r\n        }\r\n\r\n        .representatives-map .loading-map {\r\n            position: absolute;\r\n            top: 50%;\r\n            right: 50%;\r\n            opacity: 0;\r\n            transform: scale(0);\r\n            transition: 0.5s;\r\n            display: flex;\r\n            flex-direction: column;\r\n            align-items: center;\r\n            gap: 10px;\r\n            font-weight: 500;\r\n            font-size: 12px;\r\n        }\r\n\r\n        .representatives-map.loading .loading-map {\r\n            opacity: 1;\r\n            transform: scale(1);\r\n        }\r\n\r\n        .representatives-map.loading #provinces-elem {\r\n            opacity: 0.2;\r\n        }\r\n\r\n        .representatives-map .loading-map svg {\r\n            animation: spin-loading 2s linear infinite;\r\n        }\r\n\r\n        @keyframes spin-loading {\r\n            from {\r\n                transform: rotate(0deg);\r\n            }\r\n\r\n            to {\r\n                transform: rotate(360deg);\r\n            }\r\n        }\r\n\r\n        .representative-info {\r\n			position:absolute;\r\n			left:0;\r\n			bottom:0;\r\n            width: 250px;\r\n            padding: 10px;\r\n            background-color: #fff;\r\n            border-radius: 20px;\r\n            display: flex;\r\n            gap: 10px;\r\n            border: 1px solid #5050502c;\r\n            transform: scale(0);\r\n            transition: 0.3s;\r\n			font-family: var(--e-global-typography-primary-font-family);\r\n        }\r\n\r\n        .representative-img {\r\n            width: 80px !important;\r\n            height: 80px !important;\r\n            object-fit: cover;\r\n            border-radius: 10px !important;\r\n        }\r\n\r\n        .representative-text {\r\n            display: flex;\r\n            flex-direction: column;\r\n            justify-content: space-between;\r\n        }\r\n\r\n        .representative-title {\r\n            font-size: 14px;\r\n            margin: 0;\r\n        }\r\n\r\n        .representative-description {\r\n			margin:0;\r\n            margin-top: 7px;\r\n            font-size: 10px;\r\n            color: #4d4d4d;\r\n            display: -webkit-box;\r\n            max-width: 200px;\r\n            -webkit-line-clamp: 2;\r\n            -webkit-box-orient: vertical;\r\n            overflow: hidden;\r\n        }\r\n\r\n        .province-box {\r\n			margin-top:5px;\r\n            display: flex;\r\n            align-items: center;\r\n            gap: 3px;\r\n            font-size: 10px;\r\n        }\r\n\r\n        .province-label {\r\n            color: #4d4d4d;\r\n        }\r\n\r\n        .info-image-placeholder {\r\n            width: 80px !important;\r\n            height: 80px !important;\r\n            background: #afafaf;\r\n            border-radius: 10px !important;\r\n            display: flex;\r\n            justify-content: center;\r\n            align-items: center;\r\n        }\r\n        .representative-info.show {\r\n            transform: scale(1);\r\n        }\r\n\r\n		.is-representative{\r\n			fill:Transparent;\r\n			transition: 0.4s;\r\n		}\r\n\r\n		.is-representative:hover{\r\n			fill:#0059b2;\r\n		}\r\n		\r\n	.cls-1 {\r\n        fill: #fff;\r\n		stroke:white !important;\r\n		stroke-width:0.3  !important;\r\n      }\r\n    </style>\r\n\r\n	<!-- Html Elements	-->\r\n    <div class=\"representatives-map loading\">\r\n        <svg id=\"provinces-elem\" viewBox=\"0 0 654.51147 593.71021\">\r\n            <defs>\r\n                <clipPath id=\"iran-clip\">\r\n                    <path\r\n                        d=\"m 230.09043,148.8044 0,0 5.59,1.11 2.16,0.86 0.61,0.89 1.29,1.19 1.42,0.62 5.55,1.23 2.2,2.6 -0.11,1.77 0,2.36 -1.91,1.18 -2.74,-0.33 -2.73,1.01 -2.05,2.36 -0.13,2.7 -0.41,2.02 -3.01,0.17 -0.96,2.53 -1.77,2.18 -2.19,1.35 -0.89,2.07 -1.56,0.14 -0.94,1.92 -0.96,0.2 -0.24,-1.39 0.01,-2.31 -1.31,-1.55 -1.91,-0.02 -0.43,1.12 1.31,1.82 0,0.7 -0.35,0.62 -0.85,-0.51 -1.95,-1.76 -3.32,-0.97 -3.42,-0.22 -1.46,-0.34 -0.73,-1.21 -0.86,-1.92 -0.28,-1.29 0.42,-1.63 1.86,-1.8 6.86,-3.35 1.16,-1.11 0.4,-1.54 1.63,-3.39 1.07,-3.62 -1.57,-1.35 -2.4,-0.72 -1.25,-1.07 -1.73,-2.38 0.98,-1.49 3.84,-0.31 8.06,0.86 z\"\r\n                        title=\"Alborz\" />\r\n                    <path\r\n                        d=\"m 468.28043,340.0844 0,0 38.55,17.43 4.85,3.63 13.52,19.71 -6.95,32.33 -0.3,3.24 0.8,0.85 1.53,1.01 1.35,3.42 1.17,8.21 -0.1,3.39 -1.03,3.84 -2.84,4.34 -0.49,2.5 0.49,2.57 0.04,3.17 1,2.09 0.35,1.5 -0.06,1.43 -0.99,1.08 -1.53,1.2 -7.88,4.59 -3.85,1.31 -1.96,1.05 1.26,1.95 2.78,2.11 1.21,1.95 -1.05,3.48 -3.91,5.11 0.23,13.28 -0.45,4.38 -3.9,15.31 0.01,3.77 0.82,3.2 0.12,1.42 -0.1,2.44 0.7,2.59 2.58,2.97 1.78,3.63 -0.96,2.88 -0.95,1.63 0.55,0.87 1.08,0.99 0.04,1.29 -1.09,1.3 -0.84,1.74 0.63,2.2 1.17,1.39 0.29,1.45 -0.54,1.45 -0.64,0.78 0.06,1.23 -0.46,0.61 -0.41,0.98 0.02,2.33 -0.2,1.4 -0.67,1.65 -1.38,-2.09 -0.49,-0.41 -0.93,0.01 -1.31,-0.52 -0.99,0.25 -1,1.05 -1.45,0.18 -1.68,-0.06 -1.4,-0.32 -0.57,-1.01 -0.1,-1.17 -0.34,-0.84 -0.08,-0.73 0.32,-0.7 0.05,-0.41 -0.64,-0.4 -2.11,-0.33 -1.3,-0.59 -1.19,-0.27 -1.17,0.55 -1.83,0.17 -2.78,-0.5 -4.49,0.32 -0.06,-0.77 0.69,-0.85 0.4,-2.11 0,-1.09 -0.19,-1.09 0.78,-7.39 0.47,-1.17 0.62,-0.76 0.19,-0.63 -0.05,-0.96 -0.82,-2.43 0.04,-0.76 0.73,0.04 2.12,1.29 0.29,-0.72 -0.97,-2.1 -1.99,-2.31 -2.53,-2.13 -2.33,-1.4 -2.23,-0.06 -1.39,0.95 -0.81,1.13 -1.6,1.5 -1.02,-0.32 -2.29,-1.69 -10.47,-5.56 -0.68,-2.21 -1.07,-14.26 -1.02,-2.99 -0.92,-1.88 -0.91,-0.46 -0.77,-1.11 0.59,-1.18 0.94,-0.79 -0.23,-1.92 -1.53,-2.33 -1.54,-1.69 -0.79,-1.52 -1.35,-1.76 -1.76,-0.96 -1.04,-0.13 -0.68,-0.57 -0.49,-0.81 -1.23,-5.97 0.3,-3.93 -0.27,-0.62 -3.53,-1.73 -1.84,-0.07 -1.56,1.23 -1.03,1.27 -3.67,3.49 -3.98,1.97 -2.17,0.39 -4.03,-0.62 -3.48,-2.11 -2.91,-2.68 -3.02,-3.91 -0.71,-3.76 0.84,-2.86 -0.65,-14.7 -0.95,-1.41 -1.02,0.13 -3.98,1.87 -6.77,5.14 -1.74,0.45 -1.52,-0.75 -1.48,-1.04 -1.48,-1.94 -3.03,-2.38 -6.12,-1.74 -2.87,-0.21 -6.85,-17.02 -1.97,-0.84 -7.76,-0.72 -1.51,-0.96 -0.81,-0.83 -0.74,-1.3 -0.38,-1.5 -2.75,-5.71 -0.93,-3.09 0.01,-0.77 1.49,-0.66 0.34,-0.29 3.42,-0.42 1.07,-0.76 -0.04,-1.11 -0.47,-1.56 -0.36,-2.22 0.43,-12.7 -1.09,-0.75 -1.09,-1.34 -0.81,-3.92 -2,-5.27 -1.89,-3.58 -0.09,-1.95 0.75,-2.87 1.57,-2.98 2.98,-3.33 19.03,-3.38 4.33,0.17 2.78,0.56 6.38,-0.87 5.74,-2.53 0.51,-2.75 0.44,-12.48 1.5,-3.23 17.98,-9.5 2.4,-2.55 7.04,-3.99 1.56,-1.69 0.73,-1.11 4.32,0.76 36.34,15.66 z\"\r\n                        title=\"Kerman\" />\r\n                    <path\r\n                        d=\"m 596.00043,349.9544 0,0 1.86,0.27 0.88,0.35 0.66,0.53 1.21,1.54 0.24,0.74 -0.24,1.7 0.02,0.79 0.32,0.8 0.91,1.51 0.29,0.89 0.05,1.16 0.09,0.41 0.59,1.26 0.41,1.29 0.17,0.78 0,0.78 -0.24,0.83 -0.65,1.29 0.15,0.46 0.13,2.69 -0.2,0.12 -0.09,0.27 -0.05,0.72 0.05,0.04 0.08,0.21 -0.58,0.62 -2.79,3.38 -4.28,5.18 -3.88,4.7 0,0 -2.76,3.31 -3.66,4.39 -1.91,2.3 -2.8,3.35 -5.24,6.25 -0.01,0.01 -2.57,3.02 -1.96,2.3 2.74,3.24 1.79,2.13 2.21,2.65 2.55,3.06 2.65,3.18 2.79,3.33 0.66,0.54 0.71,0.29 0.6,0.42 0.31,0.99 -0.06,0.76 -0.41,1.36 0,0.76 0.33,0.79 1.07,1.19 0.44,0.67 0.1,0.43 0.09,0.97 0.18,0.44 0.36,0.41 0.31,0.11 0.31,0.04 0.37,0.2 0.34,0.55 0.18,0.66 0.26,0.56 0.58,0.25 0.33,0.26 0.1,0.34 -0.12,0.35 -0.31,0.33 -0.24,0.25 -0.1,0.24 0.08,0.22 0.26,0.21 0.44,0.2 0.38,0.3 0.3,0.4 1.43,3.3 0.19,0.75 0.08,0.65 0.18,0.58 0.97,1.09 0.97,2.13 0.99,1.21 3.49,3.18 1.41,1.83 2.15,2 1.07,1.24 0.62,0.34 2.03,0.57 1.62,0.93 1.02,0.33 2.25,0.19 1.08,0.23 2.82,1.27 4.47,0.9 0.94,0.49 0.4,0.47 0.29,0.51 0.34,0.47 0.55,0.31 0.57,0.19 0.35,0.22 0.24,0.39 0.22,0.67 0.49,0.83 2.14,2.32 0.68,0.44 5.54,-1.13 0.76,0.46 0.16,1.34 -0.5,3.95 -0.54,4.36 0.63,2.65 0.88,3.69 0.21,2.27 0.28,3.09 0.17,1.92 0.33,3.53 0.18,1.99 -0.21,1.58 -1.78,4.02 0.67,0.81 0.16,0.41 -0.06,0.62 -0.16,0.54 -0.2,0.43 -0.33,0.25 -0.54,0.04 1.46,1.3 0.51,0.28 0.27,0 0.47,-0.28 0.23,-0.04 0.28,0.09 0.79,0.44 1.07,0.24 0.92,-0.05 1.97,-0.4 0.88,-0.13 1.78,-0.55 0.9,-0.05 0.56,0.06 0.44,-0.01 1.85,-0.59 0.34,0.01 0.42,0.15 0.88,0.81 0.38,0.23 0.84,0.31 0.31,0.2 0.36,0.39 0.48,0.72 1.16,2.56 -0.59,-0.23 -0.74,0 -0.66,0.29 -0.37,0.62 -0.13,0.38 -0.36,0.52 -0.14,0.38 -0.05,0.44 0.17,4.3 0.31,0.71 0.42,0.62 0.28,0.61 -0.11,0.69 -0.5,0.46 -1.38,0.23 -0.56,0.29 -0.24,0.6 -0.27,5.5 -0.36,1.52 -0.76,0.74 -0.34,-0.01 -0.27,-0.14 -0.24,-0.17 -0.29,-0.14 -0.33,-0.03 -0.98,0.22 -1.34,-0.03 -1.32,-0.21 -3.06,-0.07 -2.66,-0.07 -2.3,-0.06 -0.37,0.11 -0.26,0.35 -0.35,0.64 -0.23,0.18 -0.25,0.13 -0.29,0.11 -1.05,0.24 -0.29,-0.02 -0.37,-0.18 -0.37,-0.08 -0.29,0.18 -0.27,0.28 -0.28,0.22 -0.69,0.25 -5.67,0.6 -0.32,0.09 -0.27,0.21 -0.27,0.49 -0.2,0.18 -0.35,0.1 -0.71,-0.04 -0.32,0.04 -0.28,0.12 -0.44,0.32 -0.27,0.16 -0.67,0.26 -0.29,0.19 -0.21,0.29 -0.07,0.33 0.11,0.25 0.12,0.21 0.04,0.23 -0.35,0.66 -1.07,1.05 -0.24,0.47 0.19,0.87 0.33,0.69 0.03,0.54 -0.74,0.39 -1.27,-0.18 -1.5,-0.53 -1.28,-0.17 -0.57,0.92 -0.12,0.92 -0.31,0.39 -1.4,0.24 -0.7,0.21 -0.63,0.32 -1.22,0.81 -4.08,1.16 -0.82,0.64 -0.49,1.02 -0.29,1.17 -0.31,2.29 -0.27,2.03 -0.32,2.34 -0.43,3.14 -0.36,2.63 -0.19,0.66 -0.51,0.63 -0.59,0.13 -0.65,-0.01 -0.72,0.17 -0.71,0.99 0.16,1.38 0.38,1.49 -0.1,1.3 -0.21,0.29 -0.5,0.5 -0.2,0.36 -0.11,0.54 -0.14,2.19 -0.21,3.21 -0.24,3.73 -0.2,3.16 -1.07,3.12 -0.01,0 -0.21,-0.54 -0.07,-0.63 -0.59,-0.43 -0.11,-0.23 -0.16,-0.11 -0.33,0.22 -0.1,0.21 -0.05,0.6 -0.1,0.23 0.19,0.18 0.33,0.39 0.19,0.17 -0.72,-0.08 -0.55,-0.22 -0.56,-0.01 -0.73,0.57 0.8,0.26 0.33,0.18 0.27,0.33 -0.18,0.36 -0.53,0.68 -0.15,0.4 0,0.19 -0.04,0.15 -0.27,0.26 -0.49,0.26 -1.84,0.55 0.49,0.34 -0.79,1.06 -5.7,-1.96 -1.98,-0.43 0.01,-0.61 -0.51,-0.93 -4.73,-1.69 -5.55,-0.93 -4.71,-1.12 -3.19,-0.39 -0.56,-0.31 0.52,-0.49 -0.82,-1.18 -0.1,-0.5 -0.01,-2.1 -0.11,-0.33 -1.23,-1.23 -0.53,-0.31 -0.59,-0.07 -0.61,0.06 -2.32,0.71 -0.58,0.33 -0.32,0.51 -0.53,0.64 -0.28,0.41 0,0.25 0.1,0.23 0.13,0.76 0.17,0.11 0.23,0.02 0.38,0.19 0.29,-0.01 0.14,0.1 0.14,0.23 0.35,0.39 -0.37,-0.06 0,0.09 0.98,0.5 -0.1,0.48 -0.39,-0.09 -1.09,-0.46 -1.38,-0.57 -0.68,-0.39 -1.47,0.03 -0.98,-0.8 0.32,-0.6 0.14,-0.15 -0.49,-0.22 -0.62,-0.09 -1.22,0.06 -0.94,0.18 -0.2,0.07 -0.3,0.35 0,0.21 0.09,0.19 0.7,0.48 -0.23,0.7 -0.92,-0.01 -0.68,-0.45 -0.37,-0.12 -1.16,-0.17 -0.26,-0.2 -0.38,-0.49 -0.53,-0.29 -1.25,0.08 -1.72,0.26 -1.82,0.07 -1.25,0.94 -1.42,-0.49 -1.42,-1.36 -1.53,-0.4 -3.91,0.24 -1.53,-0.01 -2.58,-0.6 -1.61,-1.64 -1.23,-0.68 -1.92,0.37 -4,0.64 -0.95,0.15 -0.15,-0.89 0.89,-0.39 0.02,-0.57 0.09,-0.6 -0.63,-0.31 -0.28,-0.37 -1.2,-2.05 -0.56,-0.56 -0.46,-0.6 -0.23,-0.77 -0.55,-0.68 -1.02,-0.39 -0.75,-0.76 -0.18,-1.36 -1.09,-1.8 -6.42,-5.68 -1.21,-0.76 -0.46,-0.2 -0.13,-0.68 0.16,-1.21 0.61,-0.93 0.41,-0.22 0.67,-1.65 0.2,-1.4 -0.02,-2.33 0.41,-0.98 0.46,-0.61 -0.06,-1.23 0.64,-0.78 0.54,-1.45 -0.29,-1.45 -1.17,-1.39 -0.63,-2.2 0.84,-1.74 1.09,-1.3 -0.04,-1.29 -1.08,-0.99 -0.55,-0.87 0.95,-1.63 0.96,-2.88 -1.78,-3.63 -2.58,-2.97 -0.7,-2.59 0.1,-2.44 -0.12,-1.42 -0.82,-3.2 -0.01,-3.77 3.9,-15.31 0.45,-4.38 -0.23,-13.28 3.91,-5.11 1.05,-3.48 -1.21,-1.95 -2.78,-2.11 -1.26,-1.95 1.96,-1.05 3.85,-1.31 7.88,-4.59 1.53,-1.2 0.99,-1.08 0.06,-1.43 -0.35,-1.5 -1,-2.09 -0.04,-3.17 -0.49,-2.57 0.49,-2.5 2.84,-4.34 1.03,-3.84 0.1,-3.39 -1.17,-8.21 -1.35,-3.42 -1.53,-1.01 -0.8,-0.85 0.3,-3.24 6.95,-32.33 1.06,-0.51 25.41,-7.22 1.85,0.33 1.19,1.27 0.77,0.62 3.14,0.86 4.17,3.08 5.33,7.61 2.78,2.38 4.6,-0.16 1.15,-0.45 0.53,-0.82 0.06,-1.22 -1.72,-7.64 -0.14,-3 0.7,-10.31 1.61,-5.8 2.17,-5.22 0.47,-4.78 -0.62,-2.31 5.75,0.85 6.64,0.97 3.9,0.57 z\"\r\n                        title=\"Sistan and Baluchestan\" />\r\n                    <path\r\n                        d=\"m 456.82043,80.6944 0,0 0.54,-0.08 0.52,-0.16 0.58,-0.09 0.57,0.07 1.72,0.5 1.65,-0.03 0.51,-0.13 0.51,0 0.46,0.29 0.42,0.37 0.43,0.27 0.17,0.02 -4.11,2.54 -1.28,1.3 0.01,1.87 -0.39,1.59 -0.55,1.48 1.29,0.93 15.19,0.72 0.64,0.8 0.43,1.46 0.78,1.78 3.07,2.88 0.93,1.91 0.21,1.71 -0.75,1.37 -0.89,1.1 -0.31,0.74 -0.03,0.85 -0.34,1.26 -1.22,1.71 -2.03,6.01 -1.38,1.71 0.16,1.48 1.66,1.15 0.94,1.04 0.61,1.19 0.9,-0.14 0.49,-1.28 0.44,-0.2 0.29,1.09 0.68,1.04 1.12,0.54 0.13,0.98 -2.01,2.17 -0.22,1.18 0.44,0.67 1.21,0.72 0.28,1.32 -1.13,3.3 -1.27,1.2 -2.56,0.63 -9.38,-1.44 -22.43,-12.47 -5.4,-0.26 -8.16,6.63 -1.95,2.61 -0.27,1.92 0.26,1.5 -0.11,1.15 -5.16,0.87 -1.68,-0.65 -3.23,-0.55 -1.9,-0.64 -3.85,-3.31 -4.01,-4.51 -0.63,-1.34 0.12,-0.85 0.64,-2.53 0.17,-2.88 -0.17,-1.12 -0.21,-0.45 -0.22,-0.34 0.21,-0.63 0.87,-0.7 1.98,-0.59 0.35,-0.97 -1.65,-0.69 -1.33,0.23 -2.41,-1.7 -5.12,-6.83 1.03,-1 2.47,-4.4 2.46,-1.02 1.03,-0.95 1.02,-0.46 0.91,-0.14 3.97,-1.38 1.86,-2.6 -0.63,-2.61 -1.38,-1.06 -1.6,-0.79 -1.15,-1.37 -0.07,-1.94 0.69,-2.77 0.03,-1.02 -0.41,-1.8 -0.09,-1.56 0.22,-1.22 -0.22,-3.01 1.05,0.43 0.55,0.08 2.9,-0.49 0.53,-0.4 0.34,-0.67 0.12,-0.8 -0.16,-0.75 -0.92,-1.06 0.21,-0.59 2.14,-1.99 1.14,-0.8 1.23,-0.47 3.11,-0.1 0.57,0.14 0.48,0.29 0.42,0.34 0.46,0.21 0.54,-0.1 2.72,-1.19 1.62,-0.28 0.33,0.06 1.32,1.09 1.16,0.67 0.53,0.17 5.09,0.96 1.35,0.55 0.69,0.11 0.61,-0.34 0.47,-0.42 1.1,-0.74 0.4,-0.43 0.68,-1.19 0.1,-0.12 0.3,-0.32 0.59,-0.28 0.37,-0.05 0.37,0.05 0.72,0.24 0.38,0.25 0.09,0.28 0.02,0.32 0.14,0.38 0.78,1.33 0.61,1.49 0.4,0.6 1.11,1.2 0.39,1.29 0.73,1.03 0.16,0.76 -0.08,0.71 -0.67,2.27 0.86,1.15 4.87,1.94 z\"\r\n                        title=\"North Khorasan\" />\r\n                    <path\r\n                        d=\"m 467.11043,83.0344 0,0 0.55,-0.04 0.57,-0.13 0.55,-0.05 1.18,0.32 5.31,2.56 2.23,0.53 1.14,0.09 0.55,0.13 0.57,0.28 0.25,0.29 0.01,0.3 -0.08,0.3 0.03,0.34 0.54,1 0.12,0.32 0.08,0.78 0.01,0.59 0.16,0.49 0.58,0.48 0.58,0.22 2.64,0.4 0.42,0.2 0.9,0.64 0.47,0.13 3.07,-0.31 0.58,-0.28 0.46,-0.71 0.31,-0.72 0.41,-0.6 0.52,-0.38 0.66,-0.05 0.56,0.29 1.7,1.51 1.46,0.6 0.77,0.12 0.76,-0.08 0.29,-0.18 0.22,-0.26 0.24,-0.2 0.38,0 0.72,0.14 0.35,-0.03 0.36,-0.12 0.45,-0.56 0.08,-0.64 0.19,-0.29 2.03,1.13 2.63,0.61 1.33,0.61 0.48,0.35 0.45,0.15 0.98,0.15 0.38,0.2 1.11,1.15 4.51,3.27 0.73,0.07 1.9,-0.88 0.78,0.21 0.68,0.65 0.65,0.91 0.16,0.56 -0.1,0.95 0.2,0.46 0.09,0.36 -0.14,0.38 -0.21,0.42 -0.11,0.47 0.08,0.9 0.67,2.93 0.39,0.59 2.12,1.77 0.64,0.71 0.2,0.28 -0.04,0.21 -0.13,0.14 -0.04,0.12 -0.05,0.29 -0.1,0.35 0.1,0.3 0.56,0.15 0.22,0.23 0.27,0.22 0.29,0.14 0.28,0.02 1.07,-0.43 0.5,0.09 0.57,0.61 0.24,0.66 0.16,0.81 0.24,0.7 0.45,0.36 0.32,-0.07 0.24,-0.25 0.4,-0.63 0.32,-0.17 0.36,0.02 4.87,1.6 2.22,1.88 1.25,0.73 2.78,0.5 1.27,0.55 1,1.35 1.27,2.71 1.57,2.4 3.59,4.39 0.71,1.15 0.98,2.59 0.7,1.23 1.12,0.63 5.38,-0.1 4.74,-0.09 7.22,-0.13 4.02,-0.07 3.47,-0.06 1.68,0.29 1.38,0.19 0.28,1.44 0.28,0.65 0.12,0.39 0.06,0.53 -0.05,0.51 -0.13,0.47 -0.19,0.41 -0.21,0.32 -0.14,0.45 0.05,0.5 0.21,0.63 -0.73,3.39 -0.2,2.07 0.48,1.2 -0.1,0.17 -0.06,0.12 -0.09,0.29 0.33,0.14 0.27,0.21 0.21,0.26 0.14,0.25 0.13,0.44 0.06,0.44 0.02,0.97 0.11,0.41 0.49,0.82 0.51,2.61 0.09,1.26 0.05,0.21 -0.06,0.26 -0.36,0.47 -0.17,0.29 -0.1,0.37 -0.06,0.41 -0.02,0.39 -0.13,0.45 -0.28,0.21 -0.32,0.13 -0.21,0.19 -0.1,0.51 0.12,0.84 -0.02,0.39 -0.42,0.45 -0.69,0.56 -0.39,0.5 0.47,0.21 0.83,0.13 0.68,0.37 0.59,0.55 0.55,0.66 0.35,0.58 0.3,0.71 0.21,0.73 0.15,1.5 0.13,0.63 0.02,0.68 -0.22,0.93 0.22,0.31 0,0.41 -0.22,0.99 -0.02,0.23 0.02,0.74 -0.1,0.29 -0.46,0.46 -0.14,0.25 0.09,1.11 0.46,0.94 0.83,1.29 0.24,0.38 0.36,1.71 0.09,0.84 -0.21,0.86 -0.46,0.79 -0.79,0.97 -0.37,0.8 -0.3,1.3 -0.18,0.43 -0.71,0.96 -0.2,0.46 -0.16,0.85 0.16,2.14 -0.27,0.73 -0.65,0.38 -0.81,0.13 -0.72,0.02 -0.49,0.4 -0.2,0.89 -0.02,0.88 0.02,0.4 0.19,0.18 0.16,0.4 -0.01,0.4 -0.34,0.18 -0.2,0.19 0.17,0.41 1.21,1.63 0.09,0.18 -0.07,0.47 -0.09,0.36 0.06,0.34 0.35,0.38 -0.82,1.16 -0.24,0.59 -0.2,1.71 -0.5,1.55 -0.11,0.81 -0.11,0.39 -0.47,0.78 -0.11,0.52 0.03,0.42 0.15,0.77 0.03,0.36 -0.15,1.45 -0.27,1.37 -1.04,0.34 -0.19,0.69 -0.66,1.18 -1.07,0.84 -0.61,0.72 -0.05,0.97 0.12,1.06 -0.14,1.01 -0.35,0.47 -0.4,0.09 -0.44,-0.03 -0.47,0.07 -0.46,0.26 -0.22,0.28 -0.17,0.33 -1.54,1.76 -0.66,0.45 -0.84,0.24 -1.86,0.25 -0.84,0.43 -0.5,0.87 0.36,0.05 0.29,0.16 0.22,0.29 0.29,0.98 0.3,0.28 0.83,0.38 0.41,0.38 0.33,0.47 0.54,1.07 2.51,3.28 0.38,0.77 -2.52,0.14 -3.44,0.22 -2.39,0.14 0.23,0.87 -0.53,0.58 -1.61,0.86 -1.18,1.24 -1.07,1.39 -0.95,1.92 -0.21,1.83 0.06,0.55 -0.01,0 -2.64,0.45 -21.07,0.06 -4.45,-1.58 -3.32,-5.44 -1.82,-1.56 -3.53,1.32 -3.14,1.81 -10.05,1.49 -0.97,1.08 -0.92,0.67 -3.48,-1.06 -5.39,-0.69 -1.82,0.7 -0.49,1.17 0.19,1.07 1.32,2.14 -0.32,2.71 -0.71,3 0.36,1.8 -0.13,1.62 -0.87,2.09 -0.51,2.31 0.16,1.74 0.95,0.92 0.79,0.58 0.35,0.96 0.29,1.17 5.13,3.75 -1.01,1.87 -0.2,1.16 -1.69,2.71 -1.51,1.54 -10.64,7.07 -4.7,7.14 -1.12,4.78 -1.45,2.49 -0.85,1.02 -0.89,-0.64 -2.74,-4.3 -2.87,-1.8 -2.19,-0.99 -0.81,-0.63 -2.88,-1.65 -2.2,-5.05 -2.53,-17.12 -1.34,-2.59 -1.45,-1.85 -8.66,2.02 -6.72,-0.81 -1.59,-2.51 -2.11,-11.75 0.28,-6.91 4.26,-12.86 2.31,-4.17 13.42,-9.52 3.28,-3.22 0.46,-2.64 -1.16,-2.61 -9.88,-7.59 -3.77,-0.99 -8.52,2.2 -13.46,6.4 -13.84,3.62 5.44,-6.75 4.37,-4 3.85,-2.3 7.15,-2.69 1.03,-0.81 1.44,-3.35 5.89,-10.15 0.52,-2.91 -2.22,-2.56 -8.03,-6.57 -0.92,-2.35 -1.1,-5.06 -0.64,-7.87 0.5,-4.58 1.37,-2.62 0.91,-3.93 -0.83,-3.32 -1.37,-0.82 -1.08,-0.04 -0.67,0.19 0.11,-1.15 -0.26,-1.5 0.27,-1.92 1.95,-2.61 8.16,-6.63 5.4,0.26 22.43,12.47 9.38,1.44 2.56,-0.63 1.27,-1.2 1.13,-3.3 -0.28,-1.32 -1.21,-0.72 -0.44,-0.67 0.22,-1.18 2.01,-2.17 -0.13,-0.98 -1.12,-0.54 -0.68,-1.04 -0.29,-1.09 -0.44,0.2 -0.49,1.28 -0.9,0.14 -0.61,-1.19 -0.94,-1.04 -1.66,-1.15 -0.16,-1.48 1.38,-1.71 2.03,-6.01 1.22,-1.71 0.34,-1.26 0.03,-0.85 0.31,-0.74 0.89,-1.1 0.75,-1.37 -0.21,-1.71 -0.93,-1.91 -3.07,-2.88 -0.78,-1.78 -0.43,-1.46 -0.64,-0.8 -15.19,-0.72 -1.29,-0.93 0.55,-1.48 0.39,-1.59 -0.01,-1.87 1.28,-1.3 4.11,-2.54 0.12,0.01 0.55,-0.13 0.28,0.07 0.24,0.24 0.31,0.65 0.2,0.26 0.51,0.21 z\"\r\n                        title=\"Razavi Khorasan\" />\r\n                    <path\r\n                        d=\"m 534.43043,242.0644 0,0 21.07,-0.06 2.64,-0.45 0.01,0 0.37,3.54 0.97,6.24 -0.07,1.6 -1.05,2.36 -0.27,1.34 0.84,2.97 2.14,2.05 2.73,1.14 2.65,0.2 2.49,-0.13 1.31,0.1 1.14,0.28 0.52,0.31 0.57,0.52 0.3,0.58 -0.03,0.06 -0.26,0.45 -0.5,0.18 -1.61,0.11 -0.6,0.4 -0.1,0.58 0.12,0.68 0.06,0.7 -0.18,0.81 -0.36,0.46 -1.11,0.7 -0.97,0.87 -1.29,1.75 -1.65,2.24 -1.84,2.49 -1.64,2.22 -0.21,0.57 0.05,3.2 0.5,2.58 0.97,3.31 1.14,3.9 1.18,4.02 1.25,4.24 1.38,4.65 1.49,5.56 1.15,4.29 -0.07,3.26 -0.46,3.18 -0.2,0.67 -0.89,1.14 -0.26,0.62 0.12,0.24 0.28,0.17 0.2,0.22 -0.29,0.88 0.07,0.41 0.17,0.39 0.13,0.43 0.06,0.87 -0.25,2.46 0.07,1.93 0.47,3.69 -0.43,2.94 0.08,0.93 0.51,1.92 0.4,3.73 1.12,0.47 3.42,0.5 5.68,0.84 0.05,0 0.62,2.31 -0.47,4.78 -2.17,5.22 -1.61,5.8 -0.7,10.31 0.14,3 1.72,7.64 -0.06,1.22 -0.53,0.82 -1.15,0.45 -4.6,0.16 -2.78,-2.38 -5.33,-7.61 -4.17,-3.08 -3.14,-0.86 -0.77,-0.62 -1.19,-1.27 -1.85,-0.33 -25.41,7.22 -1.06,0.51 -13.52,-19.71 -4.85,-3.63 -38.55,-17.43 0.48,-0.78 1.77,-4.57 3.48,-5.4 1.25,-3.49 4.51,-6.05 0.56,-1.87 0.3,-1.97 0.77,-2.23 0.08,-2.2 -1.36,-2.25 -1.03,-2.25 -0.06,-1.21 -0.99,-1.13 -0.52,-0.93 -0.24,-0.89 0.58,-1.44 0.91,-1.48 0.28,-1.25 -0.17,-3.08 0.85,-1.02 1.45,-2.49 1.12,-4.78 4.7,-7.14 10.64,-7.07 1.51,-1.54 1.69,-2.71 0.2,-1.16 1.01,-1.87 -5.13,-3.75 -0.29,-1.17 -0.35,-0.96 -0.79,-0.58 -0.95,-0.92 -0.16,-1.74 0.51,-2.31 0.87,-2.09 0.13,-1.62 -0.36,-1.8 0.71,-3 0.32,-2.71 -1.32,-2.14 -0.19,-1.07 0.49,-1.17 1.82,-0.7 5.39,0.69 3.48,1.06 0.92,-0.67 0.97,-1.08 10.05,-1.49 3.14,-1.81 3.53,-1.32 1.82,1.56 3.32,5.44 4.45,1.58 z\"\r\n                        title=\"South Khorasan\" />\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 -4.99,-2.73 -1.22,0.34 0.6,1.67 1,1.3 0.4,0.89 -0.01,1.05 -2.41,0.82 -0.97,0.95 -1.11,0.5 -1.05,-0.29 -1.6,-3.33 -0.78,0.08 -1.77,1.99 -0.53,1.05 2.36,3.5 3.65,8.17 1.66,2.03 1.39,0.87 1.93,1.92 0.93,3.83 -0.67,3.09 -1.19,1.91 -1.13,0.99 -0.73,-0.39 -1.09,-2.68 -0.63,0.16 -0.38,1.16 -1.23,0.67 -2.08,0.59 -1.03,0.56 -1.05,0.04 -1.46,-0.22 -5.2,-5.88 -3.88,-1.76 -1.33,-1.15 -0.99,-0.08 -0.36,0.79 0.61,1.23 -0.11,1.4 -1.16,1.07 -4.85,0.32 -0.35,0.8 -0.21,2.69 -0.68,0.39 -1.33,-0.09 -2.11,0.21 -2.04,2.13 -1.42,0.48 -0.44,0.91 0,1.19 -0.72,0.83 -1.11,0.18 -0.66,0.89 -0.16,1.36 -1.3,0.69 -2.29,0.33 -3.06,-0.36 -2.03,0.22 -1.12,-1.23 -0.04,-1.63 0.27,-1.21 -0.14,-0.87 -0.77,0.06 -1.45,-1.01 -8.14,-11.14 -6.44,-5.08 -0.94,-0.32 0.08,-0.17 -0.25,-1.22 -0.81,-0.94 -1.87,-1.68 -2.17,-3.48 -0.44,-1.2 -0.01,-0.38 0.08,-0.34 0.18,-0.27 0.27,-0.21 0.13,-0.16 0.05,-0.17 -0.05,-0.18 -0.13,-0.17 -0.38,-0.79 -0.3,-0.85 0.16,-0.04 0.16,0 1.04,0.32 0.09,-0.58 -0.33,-1.6 0,-0.69 0.12,-0.73 0.27,-0.66 0.43,-0.47 0.7,-0.25 2.37,0.07 0.69,-0.16 1.7,-0.9 1.33,0.07 0.71,-0.08 0.53,-0.51 0.46,-0.68 1.03,-0.66 0.53,-0.48 0.4,-0.69 0.07,-0.65 -0.25,-0.56 -0.57,-0.4 -0.73,-0.07 -0.6,0.3 -0.58,0.4 -0.65,0.24 -1.43,0.31 -0.73,0.03 -0.68,-0.29 -0.28,-0.23 -0.21,-0.23 -0.14,-0.29 -0.17,-0.85 -0.16,-0.15 -0.25,-0.04 -1.04,-0.4 -0.56,-0.01 -0.55,0.2 -0.65,0.38 -0.68,0.22 -2.16,-0.1 -1.09,0.38 -0.35,-0.04 -0.34,-0.11 -0.35,-0.01 -0.82,0.7 -0.65,0.33 -0.7,0.05 -0.55,-0.38 -0.38,-0.08 -1.28,0.39 -0.61,-0.17 -0.41,-0.55 -0.87,-2.16 -1.57,-2.23 -1.01,-0.93 -0.92,-0.17 -0.44,-0.28 -1.25,-1.16 -1.3,-0.48 0,0 0.02,-0.02 1.14,-0.7 1.33,-1.33 0.56,-1.37 1.88,-2.14 0.46,-2.04 0.75,-0.77 0.39,-0.67 1.02,-1.11 5.51,-1.78 1.63,-2.48 0.05,-2.03 0.75,-0.97 2.96,-1.18 8.52,1.22 17.52,-1.62 0.4,0.33 0.24,0.51 0.48,0.64 0.68,0.57 0.58,0.64 1.3,0.9 3.51,0.97 3.84,0.34 2.56,-1.13 1.43,-1.66 0.58,-1.16 0.18,-0.66 -0.24,-0.69 0.14,-0.83 1,-0.61 0.83,-0.26 0.98,0.99 17.06,3.4 0.12,0.18 1.07,1.19 0.23,0.45 0.13,0.81 0.33,0.94 0.38,0.82 0.32,0.47 -0.35,0.33 -0.07,0.37 0.21,1.02 -0.05,0.29 -0.14,0.26 -0.11,0.28 0.04,0.31 0.14,0.06 0.59,0.07 0.64,2.37 0,4.26 -0.75,3.07 -1.33,1.4 -0.56,1.51 0.47,1.11 9.32,5.68 0.62,0.58 0.67,1.14 0.3,0.9 z\"\r\n                        title=\"Kordestan\" />\r\n                    <path\r\n                        d=\"m 164.84043,58.6444 0,0 0.1,3.8 -0.39,1.26 0.24,0.92 0.07,2.28 0.64,1.59 0.47,5.27 1.4,5.01 -0.27,0.83 -0.03,0.97 0.15,0.93 0.26,0.66 1.19,1.95 0.01,0.45 -0.1,0.38 -0.05,0.31 0.35,1.68 0.71,1.61 1.71,2.58 2.28,2.38 2.48,1.78 5.46,2.85 2.54,0.85 13.01,1.77 1.4,-0.22 1.16,-0.47 1.09,-0.2 1.21,0.62 -0.32,0.06 -0.38,-0.11 -0.2,-0.03 -0.26,0.35 2.82,1.1 4.41,1.02 1.59,0.61 1.07,1.02 -0.14,1.54 0.3,0.59 0.44,1.54 0.31,0.62 0.49,0.76 0.8,2.3 1.01,1.68 1.19,1.14 2.44,1.85 1.68,2.03 0.51,0.31 0.66,0.19 2.13,1.45 0,0 -0.02,0.14 -0.33,1.08 -1.16,1.6 -1.76,0.95 -1.36,1.35 -0.74,3.51 -2.08,3.71 -1.76,1.15 -4.6,-0.46 -2.81,0.63 -0.75,0.4 -0.7,0.24 -6.36,3.46 -1.68,0.3 -3.13,-0.63 -0.73,-0.5 -1.04,-0.18 -1.73,0.07 -4.65,-1.39 -2.06,-1.94 -1.91,-2.43 -0.43,-1.35 -0.06,-0.71 -3.21,-1.55 -2,-6.96 -1.44,-2.33 -3.76,-3.97 -5.1,-3.26 -0.37,-1.05 -0.29,-2.23 0.15,-1.86 -0.03,-1.22 -1.14,-1.45 -2.16,-1.71 -1.87,-1.93 -5.62,-8.86 -3.11,-8.63 0.07,-2.35 1.08,-1.68 0.3,-2.28 0.7,-1.66 7.65,-9.11 0.3,-0.79 -0.52,-0.56 -1.28,-0.29 -0.82,-0.33 -0.19,-0.81 -0.7,-0.92 -1.08,-0.96 -0.2,-0.45 1.56,0.13 0.82,-0.23 0.91,-0.39 0.86,-0.54 0.67,-0.68 0.76,-0.41 1.08,0 2.19,0.46 z\"\r\n                        title=\"Gilan\" />\r\n                    <path\r\n                        d=\"m 88.71043,209.5144 0,0 0.77,-0.06 0.14,0.87 -0.27,1.21 0.04,1.63 1.12,1.23 2.03,-0.22 3.06,0.36 2.29,-0.33 1.3,-0.69 0.16,-1.36 0.66,-0.89 1.11,-0.18 0.72,-0.83 0,-1.19 0.44,-0.91 1.42,-0.48 2.04,-2.13 2.11,-0.21 1.33,0.09 0.68,-0.39 0.21,-2.69 0.35,-0.8 4.85,-0.32 1.16,-1.07 0.11,-1.4 -0.61,-1.23 0.36,-0.79 0.99,0.08 1.33,1.15 3.88,1.76 5.2,5.88 1.46,0.22 1.05,-0.04 0.02,0.63 -0.18,1.15 -1.12,1.29 -1.34,3.02 -1.59,2.35 -3.39,0.39 -1.08,0.43 -0.49,0.64 0.33,1.64 1.72,1.4 2.49,1.36 1.11,0.22 0.92,0.49 0.5,1.7 0.86,1.31 2.89,-3.02 1.56,-0.69 0.78,-0.17 0.65,0.99 0.34,1.67 -0.37,2.72 0.08,1.91 -1.03,0.85 -3.8,-0.81 -3.36,0.24 -1.24,1.9 -0.59,1.15 -2.33,-0.31 -0.98,0.26 -0.65,0.43 -0.11,0.92 0.31,2.21 -0.19,2.3 -1.64,0.85 -2.42,0.12 -1.96,0.97 -0.2,0.58 0.08,0.4 0.21,0.27 0.23,0.25 0.17,0.33 0.06,0.47 -0.1,0.76 0.04,0.44 0.13,0.31 -0.49,0.79 -0.59,0.42 -0.56,-0.17 -1.15,-0.1 -5.43,1.26 0,1.25 0.93,1.39 0.5,1.03 -0.47,2.64 -0.71,1.39 -5.31,-0.24 -5.76,1.47 -3.96,-0.32 -8.5,-2.75 -2.49,-2.16 -2.27,-1.4 -2.74,-0.63 -2.73,-0.2 -5.07,-2.08 -5.25,0.66 -2,-0.06 -0.62,0.73 0.47,1.56 -0.37,2.63 -1.29,4.06 -0.72,5.9 -0.76,0.64 -0.12,-0.31 -1.6,-1.15 -0.51,-0.51 -0.47,-0.67 -0.33,-0.66 -0.24,-0.72 -0.14,-0.82 -0.25,-0.68 -0.44,-0.49 -0.52,-0.44 -0.46,-0.5 -3.01,-5.5 -0.07,-0.06 -0.07,-0.03 -0.08,-0.01 -1,0.15 -0.88,-0.05 -0.77,-0.44 -0.7,-0.98 0.72,-0.33 0.33,-0.23 0.28,-0.29 0.01,0 0,0 0.51,-1.14 0.29,-1.04 0.38,-0.91 0.83,-0.72 0.49,-0.54 1.37,-1.12 0.35,-0.47 0,-0.45 -0.2,-0.35 -0.25,-0.36 -0.16,-0.47 0.07,-0.37 0.48,-0.78 0.16,-0.37 0.46,-1.97 0.06,-1.01 -0.18,-0.93 -0.52,-0.8 -0.7,-0.45 -0.76,0 -0.67,0.55 -0.63,-0.47 -0.43,-0.89 -1.05,-3.37 0.33,-0.54 1.78,-0.4 0.24,-0.23 0.22,-0.26 0.2,-0.29 0.16,-0.33 0.04,-1.22 -0.28,-1.66 0.14,-1.13 1.32,0.39 1.16,0.62 1.05,0.25 2.33,0.18 0.74,0.27 0.2,-0.05 0.14,-0.26 0.09,-0.44 0.01,-0.44 -0.1,-0.27 -0.38,-0.53 -0.1,-0.7 -0.02,-0.77 -0.11,-0.78 -0.14,-0.29 -0.17,-0.2 -0.17,-0.25 -0.1,-0.44 -0.12,-0.33 -0.25,-0.3 -0.3,-0.24 -0.28,-0.16 -0.51,-0.57 0.26,-0.67 0.94,-1.08 0.11,-0.48 -0.08,-0.83 0.11,-0.49 0.33,-0.47 0.43,-0.18 0.96,-0.1 0.94,-0.66 0.17,-1 -0.07,-1.05 0.23,-0.8 0.78,-0.03 0.61,0.32 0.4,0.21 0.91,0.32 0.52,-0.69 0.26,-1.01 0.28,-0.75 0.09,-0.78 -0.31,-1.07 0,0 -0.1,-0.57 0.01,-0.55 0.16,-0.47 0.36,-0.36 0.23,-0.07 0.47,-0.05 0.2,-0.11 0.07,-0.19 -0.09,-0.51 0.03,-0.19 0.47,-0.78 0.24,-0.09 0.5,0.17 0.71,0.46 0.35,0.15 0.44,-0.04 1.01,0.45 0.54,-0.14 0.5,-0.47 0.91,-0.55 0.34,-0.04 0.6,0.16 0.86,-0.28 0.42,-0.09 0.37,-0.19 0.27,-0.5 -0.7,-0.82 0.45,-1.17 0.74,-1.26 0.12,-1.09 -0.51,-0.43 -1.31,0.01 -0.47,-0.33 -0.09,-0.65 0.3,-0.53 0.42,-0.5 0.17,-0.42 0.94,0.32 6.44,5.08 8.14,11.14 1.45,1.01 z\"\r\n                        title=\"Kermanshah\" />\r\n                    <path\r\n                        d=\"m 95.95043,37.9044 0,0 -1.57,-1.29 -0.7,0.05 -0.09,0.66 -0.02,1.27 -0.23,1.21 -0.46,0.41 -1.81,-0.44 -1.26,0.14 -0.34,0.62 -0.91,0.53 -1.36,1.8 -0.54,2.71 0.96,2.37 1.73,0.95 2.32,-0.83 2.32,-1.26 2.22,-0.63 5.07,1.44 1.42,-1.15 1.28,-1.75 2.12,-1.6 0.42,-0.55 -0.51,-0.19 -0.46,-0.71 3.88,-6.77 2.55,-1.73 1.38,0.12 2.28,-1.37 2.19,-1.96 1.34,0.5 -0.47,4.96 0.52,0.76 0.09,3.28 1.96,4.9 -0.36,2.9 -1.25,1.69 0.02,1.21 1.78,1.01 0.64,2.12 -1.65,1.13 -2.43,-0.39 -2.3,0.68 -1.42,1.54 -2.71,1.98 -1.07,2.01 -0.86,1.12 -0.69,1.58 -0.16,2.21 0.4,1.34 1.63,-0.64 2.16,-0.26 1.07,1.04 0.47,0.35 0.99,0.18 7.61,-1.12 2.36,1.18 1.01,3.16 0.21,3.42 1.71,4.24 2.67,3.66 2.27,2.09 0.35,0.77 -0.34,1.19 -0.77,1.63 -0.3,3.9 1.01,4.68 3.31,2.05 0.21,-0.13 0.76,0.15 2.49,1.3 0.9,0.79 0.27,3.09 0.88,2.08 2.08,1.38 0.72,0.74 1.54,1.26 -0.09,0.23 -0.17,0.64 0.26,0 0.3,-0.37 0.51,-0.18 1.15,-0.06 0.49,0.26 0.48,0.97 0.3,-0.04 0.47,0.25 0.47,0.17 -0.39,0.23 -1.19,0.95 -2.52,0.99 -8.1,-0.84 -2.2,0.36 -3.21,-0.49 -10.65,1.24 -1.2,0.5 -1.17,0.7 -1.85,2.01 -2.24,1.07 -1.01,0.74 -1.42,2.37 -5.13,5.22 -0.65,1.33 0.01,2.05 0.2,1.37 -8.04,0.93 -3.3,-0.45 -1.22,-1.77 0.03,-2.82 -1.34,-3.92 0.44,-0.63 -0.15,-0.9 -1.07,-0.92 -1.72,-0.39 -1.35,-0.83 -1.07,-1.09 -1.57,-0.26 -1.42,0.94 -0.93,0.88 -0.82,-0.08 -1.68,0.35 -2.03,1.33 -1.11,1.38 -0.5,1.19 -0.11,0.38 -0.55,0.88 -1,0.69 -1.57,-0.66 -1.46,-1.36 -4.21,-2.38 -0.57,-1.14 -4.7,-4.28 -3.62,-0.06 -4.4,-0.78 -9.89,-6.5 -1.28,-1.93 -0.46,-2.29 0.38,-5.3 -0.84,-1.95 -2.27,-2.74 -0.22,-0.78 -0.46,-0.85 -0.26,-0.67 0.14,-0.48 0.32,-0.27 0.32,-0.18 0.15,-0.23 -0.27,-2.57 -0.05,-0.18 -0.15,-0.34 -0.68,-0.92 -1.19,-11.58 0.02,-1.43 0.11,-0.22 0.13,-0.21 -0.05,-0.47 -0.21,-0.77 -0.22,-0.35 -0.27,-0.23 -0.2,-0.32 0,-0.59 -0.23,0 -2.15,-2.92 -0.45,-1.44 0.37,-1.87 1.91,-3.23 5.81,-6.03 1.27,-2.3 0.01,-2.15 -0.86,-2.29 -0.47,-2.48 0.99,-4.61 0.74,-1.81 3.74,-4 0.21,-0.21 0.54,0.14 0.69,0.41 0.16,0.03 0.26,0.06 0.94,0.03 1.93,0.48 3.01,0.03 1.74,0.68 0.78,0.3 7.13,1.51 2.24,1.02 1.97,0.5 0.33,-0.05 2.26,-0.3 0.59,-0.28 1.76,-1.28 0.66,-0.32 0.44,-0.11 1.32,-0.05 0.82,-0.27 0.36,-0.04 0.46,0.1 3.53,1.58 0.61,0.17 0.61,-0.04 0.73,-0.3 0.55,-0.34 0.52,-0.43 0.47,-0.53 0.39,-0.62 0.96,-1.98 0.45,-0.59 0.61,-0.52 1.97,-1 0.55,-0.54 0.57,-1.32 0.41,-0.65 0.27,-0.21 0.56,-0.31 0.27,-0.22 0.19,-0.27 0.87,-1.51 0.46,-0.54 0.51,-0.43 0.01,0 0.56,-0.26 0.54,-0.02 0.94,0.43 0.51,0.14 0.41,-0.08 2.03,-1.15 0.26,0.86 0.12,0.09 0.04,0.45 0.47,0.53 1.04,0.51 0.5,0.88 0.63,2.66 -0.13,0.87 -0.23,0.79 -0.69,0.96 -2.94,2.02 -2.11,0.29 -1.36,0.79 -1.48,0.28 z\"\r\n                        title=\"East Azarbaijan\" />\r\n                    <path\r\n                        d=\"m 27.10043,6.0744 0,0 0.09,0.12 0.48,0.29 0.14,0.07 0.72,0.14 0.78,0.03 -0.1,0.2 -0.13,0.13 0.71,0.51 0.41,0.95 1.01,4.22 0.42,0.88 0.71,0.63 -0.28,0.53 0.12,0.32 0.86,0.62 0.18,0.04 0.37,-0.01 0.26,0.07 0.12,0.17 0.08,0.2 0.12,0.16 1.2,0.82 0.02,0.01 0.18,0.23 0.11,0.31 0.28,0.46 0.34,0.41 0.32,0.18 0.27,0.42 0.62,1.39 0.2,0.45 0.29,0.43 0.24,0.47 0.35,2.18 0.22,0.66 0.89,-0.28 3.52,1.17 0.09,-0.08 0.24,-0.16 0.3,-0.12 0.32,0.04 0.1,0.27 -0.09,0.41 -0.01,0.38 0.34,0.16 0.47,0.09 0.45,0.29 0.19,0.46 -0.29,0.65 0.23,0.44 0.29,0.22 0.31,0.19 0.32,0.34 0.14,0.34 0.27,0.94 0.17,0.37 0.32,0.24 0.81,0.36 0.16,0.3 -0.07,0.45 -0.14,0.36 -0.1,0.37 0.06,0.47 0.39,0.46 0.72,0.49 0.77,0.38 0.4,0.11 -0.21,0.21 -3.74,4 -0.74,1.81 -0.99,4.61 0.47,2.48 0.86,2.29 -0.01,2.15 -1.27,2.3 -5.81,6.03 -1.91,3.23 -0.37,1.87 0.45,1.44 2.15,2.92 0.23,0 0,0.59 0.2,0.32 0.27,0.23 0.22,0.35 0.21,0.77 0.05,0.47 -0.13,0.21 -0.11,0.22 -0.02,1.43 1.19,11.58 0.68,0.92 0.15,0.34 0.05,0.18 0.27,2.57 -0.15,0.23 -0.32,0.18 -0.32,0.27 -0.14,0.48 0.26,0.67 0.46,0.85 0.22,0.78 2.27,2.74 0.84,1.95 -0.38,5.3 0.46,2.29 1.28,1.93 9.89,6.5 4.4,0.78 3.62,0.06 4.7,4.28 0.57,1.14 4.21,2.38 1.46,1.36 1.57,0.66 1,-0.69 0.55,-0.88 0.11,-0.38 0.5,-1.19 1.11,-1.38 2.03,-1.33 1.68,-0.35 0.82,0.08 0.93,-0.88 1.42,-0.94 1.57,0.26 1.07,1.09 1.35,0.83 1.72,0.39 1.07,0.92 0.15,0.9 -0.44,0.63 1.34,3.92 -0.03,2.82 1.22,1.77 3.3,0.45 8.04,-0.93 4.69,10.52 -0.83,0.26 -1,0.61 -0.14,0.83 0.24,0.69 -0.18,0.66 -0.58,1.16 -1.43,1.66 -2.56,1.13 -3.84,-0.34 -3.51,-0.97 -1.3,-0.9 -0.58,-0.64 -0.68,-0.57 -0.48,-0.64 -0.24,-0.51 -0.4,-0.33 -17.52,1.62 -8.52,-1.22 -2.96,1.18 -0.75,0.97 -0.05,2.03 -1.63,2.48 -5.51,1.78 -1.02,1.11 -0.39,0.67 -0.75,0.77 -0.46,2.04 -1.88,2.14 -0.56,1.37 -1.33,1.33 -1.14,0.7 -0.02,0.02 0,0 -0.75,-0.28 -0.89,0.02 -1.12,0.56 -0.6,0.17 -0.01,0 0,0.01 -0.01,0 0,0 -0.67,0.46 -0.76,0.25 -0.72,-0.1 -0.6,-0.61 -0.01,0 0,-0.01 0,0 0,0 -0.22,-0.68 0.2,-0.86 0.42,-0.86 0.41,-0.67 0.14,-0.84 -0.43,-0.85 -1.05,-1.37 -0.17,-0.88 0.08,-1.93 -0.15,-0.81 -0.5,-0.49 -0.63,-0.49 -0.19,-0.51 0.82,-0.53 -0.64,-0.82 -0.23,-0.73 -0.09,-1.81 -0.16,-0.97 -0.36,-1.06 -0.6,-0.75 -0.86,-0.06 -1.89,0.75 -0.99,0.08 -0.92,-0.43 -0.39,-0.45 -0.12,-0.38 -0.06,-0.41 -0.16,-0.55 -0.27,-0.4 -0.29,-0.29 -0.22,-0.34 -0.03,-0.6 -0.44,-0.47 -0.53,-0.46 -0.12,-0.11 -0.49,-0.63 0.06,-0.67 0.15,-0.11 0.42,-0.16 0.11,-0.08 0.03,-0.89 0.36,-1.44 0.66,-1.53 0.05,-0.79 -0.36,-0.91 -0.82,-1.52 -0.5,-0.68 -0.57,-0.31 -0.44,-0.01 -0.4,-0.13 -0.35,-0.25 -0.31,-0.37 -0.42,-0.37 -0.49,-0.09 -1.05,0.06 -0.88,-0.2 -0.68,-0.45 -0.26,-0.74 0.36,-1.04 1.2,-1.48 0.47,-0.76 0.18,-1.02 -0.16,-0.95 -0.31,-0.69 -0.19,-0.75 0.19,-1.13 0.37,-0.47 0.05,-0.46 -0.22,-0.38 -0.74,-0.39 -0.39,-0.42 -0.23,-0.13 -0.33,0.01 -0.67,0.21 -0.31,-0.07 -0.16,-0.21 -0.17,-0.65 -0.13,-0.27 -0.25,-0.18 -0.25,-0.08 -0.24,-0.11 -0.2,-0.29 -0.27,-0.75 0,-0.41 0.46,-1.23 0.21,-0.82 -0.21,-0.72 -0.32,-0.72 -0.11,-0.86 0.24,-0.76 0.42,-0.36 0.47,-0.27 0.39,-0.52 0.11,-1.38 -0.77,-0.9 -1.95,-1.25 -0.28,-0.58 -0.2,-0.6 -0.31,-0.39 -1.23,0.19 -0.32,-0.36 -0.48,-1.22 -0.52,-0.39 -1.26,-0.12 -0.45,-0.26 -0.21,-0.7 0.45,-1.27 -0.14,-0.72 0,-0.01 -0.18,-0.87 0.07,-1.06 0.22,-1.05 0.31,-0.86 -0.14,-0.73 -0.76,-0.58 -0.68,-0.78 0.15,-1.29 0.28,-0.38 1.17,-0.95 0.35,-0.55 -0.08,-0.4 -1.24,-1.53 -0.85,-0.74 -0.95,-0.43 -0.92,0.1 -0.43,0.25 -0.54,0.19 -0.48,-0.05 -0.25,-0.48 0.03,-0.26 0.13,-0.68 -0.02,-0.22 -0.26,-0.2 -0.22,0.05 -0.23,0.08 -0.26,-0.08 -0.38,-0.49 -0.19,-0.53 -0.13,-0.49 -0.2,-0.4 -0.36,-0.26 -1.22,-0.59 -0.41,-0.12 -2.19,0.26 -1.18,-0.2 -0.59,-0.93 0.09,-0.33 0.05,-0.15 0.35,-0.44 0.3,-0.46 -0.03,-0.55 -0.17,-0.6 0.06,-0.55 0.21,-0.52 0.29,-0.55 0,-0.01 0,0 0,0 0.31,-0.62 0.82,-0.93 0.3,-0.66 0.28,-0.9 0.31,-0.55 0.45,-0.35 0.65,-0.32 0.19,-0.27 -0.28,-0.81 0.05,-0.37 0.28,-0.25 0.6,-0.25 0.25,-0.34 0.22,-0.63 0.21,-0.85 0.12,-0.83 -0.15,-2.07 0.96,-1.09 1.22,-0.96 0.76,-1.1 -0.01,-0.68 -0.26,-0.68 -0.42,-0.59 -0.48,-0.41 -0.53,-0.2 -0.43,0.09 -1.11,0.65 -1.69,-0.31 -0.5,-0.23 -0.31,-0.22 -0.1,-0.38 0.11,-0.71 0.02,-0.39 -0.11,-1.1 0.01,-0.51 0.43,-1.74 0.04,-0.75 -0.31,-2.2 0.15,-1.71 0.01,-0.9 -0.24,-0.72 -0.25,-0.28 -0.26,-0.17 -0.61,-0.2 -0.42,-0.22 0.1,-0.26 0.29,-0.3 0.15,-0.32 -0.17,-0.78 -0.16,-0.52 -0.07,-0.54 0.14,-0.87 0.92,-3.15 -0.17,-1.27 -1.79,-0.87 -0.55,-0.53 -0.46,-0.66 -0.33,-0.97 -0.14,-0.33 -0.12,-0.33 0.02,-0.37 -0.02,-0.39 -0.26,-0.27 -0.31,-0.24 -0.2,-0.31 -0.14,-0.67 -0.11,-0.3 -0.18,-0.3 0,-0.01 0.48,-0.81 0.54,-0.46 0.33,-0.52 -0.31,-1.71 0.17,-0.7 0.67,-1.32 -0.28,-1.07 -1.3,-0.93 -1.51,-0.8 -0.88,-0.67 -0.04,-0.38 0.24,-0.79 -0.03,-0.39 -0.41,-0.87 -0.11,-0.37 -0.02,-0.39 0.09,-0.29 0,-0.32 -0.4,-0.87 -0.2,-0.93 -0.14,-0.42 -0.01,-0.01 -0.89,-1.06 -0.2,-0.53 0.37,-0.53 0.69,-0.43 0.51,-0.19 0.53,-0.01 0.75,0.09 0.78,-0.08 1.84,-0.49 0.81,0.09 2.34,1.17 0.86,0.07 0.75,-0.18 1.75,-0.8 0.65,-0.48 0.57,-0.87 0.01,-0.79 -0.11,-0.83 0.16,-0.98 0,0 0.01,0 0.34,-0.52 0.02,-0.53 -0.12,-0.56 -0.06,-0.62 0.06,-0.72 0.16,-0.59 1.12,-2.27 0.2,-0.56 0.02,-0.17 0.07,-0.53 -0.18,-1.43 0.15,-0.5 3.6,-2.97 0.84,-0.25 0.52,0.37 0.91,1.39 0.47,0.53 2.02,0.95 0.66,0.56 2.75,2 z\"\r\n                        title=\"West Azarbaijan\" />\r\n                    <path\r\n                        d=\"m 189.74043,137.3244 0,0 1.73,-0.07 1.04,0.18 0.73,0.5 3.13,0.63 1.68,-0.3 6.36,-3.46 0.7,-0.24 0.75,-0.4 2.81,-0.63 4.6,0.46 9.03,7.62 1.87,1.02 5.49,4.19 0.39,1.14 0.04,0.84 -8.06,-0.86 -3.84,0.31 -0.98,1.49 1.73,2.38 1.25,1.07 2.4,0.72 1.57,1.35 -1.07,3.62 -1.63,3.39 -0.4,1.54 -1.16,1.11 -6.86,3.35 -1.86,1.8 -0.42,1.63 0.28,1.29 0.86,1.92 0.73,1.21 -1.01,-0.15 -2.02,0.12 -6.07,2.65 -1.56,0.09 -1.87,0.54 -1.75,0.87 -5.96,1.82 -1.42,1.06 -1.02,2.34 -5.94,0.16 -0.83,-0.58 -4.81,-1.22 -0.95,0.25 -4.34,-0.74 -2.31,-1.77 1.03,-1.57 -1.29,-1.62 -2.82,-1.62 -3.7,-0.07 -1.58,0.7 -2.52,-3.71 -4.3,-3.88 -0.1,-1.3 0.71,-0.47 1.06,-0.24 1.45,-0.05 1.23,-0.25 1.89,-1.4 3.07,-0.85 2.22,0.15 3.09,1.43 -0.05,-0.46 0.18,-1.66 2.07,-2.35 3.42,-1.94 6.18,-1.67 0.78,-1.14 -0.54,-4.45 -0.78,-1.74 -1.06,-1.76 -0.56,-2.08 -0.63,-1.15 -0.88,-0.5 -0.64,-0.69 -0.65,-0.36 -1.03,-0.07 -1.68,-0.84 -1.13,-1.71 -1.09,-2.74 -1.82,-2.27 -0.7,-2.67 1.38,-3.2 3.68,-2.46 2.76,-0.95 3.21,1.55 0.06,0.71 0.43,1.35 1.91,2.43 2.06,1.94 4.65,1.39 z\"\r\n                        title=\"Qazvin\" />\r\n                    <path\r\n                        d=\"m 165.12043,111.4344 0,0 5.1,3.26 3.76,3.97 1.44,2.33 2,6.96 -2.76,0.95 -3.68,2.46 -1.38,3.2 0.7,2.67 1.82,2.27 1.09,2.74 1.13,1.71 1.68,0.84 1.03,0.07 0.65,0.36 0.64,0.69 0.88,0.5 0.63,1.15 0.56,2.08 1.06,1.76 0.78,1.74 0.54,4.45 -0.78,1.14 -6.18,1.67 -3.42,1.94 -2.07,2.35 -0.18,1.66 0.05,0.46 -3.09,-1.43 -2.22,-0.15 -3.07,0.85 -1.89,1.4 -1.23,0.25 -1.45,0.05 -1.06,0.24 -0.71,0.47 0.1,1.3 4.3,3.88 2.52,3.71 0.02,0.73 -1.24,1.7 -2.56,0.9 -2.85,-0.7 -2.97,-1.62 -7.27,-0.25 -1.52,-0.95 -1.14,-2.08 -0.3,-0.9 -0.67,-1.14 -0.62,-0.58 -9.32,-5.68 -0.47,-1.11 0.56,-1.51 1.33,-1.4 0.75,-3.07 0,-4.26 -0.64,-2.37 -0.59,-0.07 -0.14,-0.06 -0.04,-0.31 0.11,-0.28 0.14,-0.26 0.05,-0.29 -0.21,-1.02 0.07,-0.37 0.35,-0.33 -0.32,-0.47 -0.38,-0.82 -0.33,-0.94 -0.13,-0.81 -0.23,-0.45 -1.07,-1.19 -0.12,-0.18 -17.06,-3.4 -0.98,-0.99 -4.69,-10.52 -0.2,-1.37 -0.01,-2.05 0.65,-1.33 5.13,-5.22 1.42,-2.37 1.01,-0.74 2.24,-1.07 1.85,-2.01 1.17,-0.7 1.2,-0.5 10.65,-1.24 3.21,0.49 2.2,-0.36 8.1,0.84 2.52,-0.99 1.19,-0.95 0.39,-0.23 0.99,-0.27 1.39,0.51 2.53,2.7 1.05,-0.22 0.45,-0.76 0,-0.72 0.41,-0.73 0.65,-0.26 0.97,0.55 1.22,0.16 1.34,-0.92 1.19,-0.36 2.28,1.22 z\"\r\n                        title=\"Zanjan\" />\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 1.14,2.08 1.52,0.95 7.27,0.25 2.97,1.62 2.85,0.7 2.56,-0.9 1.24,-1.7 -0.02,-0.73 1.58,-0.7 3.7,0.07 2.82,1.62 1.29,1.62 -1.03,1.57 2.31,1.77 4.34,0.74 0.95,-0.25 4.81,1.22 0.83,0.58 -0.02,0.99 0.29,1.48 0.8,1.06 -0.13,1.59 -1.14,1.27 -1.16,-0.21 -0.66,-0.95 0.04,-1.05 -0.08,-0.78 -0.92,0.07 -1.06,1.35 0.64,2.78 1.51,2.52 0.42,1.91 -1.63,1.91 -1.95,0.61 -1.03,0.11 -0.61,0.69 0.09,0.59 0.78,0.76 1.52,0.78 3.64,1 1.73,0.84 1.63,1.93 0.85,2.05 0.73,4.44 -0.82,1.67 -1.49,-0.14 -1.09,-1.01 -1.34,-1.59 -0.51,-1.88 0.72,-1.53 -0.82,-1.19 -2.93,-0.51 -6.16,0.33 -0.85,1.29 0.38,2.4 -0.4,1.46 -0.9,1.47 -0.12,2.89 0.58,3.18 -0.76,0.18 -1.57,-0.76 -3.49,-0.36 -1.18,0.47 0.49,1.16 1.71,0.68 0.58,2.59 0.27,4.33 2.4,4.73 0.54,2.24 0.19,2.24 0.62,2.64 -0.1,0.96 -0.6,0.82 -3.53,3.18 -9.24,-3.95 -2.22,0.25 -1.8,-0.11 -0.88,0.24 -1.78,1.84 -1.01,0.26 -1.25,-0.47 -7.52,-0.91 -14.54,-9.57 -0.7,-1.02 -1.45,-0.94 -0.85,-0.38 0.59,-1.15 1.24,-1.9 3.36,-0.24 3.8,0.81 1.03,-0.85 -0.08,-1.91 0.37,-2.72 -0.34,-1.67 -0.65,-0.99 -0.78,0.17 -1.56,0.69 -2.89,3.02 -0.86,-1.31 -0.5,-1.7 -0.92,-0.49 -1.11,-0.22 -2.49,-1.36 -1.72,-1.4 -0.33,-1.64 0.49,-0.64 1.08,-0.43 3.39,-0.39 1.59,-2.35 1.34,-3.02 1.12,-1.29 0.18,-1.15 -0.02,-0.63 1.03,-0.56 2.08,-0.59 1.23,-0.67 0.38,-1.16 0.63,-0.16 1.09,2.68 0.73,0.39 1.13,-0.99 1.19,-1.91 0.67,-3.09 -0.93,-3.83 -1.93,-1.92 -1.39,-0.87 -1.66,-2.03 -3.65,-8.17 -2.36,-3.5 0.53,-1.05 1.77,-1.99 0.78,-0.08 1.6,3.33 1.05,0.29 1.11,-0.5 0.97,-0.95 2.41,-0.82 0.01,-1.05 -0.4,-0.89 -1,-1.3 -0.6,-1.67 1.22,-0.34 4.99,2.73 z\"\r\n                        title=\"Hamadan\" />\r\n                    <path\r\n                        d=\"m 266.71043,208.9144 0,0 0.45,1.65 -0.09,3.36 -0.91,3.61 -1.49,3.5 -1.13,1.62 -11.42,2.97 -2.62,-0.14 -7.31,0.84 -3.23,1.41 -1.27,1.28 -0.4,1.2 -1.02,8.04 0.71,1.77 0.96,0.51 -7.81,-2.13 -3.49,-1.92 -8.74,-0.82 -2.24,-1.86 -1.57,-1.95 -0.82,-2.04 0.14,-1.68 -0.51,-1.21 -0.99,-1.17 -1,-0.61 -1.36,0.12 -1.23,-0.56 -1.5,-1.35 -1.83,-2.15 0.32,-2.12 3.16,-1.78 0.36,-0.83 -0.7,-0.99 0.05,-2.69 1.93,-1.57 3.05,0.42 2.95,-0.85 2.01,-1.33 4.2,-0.66 3.51,-1.19 0.62,-0.37 0.4,-1.59 0.6,-6.35 1.13,-3.23 0.96,-1.35 0,0.11 9.73,0.11 8.13,2.45 19.31,11.52 z\"\r\n                        title=\"Qom\" />\r\n                    <path\r\n                        d=\"m 226.55043,180.9344 0,0 0.96,-0.2 0.94,-1.92 1.56,-0.14 1.57,1.96 0.87,1.69 0.02,2.91 -2.93,9.49 -0.96,1.35 -1.13,3.23 -0.6,6.35 -0.4,1.59 -0.62,0.37 -3.51,1.19 -4.2,0.66 -2.01,1.33 -2.95,0.85 -3.05,-0.42 -1.93,1.57 -0.05,2.69 0.7,0.99 -0.36,0.83 -3.16,1.78 -0.32,2.12 1.83,2.15 1.5,1.35 1.23,0.56 1.36,-0.12 1,0.61 0.99,1.17 0.51,1.21 -0.14,1.68 0.82,2.04 1.57,1.95 2.24,1.86 8.74,0.82 3.49,1.92 7.81,2.13 -0.4,2.44 -3.23,7.83 -0.91,1.61 -1.94,0.01 -2.13,0.68 -1.9,1.61 -2.12,1.31 -14.11,3.72 -5.38,3.2 -2.81,2.34 -0.3,-0.33 -2.16,-1.17 -0.24,-1.16 0.05,-1.19 -0.73,-0.76 -1.09,-0.84 -0.54,-0.97 -0.76,-0.46 -1.18,0.85 -0.67,1.32 -0.22,1.05 -0.79,0.54 -1.05,-0.83 -1.16,-1.23 -2.55,-1.29 -1.1,-0.94 -0.32,-0.95 0.36,-1.21 0.54,-1.17 -0.04,-1.08 -0.92,-1.58 -1.48,-1.8 -1.86,-0.6 -1.7,0.98 -1.87,0.63 -1.5,0.87 -1.16,3.55 -0.64,0.68 -2.71,1.72 -0.93,-0.35 -3.82,-0.33 -2.24,-0.83 -1.73,-1 -0.44,-0.86 0.18,-0.98 0.28,-0.9 1.36,-3.13 -0.12,-0.93 -0.42,-1.1 0.24,-1.33 0.53,-0.87 3.53,-3.18 0.6,-0.82 0.1,-0.96 -0.62,-2.64 -0.19,-2.24 -0.54,-2.24 -2.4,-4.73 -0.27,-4.33 -0.58,-2.59 -1.71,-0.68 -0.49,-1.16 1.18,-0.47 3.49,0.36 1.57,0.76 0.76,-0.18 -0.58,-3.18 0.12,-2.89 0.9,-1.47 0.4,-1.46 -0.38,-2.4 0.85,-1.29 6.16,-0.33 2.93,0.51 0.82,1.19 -0.72,1.53 0.51,1.88 1.34,1.59 1.09,1.01 1.49,0.14 0.82,-1.67 -0.73,-4.44 -0.85,-2.05 -1.63,-1.93 -1.73,-0.84 -3.64,-1 -1.52,-0.78 -0.78,-0.76 -0.09,-0.59 0.61,-0.69 1.03,-0.11 1.95,-0.61 1.63,-1.91 -0.42,-1.91 -1.51,-2.52 -0.64,-2.78 1.06,-1.35 0.92,-0.07 0.08,0.78 -0.04,1.05 0.66,0.95 1.16,0.21 1.14,-1.27 0.13,-1.59 -0.8,-1.06 -0.29,-1.48 0.02,-0.99 5.94,-0.16 1.02,-2.34 1.42,-1.06 5.96,-1.82 1.75,-0.87 1.87,-0.54 1.56,-0.09 6.07,-2.65 2.02,-0.12 1.01,0.15 1.46,0.34 3.42,0.22 3.32,0.97 1.95,1.76 0.85,0.51 0.35,-0.62 0,-0.7 -1.31,-1.82 0.43,-1.12 1.91,0.02 1.31,1.55 -0.01,2.31 0.24,1.39 z\"\r\n                        title=\"Markazi\" />\r\n                    <path\r\n                        d=\"m 133.80043,3.1044 0,0 0.46,0.12 0.66,0.45 2.07,1.95 5.69,6.85 2.32,2.15 0.96,1.31 0.75,1.59 -0.36,0.11 -0.88,0.29 -1.78,1.2 -2.12,0.43 -1.14,0.59 -0.98,0.94 -0.62,1.24 -0.07,1.51 0.46,1.17 0.83,1.17 1.92,1.88 1.94,0.8 0.51,0.5 1.02,2.2 0.18,0.55 -0.02,0.61 -0.16,0.59 0,0.02 -0.26,0.56 -0.31,0.46 -0.01,0 0,0 0,0.01 0,0 -1.39,0.87 -6.26,1.11 -0.11,0.28 0.01,0.33 -0.1,0.28 -1.78,1.1 -0.31,0.49 0.08,1.79 0.67,1.24 2.2,1.77 4.49,2.22 0.42,0.36 0.09,0.36 0.16,0.63 -0.14,0.85 0.06,0.73 1.65,1.32 0.53,0.79 0.61,0.58 1.04,0.03 1.72,-0.81 0.79,0 0.39,0.94 0.24,1.15 0.44,0.59 0.54,0.49 0.56,0.88 0.57,0.62 0.5,0.72 0.84,1.06 0.44,0.56 0.92,1.55 1.09,1.06 0.17,0.01 0.2,0.45 1.08,0.96 0.7,0.92 0.19,0.81 0.82,0.33 1.28,0.29 0.52,0.56 -0.3,0.79 -7.65,9.11 -0.7,1.66 -0.3,2.28 -1.08,1.68 -0.07,2.35 3.11,8.63 5.62,8.86 1.87,1.93 2.16,1.71 1.14,1.45 0.03,1.22 -0.15,1.86 0.29,2.23 0.37,1.05 -2.28,-1.22 -1.19,0.36 -1.34,0.92 -1.22,-0.16 -0.97,-0.55 -0.65,0.26 -0.41,0.73 0,0.72 -0.45,0.76 -1.05,0.22 -2.53,-2.7 -1.39,-0.51 -0.99,0.27 -0.47,-0.17 -0.47,-0.25 -0.3,0.04 -0.48,-0.97 -0.49,-0.26 -1.15,0.06 -0.51,0.18 -0.3,0.37 -0.26,0 0.17,-0.64 0.09,-0.23 -1.54,-1.26 -0.72,-0.74 -2.08,-1.38 -0.88,-2.08 -0.27,-3.09 -0.9,-0.79 -2.49,-1.3 -0.76,-0.15 -0.21,0.13 -3.31,-2.05 -1.01,-4.68 0.3,-3.9 0.77,-1.63 0.34,-1.19 -0.35,-0.77 -2.27,-2.09 -2.67,-3.66 -1.71,-4.24 -0.21,-3.42 -1.01,-3.16 -2.36,-1.18 -7.61,1.12 -0.99,-0.18 -0.47,-0.35 -1.07,-1.04 -2.16,0.26 -1.63,0.64 -0.4,-1.34 0.16,-2.21 0.69,-1.58 0.86,-1.12 1.07,-2.01 2.71,-1.98 1.42,-1.54 2.3,-0.68 2.43,0.39 1.65,-1.13 -0.64,-2.12 -1.78,-1.01 -0.02,-1.21 1.25,-1.69 0.36,-2.9 -1.96,-4.9 -0.09,-3.28 -0.52,-0.76 0.47,-4.96 -1.34,-0.5 -2.19,1.96 -2.28,1.37 -1.38,-0.12 -2.55,1.73 -3.88,6.77 0.46,0.71 0.51,0.19 -0.42,0.55 -2.12,1.6 -1.28,1.75 -1.42,1.15 -5.07,-1.44 -2.22,0.63 -2.32,1.26 -2.32,0.83 -1.73,-0.95 -0.96,-2.37 0.54,-2.71 1.36,-1.8 0.91,-0.53 0.34,-0.62 1.26,-0.14 1.81,0.44 0.46,-0.41 0.23,-1.21 0.02,-1.27 0.09,-0.66 0.7,-0.05 1.57,1.29 1.48,-0.28 1.36,-0.79 2.11,-0.29 2.94,-2.02 0.69,-0.96 0.23,-0.79 0.13,-0.87 -0.63,-2.66 -0.5,-0.88 -1.04,-0.51 -0.47,-0.53 -0.04,-0.45 -0.12,-0.09 -0.26,-0.86 0.23,-0.13 0.35,-0.42 0.18,-0.33 0.57,-1.66 1.22,-1.96 0.12,-0.44 0.33,-0.37 1.62,-1 3.37,-1.32 0.4,-0.22 1.01,-0.58 1.12,-1.15 0.01,0 1.68,-2.18 1.11,-0.93 1.41,-0.79 2.37,-0.81 0.76,-0.08 0.44,-0.3 1.79,-1.83 0.61,-0.34 4.08,-2.31 1.45,-1.49 0.53,-0.54 0.65,-0.45 0.81,-0.22 2.57,0.05 0.42,-0.11 0.35,-0.32 0.39,-0.59 0.02,0 z\"\r\n                        title=\"Ardebil\" />\r\n                    <path\r\n                        d=\"m 374.13043,563.2144 0,0 -0.27,0.23 -0.28,0.03 -0.19,0.11 -0.32,-0.3 -0.16,0.12 0.02,-0.23 -0.12,-0.23 -0.12,-0.37 0.49,-0.27 0.59,-0.15 0.16,0.26 0.04,0.37 0.16,0.43 z m -16.97,-1.33 0,0 -0.34,0.26 -0.46,-0.11 -0.54,-0.25 -0.14,-0.42 0.44,-0.24 0.81,-0.24 0.17,0.33 0.06,0.67 z m -0.91,-13.27 0,0 -0.19,0.04 -0.39,-0.13 -0.4,-0.21 -0.18,-0.22 -0.05,-0.49 -0.08,-0.38 -0.01,-0.35 0,0 0.14,-0.44 0.21,-0.29 0.28,-0.15 0.33,0.07 0.34,0.37 0.23,0.11 0.19,0.15 0.16,0.2 0.13,0.26 -0.71,1.46 z m -16.2,-9.15 0,0 -0.38,0.21 -2.5,-0.14 -0.26,-0.02 -1.09,-0.53 -0.69,-1.12 0.34,-0.53 0.5,-0.37 0.6,-0.19 0.66,0.03 0.57,0.2 1.26,0.13 0.48,0.19 0,0 0.06,0.17 0.03,0.08 0,0 -0.01,0.34 0,0 0,0.05 0.04,0.26 0,0 0.24,0.13 0.14,0.13 0.09,0.08 0.03,0.22 0.04,0.23 -0.08,0.23 -0.07,0.22 z m 62.36,-4.91 0,0 -0.69,0.4 -0.54,-0.3 0.08,-0.87 0.43,-0.85 0.55,-0.43 0.33,-0.06 0.26,0.4 0.07,0.89 -0.49,0.82 z m -75.53,-1.71 0,0 -0.44,0.44 -0.59,-0.08 -0.6,-0.3 -0.33,-0.47 0.27,-0.41 0.67,-0.03 0.35,0.09 0.4,0.19 0.27,0.57 z m -9.39,-5.09 0,0 -0.49,0.13 -1.3,-0.11 -0.4,0.09 -0.62,0.36 -0.65,0 -1.93,-0.34 -0.59,-0.25 -0.08,-0.05 -0.45,-0.29 -1.06,-0.89 -0.3,-0.35 0.13,-0.17 0.24,-0.05 0.27,-0.1 0.33,-0.02 2.85,0.88 2.54,0.19 0.79,0.31 0.44,0.4 0.28,0.26 z m 101.5,-1.35 0,0 -1.29,0.42 -0.64,-0.26 0.16,-1.01 0.48,-0.7 0.86,-0.39 1.28,-0.13 0.17,1.17 -1.02,0.9 z m -7.04,-2.59 0,0 -0.76,1.7 -0.39,0.66 -1.4,1.43 -0.22,0.51 -0.29,0.31 -1.29,0.65 -0.29,0.35 -0.29,0.19 -1.67,1.61 -0.99,0.58 -0.78,-0.33 -0.74,-0.75 -0.87,-0.69 -2.26,1.17 -0.63,0.54 -0.63,0.36 -0.72,-0.01 -1.54,-0.23 -0.69,0.16 -0.72,0.34 -1.83,1.31 -1.89,0.8 -1.15,0.85 -0.59,0.32 -2.09,0.24 -1.49,0.41 -0.63,0.39 -0.31,0.12 0,0 -0.1,-0.01 -0.19,-0.04 -0.38,-0.13 -0.34,0 -0.15,0.32 -0.15,0.26 -0.37,0.2 -0.42,0.13 -0.31,0.05 0,0 -0.14,-0.1 -0.13,-0.08 -0.17,-0.44 -0.16,-0.93 0.23,-0.67 0.06,-0.43 -0.18,-0.2 -0.34,-1.17 0.37,-0.4 1.59,0.57 0.37,-0.17 0.21,0.06 0.1,0.03 0,0 1.79,-1.01 4.53,-1.47 0.66,-0.08 0.42,-0.17 0.13,-0.05 0,0 1.57,-0.96 0.67,-0.55 2.22,-0.86 0.34,-0.03 0.71,0.06 0.34,-0.03 0.24,-0.11 0.35,-0.29 0.33,-0.12 -0.1,-0.25 -0.15,-0.26 0.52,-0.6 0.12,-0.71 -0.16,-1.7 -0.26,-0.65 -0.58,-0.55 -0.56,-0.44 -0.24,-0.3 0.86,-0.5 4.74,1.79 1.28,-0.3 3.57,-2.31 4.47,-1.02 1.33,-0.02 0.67,0.16 0.87,0.38 0.54,0.41 0.19,0.15 0.27,0.71 -0.54,0.32 -0.55,0.31 -2.09,0.54 -0.75,0.67 z m 10.52,-5.3 0,0 -0.53,0.09 -1.07,-0.41 0.07,-0.96 0.63,-0.87 0.6,-0.12 0.36,0.24 0.39,0.15 0.32,0.26 0.02,0.07 0.11,0.48 -0.13,0.49 -0.32,0.35 -0.24,0.12 -0.21,0.11 z m -30.81,-65.74 0,0 1.52,0.75 1.74,-0.45 6.77,-5.14 3.98,-1.87 1.02,-0.13 0.95,1.41 0.65,14.7 -0.84,2.86 0.71,3.76 3.02,3.91 2.91,2.68 3.48,2.11 4.03,0.62 2.17,-0.39 3.98,-1.97 3.67,-3.49 1.03,-1.27 1.56,-1.23 1.84,0.07 3.53,1.73 0.27,0.62 -0.3,3.93 1.23,5.97 0.49,0.81 0.68,0.57 1.04,0.13 1.76,0.96 1.35,1.76 0.79,1.52 1.54,1.69 1.53,2.33 0.23,1.92 -0.94,0.79 -0.59,1.18 0.77,1.11 0.91,0.46 0.92,1.88 1.02,2.99 1.07,14.26 0.68,2.21 10.47,5.56 2.29,1.69 1.02,0.32 1.6,-1.5 0.81,-1.13 1.39,-0.95 2.23,0.06 2.33,1.4 2.53,2.13 1.99,2.31 0.97,2.1 -0.29,0.72 -2.12,-1.29 -0.73,-0.04 -0.04,0.76 0.82,2.43 0.05,0.96 -0.19,0.63 -0.62,0.76 -0.47,1.17 -0.78,7.39 0.19,1.09 0,1.09 -0.4,2.11 -0.69,0.85 0.06,0.77 4.49,-0.32 2.78,0.5 1.83,-0.17 1.17,-0.55 1.19,0.27 1.3,0.59 2.11,0.33 0.64,0.4 -0.05,0.41 -0.32,0.7 0.08,0.73 0.34,0.84 0.1,1.17 0.57,1.01 1.4,0.32 1.68,0.06 1.45,-0.18 1,-1.05 0.99,-0.25 1.31,0.52 0.93,-0.01 0.49,0.41 1.38,2.09 -0.41,0.22 -0.61,0.93 -0.16,1.21 0.13,0.68 0.46,0.2 1.21,0.76 6.42,5.68 1.09,1.8 0.18,1.36 0.75,0.76 1.02,0.39 0.55,0.68 0.23,0.77 0.46,0.6 0.56,0.56 1.2,2.05 0.28,0.37 0.63,0.31 -0.09,0.6 -0.02,0.57 -0.89,0.39 0.15,0.89 0,0 -1.89,0.29 -1.93,0.92 -0.72,0.16 -0.28,-0.06 -0.25,-0.24 -0.25,-0.16 -0.29,0.07 -0.32,0.14 -0.31,0.09 -0.78,-0.04 -0.67,-0.14 -0.57,-0.24 -0.44,-0.37 -1.56,-2.51 -0.84,-1.01 -1.32,-0.61 -1.18,0.03 -0.31,-0.15 -0.21,-0.36 -0.12,-0.37 -0.19,-0.31 -0.38,-0.12 -2.91,0 -6.15,-1.12 -2.11,0.33 -1.81,-0.12 -0.64,-0.3 0.25,-0.6 -1,0.06 -1.08,0.22 -0.46,0.24 -0.78,0.65 -0.51,0.13 -0.24,-0.1 -0.11,-0.15 -0.17,0.01 -0.39,0.37 -0.27,0.19 -0.35,0.11 -0.3,-0.04 -0.12,-0.26 -0.2,0.09 -1.19,0.83 -1.25,0.2 -1.1,-0.22 -1.07,-0.34 -1.13,-0.18 -0.91,-0.42 -0.74,-1.01 -1.01,-2.16 -1.06,-1.27 -1.28,-0.31 -1.4,0.36 -1.37,0.71 -1.15,0.94 -0.75,0.47 -0.53,-0.01 0.14,-1.66 0.13,-0.43 0.09,-0.18 0.02,-0.14 -0.05,-0.29 -0.35,-0.86 -0.53,-0.47 -0.7,-0.18 -0.85,-0.03 -0.76,0.08 -1.88,0.43 -0.41,-0.08 -0.71,-0.35 -0.39,-0.08 -0.39,0.03 -0.67,0.18 -0.35,0.04 -0.84,-0.07 -2.31,-0.72 0.25,-0.23 -4.53,-0.3 -0.5,-0.27 -0.24,-0.59 -0.19,-1.84 -0.82,-1.91 -0.42,-1.52 -0.29,-0.72 -0.33,-0.31 -0.06,-0.14 -0.75,-0.91 -0.15,-0.03 -0.43,0.07 -0.14,-0.04 -0.06,-0.16 -0.09,-0.44 -0.46,-1.35 -0.14,-0.63 -0.33,-0.74 -0.07,-0.45 0.21,-0.78 1.06,-1.15 0.36,-0.76 -0.46,-1.2 -2.24,-2.48 0.18,-1.01 -0.25,-0.23 -0.19,-1.71 -0.24,-0.85 -0.38,-0.68 -0.65,-0.63 -0.16,-0.28 -0.1,-0.34 -0.12,-0.86 -0.01,-0.35 0.58,-4.72 -0.12,-1.77 -2.2,-8.8 -0.46,-0.68 -1.15,-1 -0.41,-0.6 0.04,-0.62 -1.04,-0.69 -0.35,-0.37 0.5,0.04 0.37,-0.15 0.34,-0.22 0.41,-0.19 -0.29,-0.25 -0.04,-0.36 0.12,-0.37 0.21,-0.31 -1.04,0.45 -0.35,0.07 -0.31,-0.08 -0.2,-0.18 -0.14,-0.18 -0.16,-0.08 -0.18,-0.13 -0.18,-0.25 -0.23,-0.16 -0.66,0.33 -0.2,-0.13 -0.09,-0.31 0.02,-0.39 -0.44,0.1 -0.23,-0.2 0.01,-0.28 0.32,-0.14 0.17,-0.13 0.59,-0.65 0.3,-0.24 0,-0.28 -1,-0.14 -0.81,-0.55 -0.54,-0.79 -0.22,-0.86 -0.39,0.39 -0.44,0.15 -0.91,0.01 -0.51,-0.17 -0.31,-0.36 -0.26,-0.37 -0.32,-0.16 -3.51,-0.05 -0.77,-0.24 -0.23,0.29 -0.82,-0.46 -1.02,-0.21 -2.11,-0.12 -1.01,-0.19 -1.77,-0.71 -1.05,-0.16 -2.1,0.12 -1.07,0.28 -0.78,0.53 -0.72,0.35 -2.21,0.1 -0.89,0.18 -0.28,0.19 -0.56,0.56 -0.11,0.18 -0.07,0.41 -0.19,0.12 -0.26,0.06 -0.29,0.19 -0.58,0.5 -2.28,1.38 -0.82,0.69 -0.01,0.16 -0.18,0.12 -0.62,0.54 -0.37,0.12 -1.51,0.18 -1.4,0.34 -0.36,0.04 -1.13,-0.04 -0.37,0.08 -0.51,0.36 -0.29,0.08 -1.27,0 -1.06,-0.25 -0.34,-0.01 -0.65,0.28 -1.13,1.06 -0.43,0.24 -0.38,0.29 -1.83,2.04 0.49,-0.16 0.21,-0.11 0.25,-0.25 0.13,0.93 -0.2,1.14 -0.4,1.08 -0.48,0.77 -1.11,0.98 -1.27,0.65 -1.42,0.29 -1.52,-0.09 -2.73,-0.95 -1.55,-0.2 -1.29,0.61 -0.4,0.72 -0.18,0.68 -0.33,0.5 -0.82,0.19 -0.67,0.08 -1.48,0.44 -0.51,0.24 -2.21,1.98 -0.38,0.24 -3.25,2.65 -3.68,2.15 -0.23,0.21 -0.22,0.25 -0.25,0.21 -0.35,0.09 -0.43,-0.08 -0.57,-0.34 -0.4,-0.08 -2.91,0.27 -1.49,-0.24 -0.57,-0.86 -0.42,-1.1 -0.99,-0.93 -1.52,-0.3 -3.08,0.12 -1.22,-0.6 -0.61,-0.97 -0.5,-1.21 -0.64,-1.16 -1.01,-0.82 -0.72,-0.14 -0.67,0.11 -0.66,0.19 -2.58,0.17 -0.71,-0.07 -2.32,-0.68 -0.59,-0.1 -0.36,-0.11 -0.65,-0.52 -0.28,-0.14 -0.35,-0.02 -0.7,0.15 -2.23,1.04 -1.56,0.22 -1.37,0.39 -0.75,0.03 -1.51,-0.49 -0.83,-0.07 -0.79,0.43 -0.42,-0.15 -1.76,-1.53 -2.55,-1.51 -3.29,-2.49 -0.48,-0.6 -0.2,-0.74 -0.08,-1.8 -0.27,-0.76 -0.58,-0.7 -1.08,-0.69 -11.52,-3.92 -0.74,-0.07 -0.72,-0.21 -0.46,-0.5 -0.35,-0.61 -0.43,-0.52 -2.02,-0.51 -0.31,-0.38 -0.29,-0.82 -0.69,-0.43 -1.56,-0.46 -2.73,-2.46 -1.2,-0.82 -1.81,-0.8 0.55,-1.07 0.19,-0.23 0.15,0.02 0.69,-0.3 0.37,0.02 2.21,-0.22 0.55,0.02 1.68,0.43 1.58,0.07 0.46,-0.17 1.46,-0.84 0.93,1.79 2.48,2.36 7.55,0.67 1.25,0.5 2.86,2.35 0.57,0.28 0.59,0.08 2.47,-0.63 0.87,0 10.36,1.84 3.53,-1.88 0.92,-1.48 -0.39,-1.12 0.01,-0.42 0.71,-2.09 0.5,-3.03 1.5,-1.83 3.5,-1.22 9.04,-0.83 2.06,0.27 1.6,0.56 1.68,-0.72 3.09,-0.72 9.03,1.28 4.23,-1.29 1.96,-1.87 1.11,-3.39 1.32,-2.1 4.62,-2.49 3.1,-0.8 1.96,0.11 1.02,-0.45 0.77,-0.55 0.58,-0.94 0.21,-2.17 -1.62,-2.65 -2.86,-2.34 -0.16,-1.24 0.16,-1.6 1.71,-6.27 0.4,-4.32 -0.9,-2.42 -10.18,-9.89 -0.18,-1.82 1.11,-0.81 -0.01,-1.09 -1.95,-5.89 2.87,0.21 6.12,1.74 3.03,2.38 1.48,1.94 1.48,1.04 z\"\r\n                        title=\"Hormozgan\" />\r\n                    <path\r\n                        d=\"m 114.44043,243.3144 0,0 0.47,0.64 0.77,1.8 0.3,2 -0.17,1.29 -0.46,0.92 -0.8,0.85 -1.89,1.27 -0.67,0.95 -11.86,3.35 -2.1,2 -0.74,1.84 -0.59,0.07 -0.59,0.25 -0.09,0.62 -0.52,1.57 0.04,0.31 0.53,0.31 0.76,1.35 1.06,0.56 0.89,1.13 0.71,0.26 1.85,1.13 0.35,0.15 0.13,0.34 -0.05,0.41 -0.39,0.71 0.09,0.34 0.45,0.54 0.44,0.39 0.61,0.29 1.28,0.4 0.06,0.11 0.05,0.2 0.11,0.19 0.24,0.08 0.18,-0.04 0.17,-0.19 0.23,-0.04 0.26,0.06 0.19,0.15 0.16,0.19 1.68,1.28 0.6,0.28 0,0.53 0.62,0.63 0.86,0.53 1.44,0.35 4.16,2.1 0.36,0.42 0.19,0.5 0.44,0.14 0.5,0.03 0.38,0.17 0.8,0.95 0.67,1.28 0.44,0.49 0.64,0.19 0.5,0.25 1.1,1.23 3.99,5.25 5.45,11.5 0.67,0.97 0.41,0.39 -3.11,7.27 -2.48,3.43 0.06,2.04 0.4,2.56 -1.21,1.98 -3.54,2.33 -0.9,0.36 -0.08,-0.11 -0.65,-0.27 -0.51,-0.07 -0.3,-0.34 -0.28,-0.41 -0.43,-0.27 -0.53,-0.16 -0.23,-0.18 -0.04,-0.31 0.07,-0.56 0.14,-0.44 0.2,-0.35 0.18,-0.39 0.05,-0.55 -0.18,-0.52 -0.66,-0.51 -0.18,-0.51 -0.33,-0.16 -0.21,-0.23 -0.6,-0.83 -0.13,-0.22 -0.16,-0.22 -1.01,-0.97 -0.15,-0.23 -0.23,-0.54 0.01,-0.2 0.13,-0.15 0.3,-0.74 0.19,-0.23 0.12,-0.26 -0.05,-0.46 -0.19,-0.3 -0.91,-0.69 -0.56,-0.73 -0.38,-0.62 -0.44,-0.5 -0.72,-0.38 -1.92,-0.66 -0.47,-0.03 -1.56,0.86 -0.59,0.22 -1.2,0.13 -1.07,-0.23 -1.03,-0.55 -1.08,-0.79 0,-0.01 -0.01,0 -10.19,-8.91 -1.41,-1.6 -2.21,-1.35 -1.56,-1.26 -0.13,-0.07 -3.16,-1.84 -0.95,-0.95 -3.37,-1.62 -3.6,-1.12 -3.99,0.45 -1.98,-0.24 -0.72,-1.61 0,-0.01 0.41,-0.49 0.57,-0.46 0.5,-0.52 0.22,-0.69 -0.19,-0.55 -0.49,-0.44 -0.64,-0.27 -1.48,-0.17 -0.48,-0.41 0.04,-0.49 0.68,-0.38 0.74,-0.07 0.57,0.04 0.55,-0.11 0.71,-0.54 0.92,-0.91 0.46,-0.57 0.24,-0.51 -0.02,-0.37 -0.39,-0.25 -0.15,-0.38 0.02,-0.33 0.21,-0.77 -0.01,-0.42 -0.3,-0.68 -0.47,-0.49 -1.08,-0.87 -1.35,-1.91 -1.13,-1.1 -0.18,-0.59 -0.02,-0.68 -0.1,-0.82 -0.27,-0.77 -0.39,-0.7 -1.13,-1.42 -0.11,-0.08 -0.1,-0.06 -0.13,-0.08 -0.04,-0.02 -0.18,-0.03 -0.17,0.03 -0.16,0.09 -0.63,0.6 -1.03,0.13 -1,-0.23 -0.58,-0.5 0.53,-0.7 1.6,-0.98 0.42,-0.62 -0.24,-0.89 -0.71,-0.5 -0.6,-0.61 0.13,-1.25 -0.73,0.18 -1.65,0.03 -0.61,0.26 -0.99,0.95 -0.56,0.38 -0.59,0.14 -0.23,-0.28 0.01,-1.44 -0.11,-0.31 0.76,-0.64 0.72,-5.9 1.29,-4.06 0.37,-2.63 -0.47,-1.56 0.62,-0.73 2,0.06 5.25,-0.66 5.07,2.08 2.73,0.2 2.74,0.63 2.27,1.4 2.49,2.16 8.5,2.75 3.96,0.32 5.76,-1.47 5.31,0.24 0.71,-1.39 0.47,-2.64 -0.5,-1.03 -0.93,-1.39 0,-1.25 5.43,-1.26 1.15,0.1 0.56,0.17 z\"\r\n                        title=\"Ilam\" />\r\n                    <path\r\n                        d=\"m 124.87043,230.5444 0,0 0.85,0.38 1.45,0.94 0.7,1.02 14.54,9.57 7.52,0.91 1.25,0.47 1.01,-0.26 1.78,-1.84 0.88,-0.24 1.8,0.11 2.22,-0.25 9.24,3.95 -0.53,0.87 -0.24,1.33 0.42,1.1 0.12,0.93 -1.36,3.13 -0.28,0.9 -0.18,0.98 0.44,0.86 1.73,1 2.24,0.83 3.82,0.33 0.93,0.35 2.71,-1.72 0.64,-0.68 1.16,-3.55 1.5,-0.87 1.87,-0.63 1.7,-0.98 1.86,0.6 1.48,1.8 0.92,1.58 0.04,1.08 -0.54,1.17 -0.36,1.21 0.32,0.95 1.1,0.94 2.55,1.29 1.16,1.23 1.05,0.83 0.79,-0.54 0.22,-1.05 0.67,-1.32 1.18,-0.85 0.76,0.46 0.54,0.97 1.09,0.84 0.73,0.76 -0.05,1.19 0.24,1.16 2.16,1.17 0.3,0.33 -0.76,1.62 -0.14,2.2 0.09,1.75 -3.43,6.9 -0.19,0.95 -0.07,0.75 -0.81,0.48 -5.03,1.42 -1.95,2.3 -0.61,4.78 -1.55,1.17 -2.7,0.9 -0.77,0.5 -0.46,0.82 -0.21,0.97 0.02,0.39 -2.48,0.53 -4.76,-0.46 -7.89,-5.44 -7.5,-0.76 -2.11,-0.65 -1.74,-1.69 -3.51,-1.05 -3.6,0.27 -2.38,0.74 -8.36,0.56 -1.83,1.4 -4.62,12.18 -1.86,2.71 -0.41,-0.39 -0.67,-0.97 -5.45,-11.5 -3.99,-5.25 -1.1,-1.23 -0.5,-0.25 -0.64,-0.19 -0.44,-0.49 -0.67,-1.28 -0.8,-0.95 -0.38,-0.17 -0.5,-0.03 -0.44,-0.14 -0.19,-0.5 -0.36,-0.42 -4.16,-2.1 -1.44,-0.35 -0.86,-0.53 -0.62,-0.63 0,-0.53 -0.6,-0.28 -1.68,-1.28 -0.16,-0.19 -0.19,-0.15 -0.26,-0.06 -0.23,0.04 -0.17,0.19 -0.18,0.04 -0.24,-0.08 -0.11,-0.19 -0.05,-0.2 -0.06,-0.11 -1.28,-0.4 -0.61,-0.29 -0.44,-0.39 -0.45,-0.54 -0.09,-0.34 0.39,-0.71 0.05,-0.41 -0.13,-0.34 -0.35,-0.15 -1.85,-1.13 -0.71,-0.26 -0.89,-1.13 -1.06,-0.56 -0.76,-1.35 -0.53,-0.31 -0.04,-0.31 0.52,-1.57 0.09,-0.62 0.59,-0.25 0.59,-0.07 0.74,-1.84 2.1,-2 11.86,-3.35 0.67,-0.95 1.89,-1.27 0.8,-0.85 0.46,-0.92 0.17,-1.29 -0.3,-2 -0.77,-1.8 -0.47,-0.64 0.59,-0.42 0.49,-0.79 -0.13,-0.31 -0.04,-0.44 0.1,-0.76 -0.06,-0.47 -0.17,-0.33 -0.23,-0.25 -0.21,-0.27 -0.08,-0.4 0.2,-0.58 1.96,-0.97 2.42,-0.12 1.64,-0.85 0.19,-2.3 -0.31,-2.21 0.11,-0.92 0.65,-0.43 0.98,-0.26 2.33,0.31 z\"\r\n                        title=\"Lorestan\" />\r\n                    <path\r\n                        d=\"m 181.96043,293.7144 0,0 2.48,-0.53 1.64,4.07 1.83,0.98 2.95,-0.2 3.39,1.29 1.41,1.91 -0.73,1.12 -0.91,3 0.13,1.18 0.56,2.43 5.1,8.09 1.06,2.69 0.83,1.08 0.84,0.61 0.49,0.56 1.6,0.52 0.56,0.56 0.45,1.06 0.92,3.33 1.02,2.4 1.04,1.65 1.68,1.54 0.66,1.15 2.88,3.11 0.99,2.21 -0.1,1.85 -1.84,2.31 -1.21,2.34 -2.26,3.02 -4.05,3.64 -2.61,1.1 -1.15,0.88 -0.86,1.14 -0.56,1.29 0.03,2.31 1.54,5.59 0.1,1.6 -0.17,0.59 -0.15,1.18 -0.34,1.29 0.23,0.97 5.78,-0.77 1.36,1.76 2.65,2.63 3.23,1.72 1.91,1.39 0.58,2.08 -1.96,4.61 0.24,2.04 1.08,1.23 0.64,2.61 0.58,6.16 -5.23,-0.27 -1.95,-0.95 -3.49,0.58 -2.18,1.09 -0.89,-0.35 -1.22,-0.14 -1.26,0.19 -1.23,0.43 -10.63,6.81 -1.23,0.52 -1.09,-0.24 -0.95,-1.4 -0.09,-0.63 -0.01,-1.77 -0.26,-0.68 -0.25,-0.35 -0.09,-0.22 -0.12,-0.16 -0.37,-0.22 -0.33,-0.14 -0.32,-0.08 -0.73,-0.05 -0.36,0.04 -0.73,0.18 -0.41,0.05 -0.38,-0.08 -0.49,-0.37 -0.28,-0.08 -0.7,0.11 -1.27,0.54 -0.7,0.15 -0.88,-0.07 -0.32,-0.34 0.04,-1.61 -0.1,-0.12 -0.47,-0.34 -0.14,-0.23 -0.02,-0.21 0.02,-0.59 0.05,-0.29 0.14,-0.25 -0.01,-0.25 -0.41,-0.27 -0.2,0.66 -0.35,0.66 -0.49,0.46 -0.58,0.08 -0.61,-0.38 -0.29,-0.5 -0.36,-0.39 -0.59,-0.06 -0.79,-0.27 -2.24,-1.32 -0.46,-0.43 -0.22,-1.27 -0.6,-0.79 -0.89,-0.46 -1.08,-0.28 0.36,-0.65 0.56,-0.15 1.39,0.24 0.72,-0.04 1.12,-0.38 0.62,-0.1 0.69,0.17 1.38,0.74 0.48,0.17 0.75,0.07 0.57,0.24 0.46,0.42 0.44,0.61 0.2,-0.53 0.64,-1.14 1,-1.29 0.19,-0.42 0.03,-0.67 -0.7,0.14 -0.5,-0.32 -0.32,-0.61 -0.26,-1.44 -0.4,0.19 -0.53,0.57 -0.53,0.4 0.05,-0.5 0.05,-0.14 0.13,-0.17 -0.28,-0.44 -0.29,0.07 -0.34,0.26 -0.47,0.11 -0.21,-0.14 -0.37,-0.54 -0.23,-0.12 -0.22,0.04 -0.32,0.18 -0.17,0.05 -0.68,-0.11 -0.61,-0.18 -0.57,-0.03 -0.58,0.32 -1.21,-0.18 -0.97,0.61 -0.24,0.8 0.91,0.4 1.08,0.22 0.84,0.54 0.27,0.7 -0.68,0.69 -0.57,-0.01 -1.83,-0.26 -0.39,0.12 -1.85,1.73 -0.14,0.18 -0.3,0.47 -0.17,0.49 0.39,0.35 -0.14,0.28 -0.22,0.31 -0.12,0.21 0.25,0.84 0.6,0.61 0.68,0.52 0.56,0.61 0.28,0.7 0.22,0.88 0.19,1.76 -0.07,0.5 -0.3,0.8 -0.09,0.44 0.02,0.42 0.19,0.74 0.02,0.45 -0.21,0.77 -0.45,0.7 -0.61,0.49 -0.7,0.2 -2.3,-0.27 -0.59,0.27 -0.66,-0.31 -2.37,0.02 -1.43,-0.8 -0.55,-0.12 -0.09,0.68 0.16,0.46 0.46,0.74 0.09,0.54 -0.1,0.39 -0.25,0.33 -0.31,0.28 -0.29,0.19 -0.77,0.24 -2.49,-0.24 0,-0.27 -0.18,0.24 -0.04,0.1 -0.23,-0.11 -1.05,-0.3 -0.51,-0.31 -0.47,-0.37 -0.22,-0.22 -0.15,-0.26 -0.3,-0.76 -0.07,-0.51 -0.62,-1.95 -0.09,-0.06 -0.2,-0.41 -0.67,-0.76 -0.43,-0.91 -0.06,-0.27 0.07,-0.44 0.27,-0.32 0.32,-0.3 0.25,-0.33 0.09,-0.42 -0.07,-0.43 -0.17,-0.39 -0.22,-0.34 -1.32,-1.2 -1.09,-1.25 -0.69,-1.15 -0.31,-0.27 -0.41,-0.14 -0.43,-0.02 -1.24,0.21 -0.41,0.02 -0.4,-0.06 -0.37,-0.17 -0.27,-0.29 -0.15,-0.38 -0.28,-1.72 -0.31,-0.86 -0.43,-0.77 -0.57,-0.61 -0.35,-0.22 -0.37,-0.13 -3.59,-0.52 -0.05,-1.2 0,0 0.11,-18.98 -0.1,-0.51 -0.37,-0.22 -11.12,0 0.11,-9.56 0.09,-6.8 5.16,-14.07 0.2,-0.9 -0.09,-0.85 -0.47,-0.71 -1.33,-1.01 -0.55,-0.6 -0.12,-0.31 -0.17,-0.69 -0.19,-0.36 -0.26,-0.25 -0.61,-0.4 -0.23,-0.32 -1.22,-2.18 -0.16,-0.7 0,-0.01 -0.33,-0.7 -1.18,-0.58 -0.52,-0.6 -0.77,-1.74 -0.5,-0.72 0.9,-0.36 3.54,-2.33 1.21,-1.98 -0.4,-2.56 -0.06,-2.04 2.48,-3.43 3.11,-7.27 1.86,-2.71 4.62,-12.18 1.83,-1.4 8.36,-0.56 2.38,-0.74 3.6,-0.27 3.51,1.05 1.74,1.69 2.11,0.65 7.5,0.76 7.89,5.44 4.76,0.46 z\"\r\n                        title=\"Khuzestan\" />\r\n                    <path\r\n                        d=\"m 247.35043,358.8644 0,0 -1.16,-0.09 -2.19,0.42 -1.68,1.48 -1.84,0.96 -3.88,-0.51 -1.16,0.02 -12.6,-11.23 -1.04,-0.13 -1.78,0.1 -5.94,-2.39 -2.4,-1.47 1.21,-2.34 1.84,-2.31 0.1,-1.85 -0.99,-2.21 -2.88,-3.11 -0.66,-1.15 -1.68,-1.54 -1.04,-1.65 -1.02,-2.4 -0.92,-3.33 -0.45,-1.06 -0.56,-0.56 -1.6,-0.52 -0.49,-0.56 -0.84,-0.61 -0.83,-1.08 -1.06,-2.69 -5.1,-8.09 -0.56,-2.43 -0.13,-1.18 6.68,-3.61 2.31,0.3 1.21,-0.21 1.06,-0.53 1.51,-0.32 2.07,1.14 2.07,1.72 2.2,0.27 1.67,-0.38 1.04,0.36 1.54,-0.33 3.77,-2.47 1.33,-0.24 4.45,-0.14 1.4,-0.47 0.75,-0.82 1.46,-0.25 1.32,1.15 0.34,1.83 0.33,0.98 0.89,0.23 0.52,0.58 0.29,1.16 0.73,1.17 -0.19,2.91 0.34,3.14 4.3,3.35 1.79,1.81 3.93,2.98 1.77,3.22 0.62,4.15 -1.07,2.11 -1.35,0.94 -0.15,1.23 0.67,1.22 1.02,1.31 0.08,1.21 -1.43,0.63 -1.16,0.82 -0.2,2.13 0.76,4.53 3.09,10.25 -0.09,3.08 -0.34,1.37 z\"\r\n                        title=\"Chahar Mahall and Bakhtiari\" />\r\n                    <path\r\n                        d=\"m 450.32043,261.0144 0,0 8.66,-2.02 1.45,1.85 1.34,2.59 2.53,17.12 2.2,5.05 2.88,1.65 0.81,0.63 2.19,0.99 2.87,1.8 2.74,4.3 0.89,0.64 0.17,3.08 -0.28,1.25 -0.91,1.48 -0.58,1.44 0.24,0.89 0.52,0.93 0.99,1.13 0.06,1.21 1.03,2.25 1.36,2.25 -0.08,2.2 -0.77,2.23 -0.3,1.97 -0.56,1.87 -4.51,6.05 -1.25,3.49 -3.48,5.4 -1.77,4.57 -0.48,0.78 -36.34,-15.66 -4.32,-0.76 -0.73,1.11 -1.56,1.69 -7.04,3.99 -2.4,2.55 -17.98,9.5 -1.5,3.23 -0.44,12.48 -0.51,2.75 -5.74,2.53 -6.38,0.87 -2.78,-0.56 -4.33,-0.17 -19.03,3.38 -2.98,3.33 -1.57,2.98 -0.75,2.87 0.09,1.95 1.89,3.58 2,5.27 0.81,3.92 1.09,1.34 1.09,0.75 -0.43,12.7 0.36,2.22 0.47,1.56 0.04,1.11 -1.07,0.76 -3.42,0.42 -0.34,0.29 -1.49,0.66 -6.88,-3.5 -5.26,-3.96 -0.97,-2.34 -1.2,-8.58 -1.48,-2.62 -5.4,-6.64 -5.63,-10.08 -7.9,-20 -4.35,-5.3 -5.13,-4.72 -8.61,-3.32 -1.48,-5.85 -0.1,-2.76 0.36,-0.99 0.65,-4.83 1.42,-5.62 0.31,-2.57 -0.98,-12.32 0.26,-1.33 1.35,-0.9 2.43,-0.72 2.2,-1.25 1.49,-1.26 2.04,-1.3 3.27,-1.27 2.47,-0.09 10.72,2.47 35.84,-12.38 3.58,-2.04 1.87,-2.28 1.3,-2.46 1.1,-3.01 1.54,-6.78 1.82,-2.26 3.37,-1.81 2.63,-0.28 1.94,-1.36 2.89,-5.03 0.9,-2.88 -0.38,-27.64 0,-0.1 0.6,-0.27 3.11,-0.58 8.68,0.2 3.72,-1.93 12.18,-20.53 13.84,-3.62 13.46,-6.4 8.52,-2.2 3.77,0.99 9.88,7.59 1.16,2.61 -0.46,2.64 -3.28,3.22 -13.42,9.52 -2.31,4.17 -4.26,12.86 -0.28,6.91 2.11,11.75 1.59,2.51 6.72,0.81 z\"\r\n                        title=\"Yazd\" />\r\n                    <path\r\n                        d=\"m 274.35043,171.9044 0,0 2.33,-0.95 4.4,-5.33 3.11,-2.46 2.24,0.3 2.41,1.01 3.05,0.57 3.87,2.1 2.58,0.54 1.79,-0.25 1.09,-0.65 1.47,0.34 3.04,2.11 1.07,4.68 0.44,4.2 -1.09,3.74 -5.38,4.91 -3.36,1.8 -3.86,1.28 -2.74,-0.11 -7.63,-2.22 -2.58,-0.06 -2.47,-0.85 -6.18,-3.78 -1.87,-1.63 -2.02,-0.11 -0.73,-0.26 -0.41,-0.41 -0.63,-0.29 -0.56,0.6 -0.46,3.82 -0.64,2.5 -0.21,1.9 0.26,1.77 3.82,5.08 1.53,2.79 -0.42,2.55 -1.74,2.69 -1.03,3.32 -0.13,1.77 -19.31,-11.52 -8.13,-2.45 -9.73,-0.11 0,-0.11 2.93,-9.49 -0.02,-2.91 -0.87,-1.69 -1.57,-1.96 0.89,-2.07 2.19,-1.35 1.77,-2.18 0.96,-2.53 3.01,-0.17 0.41,-2.02 0.13,-2.7 2.05,-2.36 2.73,-1.01 2.74,0.33 1.91,-1.18 0,-2.36 0.11,-1.77 3.66,2.16 5.19,0.44 4.61,1.81 3.46,3.74 1.96,3.69 1.22,1.4 1.01,0.6 1.66,0.6 2.67,0.16 z\"\r\n                        title=\"Tehran\" />\r\n                    <path\r\n                        d=\"m 409.19043,113.5144 0,0 1.33,-0.23 1.65,0.69 -0.35,0.97 -1.98,0.59 -0.87,0.7 -0.21,0.63 0.22,0.34 0.21,0.45 0.17,1.12 -0.17,2.88 -0.64,2.53 -0.12,0.85 0.63,1.34 4.01,4.51 3.85,3.31 1.9,0.64 3.23,0.55 1.68,0.65 5.16,-0.87 0.67,-0.19 1.08,0.04 1.37,0.82 0.83,3.32 -0.91,3.93 -1.37,2.62 -0.5,4.58 0.64,7.87 1.1,5.06 0.92,2.35 8.03,6.57 2.22,2.56 -0.52,2.91 -5.89,10.15 -1.44,3.35 -1.03,0.81 -7.15,2.69 -3.85,2.3 -4.37,4 -5.44,6.75 -12.18,20.53 -3.72,1.93 -8.68,-0.2 -3.11,0.58 -0.6,0.27 0,0.1 -0.31,-0.4 -0.83,-0.72 -1.86,-0.61 -80.82,2.43 -1.76,-0.28 -14.42,-4.76 -2.31,-0.36 -9.28,0.59 -3.31,-0.55 -6.55,-3.55 1.13,-1.62 1.49,-3.5 0.91,-3.61 0.09,-3.36 -0.45,-1.65 0.13,-1.77 1.03,-3.32 1.74,-2.69 0.42,-2.55 -1.53,-2.79 -3.82,-5.08 -0.26,-1.77 0.21,-1.9 0.64,-2.5 0.46,-3.82 0.56,-0.6 0.63,0.29 0.41,0.41 0.73,0.26 2.02,0.11 1.87,1.63 6.18,3.78 2.47,0.85 2.58,0.06 7.63,2.22 2.74,0.11 3.86,-1.28 3.36,-1.8 5.38,-4.91 1.09,-3.74 -0.44,-4.2 -1.07,-4.68 0.5,-0.22 3.43,-0.38 1.6,-0.45 2.15,-1.24 1.76,-0.6 1.1,0.61 1.69,-0.23 2.59,-0.84 2.4,-1.3 1.47,-1.31 0.8,-1.12 0.42,-1.05 0.78,-1.15 3.47,-3.1 1.34,-1.55 0.54,-3.38 0.75,-2.54 1.2,-2.33 2.54,-2.56 2.82,-1.66 3.41,-1.02 6.63,-0.12 2.65,0.43 2.36,-0.53 4.78,-2.26 2.09,-2.28 5.74,-4.5 5.92,-3.41 2.88,-0.34 12.11,1.66 1.71,-0.81 1.13,-2.92 0.67,-4.64 2.8,-6.23 6.3,-9.73 1.4,-1.15 5.12,6.83 2.41,1.7 z\"\r\n                        title=\"Semnan\" />\r\n                    <path\r\n                        d=\"m 328.44043,127.8244 0,0 0,0 0.05,0.55 0.38,1.05 1.18,2.05 7.48,4.53 3.58,3.7 1.38,2.11 -3.41,1.02 -2.82,1.66 -2.54,2.56 -1.2,2.33 -0.75,2.54 -0.54,3.38 -1.34,1.55 -3.47,3.1 -0.78,1.15 -0.42,1.05 -0.8,1.12 -1.47,1.31 -2.4,1.3 -2.59,0.84 -1.69,0.23 -1.1,-0.61 -1.76,0.6 -2.15,1.24 -1.6,0.45 -3.43,0.38 -0.5,0.22 -3.04,-2.11 -1.47,-0.34 -1.09,0.65 -1.79,0.25 -2.58,-0.54 -3.87,-2.1 -3.05,-0.57 -2.41,-1.01 -2.24,-0.3 -3.11,2.46 -4.4,5.33 -2.33,0.95 -2.67,-0.16 -1.66,-0.6 -1.01,-0.6 -1.22,-1.4 -1.96,-3.69 -3.46,-3.74 -4.61,-1.81 -5.19,-0.44 -3.66,-2.16 -2.2,-2.6 -5.55,-1.23 -1.42,-0.62 -1.29,-1.19 -0.61,-0.89 -2.16,-0.86 -5.59,-1.11 -0.04,-0.84 -0.39,-1.14 -5.49,-4.19 -1.87,-1.02 -9.03,-7.62 1.76,-1.15 2.08,-3.71 0.74,-3.51 1.36,-1.35 1.76,-0.95 1.16,-1.6 0.33,-1.08 0.02,-0.14 0,0 1.61,1.09 0.71,0.17 0.47,0.21 1,1.09 0.5,0.43 5.34,2.92 4.88,3.46 2.84,1.3 9.45,1.88 6.04,1.75 6.26,1.13 6.03,1.75 6.27,-0.83 5.57,-2.05 5.82,-1.44 6.03,-1.15 5.78,-1.18 5.8,-1.73 5.59,-1.73 11.24,-2.53 1.52,-0.25 13.33,-0.76 2.43,-0.59 1.65,-1.39 -0.08,1.61 -1.91,0.67 -2.41,0.3 -1.55,0.48 -0.43,0.21 -0.48,-0.07 -0.91,-0.29 -0.51,0.08 -0.93,0.37 -0.53,0.11 -1.98,-0.27 -1.74,0 0.27,0.48 0.47,0.15 1.12,-0.05 -0.68,0.23 -0.27,0.03 0.82,1.1 1.39,0.61 0.14,0.02 z\"\r\n                        title=\"Mazandaran\" />\r\n                    <path\r\n                        d=\"m 405.42043,74.5244 0,0 4.84,-0.89 1.37,0.18 0.17,0.07 0.22,3.01 -0.22,1.22 0.09,1.56 0.41,1.8 -0.03,1.02 -0.69,2.77 0.07,1.94 1.15,1.37 1.6,0.79 1.38,1.06 0.63,2.61 -1.86,2.6 -3.97,1.38 -0.91,0.14 -1.02,0.46 -1.03,0.95 -2.46,1.02 -2.47,4.4 -1.03,1 -1.4,1.15 -6.3,9.73 -2.8,6.23 -0.67,4.64 -1.13,2.92 -1.71,0.81 -12.11,-1.66 -2.88,0.34 -5.92,3.41 -5.74,4.5 -2.09,2.28 -4.78,2.26 -2.36,0.53 -2.65,-0.43 -6.63,0.12 -1.38,-2.11 -3.58,-3.7 -7.48,-4.53 -1.18,-2.05 -0.38,-1.05 -0.05,-0.55 0,0 5.12,0.45 0.53,0.3 0.58,0.21 4.24,-1.17 0.4,-0.33 0.23,-0.71 0.02,-4.38 -0.19,-0.72 -0.5,-0.29 -0.64,-0.26 0.1,-0.62 0.77,-1.44 -0.81,-1.25 -0.54,-1.56 -0.75,-3.59 -1.03,-2.78 -0.15,-0.6 -0.32,-3.61 9.24,0.81 0.67,-0.04 0.61,-0.26 0.63,-0.6 0.63,-0.42 0.73,-0.04 0.79,0.1 0.74,0 1.21,-0.4 5.73,-3.33 0.77,-0.12 2.06,0.45 0.75,-0.01 0.51,-0.24 0.83,-0.9 0.67,-0.27 0.42,-0.4 1.61,-1.06 0.86,-0.72 0.16,-0.31 0.1,-0.65 0.46,-1.07 0.11,-0.61 0.04,-1.03 -0.04,-0.3 -0.16,-0.28 -0.39,-0.36 -0.12,-0.23 -0.04,-0.9 0.56,-1.33 0.15,-0.85 0.18,-0.68 0.44,-0.71 1.02,-1.11 5.09,-3.51 1.58,-1.78 0.26,-0.44 0.18,-0.59 0.41,-0.22 0.48,-0.08 0.36,-0.14 0.25,-0.33 0.37,-0.78 0.29,-0.33 0.65,-0.22 1.96,-0.38 0.42,-0.16 0.3,-0.68 0.74,-0.41 1.54,-0.52 0.39,-0.06 0.7,-0.57 0.7,-0.36 2.51,-1.95 0.83,-0.34 2.15,-0.09 6.69,-1.41 1.01,0 2.1,0.46 1.32,0.77 0.5,0.17 1.72,0.02 0.57,0.18 0.92,0.49 0.48,0.15 0.52,0.03 z\"\r\n                        title=\"Golestan\" />\r\n                    <path\r\n                        d=\"m 286.04043,345.0244 0,0 2.52,-0.01 11.56,-3.35 0.06,0 8.61,3.32 5.13,4.72 4.35,5.3 7.9,20 5.63,10.08 5.4,6.64 1.48,2.62 1.2,8.58 0.97,2.34 5.26,3.96 6.88,3.5 -0.01,0.77 0.93,3.09 2.75,5.71 0.38,1.5 0.74,1.3 0.81,0.83 1.51,0.96 7.76,0.72 1.97,0.84 6.85,17.02 1.95,5.89 0.01,1.09 -1.11,0.81 0.18,1.82 10.18,9.89 0.9,2.42 -0.4,4.32 -1.71,6.27 -0.16,1.6 0.16,1.24 2.86,2.34 1.62,2.65 -0.21,2.17 -0.58,0.94 -0.77,0.55 -1.02,0.45 -1.96,-0.11 -3.1,0.8 -4.62,2.49 -1.32,2.1 -1.11,3.39 -1.96,1.87 -4.23,1.29 -9.03,-1.28 -3.09,0.72 -1.68,0.72 -1.6,-0.56 -2.06,-0.27 -9.04,0.83 -3.5,1.22 -1.5,1.83 -0.5,3.03 -0.71,2.09 -0.01,0.42 0.39,1.12 -0.92,1.48 -3.53,1.88 -10.36,-1.84 -0.87,0 -2.47,0.63 -0.59,-0.08 -0.57,-0.28 -2.86,-2.35 -1.25,-0.5 -7.55,-0.67 -2.48,-2.36 -0.93,-1.79 -6.77,-4.89 -4.34,-4.09 -4.47,-5.52 -4.59,-10.29 -2.55,-2.99 -1.13,-0.67 -1.5,-0.6 -0.85,-1.4 -4.96,-14.04 -0.78,-3.48 -15.2,-28.66 -3,-2.76 -2.7,-1.01 -2.18,-2.29 -2.39,-3.79 -1.82,-4.18 -2.27,-2.53 -4.65,-1.51 -7.48,-0.56 -1.93,-0.74 -2.07,-4.21 -1.7,-1.7 -0.91,-2.83 0,-2.01 0,-0.1 3.4,-0.84 5.68,0.35 1.44,-0.23 9.04,-5.29 0.72,-1.51 0.04,-2.03 -0.83,-1.39 -0.25,-0.86 0.47,-0.84 -0.07,-0.89 -1.07,-3 -0.56,-3.31 0.51,-0.59 2.76,0.69 3.88,1.89 0.86,0.19 0.76,0.96 1.26,0.77 3.59,0.93 1.88,-0.51 1.67,-0.99 0.86,-0.86 0.19,-0.39 -0.02,-1.88 -1,-4.92 2.57,-0.39 0.95,-0.31 -0.01,-1.27 -0.35,-2.34 0.27,-3.44 2.86,-7.16 0.69,-4.04 0.82,-2.7 -0.98,-2.68 -1.95,-1.49 -1.49,-0.28 -1.33,-0.51 -1.04,-1.06 -0.8,-1.87 0.13,-1.18 3.29,0.79 2.54,-0.36 4.56,-3.1 0.96,-0.43 0.66,-0.89 4.61,-2.54 0.59,0.09 0.52,1.08 0.32,3.68 1.57,1.42 7.54,1.67 z\"\r\n                        title=\"Fars\" />\r\n                    <path\r\n                        d=\"m 273.40043,226.7544 0,0 9.28,-0.59 2.31,0.36 14.42,4.76 1.76,0.28 80.82,-2.43 1.86,0.61 0.83,0.72 0.31,0.4 0.38,27.64 -0.9,2.88 -2.89,5.03 -1.94,1.36 -2.63,0.28 -3.37,1.81 -1.82,2.26 -1.54,6.78 -1.1,3.01 -1.3,2.46 -1.87,2.28 -3.58,2.04 -35.84,12.38 -10.72,-2.47 -2.47,0.09 -3.27,1.27 -2.04,1.3 -1.49,1.26 -2.2,1.25 -2.43,0.72 -1.35,0.9 -0.26,1.33 0.98,12.32 -0.31,2.57 -1.42,5.62 -0.65,4.83 -0.36,0.99 0.1,2.76 1.48,5.85 -0.06,0 -11.56,3.35 -2.52,0.01 -7.54,-1.67 -1.57,-1.42 -0.32,-3.68 -0.52,-1.08 -0.59,-0.09 -4.61,2.54 -0.66,0.89 -0.96,0.43 -4.56,3.1 -2.54,0.36 -3.29,-0.79 -0.13,1.18 0.8,1.87 1.04,1.06 1.33,0.51 1.49,0.28 1.95,1.49 0.98,2.68 -0.82,2.7 -0.69,4.04 -2.86,7.16 -0.27,3.44 0.35,2.34 0.01,1.27 -0.95,0.31 -2.57,0.39 -0.69,-0.67 -4.74,-3.42 -3.65,-3.89 -1.87,-4.85 -0.24,-2.64 0.34,-1.37 0.09,-3.08 -3.09,-10.25 -0.76,-4.53 0.2,-2.13 1.16,-0.82 1.43,-0.63 -0.08,-1.21 -1.02,-1.31 -0.67,-1.22 0.15,-1.23 1.35,-0.94 1.07,-2.11 -0.62,-4.15 -1.77,-3.22 -3.93,-2.98 -1.79,-1.81 -4.3,-3.35 -0.34,-3.14 0.19,-2.91 -0.73,-1.17 -0.29,-1.16 -0.52,-0.58 -0.89,-0.23 -0.33,-0.98 -0.34,-1.83 -1.32,-1.15 -1.46,0.25 -0.75,0.82 -1.4,0.47 -4.45,0.14 -1.33,0.24 -3.77,2.47 -1.54,0.33 -1.04,-0.36 -1.67,0.38 -2.2,-0.27 -2.07,-1.72 -2.07,-1.14 -1.51,0.32 -1.06,0.53 -1.21,0.21 -2.31,-0.3 -6.68,3.61 0.91,-3 0.73,-1.12 -1.41,-1.91 -3.39,-1.29 -2.95,0.2 -1.83,-0.98 -1.64,-4.07 -0.02,-0.39 0.21,-0.97 0.46,-0.82 0.77,-0.5 2.7,-0.9 1.55,-1.17 0.61,-4.78 1.95,-2.3 5.03,-1.42 0.81,-0.48 0.07,-0.75 0.19,-0.95 3.43,-6.9 -0.09,-1.75 0.14,-2.2 0.76,-1.62 2.81,-2.34 5.38,-3.2 14.11,-3.72 2.12,-1.31 1.9,-1.61 2.13,-0.68 1.94,-0.01 0.91,-1.61 3.23,-7.83 0.4,-2.44 -0.96,-0.51 -0.71,-1.77 1.02,-8.04 0.4,-1.2 1.27,-1.28 3.23,-1.41 7.31,-0.84 2.62,0.14 11.42,-2.97 6.55,3.55 3.31,0.55 z\"\r\n                        title=\"Esfahan\" />\r\n                    <path\r\n                        d=\"m 214.02043,435.4644 0,0 -0.34,0.05 -0.34,-0.31 -0.33,-0.85 -0.21,-0.76 -0.25,-0.46 0.4,-0.25 0.37,0.16 0.61,0.27 0.36,0.22 -0.15,0.67 0.1,0.67 -0.22,0.59 z m 34.53,-12.42 0,0 2.18,2.29 2.7,1.01 3,2.76 15.2,28.66 0.78,3.48 4.96,14.04 0.85,1.4 1.5,0.6 1.13,0.67 2.55,2.99 4.59,10.29 4.47,5.52 4.34,4.09 6.77,4.89 -1.46,0.84 -0.46,0.17 -1.58,-0.07 -1.68,-0.43 -0.55,-0.02 -2.21,0.22 -0.37,-0.02 -0.69,0.3 -0.15,-0.02 -0.19,0.23 -0.55,1.07 0,0 -2.63,-1.17 -0.69,-0.73 -0.06,-0.78 0.32,-0.49 0.57,-0.25 0.7,-0.07 0.64,0.02 0.73,-0.08 0.42,-0.37 -0.3,-0.9 -0.54,-0.46 -1.37,-0.53 -0.51,-0.43 -0.27,-0.45 -0.55,-1.25 -0.23,-0.39 -2.54,-2.63 -1.11,-0.88 -1.24,-0.54 -6.04,-1.33 -1.27,-0.64 -4,-3.72 -1.24,-0.84 -1.4,-0.59 -1.61,-0.22 -2.35,0.29 -0.54,-0.17 -0.63,-0.4 -1.21,0.09 -1.31,0.31 -2.12,0.39 -1.33,-0.21 -2.93,-0.61 -0.4,-0.1 -0.17,-0.25 -0.04,-0.37 -0.11,-0.28 -0.18,-0.19 -1.06,-0.15 -1.44,-0.44 -0.73,-0.78 -0.77,-1.31 -0.82,-0.52 -0.26,1.07 -0.69,0.06 -0.67,-2.29 -0.66,-0.96 -0.52,-1.39 -1.28,-2.09 -0.58,-0.55 -0.7,-0.73 -0.17,-0.77 0.75,-2.07 -0.05,-1.02 -0.7,-1.14 -1.18,-1.07 -0.41,-0.5 -1.2,-1.86 -1.11,-1.19 -0.26,-0.39 -2.07,-5.13 -0.28,-1.21 -0.03,-4.91 -0.43,-1.67 -0.76,-1.42 -0.86,-1.02 -1.1,-0.68 -1.42,-0.34 -1.38,-0.07 -0.67,-0.19 -0.29,-0.41 -0.25,-0.76 -1.6,-2.02 -0.27,-0.73 -0.21,-1.07 0.13,-0.96 0.7,-0.41 0.66,0.23 0.67,0.56 0.56,0.7 0.33,0.64 0.35,-0.31 -0.04,-0.28 -0.15,-0.32 0.05,-0.43 0.24,-0.28 0.68,-0.61 0.23,-0.41 0.12,-0.84 -0.09,-0.9 -0.33,-0.56 -0.62,0.16 -0.29,-1.12 -0.23,-0.4 -0.41,-0.35 -0.2,0.04 -0.31,0.17 -0.29,0.09 -0.12,-0.17 -0.04,-0.66 -0.07,-0.32 -0.12,-0.21 -0.81,-0.14 -2.65,0.16 -0.61,0.11 -0.9,0.53 -0.94,-0.11 -0.75,-0.66 -0.3,-1.08 -0.06,-0.94 0.09,-0.48 0.31,-0.46 0.24,-0.53 0.22,-0.64 0.31,-0.29 0.51,0.55 0.15,-1.58 0.08,-0.27 -0.33,-0.11 -0.21,-0.23 -0.41,-0.75 0.24,-0.95 -0.01,-1.51 -0.17,-1.55 -0.27,-1.05 -0.44,-0.81 -0.66,-0.9 -0.52,-0.25 -0.02,1.16 -0.19,-0.43 -0.96,-1.45 -1.79,-1.48 -0.29,-0.5 -0.23,-0.67 -0.54,-0.75 -1.1,-1.12 -2.01,-0.81 -0.3,-0.4 -0.22,-0.78 -0.49,-0.74 -0.91,-1.02 -0.91,-1.32 -1.54,-2.82 -0.81,-1.19 -0.64,-0.56 -1.39,-0.86 -1.32,-1.36 -0.12,-0.18 -0.1,-0.47 -0.03,-0.72 -0.12,-0.41 0.53,-0.06 0.12,-0.23 -0.2,-0.29 -0.45,-0.22 0.36,-1.33 -0.77,-2.21 0.2,-1.03 -0.48,-0.37 -0.53,-0.72 -0.45,-0.79 -0.18,-0.65 -0.2,-0.41 -0.5,-0.34 -0.27,-0.11 -0.01,0 2.18,-1.09 3.49,-0.58 1.95,0.95 5.23,0.27 3.96,1.43 1.26,0.91 0.59,0.56 0,2.01 0.91,2.83 1.7,1.7 2.07,4.21 1.93,0.74 7.48,0.56 4.65,1.51 2.27,2.53 1.82,4.18 2.39,3.79 z\"\r\n                        title=\"Bushehr\" />\r\n                    <path\r\n                        d=\"m 220.02043,349.8844 0,0 1.78,-0.1 1.04,0.13 12.6,11.23 1.16,-0.02 3.88,0.51 1.84,-0.96 1.68,-1.48 2.19,-0.42 1.16,0.09 0.24,2.64 1.87,4.85 3.65,3.89 4.74,3.42 0.69,0.67 1,4.92 0.02,1.88 -0.19,0.39 -0.86,0.86 -1.67,0.99 -1.88,0.51 -3.59,-0.93 -1.26,-0.77 -0.76,-0.96 -0.86,-0.19 -3.88,-1.89 -2.76,-0.69 -0.51,0.59 0.56,3.31 1.07,3 0.07,0.89 -0.47,0.84 0.25,0.86 0.83,1.39 -0.04,2.03 -0.72,1.51 -9.04,5.29 -1.44,0.23 -5.68,-0.35 -3.4,0.84 0,0.1 -0.59,-0.56 -1.26,-0.91 -3.96,-1.43 -0.58,-6.16 -0.64,-2.61 -1.08,-1.23 -0.24,-2.04 1.96,-4.61 -0.58,-2.08 -1.91,-1.39 -3.23,-1.72 -2.65,-2.63 -1.36,-1.76 -5.78,0.77 -0.23,-0.97 0.34,-1.29 0.15,-1.18 0.17,-0.59 -0.1,-1.6 -1.54,-5.59 -0.03,-2.31 0.56,-1.29 0.86,-1.14 1.15,-0.88 2.61,-1.1 4.05,-3.64 2.26,-3.02 2.4,1.47 5.94,2.39 z\"\r\n                        title=\"Kohgiluyeh and Buyer Ahmad\" />\r\n                </clipPath>\r\n            </defs>\r\n            <circle clip-path=\"url(#iran-clip)\" cx=\"0\" cy=\"0\" fill=\"#003366\" id=\"expanding-circle\"\r\n                style=\"transition: r 3s ease\" />\r\n            <g class=\"provinces\" fill=\"white\" stroke=\"black\" stroke-width=\"0.5\">\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M233.21,214.92c.02.13.07.27.14.4.07.13.16.25.26.34s.22.13.35.13h.17v.48h-.17c-.17,0-.33-.05-.48-.15-.15-.1-.27-.23-.36-.38-.14.4-.46.59-.96.59-.15,0-.3-.02-.45-.07-.15-.05-.3-.11-.44-.17-.14-.06-.27-.12-.4-.17-.12-.05-.23-.07-.32-.07-.2,0-.34.07-.43.2-.09.13-.14.33-.17.58-.02.25-.04.56-.04.91,0,.25,0,.46.01.63s.02.38.03.6h-.44c0-.22-.02-.43-.03-.63,0-.19-.01-.39-.01-.58,0-.29,0-.55.02-.81.01-.25.05-.48.11-.67.06-.2.16-.36.29-.49.13-.13.31-.21.55-.24.09-.3.19-.57.31-.82.12-.25.27-.45.46-.59.19-.15.42-.22.7-.22.23,0,.44.05.62.16.18.11.33.25.45.44.12.18.19.39.22.62ZM232.8,215.22c0-.29-.08-.54-.25-.75s-.38-.31-.64-.31c-.2,0-.37.06-.5.19-.13.13-.24.29-.32.48-.08.19-.15.39-.21.58.15.06.31.12.47.19.16.07.31.13.45.18.14.05.26.07.35.07.2,0,.35-.06.47-.18.12-.12.17-.27.17-.46Z\"/>\r\n        <path class=\"cls-1\" d=\"M235.45,215.79c.33,0,.59-.02.79-.07.2-.04.34-.14.42-.3s.13-.39.13-.7c-.14.04-.29.08-.43.11-.14.03-.3.04-.48.04-.4,0-.7-.08-.91-.24-.21-.16-.31-.41-.31-.75,0-.25.05-.49.14-.71.09-.23.23-.42.41-.57.18-.15.4-.22.65-.22s.46.07.63.2c.17.13.31.3.42.52s.18.45.23.71c.05.26.07.51.07.77,0,.36-.03.65-.09.87s-.16.39-.29.51c-.14.12-.32.2-.55.25-.23.04-.52.07-.87.07h-1.44v-.48h1.48ZM235.21,210.81l.4.4-.4.4-.4-.4.4-.4ZM235.93,214.42c.15,0,.29-.01.43-.04.14-.03.28-.06.41-.1-.02-.15-.04-.31-.08-.48-.04-.17-.09-.32-.15-.47-.07-.15-.15-.26-.27-.35-.11-.09-.25-.13-.42-.13-.18,0-.33.05-.44.16-.11.11-.2.24-.25.39-.05.16-.08.31-.08.47,0,.23.08.38.24.45.16.07.36.11.62.11ZM236.29,210.81l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M241.93,209.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM241.42,210.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M241.49,210.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM241.53,211.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M180.73,234.24c-.51,0-.92-.09-1.25-.27-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.11c0-.25.03-.51.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.71c0,.49.14.89.42,1.19.28.3.72.45,1.33.45.35,0,.69-.05.99-.14.31-.09.56-.22.75-.38s.29-.36.29-.57c0-.12-.03-.22-.09-.31-.06-.09-.17-.13-.34-.13h-.63c-.35,0-.59-.09-.73-.27-.13-.18-.2-.4-.2-.67,0-.31.06-.61.19-.88s.31-.49.54-.65c.24-.16.52-.25.86-.25.13,0,.27.02.4.04.13.03.26.08.38.16l-.15.39c-.2-.09-.4-.13-.63-.13-.37,0-.65.13-.84.38-.19.25-.29.56-.29.93,0,.17.04.3.12.36.08.07.2.1.37.1h.64c.32,0,.54.08.66.25s.18.38.18.65c0,.31-.1.58-.31.82-.21.24-.5.42-.87.56-.37.13-.79.2-1.27.2Z\"/>\r\n        <path class=\"cls-1\" d=\"M186.56,232.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24,0,.62-.19,1.14-.53,1.57-.34.43-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17ZM185.16,228.59l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M187.27,228.45c.21.14.44.31.7.49.26.19.51.39.75.61.24.22.44.45.59.7.16.25.23.5.23.76,0,.47-.18.79-.54.98-.36.18-.85.27-1.48.27h-.95v-.48h.95c.31,0,.59-.02.82-.06.24-.04.42-.12.55-.23.13-.11.2-.28.2-.49,0-.2-.07-.39-.21-.58-.14-.19-.31-.38-.52-.57-.21-.18-.42-.36-.65-.53-.22-.17-.43-.32-.6-.46-.07-.06-.14-.13-.21-.2-.06-.07-.1-.15-.1-.23,0-.1.04-.18.11-.25.07-.07.17-.13.29-.18l2.7-1.1v.46l-2.64,1.07Z\"/>\r\n        <path class=\"cls-1\" d=\"M192.34,232.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24,0,.62-.19,1.14-.53,1.57-.34.43-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M195.09,232.36c-.3,0-.56-.08-.78-.23-.22-.15-.43-.33-.64-.53-.14.19-.29.35-.45.47-.16.13-.37.19-.64.19h-.21v-.48h.2c.18,0,.34-.05.46-.15.12-.1.23-.23.33-.39.1-.16.19-.33.28-.51.09-.18.19-.35.3-.51.11-.16.24-.29.4-.39.16-.1.35-.15.58-.15.27,0,.5.06.69.19.2.13.35.3.45.52.11.22.16.46.16.73,0,.39-.1.69-.29.9-.19.21-.47.32-.83.32ZM194.9,230.16c-.17,0-.31.06-.44.17-.13.11-.24.25-.33.4-.09.16-.17.31-.24.46.19.2.38.36.56.48.23.15.44.23.63.23.22,0,.39-.06.51-.18.12-.12.18-.29.18-.52,0-.29-.08-.54-.23-.74-.15-.2-.37-.3-.65-.3Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M200.93,225.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM200.42,226.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M200.49,226.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM200.53,227.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M141.96,211.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6c.11-.25.16-.52.16-.82,0-.27-.03-.54-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75-.15-.32-.23-.69-.23-1.12,0-.25.03-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7-.05.24-.07.47-.07.7,0,.5.14.89.42,1.2.28.3.72.45,1.33.45ZM141.91,207.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M145.71,205.01v5.26h-.43v-5.26h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M149.07,208.99c0-.09-.02-.19-.06-.31s-.08-.22-.13-.33l-.64-1.46.4-.19.84,1.97c.1.24.2.45.28.61.08.17.17.29.28.38s.23.13.39.13h.2v.48h-.2c-.21,0-.38-.03-.5-.1-.13-.07-.23-.16-.32-.28-.08-.12-.17-.25-.25-.4-.13.28-.36.48-.68.6s-.68.18-1.09.18c-.16,0-.3,0-.43-.02-.13-.01-.25-.03-.36-.06v-.47c.13.03.26.05.38.06.12.01.24.02.35.02.29,0,.55-.03.79-.08.23-.05.42-.14.55-.26.13-.12.2-.27.2-.46Z\"/>\r\n        <path class=\"cls-1\" d=\"M150.69,210.27h-.21v-.48h.2c.18,0,.34-.05.46-.15.12-.1.23-.23.33-.39.09-.16.19-.33.28-.51.09-.18.19-.35.3-.51.11-.16.24-.29.4-.39.16-.1.35-.15.58-.15.38,0,.67.12.88.35.21.23.35.53.4.88.04.23.12.44.26.61.14.17.3.25.48.25h.17v.48h-.17c-.17,0-.33-.05-.49-.15-.15-.1-.27-.23-.35-.38-.08.2-.21.35-.37.46s-.38.16-.63.16c-.3,0-.56-.08-.78-.23-.22-.15-.43-.33-.64-.53-.14.19-.29.35-.45.47-.16.13-.37.19-.64.19ZM153.02,208.16c-.17,0-.31.06-.44.17-.13.11-.24.25-.33.4-.09.16-.17.31-.24.46.19.2.38.37.57.49.23.15.43.22.62.22.22,0,.39-.06.51-.18.12-.12.18-.29.18-.52,0-.29-.08-.54-.23-.74-.15-.2-.37-.3-.65-.3Z\"/>\r\n        <path class=\"cls-1\" d=\"M157.23,207.3l.2-.39c.51.22.97.44,1.38.67.42.23.75.46,1,.69.25.24.38.48.38.74,0,.42-.13.73-.39.93-.26.2-.62.3-1.06.3-.27,0-.55-.03-.84-.08-.29-.05-.54-.11-.75-.18-.22.08-.49.15-.8.2-.31.05-.61.08-.9.08h-.39v-.48h.34c.23,0,.44,0,.62-.02.18-.01.38-.03.59-.06-.19-.11-.36-.27-.5-.46-.14-.19-.21-.42-.21-.68,0-.24.06-.46.17-.64.12-.18.27-.32.46-.42.19-.1.41-.15.64-.15.1,0,.21.01.31.04-.08-.03-.17-.07-.25-.1ZM156.34,208.56c0,.23.09.44.26.61.17.17.38.3.61.39.24-.09.44-.22.59-.38.15-.17.23-.37.23-.6,0-.25-.08-.45-.25-.6-.17-.14-.35-.22-.56-.22-.25,0-.46.07-.63.22s-.25.34-.25.58ZM157.69,209.71c.18.03.35.06.51.07.16.02.32.03.48.03.33,0,.59-.06.79-.18.2-.12.29-.32.29-.61,0-.12-.05-.24-.17-.37-.11-.13-.26-.26-.45-.39-.19-.13-.39-.25-.62-.37-.23-.12-.46-.23-.69-.34.17.1.31.24.42.41.11.17.16.36.16.56,0,.3-.07.54-.21.72-.14.19-.31.34-.52.46Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M164.93,203.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM164.42,204.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M164.49,204.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM164.53,205.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M130.98,267.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6c.11-.25.16-.52.16-.82,0-.27-.03-.54-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75-.15-.32-.23-.69-.23-1.12,0-.25.03-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7-.05.24-.07.47-.07.7,0,.5.14.89.42,1.2.28.3.72.45,1.33.45ZM130.93,263.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M134.3,261.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.2-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M135.6,265.79h.74c.34,0,.6-.08.78-.24.18-.16.27-.42.27-.79,0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.73v-.48ZM136.33,262.38l.4.4-.4.4-.4-.4.4-.4ZM137.41,262.38l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M141.39,266.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.26.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22,0-.08-.01-.19-.03-.31l.42-.05.05.7c.02.25.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26.12-.17.18-.41.18-.72,0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.31.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51.02.18.04.36.04.53,0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.38.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M147.3,266.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24,0,.62-.19,1.14-.53,1.57-.34.43-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M147.32,265.79h.3c.36,0,.6-.1.74-.29.13-.19.2-.45.2-.76v-3.74h.43v3.73c0,.51-.11.89-.32,1.14-.22.26-.56.38-1.05.38h-.3v-.48Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M153.93,259.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM153.42,260.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M153.49,260.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM153.53,261.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M240.92,182.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6c.11-.25.16-.52.16-.82,0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75-.15-.32-.23-.69-.23-1.11,0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.19.28.3.72.45,1.33.45ZM240.88,178.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M244.67,176.01v5.26h-.43v-5.26h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M247.72,181.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57-.34.43-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M247.73,181.27v-.48h.92v-.12c0-.29.02-.58.07-.87s.12-.54.22-.77.23-.41.4-.55.36-.21.6-.21c.3,0,.53.11.7.32.17.21.25.48.25.82s-.08.65-.24.93c-.16.28-.38.51-.65.68-.27.17-.57.26-.9.26.03.15.09.32.18.51.09.19.2.37.35.55.15.18.33.33.54.46-.02-.63.08-1.12.31-1.47.22-.35.63-.53,1.22-.53h.18v.48h-.19c-.31,0-.55.05-.71.16-.16.11-.27.27-.33.47-.06.21-.09.45-.09.74,0,.05,0,.11,0,.18,0,.07,0,.14,0,.19l-.35.32c-.45-.24-.8-.54-1.05-.92-.25-.38-.41-.76-.48-1.16h-.96ZM249.93,178.72c-.19,0-.35.09-.48.27-.13.18-.22.41-.28.71-.06.29-.09.62-.09.97v.13c.28,0,.52-.06.73-.18.21-.12.37-.29.49-.5s.18-.45.18-.72c0-.2-.05-.36-.14-.49s-.23-.19-.41-.19Z\"/>\r\n        <path class=\"cls-1\" d=\"M251.72,180.79h.8c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-.81v-.48ZM252.25,177.02l.4.4-.4.4-.4-.4.4-.4ZM253.33,177.02l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M258.47,174.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM257.96,175.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M258.03,175.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM258.07,176.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M260.25,276.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6c.11-.25.16-.52.16-.82,0-.27-.03-.54-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75-.15-.32-.23-.69-.23-1.12,0-.25.03-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7-.05.24-.07.47-.07.7,0,.5.14.89.42,1.2.28.3.72.45,1.33.45ZM260.21,272.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M263.57,270.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.2-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M264.87,275.27v-.48h.92v-.12c0-.29.02-.58.07-.87.05-.28.12-.54.22-.77s.23-.41.4-.55c.16-.14.36-.21.6-.21.3,0,.53.11.7.32.17.21.25.48.25.82s-.08.65-.24.93c-.16.28-.38.51-.65.68-.27.17-.57.26-.9.26.03.15.09.32.18.51.09.19.21.37.35.55.15.18.33.33.54.46-.02-.63.08-1.12.31-1.47s.63-.53,1.22-.53h.18v.48h-.19c-.31,0-.55.05-.71.16-.16.11-.27.27-.33.47-.06.21-.09.45-.09.74,0,.05,0,.11,0,.18,0,.07,0,.14,0,.19l-.35.32c-.45-.24-.8-.54-1.05-.92-.25-.38-.41-.76-.48-1.16h-.96ZM267.07,272.72c-.19,0-.35.09-.48.27-.13.18-.22.41-.28.71-.06.29-.09.62-.09.97v.13c.28,0,.52-.06.73-.18.21-.12.37-.29.49-.5s.18-.45.18-.72c0-.2-.05-.36-.14-.49-.09-.13-.23-.19-.41-.19Z\"/>\r\n        <path class=\"cls-1\" d=\"M272.31,273.55c0,.26-.07.49-.22.69-.15.2-.31.38-.49.53.16.01.34.02.54.02s.36,0,.48,0h.38v.48h-.37c-.13,0-.28,0-.47-.02-.18-.01-.37-.04-.57-.07-.2-.03-.38-.08-.55-.14-.17.07-.35.11-.56.15-.2.03-.4.05-.59.07-.19.01-.35.02-.49.02h-.55v-.48h.55c.13,0,.3,0,.51,0,.21,0,.4-.01.58-.02-.17-.15-.33-.33-.48-.54-.15-.2-.22-.43-.22-.69,0-.2.06-.4.18-.6s.28-.36.47-.49c.19-.13.39-.2.59-.2.22,0,.42.07.62.2.19.13.35.29.47.49s.18.4.18.61ZM271.04,272.71c-.13,0-.26.04-.38.13-.12.09-.23.2-.31.33-.08.13-.12.26-.12.39,0,.15.04.29.13.44.09.14.2.27.32.38.13.11.24.2.35.26.13-.06.26-.15.39-.26.13-.11.23-.24.32-.38.08-.14.13-.29.13-.45,0-.12-.04-.25-.12-.38-.08-.13-.19-.24-.32-.33-.13-.09-.26-.13-.39-.13ZM271.01,270.61l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M275.02,274.71c.26-.45.54-.85.82-1.2.28-.35.58-.63.89-.84.31-.21.63-.31.97-.31.27,0,.52.06.73.18.21.12.38.28.5.48.12.2.18.43.18.68,0,.39-.11.7-.34.93-.23.23-.55.39-.97.49-.42.1-.9.15-1.46.15h-.34c-.47,0-.85-.04-1.13-.12-.28-.08-.48-.26-.6-.52-.13.22-.28.38-.47.49-.19.1-.44.16-.76.16h-.2v-.48h.2c.37,0,.63-.09.78-.26s.22-.42.22-.74c0-.11,0-.21,0-.3,0-.09-.01-.19-.02-.31l.42-.05.05.8c.02.21.07.39.15.53.08.14.21.22.38.25ZM277.73,272.83c-.28,0-.55.09-.81.28-.26.18-.51.42-.75.72-.24.3-.47.62-.69.96h.84c.44,0,.84-.03,1.19-.09.35-.06.63-.16.83-.31.21-.15.31-.37.31-.65s-.09-.48-.26-.66c-.17-.17-.4-.26-.66-.26Z\"/>\r\n        <path class=\"cls-1\" d=\"M280.63,270.01v5.26h-.43v-5.26h.43Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M285.57,268.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM285.06,269.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M285.13,269.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM285.17,270.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M349.99,185.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6c.11-.25.16-.52.16-.82,0-.27-.03-.54-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75-.15-.32-.23-.69-.23-1.12,0-.25.03-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7-.05.24-.07.47-.07.7,0,.5.14.89.42,1.2.28.3.72.45,1.33.45ZM349.94,181.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M353.31,179.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.2-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M356,182.18l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.37v-.48h.37c.34,0,.6-.08.78-.24.18-.16.27-.42.27-.79,0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28ZM355.95,180.36l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M357.51,184.27h-.21v-.48h.2c.18,0,.34-.05.46-.15.12-.1.23-.23.33-.39.09-.16.19-.33.28-.51.09-.18.19-.35.3-.51.11-.16.24-.29.4-.39.16-.1.35-.15.58-.15.38,0,.67.12.88.35.21.23.35.53.4.88.04.23.12.44.26.61.14.17.3.25.48.25h.17v.48h-.17c-.17,0-.33-.05-.49-.15-.15-.1-.27-.23-.35-.38-.08.2-.21.35-.37.46s-.38.16-.63.16c-.3,0-.56-.08-.78-.23-.22-.15-.43-.33-.64-.53-.14.19-.29.35-.45.47-.16.13-.37.19-.64.19ZM359.85,182.16c-.17,0-.31.06-.44.17-.13.11-.24.25-.33.4-.09.16-.17.31-.24.46.19.2.38.37.57.49.23.15.43.22.62.22.22,0,.39-.06.51-.18.12-.12.18-.29.18-.52,0-.29-.08-.54-.23-.74-.15-.2-.37-.3-.65-.3Z\"/>\r\n        <path class=\"cls-1\" d=\"M364.62,184.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.26.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22,0-.08-.01-.19-.03-.31l.42-.05.05.7c.02.25.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26.12-.17.18-.41.18-.72,0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.31.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51.02.18.04.36.04.53,0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.38.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M372.5,177.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM372,178.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M372.07,178.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM372.1,179.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M383.61,306.8c.31,0,.59-.03.83-.08.24-.05.43-.15.57-.28.14-.13.21-.31.21-.54,0-.3-.14-.6-.43-.89-.29-.29-.67-.57-1.14-.83l.21-.41c.56.29,1,.61,1.32.97.32.36.48.74.48,1.13,0,.49-.17.84-.51,1.05-.34.21-.83.32-1.48.32-.29,0-.56-.02-.83-.07v-.47c.29.05.55.08.77.08Z\"/>\r\n        <path class=\"cls-1\" d=\"M388.42,307.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24,0,.62-.19,1.14-.53,1.57-.34.43-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17ZM387.02,303.59l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M388.44,306.79h1.11c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.02-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-1.12v-.48ZM388.92,308.03l.4.4-.4.4-.4-.4.4-.4ZM390,308.03l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M395.5,300.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM395,301.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M395.07,301.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM395.1,302.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M427.64,410.53c.43,0,.77-.07,1.01-.22s.42-.35.53-.6c.11-.25.16-.52.16-.82,0-.27-.03-.55-.1-.82s-.14-.53-.22-.76l.43-.18c.1.3.18.6.24.89.05.29.08.57.08.84,0,.41-.07.78-.22,1.1s-.37.58-.69.76-.72.28-1.23.28-.89-.09-1.2-.27-.54-.43-.69-.75-.22-.69-.22-1.12c0-.25.02-.5.07-.77s.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7-.05.24-.07.47-.07.7,0,.5.13.89.4,1.2s.69.45,1.28.45ZM427.6,406.25l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M430.84,404.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M434.71,409.36c-.29,0-.54-.08-.75-.23-.21-.15-.42-.33-.62-.53-.14.19-.28.35-.44.47-.15.13-.36.19-.62.19h-.2v-.48h.19c.18,0,.32-.05.44-.15.12-.1.22-.23.32-.39.09-.16.18-.33.27-.51.09-.18.18-.35.29-.51s.24-.29.39-.39.33-.15.56-.15c.26,0,.48.06.67.19.19.13.33.3.43.52s.15.46.15.73c0,.39-.09.68-.28.9s-.45.32-.79.32ZM434.53,407.16c-.16,0-.3.06-.42.17-.12.11-.23.25-.32.4-.09.16-.17.31-.23.46.18.2.36.36.54.48.22.15.43.23.61.23.21,0,.38-.06.49-.18.12-.12.17-.29.17-.52,0-.29-.07-.54-.22-.74s-.35-.3-.62-.3Z\"/>\r\n        <path class=\"cls-1\" d=\"M438.44,409.27c-.19,0-.34-.03-.46-.1-.12-.07-.21-.15-.28-.24-.01.62-.18,1.14-.51,1.57s-.79.71-1.39.85l-.14-.4c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65s-.1-.46-.17-.71l.41-.14.18.7c.05.22.15.39.27.51s.29.18.51.18h.18v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M439.12,405.45c.2.14.42.31.67.49s.49.39.72.61.42.45.57.7c.15.25.22.5.22.76,0,.47-.17.79-.51.98-.34.18-.82.27-1.42.27h-.92v-.48h.91c.3,0,.56-.02.79-.06s.4-.12.53-.23c.13-.11.19-.28.19-.49,0-.2-.07-.39-.2-.58s-.3-.38-.5-.57-.41-.36-.63-.53c-.22-.17-.41-.32-.58-.46-.07-.06-.14-.13-.2-.2s-.09-.15-.09-.23c0-.1.03-.18.1-.25.07-.07.16-.13.27-.18l2.6-1.1v.46l-2.54,1.07Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M446.5,402.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM446,403.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M446.07,403.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM446.1,404.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M536.05,495.53c.43,0,.77-.07,1.01-.22s.42-.35.53-.6c.11-.25.16-.52.16-.82,0-.27-.03-.55-.1-.82s-.14-.53-.22-.76l.43-.18c.1.3.18.6.24.89.05.29.08.57.08.84,0,.41-.07.78-.22,1.1s-.37.58-.69.76-.72.28-1.23.28-.89-.09-1.2-.27-.54-.43-.69-.75-.22-.69-.22-1.12c0-.25.02-.5.07-.77s.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7-.05.24-.07.47-.07.7,0,.5.13.89.4,1.2s.69.45,1.28.45ZM536.01,491.25l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M539.25,489.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M540.5,493.79h.71c.33,0,.58-.08.75-.24s.25-.42.26-.79c0-.11,0-.22,0-.31s-.01-.19-.02-.28l.4-.05.05.79c.02.28.1.5.25.65s.33.22.55.22h.15v.48h-.15c-.28,0-.5-.07-.67-.22s-.28-.3-.34-.45c-.1.23-.26.4-.48.51-.22.11-.47.16-.75.16h-.71v-.48ZM541.2,490.38l.39.4-.39.4-.38-.4.38-.4ZM542.23,490.38l.39.4-.39.4-.38-.4.38-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M548.03,494.27c-.27,0-.48-.06-.62-.19s-.25-.29-.32-.48c-.1.21-.24.38-.4.5s-.38.18-.63.18c-.3,0-.52-.06-.68-.19-.16-.12-.27-.29-.35-.49-.11.23-.26.4-.44.51s-.46.17-.81.17h-.35v-.48h.35c.35,0,.61-.07.78-.22.17-.15.26-.4.26-.76,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.02.25.09.45.23.62s.33.25.59.25c.3,0,.5-.09.62-.26.12-.17.17-.41.17-.72,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.01.24.08.44.19.61.11.17.29.26.54.26s.41-.09.51-.27.16-.42.16-.71c0-.09,0-.17,0-.27s-.01-.2-.02-.33l.4-.05.05.76c.02.26.1.47.24.63s.33.24.56.24h.17v.48h-.17c-.25,0-.46-.06-.63-.17s-.28-.29-.34-.51c-.08.22-.18.38-.32.51s-.34.18-.59.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M549.94,493.79h.64c.32,0,.62-.03.9-.1.28-.07.55-.16.81-.27.26-.11.53-.24.81-.38.28-.14.57-.28.89-.41-.21-.07-.43-.15-.64-.24-.21-.09-.42-.17-.61-.26s-.36-.15-.51-.21-.26-.08-.34-.08c-.18,0-.33.05-.45.15s-.24.21-.34.34l-.07.09-.38-.19.04-.07c.16-.24.33-.43.52-.57.19-.14.42-.21.67-.21.14,0,.32.05.54.14.22.09.46.2.73.33s.53.24.8.34.53.17.77.19v.47c-.18.04-.39.11-.62.21-.23.09-.52.24-.88.42-.34.17-.66.32-.94.44s-.56.21-.84.27-.57.09-.89.09h-.63v-.48ZM551.97,494.9l.38.39-.38.39-.37-.39.37-.39ZM552.52,495.78l.37.38-.37.39-.37-.39.37-.38ZM553.07,494.9l.37.39-.37.39-.37-.39.37-.39Z\"/>\r\n        <path class=\"cls-1\" d=\"M556.7,491.65c.3,0,.55.1.74.29s.33.45.42.78c.09.32.14.68.14,1.08h.56v.48h-.6c-.08.52-.29.95-.63,1.31-.33.35-.85.61-1.56.77l-.15-.41c.56-.13,1-.33,1.33-.59s.53-.62.61-1.07h-.71c-.43,0-.75-.08-.98-.26s-.33-.45-.33-.83c0-.25.04-.49.13-.73.09-.24.22-.43.39-.58.17-.15.38-.23.63-.23ZM556.82,493.79h.77c-.01-.3-.05-.58-.1-.84-.06-.25-.15-.46-.27-.61-.12-.15-.3-.23-.53-.23-.18,0-.32.06-.43.17s-.18.25-.23.41-.07.32-.07.47c0,.23.07.4.22.49.15.09.36.14.63.14Z\"/>\r\n        <path class=\"cls-1\" d=\"M559.6,492.68v-3.67h.41v3.68c0,.31.06.57.18.78.12.21.33.32.63.32h.17v.48h-.17c-.28,0-.5-.07-.66-.2-.16-.13-.28-.3-.35-.49-.11.24-.24.41-.4.52s-.4.16-.72.16h-.29v-.48h.29c.35,0,.58-.1.71-.3.13-.2.19-.47.2-.82Z\"/>\r\n        <path class=\"cls-1\" d=\"M560.85,493.79h.68c.29,0,.49-.08.59-.25s.16-.39.16-.67c0-.15-.01-.32-.04-.5-.02-.18-.05-.36-.08-.54l.44-.12c.08.38.11.73.11,1.07,0,.45-.09.81-.26,1.08-.17.27-.48.4-.91.4h-.69v-.48ZM561.62,495.01l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M568.09,493.72c0,.75-.19,1.34-.57,1.76-.38.42-.93.71-1.65.87l-.15-.41c.61-.14,1.07-.36,1.38-.64.31-.28.5-.66.57-1.14-.12.04-.24.07-.38.09-.14.03-.27.04-.4.04-.4,0-.71-.09-.93-.26-.22-.17-.33-.45-.33-.84,0-.25.04-.49.13-.73.09-.24.22-.43.39-.58.17-.15.38-.23.64-.23s.44.06.61.19c.17.12.3.29.4.49s.17.43.22.67.07.49.07.72ZM566.92,493.82c.13,0,.26-.01.39-.04.13-.02.26-.06.38-.09,0-.26-.04-.51-.1-.76-.05-.24-.15-.44-.27-.59-.13-.15-.3-.23-.52-.23-.18,0-.32.06-.43.17-.11.11-.19.25-.23.41s-.07.32-.07.47c0,.24.08.41.23.51.15.1.36.15.63.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M573.12,495.53c.43,0,.77-.07,1.01-.22s.42-.35.53-.6c.11-.25.16-.52.16-.82,0-.27-.03-.55-.1-.82s-.14-.53-.22-.76l.43-.18c.1.3.18.6.24.89.05.29.08.57.08.84,0,.41-.07.78-.22,1.1s-.37.58-.69.76-.72.28-1.23.28-.89-.09-1.2-.27-.54-.43-.69-.75-.22-.69-.22-1.12c0-.25.02-.5.07-.77s.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7-.05.24-.07.47-.07.7,0,.5.13.89.4,1.2s.69.45,1.28.45ZM573.07,491.25l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M576.31,489.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M577.56,493.79h.71c.33,0,.58-.08.75-.24s.25-.42.26-.79c0-.11,0-.22,0-.31s-.01-.19-.02-.28l.4-.05.05.79c.02.28.1.5.25.65s.33.22.55.22h.15v.48h-.15c-.28,0-.5-.07-.67-.22s-.28-.3-.34-.45c-.1.23-.26.4-.48.51-.22.11-.47.16-.75.16h-.71v-.48ZM578.26,490.38l.39.4-.39.4-.38-.4.38-.4ZM579.3,490.38l.39.4-.39.4-.38-.4.38-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M585.1,494.27c-.27,0-.48-.06-.62-.19s-.25-.29-.32-.48c-.1.21-.24.38-.4.5s-.38.18-.63.18c-.3,0-.52-.06-.68-.19-.16-.12-.27-.29-.35-.49-.11.23-.26.4-.44.51s-.46.17-.81.17h-.35v-.48h.35c.35,0,.61-.07.78-.22.17-.15.26-.4.26-.76,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.02.25.09.45.23.62s.33.25.59.25c.3,0,.5-.09.62-.26.12-.17.17-.41.17-.72,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.01.24.08.44.19.61.11.17.29.26.54.26s.41-.09.51-.27.16-.42.16-.71c0-.09,0-.17,0-.27s-.01-.2-.02-.33l.4-.05.05.76c.02.26.1.47.24.63s.33.24.56.24h.17v.48h-.17c-.25,0-.46-.06-.63-.17s-.28-.29-.34-.51c-.08.22-.18.38-.32.51s-.34.18-.59.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M587.21,495.03l.39.4-.39.4-.38-.4.38-.4ZM587,493.79h.56c.33,0,.58-.08.75-.24.17-.16.25-.42.26-.79,0-.11,0-.22,0-.31s-.01-.19-.02-.28l.4-.05.05.79c.02.28.1.5.25.65.15.15.34.22.55.22h.15v.48h-.15c-.28,0-.5-.07-.67-.22-.17-.15-.28-.3-.34-.45-.1.23-.26.4-.48.51-.22.11-.47.16-.75.16h-.56v-.48ZM588.25,495.03l.39.4-.39.4-.38-.4.38-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M592.42,494.27c-.3,0-.52-.06-.68-.19-.16-.12-.27-.29-.35-.49-.11.23-.26.4-.44.51s-.46.17-.81.17h-.35v-.48h.35c.35,0,.61-.07.78-.22.17-.15.26-.4.26-.76,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.02.25.09.45.23.62s.33.25.59.25c.3,0,.5-.09.62-.26.12-.17.17-.41.17-.72,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.01.24.08.44.19.61.11.17.29.26.54.26s.42-.09.51-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53s-.06-.33-.09-.46l.42-.12c.04.16.08.33.1.51s.03.36.03.53c0,.25-.03.49-.1.72-.07.22-.18.4-.34.54-.16.14-.37.21-.64.21-.27,0-.48-.06-.62-.19s-.25-.29-.32-.48c-.1.21-.24.38-.4.5s-.38.18-.63.18Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M600.5,487.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM600,488.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M600.07,488.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM600.1,489.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M396.15,501.53c.43,0,.77-.07,1.01-.22s.42-.35.53-.6c.11-.25.16-.52.16-.82,0-.27-.03-.55-.1-.82s-.14-.53-.22-.76l.43-.18c.1.3.18.6.24.89.05.29.08.57.08.84,0,.41-.07.78-.22,1.1s-.37.58-.69.76-.72.28-1.23.28-.89-.09-1.2-.27-.54-.43-.69-.75-.22-.69-.22-1.12c0-.25.02-.5.07-.77s.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7-.05.24-.07.47-.07.7,0,.5.13.89.4,1.2s.69.45,1.28.45ZM396.11,497.25l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M399.35,495.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M401.27,496.45c.2.14.42.31.67.49s.49.39.72.61.42.45.57.7c.15.25.22.5.22.76,0,.47-.17.79-.51.98-.34.18-.82.27-1.42.27h-.92v-.48h.91c.3,0,.56-.02.79-.06s.4-.12.53-.23c.13-.11.19-.28.19-.49,0-.2-.07-.39-.2-.58s-.3-.38-.5-.57-.41-.36-.63-.53c-.22-.17-.41-.32-.58-.46-.07-.06-.14-.13-.2-.2s-.09-.15-.09-.23c0-.1.03-.18.1-.25.07-.07.16-.13.27-.18l2.6-1.1v.46l-2.54,1.07ZM400.98,495.57v-.31l2.8-1.18v.31l-2.8,1.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M406.14,500.27c-.19,0-.34-.03-.46-.1-.12-.07-.21-.15-.28-.24-.01.62-.18,1.14-.51,1.57s-.79.71-1.39.85l-.14-.4c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65s-.1-.46-.17-.71l.41-.14.18.7c.05.22.15.39.27.51s.29.18.51.18h.18v.48h-.17ZM404.79,496.59l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M408.78,500.36c-.29,0-.54-.08-.75-.23-.21-.15-.42-.33-.62-.53-.14.19-.28.35-.44.47-.15.13-.36.19-.62.19h-.2v-.48h.19c.18,0,.32-.05.44-.15.12-.1.22-.23.32-.39.09-.16.18-.33.27-.51.09-.18.18-.35.29-.51s.24-.29.39-.39.33-.15.56-.15c.26,0,.48.06.67.19.19.13.33.3.43.52s.15.46.15.73c0,.39-.09.68-.28.9s-.45.32-.79.32ZM408.6,498.16c-.16,0-.3.06-.42.17-.12.11-.23.25-.32.4-.09.16-.17.31-.23.46.18.2.36.36.54.48.22.15.43.23.61.23.21,0,.38-.06.49-.18.12-.12.17-.29.17-.52,0-.29-.07-.54-.22-.74s-.35-.3-.62-.3Z\"/>\r\n        <path class=\"cls-1\" d=\"M412.51,500.27c-.19,0-.34-.03-.46-.1-.12-.07-.21-.15-.28-.24-.01.62-.18,1.14-.51,1.57s-.79.71-1.39.85l-.14-.4c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65s-.1-.46-.17-.71l.41-.14.18.7c.05.22.15.39.27.51s.29.18.51.18h.18v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M414.61,497.3l.2-.39c.49.22.93.44,1.33.67s.72.46.97.69.36.48.36.74c0,.42-.13.73-.38.93s-.59.3-1.02.3c-.26,0-.53-.03-.81-.08-.28-.05-.52-.11-.72-.18-.21.08-.47.15-.77.2s-.59.08-.86.08h-.37v-.48h.32c.22,0,.42,0,.59-.02s.36-.03.56-.06c-.18-.11-.34-.27-.48-.46-.13-.19-.2-.42-.2-.68s.05-.46.17-.64.26-.32.44-.42.39-.15.62-.15c.1,0,.2.01.3.04-.08-.03-.16-.07-.24-.1ZM413.74,498.56c0,.23.08.44.25.61s.36.3.59.39c.23-.09.42-.22.57-.38s.22-.37.22-.6c0-.25-.08-.45-.24-.6s-.34-.22-.54-.22c-.25,0-.45.07-.61.22-.16.14-.24.34-.24.58ZM415.04,499.71c.17.03.33.06.49.07.15.02.31.03.46.03.32,0,.57-.06.76-.18s.28-.32.28-.61c0-.12-.05-.24-.16-.37s-.25-.26-.43-.39c-.18-.13-.38-.25-.6-.37-.22-.12-.44-.23-.67-.34.17.1.3.24.4.41.1.17.16.36.16.56,0,.3-.07.54-.2.72-.14.19-.3.34-.5.46Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M422.5,493.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM422,494.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M422.07,494.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM422.1,495.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M265.6,152.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM265.55,148.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M269.35,146.01v5.26h-.43v-5.26h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M269.66,153.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M274.79,149.99c0-.09-.02-.19-.06-.31s-.08-.22-.13-.33l-.64-1.46.4-.19.84,1.97c.1.24.2.45.28.61s.17.29.28.38.23.13.39.13h.2v.48h-.2c-.21,0-.38-.03-.5-.1-.13-.07-.23-.16-.32-.28-.08-.12-.17-.25-.25-.4-.13.28-.36.48-.68.6s-.68.18-1.09.18c-.16,0-.3,0-.43-.02-.13-.01-.25-.03-.36-.06v-.47c.13.03.26.05.38.06.12.01.24.02.35.02.29,0,.55-.03.79-.08.23-.05.41-.14.55-.26.13-.12.2-.27.2-.46Z\"/>\r\n        <path class=\"cls-1\" d=\"M276.83,151.27h-.64v-.48h.63c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4ZM277.31,147l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M278.16,153.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9ZM279.51,147.61l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M281.23,146.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M285.26,151.36c-.3,0-.56-.08-.78-.23-.22-.15-.43-.33-.64-.53-.14.19-.29.35-.45.47-.16.13-.37.19-.64.19h-.21v-.48h.2c.18,0,.33-.05.46-.15.12-.1.23-.23.33-.39.09-.16.19-.33.28-.51s.19-.35.3-.51c.11-.16.24-.29.4-.39s.35-.15.58-.15c.27,0,.5.06.69.19s.35.3.45.52.16.46.16.73c0,.39-.1.69-.29.9-.19.21-.47.32-.83.32ZM285.07,149.16c-.17,0-.31.06-.44.17-.13.11-.24.25-.33.4s-.17.31-.24.46c.19.2.38.36.56.48.23.15.44.23.63.23.22,0,.39-.06.51-.18s.18-.29.18-.52c0-.29-.08-.54-.23-.74-.15-.2-.37-.3-.65-.3Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M291.1,144.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM290.59,145.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M290.67,145.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM290.7,146.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M361.27,114.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM361.22,110.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M364.59,108.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M365.89,112.79h.74c.34,0,.6-.08.78-.24s.26-.42.27-.79c0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.73v-.48ZM366.62,109.38l.4.4-.4.4-.4-.4.4-.4ZM367.7,109.38l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M373.72,113.27c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22s-.01-.19-.03-.31l.42-.05.05.7c.02.24.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26s.18-.41.18-.72c0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.27.16-.42.16-.71c0-.09,0-.17,0-.27s-.01-.2-.03-.33l.42-.05.05.76c.02.26.1.47.25.63.15.16.34.24.58.24h.18v.48h-.18c-.26,0-.48-.06-.66-.17s-.29-.29-.36-.51c-.08.22-.19.38-.33.51-.14.12-.35.18-.62.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M376.95,111.68v-3.67h.43v3.68c0,.31.06.57.19.78.13.21.35.32.66.32h.18v.48h-.18c-.29,0-.52-.07-.68-.2s-.29-.3-.37-.49c-.12.24-.25.41-.42.52-.16.11-.41.16-.75.16h-.3v-.48h.3c.36,0,.61-.1.74-.3s.2-.47.2-.82Z\"/>\r\n        <path class=\"cls-1\" d=\"M378.95,109.45c.21.14.44.31.7.49.26.19.51.39.75.61.24.22.44.45.59.7.15.25.23.5.23.76,0,.47-.18.79-.54.98-.36.18-.85.27-1.48.27h-.95v-.48h.95c.31,0,.59-.02.82-.06.24-.04.42-.12.55-.23.13-.11.2-.28.2-.49,0-.2-.07-.39-.21-.58s-.31-.38-.52-.57c-.21-.19-.43-.36-.65-.53-.23-.17-.43-.32-.6-.46-.07-.06-.14-.13-.21-.2-.06-.07-.1-.15-.1-.23,0-.1.04-.18.11-.25s.17-.13.29-.18l2.7-1.1v.46l-2.64,1.07ZM378.65,108.57v-.31l2.91-1.18v.31l-2.91,1.18Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M386.1,106.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM385.59,107.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M385.67,107.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM385.7,108.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M183,115.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM182.95,111.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M188.45,113.43c.18-.13.32-.31.42-.54.1-.24.14-.55.14-.94v-2.94h.43v3.15c0,.31.03.59.08.84.05.25.14.44.27.58.13.14.3.21.52.21h.19v.48h-.2c-.35,0-.62-.11-.79-.32-.17-.22-.29-.48-.34-.79-.19.36-.48.64-.88.83-.4.19-.93.28-1.6.28-.09,0-.18,0-.27,0-.09,0-.19-.01-.28-.02v-.45c.13,0,.24.01.34.02.1,0,.19,0,.29,0,.14,0,.25,0,.34,0,.09,0,.18-.01.26-.03-.07-.48-.15-.93-.23-1.35-.09-.41-.21-.88-.36-1.4-.16-.52-.35-1.06-.6-1.63l.39-.18c.24.58.44,1.13.59,1.67s.28,1.01.37,1.44.17.88.24,1.37c.26-.06.48-.16.66-.29Z\"/>\r\n        <path class=\"cls-1\" d=\"M190.56,115.03l.4.4-.4.4-.4-.4.4-.4ZM190.34,113.79h.59c.34,0,.6-.08.78-.24s.26-.42.27-.79c0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.58v-.48ZM191.64,115.03l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M193.95,110.45c.21.14.44.31.7.49.26.19.51.39.75.61.24.22.44.45.59.7.15.25.23.5.23.76,0,.47-.18.79-.54.98-.36.18-.85.27-1.48.27h-.95v-.48h.95c.31,0,.59-.02.82-.06.24-.04.42-.12.55-.23.13-.11.2-.28.2-.49,0-.2-.07-.39-.21-.58s-.31-.38-.52-.57c-.21-.19-.43-.36-.65-.53-.23-.17-.43-.32-.6-.46-.07-.06-.14-.13-.21-.2-.06-.07-.1-.15-.1-.23,0-.1.04-.18.11-.25s.17-.13.29-.18l2.7-1.1v.46l-2.64,1.07ZM193.65,109.57v-.31l2.91-1.18v.31l-2.91,1.18Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M201.1,107.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM200.59,108.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M200.67,108.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM200.7,109.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M127.98,66.21c-.47,0-.85-.08-1.13-.25-.29-.17-.5-.39-.62-.69-.13-.29-.2-.63-.2-1.01,0-.25.02-.51.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.71c0,.43.11.78.34,1.05.23.27.62.4,1.17.4.52,0,.9-.14,1.15-.42s.38-.72.38-1.32v-5h.43v3.78c0,.31.07.56.2.74s.36.27.67.27h.18v.48h-.17c-.22,0-.39-.03-.53-.09-.13-.06-.25-.17-.35-.32,0,.47-.05.88-.17,1.24-.12.35-.32.63-.6.82s-.68.29-1.19.29Z\"/>\r\n        <path class=\"cls-1\" d=\"M130.82,63.79h.86c.34,0,.6-.08.78-.24s.26-.42.27-.79c0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.85v-.48ZM131.31,65.03l.4.4-.4.4-.4-.4.4-.4ZM132.39,65.03l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M133.99,63.79h.71c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-.72v-.48ZM134.8,65.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M137.59,63.8c.31,0,.59-.03.83-.08.24-.05.43-.15.57-.28.14-.13.21-.31.21-.54,0-.3-.14-.6-.43-.89-.29-.29-.67-.57-1.14-.83l.21-.41c.56.29,1,.61,1.32.97.32.36.48.74.48,1.13,0,.49-.17.84-.51,1.05-.34.21-.83.32-1.48.32-.29,0-.57-.02-.83-.07v-.47c.29.05.54.08.77.08Z\"/>\r\n        <path class=\"cls-1\" d=\"M139.66,66.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M143.17,59.01v5.26h-.43v-5.26h.43Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M148.1,57.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM147.59,58.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M147.67,58.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM147.7,59.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M60.41,89.28c-.51,0-.93-.09-1.25-.28-.32-.19-.56-.44-.71-.76s-.23-.69-.23-1.1c0-.18.01-.37.04-.58s.08-.44.16-.69l.41.15c-.06.22-.11.43-.13.62s-.04.35-.04.5c0,.32.06.61.17.86.12.25.3.45.56.59.26.14.59.21,1.01.21.37,0,.71-.05,1.01-.14.3-.09.53-.22.71-.37.17-.15.26-.31.26-.47,0-.18-.07-.32-.21-.42-.14-.1-.33-.15-.58-.15h-.5c-.06,0-.1-.05-.13-.14l-.08-.27s.02-.07.07-.07h2.03v.47h-.4c.09.08.14.17.17.27.03.1.04.19.04.29,0,.25-.1.48-.29.7-.19.22-.47.4-.83.54-.36.14-.79.21-1.28.21Z\"/>\r\n        <path class=\"cls-1\" d=\"M64.32,86.79c.33,0,.59-.02.79-.07s.34-.14.42-.3.13-.39.13-.7c-.14.04-.29.08-.43.11s-.31.04-.48.04c-.4,0-.71-.08-.91-.24-.21-.16-.31-.41-.31-.75,0-.25.05-.49.14-.71.09-.23.23-.42.41-.57.18-.15.39-.22.65-.22s.46.07.63.2.31.3.42.52.18.45.23.71c.05.26.07.51.07.77,0,.36-.03.65-.09.87s-.16.39-.29.51-.32.2-.55.25c-.23.04-.52.07-.87.07h-1.44v-.48h1.48ZM64.08,81.81l.4.4-.4.4-.4-.4.4-.4ZM64.79,85.42c.15,0,.29-.01.43-.04.14-.03.28-.06.41-.1-.02-.15-.04-.31-.08-.48s-.09-.32-.15-.47-.16-.26-.27-.35c-.11-.09-.25-.13-.42-.13-.18,0-.33.05-.44.16-.12.11-.2.24-.25.39s-.08.31-.08.47c0,.23.08.38.24.45.16.07.36.11.62.11ZM65.16,81.81l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M68.9,87.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M71.64,87.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22s-.01-.19-.03-.31l.42-.05.05.7c.02.24.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26s.18-.41.18-.72c0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51s.04.36.04.53c0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.39.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18ZM71.9,83.46l.39.39-.39.39-.39-.39.39-.39ZM72.47,82.57l.39.39-.39.39-.39-.39.39-.39ZM73.04,83.46l.39.39-.39.39-.39-.39.39-.39Z\"/>\r\n        <path class=\"cls-1\" d=\"M80.02,88.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM79.98,84.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M83.34,82.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M89.62,85.36v.47c-.25.04-.52.13-.83.28.03.2.09.35.18.45s.23.16.4.19c.17.03.39.04.65.04h.23v.48h-.23c-.35,0-.64-.03-.86-.1-.22-.06-.38-.17-.49-.31-.11-.15-.19-.34-.22-.59-.35.17-.69.34-1.03.49-.34.15-.69.27-1.04.37-.35.09-.71.14-1.08.14h-.65v-.48h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24s-.43-.18-.63-.26c-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.13.55.24.83.34s.55.16.8.18ZM87.32,88.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M90.31,88.03l.4.4-.4.4-.4-.4.4-.4ZM90.09,86.79h.85c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-.86v-.48ZM91.39,88.03l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M93.27,82.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M94.56,86.79h.71c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-.72v-.48ZM95.37,88.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M96.95,89.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M100.59,86.8c.31,0,.59-.03.83-.08.24-.05.43-.15.57-.28.14-.13.21-.31.21-.54,0-.3-.14-.6-.43-.89-.29-.29-.67-.57-1.14-.83l.21-.41c.56.29,1,.61,1.32.97.32.36.48.74.48,1.13,0,.49-.17.84-.51,1.05-.34.21-.83.32-1.48.32-.29,0-.57-.02-.83-.07v-.47c.29.05.54.08.77.08ZM100.81,82.13l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M104.31,81.55c.05.02.1.04.14.04.07,0,.14-.03.21-.08.07-.05.14-.12.23-.19l.15-.13.25.22-.16.15c-.13.12-.24.22-.34.28s-.2.09-.29.09c-.09,0-.19-.03-.31-.08l-.5-.23c-.09-.04-.16-.06-.23-.06-.08,0-.17.03-.25.09-.08.06-.17.14-.28.25l-.18.17-.25-.22.18-.18c.15-.16.29-.28.4-.34.11-.07.22-.1.33-.1.06,0,.13,0,.19.03.06.02.14.05.21.08l.5.23ZM104.17,82.5v4.77h-.43v-4.77h.43Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M109.1,80.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM108.59,81.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M108.67,81.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM108.7,82.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M15.81,51.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM15.77,47.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M19.13,45.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M25.41,48.36v.47c-.25.04-.52.13-.83.28.03.2.09.35.18.45s.23.16.4.19c.17.03.39.04.65.04h.23v.48h-.23c-.35,0-.64-.03-.86-.1-.22-.06-.38-.17-.49-.31-.11-.15-.19-.34-.22-.59-.35.17-.69.34-1.03.49-.34.15-.69.27-1.04.37-.35.09-.71.14-1.08.14h-.65v-.48h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24s-.43-.18-.63-.26c-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.13.55.24.83.34s.55.16.8.18ZM23.11,51.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M26.1,51.03l.4.4-.4.4-.4-.4.4-.4ZM25.88,49.79h.85c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-.86v-.48ZM27.18,51.03l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M29.05,45.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M30.35,49.79h.71c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-.72v-.48ZM31.16,51.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M32.74,52.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M36.38,49.8c.31,0,.59-.03.83-.08.24-.05.43-.15.57-.28.14-.13.21-.31.21-.54,0-.3-.14-.6-.43-.89-.29-.29-.67-.57-1.14-.83l.21-.41c.56.29,1,.61,1.32.97.32.36.48.74.48,1.13,0,.49-.17.84-.51,1.05-.34.21-.83.32-1.48.32-.29,0-.57-.02-.83-.07v-.47c.29.05.54.08.77.08ZM36.6,45.13l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M40.1,44.55c.05.02.1.04.14.04.07,0,.14-.03.21-.08.07-.05.14-.12.23-.19l.15-.13.25.22-.16.15c-.13.12-.24.22-.34.28s-.2.09-.29.09c-.09,0-.19-.03-.31-.08l-.5-.23c-.09-.04-.16-.06-.23-.06-.08,0-.17.03-.25.09-.08.06-.17.14-.28.25l-.18.17-.25-.22.18-.18c.15-.16.29-.28.4-.34.11-.07.22-.1.33-.1.06,0,.13,0,.19.03.06.02.14.05.21.08l.5.23ZM39.96,45.5v4.77h-.43v-4.77h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M20.88,61.88c-.51,0-.93-.09-1.25-.28-.32-.19-.56-.44-.71-.76s-.23-.69-.23-1.1c0-.18.01-.37.04-.58s.08-.44.16-.69l.41.15c-.06.22-.11.43-.13.62s-.04.35-.04.5c0,.32.06.61.17.86.12.25.3.45.56.59.26.14.59.21,1.01.21.37,0,.71-.05,1.01-.14.3-.09.53-.22.71-.37.17-.15.26-.31.26-.47,0-.18-.07-.32-.21-.42-.14-.1-.33-.15-.58-.15h-.5c-.06,0-.1-.05-.13-.14l-.08-.27s.02-.07.07-.07h2.03v.47h-.4c.09.08.14.17.17.27.03.1.04.19.04.29,0,.25-.1.48-.29.7-.19.22-.47.4-.83.54-.36.14-.79.21-1.28.21Z\"/>\r\n        <path class=\"cls-1\" d=\"M23.31,59.39h1.45c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-1.45v-.48ZM24.85,60.61l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M29.17,59.87c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M30.66,59.39c-.14-.13-.27-.31-.39-.53-.13-.22-.19-.48-.19-.76,0-.25.07-.48.2-.69s.31-.38.53-.5c.22-.12.46-.19.71-.19.18,0,.37.03.57.1.2.07.4.17.62.31l-.17.38c-.16-.09-.33-.17-.49-.22-.16-.06-.32-.09-.48-.09-.18,0-.35.04-.51.12-.16.08-.29.19-.38.32-.1.14-.14.3-.14.49s.04.37.12.52c.08.15.17.27.26.36s.16.15.2.17c.1.07.18.09.23.08l1.6-.41v.46c-.44.14-.83.24-1.17.33s-.66.14-.97.18c-.31.04-.65.05-1.03.05h-.6v-.48h1.48ZM31.45,54.99l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M25.1,33.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM24.59,34.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M24.67,34.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM24.7,35.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M417.95,108.28c-.51,0-.93-.09-1.25-.28-.32-.19-.56-.44-.71-.76s-.23-.69-.23-1.1c0-.18.01-.37.04-.58s.08-.44.16-.69l.41.15c-.06.22-.11.43-.13.62s-.04.35-.04.5c0,.32.06.61.17.86.12.25.3.45.56.59.26.14.59.21,1.01.21.37,0,.71-.05,1.01-.14.3-.09.53-.22.71-.37.17-.15.26-.31.26-.47,0-.18-.07-.32-.21-.42-.14-.1-.33-.15-.58-.15h-.5c-.06,0-.1-.05-.13-.14l-.08-.27s.02-.07.07-.07h2.03v.47h-.4c.09.08.14.17.17.27.03.1.04.19.04.29,0,.25-.1.48-.29.7-.19.22-.47.4-.83.54-.36.14-.79.21-1.28.21Z\"/>\r\n        <path class=\"cls-1\" d=\"M420.37,105.79h.3c.36,0,.6-.1.74-.29.13-.19.2-.45.2-.76v-3.74h.43v3.73c0,.51-.11.89-.32,1.14-.22.26-.57.38-1.05.38h-.3v-.48Z\"/>\r\n        <path class=\"cls-1\" d=\"M423.35,101.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M424.86,106.27h-.21v-.48h.2c.18,0,.34-.05.46-.15s.23-.23.33-.39.19-.33.28-.51c.09-.18.19-.35.3-.51s.24-.29.4-.39.35-.15.58-.15c.38,0,.67.12.88.35.21.23.35.53.4.88.04.23.12.44.26.61.14.17.3.25.48.25h.17v.48h-.17c-.17,0-.34-.05-.49-.15-.16-.1-.27-.23-.35-.38-.08.2-.21.35-.37.46s-.38.16-.63.16c-.3,0-.56-.08-.78-.23-.22-.15-.43-.33-.64-.53-.14.19-.29.35-.45.47-.16.13-.37.19-.64.19ZM427.19,104.16c-.17,0-.31.06-.44.17-.13.11-.24.25-.33.4s-.17.31-.24.46c.19.2.38.37.57.49.23.15.43.22.62.22.22,0,.39-.06.51-.18s.18-.29.18-.52c0-.29-.08-.54-.23-.74-.15-.2-.37-.3-.65-.3Z\"/>\r\n        <path class=\"cls-1\" d=\"M431.96,106.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22s-.01-.19-.03-.31l.42-.05.05.7c.02.24.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26s.18-.41.18-.72c0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51s.04.36.04.53c0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.39.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18ZM432.23,102.46l.39.39-.39.39-.39-.39.39-.39ZM432.8,101.57l.39.39-.39.39-.39-.39.39-.39ZM433.37,102.46l.39.39-.39.39-.39-.39.39-.39Z\"/>\r\n        <path class=\"cls-1\" d=\"M440.35,107.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM440.3,103.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M443.67,101.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M447.69,106.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22s-.01-.19-.03-.31l.42-.05.05.7c.02.24.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26s.18-.41.18-.72c0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51s.04.36.04.53c0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.39.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M452.38,101.01v5.26h-.43v-5.26h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M455.43,106.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M455.44,105.79h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24s-.43-.18-.63-.26c-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.12.55.24.83.34s.55.16.8.19v.47c-.19.04-.4.11-.64.21-.24.1-.54.23-.91.42-.36.17-.68.32-.98.44-.29.12-.58.21-.87.27s-.59.09-.93.09h-.65v-.48ZM457.88,101.65l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M465.1,99.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM464.59,100.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M464.67,100.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM464.7,101.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M486.54,177.24c-.51,0-.92-.09-1.25-.27-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.11c0-.25.02-.51.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.71c0,.49.14.89.42,1.19s.72.45,1.33.45c.35,0,.68-.05.99-.14.31-.09.56-.22.75-.38s.29-.36.29-.57c0-.12-.03-.22-.09-.31-.06-.09-.17-.13-.34-.13h-.63c-.35,0-.6-.09-.73-.27-.14-.18-.2-.4-.2-.67,0-.31.06-.61.19-.88s.3-.49.54-.65c.24-.16.52-.25.86-.25.13,0,.27.02.4.04.13.03.26.08.38.16l-.15.39c-.2-.09-.41-.13-.63-.13-.37,0-.65.13-.84.38-.19.25-.29.56-.29.93,0,.17.04.3.12.36.08.07.2.1.37.1h.64c.32,0,.54.08.66.25s.18.38.18.65c0,.31-.11.58-.31.82-.21.24-.5.42-.87.56-.37.13-.79.2-1.27.2Z\"/>\r\n        <path class=\"cls-1\" d=\"M491.08,172.65c.31,0,.57.1.77.29.2.19.34.45.44.78.09.32.14.68.15,1.08h.58v.48h-.62c-.09.52-.31.95-.65,1.31s-.89.61-1.62.77l-.15-.41c.58-.13,1.04-.33,1.38-.59s.55-.62.64-1.07h-.74c-.45,0-.78-.09-1.02-.26-.23-.17-.35-.45-.35-.83,0-.25.04-.49.14-.73.09-.24.23-.43.4-.58.18-.15.4-.23.66-.23ZM491.21,174.79h.8c-.01-.3-.05-.58-.11-.84s-.15-.46-.28-.61c-.13-.15-.31-.23-.55-.23-.19,0-.33.06-.44.17-.11.11-.19.25-.24.41-.05.16-.07.32-.07.47,0,.23.08.4.23.49.15.09.37.14.66.14Z\"/>\r\n        <path class=\"cls-1\" d=\"M495.04,174.71c.26-.45.54-.85.82-1.2.28-.35.58-.63.89-.84.31-.21.63-.31.97-.31.27,0,.52.06.73.18.21.12.38.28.5.48.12.2.18.43.18.68,0,.39-.12.7-.34.93-.23.23-.55.39-.97.49-.42.1-.9.15-1.46.15h-.34c-.47,0-.85-.04-1.13-.12-.28-.08-.48-.26-.6-.52-.13.22-.29.38-.47.49-.19.1-.44.16-.76.16h-.2v-.48h.2c.37,0,.63-.09.78-.26s.22-.42.22-.74c0-.11,0-.21,0-.3,0-.09-.01-.19-.02-.31l.42-.05.05.8c.02.21.07.39.15.53.08.14.21.22.38.25ZM497.75,172.83c-.28,0-.55.09-.81.28-.26.18-.51.42-.75.72-.24.3-.47.62-.69.96h.84c.44,0,.84-.03,1.19-.09s.63-.16.83-.31c.2-.15.31-.37.31-.65s-.09-.48-.26-.66c-.17-.17-.4-.26-.66-.26ZM497.56,170.56l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M499.14,177.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M506.35,176.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM506.3,172.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M509.67,170.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M513.69,175.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22s-.01-.19-.03-.31l.42-.05.05.7c.02.24.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26s.18-.41.18-.72c0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51s.04.36.04.53c0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.39.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M518.38,170.01v5.26h-.43v-5.26h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M521.43,175.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M521.44,174.79h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24s-.43-.18-.63-.26c-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.12.55.24.83.34s.55.16.8.19v.47c-.19.04-.4.11-.64.21-.24.1-.54.23-.91.42-.36.17-.68.32-.98.44-.29.12-.58.21-.87.27s-.59.09-.93.09h-.65v-.48ZM523.88,170.65l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M531.1,168.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM530.59,169.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M530.67,169.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM530.7,170.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M498.53,316.28c-.51,0-.93-.09-1.25-.28-.32-.19-.56-.44-.71-.76-.15-.32-.23-.69-.23-1.1,0-.18.01-.37.04-.58.03-.21.08-.44.16-.69l.41.15c-.06.22-.11.43-.13.62s-.04.35-.04.5c0,.32.06.61.17.86.12.25.3.45.56.59.26.14.59.21,1.01.21.37,0,.71-.05,1.01-.14.3-.09.53-.21.71-.37.17-.15.26-.3.26-.47,0-.18-.07-.32-.21-.42-.14-.1-.33-.15-.58-.15h-.5c-.06,0-.1-.05-.13-.14l-.08-.27s.02-.07.07-.07h2.03v.47h-.4c.09.08.14.17.17.27.03.1.04.19.04.29,0,.25-.1.48-.29.7-.19.22-.47.4-.83.54-.36.14-.79.21-1.28.21Z\"/>\r\n        <path class=\"cls-1\" d=\"M500.95,313.79h1.45c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-1.45v-.48ZM502.49,315.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M505.71,311.65c.31,0,.57.1.77.29.2.19.34.45.44.78.09.32.14.68.15,1.08h.58v.48h-.62c-.09.52-.31.96-.65,1.31-.35.35-.89.61-1.62.77l-.15-.41c.58-.13,1.04-.33,1.38-.59.34-.26.55-.62.64-1.07h-.74c-.45,0-.78-.08-1.02-.26-.23-.17-.35-.45-.35-.83,0-.25.04-.49.14-.73.09-.24.23-.43.4-.58.18-.15.4-.23.66-.23ZM505.84,313.79h.8c-.01-.3-.05-.58-.11-.84s-.15-.46-.28-.61c-.13-.15-.31-.23-.55-.23-.19,0-.33.06-.44.17-.11.11-.19.25-.24.41-.05.16-.07.32-.07.47,0,.23.08.4.23.49.15.09.37.14.66.14Z\"/>\r\n        <path class=\"cls-1\" d=\"M508.88,312.18l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.37v-.48h.37c.34,0,.6-.08.78-.24.18-.16.26-.42.27-.79,0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28ZM508.83,310.36l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M510.19,313.79h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24-.22-.09-.43-.17-.63-.26-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.12.55.24.83.34.28.1.55.17.8.19v.47c-.19.04-.4.11-.64.21-.24.1-.54.24-.91.42-.36.17-.68.32-.98.44-.29.12-.58.21-.87.27-.29.06-.59.09-.93.09h-.65v-.48ZM512.87,315.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M520.35,315.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6c.11-.25.16-.52.16-.82,0-.27-.03-.54-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75-.15-.32-.23-.69-.23-1.12,0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7-.05.24-.07.47-.07.7,0,.5.14.89.42,1.2.28.3.72.45,1.33.45ZM520.3,311.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M523.67,309.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M527.69,314.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22,0-.08-.01-.19-.03-.31l.42-.05.05.7c.02.25.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26.12-.17.18-.41.18-.72,0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51.02.18.04.36.04.53,0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.39.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M532.38,309.01v5.26h-.43v-5.26h.43Z\"/>\r\n        <path class=\"cls-1\" d=\"M535.43,314.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57-.34.43-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M535.44,313.79h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24-.22-.09-.43-.17-.63-.26-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.12.55.24.83.34.28.1.55.17.8.19v.47c-.19.04-.4.11-.64.21-.24.1-.54.24-.91.42-.36.17-.68.32-.98.44-.29.12-.58.21-.87.27-.29.06-.59.09-.93.09h-.65v-.48ZM537.88,309.65l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M545.1,307.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM544.59,308.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M544.67,308.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM544.7,309.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M191.09,162.81c.45,0,.8-.07,1.05-.22s.44-.35.55-.59.16-.52.16-.82c0-.27-.03-.55-.1-.83-.07-.28-.14-.53-.23-.76l.45-.18.24.8c.06.18.15.32.29.43.13.11.31.16.54.16h.2v.48h-.19c-.17,0-.32-.02-.44-.07-.12-.04-.23-.12-.32-.23.02.45-.04.85-.18,1.19-.14.35-.38.62-.71.82-.33.2-.77.3-1.32.3-.51,0-.92-.09-1.25-.27-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM191.04,158.55l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M194.09,160.79h1.11c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4h-1.12v-.48ZM194.57,162.03l.4.4-.4.4-.4-.4.4-.4ZM195.65,162.03l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M199.87,160.72c0,.75-.2,1.34-.6,1.76-.4.42-.97.71-1.72.87l-.15-.41c.63-.14,1.11-.36,1.44-.64s.52-.66.59-1.14c-.12.04-.25.07-.39.09s-.28.04-.41.04c-.42,0-.74-.09-.97-.26-.23-.17-.34-.45-.34-.84,0-.25.04-.49.14-.73.09-.24.23-.43.4-.58.18-.15.4-.23.66-.23.25,0,.46.06.63.19s.31.29.42.49.18.43.23.67.07.48.07.72ZM198.64,160.82c.13,0,.27-.01.4-.04.13-.02.27-.06.39-.09-.01-.26-.04-.52-.1-.76-.06-.24-.15-.44-.28-.59-.13-.15-.31-.23-.54-.23-.19,0-.34.06-.45.17-.11.11-.19.25-.24.41-.05.16-.07.32-.07.47,0,.24.08.41.24.51s.38.15.65.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M203.13,161.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17ZM201.73,157.59l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M204.63,160.79c.33,0,.59-.02.79-.07s.34-.14.42-.3.13-.39.13-.7c-.14.04-.29.08-.43.11s-.31.04-.48.04c-.4,0-.71-.08-.91-.24-.21-.16-.31-.41-.31-.75,0-.25.05-.49.14-.71.09-.23.23-.42.41-.57.18-.15.39-.22.65-.22s.46.07.63.2.31.3.42.52.18.45.23.71c.05.26.07.51.07.77,0,.36-.03.65-.09.87s-.16.39-.29.51-.32.2-.55.25c-.23.04-.52.07-.87.07h-1.44v-.48h1.48ZM204.39,155.81l.4.4-.4.4-.4-.4.4-.4ZM205.11,159.42c.15,0,.29-.01.43-.04.14-.03.28-.06.41-.1-.02-.15-.04-.31-.08-.48s-.09-.32-.15-.47-.16-.26-.27-.35c-.11-.09-.25-.13-.42-.13-.18,0-.33.05-.44.16-.12.11-.2.24-.25.39s-.08.31-.08.47c0,.23.08.38.24.45.16.07.36.11.62.11ZM205.47,155.81l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M198.1,147.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM197.59,148.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M197.67,148.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM197.7,149.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M144.36,143.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM144.32,139.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M147.68,137.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M153.96,140.36v.47c-.25.04-.52.13-.83.28.03.2.09.35.18.45s.23.16.4.19c.17.03.39.04.65.04h.23v.48h-.23c-.35,0-.64-.03-.86-.1-.22-.06-.38-.17-.49-.31-.11-.15-.19-.34-.22-.59-.35.17-.69.34-1.03.49-.34.15-.69.27-1.04.37-.35.09-.71.14-1.08.14h-.65v-.48h.66c.34,0,.65-.03.94-.1.29-.07.57-.16.84-.27s.55-.24.84-.38c.29-.14.59-.28.93-.41-.22-.07-.44-.15-.67-.24s-.43-.18-.63-.26c-.2-.08-.38-.15-.53-.21s-.27-.08-.35-.08c-.19,0-.34.05-.47.15s-.25.21-.35.34l-.07.09-.39-.19.05-.07c.16-.24.34-.43.54-.57.2-.14.43-.21.7-.21.14,0,.33.05.56.14.23.09.48.2.76.33.27.13.55.24.83.34s.55.16.8.18ZM151.66,143.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M155.07,142.27h-.64v-.48h.63c.3,0,.5-.08.62-.25.11-.17.17-.39.17-.67,0-.15-.01-.32-.04-.5-.03-.18-.05-.36-.09-.54l.45-.12c.08.38.12.73.12,1.07,0,.45-.09.81-.27,1.08-.18.27-.5.4-.95.4ZM155.55,138l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M156.4,144.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9ZM157.75,138.61l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M150.1,128.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM149.59,129.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M149.67,129.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM149.7,130.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M90.2,177.53c.45,0,.8-.07,1.05-.22s.44-.35.55-.6.16-.52.16-.82c0-.27-.03-.55-.1-.82-.07-.28-.14-.53-.23-.76l.45-.18c.11.3.19.6.24.89.06.29.08.57.08.84,0,.41-.08.78-.23,1.1-.15.32-.39.58-.71.76-.33.19-.75.28-1.28.28s-.92-.09-1.25-.27c-.32-.18-.56-.43-.71-.75s-.23-.69-.23-1.12c0-.25.02-.5.07-.77.05-.26.12-.52.2-.78l.41.16c-.07.23-.13.46-.18.7s-.07.47-.07.7c0,.49.14.89.42,1.2s.72.45,1.33.45ZM90.15,173.25l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M93.52,171.01h.43v3.73c0,.39.07.66.21.82s.36.23.65.23h.17v.48h-.17c-.45,0-.78-.13-.98-.38-.21-.25-.31-.63-.31-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M94.82,175.79h.74c.34,0,.6-.08.78-.24s.26-.42.27-.79c0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.73v-.48ZM95.55,172.38l.4.4-.4.4-.4-.4.4-.4ZM96.62,172.38l.4.4-.4.4-.4-.4.4-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M100.61,176.27c-.31,0-.54-.06-.7-.19-.16-.12-.28-.29-.36-.49-.11.23-.27.4-.46.51-.19.11-.47.17-.84.17h-.36v-.48h.37c.36,0,.63-.07.81-.22.18-.15.27-.4.27-.76,0-.06,0-.14,0-.22s-.01-.19-.03-.31l.42-.05.05.7c.02.24.1.45.23.62.14.17.34.25.61.25.31,0,.53-.09.65-.26s.18-.41.18-.72c0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.42-.05.05.7c.02.24.08.44.2.61.12.17.3.26.56.26s.43-.09.54-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53-.03-.18-.06-.33-.09-.46l.44-.12c.04.16.08.33.1.51s.04.36.04.53c0,.26-.04.49-.11.72-.07.22-.19.4-.35.54s-.39.21-.66.21c-.28,0-.5-.06-.65-.19-.15-.13-.26-.29-.33-.48-.11.21-.25.38-.42.5s-.39.18-.65.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M105.43,175.8c.31,0,.59-.03.83-.08.24-.05.43-.15.57-.28.14-.13.21-.31.21-.54,0-.3-.14-.6-.43-.89-.29-.29-.67-.57-1.14-.83l.21-.41c.56.29,1,.61,1.32.97.32.36.48.74.48,1.13,0,.49-.17.84-.51,1.05-.34.21-.83.32-1.48.32-.29,0-.57-.02-.83-.07v-.47c.29.05.54.08.77.08Z\"/>\r\n        <path class=\"cls-1\" d=\"M110.23,176.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M110.95,172.45c.21.14.44.31.7.49.26.19.51.39.75.61.24.22.44.45.59.7.15.25.23.5.23.76,0,.47-.18.79-.54.98-.36.18-.85.27-1.48.27h-.95v-.48h.95c.31,0,.59-.02.82-.06.24-.04.42-.12.55-.23.13-.11.2-.28.2-.49,0-.2-.07-.39-.21-.58s-.31-.38-.52-.57c-.21-.19-.43-.36-.65-.53-.23-.17-.43-.32-.6-.46-.07-.06-.14-.13-.21-.2-.06-.07-.1-.15-.1-.23,0-.1.04-.18.11-.25s.17-.13.29-.18l2.7-1.1v.46l-2.64,1.07Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M101.1,162.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM100.59,163.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M100.67,163.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM100.7,164.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M222.73,170.35l-.15-.41c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14c.16.49.25.97.25,1.43,0,.62-.17,1.16-.49,1.61-.33.45-.82.75-1.48.9ZM224.09,164.61l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M227.97,168.27c-.2,0-.36-.03-.48-.1-.13-.07-.22-.15-.29-.24-.01.62-.19,1.14-.53,1.57s-.82.71-1.44.85l-.15-.4c.58-.15,1.01-.4,1.28-.75.27-.35.41-.78.41-1.28,0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.18-.71l.43-.14.18.7c.06.22.15.39.28.51.13.12.31.18.53.18h.19v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M227.98,167.79h.45c.34,0,.6-.08.78-.24s.26-.42.27-.79c0-.11,0-.22,0-.31,0-.1-.01-.19-.02-.28l.42-.05.05.79c.02.28.11.5.26.65.16.15.35.22.57.22h.16v.48h-.16c-.29,0-.52-.07-.69-.22-.17-.15-.29-.3-.35-.45-.11.23-.27.4-.5.51-.23.11-.49.16-.78.16h-.45v-.48ZM228.79,169.01l.42.42-.42.42-.42-.42.42-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M230.76,167.79h.3c.36,0,.6-.1.74-.29.13-.19.2-.45.2-.76v-3.74h.43v3.73c0,.51-.11.89-.32,1.14-.22.26-.57.38-1.05.38h-.3v-.48Z\"/>\r\n        <path class=\"cls-1\" d=\"M234.17,163.01v5.26h-.43v-5.26h.43Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M230.1,154.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM229.59,155.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M229.67,155.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM229.7,156.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M305.82,431.27c-.2,0-.37-.03-.51-.09s-.26-.13-.34-.21c.02.45-.04.85-.18,1.2s-.37.62-.69.82c-.32.2-.74.29-1.26.29-.49,0-.89-.09-1.2-.27s-.54-.43-.69-.75-.22-.69-.22-1.12c0-.25.02-.5.07-.77.05-.26.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7s-.07.47-.07.7c0,.5.13.89.4,1.2.27.3.69.45,1.28.45.43,0,.77-.07,1.01-.22s.43-.35.53-.59c.11-.25.16-.52.16-.82,0-.27-.03-.55-.1-.83-.06-.28-.14-.53-.22-.76l.43-.18.19.64c.07.24.19.42.34.55s.37.2.64.2c.3,0,.51-.09.62-.26.12-.17.17-.41.17-.72,0-.06,0-.14,0-.22,0-.08-.01-.19-.02-.31l.4-.05.05.7c.01.24.08.44.19.61.11.17.29.26.54.26s.42-.09.51-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53s-.06-.33-.09-.46l.42-.12c.04.16.08.33.1.51.02.18.04.36.04.53,0,.25-.04.49-.1.72s-.18.4-.34.54-.37.21-.64.21c-.27,0-.48-.06-.62-.19-.14-.13-.25-.29-.31-.48-.1.21-.24.38-.4.5-.17.12-.38.18-.63.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M308.89,433.35l-.14-.41c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65-.04-.23-.1-.46-.17-.71l.41-.14c.16.5.24.97.24,1.43,0,.62-.16,1.16-.47,1.61s-.79.75-1.43.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M311.85,426.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.95-.38s-.29-.63-.29-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M314.53,430.79c.32,0,.57-.02.76-.07.19-.05.32-.14.4-.3.08-.15.12-.39.12-.7-.14.04-.28.08-.42.11s-.29.04-.46.04c-.39,0-.68-.08-.88-.24-.2-.16-.3-.41-.3-.75,0-.25.04-.49.13-.71.09-.23.22-.42.39-.57s.38-.22.62-.22.44.07.61.2c.16.13.3.3.4.52s.17.45.22.71.07.51.07.77c0,.36-.03.65-.08.87-.06.22-.15.39-.28.51-.13.12-.31.2-.53.25s-.5.07-.83.07h-1.38v-.48h1.43ZM314.99,429.42c.14,0,.28-.01.41-.04.13-.03.27-.06.4-.1-.02-.15-.04-.31-.08-.48s-.08-.32-.15-.47-.15-.26-.26-.35-.24-.13-.4-.13-.31.05-.42.16c-.11.11-.19.24-.24.39s-.08.31-.08.47c0,.23.08.38.23.45.15.07.35.11.6.11ZM314.81,425.74l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M321.25,424.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM320.75,425.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M320.82,425.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM320.85,426.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M245.55,455.27c-.19,0-.34-.03-.46-.1-.12-.07-.21-.15-.28-.24-.01.62-.18,1.14-.51,1.57s-.79.71-1.39.85l-.14-.4c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65s-.1-.46-.17-.71l.41-.14.18.7c.05.22.15.39.27.51s.29.18.51.18h.18v.48h-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M245.57,455.27v-.48h.88v-.12c0-.29.02-.58.07-.87.04-.28.12-.54.21-.77s.23-.42.38-.55c.16-.14.35-.21.58-.21.29,0,.51.11.67.32s.24.48.24.82-.08.65-.23.93c-.16.28-.37.51-.63.68s-.55.26-.86.26c.03.15.09.32.17.51s.2.37.34.55c.14.18.32.33.52.46-.02-.63.08-1.12.3-1.47.21-.35.6-.53,1.17-.53h.18v.48h-.18c-.3,0-.53.05-.68.16s-.26.27-.32.47-.08.45-.08.74c0,.05,0,.11,0,.18s0,.14,0,.19l-.33.32c-.43-.24-.77-.54-1.01-.92s-.4-.76-.46-1.16h-.92ZM247.69,452.72c-.19,0-.34.09-.46.27-.12.18-.21.41-.27.71s-.09.62-.09.97v.13c.27,0,.5-.06.7-.18.2-.12.36-.29.47-.5.11-.21.17-.45.17-.72,0-.2-.04-.36-.13-.49-.09-.13-.22-.19-.39-.19Z\"/>\r\n        <path class=\"cls-1\" d=\"M252.02,455.27c-.3,0-.52-.06-.68-.19-.16-.12-.27-.29-.35-.49-.11.23-.26.4-.44.51s-.46.17-.81.17h-.35v-.48h.35c.35,0,.61-.07.78-.22.17-.15.26-.4.26-.76,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.02.25.09.45.23.62s.33.25.59.25c.3,0,.5-.09.62-.26.12-.17.17-.41.17-.72,0-.06,0-.14,0-.22s-.01-.19-.02-.31l.4-.05.05.7c.01.24.08.44.19.61.11.17.29.26.54.26s.42-.09.51-.28.15-.4.15-.65c0-.17-.01-.35-.04-.53s-.06-.33-.09-.46l.42-.12c.04.16.08.33.1.51s.03.36.03.53c0,.25-.03.49-.1.72-.07.22-.18.4-.34.54-.16.14-.37.21-.64.21-.27,0-.48-.06-.62-.19s-.25-.29-.32-.48c-.1.21-.24.38-.4.5s-.38.18-.63.18ZM252.28,451.46l.38.39-.38.39-.37-.39.37-.39ZM252.83,450.57l.37.39-.37.39-.37-.39.37-.39ZM253.38,451.46l.37.39-.37.39-.37-.39.37-.39Z\"/>\r\n        <path class=\"cls-1\" d=\"M257.07,452.65c.3,0,.55.1.74.29s.33.45.42.78c.09.32.14.68.14,1.08h.56v.48h-.6c-.08.52-.29.95-.63,1.31-.33.35-.85.61-1.56.77l-.15-.41c.56-.13,1-.33,1.33-.59s.53-.62.61-1.07h-.71c-.43,0-.75-.08-.98-.26s-.33-.45-.33-.83c0-.25.04-.49.13-.73.09-.24.22-.43.39-.58.17-.15.38-.23.63-.23ZM257.19,454.79h.77c-.01-.3-.05-.58-.1-.84-.06-.25-.15-.46-.27-.61-.12-.15-.3-.23-.53-.23-.18,0-.32.06-.43.17s-.18.25-.23.41-.07.32-.07.47c0,.23.07.4.22.49.15.09.36.14.63.14Z\"/>\r\n        <path class=\"cls-1\" d=\"M258.78,454.79h.68c.29,0,.49-.08.59-.25s.16-.39.16-.67c0-.15-.01-.32-.04-.5-.02-.18-.05-.36-.08-.54l.44-.12c.08.38.11.73.11,1.07,0,.45-.09.81-.26,1.08-.17.27-.48.4-.91.4h-.69v-.48ZM259.55,456.01l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M252.69,440.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM252.18,441.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M252.25,441.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM252.29,442.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M220.04,375.27c-.31,0-.54-.09-.69-.27s-.24-.42-.29-.72c-.1.17-.24.3-.41.39-.17.09-.36.14-.56.14-.29,0-.54-.08-.73-.24-.2-.16-.29-.39-.29-.67,0-.25.08-.46.23-.65.15-.19.36-.35.62-.49.26-.14.55-.26.88-.36l-.02-.14.35-.07.27,1.99c.03.23.1.4.2.52.1.12.25.17.45.17h.15v.42h-.16ZM218.97,373.65s0-.07,0-.11c0-.04,0-.07-.01-.11l-.1-.68c-.24.09-.47.19-.69.3-.21.11-.39.23-.52.36-.13.13-.2.29-.2.46,0,.19.06.33.18.42.12.09.28.14.46.14.15,0,.29-.03.43-.1s.24-.15.32-.27c.08-.12.12-.25.12-.41Z\"/>\r\n        <path class=\"cls-1\" d=\"M220.25,375.94l.34.35-.34.35-.34-.35.34-.35ZM220.06,374.85h.71c.25,0,.42-.07.52-.22.09-.15.14-.34.14-.58,0-.13-.01-.28-.03-.44-.02-.16-.05-.32-.07-.47l.38-.1c.07.33.1.64.1.94,0,.39-.08.71-.23.94-.15.24-.42.35-.8.35h-.72v-.42ZM221.16,375.94l.34.35-.34.35-.33-.35.33-.35Z\"/>\r\n        <path class=\"cls-1\" d=\"M223.57,372.98c.26,0,.48.08.64.25.17.17.29.4.37.68.08.28.12.6.12.95h.49v.42h-.52c-.07.45-.26.83-.55,1.14-.29.31-.75.53-1.36.67l-.13-.36c.49-.11.87-.29,1.16-.52.29-.23.46-.54.54-.94h-.62c-.38,0-.66-.07-.85-.22-.2-.15-.29-.39-.29-.72,0-.22.04-.43.12-.64.08-.21.19-.38.34-.51.15-.13.33-.2.55-.2ZM223.67,374.85h.67c-.01-.27-.04-.51-.09-.73-.05-.22-.13-.4-.24-.53-.11-.13-.26-.2-.46-.2-.16,0-.28.05-.37.15-.09.1-.16.22-.2.36-.04.14-.06.28-.06.41,0,.21.06.35.2.43.13.08.32.12.55.12Z\"/>\r\n        <path class=\"cls-1\" d=\"M226.11,373.88v-3.21h.36v3.22c0,.27.05.5.16.69.11.19.29.28.55.28h.15v.42h-.15c-.25,0-.44-.06-.58-.18-.14-.12-.24-.26-.31-.43-.1.21-.21.36-.35.46-.14.1-.35.14-.63.14h-.26v-.42h.25c.3,0,.51-.09.62-.26.11-.17.17-.41.17-.71Z\"/>\r\n        <path class=\"cls-1\" d=\"M227.39,375.94l.34.35-.34.35-.34-.35.34-.35ZM227.2,374.85h.49c.29,0,.5-.07.65-.21.15-.14.22-.37.23-.69,0-.1,0-.19,0-.28,0-.08,0-.17-.02-.24l.35-.04.05.69c.02.25.09.44.22.57s.29.2.48.2h.13v.42h-.13c-.24,0-.44-.06-.58-.2-.15-.13-.24-.26-.29-.39-.09.2-.23.35-.42.44-.19.1-.41.14-.66.14h-.49v-.42ZM228.29,375.94l.34.35-.34.35-.33-.35.33-.35Z\"/>\r\n        <path class=\"cls-1\" d=\"M230.24,371.93c.17.12.35.26.54.4.19.14.38.3.57.47.18.17.35.35.49.54s.24.39.3.61c.08.25.19.47.34.64.15.17.35.26.59.26h.15v.42h-.15c-.23,0-.43-.06-.6-.18-.17-.12-.31-.29-.43-.5-.1.25-.28.42-.54.52-.26.1-.62.15-1.06.15h-.8v-.42h.8c.26,0,.49-.02.69-.05.2-.04.35-.1.46-.21.11-.1.17-.24.17-.43,0-.17-.06-.34-.17-.51-.12-.17-.26-.33-.44-.5-.18-.16-.36-.32-.55-.46s-.36-.28-.51-.4c-.06-.05-.12-.11-.17-.17-.05-.06-.08-.13-.08-.2,0-.08.03-.16.09-.22.06-.06.14-.11.24-.15l2.28-.96v.4l-2.22.94ZM229.99,371.16v-.27l2.45-1.03v.27l-2.45,1.04Z\"/>\r\n        <path class=\"cls-1\" d=\"M233.09,375.27v-.42h.77v-.11c0-.26.02-.51.06-.76.04-.25.1-.47.19-.67.09-.2.2-.36.34-.48.14-.12.31-.18.5-.18.25,0,.45.09.59.28.14.18.21.42.21.71s-.07.57-.21.81-.32.45-.55.6c-.23.15-.48.23-.76.23.03.13.08.28.15.45s.17.33.3.48c.12.16.28.29.46.4-.01-.55.07-.98.26-1.29.19-.31.53-.46,1.02-.46h.15v.42h-.16c-.26,0-.46.05-.6.14s-.23.23-.28.41c-.05.18-.07.4-.07.65,0,.04,0,.1,0,.16,0,.06,0,.12,0,.17l-.29.28c-.38-.21-.67-.47-.89-.8-.21-.33-.35-.67-.41-1.01h-.81ZM234.94,373.04c-.16,0-.3.08-.4.23s-.19.36-.24.62c-.05.26-.08.54-.08.85v.12c.23,0,.44-.05.62-.16.18-.11.31-.25.41-.43s.15-.39.15-.63c0-.18-.04-.32-.12-.43-.08-.11-.19-.17-.34-.17Z\"/>\r\n        <path class=\"cls-1\" d=\"M237.03,371.93c.17.13.37.27.59.43s.43.34.63.53c.2.19.37.4.5.61.13.21.2.44.2.67,0,.41-.15.7-.45.85s-.71.24-1.24.24h-.8v-.42h.8c.26,0,.49-.02.69-.05.2-.04.35-.1.46-.21.11-.1.17-.24.17-.43,0-.17-.06-.34-.17-.51-.12-.17-.26-.33-.44-.5-.18-.16-.36-.32-.55-.46s-.36-.28-.51-.4c-.06-.05-.12-.11-.17-.17-.05-.06-.08-.13-.08-.2,0-.08.03-.16.09-.22.06-.06.14-.11.24-.15l2.28-.96v.4l-2.22.94Z\"/>\r\n        <path class=\"cls-1\" d=\"M217.94,382.55c0-.08-.02-.17-.05-.27-.03-.1-.07-.2-.11-.29l-.54-1.28.34-.16.71,1.72c.09.21.17.39.23.54.07.15.15.26.23.33.08.07.2.11.33.11h.17v.42h-.17c-.18,0-.32-.03-.42-.09s-.2-.14-.27-.24c-.07-.1-.14-.22-.21-.35-.11.25-.3.42-.57.52-.27.1-.58.15-.92.15-.13,0-.25,0-.36-.02s-.21-.03-.3-.05v-.41c.11.03.22.04.32.05s.2.02.3.02c.25,0,.46-.02.66-.07s.35-.12.46-.23c.11-.1.17-.24.17-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M219.29,383.67h-.17v-.42h.17c.15,0,.28-.04.39-.13.1-.09.2-.2.28-.34.08-.14.16-.29.23-.44.08-.16.16-.3.25-.44.09-.14.2-.25.33-.34.13-.09.29-.13.49-.13.32,0,.56.1.74.31s.29.46.34.77c.03.21.1.38.22.53.12.15.25.22.41.22h.14v.42h-.14c-.14,0-.28-.04-.41-.13-.13-.09-.23-.2-.3-.33-.07.17-.17.31-.31.4-.14.1-.32.14-.53.14-.25,0-.47-.07-.66-.2-.19-.13-.37-.29-.54-.46-.12.17-.25.3-.38.42s-.31.17-.54.17ZM221.26,381.82c-.14,0-.26.05-.37.15-.11.1-.2.21-.28.35s-.15.27-.2.41c.16.18.32.32.48.43.19.13.37.19.52.19.19,0,.33-.05.43-.16.1-.11.15-.26.15-.45,0-.26-.06-.47-.19-.65-.13-.18-.31-.26-.55-.26Z\"/>\r\n        <path class=\"cls-1\" d=\"M222.98,383.25h.56c.28,0,.54-.03.79-.09.24-.06.48-.14.71-.24.23-.1.47-.21.71-.33.24-.12.5-.24.78-.36-.19-.06-.37-.13-.56-.21s-.37-.15-.53-.23-.32-.13-.45-.18c-.13-.05-.23-.07-.29-.07-.16,0-.29.04-.4.13-.11.08-.21.18-.29.3l-.06.08-.33-.17.04-.06c.14-.21.29-.38.46-.5s.37-.18.59-.18c.12,0,.28.04.47.12.19.08.41.18.64.29.23.11.46.21.7.3.24.09.46.14.67.16v.41c-.16.04-.34.1-.54.18s-.46.21-.77.37c-.3.15-.58.28-.82.39-.25.11-.49.19-.73.24-.24.05-.5.08-.78.08h-.55v-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M228.42,379.07v4.6h-.36v-4.6h.36Z\"/>\r\n        <path class=\"cls-1\" d=\"M233.25,383.67c-.16,0-.3-.03-.41-.09s-.19-.13-.24-.21c0,.54-.16,1-.44,1.37-.29.37-.69.62-1.21.74l-.12-.35c.49-.13.85-.35,1.08-.66.23-.31.34-.68.34-1.12,0-.18-.02-.37-.05-.57-.04-.2-.09-.41-.15-.62l.36-.13.15.61c.05.19.13.34.24.45.11.11.26.16.44.16h.16v.42h-.14Z\"/>\r\n        <path class=\"cls-1\" d=\"M233.27,383.25h.94c.25,0,.42-.07.52-.22.09-.15.14-.34.14-.58,0-.13-.01-.28-.03-.44-.02-.16-.05-.32-.07-.47l.38-.1c.07.33.1.64.1.94,0,.39-.08.71-.23.94-.15.24-.42.35-.8.35h-.94v-.42ZM233.68,384.34l.34.35-.34.35-.34-.35.34-.35ZM234.58,384.34l.34.35-.34.35-.34-.35.34-.35Z\"/>\r\n        <path class=\"cls-1\" d=\"M236.99,381.38c.26,0,.48.08.64.25.17.17.29.4.37.68.08.28.12.6.12.95h.49v.42h-.52c-.07.45-.26.83-.55,1.14-.29.31-.75.53-1.36.67l-.13-.36c.49-.11.87-.29,1.16-.52.29-.23.46-.54.54-.94h-.62c-.38,0-.66-.07-.85-.22-.2-.15-.29-.39-.29-.72,0-.22.04-.43.12-.64.08-.21.19-.38.34-.51.15-.13.33-.2.55-.2ZM237.1,383.25h.67c-.01-.27-.04-.51-.09-.73-.05-.22-.13-.4-.24-.53-.11-.13-.26-.2-.46-.2-.16,0-.28.05-.37.15-.09.1-.16.22-.2.36-.04.14-.06.28-.06.41,0,.21.06.35.2.43.13.08.32.12.55.12Z\"/>\r\n        <path class=\"cls-1\" d=\"M238.49,383.25h.6c.25,0,.42-.07.52-.22.09-.15.14-.34.14-.58,0-.13-.01-.28-.03-.44-.02-.16-.05-.32-.07-.47l.38-.1c.07.33.1.64.1.94,0,.39-.08.71-.23.94-.15.24-.42.35-.8.35h-.61v-.42ZM239.16,384.32l.36.37-.36.37-.35-.37.35-.37Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M228.69,359.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM228.18,360.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M228.25,360.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM228.29,361.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M158.74,346.37c.38,0,.67-.07.89-.19.22-.13.37-.3.46-.52.09-.22.14-.46.14-.72,0-.24-.03-.48-.09-.72-.06-.24-.12-.46-.19-.66l.38-.16c.09.27.16.53.21.78.05.26.07.5.07.73,0,.36-.06.68-.19.96-.13.28-.33.51-.6.67-.27.16-.63.24-1.08.24s-.78-.08-1.05-.24c-.27-.16-.47-.38-.6-.66s-.19-.61-.19-.98c0-.22.02-.44.06-.67.04-.23.1-.46.17-.68l.35.14c-.06.2-.11.41-.15.62-.04.21-.06.42-.06.62,0,.43.12.78.35,1.05s.61.4,1.12.4ZM158.7,342.63l.36.37-.36.37-.35-.37.35-.37Z\"/>\r\n        <path class=\"cls-1\" d=\"M161.53,340.67h.36v3.27c0,.34.06.58.18.71s.3.21.55.21h.14v.42h-.14c-.38,0-.66-.11-.83-.33-.17-.22-.26-.55-.26-1v-3.27Z\"/>\r\n        <path class=\"cls-1\" d=\"M162.63,344.85h.62c.29,0,.5-.07.65-.21.15-.14.22-.37.23-.69,0-.1,0-.19,0-.28,0-.08,0-.17-.02-.24l.35-.04.05.69c.02.25.09.44.22.57s.29.2.48.2h.13v.42h-.13c-.24,0-.44-.06-.58-.2-.15-.13-.24-.26-.29-.39-.09.2-.23.35-.42.44-.19.1-.41.14-.66.14h-.62v-.42ZM163.24,341.87l.34.35-.34.35-.34-.35.34-.35ZM164.15,341.87l.34.35-.34.35-.33-.35.33-.35Z\"/>\r\n        <path class=\"cls-1\" d=\"M167.5,345.27c-.26,0-.46-.05-.59-.16-.14-.11-.24-.25-.3-.43-.09.2-.22.35-.39.45s-.4.15-.71.15h-.3v-.42h.31c.3,0,.53-.06.68-.19s.22-.35.22-.67c0-.05,0-.12,0-.19,0-.07,0-.16-.02-.27l.35-.05.05.61c.02.21.08.39.2.54s.29.22.51.22c.26,0,.44-.08.54-.23.1-.15.15-.36.15-.63,0-.05,0-.12,0-.19,0-.07-.01-.16-.02-.27l.35-.05.05.61c.01.21.07.39.17.54s.26.22.47.22.37-.08.45-.25c.08-.16.13-.35.13-.57,0-.15-.01-.31-.04-.46-.02-.16-.05-.29-.08-.4l.37-.1c.04.14.07.29.08.45.02.16.03.31.03.47,0,.22-.03.43-.09.63-.06.19-.16.35-.3.47-.14.12-.32.18-.56.18-.24,0-.42-.06-.55-.17-.13-.11-.22-.25-.28-.42-.09.19-.21.33-.35.43-.14.1-.33.15-.55.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M170.18,347.09l-.12-.36c.49-.13.85-.35,1.08-.66.23-.31.34-.68.34-1.12,0-.18-.02-.37-.05-.57-.04-.2-.09-.41-.15-.62l.36-.13c.14.43.21.85.21,1.25,0,.54-.14,1.01-.42,1.41-.28.4-.69.66-1.25.79ZM171.32,342.07l.36.37-.36.37-.35-.37.35-.37Z\"/>\r\n        <path class=\"cls-1\" d=\"M173.6,342.98c.26,0,.48.08.64.25.17.17.29.4.37.68.08.28.12.6.12.95h.49v.42h-.52c-.07.45-.26.83-.55,1.14-.29.31-.75.53-1.36.67l-.13-.36c.49-.11.87-.29,1.16-.52.29-.23.46-.54.54-.94h-.62c-.38,0-.66-.07-.85-.22-.2-.15-.29-.39-.29-.72,0-.22.04-.43.12-.64.08-.21.19-.38.34-.51.15-.13.33-.2.55-.2ZM173.7,344.85h.67c-.01-.27-.04-.51-.09-.73-.05-.22-.13-.4-.24-.53-.11-.13-.26-.2-.46-.2-.16,0-.28.05-.37.15-.09.1-.16.22-.2.36-.04.14-.06.28-.06.41,0,.21.06.35.2.43.13.08.32.12.55.12Z\"/>\r\n        <path class=\"cls-1\" d=\"M175.09,344.85h.56c.28,0,.54-.03.79-.09.24-.06.48-.14.71-.24.23-.1.47-.21.71-.33.24-.12.5-.24.78-.36-.19-.06-.37-.13-.56-.21s-.37-.15-.53-.23-.32-.13-.45-.18c-.13-.05-.23-.07-.29-.07-.16,0-.29.04-.4.13-.11.08-.21.18-.29.3l-.06.08-.33-.17.04-.06c.14-.21.29-.38.46-.5s.37-.18.59-.18c.12,0,.28.04.47.12.19.08.41.18.64.29.23.11.46.21.7.3.24.09.46.14.67.16v.41c-.16.04-.34.1-.54.18s-.46.21-.77.37c-.3.15-.58.28-.82.39-.25.11-.49.19-.73.24-.24.05-.5.08-.78.08h-.55v-.42ZM177.14,341.23l.36.37-.36.37-.35-.37.35-.37Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M168.69,329.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM168.18,330.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M168.25,330.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM168.29,331.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M89.55,283.45c.07-.26.16-.5.26-.71.1-.22.23-.39.38-.52.16-.13.35-.2.59-.2.22,0,.41.06.58.17.17.12.3.27.39.48.09.2.14.43.14.68,0,.29-.08.52-.23.7-.15.17-.38.26-.68.26-.12,0-.25-.02-.38-.07-.13-.04-.25-.09-.37-.15-.12-.06-.23-.11-.33-.15-.1-.04-.19-.06-.27-.06-.17,0-.29.06-.36.18s-.12.29-.14.51-.03.49-.03.8c0,.21,0,.4,0,.55,0,.15.02.33.03.53h-.37c0-.2-.02-.38-.02-.55s0-.34,0-.51c0-.25,0-.48.02-.7.01-.22.04-.42.1-.59.05-.17.13-.32.24-.43.11-.11.26-.18.46-.21ZM91.53,283.35c0-.26-.07-.48-.21-.66-.14-.18-.32-.27-.54-.27-.17,0-.31.06-.42.17-.11.11-.2.25-.27.42s-.13.34-.18.51c.13.05.26.11.4.17s.26.11.38.16c.12.04.22.06.29.06.17,0,.3-.05.4-.15.09-.1.14-.24.14-.41Z\"/>\r\n        <path class=\"cls-1\" d=\"M94.61,283.53c.15-.11.27-.27.35-.48s.12-.48.12-.82v-2.57h.36v2.75c0,.27.02.52.07.74s.12.39.23.51.25.19.44.19h.16v.42h-.16c-.3,0-.52-.09-.67-.28-.15-.19-.24-.42-.29-.69-.16.32-.41.56-.74.72-.34.17-.78.25-1.34.25-.07,0-.15,0-.23,0-.08,0-.16,0-.24-.01v-.39c.11,0,.21.01.29.02s.16,0,.24,0c.12,0,.21,0,.29,0,.07,0,.15-.01.22-.02-.06-.42-.12-.82-.2-1.18s-.18-.77-.31-1.23c-.13-.46-.3-.93-.5-1.42l.33-.16c.2.51.37.99.5,1.46.13.47.24.89.31,1.26.08.37.14.77.21,1.2.22-.06.41-.14.56-.25Z\"/>\r\n        <path class=\"cls-1\" d=\"M96.39,284.94l.34.35-.34.35-.34-.35.34-.35ZM96.2,283.85h.71c.25,0,.42-.07.52-.22.09-.15.14-.34.14-.58,0-.13-.01-.28-.03-.44-.02-.16-.05-.32-.07-.47l.38-.1c.07.33.1.64.1.94,0,.39-.08.71-.23.94-.15.24-.42.35-.8.35h-.72v-.42ZM97.3,284.94l.34.35-.34.35-.33-.35.33-.35Z\"/>\r\n        <path class=\"cls-1\" d=\"M99.24,279.67v4.6h-.36v-4.6h.36Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M94.69,268.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM94.18,269.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M94.25,269.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM94.29,270.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M76.01,231.83l-.11-.1.23-.31c.24.21.47.41.67.6.2.2.37.39.49.59.12.2.18.4.18.61,0,.33-.11.58-.32.76-.21.18-.49.27-.83.27s-.63-.09-.84-.26c-.21-.17-.31-.4-.31-.69,0-.24.07-.48.21-.72.14-.24.35-.49.62-.76ZM77.11,233.2c0-.12-.04-.25-.13-.38-.08-.13-.19-.26-.31-.38s-.25-.24-.38-.35c-.19.19-.36.38-.51.57-.15.19-.22.4-.22.6,0,.19.07.33.2.44.13.1.32.15.57.15s.45-.05.58-.16.2-.27.2-.5Z\"/>\r\n        <path class=\"cls-1\" d=\"M78.4,229.67h.36v3.27c0,.34.06.58.18.71s.3.21.55.21h.14v.42h-.14c-.38,0-.66-.11-.83-.33-.17-.22-.26-.55-.26-1v-3.27Z\"/>\r\n        <path class=\"cls-1\" d=\"M83.51,234.27c-.24,0-.42-.06-.55-.17-.13-.11-.22-.25-.28-.42-.09.19-.21.33-.35.43-.14.1-.33.15-.55.15-.26,0-.46-.05-.59-.16-.14-.11-.24-.25-.3-.43-.09.2-.22.35-.39.45s-.4.15-.71.15h-.3v-.42h.31c.3,0,.53-.06.68-.19s.22-.35.22-.67c0-.05,0-.12,0-.19,0-.07,0-.16-.02-.27l.35-.05.05.61c.02.21.08.39.2.54s.29.22.51.22c.26,0,.44-.08.54-.23.1-.15.15-.36.15-.63,0-.05,0-.12,0-.19,0-.07-.01-.16-.02-.27l.35-.05.05.61c.01.21.07.39.17.54s.26.22.47.22.36-.08.45-.24c.09-.16.14-.37.14-.62,0-.07,0-.15,0-.23,0-.08-.01-.17-.02-.29l.35-.04.05.66c.02.23.08.41.21.55.12.14.29.21.49.21h.15v.42h-.15c-.22,0-.41-.05-.55-.15-.15-.1-.25-.25-.3-.45-.07.19-.16.34-.28.44-.12.11-.29.16-.52.16ZM82.01,230.93l.33.34-.33.34-.33-.34.33-.34ZM82.49,230.16l.33.34-.33.34-.33-.34.33-.34ZM82.97,230.93l.33.34-.33.34-.33-.34.33-.34Z\"/>\r\n        <path class=\"cls-1\" d=\"M85.71,234.27h-.54v-.42h.53c.25,0,.42-.07.52-.22s.14-.34.14-.58c0-.13,0-.28-.03-.44-.02-.16-.04-.32-.07-.47l.38-.1c.07.33.1.64.1.94,0,.39-.08.71-.23.94-.15.24-.42.35-.8.35ZM86.11,230.53l.36.37-.36.37-.35-.37.35-.37Z\"/>\r\n        <path class=\"cls-1\" d=\"M87.67,229.67h.36v3.27c0,.34.06.58.18.71s.3.21.55.21h.14v.42h-.14c-.38,0-.66-.11-.83-.33-.17-.22-.26-.55-.26-1v-3.27Z\"/>\r\n        <path class=\"cls-1\" d=\"M91.06,234.35c-.25,0-.47-.07-.66-.2-.19-.13-.37-.29-.54-.46-.12.17-.25.3-.38.42s-.31.17-.54.17h-.17v-.42h.17c.15,0,.28-.04.39-.13s.2-.2.28-.34.16-.29.23-.44c.08-.16.16-.3.25-.44.09-.14.21-.25.34-.34.13-.09.29-.13.49-.13.22,0,.42.06.58.17.16.11.29.26.38.45.09.19.13.4.13.64,0,.34-.08.6-.25.79-.16.19-.4.28-.7.28ZM90.91,232.42c-.14,0-.26.05-.37.15-.11.1-.2.21-.28.35s-.15.27-.2.41c.16.18.32.32.47.42.19.13.37.2.53.2.19,0,.33-.05.43-.16.1-.11.15-.26.15-.45,0-.26-.06-.47-.19-.65-.13-.18-.31-.26-.55-.26Z\"/>\r\n        <path class=\"cls-1\" d=\"M94.32,234.27c-.16,0-.3-.03-.41-.09s-.19-.13-.24-.21c0,.54-.16,1-.44,1.37-.29.37-.69.62-1.21.74l-.12-.35c.49-.13.85-.35,1.08-.66.23-.31.34-.68.34-1.12,0-.18-.02-.37-.05-.57-.04-.2-.09-.41-.15-.62l.36-.13.15.61c.05.19.13.34.24.45.11.11.26.16.44.16h.16v.42h-.14Z\"/>\r\n        <path class=\"cls-1\" d=\"M94.92,230.93c.17.13.37.27.59.43s.43.34.63.53c.2.19.37.4.5.61.13.21.2.44.2.67,0,.41-.15.7-.45.85s-.71.24-1.24.24h-.8v-.42h.8c.26,0,.49-.02.69-.05.2-.04.35-.1.46-.21.11-.1.17-.24.17-.43,0-.17-.06-.34-.17-.51-.12-.17-.26-.33-.44-.5-.18-.16-.36-.32-.55-.46s-.36-.28-.51-.4c-.06-.05-.12-.11-.17-.17-.05-.06-.08-.13-.08-.2,0-.08.03-.16.09-.22.06-.06.14-.11.24-.15l2.28-.96v.4l-2.22.94Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M86.69,218.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM86.18,219.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M86.25,219.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM86.29,220.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n    <g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M216.82,329.93c0,.77-.15,1.34-.45,1.71s-.78.56-1.43.56c-.45,0-.81-.08-1.09-.25s-.48-.39-.6-.69-.19-.63-.19-1.01c0-.25.02-.51.07-.77s.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7-.05.24-.07.47-.07.71,0,.43.11.78.33,1.05.22.27.59.4,1.12.4.5,0,.87-.14,1.11-.42s.36-.72.36-1.32v-5h.41v4.93Z\"/>\r\n        <path class=\"cls-1\" d=\"M218.08,325.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M224.12,328.36v.47c-.24.04-.5.13-.8.28.03.2.09.35.18.45.09.1.22.16.38.19s.38.04.63.04h.22v.48h-.23c-.34,0-.62-.03-.82-.1s-.37-.17-.47-.31-.18-.34-.22-.59c-.33.17-.66.34-.99.49-.33.15-.66.27-1,.37-.34.09-.68.14-1.04.14h-.63v-.48h.64c.32,0,.62-.03.9-.1.28-.07.55-.16.81-.27.26-.11.53-.24.81-.38.28-.14.57-.28.89-.41-.21-.07-.43-.15-.64-.24-.21-.09-.42-.17-.61-.26s-.36-.15-.51-.21-.26-.08-.34-.08c-.18,0-.33.05-.45.15s-.24.21-.34.34l-.07.09-.38-.19.04-.07c.16-.24.33-.43.52-.57.19-.14.42-.21.67-.21.14,0,.32.05.54.14.22.09.46.2.73.33s.53.24.8.34.53.16.77.18Z\"/>\r\n        <path class=\"cls-1\" d=\"M227.2,330.36c-.29,0-.54-.08-.75-.23-.21-.15-.42-.33-.62-.53-.14.19-.28.35-.44.47-.15.13-.36.19-.62.19h-.2v-.48h.19c.18,0,.32-.05.44-.15.12-.1.22-.23.32-.39.09-.16.18-.33.27-.51.09-.18.18-.35.29-.51s.24-.29.39-.39.33-.15.56-.15c.26,0,.48.06.67.19.19.13.33.3.43.52s.15.46.15.73c0,.39-.09.68-.28.9s-.45.32-.79.32ZM227.02,328.16c-.16,0-.3.06-.42.17-.12.11-.23.25-.32.4-.09.16-.17.31-.23.46.18.2.36.36.54.48.22.15.43.23.61.23.21,0,.38-.06.49-.18.12-.12.17-.29.17-.52,0-.29-.07-.54-.22-.74s-.35-.3-.62-.3Z\"/>\r\n        <path class=\"cls-1\" d=\"M228.29,332.35l-.14-.41c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65s-.1-.46-.17-.71l.41-.14c.16.5.24.97.24,1.43,0,.62-.16,1.16-.47,1.61-.32.45-.79.75-1.43.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M231.25,325.01h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M232.5,330.27v-.48h.88v-.12c0-.29.02-.58.07-.87.04-.28.12-.54.21-.77s.23-.42.38-.55c.16-.14.35-.21.58-.21.29,0,.51.11.67.32s.24.48.24.82-.08.65-.23.93c-.16.28-.37.51-.63.68s-.55.26-.86.26c.03.15.09.32.17.51s.2.37.34.55c.14.18.32.33.52.46-.02-.63.08-1.12.3-1.47.21-.35.6-.53,1.17-.53h.18v.48h-.18c-.3,0-.53.05-.68.16s-.26.27-.32.47-.08.45-.08.74c0,.05,0,.11,0,.18s0,.14,0,.19l-.33.32c-.43-.24-.77-.54-1.01-.92s-.4-.76-.46-1.16h-.92ZM234.62,327.72c-.19,0-.34.09-.46.27-.12.18-.21.41-.27.71s-.09.62-.09.97v.13c.27,0,.5-.06.7-.18.2-.12.36-.29.47-.5.11-.21.17-.45.17-.72,0-.2-.04-.36-.13-.49-.09-.13-.22-.19-.39-.19Z\"/>\r\n        <path class=\"cls-1\" d=\"M236.33,329.79h.64c.32,0,.62-.03.9-.1.28-.07.55-.16.81-.27.26-.11.53-.24.81-.38.28-.14.57-.28.89-.41-.21-.07-.43-.15-.64-.24-.21-.09-.42-.17-.61-.26s-.36-.15-.51-.21-.26-.08-.34-.08c-.18,0-.33.05-.45.15s-.24.21-.34.34l-.07.09-.38-.19.04-.07c.16-.24.33-.43.52-.57.19-.14.42-.21.67-.21.14,0,.32.05.54.14.22.09.46.2.73.33s.53.24.8.34.53.17.77.19v.47c-.18.04-.39.11-.62.21-.23.09-.52.24-.88.42-.34.17-.66.32-.94.44s-.56.21-.84.27-.57.09-.89.09h-.63v-.48ZM238.36,330.9l.38.39-.38.39-.37-.39.37-.39ZM238.91,331.78l.37.38-.37.39-.37-.39.37-.38ZM239.46,330.9l.37.39-.37.39-.37-.39.37-.39Z\"/>\r\n        <path class=\"cls-1\" d=\"M218.2,341.84c-.49,0-.89-.09-1.2-.27s-.54-.43-.69-.75-.22-.69-.22-1.11c0-.25.02-.51.07-.77s.11-.52.2-.78l.4.16c-.07.23-.12.46-.17.7-.05.24-.07.47-.07.71,0,.49.13.89.4,1.19s.69.45,1.28.45c.34,0,.66-.05.95-.14s.54-.22.72-.38.28-.36.28-.57c0-.12-.03-.22-.09-.31s-.17-.13-.33-.13h-.61c-.34,0-.57-.09-.7-.27-.13-.18-.2-.4-.2-.67,0-.32.06-.61.18-.88s.29-.49.52-.65.5-.25.83-.25c.13,0,.26.01.38.04s.25.08.37.16l-.14.39c-.19-.09-.39-.13-.6-.13-.35,0-.62.13-.81.38-.19.25-.28.56-.28.93,0,.17.04.3.11.36s.19.1.35.1h.62c.31,0,.52.08.63.25.12.16.17.38.17.65,0,.31-.1.58-.3.82-.2.24-.48.42-.84.56-.36.13-.76.2-1.22.2Z\"/>\r\n        <path class=\"cls-1\" d=\"M221.18,341.95l-.14-.41c.56-.15.97-.4,1.23-.75s.39-.78.39-1.28c0-.21-.02-.43-.06-.65s-.1-.46-.17-.71l.41-.14c.16.5.24.97.24,1.43,0,.62-.16,1.16-.47,1.61-.32.45-.79.75-1.43.9Z\"/>\r\n        <path class=\"cls-1\" d=\"M224.14,334.61h.41v3.73c0,.39.07.66.2.82.13.16.34.23.62.23h.16v.48h-.16c-.43,0-.75-.13-.94-.38-.2-.25-.3-.63-.3-1.14v-3.74Z\"/>\r\n        <path class=\"cls-1\" d=\"M225.6,340.63l.39.4-.39.4-.38-.4.38-.4ZM225.38,339.39h.56c.33,0,.58-.08.75-.24.17-.16.25-.42.26-.79,0-.11,0-.22,0-.31s-.01-.19-.02-.28l.4-.05.05.79c.02.28.1.5.25.65.15.15.34.22.55.22h.15v.48h-.15c-.28,0-.5-.07-.67-.22-.17-.15-.28-.3-.34-.45-.1.23-.26.4-.48.51-.22.11-.47.16-.75.16h-.56v-.48ZM226.64,340.63l.39.4-.39.4-.38-.4.38-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M228.18,339.39h.52c.33,0,.58-.08.75-.24s.25-.42.26-.79c0-.11,0-.22,0-.31s-.01-.19-.02-.28l.4-.05.05.79c.02.28.1.5.25.65s.33.22.55.22h.15v.48h-.15c-.28,0-.5-.07-.67-.22-.17-.15-.28-.3-.34-.45-.1.23-.26.4-.48.51-.22.11-.47.16-.75.16h-.52v-.48ZM228.7,335.98l.39.4-.39.4-.38-.4.38-.4ZM229.74,335.98l.39.4-.39.4-.38-.4.38-.4Z\"/>\r\n        <path class=\"cls-1\" d=\"M235.73,337.96v.47c-.24.04-.5.13-.8.28.03.2.09.35.18.45.09.1.22.16.38.19s.38.04.63.04h.22v.48h-.23c-.34,0-.62-.03-.82-.1s-.37-.17-.47-.31-.18-.34-.22-.59c-.33.17-.66.34-.99.49-.33.15-.66.27-1,.37-.34.09-.68.14-1.04.14h-.63v-.48h.64c.32,0,.62-.03.9-.1.28-.07.55-.16.81-.27.26-.11.53-.24.81-.38.28-.14.57-.28.89-.41-.21-.07-.43-.15-.64-.24-.21-.09-.42-.17-.61-.26s-.36-.15-.51-.21-.26-.08-.34-.08c-.18,0-.33.05-.45.15s-.24.21-.34.34l-.07.09-.38-.19.04-.07c.16-.24.33-.43.52-.57.19-.14.42-.21.67-.21.14,0,.32.05.54.14.22.09.46.2.73.33s.53.24.8.34.53.16.77.18ZM233.28,335.25l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n        <path class=\"cls-1\" d=\"M236.18,339.39h.68c.29,0,.49-.08.59-.25s.16-.39.16-.67c0-.15-.01-.32-.04-.5-.02-.18-.05-.36-.08-.54l.44-.12c.08.38.11.73.11,1.07,0,.45-.09.81-.26,1.08-.17.27-.48.4-.91.4h-.69v-.48ZM236.96,340.61l.41.42-.41.42-.4-.42.4-.42Z\"/>\r\n      </g>\r\n      <g>\r\n        <path class=\"cls-1\" d=\"M227.69,314.73c.19.05.38.07.57.12,1.2.33,2.14,1.56,2.13,2.81,0,1.16-1.27,3.21-1.98,4.14-.26.34-.54.71-.9.93h-.18c-.39-.23-.67-.61-.94-.96-.68-.9-1.6-2.4-1.85-3.49-.34-1.52.57-2.98,2.04-3.42l.57-.12h.53ZM227.18,315.2c-1.38.13-2.47,1.46-2.22,2.84.18,1,1.09,2.49,1.7,3.32.09.13.67.88.76.87.68-.7,1.27-1.57,1.73-2.42.61-1.13,1.13-2.23.38-3.45-.48-.78-1.43-1.23-2.35-1.15Z\"/>\r\n        <path class=\"cls-1\" d=\"M227.25,315.95c2.3-.22,2.58,3.28.34,3.47s-2.59-3.26-.34-3.47ZM227.29,316.41c-1.67.18-1.42,2.75.31,2.55,1.6-.18,1.36-2.72-.31-2.55Z\"/>\r\n      </g>\r\n    </g>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 230.09043,148.8044 0,0 5.59,1.11 2.16,0.86 0.61,0.89 1.29,1.19 1.42,0.62 5.55,1.23 2.2,2.6 -0.11,1.77 0,2.36 -1.91,1.18 -2.74,-0.33 -2.73,1.01 -2.05,2.36 -0.13,2.7 -0.41,2.02 -3.01,0.17 -0.96,2.53 -1.77,2.18 -2.19,1.35 -0.89,2.07 -1.56,0.14 -0.94,1.92 -0.96,0.2 -0.24,-1.39 0.01,-2.31 -1.31,-1.55 -1.91,-0.02 -0.43,1.12 1.31,1.82 0,0.7 -0.35,0.62 -0.85,-0.51 -1.95,-1.76 -3.32,-0.97 -3.42,-0.22 -1.46,-0.34 -0.73,-1.21 -0.86,-1.92 -0.28,-1.29 0.42,-1.63 1.86,-1.8 6.86,-3.35 1.16,-1.11 0.4,-1.54 1.63,-3.39 1.07,-3.62 -1.57,-1.35 -2.4,-0.72 -1.25,-1.07 -1.73,-2.38 0.98,-1.49 3.84,-0.31 8.06,0.86 z\"\r\n                        title=\"Alborz\" id=\"IR-32\" data-fa=\"البرز\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 468.28043,340.0844 0,0 38.55,17.43 4.85,3.63 13.52,19.71 -6.95,32.33 -0.3,3.24 0.8,0.85 1.53,1.01 1.35,3.42 1.17,8.21 -0.1,3.39 -1.03,3.84 -2.84,4.34 -0.49,2.5 0.49,2.57 0.04,3.17 1,2.09 0.35,1.5 -0.06,1.43 -0.99,1.08 -1.53,1.2 -7.88,4.59 -3.85,1.31 -1.96,1.05 1.26,1.95 2.78,2.11 1.21,1.95 -1.05,3.48 -3.91,5.11 0.23,13.28 -0.45,4.38 -3.9,15.31 0.01,3.77 0.82,3.2 0.12,1.42 -0.1,2.44 0.7,2.59 2.58,2.97 1.78,3.63 -0.96,2.88 -0.95,1.63 0.55,0.87 1.08,0.99 0.04,1.29 -1.09,1.3 -0.84,1.74 0.63,2.2 1.17,1.39 0.29,1.45 -0.54,1.45 -0.64,0.78 0.06,1.23 -0.46,0.61 -0.41,0.98 0.02,2.33 -0.2,1.4 -0.67,1.65 -1.38,-2.09 -0.49,-0.41 -0.93,0.01 -1.31,-0.52 -0.99,0.25 -1,1.05 -1.45,0.18 -1.68,-0.06 -1.4,-0.32 -0.57,-1.01 -0.1,-1.17 -0.34,-0.84 -0.08,-0.73 0.32,-0.7 0.05,-0.41 -0.64,-0.4 -2.11,-0.33 -1.3,-0.59 -1.19,-0.27 -1.17,0.55 -1.83,0.17 -2.78,-0.5 -4.49,0.32 -0.06,-0.77 0.69,-0.85 0.4,-2.11 0,-1.09 -0.19,-1.09 0.78,-7.39 0.47,-1.17 0.62,-0.76 0.19,-0.63 -0.05,-0.96 -0.82,-2.43 0.04,-0.76 0.73,0.04 2.12,1.29 0.29,-0.72 -0.97,-2.1 -1.99,-2.31 -2.53,-2.13 -2.33,-1.4 -2.23,-0.06 -1.39,0.95 -0.81,1.13 -1.6,1.5 -1.02,-0.32 -2.29,-1.69 -10.47,-5.56 -0.68,-2.21 -1.07,-14.26 -1.02,-2.99 -0.92,-1.88 -0.91,-0.46 -0.77,-1.11 0.59,-1.18 0.94,-0.79 -0.23,-1.92 -1.53,-2.33 -1.54,-1.69 -0.79,-1.52 -1.35,-1.76 -1.76,-0.96 -1.04,-0.13 -0.68,-0.57 -0.49,-0.81 -1.23,-5.97 0.3,-3.93 -0.27,-0.62 -3.53,-1.73 -1.84,-0.07 -1.56,1.23 -1.03,1.27 -3.67,3.49 -3.98,1.97 -2.17,0.39 -4.03,-0.62 -3.48,-2.11 -2.91,-2.68 -3.02,-3.91 -0.71,-3.76 0.84,-2.86 -0.65,-14.7 -0.95,-1.41 -1.02,0.13 -3.98,1.87 -6.77,5.14 -1.74,0.45 -1.52,-0.75 -1.48,-1.04 -1.48,-1.94 -3.03,-2.38 -6.12,-1.74 -2.87,-0.21 -6.85,-17.02 -1.97,-0.84 -7.76,-0.72 -1.51,-0.96 -0.81,-0.83 -0.74,-1.3 -0.38,-1.5 -2.75,-5.71 -0.93,-3.09 0.01,-0.77 1.49,-0.66 0.34,-0.29 3.42,-0.42 1.07,-0.76 -0.04,-1.11 -0.47,-1.56 -0.36,-2.22 0.43,-12.7 -1.09,-0.75 -1.09,-1.34 -0.81,-3.92 -2,-5.27 -1.89,-3.58 -0.09,-1.95 0.75,-2.87 1.57,-2.98 2.98,-3.33 19.03,-3.38 4.33,0.17 2.78,0.56 6.38,-0.87 5.74,-2.53 0.51,-2.75 0.44,-12.48 1.5,-3.23 17.98,-9.5 2.4,-2.55 7.04,-3.99 1.56,-1.69 0.73,-1.11 4.32,0.76 36.34,15.66 z\"\r\n                        title=\"Kerman\" id=\"IR-15\"  data-fa=\"کرمان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 596.00043,349.9544 0,0 1.86,0.27 0.88,0.35 0.66,0.53 1.21,1.54 0.24,0.74 -0.24,1.7 0.02,0.79 0.32,0.8 0.91,1.51 0.29,0.89 0.05,1.16 0.09,0.41 0.59,1.26 0.41,1.29 0.17,0.78 0,0.78 -0.24,0.83 -0.65,1.29 0.15,0.46 0.13,2.69 -0.2,0.12 -0.09,0.27 -0.05,0.72 0.05,0.04 0.08,0.21 -0.58,0.62 -2.79,3.38 -4.28,5.18 -3.88,4.7 0,0 -2.76,3.31 -3.66,4.39 -1.91,2.3 -2.8,3.35 -5.24,6.25 -0.01,0.01 -2.57,3.02 -1.96,2.3 2.74,3.24 1.79,2.13 2.21,2.65 2.55,3.06 2.65,3.18 2.79,3.33 0.66,0.54 0.71,0.29 0.6,0.42 0.31,0.99 -0.06,0.76 -0.41,1.36 0,0.76 0.33,0.79 1.07,1.19 0.44,0.67 0.1,0.43 0.09,0.97 0.18,0.44 0.36,0.41 0.31,0.11 0.31,0.04 0.37,0.2 0.34,0.55 0.18,0.66 0.26,0.56 0.58,0.25 0.33,0.26 0.1,0.34 -0.12,0.35 -0.31,0.33 -0.24,0.25 -0.1,0.24 0.08,0.22 0.26,0.21 0.44,0.2 0.38,0.3 0.3,0.4 1.43,3.3 0.19,0.75 0.08,0.65 0.18,0.58 0.97,1.09 0.97,2.13 0.99,1.21 3.49,3.18 1.41,1.83 2.15,2 1.07,1.24 0.62,0.34 2.03,0.57 1.62,0.93 1.02,0.33 2.25,0.19 1.08,0.23 2.82,1.27 4.47,0.9 0.94,0.49 0.4,0.47 0.29,0.51 0.34,0.47 0.55,0.31 0.57,0.19 0.35,0.22 0.24,0.39 0.22,0.67 0.49,0.83 2.14,2.32 0.68,0.44 5.54,-1.13 0.76,0.46 0.16,1.34 -0.5,3.95 -0.54,4.36 0.63,2.65 0.88,3.69 0.21,2.27 0.28,3.09 0.17,1.92 0.33,3.53 0.18,1.99 -0.21,1.58 -1.78,4.02 0.67,0.81 0.16,0.41 -0.06,0.62 -0.16,0.54 -0.2,0.43 -0.33,0.25 -0.54,0.04 1.46,1.3 0.51,0.28 0.27,0 0.47,-0.28 0.23,-0.04 0.28,0.09 0.79,0.44 1.07,0.24 0.92,-0.05 1.97,-0.4 0.88,-0.13 1.78,-0.55 0.9,-0.05 0.56,0.06 0.44,-0.01 1.85,-0.59 0.34,0.01 0.42,0.15 0.88,0.81 0.38,0.23 0.84,0.31 0.31,0.2 0.36,0.39 0.48,0.72 1.16,2.56 -0.59,-0.23 -0.74,0 -0.66,0.29 -0.37,0.62 -0.13,0.38 -0.36,0.52 -0.14,0.38 -0.05,0.44 0.17,4.3 0.31,0.71 0.42,0.62 0.28,0.61 -0.11,0.69 -0.5,0.46 -1.38,0.23 -0.56,0.29 -0.24,0.6 -0.27,5.5 -0.36,1.52 -0.76,0.74 -0.34,-0.01 -0.27,-0.14 -0.24,-0.17 -0.29,-0.14 -0.33,-0.03 -0.98,0.22 -1.34,-0.03 -1.32,-0.21 -3.06,-0.07 -2.66,-0.07 -2.3,-0.06 -0.37,0.11 -0.26,0.35 -0.35,0.64 -0.23,0.18 -0.25,0.13 -0.29,0.11 -1.05,0.24 -0.29,-0.02 -0.37,-0.18 -0.37,-0.08 -0.29,0.18 -0.27,0.28 -0.28,0.22 -0.69,0.25 -5.67,0.6 -0.32,0.09 -0.27,0.21 -0.27,0.49 -0.2,0.18 -0.35,0.1 -0.71,-0.04 -0.32,0.04 -0.28,0.12 -0.44,0.32 -0.27,0.16 -0.67,0.26 -0.29,0.19 -0.21,0.29 -0.07,0.33 0.11,0.25 0.12,0.21 0.04,0.23 -0.35,0.66 -1.07,1.05 -0.24,0.47 0.19,0.87 0.33,0.69 0.03,0.54 -0.74,0.39 -1.27,-0.18 -1.5,-0.53 -1.28,-0.17 -0.57,0.92 -0.12,0.92 -0.31,0.39 -1.4,0.24 -0.7,0.21 -0.63,0.32 -1.22,0.81 -4.08,1.16 -0.82,0.64 -0.49,1.02 -0.29,1.17 -0.31,2.29 -0.27,2.03 -0.32,2.34 -0.43,3.14 -0.36,2.63 -0.19,0.66 -0.51,0.63 -0.59,0.13 -0.65,-0.01 -0.72,0.17 -0.71,0.99 0.16,1.38 0.38,1.49 -0.1,1.3 -0.21,0.29 -0.5,0.5 -0.2,0.36 -0.11,0.54 -0.14,2.19 -0.21,3.21 -0.24,3.73 -0.2,3.16 -1.07,3.12 -0.01,0 -0.21,-0.54 -0.07,-0.63 -0.59,-0.43 -0.11,-0.23 -0.16,-0.11 -0.33,0.22 -0.1,0.21 -0.05,0.6 -0.1,0.23 0.19,0.18 0.33,0.39 0.19,0.17 -0.72,-0.08 -0.55,-0.22 -0.56,-0.01 -0.73,0.57 0.8,0.26 0.33,0.18 0.27,0.33 -0.18,0.36 -0.53,0.68 -0.15,0.4 0,0.19 -0.04,0.15 -0.27,0.26 -0.49,0.26 -1.84,0.55 0.49,0.34 -0.79,1.06 -5.7,-1.96 -1.98,-0.43 0.01,-0.61 -0.51,-0.93 -4.73,-1.69 -5.55,-0.93 -4.71,-1.12 -3.19,-0.39 -0.56,-0.31 0.52,-0.49 -0.82,-1.18 -0.1,-0.5 -0.01,-2.1 -0.11,-0.33 -1.23,-1.23 -0.53,-0.31 -0.59,-0.07 -0.61,0.06 -2.32,0.71 -0.58,0.33 -0.32,0.51 -0.53,0.64 -0.28,0.41 0,0.25 0.1,0.23 0.13,0.76 0.17,0.11 0.23,0.02 0.38,0.19 0.29,-0.01 0.14,0.1 0.14,0.23 0.35,0.39 -0.37,-0.06 0,0.09 0.98,0.5 -0.1,0.48 -0.39,-0.09 -1.09,-0.46 -1.38,-0.57 -0.68,-0.39 -1.47,0.03 -0.98,-0.8 0.32,-0.6 0.14,-0.15 -0.49,-0.22 -0.62,-0.09 -1.22,0.06 -0.94,0.18 -0.2,0.07 -0.3,0.35 0,0.21 0.09,0.19 0.7,0.48 -0.23,0.7 -0.92,-0.01 -0.68,-0.45 -0.37,-0.12 -1.16,-0.17 -0.26,-0.2 -0.38,-0.49 -0.53,-0.29 -1.25,0.08 -1.72,0.26 -1.82,0.07 -1.25,0.94 -1.42,-0.49 -1.42,-1.36 -1.53,-0.4 -3.91,0.24 -1.53,-0.01 -2.58,-0.6 -1.61,-1.64 -1.23,-0.68 -1.92,0.37 -4,0.64 -0.95,0.15 -0.15,-0.89 0.89,-0.39 0.02,-0.57 0.09,-0.6 -0.63,-0.31 -0.28,-0.37 -1.2,-2.05 -0.56,-0.56 -0.46,-0.6 -0.23,-0.77 -0.55,-0.68 -1.02,-0.39 -0.75,-0.76 -0.18,-1.36 -1.09,-1.8 -6.42,-5.68 -1.21,-0.76 -0.46,-0.2 -0.13,-0.68 0.16,-1.21 0.61,-0.93 0.41,-0.22 0.67,-1.65 0.2,-1.4 -0.02,-2.33 0.41,-0.98 0.46,-0.61 -0.06,-1.23 0.64,-0.78 0.54,-1.45 -0.29,-1.45 -1.17,-1.39 -0.63,-2.2 0.84,-1.74 1.09,-1.3 -0.04,-1.29 -1.08,-0.99 -0.55,-0.87 0.95,-1.63 0.96,-2.88 -1.78,-3.63 -2.58,-2.97 -0.7,-2.59 0.1,-2.44 -0.12,-1.42 -0.82,-3.2 -0.01,-3.77 3.9,-15.31 0.45,-4.38 -0.23,-13.28 3.91,-5.11 1.05,-3.48 -1.21,-1.95 -2.78,-2.11 -1.26,-1.95 1.96,-1.05 3.85,-1.31 7.88,-4.59 1.53,-1.2 0.99,-1.08 0.06,-1.43 -0.35,-1.5 -1,-2.09 -0.04,-3.17 -0.49,-2.57 0.49,-2.5 2.84,-4.34 1.03,-3.84 0.1,-3.39 -1.17,-8.21 -1.35,-3.42 -1.53,-1.01 -0.8,-0.85 0.3,-3.24 6.95,-32.33 1.06,-0.51 25.41,-7.22 1.85,0.33 1.19,1.27 0.77,0.62 3.14,0.86 4.17,3.08 5.33,7.61 2.78,2.38 4.6,-0.16 1.15,-0.45 0.53,-0.82 0.06,-1.22 -1.72,-7.64 -0.14,-3 0.7,-10.31 1.61,-5.8 2.17,-5.22 0.47,-4.78 -0.62,-2.31 5.75,0.85 6.64,0.97 3.9,0.57 z\"\r\n                        title=\"Sistan and Baluchestan\" id=\"IR-13\"  data-fa=\"سیستان و بلوچستان\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 456.82043,80.6944 0,0 0.54,-0.08 0.52,-0.16 0.58,-0.09 0.57,0.07 1.72,0.5 1.65,-0.03 0.51,-0.13 0.51,0 0.46,0.29 0.42,0.37 0.43,0.27 0.17,0.02 -4.11,2.54 -1.28,1.3 0.01,1.87 -0.39,1.59 -0.55,1.48 1.29,0.93 15.19,0.72 0.64,0.8 0.43,1.46 0.78,1.78 3.07,2.88 0.93,1.91 0.21,1.71 -0.75,1.37 -0.89,1.1 -0.31,0.74 -0.03,0.85 -0.34,1.26 -1.22,1.71 -2.03,6.01 -1.38,1.71 0.16,1.48 1.66,1.15 0.94,1.04 0.61,1.19 0.9,-0.14 0.49,-1.28 0.44,-0.2 0.29,1.09 0.68,1.04 1.12,0.54 0.13,0.98 -2.01,2.17 -0.22,1.18 0.44,0.67 1.21,0.72 0.28,1.32 -1.13,3.3 -1.27,1.2 -2.56,0.63 -9.38,-1.44 -22.43,-12.47 -5.4,-0.26 -8.16,6.63 -1.95,2.61 -0.27,1.92 0.26,1.5 -0.11,1.15 -5.16,0.87 -1.68,-0.65 -3.23,-0.55 -1.9,-0.64 -3.85,-3.31 -4.01,-4.51 -0.63,-1.34 0.12,-0.85 0.64,-2.53 0.17,-2.88 -0.17,-1.12 -0.21,-0.45 -0.22,-0.34 0.21,-0.63 0.87,-0.7 1.98,-0.59 0.35,-0.97 -1.65,-0.69 -1.33,0.23 -2.41,-1.7 -5.12,-6.83 1.03,-1 2.47,-4.4 2.46,-1.02 1.03,-0.95 1.02,-0.46 0.91,-0.14 3.97,-1.38 1.86,-2.6 -0.63,-2.61 -1.38,-1.06 -1.6,-0.79 -1.15,-1.37 -0.07,-1.94 0.69,-2.77 0.03,-1.02 -0.41,-1.8 -0.09,-1.56 0.22,-1.22 -0.22,-3.01 1.05,0.43 0.55,0.08 2.9,-0.49 0.53,-0.4 0.34,-0.67 0.12,-0.8 -0.16,-0.75 -0.92,-1.06 0.21,-0.59 2.14,-1.99 1.14,-0.8 1.23,-0.47 3.11,-0.1 0.57,0.14 0.48,0.29 0.42,0.34 0.46,0.21 0.54,-0.1 2.72,-1.19 1.62,-0.28 0.33,0.06 1.32,1.09 1.16,0.67 0.53,0.17 5.09,0.96 1.35,0.55 0.69,0.11 0.61,-0.34 0.47,-0.42 1.1,-0.74 0.4,-0.43 0.68,-1.19 0.1,-0.12 0.3,-0.32 0.59,-0.28 0.37,-0.05 0.37,0.05 0.72,0.24 0.38,0.25 0.09,0.28 0.02,0.32 0.14,0.38 0.78,1.33 0.61,1.49 0.4,0.6 1.11,1.2 0.39,1.29 0.73,1.03 0.16,0.76 -0.08,0.71 -0.67,2.27 0.86,1.15 4.87,1.94 z\"\r\n                        title=\"North Khorasan\" id=\"IR-31\"  data-fa=\"خراسان شمالی\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n\r\n                    <path\r\n                        d=\"m 467.11043,83.0344 0,0 0.55,-0.04 0.57,-0.13 0.55,-0.05 1.18,0.32 5.31,2.56 2.23,0.53 1.14,0.09 0.55,0.13 0.57,0.28 0.25,0.29 0.01,0.3 -0.08,0.3 0.03,0.34 0.54,1 0.12,0.32 0.08,0.78 0.01,0.59 0.16,0.49 0.58,0.48 0.58,0.22 2.64,0.4 0.42,0.2 0.9,0.64 0.47,0.13 3.07,-0.31 0.58,-0.28 0.46,-0.71 0.31,-0.72 0.41,-0.6 0.52,-0.38 0.66,-0.05 0.56,0.29 1.7,1.51 1.46,0.6 0.77,0.12 0.76,-0.08 0.29,-0.18 0.22,-0.26 0.24,-0.2 0.38,0 0.72,0.14 0.35,-0.03 0.36,-0.12 0.45,-0.56 0.08,-0.64 0.19,-0.29 2.03,1.13 2.63,0.61 1.33,0.61 0.48,0.35 0.45,0.15 0.98,0.15 0.38,0.2 1.11,1.15 4.51,3.27 0.73,0.07 1.9,-0.88 0.78,0.21 0.68,0.65 0.65,0.91 0.16,0.56 -0.1,0.95 0.2,0.46 0.09,0.36 -0.14,0.38 -0.21,0.42 -0.11,0.47 0.08,0.9 0.67,2.93 0.39,0.59 2.12,1.77 0.64,0.71 0.2,0.28 -0.04,0.21 -0.13,0.14 -0.04,0.12 -0.05,0.29 -0.1,0.35 0.1,0.3 0.56,0.15 0.22,0.23 0.27,0.22 0.29,0.14 0.28,0.02 1.07,-0.43 0.5,0.09 0.57,0.61 0.24,0.66 0.16,0.81 0.24,0.7 0.45,0.36 0.32,-0.07 0.24,-0.25 0.4,-0.63 0.32,-0.17 0.36,0.02 4.87,1.6 2.22,1.88 1.25,0.73 2.78,0.5 1.27,0.55 1,1.35 1.27,2.71 1.57,2.4 3.59,4.39 0.71,1.15 0.98,2.59 0.7,1.23 1.12,0.63 5.38,-0.1 4.74,-0.09 7.22,-0.13 4.02,-0.07 3.47,-0.06 1.68,0.29 1.38,0.19 0.28,1.44 0.28,0.65 0.12,0.39 0.06,0.53 -0.05,0.51 -0.13,0.47 -0.19,0.41 -0.21,0.32 -0.14,0.45 0.05,0.5 0.21,0.63 -0.73,3.39 -0.2,2.07 0.48,1.2 -0.1,0.17 -0.06,0.12 -0.09,0.29 0.33,0.14 0.27,0.21 0.21,0.26 0.14,0.25 0.13,0.44 0.06,0.44 0.02,0.97 0.11,0.41 0.49,0.82 0.51,2.61 0.09,1.26 0.05,0.21 -0.06,0.26 -0.36,0.47 -0.17,0.29 -0.1,0.37 -0.06,0.41 -0.02,0.39 -0.13,0.45 -0.28,0.21 -0.32,0.13 -0.21,0.19 -0.1,0.51 0.12,0.84 -0.02,0.39 -0.42,0.45 -0.69,0.56 -0.39,0.5 0.47,0.21 0.83,0.13 0.68,0.37 0.59,0.55 0.55,0.66 0.35,0.58 0.3,0.71 0.21,0.73 0.15,1.5 0.13,0.63 0.02,0.68 -0.22,0.93 0.22,0.31 0,0.41 -0.22,0.99 -0.02,0.23 0.02,0.74 -0.1,0.29 -0.46,0.46 -0.14,0.25 0.09,1.11 0.46,0.94 0.83,1.29 0.24,0.38 0.36,1.71 0.09,0.84 -0.21,0.86 -0.46,0.79 -0.79,0.97 -0.37,0.8 -0.3,1.3 -0.18,0.43 -0.71,0.96 -0.2,0.46 -0.16,0.85 0.16,2.14 -0.27,0.73 -0.65,0.38 -0.81,0.13 -0.72,0.02 -0.49,0.4 -0.2,0.89 -0.02,0.88 0.02,0.4 0.19,0.18 0.16,0.4 -0.01,0.4 -0.34,0.18 -0.2,0.19 0.17,0.41 1.21,1.63 0.09,0.18 -0.07,0.47 -0.09,0.36 0.06,0.34 0.35,0.38 -0.82,1.16 -0.24,0.59 -0.2,1.71 -0.5,1.55 -0.11,0.81 -0.11,0.39 -0.47,0.78 -0.11,0.52 0.03,0.42 0.15,0.77 0.03,0.36 -0.15,1.45 -0.27,1.37 -1.04,0.34 -0.19,0.69 -0.66,1.18 -1.07,0.84 -0.61,0.72 -0.05,0.97 0.12,1.06 -0.14,1.01 -0.35,0.47 -0.4,0.09 -0.44,-0.03 -0.47,0.07 -0.46,0.26 -0.22,0.28 -0.17,0.33 -1.54,1.76 -0.66,0.45 -0.84,0.24 -1.86,0.25 -0.84,0.43 -0.5,0.87 0.36,0.05 0.29,0.16 0.22,0.29 0.29,0.98 0.3,0.28 0.83,0.38 0.41,0.38 0.33,0.47 0.54,1.07 2.51,3.28 0.38,0.77 -2.52,0.14 -3.44,0.22 -2.39,0.14 0.23,0.87 -0.53,0.58 -1.61,0.86 -1.18,1.24 -1.07,1.39 -0.95,1.92 -0.21,1.83 0.06,0.55 -0.01,0 -2.64,0.45 -21.07,0.06 -4.45,-1.58 -3.32,-5.44 -1.82,-1.56 -3.53,1.32 -3.14,1.81 -10.05,1.49 -0.97,1.08 -0.92,0.67 -3.48,-1.06 -5.39,-0.69 -1.82,0.7 -0.49,1.17 0.19,1.07 1.32,2.14 -0.32,2.71 -0.71,3 0.36,1.8 -0.13,1.62 -0.87,2.09 -0.51,2.31 0.16,1.74 0.95,0.92 0.79,0.58 0.35,0.96 0.29,1.17 5.13,3.75 -1.01,1.87 -0.2,1.16 -1.69,2.71 -1.51,1.54 -10.64,7.07 -4.7,7.14 -1.12,4.78 -1.45,2.49 -0.85,1.02 -0.89,-0.64 -2.74,-4.3 -2.87,-1.8 -2.19,-0.99 -0.81,-0.63 -2.88,-1.65 -2.2,-5.05 -2.53,-17.12 -1.34,-2.59 -1.45,-1.85 -8.66,2.02 -6.72,-0.81 -1.59,-2.51 -2.11,-11.75 0.28,-6.91 4.26,-12.86 2.31,-4.17 13.42,-9.52 3.28,-3.22 0.46,-2.64 -1.16,-2.61 -9.88,-7.59 -3.77,-0.99 -8.52,2.2 -13.46,6.4 -13.84,3.62 5.44,-6.75 4.37,-4 3.85,-2.3 7.15,-2.69 1.03,-0.81 1.44,-3.35 5.89,-10.15 0.52,-2.91 -2.22,-2.56 -8.03,-6.57 -0.92,-2.35 -1.1,-5.06 -0.64,-7.87 0.5,-4.58 1.37,-2.62 0.91,-3.93 -0.83,-3.32 -1.37,-0.82 -1.08,-0.04 -0.67,0.19 0.11,-1.15 -0.26,-1.5 0.27,-1.92 1.95,-2.61 8.16,-6.63 5.4,0.26 22.43,12.47 9.38,1.44 2.56,-0.63 1.27,-1.2 1.13,-3.3 -0.28,-1.32 -1.21,-0.72 -0.44,-0.67 0.22,-1.18 2.01,-2.17 -0.13,-0.98 -1.12,-0.54 -0.68,-1.04 -0.29,-1.09 -0.44,0.2 -0.49,1.28 -0.9,0.14 -0.61,-1.19 -0.94,-1.04 -1.66,-1.15 -0.16,-1.48 1.38,-1.71 2.03,-6.01 1.22,-1.71 0.34,-1.26 0.03,-0.85 0.31,-0.74 0.89,-1.1 0.75,-1.37 -0.21,-1.71 -0.93,-1.91 -3.07,-2.88 -0.78,-1.78 -0.43,-1.46 -0.64,-0.8 -15.19,-0.72 -1.29,-0.93 0.55,-1.48 0.39,-1.59 -0.01,-1.87 1.28,-1.3 4.11,-2.54 0.12,0.01 0.55,-0.13 0.28,0.07 0.24,0.24 0.31,0.65 0.2,0.26 0.51,0.21 z\"\r\n                        title=\"Razavi Khorasan\" id=\"IR-30\" data-fa=\"خراسان رضوی\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 534.43043,242.0644 0,0 21.07,-0.06 2.64,-0.45 0.01,0 0.37,3.54 0.97,6.24 -0.07,1.6 -1.05,2.36 -0.27,1.34 0.84,2.97 2.14,2.05 2.73,1.14 2.65,0.2 2.49,-0.13 1.31,0.1 1.14,0.28 0.52,0.31 0.57,0.52 0.3,0.58 -0.03,0.06 -0.26,0.45 -0.5,0.18 -1.61,0.11 -0.6,0.4 -0.1,0.58 0.12,0.68 0.06,0.7 -0.18,0.81 -0.36,0.46 -1.11,0.7 -0.97,0.87 -1.29,1.75 -1.65,2.24 -1.84,2.49 -1.64,2.22 -0.21,0.57 0.05,3.2 0.5,2.58 0.97,3.31 1.14,3.9 1.18,4.02 1.25,4.24 1.38,4.65 1.49,5.56 1.15,4.29 -0.07,3.26 -0.46,3.18 -0.2,0.67 -0.89,1.14 -0.26,0.62 0.12,0.24 0.28,0.17 0.2,0.22 -0.29,0.88 0.07,0.41 0.17,0.39 0.13,0.43 0.06,0.87 -0.25,2.46 0.07,1.93 0.47,3.69 -0.43,2.94 0.08,0.93 0.51,1.92 0.4,3.73 1.12,0.47 3.42,0.5 5.68,0.84 0.05,0 0.62,2.31 -0.47,4.78 -2.17,5.22 -1.61,5.8 -0.7,10.31 0.14,3 1.72,7.64 -0.06,1.22 -0.53,0.82 -1.15,0.45 -4.6,0.16 -2.78,-2.38 -5.33,-7.61 -4.17,-3.08 -3.14,-0.86 -0.77,-0.62 -1.19,-1.27 -1.85,-0.33 -25.41,7.22 -1.06,0.51 -13.52,-19.71 -4.85,-3.63 -38.55,-17.43 0.48,-0.78 1.77,-4.57 3.48,-5.4 1.25,-3.49 4.51,-6.05 0.56,-1.87 0.3,-1.97 0.77,-2.23 0.08,-2.2 -1.36,-2.25 -1.03,-2.25 -0.06,-1.21 -0.99,-1.13 -0.52,-0.93 -0.24,-0.89 0.58,-1.44 0.91,-1.48 0.28,-1.25 -0.17,-3.08 0.85,-1.02 1.45,-2.49 1.12,-4.78 4.7,-7.14 10.64,-7.07 1.51,-1.54 1.69,-2.71 0.2,-1.16 1.01,-1.87 -5.13,-3.75 -0.29,-1.17 -0.35,-0.96 -0.79,-0.58 -0.95,-0.92 -0.16,-1.74 0.51,-2.31 0.87,-2.09 0.13,-1.62 -0.36,-1.8 0.71,-3 0.32,-2.71 -1.32,-2.14 -0.19,-1.07 0.49,-1.17 1.82,-0.7 5.39,0.69 3.48,1.06 0.92,-0.67 0.97,-1.08 10.05,-1.49 3.14,-1.81 3.53,-1.32 1.82,1.56 3.32,5.44 4.45,1.58 z\"\r\n                        title=\"South Khorasan\" id=\"IR-29\"  data-fa=\"خراسان جنوبی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 -4.99,-2.73 -1.22,0.34 0.6,1.67 1,1.3 0.4,0.89 -0.01,1.05 -2.41,0.82 -0.97,0.95 -1.11,0.5 -1.05,-0.29 -1.6,-3.33 -0.78,0.08 -1.77,1.99 -0.53,1.05 2.36,3.5 3.65,8.17 1.66,2.03 1.39,0.87 1.93,1.92 0.93,3.83 -0.67,3.09 -1.19,1.91 -1.13,0.99 -0.73,-0.39 -1.09,-2.68 -0.63,0.16 -0.38,1.16 -1.23,0.67 -2.08,0.59 -1.03,0.56 -1.05,0.04 -1.46,-0.22 -5.2,-5.88 -3.88,-1.76 -1.33,-1.15 -0.99,-0.08 -0.36,0.79 0.61,1.23 -0.11,1.4 -1.16,1.07 -4.85,0.32 -0.35,0.8 -0.21,2.69 -0.68,0.39 -1.33,-0.09 -2.11,0.21 -2.04,2.13 -1.42,0.48 -0.44,0.91 0,1.19 -0.72,0.83 -1.11,0.18 -0.66,0.89 -0.16,1.36 -1.3,0.69 -2.29,0.33 -3.06,-0.36 -2.03,0.22 -1.12,-1.23 -0.04,-1.63 0.27,-1.21 -0.14,-0.87 -0.77,0.06 -1.45,-1.01 -8.14,-11.14 -6.44,-5.08 -0.94,-0.32 0.08,-0.17 -0.25,-1.22 -0.81,-0.94 -1.87,-1.68 -2.17,-3.48 -0.44,-1.2 -0.01,-0.38 0.08,-0.34 0.18,-0.27 0.27,-0.21 0.13,-0.16 0.05,-0.17 -0.05,-0.18 -0.13,-0.17 -0.38,-0.79 -0.3,-0.85 0.16,-0.04 0.16,0 1.04,0.32 0.09,-0.58 -0.33,-1.6 0,-0.69 0.12,-0.73 0.27,-0.66 0.43,-0.47 0.7,-0.25 2.37,0.07 0.69,-0.16 1.7,-0.9 1.33,0.07 0.71,-0.08 0.53,-0.51 0.46,-0.68 1.03,-0.66 0.53,-0.48 0.4,-0.69 0.07,-0.65 -0.25,-0.56 -0.57,-0.4 -0.73,-0.07 -0.6,0.3 -0.58,0.4 -0.65,0.24 -1.43,0.31 -0.73,0.03 -0.68,-0.29 -0.28,-0.23 -0.21,-0.23 -0.14,-0.29 -0.17,-0.85 -0.16,-0.15 -0.25,-0.04 -1.04,-0.4 -0.56,-0.01 -0.55,0.2 -0.65,0.38 -0.68,0.22 -2.16,-0.1 -1.09,0.38 -0.35,-0.04 -0.34,-0.11 -0.35,-0.01 -0.82,0.7 -0.65,0.33 -0.7,0.05 -0.55,-0.38 -0.38,-0.08 -1.28,0.39 -0.61,-0.17 -0.41,-0.55 -0.87,-2.16 -1.57,-2.23 -1.01,-0.93 -0.92,-0.17 -0.44,-0.28 -1.25,-1.16 -1.3,-0.48 0,0 0.02,-0.02 1.14,-0.7 1.33,-1.33 0.56,-1.37 1.88,-2.14 0.46,-2.04 0.75,-0.77 0.39,-0.67 1.02,-1.11 5.51,-1.78 1.63,-2.48 0.05,-2.03 0.75,-0.97 2.96,-1.18 8.52,1.22 17.52,-1.62 0.4,0.33 0.24,0.51 0.48,0.64 0.68,0.57 0.58,0.64 1.3,0.9 3.51,0.97 3.84,0.34 2.56,-1.13 1.43,-1.66 0.58,-1.16 0.18,-0.66 -0.24,-0.69 0.14,-0.83 1,-0.61 0.83,-0.26 0.98,0.99 17.06,3.4 0.12,0.18 1.07,1.19 0.23,0.45 0.13,0.81 0.33,0.94 0.38,0.82 0.32,0.47 -0.35,0.33 -0.07,0.37 0.21,1.02 -0.05,0.29 -0.14,0.26 -0.11,0.28 0.04,0.31 0.14,0.06 0.59,0.07 0.64,2.37 0,4.26 -0.75,3.07 -1.33,1.4 -0.56,1.51 0.47,1.11 9.32,5.68 0.62,0.58 0.67,1.14 0.3,0.9 z\"\r\n                        title=\"Kordestan\" id=\"IR-16\"  data-fa=\"کردستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 164.84043,58.6444 0,0 0.1,3.8 -0.39,1.26 0.24,0.92 0.07,2.28 0.64,1.59 0.47,5.27 1.4,5.01 -0.27,0.83 -0.03,0.97 0.15,0.93 0.26,0.66 1.19,1.95 0.01,0.45 -0.1,0.38 -0.05,0.31 0.35,1.68 0.71,1.61 1.71,2.58 2.28,2.38 2.48,1.78 5.46,2.85 2.54,0.85 13.01,1.77 1.4,-0.22 1.16,-0.47 1.09,-0.2 1.21,0.62 -0.32,0.06 -0.38,-0.11 -0.2,-0.03 -0.26,0.35 2.82,1.1 4.41,1.02 1.59,0.61 1.07,1.02 -0.14,1.54 0.3,0.59 0.44,1.54 0.31,0.62 0.49,0.76 0.8,2.3 1.01,1.68 1.19,1.14 2.44,1.85 1.68,2.03 0.51,0.31 0.66,0.19 2.13,1.45 0,0 -0.02,0.14 -0.33,1.08 -1.16,1.6 -1.76,0.95 -1.36,1.35 -0.74,3.51 -2.08,3.71 -1.76,1.15 -4.6,-0.46 -2.81,0.63 -0.75,0.4 -0.7,0.24 -6.36,3.46 -1.68,0.3 -3.13,-0.63 -0.73,-0.5 -1.04,-0.18 -1.73,0.07 -4.65,-1.39 -2.06,-1.94 -1.91,-2.43 -0.43,-1.35 -0.06,-0.71 -3.21,-1.55 -2,-6.96 -1.44,-2.33 -3.76,-3.97 -5.1,-3.26 -0.37,-1.05 -0.29,-2.23 0.15,-1.86 -0.03,-1.22 -1.14,-1.45 -2.16,-1.71 -1.87,-1.93 -5.62,-8.86 -3.11,-8.63 0.07,-2.35 1.08,-1.68 0.3,-2.28 0.7,-1.66 7.65,-9.11 0.3,-0.79 -0.52,-0.56 -1.28,-0.29 -0.82,-0.33 -0.19,-0.81 -0.7,-0.92 -1.08,-0.96 -0.2,-0.45 1.56,0.13 0.82,-0.23 0.91,-0.39 0.86,-0.54 0.67,-0.68 0.76,-0.41 1.08,0 2.19,0.46 z\"\r\n                        title=\"Gilan\" id=\"IR-19\"  data-fa=\"گیلان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 88.71043,209.5144 0,0 0.77,-0.06 0.14,0.87 -0.27,1.21 0.04,1.63 1.12,1.23 2.03,-0.22 3.06,0.36 2.29,-0.33 1.3,-0.69 0.16,-1.36 0.66,-0.89 1.11,-0.18 0.72,-0.83 0,-1.19 0.44,-0.91 1.42,-0.48 2.04,-2.13 2.11,-0.21 1.33,0.09 0.68,-0.39 0.21,-2.69 0.35,-0.8 4.85,-0.32 1.16,-1.07 0.11,-1.4 -0.61,-1.23 0.36,-0.79 0.99,0.08 1.33,1.15 3.88,1.76 5.2,5.88 1.46,0.22 1.05,-0.04 0.02,0.63 -0.18,1.15 -1.12,1.29 -1.34,3.02 -1.59,2.35 -3.39,0.39 -1.08,0.43 -0.49,0.64 0.33,1.64 1.72,1.4 2.49,1.36 1.11,0.22 0.92,0.49 0.5,1.7 0.86,1.31 2.89,-3.02 1.56,-0.69 0.78,-0.17 0.65,0.99 0.34,1.67 -0.37,2.72 0.08,1.91 -1.03,0.85 -3.8,-0.81 -3.36,0.24 -1.24,1.9 -0.59,1.15 -2.33,-0.31 -0.98,0.26 -0.65,0.43 -0.11,0.92 0.31,2.21 -0.19,2.3 -1.64,0.85 -2.42,0.12 -1.96,0.97 -0.2,0.58 0.08,0.4 0.21,0.27 0.23,0.25 0.17,0.33 0.06,0.47 -0.1,0.76 0.04,0.44 0.13,0.31 -0.49,0.79 -0.59,0.42 -0.56,-0.17 -1.15,-0.1 -5.43,1.26 0,1.25 0.93,1.39 0.5,1.03 -0.47,2.64 -0.71,1.39 -5.31,-0.24 -5.76,1.47 -3.96,-0.32 -8.5,-2.75 -2.49,-2.16 -2.27,-1.4 -2.74,-0.63 -2.73,-0.2 -5.07,-2.08 -5.25,0.66 -2,-0.06 -0.62,0.73 0.47,1.56 -0.37,2.63 -1.29,4.06 -0.72,5.9 -0.76,0.64 -0.12,-0.31 -1.6,-1.15 -0.51,-0.51 -0.47,-0.67 -0.33,-0.66 -0.24,-0.72 -0.14,-0.82 -0.25,-0.68 -0.44,-0.49 -0.52,-0.44 -0.46,-0.5 -3.01,-5.5 -0.07,-0.06 -0.07,-0.03 -0.08,-0.01 -1,0.15 -0.88,-0.05 -0.77,-0.44 -0.7,-0.98 0.72,-0.33 0.33,-0.23 0.28,-0.29 0.01,0 0,0 0.51,-1.14 0.29,-1.04 0.38,-0.91 0.83,-0.72 0.49,-0.54 1.37,-1.12 0.35,-0.47 0,-0.45 -0.2,-0.35 -0.25,-0.36 -0.16,-0.47 0.07,-0.37 0.48,-0.78 0.16,-0.37 0.46,-1.97 0.06,-1.01 -0.18,-0.93 -0.52,-0.8 -0.7,-0.45 -0.76,0 -0.67,0.55 -0.63,-0.47 -0.43,-0.89 -1.05,-3.37 0.33,-0.54 1.78,-0.4 0.24,-0.23 0.22,-0.26 0.2,-0.29 0.16,-0.33 0.04,-1.22 -0.28,-1.66 0.14,-1.13 1.32,0.39 1.16,0.62 1.05,0.25 2.33,0.18 0.74,0.27 0.2,-0.05 0.14,-0.26 0.09,-0.44 0.01,-0.44 -0.1,-0.27 -0.38,-0.53 -0.1,-0.7 -0.02,-0.77 -0.11,-0.78 -0.14,-0.29 -0.17,-0.2 -0.17,-0.25 -0.1,-0.44 -0.12,-0.33 -0.25,-0.3 -0.3,-0.24 -0.28,-0.16 -0.51,-0.57 0.26,-0.67 0.94,-1.08 0.11,-0.48 -0.08,-0.83 0.11,-0.49 0.33,-0.47 0.43,-0.18 0.96,-0.1 0.94,-0.66 0.17,-1 -0.07,-1.05 0.23,-0.8 0.78,-0.03 0.61,0.32 0.4,0.21 0.91,0.32 0.52,-0.69 0.26,-1.01 0.28,-0.75 0.09,-0.78 -0.31,-1.07 0,0 -0.1,-0.57 0.01,-0.55 0.16,-0.47 0.36,-0.36 0.23,-0.07 0.47,-0.05 0.2,-0.11 0.07,-0.19 -0.09,-0.51 0.03,-0.19 0.47,-0.78 0.24,-0.09 0.5,0.17 0.71,0.46 0.35,0.15 0.44,-0.04 1.01,0.45 0.54,-0.14 0.5,-0.47 0.91,-0.55 0.34,-0.04 0.6,0.16 0.86,-0.28 0.42,-0.09 0.37,-0.19 0.27,-0.5 -0.7,-0.82 0.45,-1.17 0.74,-1.26 0.12,-1.09 -0.51,-0.43 -1.31,0.01 -0.47,-0.33 -0.09,-0.65 0.3,-0.53 0.42,-0.5 0.17,-0.42 0.94,0.32 6.44,5.08 8.14,11.14 1.45,1.01 z\"\r\n                        title=\"Kermanshah\" id=\"IR-17\"  data-fa=\"کرمانشاه\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 95.95043,37.9044 0,0 -1.57,-1.29 -0.7,0.05 -0.09,0.66 -0.02,1.27 -0.23,1.21 -0.46,0.41 -1.81,-0.44 -1.26,0.14 -0.34,0.62 -0.91,0.53 -1.36,1.8 -0.54,2.71 0.96,2.37 1.73,0.95 2.32,-0.83 2.32,-1.26 2.22,-0.63 5.07,1.44 1.42,-1.15 1.28,-1.75 2.12,-1.6 0.42,-0.55 -0.51,-0.19 -0.46,-0.71 3.88,-6.77 2.55,-1.73 1.38,0.12 2.28,-1.37 2.19,-1.96 1.34,0.5 -0.47,4.96 0.52,0.76 0.09,3.28 1.96,4.9 -0.36,2.9 -1.25,1.69 0.02,1.21 1.78,1.01 0.64,2.12 -1.65,1.13 -2.43,-0.39 -2.3,0.68 -1.42,1.54 -2.71,1.98 -1.07,2.01 -0.86,1.12 -0.69,1.58 -0.16,2.21 0.4,1.34 1.63,-0.64 2.16,-0.26 1.07,1.04 0.47,0.35 0.99,0.18 7.61,-1.12 2.36,1.18 1.01,3.16 0.21,3.42 1.71,4.24 2.67,3.66 2.27,2.09 0.35,0.77 -0.34,1.19 -0.77,1.63 -0.3,3.9 1.01,4.68 3.31,2.05 0.21,-0.13 0.76,0.15 2.49,1.3 0.9,0.79 0.27,3.09 0.88,2.08 2.08,1.38 0.72,0.74 1.54,1.26 -0.09,0.23 -0.17,0.64 0.26,0 0.3,-0.37 0.51,-0.18 1.15,-0.06 0.49,0.26 0.48,0.97 0.3,-0.04 0.47,0.25 0.47,0.17 -0.39,0.23 -1.19,0.95 -2.52,0.99 -8.1,-0.84 -2.2,0.36 -3.21,-0.49 -10.65,1.24 -1.2,0.5 -1.17,0.7 -1.85,2.01 -2.24,1.07 -1.01,0.74 -1.42,2.37 -5.13,5.22 -0.65,1.33 0.01,2.05 0.2,1.37 -8.04,0.93 -3.3,-0.45 -1.22,-1.77 0.03,-2.82 -1.34,-3.92 0.44,-0.63 -0.15,-0.9 -1.07,-0.92 -1.72,-0.39 -1.35,-0.83 -1.07,-1.09 -1.57,-0.26 -1.42,0.94 -0.93,0.88 -0.82,-0.08 -1.68,0.35 -2.03,1.33 -1.11,1.38 -0.5,1.19 -0.11,0.38 -0.55,0.88 -1,0.69 -1.57,-0.66 -1.46,-1.36 -4.21,-2.38 -0.57,-1.14 -4.7,-4.28 -3.62,-0.06 -4.4,-0.78 -9.89,-6.5 -1.28,-1.93 -0.46,-2.29 0.38,-5.3 -0.84,-1.95 -2.27,-2.74 -0.22,-0.78 -0.46,-0.85 -0.26,-0.67 0.14,-0.48 0.32,-0.27 0.32,-0.18 0.15,-0.23 -0.27,-2.57 -0.05,-0.18 -0.15,-0.34 -0.68,-0.92 -1.19,-11.58 0.02,-1.43 0.11,-0.22 0.13,-0.21 -0.05,-0.47 -0.21,-0.77 -0.22,-0.35 -0.27,-0.23 -0.2,-0.32 0,-0.59 -0.23,0 -2.15,-2.92 -0.45,-1.44 0.37,-1.87 1.91,-3.23 5.81,-6.03 1.27,-2.3 0.01,-2.15 -0.86,-2.29 -0.47,-2.48 0.99,-4.61 0.74,-1.81 3.74,-4 0.21,-0.21 0.54,0.14 0.69,0.41 0.16,0.03 0.26,0.06 0.94,0.03 1.93,0.48 3.01,0.03 1.74,0.68 0.78,0.3 7.13,1.51 2.24,1.02 1.97,0.5 0.33,-0.05 2.26,-0.3 0.59,-0.28 1.76,-1.28 0.66,-0.32 0.44,-0.11 1.32,-0.05 0.82,-0.27 0.36,-0.04 0.46,0.1 3.53,1.58 0.61,0.17 0.61,-0.04 0.73,-0.3 0.55,-0.34 0.52,-0.43 0.47,-0.53 0.39,-0.62 0.96,-1.98 0.45,-0.59 0.61,-0.52 1.97,-1 0.55,-0.54 0.57,-1.32 0.41,-0.65 0.27,-0.21 0.56,-0.31 0.27,-0.22 0.19,-0.27 0.87,-1.51 0.46,-0.54 0.51,-0.43 0.01,0 0.56,-0.26 0.54,-0.02 0.94,0.43 0.51,0.14 0.41,-0.08 2.03,-1.15 0.26,0.86 0.12,0.09 0.04,0.45 0.47,0.53 1.04,0.51 0.5,0.88 0.63,2.66 -0.13,0.87 -0.23,0.79 -0.69,0.96 -2.94,2.02 -2.11,0.29 -1.36,0.79 -1.48,0.28 z\"\r\n                        title=\"East Azarbaijan\" id=\"IR-01\"  data-fa=\"آذربایجان شرقی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n\r\n                    <path\r\n                        d=\"m 27.10043,6.0744 0,0 0.09,0.12 0.48,0.29 0.14,0.07 0.72,0.14 0.78,0.03 -0.1,0.2 -0.13,0.13 0.71,0.51 0.41,0.95 1.01,4.22 0.42,0.88 0.71,0.63 -0.28,0.53 0.12,0.32 0.86,0.62 0.18,0.04 0.37,-0.01 0.26,0.07 0.12,0.17 0.08,0.2 0.12,0.16 1.2,0.82 0.02,0.01 0.18,0.23 0.11,0.31 0.28,0.46 0.34,0.41 0.32,0.18 0.27,0.42 0.62,1.39 0.2,0.45 0.29,0.43 0.24,0.47 0.35,2.18 0.22,0.66 0.89,-0.28 3.52,1.17 0.09,-0.08 0.24,-0.16 0.3,-0.12 0.32,0.04 0.1,0.27 -0.09,0.41 -0.01,0.38 0.34,0.16 0.47,0.09 0.45,0.29 0.19,0.46 -0.29,0.65 0.23,0.44 0.29,0.22 0.31,0.19 0.32,0.34 0.14,0.34 0.27,0.94 0.17,0.37 0.32,0.24 0.81,0.36 0.16,0.3 -0.07,0.45 -0.14,0.36 -0.1,0.37 0.06,0.47 0.39,0.46 0.72,0.49 0.77,0.38 0.4,0.11 -0.21,0.21 -3.74,4 -0.74,1.81 -0.99,4.61 0.47,2.48 0.86,2.29 -0.01,2.15 -1.27,2.3 -5.81,6.03 -1.91,3.23 -0.37,1.87 0.45,1.44 2.15,2.92 0.23,0 0,0.59 0.2,0.32 0.27,0.23 0.22,0.35 0.21,0.77 0.05,0.47 -0.13,0.21 -0.11,0.22 -0.02,1.43 1.19,11.58 0.68,0.92 0.15,0.34 0.05,0.18 0.27,2.57 -0.15,0.23 -0.32,0.18 -0.32,0.27 -0.14,0.48 0.26,0.67 0.46,0.85 0.22,0.78 2.27,2.74 0.84,1.95 -0.38,5.3 0.46,2.29 1.28,1.93 9.89,6.5 4.4,0.78 3.62,0.06 4.7,4.28 0.57,1.14 4.21,2.38 1.46,1.36 1.57,0.66 1,-0.69 0.55,-0.88 0.11,-0.38 0.5,-1.19 1.11,-1.38 2.03,-1.33 1.68,-0.35 0.82,0.08 0.93,-0.88 1.42,-0.94 1.57,0.26 1.07,1.09 1.35,0.83 1.72,0.39 1.07,0.92 0.15,0.9 -0.44,0.63 1.34,3.92 -0.03,2.82 1.22,1.77 3.3,0.45 8.04,-0.93 4.69,10.52 -0.83,0.26 -1,0.61 -0.14,0.83 0.24,0.69 -0.18,0.66 -0.58,1.16 -1.43,1.66 -2.56,1.13 -3.84,-0.34 -3.51,-0.97 -1.3,-0.9 -0.58,-0.64 -0.68,-0.57 -0.48,-0.64 -0.24,-0.51 -0.4,-0.33 -17.52,1.62 -8.52,-1.22 -2.96,1.18 -0.75,0.97 -0.05,2.03 -1.63,2.48 -5.51,1.78 -1.02,1.11 -0.39,0.67 -0.75,0.77 -0.46,2.04 -1.88,2.14 -0.56,1.37 -1.33,1.33 -1.14,0.7 -0.02,0.02 0,0 -0.75,-0.28 -0.89,0.02 -1.12,0.56 -0.6,0.17 -0.01,0 0,0.01 -0.01,0 0,0 -0.67,0.46 -0.76,0.25 -0.72,-0.1 -0.6,-0.61 -0.01,0 0,-0.01 0,0 0,0 -0.22,-0.68 0.2,-0.86 0.42,-0.86 0.41,-0.67 0.14,-0.84 -0.43,-0.85 -1.05,-1.37 -0.17,-0.88 0.08,-1.93 -0.15,-0.81 -0.5,-0.49 -0.63,-0.49 -0.19,-0.51 0.82,-0.53 -0.64,-0.82 -0.23,-0.73 -0.09,-1.81 -0.16,-0.97 -0.36,-1.06 -0.6,-0.75 -0.86,-0.06 -1.89,0.75 -0.99,0.08 -0.92,-0.43 -0.39,-0.45 -0.12,-0.38 -0.06,-0.41 -0.16,-0.55 -0.27,-0.4 -0.29,-0.29 -0.22,-0.34 -0.03,-0.6 -0.44,-0.47 -0.53,-0.46 -0.12,-0.11 -0.49,-0.63 0.06,-0.67 0.15,-0.11 0.42,-0.16 0.11,-0.08 0.03,-0.89 0.36,-1.44 0.66,-1.53 0.05,-0.79 -0.36,-0.91 -0.82,-1.52 -0.5,-0.68 -0.57,-0.31 -0.44,-0.01 -0.4,-0.13 -0.35,-0.25 -0.31,-0.37 -0.42,-0.37 -0.49,-0.09 -1.05,0.06 -0.88,-0.2 -0.68,-0.45 -0.26,-0.74 0.36,-1.04 1.2,-1.48 0.47,-0.76 0.18,-1.02 -0.16,-0.95 -0.31,-0.69 -0.19,-0.75 0.19,-1.13 0.37,-0.47 0.05,-0.46 -0.22,-0.38 -0.74,-0.39 -0.39,-0.42 -0.23,-0.13 -0.33,0.01 -0.67,0.21 -0.31,-0.07 -0.16,-0.21 -0.17,-0.65 -0.13,-0.27 -0.25,-0.18 -0.25,-0.08 -0.24,-0.11 -0.2,-0.29 -0.27,-0.75 0,-0.41 0.46,-1.23 0.21,-0.82 -0.21,-0.72 -0.32,-0.72 -0.11,-0.86 0.24,-0.76 0.42,-0.36 0.47,-0.27 0.39,-0.52 0.11,-1.38 -0.77,-0.9 -1.95,-1.25 -0.28,-0.58 -0.2,-0.6 -0.31,-0.39 -1.23,0.19 -0.32,-0.36 -0.48,-1.22 -0.52,-0.39 -1.26,-0.12 -0.45,-0.26 -0.21,-0.7 0.45,-1.27 -0.14,-0.72 0,-0.01 -0.18,-0.87 0.07,-1.06 0.22,-1.05 0.31,-0.86 -0.14,-0.73 -0.76,-0.58 -0.68,-0.78 0.15,-1.29 0.28,-0.38 1.17,-0.95 0.35,-0.55 -0.08,-0.4 -1.24,-1.53 -0.85,-0.74 -0.95,-0.43 -0.92,0.1 -0.43,0.25 -0.54,0.19 -0.48,-0.05 -0.25,-0.48 0.03,-0.26 0.13,-0.68 -0.02,-0.22 -0.26,-0.2 -0.22,0.05 -0.23,0.08 -0.26,-0.08 -0.38,-0.49 -0.19,-0.53 -0.13,-0.49 -0.2,-0.4 -0.36,-0.26 -1.22,-0.59 -0.41,-0.12 -2.19,0.26 -1.18,-0.2 -0.59,-0.93 0.09,-0.33 0.05,-0.15 0.35,-0.44 0.3,-0.46 -0.03,-0.55 -0.17,-0.6 0.06,-0.55 0.21,-0.52 0.29,-0.55 0,-0.01 0,0 0,0 0.31,-0.62 0.82,-0.93 0.3,-0.66 0.28,-0.9 0.31,-0.55 0.45,-0.35 0.65,-0.32 0.19,-0.27 -0.28,-0.81 0.05,-0.37 0.28,-0.25 0.6,-0.25 0.25,-0.34 0.22,-0.63 0.21,-0.85 0.12,-0.83 -0.15,-2.07 0.96,-1.09 1.22,-0.96 0.76,-1.1 -0.01,-0.68 -0.26,-0.68 -0.42,-0.59 -0.48,-0.41 -0.53,-0.2 -0.43,0.09 -1.11,0.65 -1.69,-0.31 -0.5,-0.23 -0.31,-0.22 -0.1,-0.38 0.11,-0.71 0.02,-0.39 -0.11,-1.1 0.01,-0.51 0.43,-1.74 0.04,-0.75 -0.31,-2.2 0.15,-1.71 0.01,-0.9 -0.24,-0.72 -0.25,-0.28 -0.26,-0.17 -0.61,-0.2 -0.42,-0.22 0.1,-0.26 0.29,-0.3 0.15,-0.32 -0.17,-0.78 -0.16,-0.52 -0.07,-0.54 0.14,-0.87 0.92,-3.15 -0.17,-1.27 -1.79,-0.87 -0.55,-0.53 -0.46,-0.66 -0.33,-0.97 -0.14,-0.33 -0.12,-0.33 0.02,-0.37 -0.02,-0.39 -0.26,-0.27 -0.31,-0.24 -0.2,-0.31 -0.14,-0.67 -0.11,-0.3 -0.18,-0.3 0,-0.01 0.48,-0.81 0.54,-0.46 0.33,-0.52 -0.31,-1.71 0.17,-0.7 0.67,-1.32 -0.28,-1.07 -1.3,-0.93 -1.51,-0.8 -0.88,-0.67 -0.04,-0.38 0.24,-0.79 -0.03,-0.39 -0.41,-0.87 -0.11,-0.37 -0.02,-0.39 0.09,-0.29 0,-0.32 -0.4,-0.87 -0.2,-0.93 -0.14,-0.42 -0.01,-0.01 -0.89,-1.06 -0.2,-0.53 0.37,-0.53 0.69,-0.43 0.51,-0.19 0.53,-0.01 0.75,0.09 0.78,-0.08 1.84,-0.49 0.81,0.09 2.34,1.17 0.86,0.07 0.75,-0.18 1.75,-0.8 0.65,-0.48 0.57,-0.87 0.01,-0.79 -0.11,-0.83 0.16,-0.98 0,0 0.01,0 0.34,-0.52 0.02,-0.53 -0.12,-0.56 -0.06,-0.62 0.06,-0.72 0.16,-0.59 1.12,-2.27 0.2,-0.56 0.02,-0.17 0.07,-0.53 -0.18,-1.43 0.15,-0.5 3.6,-2.97 0.84,-0.25 0.52,0.37 0.91,1.39 0.47,0.53 2.02,0.95 0.66,0.56 2.75,2 z\"\r\n                        title=\"West Azarbaijan\" id=\"IR-02\"  data-fa=\"آذربایجان غربی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 189.74043,137.3244 0,0 1.73,-0.07 1.04,0.18 0.73,0.5 3.13,0.63 1.68,-0.3 6.36,-3.46 0.7,-0.24 0.75,-0.4 2.81,-0.63 4.6,0.46 9.03,7.62 1.87,1.02 5.49,4.19 0.39,1.14 0.04,0.84 -8.06,-0.86 -3.84,0.31 -0.98,1.49 1.73,2.38 1.25,1.07 2.4,0.72 1.57,1.35 -1.07,3.62 -1.63,3.39 -0.4,1.54 -1.16,1.11 -6.86,3.35 -1.86,1.8 -0.42,1.63 0.28,1.29 0.86,1.92 0.73,1.21 -1.01,-0.15 -2.02,0.12 -6.07,2.65 -1.56,0.09 -1.87,0.54 -1.75,0.87 -5.96,1.82 -1.42,1.06 -1.02,2.34 -5.94,0.16 -0.83,-0.58 -4.81,-1.22 -0.95,0.25 -4.34,-0.74 -2.31,-1.77 1.03,-1.57 -1.29,-1.62 -2.82,-1.62 -3.7,-0.07 -1.58,0.7 -2.52,-3.71 -4.3,-3.88 -0.1,-1.3 0.71,-0.47 1.06,-0.24 1.45,-0.05 1.23,-0.25 1.89,-1.4 3.07,-0.85 2.22,0.15 3.09,1.43 -0.05,-0.46 0.18,-1.66 2.07,-2.35 3.42,-1.94 6.18,-1.67 0.78,-1.14 -0.54,-4.45 -0.78,-1.74 -1.06,-1.76 -0.56,-2.08 -0.63,-1.15 -0.88,-0.5 -0.64,-0.69 -0.65,-0.36 -1.03,-0.07 -1.68,-0.84 -1.13,-1.71 -1.09,-2.74 -1.82,-2.27 -0.7,-2.67 1.38,-3.2 3.68,-2.46 2.76,-0.95 3.21,1.55 0.06,0.71 0.43,1.35 1.91,2.43 2.06,1.94 4.65,1.39 z\"\r\n                        title=\"Qazvin\" id=\"IR-28\" data-fa=\"قزوین\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 165.12043,111.4344 0,0 5.1,3.26 3.76,3.97 1.44,2.33 2,6.96 -2.76,0.95 -3.68,2.46 -1.38,3.2 0.7,2.67 1.82,2.27 1.09,2.74 1.13,1.71 1.68,0.84 1.03,0.07 0.65,0.36 0.64,0.69 0.88,0.5 0.63,1.15 0.56,2.08 1.06,1.76 0.78,1.74 0.54,4.45 -0.78,1.14 -6.18,1.67 -3.42,1.94 -2.07,2.35 -0.18,1.66 0.05,0.46 -3.09,-1.43 -2.22,-0.15 -3.07,0.85 -1.89,1.4 -1.23,0.25 -1.45,0.05 -1.06,0.24 -0.71,0.47 0.1,1.3 4.3,3.88 2.52,3.71 0.02,0.73 -1.24,1.7 -2.56,0.9 -2.85,-0.7 -2.97,-1.62 -7.27,-0.25 -1.52,-0.95 -1.14,-2.08 -0.3,-0.9 -0.67,-1.14 -0.62,-0.58 -9.32,-5.68 -0.47,-1.11 0.56,-1.51 1.33,-1.4 0.75,-3.07 0,-4.26 -0.64,-2.37 -0.59,-0.07 -0.14,-0.06 -0.04,-0.31 0.11,-0.28 0.14,-0.26 0.05,-0.29 -0.21,-1.02 0.07,-0.37 0.35,-0.33 -0.32,-0.47 -0.38,-0.82 -0.33,-0.94 -0.13,-0.81 -0.23,-0.45 -1.07,-1.19 -0.12,-0.18 -17.06,-3.4 -0.98,-0.99 -4.69,-10.52 -0.2,-1.37 -0.01,-2.05 0.65,-1.33 5.13,-5.22 1.42,-2.37 1.01,-0.74 2.24,-1.07 1.85,-2.01 1.17,-0.7 1.2,-0.5 10.65,-1.24 3.21,0.49 2.2,-0.36 8.1,0.84 2.52,-0.99 1.19,-0.95 0.39,-0.23 0.99,-0.27 1.39,0.51 2.53,2.7 1.05,-0.22 0.45,-0.76 0,-0.72 0.41,-0.73 0.65,-0.26 0.97,0.55 1.22,0.16 1.34,-0.92 1.19,-0.36 2.28,1.22 z\"\r\n                        title=\"Zanjan\" id=\"IR-11\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 1.14,2.08 1.52,0.95 7.27,0.25 2.97,1.62 2.85,0.7 2.56,-0.9 1.24,-1.7 -0.02,-0.73 1.58,-0.7 3.7,0.07 2.82,1.62 1.29,1.62 -1.03,1.57 2.31,1.77 4.34,0.74 0.95,-0.25 4.81,1.22 0.83,0.58 -0.02,0.99 0.29,1.48 0.8,1.06 -0.13,1.59 -1.14,1.27 -1.16,-0.21 -0.66,-0.95 0.04,-1.05 -0.08,-0.78 -0.92,0.07 -1.06,1.35 0.64,2.78 1.51,2.52 0.42,1.91 -1.63,1.91 -1.95,0.61 -1.03,0.11 -0.61,0.69 0.09,0.59 0.78,0.76 1.52,0.78 3.64,1 1.73,0.84 1.63,1.93 0.85,2.05 0.73,4.44 -0.82,1.67 -1.49,-0.14 -1.09,-1.01 -1.34,-1.59 -0.51,-1.88 0.72,-1.53 -0.82,-1.19 -2.93,-0.51 -6.16,0.33 -0.85,1.29 0.38,2.4 -0.4,1.46 -0.9,1.47 -0.12,2.89 0.58,3.18 -0.76,0.18 -1.57,-0.76 -3.49,-0.36 -1.18,0.47 0.49,1.16 1.71,0.68 0.58,2.59 0.27,4.33 2.4,4.73 0.54,2.24 0.19,2.24 0.62,2.64 -0.1,0.96 -0.6,0.82 -3.53,3.18 -9.24,-3.95 -2.22,0.25 -1.8,-0.11 -0.88,0.24 -1.78,1.84 -1.01,0.26 -1.25,-0.47 -7.52,-0.91 -14.54,-9.57 -0.7,-1.02 -1.45,-0.94 -0.85,-0.38 0.59,-1.15 1.24,-1.9 3.36,-0.24 3.8,0.81 1.03,-0.85 -0.08,-1.91 0.37,-2.72 -0.34,-1.67 -0.65,-0.99 -0.78,0.17 -1.56,0.69 -2.89,3.02 -0.86,-1.31 -0.5,-1.7 -0.92,-0.49 -1.11,-0.22 -2.49,-1.36 -1.72,-1.4 -0.33,-1.64 0.49,-0.64 1.08,-0.43 3.39,-0.39 1.59,-2.35 1.34,-3.02 1.12,-1.29 0.18,-1.15 -0.02,-0.63 1.03,-0.56 2.08,-0.59 1.23,-0.67 0.38,-1.16 0.63,-0.16 1.09,2.68 0.73,0.39 1.13,-0.99 1.19,-1.91 0.67,-3.09 -0.93,-3.83 -1.93,-1.92 -1.39,-0.87 -1.66,-2.03 -3.65,-8.17 -2.36,-3.5 0.53,-1.05 1.77,-1.99 0.78,-0.08 1.6,3.33 1.05,0.29 1.11,-0.5 0.97,-0.95 2.41,-0.82 0.01,-1.05 -0.4,-0.89 -1,-1.3 -0.6,-1.67 1.22,-0.34 4.99,2.73 z\"\r\n                        title=\"Hamadan\" id=\"IR-24\"  data-fa=\"همدان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 266.71043,208.9144 0,0 0.45,1.65 -0.09,3.36 -0.91,3.61 -1.49,3.5 -1.13,1.62 -11.42,2.97 -2.62,-0.14 -7.31,0.84 -3.23,1.41 -1.27,1.28 -0.4,1.2 -1.02,8.04 0.71,1.77 0.96,0.51 -7.81,-2.13 -3.49,-1.92 -8.74,-0.82 -2.24,-1.86 -1.57,-1.95 -0.82,-2.04 0.14,-1.68 -0.51,-1.21 -0.99,-1.17 -1,-0.61 -1.36,0.12 -1.23,-0.56 -1.5,-1.35 -1.83,-2.15 0.32,-2.12 3.16,-1.78 0.36,-0.83 -0.7,-0.99 0.05,-2.69 1.93,-1.57 3.05,0.42 2.95,-0.85 2.01,-1.33 4.2,-0.66 3.51,-1.19 0.62,-0.37 0.4,-1.59 0.6,-6.35 1.13,-3.23 0.96,-1.35 0,0.11 9.73,0.11 8.13,2.45 19.31,11.52 z\"\r\n                        title=\"Qom\" id=\"IR-26\"  data-fa=\"قم\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 226.55043,180.9344 0,0 0.96,-0.2 0.94,-1.92 1.56,-0.14 1.57,1.96 0.87,1.69 0.02,2.91 -2.93,9.49 -0.96,1.35 -1.13,3.23 -0.6,6.35 -0.4,1.59 -0.62,0.37 -3.51,1.19 -4.2,0.66 -2.01,1.33 -2.95,0.85 -3.05,-0.42 -1.93,1.57 -0.05,2.69 0.7,0.99 -0.36,0.83 -3.16,1.78 -0.32,2.12 1.83,2.15 1.5,1.35 1.23,0.56 1.36,-0.12 1,0.61 0.99,1.17 0.51,1.21 -0.14,1.68 0.82,2.04 1.57,1.95 2.24,1.86 8.74,0.82 3.49,1.92 7.81,2.13 -0.4,2.44 -3.23,7.83 -0.91,1.61 -1.94,0.01 -2.13,0.68 -1.9,1.61 -2.12,1.31 -14.11,3.72 -5.38,3.2 -2.81,2.34 -0.3,-0.33 -2.16,-1.17 -0.24,-1.16 0.05,-1.19 -0.73,-0.76 -1.09,-0.84 -0.54,-0.97 -0.76,-0.46 -1.18,0.85 -0.67,1.32 -0.22,1.05 -0.79,0.54 -1.05,-0.83 -1.16,-1.23 -2.55,-1.29 -1.1,-0.94 -0.32,-0.95 0.36,-1.21 0.54,-1.17 -0.04,-1.08 -0.92,-1.58 -1.48,-1.8 -1.86,-0.6 -1.7,0.98 -1.87,0.63 -1.5,0.87 -1.16,3.55 -0.64,0.68 -2.71,1.72 -0.93,-0.35 -3.82,-0.33 -2.24,-0.83 -1.73,-1 -0.44,-0.86 0.18,-0.98 0.28,-0.9 1.36,-3.13 -0.12,-0.93 -0.42,-1.1 0.24,-1.33 0.53,-0.87 3.53,-3.18 0.6,-0.82 0.1,-0.96 -0.62,-2.64 -0.19,-2.24 -0.54,-2.24 -2.4,-4.73 -0.27,-4.33 -0.58,-2.59 -1.71,-0.68 -0.49,-1.16 1.18,-0.47 3.49,0.36 1.57,0.76 0.76,-0.18 -0.58,-3.18 0.12,-2.89 0.9,-1.47 0.4,-1.46 -0.38,-2.4 0.85,-1.29 6.16,-0.33 2.93,0.51 0.82,1.19 -0.72,1.53 0.51,1.88 1.34,1.59 1.09,1.01 1.49,0.14 0.82,-1.67 -0.73,-4.44 -0.85,-2.05 -1.63,-1.93 -1.73,-0.84 -3.64,-1 -1.52,-0.78 -0.78,-0.76 -0.09,-0.59 0.61,-0.69 1.03,-0.11 1.95,-0.61 1.63,-1.91 -0.42,-1.91 -1.51,-2.52 -0.64,-2.78 1.06,-1.35 0.92,-0.07 0.08,0.78 -0.04,1.05 0.66,0.95 1.16,0.21 1.14,-1.27 0.13,-1.59 -0.8,-1.06 -0.29,-1.48 0.02,-0.99 5.94,-0.16 1.02,-2.34 1.42,-1.06 5.96,-1.82 1.75,-0.87 1.87,-0.54 1.56,-0.09 6.07,-2.65 2.02,-0.12 1.01,0.15 1.46,0.34 3.42,0.22 3.32,0.97 1.95,1.76 0.85,0.51 0.35,-0.62 0,-0.7 -1.31,-1.82 0.43,-1.12 1.91,0.02 1.31,1.55 -0.01,2.31 0.24,1.39 z\"\r\n                        title=\"Markazi\" id=\"IR-22\"  data-fa=\"مرکزی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 133.80043,3.1044 0,0 0.46,0.12 0.66,0.45 2.07,1.95 5.69,6.85 2.32,2.15 0.96,1.31 0.75,1.59 -0.36,0.11 -0.88,0.29 -1.78,1.2 -2.12,0.43 -1.14,0.59 -0.98,0.94 -0.62,1.24 -0.07,1.51 0.46,1.17 0.83,1.17 1.92,1.88 1.94,0.8 0.51,0.5 1.02,2.2 0.18,0.55 -0.02,0.61 -0.16,0.59 0,0.02 -0.26,0.56 -0.31,0.46 -0.01,0 0,0 0,0.01 0,0 -1.39,0.87 -6.26,1.11 -0.11,0.28 0.01,0.33 -0.1,0.28 -1.78,1.1 -0.31,0.49 0.08,1.79 0.67,1.24 2.2,1.77 4.49,2.22 0.42,0.36 0.09,0.36 0.16,0.63 -0.14,0.85 0.06,0.73 1.65,1.32 0.53,0.79 0.61,0.58 1.04,0.03 1.72,-0.81 0.79,0 0.39,0.94 0.24,1.15 0.44,0.59 0.54,0.49 0.56,0.88 0.57,0.62 0.5,0.72 0.84,1.06 0.44,0.56 0.92,1.55 1.09,1.06 0.17,0.01 0.2,0.45 1.08,0.96 0.7,0.92 0.19,0.81 0.82,0.33 1.28,0.29 0.52,0.56 -0.3,0.79 -7.65,9.11 -0.7,1.66 -0.3,2.28 -1.08,1.68 -0.07,2.35 3.11,8.63 5.62,8.86 1.87,1.93 2.16,1.71 1.14,1.45 0.03,1.22 -0.15,1.86 0.29,2.23 0.37,1.05 -2.28,-1.22 -1.19,0.36 -1.34,0.92 -1.22,-0.16 -0.97,-0.55 -0.65,0.26 -0.41,0.73 0,0.72 -0.45,0.76 -1.05,0.22 -2.53,-2.7 -1.39,-0.51 -0.99,0.27 -0.47,-0.17 -0.47,-0.25 -0.3,0.04 -0.48,-0.97 -0.49,-0.26 -1.15,0.06 -0.51,0.18 -0.3,0.37 -0.26,0 0.17,-0.64 0.09,-0.23 -1.54,-1.26 -0.72,-0.74 -2.08,-1.38 -0.88,-2.08 -0.27,-3.09 -0.9,-0.79 -2.49,-1.3 -0.76,-0.15 -0.21,0.13 -3.31,-2.05 -1.01,-4.68 0.3,-3.9 0.77,-1.63 0.34,-1.19 -0.35,-0.77 -2.27,-2.09 -2.67,-3.66 -1.71,-4.24 -0.21,-3.42 -1.01,-3.16 -2.36,-1.18 -7.61,1.12 -0.99,-0.18 -0.47,-0.35 -1.07,-1.04 -2.16,0.26 -1.63,0.64 -0.4,-1.34 0.16,-2.21 0.69,-1.58 0.86,-1.12 1.07,-2.01 2.71,-1.98 1.42,-1.54 2.3,-0.68 2.43,0.39 1.65,-1.13 -0.64,-2.12 -1.78,-1.01 -0.02,-1.21 1.25,-1.69 0.36,-2.9 -1.96,-4.9 -0.09,-3.28 -0.52,-0.76 0.47,-4.96 -1.34,-0.5 -2.19,1.96 -2.28,1.37 -1.38,-0.12 -2.55,1.73 -3.88,6.77 0.46,0.71 0.51,0.19 -0.42,0.55 -2.12,1.6 -1.28,1.75 -1.42,1.15 -5.07,-1.44 -2.22,0.63 -2.32,1.26 -2.32,0.83 -1.73,-0.95 -0.96,-2.37 0.54,-2.71 1.36,-1.8 0.91,-0.53 0.34,-0.62 1.26,-0.14 1.81,0.44 0.46,-0.41 0.23,-1.21 0.02,-1.27 0.09,-0.66 0.7,-0.05 1.57,1.29 1.48,-0.28 1.36,-0.79 2.11,-0.29 2.94,-2.02 0.69,-0.96 0.23,-0.79 0.13,-0.87 -0.63,-2.66 -0.5,-0.88 -1.04,-0.51 -0.47,-0.53 -0.04,-0.45 -0.12,-0.09 -0.26,-0.86 0.23,-0.13 0.35,-0.42 0.18,-0.33 0.57,-1.66 1.22,-1.96 0.12,-0.44 0.33,-0.37 1.62,-1 3.37,-1.32 0.4,-0.22 1.01,-0.58 1.12,-1.15 0.01,0 1.68,-2.18 1.11,-0.93 1.41,-0.79 2.37,-0.81 0.76,-0.08 0.44,-0.3 1.79,-1.83 0.61,-0.34 4.08,-2.31 1.45,-1.49 0.53,-0.54 0.65,-0.45 0.81,-0.22 2.57,0.05 0.42,-0.11 0.35,-0.32 0.39,-0.59 0.02,0 z\"\r\n                        title=\"Ardebil\" id=\"IR-03\" data-fa=\"اردبیل\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 374.13043,563.2144 0,0 -0.27,0.23 -0.28,0.03 -0.19,0.11 -0.32,-0.3 -0.16,0.12 0.02,-0.23 -0.12,-0.23 -0.12,-0.37 0.49,-0.27 0.59,-0.15 0.16,0.26 0.04,0.37 0.16,0.43 z m -16.97,-1.33 0,0 -0.34,0.26 -0.46,-0.11 -0.54,-0.25 -0.14,-0.42 0.44,-0.24 0.81,-0.24 0.17,0.33 0.06,0.67 z m -0.91,-13.27 0,0 -0.19,0.04 -0.39,-0.13 -0.4,-0.21 -0.18,-0.22 -0.05,-0.49 -0.08,-0.38 -0.01,-0.35 0,0 0.14,-0.44 0.21,-0.29 0.28,-0.15 0.33,0.07 0.34,0.37 0.23,0.11 0.19,0.15 0.16,0.2 0.13,0.26 -0.71,1.46 z m -16.2,-9.15 0,0 -0.38,0.21 -2.5,-0.14 -0.26,-0.02 -1.09,-0.53 -0.69,-1.12 0.34,-0.53 0.5,-0.37 0.6,-0.19 0.66,0.03 0.57,0.2 1.26,0.13 0.48,0.19 0,0 0.06,0.17 0.03,0.08 0,0 -0.01,0.34 0,0 0,0.05 0.04,0.26 0,0 0.24,0.13 0.14,0.13 0.09,0.08 0.03,0.22 0.04,0.23 -0.08,0.23 -0.07,0.22 z m 62.36,-4.91 0,0 -0.69,0.4 -0.54,-0.3 0.08,-0.87 0.43,-0.85 0.55,-0.43 0.33,-0.06 0.26,0.4 0.07,0.89 -0.49,0.82 z m -75.53,-1.71 0,0 -0.44,0.44 -0.59,-0.08 -0.6,-0.3 -0.33,-0.47 0.27,-0.41 0.67,-0.03 0.35,0.09 0.4,0.19 0.27,0.57 z m -9.39,-5.09 0,0 -0.49,0.13 -1.3,-0.11 -0.4,0.09 -0.62,0.36 -0.65,0 -1.93,-0.34 -0.59,-0.25 -0.08,-0.05 -0.45,-0.29 -1.06,-0.89 -0.3,-0.35 0.13,-0.17 0.24,-0.05 0.27,-0.1 0.33,-0.02 2.85,0.88 2.54,0.19 0.79,0.31 0.44,0.4 0.28,0.26 z m 101.5,-1.35 0,0 -1.29,0.42 -0.64,-0.26 0.16,-1.01 0.48,-0.7 0.86,-0.39 1.28,-0.13 0.17,1.17 -1.02,0.9 z m -7.04,-2.59 0,0 -0.76,1.7 -0.39,0.66 -1.4,1.43 -0.22,0.51 -0.29,0.31 -1.29,0.65 -0.29,0.35 -0.29,0.19 -1.67,1.61 -0.99,0.58 -0.78,-0.33 -0.74,-0.75 -0.87,-0.69 -2.26,1.17 -0.63,0.54 -0.63,0.36 -0.72,-0.01 -1.54,-0.23 -0.69,0.16 -0.72,0.34 -1.83,1.31 -1.89,0.8 -1.15,0.85 -0.59,0.32 -2.09,0.24 -1.49,0.41 -0.63,0.39 -0.31,0.12 0,0 -0.1,-0.01 -0.19,-0.04 -0.38,-0.13 -0.34,0 -0.15,0.32 -0.15,0.26 -0.37,0.2 -0.42,0.13 -0.31,0.05 0,0 -0.14,-0.1 -0.13,-0.08 -0.17,-0.44 -0.16,-0.93 0.23,-0.67 0.06,-0.43 -0.18,-0.2 -0.34,-1.17 0.37,-0.4 1.59,0.57 0.37,-0.17 0.21,0.06 0.1,0.03 0,0 1.79,-1.01 4.53,-1.47 0.66,-0.08 0.42,-0.17 0.13,-0.05 0,0 1.57,-0.96 0.67,-0.55 2.22,-0.86 0.34,-0.03 0.71,0.06 0.34,-0.03 0.24,-0.11 0.35,-0.29 0.33,-0.12 -0.1,-0.25 -0.15,-0.26 0.52,-0.6 0.12,-0.71 -0.16,-1.7 -0.26,-0.65 -0.58,-0.55 -0.56,-0.44 -0.24,-0.3 0.86,-0.5 4.74,1.79 1.28,-0.3 3.57,-2.31 4.47,-1.02 1.33,-0.02 0.67,0.16 0.87,0.38 0.54,0.41 0.19,0.15 0.27,0.71 -0.54,0.32 -0.55,0.31 -2.09,0.54 -0.75,0.67 z m 10.52,-5.3 0,0 -0.53,0.09 -1.07,-0.41 0.07,-0.96 0.63,-0.87 0.6,-0.12 0.36,0.24 0.39,0.15 0.32,0.26 0.02,0.07 0.11,0.48 -0.13,0.49 -0.32,0.35 -0.24,0.12 -0.21,0.11 z m -30.81,-65.74 0,0 1.52,0.75 1.74,-0.45 6.77,-5.14 3.98,-1.87 1.02,-0.13 0.95,1.41 0.65,14.7 -0.84,2.86 0.71,3.76 3.02,3.91 2.91,2.68 3.48,2.11 4.03,0.62 2.17,-0.39 3.98,-1.97 3.67,-3.49 1.03,-1.27 1.56,-1.23 1.84,0.07 3.53,1.73 0.27,0.62 -0.3,3.93 1.23,5.97 0.49,0.81 0.68,0.57 1.04,0.13 1.76,0.96 1.35,1.76 0.79,1.52 1.54,1.69 1.53,2.33 0.23,1.92 -0.94,0.79 -0.59,1.18 0.77,1.11 0.91,0.46 0.92,1.88 1.02,2.99 1.07,14.26 0.68,2.21 10.47,5.56 2.29,1.69 1.02,0.32 1.6,-1.5 0.81,-1.13 1.39,-0.95 2.23,0.06 2.33,1.4 2.53,2.13 1.99,2.31 0.97,2.1 -0.29,0.72 -2.12,-1.29 -0.73,-0.04 -0.04,0.76 0.82,2.43 0.05,0.96 -0.19,0.63 -0.62,0.76 -0.47,1.17 -0.78,7.39 0.19,1.09 0,1.09 -0.4,2.11 -0.69,0.85 0.06,0.77 4.49,-0.32 2.78,0.5 1.83,-0.17 1.17,-0.55 1.19,0.27 1.3,0.59 2.11,0.33 0.64,0.4 -0.05,0.41 -0.32,0.7 0.08,0.73 0.34,0.84 0.1,1.17 0.57,1.01 1.4,0.32 1.68,0.06 1.45,-0.18 1,-1.05 0.99,-0.25 1.31,0.52 0.93,-0.01 0.49,0.41 1.38,2.09 -0.41,0.22 -0.61,0.93 -0.16,1.21 0.13,0.68 0.46,0.2 1.21,0.76 6.42,5.68 1.09,1.8 0.18,1.36 0.75,0.76 1.02,0.39 0.55,0.68 0.23,0.77 0.46,0.6 0.56,0.56 1.2,2.05 0.28,0.37 0.63,0.31 -0.09,0.6 -0.02,0.57 -0.89,0.39 0.15,0.89 0,0 -1.89,0.29 -1.93,0.92 -0.72,0.16 -0.28,-0.06 -0.25,-0.24 -0.25,-0.16 -0.29,0.07 -0.32,0.14 -0.31,0.09 -0.78,-0.04 -0.67,-0.14 -0.57,-0.24 -0.44,-0.37 -1.56,-2.51 -0.84,-1.01 -1.32,-0.61 -1.18,0.03 -0.31,-0.15 -0.21,-0.36 -0.12,-0.37 -0.19,-0.31 -0.38,-0.12 -2.91,0 -6.15,-1.12 -2.11,0.33 -1.81,-0.12 -0.64,-0.3 0.25,-0.6 -1,0.06 -1.08,0.22 -0.46,0.24 -0.78,0.65 -0.51,0.13 -0.24,-0.1 -0.11,-0.15 -0.17,0.01 -0.39,0.37 -0.27,0.19 -0.35,0.11 -0.3,-0.04 -0.12,-0.26 -0.2,0.09 -1.19,0.83 -1.25,0.2 -1.1,-0.22 -1.07,-0.34 -1.13,-0.18 -0.91,-0.42 -0.74,-1.01 -1.01,-2.16 -1.06,-1.27 -1.28,-0.31 -1.4,0.36 -1.37,0.71 -1.15,0.94 -0.75,0.47 -0.53,-0.01 0.14,-1.66 0.13,-0.43 0.09,-0.18 0.02,-0.14 -0.05,-0.29 -0.35,-0.86 -0.53,-0.47 -0.7,-0.18 -0.85,-0.03 -0.76,0.08 -1.88,0.43 -0.41,-0.08 -0.71,-0.35 -0.39,-0.08 -0.39,0.03 -0.67,0.18 -0.35,0.04 -0.84,-0.07 -2.31,-0.72 0.25,-0.23 -4.53,-0.3 -0.5,-0.27 -0.24,-0.59 -0.19,-1.84 -0.82,-1.91 -0.42,-1.52 -0.29,-0.72 -0.33,-0.31 -0.06,-0.14 -0.75,-0.91 -0.15,-0.03 -0.43,0.07 -0.14,-0.04 -0.06,-0.16 -0.09,-0.44 -0.46,-1.35 -0.14,-0.63 -0.33,-0.74 -0.07,-0.45 0.21,-0.78 1.06,-1.15 0.36,-0.76 -0.46,-1.2 -2.24,-2.48 0.18,-1.01 -0.25,-0.23 -0.19,-1.71 -0.24,-0.85 -0.38,-0.68 -0.65,-0.63 -0.16,-0.28 -0.1,-0.34 -0.12,-0.86 -0.01,-0.35 0.58,-4.72 -0.12,-1.77 -2.2,-8.8 -0.46,-0.68 -1.15,-1 -0.41,-0.6 0.04,-0.62 -1.04,-0.69 -0.35,-0.37 0.5,0.04 0.37,-0.15 0.34,-0.22 0.41,-0.19 -0.29,-0.25 -0.04,-0.36 0.12,-0.37 0.21,-0.31 -1.04,0.45 -0.35,0.07 -0.31,-0.08 -0.2,-0.18 -0.14,-0.18 -0.16,-0.08 -0.18,-0.13 -0.18,-0.25 -0.23,-0.16 -0.66,0.33 -0.2,-0.13 -0.09,-0.31 0.02,-0.39 -0.44,0.1 -0.23,-0.2 0.01,-0.28 0.32,-0.14 0.17,-0.13 0.59,-0.65 0.3,-0.24 0,-0.28 -1,-0.14 -0.81,-0.55 -0.54,-0.79 -0.22,-0.86 -0.39,0.39 -0.44,0.15 -0.91,0.01 -0.51,-0.17 -0.31,-0.36 -0.26,-0.37 -0.32,-0.16 -3.51,-0.05 -0.77,-0.24 -0.23,0.29 -0.82,-0.46 -1.02,-0.21 -2.11,-0.12 -1.01,-0.19 -1.77,-0.71 -1.05,-0.16 -2.1,0.12 -1.07,0.28 -0.78,0.53 -0.72,0.35 -2.21,0.1 -0.89,0.18 -0.28,0.19 -0.56,0.56 -0.11,0.18 -0.07,0.41 -0.19,0.12 -0.26,0.06 -0.29,0.19 -0.58,0.5 -2.28,1.38 -0.82,0.69 -0.01,0.16 -0.18,0.12 -0.62,0.54 -0.37,0.12 -1.51,0.18 -1.4,0.34 -0.36,0.04 -1.13,-0.04 -0.37,0.08 -0.51,0.36 -0.29,0.08 -1.27,0 -1.06,-0.25 -0.34,-0.01 -0.65,0.28 -1.13,1.06 -0.43,0.24 -0.38,0.29 -1.83,2.04 0.49,-0.16 0.21,-0.11 0.25,-0.25 0.13,0.93 -0.2,1.14 -0.4,1.08 -0.48,0.77 -1.11,0.98 -1.27,0.65 -1.42,0.29 -1.52,-0.09 -2.73,-0.95 -1.55,-0.2 -1.29,0.61 -0.4,0.72 -0.18,0.68 -0.33,0.5 -0.82,0.19 -0.67,0.08 -1.48,0.44 -0.51,0.24 -2.21,1.98 -0.38,0.24 -3.25,2.65 -3.68,2.15 -0.23,0.21 -0.22,0.25 -0.25,0.21 -0.35,0.09 -0.43,-0.08 -0.57,-0.34 -0.4,-0.08 -2.91,0.27 -1.49,-0.24 -0.57,-0.86 -0.42,-1.1 -0.99,-0.93 -1.52,-0.3 -3.08,0.12 -1.22,-0.6 -0.61,-0.97 -0.5,-1.21 -0.64,-1.16 -1.01,-0.82 -0.72,-0.14 -0.67,0.11 -0.66,0.19 -2.58,0.17 -0.71,-0.07 -2.32,-0.68 -0.59,-0.1 -0.36,-0.11 -0.65,-0.52 -0.28,-0.14 -0.35,-0.02 -0.7,0.15 -2.23,1.04 -1.56,0.22 -1.37,0.39 -0.75,0.03 -1.51,-0.49 -0.83,-0.07 -0.79,0.43 -0.42,-0.15 -1.76,-1.53 -2.55,-1.51 -3.29,-2.49 -0.48,-0.6 -0.2,-0.74 -0.08,-1.8 -0.27,-0.76 -0.58,-0.7 -1.08,-0.69 -11.52,-3.92 -0.74,-0.07 -0.72,-0.21 -0.46,-0.5 -0.35,-0.61 -0.43,-0.52 -2.02,-0.51 -0.31,-0.38 -0.29,-0.82 -0.69,-0.43 -1.56,-0.46 -2.73,-2.46 -1.2,-0.82 -1.81,-0.8 0.55,-1.07 0.19,-0.23 0.15,0.02 0.69,-0.3 0.37,0.02 2.21,-0.22 0.55,0.02 1.68,0.43 1.58,0.07 0.46,-0.17 1.46,-0.84 0.93,1.79 2.48,2.36 7.55,0.67 1.25,0.5 2.86,2.35 0.57,0.28 0.59,0.08 2.47,-0.63 0.87,0 10.36,1.84 3.53,-1.88 0.92,-1.48 -0.39,-1.12 0.01,-0.42 0.71,-2.09 0.5,-3.03 1.5,-1.83 3.5,-1.22 9.04,-0.83 2.06,0.27 1.6,0.56 1.68,-0.72 3.09,-0.72 9.03,1.28 4.23,-1.29 1.96,-1.87 1.11,-3.39 1.32,-2.1 4.62,-2.49 3.1,-0.8 1.96,0.11 1.02,-0.45 0.77,-0.55 0.58,-0.94 0.21,-2.17 -1.62,-2.65 -2.86,-2.34 -0.16,-1.24 0.16,-1.6 1.71,-6.27 0.4,-4.32 -0.9,-2.42 -10.18,-9.89 -0.18,-1.82 1.11,-0.81 -0.01,-1.09 -1.95,-5.89 2.87,0.21 6.12,1.74 3.03,2.38 1.48,1.94 1.48,1.04 z\"\r\n                        title=\"Hormozgan\" id=\"IR-23\"  data-fa=\"هرمزگان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 114.44043,243.3144 0,0 0.47,0.64 0.77,1.8 0.3,2 -0.17,1.29 -0.46,0.92 -0.8,0.85 -1.89,1.27 -0.67,0.95 -11.86,3.35 -2.1,2 -0.74,1.84 -0.59,0.07 -0.59,0.25 -0.09,0.62 -0.52,1.57 0.04,0.31 0.53,0.31 0.76,1.35 1.06,0.56 0.89,1.13 0.71,0.26 1.85,1.13 0.35,0.15 0.13,0.34 -0.05,0.41 -0.39,0.71 0.09,0.34 0.45,0.54 0.44,0.39 0.61,0.29 1.28,0.4 0.06,0.11 0.05,0.2 0.11,0.19 0.24,0.08 0.18,-0.04 0.17,-0.19 0.23,-0.04 0.26,0.06 0.19,0.15 0.16,0.19 1.68,1.28 0.6,0.28 0,0.53 0.62,0.63 0.86,0.53 1.44,0.35 4.16,2.1 0.36,0.42 0.19,0.5 0.44,0.14 0.5,0.03 0.38,0.17 0.8,0.95 0.67,1.28 0.44,0.49 0.64,0.19 0.5,0.25 1.1,1.23 3.99,5.25 5.45,11.5 0.67,0.97 0.41,0.39 -3.11,7.27 -2.48,3.43 0.06,2.04 0.4,2.56 -1.21,1.98 -3.54,2.33 -0.9,0.36 -0.08,-0.11 -0.65,-0.27 -0.51,-0.07 -0.3,-0.34 -0.28,-0.41 -0.43,-0.27 -0.53,-0.16 -0.23,-0.18 -0.04,-0.31 0.07,-0.56 0.14,-0.44 0.2,-0.35 0.18,-0.39 0.05,-0.55 -0.18,-0.52 -0.66,-0.51 -0.18,-0.51 -0.33,-0.16 -0.21,-0.23 -0.6,-0.83 -0.13,-0.22 -0.16,-0.22 -1.01,-0.97 -0.15,-0.23 -0.23,-0.54 0.01,-0.2 0.13,-0.15 0.3,-0.74 0.19,-0.23 0.12,-0.26 -0.05,-0.46 -0.19,-0.3 -0.91,-0.69 -0.56,-0.73 -0.38,-0.62 -0.44,-0.5 -0.72,-0.38 -1.92,-0.66 -0.47,-0.03 -1.56,0.86 -0.59,0.22 -1.2,0.13 -1.07,-0.23 -1.03,-0.55 -1.08,-0.79 0,-0.01 -0.01,0 -10.19,-8.91 -1.41,-1.6 -2.21,-1.35 -1.56,-1.26 -0.13,-0.07 -3.16,-1.84 -0.95,-0.95 -3.37,-1.62 -3.6,-1.12 -3.99,0.45 -1.98,-0.24 -0.72,-1.61 0,-0.01 0.41,-0.49 0.57,-0.46 0.5,-0.52 0.22,-0.69 -0.19,-0.55 -0.49,-0.44 -0.64,-0.27 -1.48,-0.17 -0.48,-0.41 0.04,-0.49 0.68,-0.38 0.74,-0.07 0.57,0.04 0.55,-0.11 0.71,-0.54 0.92,-0.91 0.46,-0.57 0.24,-0.51 -0.02,-0.37 -0.39,-0.25 -0.15,-0.38 0.02,-0.33 0.21,-0.77 -0.01,-0.42 -0.3,-0.68 -0.47,-0.49 -1.08,-0.87 -1.35,-1.91 -1.13,-1.1 -0.18,-0.59 -0.02,-0.68 -0.1,-0.82 -0.27,-0.77 -0.39,-0.7 -1.13,-1.42 -0.11,-0.08 -0.1,-0.06 -0.13,-0.08 -0.04,-0.02 -0.18,-0.03 -0.17,0.03 -0.16,0.09 -0.63,0.6 -1.03,0.13 -1,-0.23 -0.58,-0.5 0.53,-0.7 1.6,-0.98 0.42,-0.62 -0.24,-0.89 -0.71,-0.5 -0.6,-0.61 0.13,-1.25 -0.73,0.18 -1.65,0.03 -0.61,0.26 -0.99,0.95 -0.56,0.38 -0.59,0.14 -0.23,-0.28 0.01,-1.44 -0.11,-0.31 0.76,-0.64 0.72,-5.9 1.29,-4.06 0.37,-2.63 -0.47,-1.56 0.62,-0.73 2,0.06 5.25,-0.66 5.07,2.08 2.73,0.2 2.74,0.63 2.27,1.4 2.49,2.16 8.5,2.75 3.96,0.32 5.76,-1.47 5.31,0.24 0.71,-1.39 0.47,-2.64 -0.5,-1.03 -0.93,-1.39 0,-1.25 5.43,-1.26 1.15,0.1 0.56,0.17 z\"\r\n                        title=\"Ilam\" id=\"IR-05\"  data-fa=\"ایلام\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 124.87043,230.5444 0,0 0.85,0.38 1.45,0.94 0.7,1.02 14.54,9.57 7.52,0.91 1.25,0.47 1.01,-0.26 1.78,-1.84 0.88,-0.24 1.8,0.11 2.22,-0.25 9.24,3.95 -0.53,0.87 -0.24,1.33 0.42,1.1 0.12,0.93 -1.36,3.13 -0.28,0.9 -0.18,0.98 0.44,0.86 1.73,1 2.24,0.83 3.82,0.33 0.93,0.35 2.71,-1.72 0.64,-0.68 1.16,-3.55 1.5,-0.87 1.87,-0.63 1.7,-0.98 1.86,0.6 1.48,1.8 0.92,1.58 0.04,1.08 -0.54,1.17 -0.36,1.21 0.32,0.95 1.1,0.94 2.55,1.29 1.16,1.23 1.05,0.83 0.79,-0.54 0.22,-1.05 0.67,-1.32 1.18,-0.85 0.76,0.46 0.54,0.97 1.09,0.84 0.73,0.76 -0.05,1.19 0.24,1.16 2.16,1.17 0.3,0.33 -0.76,1.62 -0.14,2.2 0.09,1.75 -3.43,6.9 -0.19,0.95 -0.07,0.75 -0.81,0.48 -5.03,1.42 -1.95,2.3 -0.61,4.78 -1.55,1.17 -2.7,0.9 -0.77,0.5 -0.46,0.82 -0.21,0.97 0.02,0.39 -2.48,0.53 -4.76,-0.46 -7.89,-5.44 -7.5,-0.76 -2.11,-0.65 -1.74,-1.69 -3.51,-1.05 -3.6,0.27 -2.38,0.74 -8.36,0.56 -1.83,1.4 -4.62,12.18 -1.86,2.71 -0.41,-0.39 -0.67,-0.97 -5.45,-11.5 -3.99,-5.25 -1.1,-1.23 -0.5,-0.25 -0.64,-0.19 -0.44,-0.49 -0.67,-1.28 -0.8,-0.95 -0.38,-0.17 -0.5,-0.03 -0.44,-0.14 -0.19,-0.5 -0.36,-0.42 -4.16,-2.1 -1.44,-0.35 -0.86,-0.53 -0.62,-0.63 0,-0.53 -0.6,-0.28 -1.68,-1.28 -0.16,-0.19 -0.19,-0.15 -0.26,-0.06 -0.23,0.04 -0.17,0.19 -0.18,0.04 -0.24,-0.08 -0.11,-0.19 -0.05,-0.2 -0.06,-0.11 -1.28,-0.4 -0.61,-0.29 -0.44,-0.39 -0.45,-0.54 -0.09,-0.34 0.39,-0.71 0.05,-0.41 -0.13,-0.34 -0.35,-0.15 -1.85,-1.13 -0.71,-0.26 -0.89,-1.13 -1.06,-0.56 -0.76,-1.35 -0.53,-0.31 -0.04,-0.31 0.52,-1.57 0.09,-0.62 0.59,-0.25 0.59,-0.07 0.74,-1.84 2.1,-2 11.86,-3.35 0.67,-0.95 1.89,-1.27 0.8,-0.85 0.46,-0.92 0.17,-1.29 -0.3,-2 -0.77,-1.8 -0.47,-0.64 0.59,-0.42 0.49,-0.79 -0.13,-0.31 -0.04,-0.44 0.1,-0.76 -0.06,-0.47 -0.17,-0.33 -0.23,-0.25 -0.21,-0.27 -0.08,-0.4 0.2,-0.58 1.96,-0.97 2.42,-0.12 1.64,-0.85 0.19,-2.3 -0.31,-2.21 0.11,-0.92 0.65,-0.43 0.98,-0.26 2.33,0.31 z\"\r\n                        title=\"Lorestan\" id=\"IR-20\"  data-fa=\"لرستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 181.96043,293.7144 0,0 2.48,-0.53 1.64,4.07 1.83,0.98 2.95,-0.2 3.39,1.29 1.41,1.91 -0.73,1.12 -0.91,3 0.13,1.18 0.56,2.43 5.1,8.09 1.06,2.69 0.83,1.08 0.84,0.61 0.49,0.56 1.6,0.52 0.56,0.56 0.45,1.06 0.92,3.33 1.02,2.4 1.04,1.65 1.68,1.54 0.66,1.15 2.88,3.11 0.99,2.21 -0.1,1.85 -1.84,2.31 -1.21,2.34 -2.26,3.02 -4.05,3.64 -2.61,1.1 -1.15,0.88 -0.86,1.14 -0.56,1.29 0.03,2.31 1.54,5.59 0.1,1.6 -0.17,0.59 -0.15,1.18 -0.34,1.29 0.23,0.97 5.78,-0.77 1.36,1.76 2.65,2.63 3.23,1.72 1.91,1.39 0.58,2.08 -1.96,4.61 0.24,2.04 1.08,1.23 0.64,2.61 0.58,6.16 -5.23,-0.27 -1.95,-0.95 -3.49,0.58 -2.18,1.09 -0.89,-0.35 -1.22,-0.14 -1.26,0.19 -1.23,0.43 -10.63,6.81 -1.23,0.52 -1.09,-0.24 -0.95,-1.4 -0.09,-0.63 -0.01,-1.77 -0.26,-0.68 -0.25,-0.35 -0.09,-0.22 -0.12,-0.16 -0.37,-0.22 -0.33,-0.14 -0.32,-0.08 -0.73,-0.05 -0.36,0.04 -0.73,0.18 -0.41,0.05 -0.38,-0.08 -0.49,-0.37 -0.28,-0.08 -0.7,0.11 -1.27,0.54 -0.7,0.15 -0.88,-0.07 -0.32,-0.34 0.04,-1.61 -0.1,-0.12 -0.47,-0.34 -0.14,-0.23 -0.02,-0.21 0.02,-0.59 0.05,-0.29 0.14,-0.25 -0.01,-0.25 -0.41,-0.27 -0.2,0.66 -0.35,0.66 -0.49,0.46 -0.58,0.08 -0.61,-0.38 -0.29,-0.5 -0.36,-0.39 -0.59,-0.06 -0.79,-0.27 -2.24,-1.32 -0.46,-0.43 -0.22,-1.27 -0.6,-0.79 -0.89,-0.46 -1.08,-0.28 0.36,-0.65 0.56,-0.15 1.39,0.24 0.72,-0.04 1.12,-0.38 0.62,-0.1 0.69,0.17 1.38,0.74 0.48,0.17 0.75,0.07 0.57,0.24 0.46,0.42 0.44,0.61 0.2,-0.53 0.64,-1.14 1,-1.29 0.19,-0.42 0.03,-0.67 -0.7,0.14 -0.5,-0.32 -0.32,-0.61 -0.26,-1.44 -0.4,0.19 -0.53,0.57 -0.53,0.4 0.05,-0.5 0.05,-0.14 0.13,-0.17 -0.28,-0.44 -0.29,0.07 -0.34,0.26 -0.47,0.11 -0.21,-0.14 -0.37,-0.54 -0.23,-0.12 -0.22,0.04 -0.32,0.18 -0.17,0.05 -0.68,-0.11 -0.61,-0.18 -0.57,-0.03 -0.58,0.32 -1.21,-0.18 -0.97,0.61 -0.24,0.8 0.91,0.4 1.08,0.22 0.84,0.54 0.27,0.7 -0.68,0.69 -0.57,-0.01 -1.83,-0.26 -0.39,0.12 -1.85,1.73 -0.14,0.18 -0.3,0.47 -0.17,0.49 0.39,0.35 -0.14,0.28 -0.22,0.31 -0.12,0.21 0.25,0.84 0.6,0.61 0.68,0.52 0.56,0.61 0.28,0.7 0.22,0.88 0.19,1.76 -0.07,0.5 -0.3,0.8 -0.09,0.44 0.02,0.42 0.19,0.74 0.02,0.45 -0.21,0.77 -0.45,0.7 -0.61,0.49 -0.7,0.2 -2.3,-0.27 -0.59,0.27 -0.66,-0.31 -2.37,0.02 -1.43,-0.8 -0.55,-0.12 -0.09,0.68 0.16,0.46 0.46,0.74 0.09,0.54 -0.1,0.39 -0.25,0.33 -0.31,0.28 -0.29,0.19 -0.77,0.24 -2.49,-0.24 0,-0.27 -0.18,0.24 -0.04,0.1 -0.23,-0.11 -1.05,-0.3 -0.51,-0.31 -0.47,-0.37 -0.22,-0.22 -0.15,-0.26 -0.3,-0.76 -0.07,-0.51 -0.62,-1.95 -0.09,-0.06 -0.2,-0.41 -0.67,-0.76 -0.43,-0.91 -0.06,-0.27 0.07,-0.44 0.27,-0.32 0.32,-0.3 0.25,-0.33 0.09,-0.42 -0.07,-0.43 -0.17,-0.39 -0.22,-0.34 -1.32,-1.2 -1.09,-1.25 -0.69,-1.15 -0.31,-0.27 -0.41,-0.14 -0.43,-0.02 -1.24,0.21 -0.41,0.02 -0.4,-0.06 -0.37,-0.17 -0.27,-0.29 -0.15,-0.38 -0.28,-1.72 -0.31,-0.86 -0.43,-0.77 -0.57,-0.61 -0.35,-0.22 -0.37,-0.13 -3.59,-0.52 -0.05,-1.2 0,0 0.11,-18.98 -0.1,-0.51 -0.37,-0.22 -11.12,0 0.11,-9.56 0.09,-6.8 5.16,-14.07 0.2,-0.9 -0.09,-0.85 -0.47,-0.71 -1.33,-1.01 -0.55,-0.6 -0.12,-0.31 -0.17,-0.69 -0.19,-0.36 -0.26,-0.25 -0.61,-0.4 -0.23,-0.32 -1.22,-2.18 -0.16,-0.7 0,-0.01 -0.33,-0.7 -1.18,-0.58 -0.52,-0.6 -0.77,-1.74 -0.5,-0.72 0.9,-0.36 3.54,-2.33 1.21,-1.98 -0.4,-2.56 -0.06,-2.04 2.48,-3.43 3.11,-7.27 1.86,-2.71 4.62,-12.18 1.83,-1.4 8.36,-0.56 2.38,-0.74 3.6,-0.27 3.51,1.05 1.74,1.69 2.11,0.65 7.5,0.76 7.89,5.44 4.76,0.46 z\"\r\n                        title=\"Khuzestan\" id=\"IR-10\"  data-fa=\"خوزستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 247.35043,358.8644 0,0 -1.16,-0.09 -2.19,0.42 -1.68,1.48 -1.84,0.96 -3.88,-0.51 -1.16,0.02 -12.6,-11.23 -1.04,-0.13 -1.78,0.1 -5.94,-2.39 -2.4,-1.47 1.21,-2.34 1.84,-2.31 0.1,-1.85 -0.99,-2.21 -2.88,-3.11 -0.66,-1.15 -1.68,-1.54 -1.04,-1.65 -1.02,-2.4 -0.92,-3.33 -0.45,-1.06 -0.56,-0.56 -1.6,-0.52 -0.49,-0.56 -0.84,-0.61 -0.83,-1.08 -1.06,-2.69 -5.1,-8.09 -0.56,-2.43 -0.13,-1.18 6.68,-3.61 2.31,0.3 1.21,-0.21 1.06,-0.53 1.51,-0.32 2.07,1.14 2.07,1.72 2.2,0.27 1.67,-0.38 1.04,0.36 1.54,-0.33 3.77,-2.47 1.33,-0.24 4.45,-0.14 1.4,-0.47 0.75,-0.82 1.46,-0.25 1.32,1.15 0.34,1.83 0.33,0.98 0.89,0.23 0.52,0.58 0.29,1.16 0.73,1.17 -0.19,2.91 0.34,3.14 4.3,3.35 1.79,1.81 3.93,2.98 1.77,3.22 0.62,4.15 -1.07,2.11 -1.35,0.94 -0.15,1.23 0.67,1.22 1.02,1.31 0.08,1.21 -1.43,0.63 -1.16,0.82 -0.2,2.13 0.76,4.53 3.09,10.25 -0.09,3.08 -0.34,1.37 z\"\r\n                        title=\"Chahar Mahall and Bakhtiari\" id=\"IR-08\" data-fa=\"چهار محال بختیاری\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 450.32043,261.0144 0,0 8.66,-2.02 1.45,1.85 1.34,2.59 2.53,17.12 2.2,5.05 2.88,1.65 0.81,0.63 2.19,0.99 2.87,1.8 2.74,4.3 0.89,0.64 0.17,3.08 -0.28,1.25 -0.91,1.48 -0.58,1.44 0.24,0.89 0.52,0.93 0.99,1.13 0.06,1.21 1.03,2.25 1.36,2.25 -0.08,2.2 -0.77,2.23 -0.3,1.97 -0.56,1.87 -4.51,6.05 -1.25,3.49 -3.48,5.4 -1.77,4.57 -0.48,0.78 -36.34,-15.66 -4.32,-0.76 -0.73,1.11 -1.56,1.69 -7.04,3.99 -2.4,2.55 -17.98,9.5 -1.5,3.23 -0.44,12.48 -0.51,2.75 -5.74,2.53 -6.38,0.87 -2.78,-0.56 -4.33,-0.17 -19.03,3.38 -2.98,3.33 -1.57,2.98 -0.75,2.87 0.09,1.95 1.89,3.58 2,5.27 0.81,3.92 1.09,1.34 1.09,0.75 -0.43,12.7 0.36,2.22 0.47,1.56 0.04,1.11 -1.07,0.76 -3.42,0.42 -0.34,0.29 -1.49,0.66 -6.88,-3.5 -5.26,-3.96 -0.97,-2.34 -1.2,-8.58 -1.48,-2.62 -5.4,-6.64 -5.63,-10.08 -7.9,-20 -4.35,-5.3 -5.13,-4.72 -8.61,-3.32 -1.48,-5.85 -0.1,-2.76 0.36,-0.99 0.65,-4.83 1.42,-5.62 0.31,-2.57 -0.98,-12.32 0.26,-1.33 1.35,-0.9 2.43,-0.72 2.2,-1.25 1.49,-1.26 2.04,-1.3 3.27,-1.27 2.47,-0.09 10.72,2.47 35.84,-12.38 3.58,-2.04 1.87,-2.28 1.3,-2.46 1.1,-3.01 1.54,-6.78 1.82,-2.26 3.37,-1.81 2.63,-0.28 1.94,-1.36 2.89,-5.03 0.9,-2.88 -0.38,-27.64 0,-0.1 0.6,-0.27 3.11,-0.58 8.68,0.2 3.72,-1.93 12.18,-20.53 13.84,-3.62 13.46,-6.4 8.52,-2.2 3.77,0.99 9.88,7.59 1.16,2.61 -0.46,2.64 -3.28,3.22 -13.42,9.52 -2.31,4.17 -4.26,12.86 -0.28,6.91 2.11,11.75 1.59,2.51 6.72,0.81 z\"\r\n                        title=\"Yazd\" id=\"IR-25\"  data-fa=\"یزد\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 274.35043,171.9044 0,0 2.33,-0.95 4.4,-5.33 3.11,-2.46 2.24,0.3 2.41,1.01 3.05,0.57 3.87,2.1 2.58,0.54 1.79,-0.25 1.09,-0.65 1.47,0.34 3.04,2.11 1.07,4.68 0.44,4.2 -1.09,3.74 -5.38,4.91 -3.36,1.8 -3.86,1.28 -2.74,-0.11 -7.63,-2.22 -2.58,-0.06 -2.47,-0.85 -6.18,-3.78 -1.87,-1.63 -2.02,-0.11 -0.73,-0.26 -0.41,-0.41 -0.63,-0.29 -0.56,0.6 -0.46,3.82 -0.64,2.5 -0.21,1.9 0.26,1.77 3.82,5.08 1.53,2.79 -0.42,2.55 -1.74,2.69 -1.03,3.32 -0.13,1.77 -19.31,-11.52 -8.13,-2.45 -9.73,-0.11 0,-0.11 2.93,-9.49 -0.02,-2.91 -0.87,-1.69 -1.57,-1.96 0.89,-2.07 2.19,-1.35 1.77,-2.18 0.96,-2.53 3.01,-0.17 0.41,-2.02 0.13,-2.7 2.05,-2.36 2.73,-1.01 2.74,0.33 1.91,-1.18 0,-2.36 0.11,-1.77 3.66,2.16 5.19,0.44 4.61,1.81 3.46,3.74 1.96,3.69 1.22,1.4 1.01,0.6 1.66,0.6 2.67,0.16 z\"\r\n                        title=\"Tehran\" id=\"IR-07\"  data-fa=\"تهران\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 409.19043,113.5144 0,0 1.33,-0.23 1.65,0.69 -0.35,0.97 -1.98,0.59 -0.87,0.7 -0.21,0.63 0.22,0.34 0.21,0.45 0.17,1.12 -0.17,2.88 -0.64,2.53 -0.12,0.85 0.63,1.34 4.01,4.51 3.85,3.31 1.9,0.64 3.23,0.55 1.68,0.65 5.16,-0.87 0.67,-0.19 1.08,0.04 1.37,0.82 0.83,3.32 -0.91,3.93 -1.37,2.62 -0.5,4.58 0.64,7.87 1.1,5.06 0.92,2.35 8.03,6.57 2.22,2.56 -0.52,2.91 -5.89,10.15 -1.44,3.35 -1.03,0.81 -7.15,2.69 -3.85,2.3 -4.37,4 -5.44,6.75 -12.18,20.53 -3.72,1.93 -8.68,-0.2 -3.11,0.58 -0.6,0.27 0,0.1 -0.31,-0.4 -0.83,-0.72 -1.86,-0.61 -80.82,2.43 -1.76,-0.28 -14.42,-4.76 -2.31,-0.36 -9.28,0.59 -3.31,-0.55 -6.55,-3.55 1.13,-1.62 1.49,-3.5 0.91,-3.61 0.09,-3.36 -0.45,-1.65 0.13,-1.77 1.03,-3.32 1.74,-2.69 0.42,-2.55 -1.53,-2.79 -3.82,-5.08 -0.26,-1.77 0.21,-1.9 0.64,-2.5 0.46,-3.82 0.56,-0.6 0.63,0.29 0.41,0.41 0.73,0.26 2.02,0.11 1.87,1.63 6.18,3.78 2.47,0.85 2.58,0.06 7.63,2.22 2.74,0.11 3.86,-1.28 3.36,-1.8 5.38,-4.91 1.09,-3.74 -0.44,-4.2 -1.07,-4.68 0.5,-0.22 3.43,-0.38 1.6,-0.45 2.15,-1.24 1.76,-0.6 1.1,0.61 1.69,-0.23 2.59,-0.84 2.4,-1.3 1.47,-1.31 0.8,-1.12 0.42,-1.05 0.78,-1.15 3.47,-3.1 1.34,-1.55 0.54,-3.38 0.75,-2.54 1.2,-2.33 2.54,-2.56 2.82,-1.66 3.41,-1.02 6.63,-0.12 2.65,0.43 2.36,-0.53 4.78,-2.26 2.09,-2.28 5.74,-4.5 5.92,-3.41 2.88,-0.34 12.11,1.66 1.71,-0.81 1.13,-2.92 0.67,-4.64 2.8,-6.23 6.3,-9.73 1.4,-1.15 5.12,6.83 2.41,1.7 z\"\r\n                        title=\"Semnan\" id=\"IR-12\"  data-fa=\"سمنان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 328.44043,127.8244 0,0 0,0 0.05,0.55 0.38,1.05 1.18,2.05 7.48,4.53 3.58,3.7 1.38,2.11 -3.41,1.02 -2.82,1.66 -2.54,2.56 -1.2,2.33 -0.75,2.54 -0.54,3.38 -1.34,1.55 -3.47,3.1 -0.78,1.15 -0.42,1.05 -0.8,1.12 -1.47,1.31 -2.4,1.3 -2.59,0.84 -1.69,0.23 -1.1,-0.61 -1.76,0.6 -2.15,1.24 -1.6,0.45 -3.43,0.38 -0.5,0.22 -3.04,-2.11 -1.47,-0.34 -1.09,0.65 -1.79,0.25 -2.58,-0.54 -3.87,-2.1 -3.05,-0.57 -2.41,-1.01 -2.24,-0.3 -3.11,2.46 -4.4,5.33 -2.33,0.95 -2.67,-0.16 -1.66,-0.6 -1.01,-0.6 -1.22,-1.4 -1.96,-3.69 -3.46,-3.74 -4.61,-1.81 -5.19,-0.44 -3.66,-2.16 -2.2,-2.6 -5.55,-1.23 -1.42,-0.62 -1.29,-1.19 -0.61,-0.89 -2.16,-0.86 -5.59,-1.11 -0.04,-0.84 -0.39,-1.14 -5.49,-4.19 -1.87,-1.02 -9.03,-7.62 1.76,-1.15 2.08,-3.71 0.74,-3.51 1.36,-1.35 1.76,-0.95 1.16,-1.6 0.33,-1.08 0.02,-0.14 0,0 1.61,1.09 0.71,0.17 0.47,0.21 1,1.09 0.5,0.43 5.34,2.92 4.88,3.46 2.84,1.3 9.45,1.88 6.04,1.75 6.26,1.13 6.03,1.75 6.27,-0.83 5.57,-2.05 5.82,-1.44 6.03,-1.15 5.78,-1.18 5.8,-1.73 5.59,-1.73 11.24,-2.53 1.52,-0.25 13.33,-0.76 2.43,-0.59 1.65,-1.39 -0.08,1.61 -1.91,0.67 -2.41,0.3 -1.55,0.48 -0.43,0.21 -0.48,-0.07 -0.91,-0.29 -0.51,0.08 -0.93,0.37 -0.53,0.11 -1.98,-0.27 -1.74,0 0.27,0.48 0.47,0.15 1.12,-0.05 -0.68,0.23 -0.27,0.03 0.82,1.1 1.39,0.61 0.14,0.02 z\"\r\n                        title=\"Mazandaran\" id=\"IR-21\" data-fa=\"مازندران\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 405.42043,74.5244 0,0 4.84,-0.89 1.37,0.18 0.17,0.07 0.22,3.01 -0.22,1.22 0.09,1.56 0.41,1.8 -0.03,1.02 -0.69,2.77 0.07,1.94 1.15,1.37 1.6,0.79 1.38,1.06 0.63,2.61 -1.86,2.6 -3.97,1.38 -0.91,0.14 -1.02,0.46 -1.03,0.95 -2.46,1.02 -2.47,4.4 -1.03,1 -1.4,1.15 -6.3,9.73 -2.8,6.23 -0.67,4.64 -1.13,2.92 -1.71,0.81 -12.11,-1.66 -2.88,0.34 -5.92,3.41 -5.74,4.5 -2.09,2.28 -4.78,2.26 -2.36,0.53 -2.65,-0.43 -6.63,0.12 -1.38,-2.11 -3.58,-3.7 -7.48,-4.53 -1.18,-2.05 -0.38,-1.05 -0.05,-0.55 0,0 5.12,0.45 0.53,0.3 0.58,0.21 4.24,-1.17 0.4,-0.33 0.23,-0.71 0.02,-4.38 -0.19,-0.72 -0.5,-0.29 -0.64,-0.26 0.1,-0.62 0.77,-1.44 -0.81,-1.25 -0.54,-1.56 -0.75,-3.59 -1.03,-2.78 -0.15,-0.6 -0.32,-3.61 9.24,0.81 0.67,-0.04 0.61,-0.26 0.63,-0.6 0.63,-0.42 0.73,-0.04 0.79,0.1 0.74,0 1.21,-0.4 5.73,-3.33 0.77,-0.12 2.06,0.45 0.75,-0.01 0.51,-0.24 0.83,-0.9 0.67,-0.27 0.42,-0.4 1.61,-1.06 0.86,-0.72 0.16,-0.31 0.1,-0.65 0.46,-1.07 0.11,-0.61 0.04,-1.03 -0.04,-0.3 -0.16,-0.28 -0.39,-0.36 -0.12,-0.23 -0.04,-0.9 0.56,-1.33 0.15,-0.85 0.18,-0.68 0.44,-0.71 1.02,-1.11 5.09,-3.51 1.58,-1.78 0.26,-0.44 0.18,-0.59 0.41,-0.22 0.48,-0.08 0.36,-0.14 0.25,-0.33 0.37,-0.78 0.29,-0.33 0.65,-0.22 1.96,-0.38 0.42,-0.16 0.3,-0.68 0.74,-0.41 1.54,-0.52 0.39,-0.06 0.7,-0.57 0.7,-0.36 2.51,-1.95 0.83,-0.34 2.15,-0.09 6.69,-1.41 1.01,0 2.1,0.46 1.32,0.77 0.5,0.17 1.72,0.02 0.57,0.18 0.92,0.49 0.48,0.15 0.52,0.03 z\"\r\n                        title=\"Golestan\" id=\"IR-27\"  data-fa=\"گلستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 286.04043,345.0244 0,0 2.52,-0.01 11.56,-3.35 0.06,0 8.61,3.32 5.13,4.72 4.35,5.3 7.9,20 5.63,10.08 5.4,6.64 1.48,2.62 1.2,8.58 0.97,2.34 5.26,3.96 6.88,3.5 -0.01,0.77 0.93,3.09 2.75,5.71 0.38,1.5 0.74,1.3 0.81,0.83 1.51,0.96 7.76,0.72 1.97,0.84 6.85,17.02 1.95,5.89 0.01,1.09 -1.11,0.81 0.18,1.82 10.18,9.89 0.9,2.42 -0.4,4.32 -1.71,6.27 -0.16,1.6 0.16,1.24 2.86,2.34 1.62,2.65 -0.21,2.17 -0.58,0.94 -0.77,0.55 -1.02,0.45 -1.96,-0.11 -3.1,0.8 -4.62,2.49 -1.32,2.1 -1.11,3.39 -1.96,1.87 -4.23,1.29 -9.03,-1.28 -3.09,0.72 -1.68,0.72 -1.6,-0.56 -2.06,-0.27 -9.04,0.83 -3.5,1.22 -1.5,1.83 -0.5,3.03 -0.71,2.09 -0.01,0.42 0.39,1.12 -0.92,1.48 -3.53,1.88 -10.36,-1.84 -0.87,0 -2.47,0.63 -0.59,-0.08 -0.57,-0.28 -2.86,-2.35 -1.25,-0.5 -7.55,-0.67 -2.48,-2.36 -0.93,-1.79 -6.77,-4.89 -4.34,-4.09 -4.47,-5.52 -4.59,-10.29 -2.55,-2.99 -1.13,-0.67 -1.5,-0.6 -0.85,-1.4 -4.96,-14.04 -0.78,-3.48 -15.2,-28.66 -3,-2.76 -2.7,-1.01 -2.18,-2.29 -2.39,-3.79 -1.82,-4.18 -2.27,-2.53 -4.65,-1.51 -7.48,-0.56 -1.93,-0.74 -2.07,-4.21 -1.7,-1.7 -0.91,-2.83 0,-2.01 0,-0.1 3.4,-0.84 5.68,0.35 1.44,-0.23 9.04,-5.29 0.72,-1.51 0.04,-2.03 -0.83,-1.39 -0.25,-0.86 0.47,-0.84 -0.07,-0.89 -1.07,-3 -0.56,-3.31 0.51,-0.59 2.76,0.69 3.88,1.89 0.86,0.19 0.76,0.96 1.26,0.77 3.59,0.93 1.88,-0.51 1.67,-0.99 0.86,-0.86 0.19,-0.39 -0.02,-1.88 -1,-4.92 2.57,-0.39 0.95,-0.31 -0.01,-1.27 -0.35,-2.34 0.27,-3.44 2.86,-7.16 0.69,-4.04 0.82,-2.7 -0.98,-2.68 -1.95,-1.49 -1.49,-0.28 -1.33,-0.51 -1.04,-1.06 -0.8,-1.87 0.13,-1.18 3.29,0.79 2.54,-0.36 4.56,-3.1 0.96,-0.43 0.66,-0.89 4.61,-2.54 0.59,0.09 0.52,1.08 0.32,3.68 1.57,1.42 7.54,1.67 z\"\r\n                        title=\"Fars\" id=\"IR-14\"  data-fa=\"فارس\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 273.40043,226.7544 0,0 9.28,-0.59 2.31,0.36 14.42,4.76 1.76,0.28 80.82,-2.43 1.86,0.61 0.83,0.72 0.31,0.4 0.38,27.64 -0.9,2.88 -2.89,5.03 -1.94,1.36 -2.63,0.28 -3.37,1.81 -1.82,2.26 -1.54,6.78 -1.1,3.01 -1.3,2.46 -1.87,2.28 -3.58,2.04 -35.84,12.38 -10.72,-2.47 -2.47,0.09 -3.27,1.27 -2.04,1.3 -1.49,1.26 -2.2,1.25 -2.43,0.72 -1.35,0.9 -0.26,1.33 0.98,12.32 -0.31,2.57 -1.42,5.62 -0.65,4.83 -0.36,0.99 0.1,2.76 1.48,5.85 -0.06,0 -11.56,3.35 -2.52,0.01 -7.54,-1.67 -1.57,-1.42 -0.32,-3.68 -0.52,-1.08 -0.59,-0.09 -4.61,2.54 -0.66,0.89 -0.96,0.43 -4.56,3.1 -2.54,0.36 -3.29,-0.79 -0.13,1.18 0.8,1.87 1.04,1.06 1.33,0.51 1.49,0.28 1.95,1.49 0.98,2.68 -0.82,2.7 -0.69,4.04 -2.86,7.16 -0.27,3.44 0.35,2.34 0.01,1.27 -0.95,0.31 -2.57,0.39 -0.69,-0.67 -4.74,-3.42 -3.65,-3.89 -1.87,-4.85 -0.24,-2.64 0.34,-1.37 0.09,-3.08 -3.09,-10.25 -0.76,-4.53 0.2,-2.13 1.16,-0.82 1.43,-0.63 -0.08,-1.21 -1.02,-1.31 -0.67,-1.22 0.15,-1.23 1.35,-0.94 1.07,-2.11 -0.62,-4.15 -1.77,-3.22 -3.93,-2.98 -1.79,-1.81 -4.3,-3.35 -0.34,-3.14 0.19,-2.91 -0.73,-1.17 -0.29,-1.16 -0.52,-0.58 -0.89,-0.23 -0.33,-0.98 -0.34,-1.83 -1.32,-1.15 -1.46,0.25 -0.75,0.82 -1.4,0.47 -4.45,0.14 -1.33,0.24 -3.77,2.47 -1.54,0.33 -1.04,-0.36 -1.67,0.38 -2.2,-0.27 -2.07,-1.72 -2.07,-1.14 -1.51,0.32 -1.06,0.53 -1.21,0.21 -2.31,-0.3 -6.68,3.61 0.91,-3 0.73,-1.12 -1.41,-1.91 -3.39,-1.29 -2.95,0.2 -1.83,-0.98 -1.64,-4.07 -0.02,-0.39 0.21,-0.97 0.46,-0.82 0.77,-0.5 2.7,-0.9 1.55,-1.17 0.61,-4.78 1.95,-2.3 5.03,-1.42 0.81,-0.48 0.07,-0.75 0.19,-0.95 3.43,-6.9 -0.09,-1.75 0.14,-2.2 0.76,-1.62 2.81,-2.34 5.38,-3.2 14.11,-3.72 2.12,-1.31 1.9,-1.61 2.13,-0.68 1.94,-0.01 0.91,-1.61 3.23,-7.83 0.4,-2.44 -0.96,-0.51 -0.71,-1.77 1.02,-8.04 0.4,-1.2 1.27,-1.28 3.23,-1.41 7.31,-0.84 2.62,0.14 11.42,-2.97 6.55,3.55 3.31,0.55 z\"\r\n                        title=\"Esfahan\" id=\"IR-04\" data-fa=\"اصفهان\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 214.02043,435.4644 0,0 -0.34,0.05 -0.34,-0.31 -0.33,-0.85 -0.21,-0.76 -0.25,-0.46 0.4,-0.25 0.37,0.16 0.61,0.27 0.36,0.22 -0.15,0.67 0.1,0.67 -0.22,0.59 z m 34.53,-12.42 0,0 2.18,2.29 2.7,1.01 3,2.76 15.2,28.66 0.78,3.48 4.96,14.04 0.85,1.4 1.5,0.6 1.13,0.67 2.55,2.99 4.59,10.29 4.47,5.52 4.34,4.09 6.77,4.89 -1.46,0.84 -0.46,0.17 -1.58,-0.07 -1.68,-0.43 -0.55,-0.02 -2.21,0.22 -0.37,-0.02 -0.69,0.3 -0.15,-0.02 -0.19,0.23 -0.55,1.07 0,0 -2.63,-1.17 -0.69,-0.73 -0.06,-0.78 0.32,-0.49 0.57,-0.25 0.7,-0.07 0.64,0.02 0.73,-0.08 0.42,-0.37 -0.3,-0.9 -0.54,-0.46 -1.37,-0.53 -0.51,-0.43 -0.27,-0.45 -0.55,-1.25 -0.23,-0.39 -2.54,-2.63 -1.11,-0.88 -1.24,-0.54 -6.04,-1.33 -1.27,-0.64 -4,-3.72 -1.24,-0.84 -1.4,-0.59 -1.61,-0.22 -2.35,0.29 -0.54,-0.17 -0.63,-0.4 -1.21,0.09 -1.31,0.31 -2.12,0.39 -1.33,-0.21 -2.93,-0.61 -0.4,-0.1 -0.17,-0.25 -0.04,-0.37 -0.11,-0.28 -0.18,-0.19 -1.06,-0.15 -1.44,-0.44 -0.73,-0.78 -0.77,-1.31 -0.82,-0.52 -0.26,1.07 -0.69,0.06 -0.67,-2.29 -0.66,-0.96 -0.52,-1.39 -1.28,-2.09 -0.58,-0.55 -0.7,-0.73 -0.17,-0.77 0.75,-2.07 -0.05,-1.02 -0.7,-1.14 -1.18,-1.07 -0.41,-0.5 -1.2,-1.86 -1.11,-1.19 -0.26,-0.39 -2.07,-5.13 -0.28,-1.21 -0.03,-4.91 -0.43,-1.67 -0.76,-1.42 -0.86,-1.02 -1.1,-0.68 -1.42,-0.34 -1.38,-0.07 -0.67,-0.19 -0.29,-0.41 -0.25,-0.76 -1.6,-2.02 -0.27,-0.73 -0.21,-1.07 0.13,-0.96 0.7,-0.41 0.66,0.23 0.67,0.56 0.56,0.7 0.33,0.64 0.35,-0.31 -0.04,-0.28 -0.15,-0.32 0.05,-0.43 0.24,-0.28 0.68,-0.61 0.23,-0.41 0.12,-0.84 -0.09,-0.9 -0.33,-0.56 -0.62,0.16 -0.29,-1.12 -0.23,-0.4 -0.41,-0.35 -0.2,0.04 -0.31,0.17 -0.29,0.09 -0.12,-0.17 -0.04,-0.66 -0.07,-0.32 -0.12,-0.21 -0.81,-0.14 -2.65,0.16 -0.61,0.11 -0.9,0.53 -0.94,-0.11 -0.75,-0.66 -0.3,-1.08 -0.06,-0.94 0.09,-0.48 0.31,-0.46 0.24,-0.53 0.22,-0.64 0.31,-0.29 0.51,0.55 0.15,-1.58 0.08,-0.27 -0.33,-0.11 -0.21,-0.23 -0.41,-0.75 0.24,-0.95 -0.01,-1.51 -0.17,-1.55 -0.27,-1.05 -0.44,-0.81 -0.66,-0.9 -0.52,-0.25 -0.02,1.16 -0.19,-0.43 -0.96,-1.45 -1.79,-1.48 -0.29,-0.5 -0.23,-0.67 -0.54,-0.75 -1.1,-1.12 -2.01,-0.81 -0.3,-0.4 -0.22,-0.78 -0.49,-0.74 -0.91,-1.02 -0.91,-1.32 -1.54,-2.82 -0.81,-1.19 -0.64,-0.56 -1.39,-0.86 -1.32,-1.36 -0.12,-0.18 -0.1,-0.47 -0.03,-0.72 -0.12,-0.41 0.53,-0.06 0.12,-0.23 -0.2,-0.29 -0.45,-0.22 0.36,-1.33 -0.77,-2.21 0.2,-1.03 -0.48,-0.37 -0.53,-0.72 -0.45,-0.79 -0.18,-0.65 -0.2,-0.41 -0.5,-0.34 -0.27,-0.11 -0.01,0 2.18,-1.09 3.49,-0.58 1.95,0.95 5.23,0.27 3.96,1.43 1.26,0.91 0.59,0.56 0,2.01 0.91,2.83 1.7,1.7 2.07,4.21 1.93,0.74 7.48,0.56 4.65,1.51 2.27,2.53 1.82,4.18 2.39,3.79 z\"\r\n                        title=\"Bushehr\" id=\"IR-06\"  data-fa=\"بوشهر\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 220.02043,349.8844 0,0 1.78,-0.1 1.04,0.13 12.6,11.23 1.16,-0.02 3.88,0.51 1.84,-0.96 1.68,-1.48 2.19,-0.42 1.16,0.09 0.24,2.64 1.87,4.85 3.65,3.89 4.74,3.42 0.69,0.67 1,4.92 0.02,1.88 -0.19,0.39 -0.86,0.86 -1.67,0.99 -1.88,0.51 -3.59,-0.93 -1.26,-0.77 -0.76,-0.96 -0.86,-0.19 -3.88,-1.89 -2.76,-0.69 -0.51,0.59 0.56,3.31 1.07,3 0.07,0.89 -0.47,0.84 0.25,0.86 0.83,1.39 -0.04,2.03 -0.72,1.51 -9.04,5.29 -1.44,0.23 -5.68,-0.35 -3.4,0.84 0,0.1 -0.59,-0.56 -1.26,-0.91 -3.96,-1.43 -0.58,-6.16 -0.64,-2.61 -1.08,-1.23 -0.24,-2.04 1.96,-4.61 -0.58,-2.08 -1.91,-1.39 -3.23,-1.72 -2.65,-2.63 -1.36,-1.76 -5.78,0.77 -0.23,-0.97 0.34,-1.29 0.15,-1.18 0.17,-0.59 -0.1,-1.6 -1.54,-5.59 -0.03,-2.31 0.56,-1.29 0.86,-1.14 1.15,-0.88 2.61,-1.1 4.05,-3.64 2.26,-3.02 2.4,1.47 5.94,2.39 z\"\r\n                        title=\"Kohgiluyeh and Buyer Ahmad\" id=\"IR-18\" data-fa=\"کهگلویه و بویراحمد\"  />\r\n                </a>\r\n            </g>\r\n\r\n        </svg>\r\n        <div class=\"loading-map\">\r\n            <svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1.5\"\r\n                stroke=\"currentColor\" width=\"24\" height=\"24\">\r\n                <path stroke-linecap=\"round\" stroke-linejoin=\"round\"\r\n                    d=\"M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99\" />\r\n            </svg>\r\n            در حال بارگزاری\r\n        </div>\r\n		<div class=\"representative-info\"></div>\r\n    </div>\r\n	<!-- Script	 -->\r\n	<script>\r\ndocument.addEventListener(\"DOMContentLoaded\", () => {\r\n    const countrySvgElem = document.querySelector(\"#provinces-elem\");\r\n    const countrySvgWrapperElem = document.querySelector(\".representatives-map\")\r\n    const baseUrl = \"https://desing85.ir/\"\r\n	const items = document.querySelectorAll(\'.accordion-item\');\r\n\r\n            function closeAll() {\r\n                items.forEach(item => {\r\n                    const content = item.querySelector(\'.accordion-content\');\r\n                    content.style.height = content.scrollHeight + \'px\';\r\n                    requestAnimationFrame(() => {\r\n                        content.style.height = \'0px\';\r\n                    });\r\n                    item.classList.remove(\'active\');\r\n                });\r\n            }\r\n\r\n            function openAccordion(id, shouldScroll = true) {\r\n                const el = document.getElementById(id);\r\n                if (!el) return;\r\n\r\n                const content = el.querySelector(\'.accordion-content\');\r\n                closeAll();\r\n\r\n                el.classList.add(\'active\');\r\n                content.style.height = \'0px\';\r\n                requestAnimationFrame(() => {\r\n                    content.style.height = content.scrollHeight + \'px\';\r\n                });\r\n\r\n                content.addEventListener(\'transitionend\', function handler() {\r\n                    if (el.classList.contains(\'active\')) {\r\n                        content.style.height = \'auto\';\r\n                    }\r\n                    content.removeEventListener(\'transitionend\', handler);\r\n                });\r\n\r\n                if (shouldScroll) {\r\n                    // اسکرول با فاصله 100px از بالا\r\n                    setTimeout(() => {\r\n                        const offset = el.getBoundingClientRect().top + window.scrollY - 30;\r\n                        window.scrollTo({ top: offset, behavior: \'smooth\' });\r\n                    }, 200); // بعد از انیمیشن\r\n                }\r\n            }\r\n\r\n            // کلیک روی هدر آکوردیون\r\n            document.querySelectorAll(\'.accordion-header\').forEach(header => {\r\n\r\n                header.addEventListener(\'click\', () => {\r\n                    const parent = header.parentElement;\r\n                    if (parent.classList.contains(\'active\')) {\r\n                        closeAll();\r\n                    } else {\r\n                        openAccordion(parent.id, false); // بدون اسکرول\r\n                    }\r\n                });\r\n            });\r\n				\r\n            // اگر آدرس شامل hash بود در زمان بارگذاری\r\n            if (location.hash) {\r\n                const id = location.hash.substring(1);\r\n                setTimeout(() => openAccordion(id, true), 100);\r\n            }\r\n	\r\n	\r\n    const fillInfoBox = (info, cityname) => {\r\n        return `\r\n            ${info.thumbnail ? `<img class=\"representative-img\"\r\n                src=\"${info.thumbnail}\"\r\n                alt=\"\">`: `<div class=\"info-image-placeholder\">\r\n                <svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1\" stroke=\"currentColor\" width=\"20px\" height=\"20px\">\r\n                    <path stroke-linecap=\"round\" stroke-linejoin=\"round\" d=\"m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z\" />\r\n                </svg>\r\n                </div>`}\r\n            <div class=\"representative-text\">\r\n                <div>\r\n                <h5 class=\"representative-title\">${info.title}</h5>\r\n                <span class=\"province-box\">\r\n                    <svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1.5\"\r\n                        stroke=\"#4d4d4d\" width=\"15\" height=\"15\">\r\n                        <path stroke-linecap=\"round\" stroke-linejoin=\"round\"\r\n                            d=\"M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z\" />\r\n                        <path stroke-linecap=\"round\" stroke-linejoin=\"round\"\r\n                            d=\"M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1 1 15 0Z\" />\r\n                    </svg>\r\n                    <span class=\"province-label\">${cityname}</span>\r\n                </span>\r\n                </div>\r\n                <p class=\"representative-description\">${info?.description ?? \'\'}</p>\r\n            </div>`\r\n    }\r\n\r\n    const applyStylesInPath = async (provincesList) => {\r\n        let showTimeout;\r\n        let isInfoBoxVisible = false;\r\n        const linksElem = countrySvgElem.querySelectorAll(\".provinces path\")\r\n        const expandingCircleElem = countrySvgElem.querySelector(\"#expanding-circle\")\r\n        const infoBoxElem = countrySvgWrapperElem.querySelector(\".representative-info\")\r\n\r\n        countrySvgWrapperElem.classList.remove(\"loading\");\r\n\r\n        provincesList.forEach((linkElem) => {\r\n            const provinceElem = countrySvgElem.querySelector(`#${linkElem.province_id}`);\r\n            provinceElem.classList.add(\"is-representative\");\r\n            provinceElem.closest(\"a\").setAttributeNS(\"http://www.w3.org/1999/xlink\", \"xlink:href\",`#namayandegan-${linkElem.id}`);\r\n// 			provinceElem.closest(\"a\").dataset.active = true;\r\n            provinceElem.addEventListener(\'click\', function (e) {\r\n                    const id = `namayandegan-${linkElem.id}`;\r\n					console.log(id);\r\n                    if (document.getElementById(id)) {\r\n						console.log(\"fire\");\r\n                        e.preventDefault();\r\n                        openAccordion(id, true); // با اسکرول\r\n                        history.pushState(null, null, `#${id}`);\r\n                    }\r\n                });\r\n		\r\n            provinceElem.addEventListener(\'mouseleave\', () => {\r\n                clearTimeout(showTimeout);\r\n                if (isInfoBoxVisible) {\r\n                    infoBoxElem.classList.remove(\"show\");\r\n                    isTooltipVisible = false;\r\n                }\r\n            });\r\n        })\r\n\r\n        expandingCircleElem.style.r = 800;\r\n    }\r\n\r\n    const getActiveRepresentatives = async () => {\r\n        fetch(`${baseUrl}/wp-json/v1/representatives`)\r\n            .then(res => res.json())\r\n            .then(res => {\r\n                applyStylesInPath(res)\r\n            })\r\n    }\r\n\r\n    getActiveRepresentatives()\r\n\r\n})\r\n	</script>\r\n    <?php\r\n    return ob_get_clean();\r\n}\r\nadd_shortcode(\'representatives_map_2_shortcode\', \'representatives_map_2_shortcode\');\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-25 18:05:58\";}i:3;a:14:{s:2:\"id\";i:1242;s:5:\"title\";s:25:\"Representatives Accordion\";s:4:\"code\";s:5910:\"function show_namayandegan_accordion() {\r\n    $args = array(\r\n        \'post_type\' => \'representatives\',\r\n        \'posts_per_page\' => -1,\r\n        \'post_status\' => \'publish\',\r\n        \'orderby\' => \'title\',\r\n        \'order\' => \'ASC\',\r\n    );\r\n	\r\n	function get_province_name($id){\r\n					$provinces = [\r\n        \'IR-01\' => \'آذربایجان شرقی\',\r\n        \'IR-02\' => \'آذربایجان غربی\',\r\n        \'IR-03\' => \'اردبیل\',\r\n        \'IR-04\' => \'اصفهان\',\r\n        \'IR-05\' => \'ایلام\',\r\n        \'IR-06\' => \'بوشهر\',\r\n        \'IR-07\' => \'تهران\',\r\n        \'IR-08\' => \'چهارمحال و بختیاری\',\r\n        \'IR-10\' => \'خوزستان\',\r\n        \'IR-11\' => \'زنجان\',\r\n        \'IR-12\' => \'سمنان\',\r\n        \'IR-13\' => \'سیستان و بلوچستان\',\r\n        \'IR-14\' => \'فارس\',\r\n        \'IR-15\' => \'کرمان\',\r\n        \'IR-16\' => \'کردستان\',\r\n        \'IR-17\' => \'کرمانشاه\',\r\n        \'IR-18\' => \'کهگیلویه و بویراحمد\',\r\n        \'IR-19\' => \'گیلان\',\r\n        \'IR-20\' => \'لرستان\',\r\n        \'IR-21\' => \'مازندران\',\r\n        \'IR-22\' => \'مرکزی\',\r\n        \'IR-23\' => \'هرمزگان\',\r\n        \'IR-24\' => \'همدان\',\r\n        \'IR-25\' => \'یزد\',\r\n        \'IR-26\' => \'قم\',\r\n        \'IR-27\' => \'گلستان\',\r\n        \'IR-28\' => \'قزوین\',\r\n        \'IR-29\' => \'خراسان جنوبی\',\r\n        \'IR-30\' => \'خراسان رضوی\',\r\n        \'IR-31\' => \'خراسان شمالی\',\r\n        \'IR-32\' => \'البرز\',\r\n					];\r\n    			return $provinces[$id] ?? null;\r\n	}\r\n\r\n    $namayandegan_query = new WP_Query($args);\r\n\r\n    if ($namayandegan_query->have_posts()) {\r\n        ob_start(); // شروع بافر خروجی\r\n        ?>\r\n        <style>\r\n            body {\r\n                background: #f3f3f3;\r\n                font-family: \"vazirmatn\";\r\n            }\r\n\r\n            .accordion {\r\n                display: flex;\r\n                flex-direction: column;\r\n                gap: 20px;\r\n            }\r\n\r\n            .accordion-item {\r\n                background-color: #fff;\r\n                border-radius: 10px;\r\n                padding: 5px 10px 10px 10px;\r\n            }\r\n\r\n            .accordion-content {\r\n                overflow: hidden;\r\n                height: 0;\r\n                transition: height 0.4s ease;\r\n                font-size: 14px;\r\n                color: rgb(105, 105, 105);\r\n                padding: 0 20px;\r\n                line-height: 2;\r\n                text-align: justify;\r\n            }\r\n\r\n            .accordion-header {\r\n                position: relative;\r\n                cursor: pointer;\r\n                padding: 10px;\r\n                margin: 5px 0;\r\n                font-weight: bold;\r\n                font-size: 14px;\r\n                padding-right: 50px;\r\n                display: flex;\r\n                justify-content: space-between;\r\n                align-items: center;\r\n            }\r\n\r\n            .accordion-header-icon {\r\n                width: 40px !important;\r\n                height: 40px !important;\r\n                border-radius: 50% !important;\r\n                object-fit: cover !important;\r\n                position: absolute !important;\r\n                right: 0;\r\n                top: 50%;\r\n                transform: translateY(-50%);\r\n            }\r\n\r\n            .accordion-header svg {\r\n                width: 15px;\r\n                height: 15px;\r\n                transition: 0.5s;\r\n            }\r\n\r\n            .active .accordion-header svg {\r\n                transform: rotate(180deg);\r\n            }\r\n\r\n            .accordion-header-title {\r\n                display: flex;\r\n                flex-direction: column;\r\n                text-align: right;\r\n            }\r\n\r\n            .accordion-header-title .city {\r\n                font-size: 12px;\r\n                font-weight: 300;\r\n            }\r\n        </style>\r\n\r\n        <div class=\"accordion\">\r\n            <?php while ($namayandegan_query->have_posts()) : $namayandegan_query->the_post(); ?>\r\n                <?php\r\n                $post_id = get_the_ID();\r\n                $post_title = get_the_title();\r\n                $post_content = apply_filters(\'the_content\', get_the_content());\r\n				$port_province = get_province_name(get_post_meta(get_the_ID(), \'province\', true));\r\n      			$post_thumbnail = get_the_post_thumbnail_url(get_the_ID(), \'full\');\r\n                ?>\r\n                <div class=\"accordion-item\" id=\"namayandegan-<?php echo esc_attr($post_id); ?>\">\r\n                    <div class=\"accordion-header\">\r\n                        <img class=\"accordion-header-icon\"\r\n                             src=\"<?php echo  $post_thumbnail; ?>\"\r\n                             alt=\"icon\">\r\n                        <div class=\"accordion-header-title\">\r\n                            <span class=\"title\"><?php echo esc_html($post_title); ?></span>\r\n                            <span class=\"city\">استان <?php echo $port_province; ?></span>\r\n                        </div>\r\n                        <svg data-name=\"Layer 1\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 24.39 12.97\">\r\n                            <path d=\"M12.2,12.97c-.25,0-.51-.1-.7-.29L.3,1.71c-.39-.39-.4-1.02-.01-1.41.39-.4,1.02-.4,1.41-.01l10.5,10.28L22.69.29c.39-.39,1.03-.38,1.41.01.39.39.38,1.03-.01,1.41l-11.19,10.97c-.19.19-.45.29-.7.29Z\"/>\r\n                        </svg>\r\n                    </div>\r\n                    <div class=\"accordion-content\"><?php echo $post_content; ?></div>\r\n                </div>\r\n            <?php endwhile; ?>\r\n        </div>\r\n\r\n        <?php\r\n        wp_reset_postdata();\r\n        return ob_get_clean(); // گرفتن خروجی و بازگرداندن به عنوان خروجی شورتکد\r\n    } else {\r\n        return \'<p>هیچ نماینده‌ای یافت نشد.</p>\';\r\n    }\r\n}\r\nadd_shortcode(\'namayandegan_accordion\', \'show_namayandegan_accordion\');\r\n\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-27 12:24:59\";}i:4;a:14:{s:2:\"id\";i:844;s:5:\"title\";s:9:\"PriceList\";s:4:\"code\";s:3260:\"add_action(\'rest_api_init\', function () {\r\n    register_rest_route(\'myapi/v1\', \'/price-list/\', [\r\n        \'methods\' => \'GET\',\r\n        \'callback\' => \'get_full_price_list_data\',\r\n        \'permission_callback\' => \'__return_true\',\r\n    ]);\r\n});\r\n\r\nfunction get_full_price_list_data()\r\n{\r\n    $response = wp_remote_get(\'https://api.tgju.org/v1/widget/tmp?keys=137203\', [\r\n        \'timeout\' => 30,\r\n        \'user-agent\' => \'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36\',\r\n    ]);\r\n    if (is_wp_error($response)) {\r\n        return new WP_Error(\'api_error\', \'خطا در دریافت نرخ دلار\', [\'status\' => 500]);\r\n    }\r\n\r\n    $body = wp_remote_retrieve_body($response);\r\n    $data = json_decode($body, true);\r\n    $indicator = $data[\'response\'][\'indicators\'][0] ?? null;\r\n    if (!$indicator) {\r\n        return new WP_Error(\'no_data\', \'داده‌ای از TGJU دریافت نشد\', [\'status\' => 500]);\r\n    }\r\n\r\n    $price_now  = (float) str_replace(\',\', \'\', $indicator[\'p\'] ?? 0);\r\n    $price_high = (float) str_replace(\',\', \'\', $indicator[\'h\'] ?? 0);\r\n    $price_low  = (float) str_replace(\',\', \'\', $indicator[\'l\'] ?? 0);\r\n    $price_dp   = (float) ($indicator[\'dp\'] ?? 0);\r\n\r\n    if ($price_now === 0) {\r\n        return new WP_Error(\'invalid_price\', \'قیمت معتبر دریافت نشد\', [\'status\' => 500]);\r\n    }\r\n\r\n    $options = get_option(\'price_list\');\r\n    $items = $options[\'list_items\'] ?? [];\r\n\r\n    $result = [\r\n        \'top\' => [],\r\n        \'right\' => [],\r\n        \'left\' => [],\r\n    ];\r\n\r\n    foreach ($items as $item) {\r\n        $title = $item[\'title\'] ?? \'بدون عنوان\';\r\n        $name = $item[\'slug\'] ?? \'\';\r\n        $usd_price = (float) ($item[\'price\'] ?? 0);\r\n        $show_places = $item[\'show_place\'] ?? [\'top-items\']; \r\n\r\n        if (!is_array($show_places)) {\r\n            $show_places = [$show_places];\r\n        }\r\n\r\n        $rial_now = round($usd_price * $price_now);\r\n        $rial_high = round($usd_price * $price_high);\r\n        $rial_low = round($usd_price * $price_low);\r\n        $percent_decimal = $price_dp / 100;\r\n        $rial_yesterday = round($rial_now / (1 + $percent_decimal));\r\n        $rial_change = $rial_now - $rial_yesterday;\r\n\r\n        $item_data = [\r\n            \'title\' => $title,\r\n            \'name\' => $name,\r\n            \'usd_price\' => $usd_price,\r\n            \'rial_price\' => [\r\n                \'now\' => $rial_now,\r\n                \'high\' => $rial_high,\r\n                \'low\' => $rial_low,\r\n                \'yesterday\' => $rial_yesterday,\r\n                \'change\' => $rial_change,\r\n                \'change_percent\' => $price_dp,\r\n                \'change_direction\' => $rial_change > 0 ? \'up\' : ($rial_change < 0 ? \'down\' : \'neutral\'),\r\n            ]\r\n        ];\r\n\r\n        foreach ($show_places as $place) {\r\n            switch ($place) {\r\n                case \'top-items\':\r\n                    $result[\'top\'][] = $item_data;\r\n                    break;\r\n                case \'right-table\':\r\n                    $result[\'right\'][] = $item_data;\r\n                    break;\r\n                case \'left-table\':\r\n                    $result[\'left\'][] = $item_data;\r\n                    break;\r\n            }\r\n        }\r\n    }\r\n\r\n    return rest_ensure_response($result);\r\n}\r\n\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-27 15:35:24\";}i:5;a:14:{s:2:\"id\";i:758;s:5:\"title\";s:33:\"Image Gallery (Product) ShortCode\";s:4:\"code\";s:3457:\"function product_slider_shortcode($atts) {\r\n    if (!is_singular(\'products\')) return \'\';\r\n\r\n    $post_id = get_the_ID();\r\n    $gallery_string = get_post_meta($post_id, \'image-gallery\', true);\r\n\r\n    // آدرس داینامیک تصویر پیش‌فرض\r\n    $default_image = home_url(\'/wp-content/uploads/2025/06/placeholder.webp\');\r\n\r\n    // تبدیل رشته به آرایه\r\n    $gallery_ids = array_filter(array_map(\'trim\', explode(\',\', $gallery_string)));\r\n\r\n    if (empty($gallery_ids)) {\r\n        $gallery_ids = [\'default\'];\r\n    }\r\n\r\n    ob_start();\r\n    ?>\r\n    <link rel=\"stylesheet\" href=\"https://desing85.ir/wp-content/uploads/swiper/swiper-bundle.min.css\" />\r\n	<style>\r\n		.mySwiper2 img{\r\n			background:white;\r\n			border-radius:12px;\r\n			height:500px;\r\n			object-fit: cover;\r\n		}\r\n		\r\n		@media only screen and (max-width: 768px) {\r\n		 	.mySwiper2 img{\r\n			height:300px;\r\n		}\r\n			.mySwiper img{\r\n    			width:50px !Important;\r\n				height:50px  !Important;\r\n			}\r\n			\r\n		}\r\n		\r\n		.mySwiper2{\r\n			--swiper-navigation-size: 20px;\r\n			--swiper-navigation-color:#003366;\r\n		}\r\n		\r\n		.mySwiper img{\r\n			background:white;\r\n			border-radius:8px;\r\n			height: 80px;\r\n    		width: 80px;\r\n    		display: flex;\r\n    		justify-self: center;\r\n			object-fit: cover;\r\n			opacity:0.5;\r\n			transition:0.4s;\r\n			cursor:pointer;\r\n		}\r\n		\r\n		.mySwiper .swiper-slide-thumb-active img{\r\n			opacity:1 !Important;\r\n		}\r\n		.swiper-button-next,\r\n		.swiper-button-prev{\r\n			right:unset !Important;\r\n			top:unset !Important;\r\n			bottom:20px !Important;\r\n		}\r\n		\r\n		.swiper-button-next{\r\n			left:20px !Important;\r\n		}\r\n		\r\n		.swiper-button-prev{\r\n			left:50px !Important;\r\n		}\r\n	</style>\r\n    <div  class=\"swiper mySwiper2\">\r\n        <div class=\"swiper-wrapper\">\r\n            <?php foreach ($gallery_ids as $image_id): \r\n                $url = ($image_id === \'default\') ? $default_image : wp_get_attachment_image_url($image_id, \'large\'); ?>\r\n                <div class=\"swiper-slide\">\r\n                    <img src=\"<?php echo esc_url($url); ?>\" />\r\n                </div>\r\n            <?php endforeach; ?>\r\n        </div>\r\n        <div class=\"swiper-button-next\"></div>\r\n        <div class=\"swiper-button-prev\"></div>\r\n    </div>\r\n\r\n    <div thumbsSlider=\"\" class=\"swiper mySwiper\" style=\"margin-top: 10px;\">\r\n        <div class=\"swiper-wrapper\">\r\n            <?php foreach ($gallery_ids as $image_id): \r\n                $thumb_url = ($image_id === \'default\') ? $default_image : wp_get_attachment_image_url($image_id, \'thumbnail\'); ?>\r\n                <div class=\"swiper-slide\">\r\n                    <img src=\"<?php echo esc_url($thumb_url); ?>\" />\r\n                </div>\r\n            <?php endforeach; ?>\r\n        </div>\r\n    </div>\r\n\r\n    <script src=\"https://desing85.ir/wp-content/uploads/swiper/swiper-bundle.min.js\"></script>\r\n    <script>\r\n    const swiperThumbs = new Swiper(\".mySwiper\", {\r\n        loop: true,\r\n        spaceBetween: 10,\r\n        slidesPerView: 5,\r\n        freeMode: true,\r\n        watchSlidesProgress: true,\r\n    });\r\n    const swiperMain = new Swiper(\".mySwiper2\", {\r\n        loop: true,\r\n        spaceBetween: 10,\r\n        navigation: {\r\n            nextEl: \".swiper-button-next\",\r\n            prevEl: \".swiper-button-prev\",\r\n        },\r\n        thumbs: {\r\n            swiper: swiperThumbs,\r\n        },\r\n    });\r\n    </script>\r\n    <?php\r\n    return ob_get_clean();\r\n}\r\nadd_shortcode(\'product_slider_shortcode\', \'product_slider_shortcode\');\r\n\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-29 23:00:54\";}i:6;a:14:{s:2:\"id\";i:173;s:5:\"title\";s:40:\"Representatives Map (MainPage) ShortCode\";s:4:\"code\";s:151422:\"function representatives_map_shortcode($atts) {\r\n    ob_start();\r\n    ?>\r\n	<!-- Styles	-->\r\n  	<style>\r\n        .representatives-map {\r\n            position: relative;\r\n            opacity: 1;\r\n            transition: 0.3s;\r\n			font-family: var(--e-global-typography-primary-font-family);\r\n        }\r\n\r\n        .representatives-map .loading-map {\r\n            position: absolute;\r\n            top: 50%;\r\n            right: 50%;\r\n            opacity: 0;\r\n            transform: scale(0);\r\n            transition: 0.5s;\r\n            display: flex;\r\n            flex-direction: column;\r\n            align-items: center;\r\n            gap: 10px;\r\n            font-weight: 500;\r\n            font-size: 12px;\r\n        }\r\n\r\n        .representatives-map.loading .loading-map {\r\n            opacity: 1;\r\n            transform: scale(1);\r\n        }\r\n\r\n        .representatives-map.loading #provinces-elem {\r\n            opacity: 0.2;\r\n        }\r\n\r\n        .representatives-map .loading-map svg {\r\n            animation: spin-loading 2s linear infinite;\r\n        }\r\n\r\n        @keyframes spin-loading {\r\n            from {\r\n                transform: rotate(0deg);\r\n            }\r\n\r\n            to {\r\n                transform: rotate(360deg);\r\n            }\r\n        }\r\n\r\n        .representative-info {\r\n			position:absolute;\r\n			left:0;\r\n			bottom:0;\r\n            width: 250px;\r\n            padding: 10px;\r\n            background-color: #fff;\r\n            border-radius: 20px;\r\n            display: flex;\r\n            gap: 10px;\r\n            border: 1px solid #5050502c;\r\n            transform: scale(0);\r\n            transition: 0.3s;\r\n			font-family: var(--e-global-typography-primary-font-family);\r\n        }\r\n\r\n        .representative-img {\r\n            width: 80px !important;\r\n            height: 80px !important;\r\n            object-fit: cover;\r\n            border-radius: 10px !important;\r\n        }\r\n\r\n        .representative-text {\r\n            display: flex;\r\n            flex-direction: column;\r\n            justify-content: space-between;\r\n        }\r\n\r\n        .representative-title {\r\n            font-size: 14px;\r\n            margin: 0;\r\n        }\r\n\r\n        .representative-description {\r\n			margin:0;\r\n            margin-top: 7px;\r\n            font-size: 10px;\r\n            color: #4d4d4d;\r\n            display: -webkit-box;\r\n            max-width: 200px;\r\n            -webkit-line-clamp: 2;\r\n            -webkit-box-orient: vertical;\r\n            overflow: hidden;\r\n        }\r\n\r\n        .province-box {\r\n			margin-top:5px;\r\n            display: flex;\r\n            align-items: center;\r\n            gap: 3px;\r\n            font-size: 10px;\r\n        }\r\n\r\n        .province-label {\r\n            color: #4d4d4d;\r\n        }\r\n\r\n        .info-image-placeholder {\r\n            width: 80px !important;\r\n            height: 80px !important;\r\n            background: #afafaf;\r\n            border-radius: 10px !important;\r\n            display: flex;\r\n            justify-content: center;\r\n            align-items: center;\r\n        }\r\n        .representative-info.show {\r\n            transform: scale(1);\r\n        }\r\n\r\n		.is-representative{\r\n			fill:Transparent;\r\n			transition: 0.4s;\r\n		}\r\n\r\n		.is-representative:hover{\r\n			fill:#0059b2;\r\n		}\r\n    </style>\r\n\r\n	<!-- Html Elements	-->\r\n    <div class=\"representatives-map loading\">\r\n        <svg id=\"provinces-elem\" viewBox=\"0 0 654.51147 593.71021\">\r\n            <defs>\r\n                <clipPath id=\"iran-clip\">\r\n                    <path\r\n                        d=\"m 230.09043,148.8044 0,0 5.59,1.11 2.16,0.86 0.61,0.89 1.29,1.19 1.42,0.62 5.55,1.23 2.2,2.6 -0.11,1.77 0,2.36 -1.91,1.18 -2.74,-0.33 -2.73,1.01 -2.05,2.36 -0.13,2.7 -0.41,2.02 -3.01,0.17 -0.96,2.53 -1.77,2.18 -2.19,1.35 -0.89,2.07 -1.56,0.14 -0.94,1.92 -0.96,0.2 -0.24,-1.39 0.01,-2.31 -1.31,-1.55 -1.91,-0.02 -0.43,1.12 1.31,1.82 0,0.7 -0.35,0.62 -0.85,-0.51 -1.95,-1.76 -3.32,-0.97 -3.42,-0.22 -1.46,-0.34 -0.73,-1.21 -0.86,-1.92 -0.28,-1.29 0.42,-1.63 1.86,-1.8 6.86,-3.35 1.16,-1.11 0.4,-1.54 1.63,-3.39 1.07,-3.62 -1.57,-1.35 -2.4,-0.72 -1.25,-1.07 -1.73,-2.38 0.98,-1.49 3.84,-0.31 8.06,0.86 z\"\r\n                        title=\"Alborz\" />\r\n                    <path\r\n                        d=\"m 468.28043,340.0844 0,0 38.55,17.43 4.85,3.63 13.52,19.71 -6.95,32.33 -0.3,3.24 0.8,0.85 1.53,1.01 1.35,3.42 1.17,8.21 -0.1,3.39 -1.03,3.84 -2.84,4.34 -0.49,2.5 0.49,2.57 0.04,3.17 1,2.09 0.35,1.5 -0.06,1.43 -0.99,1.08 -1.53,1.2 -7.88,4.59 -3.85,1.31 -1.96,1.05 1.26,1.95 2.78,2.11 1.21,1.95 -1.05,3.48 -3.91,5.11 0.23,13.28 -0.45,4.38 -3.9,15.31 0.01,3.77 0.82,3.2 0.12,1.42 -0.1,2.44 0.7,2.59 2.58,2.97 1.78,3.63 -0.96,2.88 -0.95,1.63 0.55,0.87 1.08,0.99 0.04,1.29 -1.09,1.3 -0.84,1.74 0.63,2.2 1.17,1.39 0.29,1.45 -0.54,1.45 -0.64,0.78 0.06,1.23 -0.46,0.61 -0.41,0.98 0.02,2.33 -0.2,1.4 -0.67,1.65 -1.38,-2.09 -0.49,-0.41 -0.93,0.01 -1.31,-0.52 -0.99,0.25 -1,1.05 -1.45,0.18 -1.68,-0.06 -1.4,-0.32 -0.57,-1.01 -0.1,-1.17 -0.34,-0.84 -0.08,-0.73 0.32,-0.7 0.05,-0.41 -0.64,-0.4 -2.11,-0.33 -1.3,-0.59 -1.19,-0.27 -1.17,0.55 -1.83,0.17 -2.78,-0.5 -4.49,0.32 -0.06,-0.77 0.69,-0.85 0.4,-2.11 0,-1.09 -0.19,-1.09 0.78,-7.39 0.47,-1.17 0.62,-0.76 0.19,-0.63 -0.05,-0.96 -0.82,-2.43 0.04,-0.76 0.73,0.04 2.12,1.29 0.29,-0.72 -0.97,-2.1 -1.99,-2.31 -2.53,-2.13 -2.33,-1.4 -2.23,-0.06 -1.39,0.95 -0.81,1.13 -1.6,1.5 -1.02,-0.32 -2.29,-1.69 -10.47,-5.56 -0.68,-2.21 -1.07,-14.26 -1.02,-2.99 -0.92,-1.88 -0.91,-0.46 -0.77,-1.11 0.59,-1.18 0.94,-0.79 -0.23,-1.92 -1.53,-2.33 -1.54,-1.69 -0.79,-1.52 -1.35,-1.76 -1.76,-0.96 -1.04,-0.13 -0.68,-0.57 -0.49,-0.81 -1.23,-5.97 0.3,-3.93 -0.27,-0.62 -3.53,-1.73 -1.84,-0.07 -1.56,1.23 -1.03,1.27 -3.67,3.49 -3.98,1.97 -2.17,0.39 -4.03,-0.62 -3.48,-2.11 -2.91,-2.68 -3.02,-3.91 -0.71,-3.76 0.84,-2.86 -0.65,-14.7 -0.95,-1.41 -1.02,0.13 -3.98,1.87 -6.77,5.14 -1.74,0.45 -1.52,-0.75 -1.48,-1.04 -1.48,-1.94 -3.03,-2.38 -6.12,-1.74 -2.87,-0.21 -6.85,-17.02 -1.97,-0.84 -7.76,-0.72 -1.51,-0.96 -0.81,-0.83 -0.74,-1.3 -0.38,-1.5 -2.75,-5.71 -0.93,-3.09 0.01,-0.77 1.49,-0.66 0.34,-0.29 3.42,-0.42 1.07,-0.76 -0.04,-1.11 -0.47,-1.56 -0.36,-2.22 0.43,-12.7 -1.09,-0.75 -1.09,-1.34 -0.81,-3.92 -2,-5.27 -1.89,-3.58 -0.09,-1.95 0.75,-2.87 1.57,-2.98 2.98,-3.33 19.03,-3.38 4.33,0.17 2.78,0.56 6.38,-0.87 5.74,-2.53 0.51,-2.75 0.44,-12.48 1.5,-3.23 17.98,-9.5 2.4,-2.55 7.04,-3.99 1.56,-1.69 0.73,-1.11 4.32,0.76 36.34,15.66 z\"\r\n                        title=\"Kerman\" />\r\n                    <path\r\n                        d=\"m 596.00043,349.9544 0,0 1.86,0.27 0.88,0.35 0.66,0.53 1.21,1.54 0.24,0.74 -0.24,1.7 0.02,0.79 0.32,0.8 0.91,1.51 0.29,0.89 0.05,1.16 0.09,0.41 0.59,1.26 0.41,1.29 0.17,0.78 0,0.78 -0.24,0.83 -0.65,1.29 0.15,0.46 0.13,2.69 -0.2,0.12 -0.09,0.27 -0.05,0.72 0.05,0.04 0.08,0.21 -0.58,0.62 -2.79,3.38 -4.28,5.18 -3.88,4.7 0,0 -2.76,3.31 -3.66,4.39 -1.91,2.3 -2.8,3.35 -5.24,6.25 -0.01,0.01 -2.57,3.02 -1.96,2.3 2.74,3.24 1.79,2.13 2.21,2.65 2.55,3.06 2.65,3.18 2.79,3.33 0.66,0.54 0.71,0.29 0.6,0.42 0.31,0.99 -0.06,0.76 -0.41,1.36 0,0.76 0.33,0.79 1.07,1.19 0.44,0.67 0.1,0.43 0.09,0.97 0.18,0.44 0.36,0.41 0.31,0.11 0.31,0.04 0.37,0.2 0.34,0.55 0.18,0.66 0.26,0.56 0.58,0.25 0.33,0.26 0.1,0.34 -0.12,0.35 -0.31,0.33 -0.24,0.25 -0.1,0.24 0.08,0.22 0.26,0.21 0.44,0.2 0.38,0.3 0.3,0.4 1.43,3.3 0.19,0.75 0.08,0.65 0.18,0.58 0.97,1.09 0.97,2.13 0.99,1.21 3.49,3.18 1.41,1.83 2.15,2 1.07,1.24 0.62,0.34 2.03,0.57 1.62,0.93 1.02,0.33 2.25,0.19 1.08,0.23 2.82,1.27 4.47,0.9 0.94,0.49 0.4,0.47 0.29,0.51 0.34,0.47 0.55,0.31 0.57,0.19 0.35,0.22 0.24,0.39 0.22,0.67 0.49,0.83 2.14,2.32 0.68,0.44 5.54,-1.13 0.76,0.46 0.16,1.34 -0.5,3.95 -0.54,4.36 0.63,2.65 0.88,3.69 0.21,2.27 0.28,3.09 0.17,1.92 0.33,3.53 0.18,1.99 -0.21,1.58 -1.78,4.02 0.67,0.81 0.16,0.41 -0.06,0.62 -0.16,0.54 -0.2,0.43 -0.33,0.25 -0.54,0.04 1.46,1.3 0.51,0.28 0.27,0 0.47,-0.28 0.23,-0.04 0.28,0.09 0.79,0.44 1.07,0.24 0.92,-0.05 1.97,-0.4 0.88,-0.13 1.78,-0.55 0.9,-0.05 0.56,0.06 0.44,-0.01 1.85,-0.59 0.34,0.01 0.42,0.15 0.88,0.81 0.38,0.23 0.84,0.31 0.31,0.2 0.36,0.39 0.48,0.72 1.16,2.56 -0.59,-0.23 -0.74,0 -0.66,0.29 -0.37,0.62 -0.13,0.38 -0.36,0.52 -0.14,0.38 -0.05,0.44 0.17,4.3 0.31,0.71 0.42,0.62 0.28,0.61 -0.11,0.69 -0.5,0.46 -1.38,0.23 -0.56,0.29 -0.24,0.6 -0.27,5.5 -0.36,1.52 -0.76,0.74 -0.34,-0.01 -0.27,-0.14 -0.24,-0.17 -0.29,-0.14 -0.33,-0.03 -0.98,0.22 -1.34,-0.03 -1.32,-0.21 -3.06,-0.07 -2.66,-0.07 -2.3,-0.06 -0.37,0.11 -0.26,0.35 -0.35,0.64 -0.23,0.18 -0.25,0.13 -0.29,0.11 -1.05,0.24 -0.29,-0.02 -0.37,-0.18 -0.37,-0.08 -0.29,0.18 -0.27,0.28 -0.28,0.22 -0.69,0.25 -5.67,0.6 -0.32,0.09 -0.27,0.21 -0.27,0.49 -0.2,0.18 -0.35,0.1 -0.71,-0.04 -0.32,0.04 -0.28,0.12 -0.44,0.32 -0.27,0.16 -0.67,0.26 -0.29,0.19 -0.21,0.29 -0.07,0.33 0.11,0.25 0.12,0.21 0.04,0.23 -0.35,0.66 -1.07,1.05 -0.24,0.47 0.19,0.87 0.33,0.69 0.03,0.54 -0.74,0.39 -1.27,-0.18 -1.5,-0.53 -1.28,-0.17 -0.57,0.92 -0.12,0.92 -0.31,0.39 -1.4,0.24 -0.7,0.21 -0.63,0.32 -1.22,0.81 -4.08,1.16 -0.82,0.64 -0.49,1.02 -0.29,1.17 -0.31,2.29 -0.27,2.03 -0.32,2.34 -0.43,3.14 -0.36,2.63 -0.19,0.66 -0.51,0.63 -0.59,0.13 -0.65,-0.01 -0.72,0.17 -0.71,0.99 0.16,1.38 0.38,1.49 -0.1,1.3 -0.21,0.29 -0.5,0.5 -0.2,0.36 -0.11,0.54 -0.14,2.19 -0.21,3.21 -0.24,3.73 -0.2,3.16 -1.07,3.12 -0.01,0 -0.21,-0.54 -0.07,-0.63 -0.59,-0.43 -0.11,-0.23 -0.16,-0.11 -0.33,0.22 -0.1,0.21 -0.05,0.6 -0.1,0.23 0.19,0.18 0.33,0.39 0.19,0.17 -0.72,-0.08 -0.55,-0.22 -0.56,-0.01 -0.73,0.57 0.8,0.26 0.33,0.18 0.27,0.33 -0.18,0.36 -0.53,0.68 -0.15,0.4 0,0.19 -0.04,0.15 -0.27,0.26 -0.49,0.26 -1.84,0.55 0.49,0.34 -0.79,1.06 -5.7,-1.96 -1.98,-0.43 0.01,-0.61 -0.51,-0.93 -4.73,-1.69 -5.55,-0.93 -4.71,-1.12 -3.19,-0.39 -0.56,-0.31 0.52,-0.49 -0.82,-1.18 -0.1,-0.5 -0.01,-2.1 -0.11,-0.33 -1.23,-1.23 -0.53,-0.31 -0.59,-0.07 -0.61,0.06 -2.32,0.71 -0.58,0.33 -0.32,0.51 -0.53,0.64 -0.28,0.41 0,0.25 0.1,0.23 0.13,0.76 0.17,0.11 0.23,0.02 0.38,0.19 0.29,-0.01 0.14,0.1 0.14,0.23 0.35,0.39 -0.37,-0.06 0,0.09 0.98,0.5 -0.1,0.48 -0.39,-0.09 -1.09,-0.46 -1.38,-0.57 -0.68,-0.39 -1.47,0.03 -0.98,-0.8 0.32,-0.6 0.14,-0.15 -0.49,-0.22 -0.62,-0.09 -1.22,0.06 -0.94,0.18 -0.2,0.07 -0.3,0.35 0,0.21 0.09,0.19 0.7,0.48 -0.23,0.7 -0.92,-0.01 -0.68,-0.45 -0.37,-0.12 -1.16,-0.17 -0.26,-0.2 -0.38,-0.49 -0.53,-0.29 -1.25,0.08 -1.72,0.26 -1.82,0.07 -1.25,0.94 -1.42,-0.49 -1.42,-1.36 -1.53,-0.4 -3.91,0.24 -1.53,-0.01 -2.58,-0.6 -1.61,-1.64 -1.23,-0.68 -1.92,0.37 -4,0.64 -0.95,0.15 -0.15,-0.89 0.89,-0.39 0.02,-0.57 0.09,-0.6 -0.63,-0.31 -0.28,-0.37 -1.2,-2.05 -0.56,-0.56 -0.46,-0.6 -0.23,-0.77 -0.55,-0.68 -1.02,-0.39 -0.75,-0.76 -0.18,-1.36 -1.09,-1.8 -6.42,-5.68 -1.21,-0.76 -0.46,-0.2 -0.13,-0.68 0.16,-1.21 0.61,-0.93 0.41,-0.22 0.67,-1.65 0.2,-1.4 -0.02,-2.33 0.41,-0.98 0.46,-0.61 -0.06,-1.23 0.64,-0.78 0.54,-1.45 -0.29,-1.45 -1.17,-1.39 -0.63,-2.2 0.84,-1.74 1.09,-1.3 -0.04,-1.29 -1.08,-0.99 -0.55,-0.87 0.95,-1.63 0.96,-2.88 -1.78,-3.63 -2.58,-2.97 -0.7,-2.59 0.1,-2.44 -0.12,-1.42 -0.82,-3.2 -0.01,-3.77 3.9,-15.31 0.45,-4.38 -0.23,-13.28 3.91,-5.11 1.05,-3.48 -1.21,-1.95 -2.78,-2.11 -1.26,-1.95 1.96,-1.05 3.85,-1.31 7.88,-4.59 1.53,-1.2 0.99,-1.08 0.06,-1.43 -0.35,-1.5 -1,-2.09 -0.04,-3.17 -0.49,-2.57 0.49,-2.5 2.84,-4.34 1.03,-3.84 0.1,-3.39 -1.17,-8.21 -1.35,-3.42 -1.53,-1.01 -0.8,-0.85 0.3,-3.24 6.95,-32.33 1.06,-0.51 25.41,-7.22 1.85,0.33 1.19,1.27 0.77,0.62 3.14,0.86 4.17,3.08 5.33,7.61 2.78,2.38 4.6,-0.16 1.15,-0.45 0.53,-0.82 0.06,-1.22 -1.72,-7.64 -0.14,-3 0.7,-10.31 1.61,-5.8 2.17,-5.22 0.47,-4.78 -0.62,-2.31 5.75,0.85 6.64,0.97 3.9,0.57 z\"\r\n                        title=\"Sistan and Baluchestan\" />\r\n                    <path\r\n                        d=\"m 456.82043,80.6944 0,0 0.54,-0.08 0.52,-0.16 0.58,-0.09 0.57,0.07 1.72,0.5 1.65,-0.03 0.51,-0.13 0.51,0 0.46,0.29 0.42,0.37 0.43,0.27 0.17,0.02 -4.11,2.54 -1.28,1.3 0.01,1.87 -0.39,1.59 -0.55,1.48 1.29,0.93 15.19,0.72 0.64,0.8 0.43,1.46 0.78,1.78 3.07,2.88 0.93,1.91 0.21,1.71 -0.75,1.37 -0.89,1.1 -0.31,0.74 -0.03,0.85 -0.34,1.26 -1.22,1.71 -2.03,6.01 -1.38,1.71 0.16,1.48 1.66,1.15 0.94,1.04 0.61,1.19 0.9,-0.14 0.49,-1.28 0.44,-0.2 0.29,1.09 0.68,1.04 1.12,0.54 0.13,0.98 -2.01,2.17 -0.22,1.18 0.44,0.67 1.21,0.72 0.28,1.32 -1.13,3.3 -1.27,1.2 -2.56,0.63 -9.38,-1.44 -22.43,-12.47 -5.4,-0.26 -8.16,6.63 -1.95,2.61 -0.27,1.92 0.26,1.5 -0.11,1.15 -5.16,0.87 -1.68,-0.65 -3.23,-0.55 -1.9,-0.64 -3.85,-3.31 -4.01,-4.51 -0.63,-1.34 0.12,-0.85 0.64,-2.53 0.17,-2.88 -0.17,-1.12 -0.21,-0.45 -0.22,-0.34 0.21,-0.63 0.87,-0.7 1.98,-0.59 0.35,-0.97 -1.65,-0.69 -1.33,0.23 -2.41,-1.7 -5.12,-6.83 1.03,-1 2.47,-4.4 2.46,-1.02 1.03,-0.95 1.02,-0.46 0.91,-0.14 3.97,-1.38 1.86,-2.6 -0.63,-2.61 -1.38,-1.06 -1.6,-0.79 -1.15,-1.37 -0.07,-1.94 0.69,-2.77 0.03,-1.02 -0.41,-1.8 -0.09,-1.56 0.22,-1.22 -0.22,-3.01 1.05,0.43 0.55,0.08 2.9,-0.49 0.53,-0.4 0.34,-0.67 0.12,-0.8 -0.16,-0.75 -0.92,-1.06 0.21,-0.59 2.14,-1.99 1.14,-0.8 1.23,-0.47 3.11,-0.1 0.57,0.14 0.48,0.29 0.42,0.34 0.46,0.21 0.54,-0.1 2.72,-1.19 1.62,-0.28 0.33,0.06 1.32,1.09 1.16,0.67 0.53,0.17 5.09,0.96 1.35,0.55 0.69,0.11 0.61,-0.34 0.47,-0.42 1.1,-0.74 0.4,-0.43 0.68,-1.19 0.1,-0.12 0.3,-0.32 0.59,-0.28 0.37,-0.05 0.37,0.05 0.72,0.24 0.38,0.25 0.09,0.28 0.02,0.32 0.14,0.38 0.78,1.33 0.61,1.49 0.4,0.6 1.11,1.2 0.39,1.29 0.73,1.03 0.16,0.76 -0.08,0.71 -0.67,2.27 0.86,1.15 4.87,1.94 z\"\r\n                        title=\"North Khorasan\" />\r\n                    <path\r\n                        d=\"m 467.11043,83.0344 0,0 0.55,-0.04 0.57,-0.13 0.55,-0.05 1.18,0.32 5.31,2.56 2.23,0.53 1.14,0.09 0.55,0.13 0.57,0.28 0.25,0.29 0.01,0.3 -0.08,0.3 0.03,0.34 0.54,1 0.12,0.32 0.08,0.78 0.01,0.59 0.16,0.49 0.58,0.48 0.58,0.22 2.64,0.4 0.42,0.2 0.9,0.64 0.47,0.13 3.07,-0.31 0.58,-0.28 0.46,-0.71 0.31,-0.72 0.41,-0.6 0.52,-0.38 0.66,-0.05 0.56,0.29 1.7,1.51 1.46,0.6 0.77,0.12 0.76,-0.08 0.29,-0.18 0.22,-0.26 0.24,-0.2 0.38,0 0.72,0.14 0.35,-0.03 0.36,-0.12 0.45,-0.56 0.08,-0.64 0.19,-0.29 2.03,1.13 2.63,0.61 1.33,0.61 0.48,0.35 0.45,0.15 0.98,0.15 0.38,0.2 1.11,1.15 4.51,3.27 0.73,0.07 1.9,-0.88 0.78,0.21 0.68,0.65 0.65,0.91 0.16,0.56 -0.1,0.95 0.2,0.46 0.09,0.36 -0.14,0.38 -0.21,0.42 -0.11,0.47 0.08,0.9 0.67,2.93 0.39,0.59 2.12,1.77 0.64,0.71 0.2,0.28 -0.04,0.21 -0.13,0.14 -0.04,0.12 -0.05,0.29 -0.1,0.35 0.1,0.3 0.56,0.15 0.22,0.23 0.27,0.22 0.29,0.14 0.28,0.02 1.07,-0.43 0.5,0.09 0.57,0.61 0.24,0.66 0.16,0.81 0.24,0.7 0.45,0.36 0.32,-0.07 0.24,-0.25 0.4,-0.63 0.32,-0.17 0.36,0.02 4.87,1.6 2.22,1.88 1.25,0.73 2.78,0.5 1.27,0.55 1,1.35 1.27,2.71 1.57,2.4 3.59,4.39 0.71,1.15 0.98,2.59 0.7,1.23 1.12,0.63 5.38,-0.1 4.74,-0.09 7.22,-0.13 4.02,-0.07 3.47,-0.06 1.68,0.29 1.38,0.19 0.28,1.44 0.28,0.65 0.12,0.39 0.06,0.53 -0.05,0.51 -0.13,0.47 -0.19,0.41 -0.21,0.32 -0.14,0.45 0.05,0.5 0.21,0.63 -0.73,3.39 -0.2,2.07 0.48,1.2 -0.1,0.17 -0.06,0.12 -0.09,0.29 0.33,0.14 0.27,0.21 0.21,0.26 0.14,0.25 0.13,0.44 0.06,0.44 0.02,0.97 0.11,0.41 0.49,0.82 0.51,2.61 0.09,1.26 0.05,0.21 -0.06,0.26 -0.36,0.47 -0.17,0.29 -0.1,0.37 -0.06,0.41 -0.02,0.39 -0.13,0.45 -0.28,0.21 -0.32,0.13 -0.21,0.19 -0.1,0.51 0.12,0.84 -0.02,0.39 -0.42,0.45 -0.69,0.56 -0.39,0.5 0.47,0.21 0.83,0.13 0.68,0.37 0.59,0.55 0.55,0.66 0.35,0.58 0.3,0.71 0.21,0.73 0.15,1.5 0.13,0.63 0.02,0.68 -0.22,0.93 0.22,0.31 0,0.41 -0.22,0.99 -0.02,0.23 0.02,0.74 -0.1,0.29 -0.46,0.46 -0.14,0.25 0.09,1.11 0.46,0.94 0.83,1.29 0.24,0.38 0.36,1.71 0.09,0.84 -0.21,0.86 -0.46,0.79 -0.79,0.97 -0.37,0.8 -0.3,1.3 -0.18,0.43 -0.71,0.96 -0.2,0.46 -0.16,0.85 0.16,2.14 -0.27,0.73 -0.65,0.38 -0.81,0.13 -0.72,0.02 -0.49,0.4 -0.2,0.89 -0.02,0.88 0.02,0.4 0.19,0.18 0.16,0.4 -0.01,0.4 -0.34,0.18 -0.2,0.19 0.17,0.41 1.21,1.63 0.09,0.18 -0.07,0.47 -0.09,0.36 0.06,0.34 0.35,0.38 -0.82,1.16 -0.24,0.59 -0.2,1.71 -0.5,1.55 -0.11,0.81 -0.11,0.39 -0.47,0.78 -0.11,0.52 0.03,0.42 0.15,0.77 0.03,0.36 -0.15,1.45 -0.27,1.37 -1.04,0.34 -0.19,0.69 -0.66,1.18 -1.07,0.84 -0.61,0.72 -0.05,0.97 0.12,1.06 -0.14,1.01 -0.35,0.47 -0.4,0.09 -0.44,-0.03 -0.47,0.07 -0.46,0.26 -0.22,0.28 -0.17,0.33 -1.54,1.76 -0.66,0.45 -0.84,0.24 -1.86,0.25 -0.84,0.43 -0.5,0.87 0.36,0.05 0.29,0.16 0.22,0.29 0.29,0.98 0.3,0.28 0.83,0.38 0.41,0.38 0.33,0.47 0.54,1.07 2.51,3.28 0.38,0.77 -2.52,0.14 -3.44,0.22 -2.39,0.14 0.23,0.87 -0.53,0.58 -1.61,0.86 -1.18,1.24 -1.07,1.39 -0.95,1.92 -0.21,1.83 0.06,0.55 -0.01,0 -2.64,0.45 -21.07,0.06 -4.45,-1.58 -3.32,-5.44 -1.82,-1.56 -3.53,1.32 -3.14,1.81 -10.05,1.49 -0.97,1.08 -0.92,0.67 -3.48,-1.06 -5.39,-0.69 -1.82,0.7 -0.49,1.17 0.19,1.07 1.32,2.14 -0.32,2.71 -0.71,3 0.36,1.8 -0.13,1.62 -0.87,2.09 -0.51,2.31 0.16,1.74 0.95,0.92 0.79,0.58 0.35,0.96 0.29,1.17 5.13,3.75 -1.01,1.87 -0.2,1.16 -1.69,2.71 -1.51,1.54 -10.64,7.07 -4.7,7.14 -1.12,4.78 -1.45,2.49 -0.85,1.02 -0.89,-0.64 -2.74,-4.3 -2.87,-1.8 -2.19,-0.99 -0.81,-0.63 -2.88,-1.65 -2.2,-5.05 -2.53,-17.12 -1.34,-2.59 -1.45,-1.85 -8.66,2.02 -6.72,-0.81 -1.59,-2.51 -2.11,-11.75 0.28,-6.91 4.26,-12.86 2.31,-4.17 13.42,-9.52 3.28,-3.22 0.46,-2.64 -1.16,-2.61 -9.88,-7.59 -3.77,-0.99 -8.52,2.2 -13.46,6.4 -13.84,3.62 5.44,-6.75 4.37,-4 3.85,-2.3 7.15,-2.69 1.03,-0.81 1.44,-3.35 5.89,-10.15 0.52,-2.91 -2.22,-2.56 -8.03,-6.57 -0.92,-2.35 -1.1,-5.06 -0.64,-7.87 0.5,-4.58 1.37,-2.62 0.91,-3.93 -0.83,-3.32 -1.37,-0.82 -1.08,-0.04 -0.67,0.19 0.11,-1.15 -0.26,-1.5 0.27,-1.92 1.95,-2.61 8.16,-6.63 5.4,0.26 22.43,12.47 9.38,1.44 2.56,-0.63 1.27,-1.2 1.13,-3.3 -0.28,-1.32 -1.21,-0.72 -0.44,-0.67 0.22,-1.18 2.01,-2.17 -0.13,-0.98 -1.12,-0.54 -0.68,-1.04 -0.29,-1.09 -0.44,0.2 -0.49,1.28 -0.9,0.14 -0.61,-1.19 -0.94,-1.04 -1.66,-1.15 -0.16,-1.48 1.38,-1.71 2.03,-6.01 1.22,-1.71 0.34,-1.26 0.03,-0.85 0.31,-0.74 0.89,-1.1 0.75,-1.37 -0.21,-1.71 -0.93,-1.91 -3.07,-2.88 -0.78,-1.78 -0.43,-1.46 -0.64,-0.8 -15.19,-0.72 -1.29,-0.93 0.55,-1.48 0.39,-1.59 -0.01,-1.87 1.28,-1.3 4.11,-2.54 0.12,0.01 0.55,-0.13 0.28,0.07 0.24,0.24 0.31,0.65 0.2,0.26 0.51,0.21 z\"\r\n                        title=\"Razavi Khorasan\" />\r\n                    <path\r\n                        d=\"m 534.43043,242.0644 0,0 21.07,-0.06 2.64,-0.45 0.01,0 0.37,3.54 0.97,6.24 -0.07,1.6 -1.05,2.36 -0.27,1.34 0.84,2.97 2.14,2.05 2.73,1.14 2.65,0.2 2.49,-0.13 1.31,0.1 1.14,0.28 0.52,0.31 0.57,0.52 0.3,0.58 -0.03,0.06 -0.26,0.45 -0.5,0.18 -1.61,0.11 -0.6,0.4 -0.1,0.58 0.12,0.68 0.06,0.7 -0.18,0.81 -0.36,0.46 -1.11,0.7 -0.97,0.87 -1.29,1.75 -1.65,2.24 -1.84,2.49 -1.64,2.22 -0.21,0.57 0.05,3.2 0.5,2.58 0.97,3.31 1.14,3.9 1.18,4.02 1.25,4.24 1.38,4.65 1.49,5.56 1.15,4.29 -0.07,3.26 -0.46,3.18 -0.2,0.67 -0.89,1.14 -0.26,0.62 0.12,0.24 0.28,0.17 0.2,0.22 -0.29,0.88 0.07,0.41 0.17,0.39 0.13,0.43 0.06,0.87 -0.25,2.46 0.07,1.93 0.47,3.69 -0.43,2.94 0.08,0.93 0.51,1.92 0.4,3.73 1.12,0.47 3.42,0.5 5.68,0.84 0.05,0 0.62,2.31 -0.47,4.78 -2.17,5.22 -1.61,5.8 -0.7,10.31 0.14,3 1.72,7.64 -0.06,1.22 -0.53,0.82 -1.15,0.45 -4.6,0.16 -2.78,-2.38 -5.33,-7.61 -4.17,-3.08 -3.14,-0.86 -0.77,-0.62 -1.19,-1.27 -1.85,-0.33 -25.41,7.22 -1.06,0.51 -13.52,-19.71 -4.85,-3.63 -38.55,-17.43 0.48,-0.78 1.77,-4.57 3.48,-5.4 1.25,-3.49 4.51,-6.05 0.56,-1.87 0.3,-1.97 0.77,-2.23 0.08,-2.2 -1.36,-2.25 -1.03,-2.25 -0.06,-1.21 -0.99,-1.13 -0.52,-0.93 -0.24,-0.89 0.58,-1.44 0.91,-1.48 0.28,-1.25 -0.17,-3.08 0.85,-1.02 1.45,-2.49 1.12,-4.78 4.7,-7.14 10.64,-7.07 1.51,-1.54 1.69,-2.71 0.2,-1.16 1.01,-1.87 -5.13,-3.75 -0.29,-1.17 -0.35,-0.96 -0.79,-0.58 -0.95,-0.92 -0.16,-1.74 0.51,-2.31 0.87,-2.09 0.13,-1.62 -0.36,-1.8 0.71,-3 0.32,-2.71 -1.32,-2.14 -0.19,-1.07 0.49,-1.17 1.82,-0.7 5.39,0.69 3.48,1.06 0.92,-0.67 0.97,-1.08 10.05,-1.49 3.14,-1.81 3.53,-1.32 1.82,1.56 3.32,5.44 4.45,1.58 z\"\r\n                        title=\"South Khorasan\" />\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 -4.99,-2.73 -1.22,0.34 0.6,1.67 1,1.3 0.4,0.89 -0.01,1.05 -2.41,0.82 -0.97,0.95 -1.11,0.5 -1.05,-0.29 -1.6,-3.33 -0.78,0.08 -1.77,1.99 -0.53,1.05 2.36,3.5 3.65,8.17 1.66,2.03 1.39,0.87 1.93,1.92 0.93,3.83 -0.67,3.09 -1.19,1.91 -1.13,0.99 -0.73,-0.39 -1.09,-2.68 -0.63,0.16 -0.38,1.16 -1.23,0.67 -2.08,0.59 -1.03,0.56 -1.05,0.04 -1.46,-0.22 -5.2,-5.88 -3.88,-1.76 -1.33,-1.15 -0.99,-0.08 -0.36,0.79 0.61,1.23 -0.11,1.4 -1.16,1.07 -4.85,0.32 -0.35,0.8 -0.21,2.69 -0.68,0.39 -1.33,-0.09 -2.11,0.21 -2.04,2.13 -1.42,0.48 -0.44,0.91 0,1.19 -0.72,0.83 -1.11,0.18 -0.66,0.89 -0.16,1.36 -1.3,0.69 -2.29,0.33 -3.06,-0.36 -2.03,0.22 -1.12,-1.23 -0.04,-1.63 0.27,-1.21 -0.14,-0.87 -0.77,0.06 -1.45,-1.01 -8.14,-11.14 -6.44,-5.08 -0.94,-0.32 0.08,-0.17 -0.25,-1.22 -0.81,-0.94 -1.87,-1.68 -2.17,-3.48 -0.44,-1.2 -0.01,-0.38 0.08,-0.34 0.18,-0.27 0.27,-0.21 0.13,-0.16 0.05,-0.17 -0.05,-0.18 -0.13,-0.17 -0.38,-0.79 -0.3,-0.85 0.16,-0.04 0.16,0 1.04,0.32 0.09,-0.58 -0.33,-1.6 0,-0.69 0.12,-0.73 0.27,-0.66 0.43,-0.47 0.7,-0.25 2.37,0.07 0.69,-0.16 1.7,-0.9 1.33,0.07 0.71,-0.08 0.53,-0.51 0.46,-0.68 1.03,-0.66 0.53,-0.48 0.4,-0.69 0.07,-0.65 -0.25,-0.56 -0.57,-0.4 -0.73,-0.07 -0.6,0.3 -0.58,0.4 -0.65,0.24 -1.43,0.31 -0.73,0.03 -0.68,-0.29 -0.28,-0.23 -0.21,-0.23 -0.14,-0.29 -0.17,-0.85 -0.16,-0.15 -0.25,-0.04 -1.04,-0.4 -0.56,-0.01 -0.55,0.2 -0.65,0.38 -0.68,0.22 -2.16,-0.1 -1.09,0.38 -0.35,-0.04 -0.34,-0.11 -0.35,-0.01 -0.82,0.7 -0.65,0.33 -0.7,0.05 -0.55,-0.38 -0.38,-0.08 -1.28,0.39 -0.61,-0.17 -0.41,-0.55 -0.87,-2.16 -1.57,-2.23 -1.01,-0.93 -0.92,-0.17 -0.44,-0.28 -1.25,-1.16 -1.3,-0.48 0,0 0.02,-0.02 1.14,-0.7 1.33,-1.33 0.56,-1.37 1.88,-2.14 0.46,-2.04 0.75,-0.77 0.39,-0.67 1.02,-1.11 5.51,-1.78 1.63,-2.48 0.05,-2.03 0.75,-0.97 2.96,-1.18 8.52,1.22 17.52,-1.62 0.4,0.33 0.24,0.51 0.48,0.64 0.68,0.57 0.58,0.64 1.3,0.9 3.51,0.97 3.84,0.34 2.56,-1.13 1.43,-1.66 0.58,-1.16 0.18,-0.66 -0.24,-0.69 0.14,-0.83 1,-0.61 0.83,-0.26 0.98,0.99 17.06,3.4 0.12,0.18 1.07,1.19 0.23,0.45 0.13,0.81 0.33,0.94 0.38,0.82 0.32,0.47 -0.35,0.33 -0.07,0.37 0.21,1.02 -0.05,0.29 -0.14,0.26 -0.11,0.28 0.04,0.31 0.14,0.06 0.59,0.07 0.64,2.37 0,4.26 -0.75,3.07 -1.33,1.4 -0.56,1.51 0.47,1.11 9.32,5.68 0.62,0.58 0.67,1.14 0.3,0.9 z\"\r\n                        title=\"Kordestan\" />\r\n                    <path\r\n                        d=\"m 164.84043,58.6444 0,0 0.1,3.8 -0.39,1.26 0.24,0.92 0.07,2.28 0.64,1.59 0.47,5.27 1.4,5.01 -0.27,0.83 -0.03,0.97 0.15,0.93 0.26,0.66 1.19,1.95 0.01,0.45 -0.1,0.38 -0.05,0.31 0.35,1.68 0.71,1.61 1.71,2.58 2.28,2.38 2.48,1.78 5.46,2.85 2.54,0.85 13.01,1.77 1.4,-0.22 1.16,-0.47 1.09,-0.2 1.21,0.62 -0.32,0.06 -0.38,-0.11 -0.2,-0.03 -0.26,0.35 2.82,1.1 4.41,1.02 1.59,0.61 1.07,1.02 -0.14,1.54 0.3,0.59 0.44,1.54 0.31,0.62 0.49,0.76 0.8,2.3 1.01,1.68 1.19,1.14 2.44,1.85 1.68,2.03 0.51,0.31 0.66,0.19 2.13,1.45 0,0 -0.02,0.14 -0.33,1.08 -1.16,1.6 -1.76,0.95 -1.36,1.35 -0.74,3.51 -2.08,3.71 -1.76,1.15 -4.6,-0.46 -2.81,0.63 -0.75,0.4 -0.7,0.24 -6.36,3.46 -1.68,0.3 -3.13,-0.63 -0.73,-0.5 -1.04,-0.18 -1.73,0.07 -4.65,-1.39 -2.06,-1.94 -1.91,-2.43 -0.43,-1.35 -0.06,-0.71 -3.21,-1.55 -2,-6.96 -1.44,-2.33 -3.76,-3.97 -5.1,-3.26 -0.37,-1.05 -0.29,-2.23 0.15,-1.86 -0.03,-1.22 -1.14,-1.45 -2.16,-1.71 -1.87,-1.93 -5.62,-8.86 -3.11,-8.63 0.07,-2.35 1.08,-1.68 0.3,-2.28 0.7,-1.66 7.65,-9.11 0.3,-0.79 -0.52,-0.56 -1.28,-0.29 -0.82,-0.33 -0.19,-0.81 -0.7,-0.92 -1.08,-0.96 -0.2,-0.45 1.56,0.13 0.82,-0.23 0.91,-0.39 0.86,-0.54 0.67,-0.68 0.76,-0.41 1.08,0 2.19,0.46 z\"\r\n                        title=\"Gilan\" />\r\n                    <path\r\n                        d=\"m 88.71043,209.5144 0,0 0.77,-0.06 0.14,0.87 -0.27,1.21 0.04,1.63 1.12,1.23 2.03,-0.22 3.06,0.36 2.29,-0.33 1.3,-0.69 0.16,-1.36 0.66,-0.89 1.11,-0.18 0.72,-0.83 0,-1.19 0.44,-0.91 1.42,-0.48 2.04,-2.13 2.11,-0.21 1.33,0.09 0.68,-0.39 0.21,-2.69 0.35,-0.8 4.85,-0.32 1.16,-1.07 0.11,-1.4 -0.61,-1.23 0.36,-0.79 0.99,0.08 1.33,1.15 3.88,1.76 5.2,5.88 1.46,0.22 1.05,-0.04 0.02,0.63 -0.18,1.15 -1.12,1.29 -1.34,3.02 -1.59,2.35 -3.39,0.39 -1.08,0.43 -0.49,0.64 0.33,1.64 1.72,1.4 2.49,1.36 1.11,0.22 0.92,0.49 0.5,1.7 0.86,1.31 2.89,-3.02 1.56,-0.69 0.78,-0.17 0.65,0.99 0.34,1.67 -0.37,2.72 0.08,1.91 -1.03,0.85 -3.8,-0.81 -3.36,0.24 -1.24,1.9 -0.59,1.15 -2.33,-0.31 -0.98,0.26 -0.65,0.43 -0.11,0.92 0.31,2.21 -0.19,2.3 -1.64,0.85 -2.42,0.12 -1.96,0.97 -0.2,0.58 0.08,0.4 0.21,0.27 0.23,0.25 0.17,0.33 0.06,0.47 -0.1,0.76 0.04,0.44 0.13,0.31 -0.49,0.79 -0.59,0.42 -0.56,-0.17 -1.15,-0.1 -5.43,1.26 0,1.25 0.93,1.39 0.5,1.03 -0.47,2.64 -0.71,1.39 -5.31,-0.24 -5.76,1.47 -3.96,-0.32 -8.5,-2.75 -2.49,-2.16 -2.27,-1.4 -2.74,-0.63 -2.73,-0.2 -5.07,-2.08 -5.25,0.66 -2,-0.06 -0.62,0.73 0.47,1.56 -0.37,2.63 -1.29,4.06 -0.72,5.9 -0.76,0.64 -0.12,-0.31 -1.6,-1.15 -0.51,-0.51 -0.47,-0.67 -0.33,-0.66 -0.24,-0.72 -0.14,-0.82 -0.25,-0.68 -0.44,-0.49 -0.52,-0.44 -0.46,-0.5 -3.01,-5.5 -0.07,-0.06 -0.07,-0.03 -0.08,-0.01 -1,0.15 -0.88,-0.05 -0.77,-0.44 -0.7,-0.98 0.72,-0.33 0.33,-0.23 0.28,-0.29 0.01,0 0,0 0.51,-1.14 0.29,-1.04 0.38,-0.91 0.83,-0.72 0.49,-0.54 1.37,-1.12 0.35,-0.47 0,-0.45 -0.2,-0.35 -0.25,-0.36 -0.16,-0.47 0.07,-0.37 0.48,-0.78 0.16,-0.37 0.46,-1.97 0.06,-1.01 -0.18,-0.93 -0.52,-0.8 -0.7,-0.45 -0.76,0 -0.67,0.55 -0.63,-0.47 -0.43,-0.89 -1.05,-3.37 0.33,-0.54 1.78,-0.4 0.24,-0.23 0.22,-0.26 0.2,-0.29 0.16,-0.33 0.04,-1.22 -0.28,-1.66 0.14,-1.13 1.32,0.39 1.16,0.62 1.05,0.25 2.33,0.18 0.74,0.27 0.2,-0.05 0.14,-0.26 0.09,-0.44 0.01,-0.44 -0.1,-0.27 -0.38,-0.53 -0.1,-0.7 -0.02,-0.77 -0.11,-0.78 -0.14,-0.29 -0.17,-0.2 -0.17,-0.25 -0.1,-0.44 -0.12,-0.33 -0.25,-0.3 -0.3,-0.24 -0.28,-0.16 -0.51,-0.57 0.26,-0.67 0.94,-1.08 0.11,-0.48 -0.08,-0.83 0.11,-0.49 0.33,-0.47 0.43,-0.18 0.96,-0.1 0.94,-0.66 0.17,-1 -0.07,-1.05 0.23,-0.8 0.78,-0.03 0.61,0.32 0.4,0.21 0.91,0.32 0.52,-0.69 0.26,-1.01 0.28,-0.75 0.09,-0.78 -0.31,-1.07 0,0 -0.1,-0.57 0.01,-0.55 0.16,-0.47 0.36,-0.36 0.23,-0.07 0.47,-0.05 0.2,-0.11 0.07,-0.19 -0.09,-0.51 0.03,-0.19 0.47,-0.78 0.24,-0.09 0.5,0.17 0.71,0.46 0.35,0.15 0.44,-0.04 1.01,0.45 0.54,-0.14 0.5,-0.47 0.91,-0.55 0.34,-0.04 0.6,0.16 0.86,-0.28 0.42,-0.09 0.37,-0.19 0.27,-0.5 -0.7,-0.82 0.45,-1.17 0.74,-1.26 0.12,-1.09 -0.51,-0.43 -1.31,0.01 -0.47,-0.33 -0.09,-0.65 0.3,-0.53 0.42,-0.5 0.17,-0.42 0.94,0.32 6.44,5.08 8.14,11.14 1.45,1.01 z\"\r\n                        title=\"Kermanshah\" />\r\n                    <path\r\n                        d=\"m 95.95043,37.9044 0,0 -1.57,-1.29 -0.7,0.05 -0.09,0.66 -0.02,1.27 -0.23,1.21 -0.46,0.41 -1.81,-0.44 -1.26,0.14 -0.34,0.62 -0.91,0.53 -1.36,1.8 -0.54,2.71 0.96,2.37 1.73,0.95 2.32,-0.83 2.32,-1.26 2.22,-0.63 5.07,1.44 1.42,-1.15 1.28,-1.75 2.12,-1.6 0.42,-0.55 -0.51,-0.19 -0.46,-0.71 3.88,-6.77 2.55,-1.73 1.38,0.12 2.28,-1.37 2.19,-1.96 1.34,0.5 -0.47,4.96 0.52,0.76 0.09,3.28 1.96,4.9 -0.36,2.9 -1.25,1.69 0.02,1.21 1.78,1.01 0.64,2.12 -1.65,1.13 -2.43,-0.39 -2.3,0.68 -1.42,1.54 -2.71,1.98 -1.07,2.01 -0.86,1.12 -0.69,1.58 -0.16,2.21 0.4,1.34 1.63,-0.64 2.16,-0.26 1.07,1.04 0.47,0.35 0.99,0.18 7.61,-1.12 2.36,1.18 1.01,3.16 0.21,3.42 1.71,4.24 2.67,3.66 2.27,2.09 0.35,0.77 -0.34,1.19 -0.77,1.63 -0.3,3.9 1.01,4.68 3.31,2.05 0.21,-0.13 0.76,0.15 2.49,1.3 0.9,0.79 0.27,3.09 0.88,2.08 2.08,1.38 0.72,0.74 1.54,1.26 -0.09,0.23 -0.17,0.64 0.26,0 0.3,-0.37 0.51,-0.18 1.15,-0.06 0.49,0.26 0.48,0.97 0.3,-0.04 0.47,0.25 0.47,0.17 -0.39,0.23 -1.19,0.95 -2.52,0.99 -8.1,-0.84 -2.2,0.36 -3.21,-0.49 -10.65,1.24 -1.2,0.5 -1.17,0.7 -1.85,2.01 -2.24,1.07 -1.01,0.74 -1.42,2.37 -5.13,5.22 -0.65,1.33 0.01,2.05 0.2,1.37 -8.04,0.93 -3.3,-0.45 -1.22,-1.77 0.03,-2.82 -1.34,-3.92 0.44,-0.63 -0.15,-0.9 -1.07,-0.92 -1.72,-0.39 -1.35,-0.83 -1.07,-1.09 -1.57,-0.26 -1.42,0.94 -0.93,0.88 -0.82,-0.08 -1.68,0.35 -2.03,1.33 -1.11,1.38 -0.5,1.19 -0.11,0.38 -0.55,0.88 -1,0.69 -1.57,-0.66 -1.46,-1.36 -4.21,-2.38 -0.57,-1.14 -4.7,-4.28 -3.62,-0.06 -4.4,-0.78 -9.89,-6.5 -1.28,-1.93 -0.46,-2.29 0.38,-5.3 -0.84,-1.95 -2.27,-2.74 -0.22,-0.78 -0.46,-0.85 -0.26,-0.67 0.14,-0.48 0.32,-0.27 0.32,-0.18 0.15,-0.23 -0.27,-2.57 -0.05,-0.18 -0.15,-0.34 -0.68,-0.92 -1.19,-11.58 0.02,-1.43 0.11,-0.22 0.13,-0.21 -0.05,-0.47 -0.21,-0.77 -0.22,-0.35 -0.27,-0.23 -0.2,-0.32 0,-0.59 -0.23,0 -2.15,-2.92 -0.45,-1.44 0.37,-1.87 1.91,-3.23 5.81,-6.03 1.27,-2.3 0.01,-2.15 -0.86,-2.29 -0.47,-2.48 0.99,-4.61 0.74,-1.81 3.74,-4 0.21,-0.21 0.54,0.14 0.69,0.41 0.16,0.03 0.26,0.06 0.94,0.03 1.93,0.48 3.01,0.03 1.74,0.68 0.78,0.3 7.13,1.51 2.24,1.02 1.97,0.5 0.33,-0.05 2.26,-0.3 0.59,-0.28 1.76,-1.28 0.66,-0.32 0.44,-0.11 1.32,-0.05 0.82,-0.27 0.36,-0.04 0.46,0.1 3.53,1.58 0.61,0.17 0.61,-0.04 0.73,-0.3 0.55,-0.34 0.52,-0.43 0.47,-0.53 0.39,-0.62 0.96,-1.98 0.45,-0.59 0.61,-0.52 1.97,-1 0.55,-0.54 0.57,-1.32 0.41,-0.65 0.27,-0.21 0.56,-0.31 0.27,-0.22 0.19,-0.27 0.87,-1.51 0.46,-0.54 0.51,-0.43 0.01,0 0.56,-0.26 0.54,-0.02 0.94,0.43 0.51,0.14 0.41,-0.08 2.03,-1.15 0.26,0.86 0.12,0.09 0.04,0.45 0.47,0.53 1.04,0.51 0.5,0.88 0.63,2.66 -0.13,0.87 -0.23,0.79 -0.69,0.96 -2.94,2.02 -2.11,0.29 -1.36,0.79 -1.48,0.28 z\"\r\n                        title=\"East Azarbaijan\" />\r\n                    <path\r\n                        d=\"m 27.10043,6.0744 0,0 0.09,0.12 0.48,0.29 0.14,0.07 0.72,0.14 0.78,0.03 -0.1,0.2 -0.13,0.13 0.71,0.51 0.41,0.95 1.01,4.22 0.42,0.88 0.71,0.63 -0.28,0.53 0.12,0.32 0.86,0.62 0.18,0.04 0.37,-0.01 0.26,0.07 0.12,0.17 0.08,0.2 0.12,0.16 1.2,0.82 0.02,0.01 0.18,0.23 0.11,0.31 0.28,0.46 0.34,0.41 0.32,0.18 0.27,0.42 0.62,1.39 0.2,0.45 0.29,0.43 0.24,0.47 0.35,2.18 0.22,0.66 0.89,-0.28 3.52,1.17 0.09,-0.08 0.24,-0.16 0.3,-0.12 0.32,0.04 0.1,0.27 -0.09,0.41 -0.01,0.38 0.34,0.16 0.47,0.09 0.45,0.29 0.19,0.46 -0.29,0.65 0.23,0.44 0.29,0.22 0.31,0.19 0.32,0.34 0.14,0.34 0.27,0.94 0.17,0.37 0.32,0.24 0.81,0.36 0.16,0.3 -0.07,0.45 -0.14,0.36 -0.1,0.37 0.06,0.47 0.39,0.46 0.72,0.49 0.77,0.38 0.4,0.11 -0.21,0.21 -3.74,4 -0.74,1.81 -0.99,4.61 0.47,2.48 0.86,2.29 -0.01,2.15 -1.27,2.3 -5.81,6.03 -1.91,3.23 -0.37,1.87 0.45,1.44 2.15,2.92 0.23,0 0,0.59 0.2,0.32 0.27,0.23 0.22,0.35 0.21,0.77 0.05,0.47 -0.13,0.21 -0.11,0.22 -0.02,1.43 1.19,11.58 0.68,0.92 0.15,0.34 0.05,0.18 0.27,2.57 -0.15,0.23 -0.32,0.18 -0.32,0.27 -0.14,0.48 0.26,0.67 0.46,0.85 0.22,0.78 2.27,2.74 0.84,1.95 -0.38,5.3 0.46,2.29 1.28,1.93 9.89,6.5 4.4,0.78 3.62,0.06 4.7,4.28 0.57,1.14 4.21,2.38 1.46,1.36 1.57,0.66 1,-0.69 0.55,-0.88 0.11,-0.38 0.5,-1.19 1.11,-1.38 2.03,-1.33 1.68,-0.35 0.82,0.08 0.93,-0.88 1.42,-0.94 1.57,0.26 1.07,1.09 1.35,0.83 1.72,0.39 1.07,0.92 0.15,0.9 -0.44,0.63 1.34,3.92 -0.03,2.82 1.22,1.77 3.3,0.45 8.04,-0.93 4.69,10.52 -0.83,0.26 -1,0.61 -0.14,0.83 0.24,0.69 -0.18,0.66 -0.58,1.16 -1.43,1.66 -2.56,1.13 -3.84,-0.34 -3.51,-0.97 -1.3,-0.9 -0.58,-0.64 -0.68,-0.57 -0.48,-0.64 -0.24,-0.51 -0.4,-0.33 -17.52,1.62 -8.52,-1.22 -2.96,1.18 -0.75,0.97 -0.05,2.03 -1.63,2.48 -5.51,1.78 -1.02,1.11 -0.39,0.67 -0.75,0.77 -0.46,2.04 -1.88,2.14 -0.56,1.37 -1.33,1.33 -1.14,0.7 -0.02,0.02 0,0 -0.75,-0.28 -0.89,0.02 -1.12,0.56 -0.6,0.17 -0.01,0 0,0.01 -0.01,0 0,0 -0.67,0.46 -0.76,0.25 -0.72,-0.1 -0.6,-0.61 -0.01,0 0,-0.01 0,0 0,0 -0.22,-0.68 0.2,-0.86 0.42,-0.86 0.41,-0.67 0.14,-0.84 -0.43,-0.85 -1.05,-1.37 -0.17,-0.88 0.08,-1.93 -0.15,-0.81 -0.5,-0.49 -0.63,-0.49 -0.19,-0.51 0.82,-0.53 -0.64,-0.82 -0.23,-0.73 -0.09,-1.81 -0.16,-0.97 -0.36,-1.06 -0.6,-0.75 -0.86,-0.06 -1.89,0.75 -0.99,0.08 -0.92,-0.43 -0.39,-0.45 -0.12,-0.38 -0.06,-0.41 -0.16,-0.55 -0.27,-0.4 -0.29,-0.29 -0.22,-0.34 -0.03,-0.6 -0.44,-0.47 -0.53,-0.46 -0.12,-0.11 -0.49,-0.63 0.06,-0.67 0.15,-0.11 0.42,-0.16 0.11,-0.08 0.03,-0.89 0.36,-1.44 0.66,-1.53 0.05,-0.79 -0.36,-0.91 -0.82,-1.52 -0.5,-0.68 -0.57,-0.31 -0.44,-0.01 -0.4,-0.13 -0.35,-0.25 -0.31,-0.37 -0.42,-0.37 -0.49,-0.09 -1.05,0.06 -0.88,-0.2 -0.68,-0.45 -0.26,-0.74 0.36,-1.04 1.2,-1.48 0.47,-0.76 0.18,-1.02 -0.16,-0.95 -0.31,-0.69 -0.19,-0.75 0.19,-1.13 0.37,-0.47 0.05,-0.46 -0.22,-0.38 -0.74,-0.39 -0.39,-0.42 -0.23,-0.13 -0.33,0.01 -0.67,0.21 -0.31,-0.07 -0.16,-0.21 -0.17,-0.65 -0.13,-0.27 -0.25,-0.18 -0.25,-0.08 -0.24,-0.11 -0.2,-0.29 -0.27,-0.75 0,-0.41 0.46,-1.23 0.21,-0.82 -0.21,-0.72 -0.32,-0.72 -0.11,-0.86 0.24,-0.76 0.42,-0.36 0.47,-0.27 0.39,-0.52 0.11,-1.38 -0.77,-0.9 -1.95,-1.25 -0.28,-0.58 -0.2,-0.6 -0.31,-0.39 -1.23,0.19 -0.32,-0.36 -0.48,-1.22 -0.52,-0.39 -1.26,-0.12 -0.45,-0.26 -0.21,-0.7 0.45,-1.27 -0.14,-0.72 0,-0.01 -0.18,-0.87 0.07,-1.06 0.22,-1.05 0.31,-0.86 -0.14,-0.73 -0.76,-0.58 -0.68,-0.78 0.15,-1.29 0.28,-0.38 1.17,-0.95 0.35,-0.55 -0.08,-0.4 -1.24,-1.53 -0.85,-0.74 -0.95,-0.43 -0.92,0.1 -0.43,0.25 -0.54,0.19 -0.48,-0.05 -0.25,-0.48 0.03,-0.26 0.13,-0.68 -0.02,-0.22 -0.26,-0.2 -0.22,0.05 -0.23,0.08 -0.26,-0.08 -0.38,-0.49 -0.19,-0.53 -0.13,-0.49 -0.2,-0.4 -0.36,-0.26 -1.22,-0.59 -0.41,-0.12 -2.19,0.26 -1.18,-0.2 -0.59,-0.93 0.09,-0.33 0.05,-0.15 0.35,-0.44 0.3,-0.46 -0.03,-0.55 -0.17,-0.6 0.06,-0.55 0.21,-0.52 0.29,-0.55 0,-0.01 0,0 0,0 0.31,-0.62 0.82,-0.93 0.3,-0.66 0.28,-0.9 0.31,-0.55 0.45,-0.35 0.65,-0.32 0.19,-0.27 -0.28,-0.81 0.05,-0.37 0.28,-0.25 0.6,-0.25 0.25,-0.34 0.22,-0.63 0.21,-0.85 0.12,-0.83 -0.15,-2.07 0.96,-1.09 1.22,-0.96 0.76,-1.1 -0.01,-0.68 -0.26,-0.68 -0.42,-0.59 -0.48,-0.41 -0.53,-0.2 -0.43,0.09 -1.11,0.65 -1.69,-0.31 -0.5,-0.23 -0.31,-0.22 -0.1,-0.38 0.11,-0.71 0.02,-0.39 -0.11,-1.1 0.01,-0.51 0.43,-1.74 0.04,-0.75 -0.31,-2.2 0.15,-1.71 0.01,-0.9 -0.24,-0.72 -0.25,-0.28 -0.26,-0.17 -0.61,-0.2 -0.42,-0.22 0.1,-0.26 0.29,-0.3 0.15,-0.32 -0.17,-0.78 -0.16,-0.52 -0.07,-0.54 0.14,-0.87 0.92,-3.15 -0.17,-1.27 -1.79,-0.87 -0.55,-0.53 -0.46,-0.66 -0.33,-0.97 -0.14,-0.33 -0.12,-0.33 0.02,-0.37 -0.02,-0.39 -0.26,-0.27 -0.31,-0.24 -0.2,-0.31 -0.14,-0.67 -0.11,-0.3 -0.18,-0.3 0,-0.01 0.48,-0.81 0.54,-0.46 0.33,-0.52 -0.31,-1.71 0.17,-0.7 0.67,-1.32 -0.28,-1.07 -1.3,-0.93 -1.51,-0.8 -0.88,-0.67 -0.04,-0.38 0.24,-0.79 -0.03,-0.39 -0.41,-0.87 -0.11,-0.37 -0.02,-0.39 0.09,-0.29 0,-0.32 -0.4,-0.87 -0.2,-0.93 -0.14,-0.42 -0.01,-0.01 -0.89,-1.06 -0.2,-0.53 0.37,-0.53 0.69,-0.43 0.51,-0.19 0.53,-0.01 0.75,0.09 0.78,-0.08 1.84,-0.49 0.81,0.09 2.34,1.17 0.86,0.07 0.75,-0.18 1.75,-0.8 0.65,-0.48 0.57,-0.87 0.01,-0.79 -0.11,-0.83 0.16,-0.98 0,0 0.01,0 0.34,-0.52 0.02,-0.53 -0.12,-0.56 -0.06,-0.62 0.06,-0.72 0.16,-0.59 1.12,-2.27 0.2,-0.56 0.02,-0.17 0.07,-0.53 -0.18,-1.43 0.15,-0.5 3.6,-2.97 0.84,-0.25 0.52,0.37 0.91,1.39 0.47,0.53 2.02,0.95 0.66,0.56 2.75,2 z\"\r\n                        title=\"West Azarbaijan\" />\r\n                    <path\r\n                        d=\"m 189.74043,137.3244 0,0 1.73,-0.07 1.04,0.18 0.73,0.5 3.13,0.63 1.68,-0.3 6.36,-3.46 0.7,-0.24 0.75,-0.4 2.81,-0.63 4.6,0.46 9.03,7.62 1.87,1.02 5.49,4.19 0.39,1.14 0.04,0.84 -8.06,-0.86 -3.84,0.31 -0.98,1.49 1.73,2.38 1.25,1.07 2.4,0.72 1.57,1.35 -1.07,3.62 -1.63,3.39 -0.4,1.54 -1.16,1.11 -6.86,3.35 -1.86,1.8 -0.42,1.63 0.28,1.29 0.86,1.92 0.73,1.21 -1.01,-0.15 -2.02,0.12 -6.07,2.65 -1.56,0.09 -1.87,0.54 -1.75,0.87 -5.96,1.82 -1.42,1.06 -1.02,2.34 -5.94,0.16 -0.83,-0.58 -4.81,-1.22 -0.95,0.25 -4.34,-0.74 -2.31,-1.77 1.03,-1.57 -1.29,-1.62 -2.82,-1.62 -3.7,-0.07 -1.58,0.7 -2.52,-3.71 -4.3,-3.88 -0.1,-1.3 0.71,-0.47 1.06,-0.24 1.45,-0.05 1.23,-0.25 1.89,-1.4 3.07,-0.85 2.22,0.15 3.09,1.43 -0.05,-0.46 0.18,-1.66 2.07,-2.35 3.42,-1.94 6.18,-1.67 0.78,-1.14 -0.54,-4.45 -0.78,-1.74 -1.06,-1.76 -0.56,-2.08 -0.63,-1.15 -0.88,-0.5 -0.64,-0.69 -0.65,-0.36 -1.03,-0.07 -1.68,-0.84 -1.13,-1.71 -1.09,-2.74 -1.82,-2.27 -0.7,-2.67 1.38,-3.2 3.68,-2.46 2.76,-0.95 3.21,1.55 0.06,0.71 0.43,1.35 1.91,2.43 2.06,1.94 4.65,1.39 z\"\r\n                        title=\"Qazvin\" />\r\n                    <path\r\n                        d=\"m 165.12043,111.4344 0,0 5.1,3.26 3.76,3.97 1.44,2.33 2,6.96 -2.76,0.95 -3.68,2.46 -1.38,3.2 0.7,2.67 1.82,2.27 1.09,2.74 1.13,1.71 1.68,0.84 1.03,0.07 0.65,0.36 0.64,0.69 0.88,0.5 0.63,1.15 0.56,2.08 1.06,1.76 0.78,1.74 0.54,4.45 -0.78,1.14 -6.18,1.67 -3.42,1.94 -2.07,2.35 -0.18,1.66 0.05,0.46 -3.09,-1.43 -2.22,-0.15 -3.07,0.85 -1.89,1.4 -1.23,0.25 -1.45,0.05 -1.06,0.24 -0.71,0.47 0.1,1.3 4.3,3.88 2.52,3.71 0.02,0.73 -1.24,1.7 -2.56,0.9 -2.85,-0.7 -2.97,-1.62 -7.27,-0.25 -1.52,-0.95 -1.14,-2.08 -0.3,-0.9 -0.67,-1.14 -0.62,-0.58 -9.32,-5.68 -0.47,-1.11 0.56,-1.51 1.33,-1.4 0.75,-3.07 0,-4.26 -0.64,-2.37 -0.59,-0.07 -0.14,-0.06 -0.04,-0.31 0.11,-0.28 0.14,-0.26 0.05,-0.29 -0.21,-1.02 0.07,-0.37 0.35,-0.33 -0.32,-0.47 -0.38,-0.82 -0.33,-0.94 -0.13,-0.81 -0.23,-0.45 -1.07,-1.19 -0.12,-0.18 -17.06,-3.4 -0.98,-0.99 -4.69,-10.52 -0.2,-1.37 -0.01,-2.05 0.65,-1.33 5.13,-5.22 1.42,-2.37 1.01,-0.74 2.24,-1.07 1.85,-2.01 1.17,-0.7 1.2,-0.5 10.65,-1.24 3.21,0.49 2.2,-0.36 8.1,0.84 2.52,-0.99 1.19,-0.95 0.39,-0.23 0.99,-0.27 1.39,0.51 2.53,2.7 1.05,-0.22 0.45,-0.76 0,-0.72 0.41,-0.73 0.65,-0.26 0.97,0.55 1.22,0.16 1.34,-0.92 1.19,-0.36 2.28,1.22 z\"\r\n                        title=\"Zanjan\" />\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 1.14,2.08 1.52,0.95 7.27,0.25 2.97,1.62 2.85,0.7 2.56,-0.9 1.24,-1.7 -0.02,-0.73 1.58,-0.7 3.7,0.07 2.82,1.62 1.29,1.62 -1.03,1.57 2.31,1.77 4.34,0.74 0.95,-0.25 4.81,1.22 0.83,0.58 -0.02,0.99 0.29,1.48 0.8,1.06 -0.13,1.59 -1.14,1.27 -1.16,-0.21 -0.66,-0.95 0.04,-1.05 -0.08,-0.78 -0.92,0.07 -1.06,1.35 0.64,2.78 1.51,2.52 0.42,1.91 -1.63,1.91 -1.95,0.61 -1.03,0.11 -0.61,0.69 0.09,0.59 0.78,0.76 1.52,0.78 3.64,1 1.73,0.84 1.63,1.93 0.85,2.05 0.73,4.44 -0.82,1.67 -1.49,-0.14 -1.09,-1.01 -1.34,-1.59 -0.51,-1.88 0.72,-1.53 -0.82,-1.19 -2.93,-0.51 -6.16,0.33 -0.85,1.29 0.38,2.4 -0.4,1.46 -0.9,1.47 -0.12,2.89 0.58,3.18 -0.76,0.18 -1.57,-0.76 -3.49,-0.36 -1.18,0.47 0.49,1.16 1.71,0.68 0.58,2.59 0.27,4.33 2.4,4.73 0.54,2.24 0.19,2.24 0.62,2.64 -0.1,0.96 -0.6,0.82 -3.53,3.18 -9.24,-3.95 -2.22,0.25 -1.8,-0.11 -0.88,0.24 -1.78,1.84 -1.01,0.26 -1.25,-0.47 -7.52,-0.91 -14.54,-9.57 -0.7,-1.02 -1.45,-0.94 -0.85,-0.38 0.59,-1.15 1.24,-1.9 3.36,-0.24 3.8,0.81 1.03,-0.85 -0.08,-1.91 0.37,-2.72 -0.34,-1.67 -0.65,-0.99 -0.78,0.17 -1.56,0.69 -2.89,3.02 -0.86,-1.31 -0.5,-1.7 -0.92,-0.49 -1.11,-0.22 -2.49,-1.36 -1.72,-1.4 -0.33,-1.64 0.49,-0.64 1.08,-0.43 3.39,-0.39 1.59,-2.35 1.34,-3.02 1.12,-1.29 0.18,-1.15 -0.02,-0.63 1.03,-0.56 2.08,-0.59 1.23,-0.67 0.38,-1.16 0.63,-0.16 1.09,2.68 0.73,0.39 1.13,-0.99 1.19,-1.91 0.67,-3.09 -0.93,-3.83 -1.93,-1.92 -1.39,-0.87 -1.66,-2.03 -3.65,-8.17 -2.36,-3.5 0.53,-1.05 1.77,-1.99 0.78,-0.08 1.6,3.33 1.05,0.29 1.11,-0.5 0.97,-0.95 2.41,-0.82 0.01,-1.05 -0.4,-0.89 -1,-1.3 -0.6,-1.67 1.22,-0.34 4.99,2.73 z\"\r\n                        title=\"Hamadan\" />\r\n                    <path\r\n                        d=\"m 266.71043,208.9144 0,0 0.45,1.65 -0.09,3.36 -0.91,3.61 -1.49,3.5 -1.13,1.62 -11.42,2.97 -2.62,-0.14 -7.31,0.84 -3.23,1.41 -1.27,1.28 -0.4,1.2 -1.02,8.04 0.71,1.77 0.96,0.51 -7.81,-2.13 -3.49,-1.92 -8.74,-0.82 -2.24,-1.86 -1.57,-1.95 -0.82,-2.04 0.14,-1.68 -0.51,-1.21 -0.99,-1.17 -1,-0.61 -1.36,0.12 -1.23,-0.56 -1.5,-1.35 -1.83,-2.15 0.32,-2.12 3.16,-1.78 0.36,-0.83 -0.7,-0.99 0.05,-2.69 1.93,-1.57 3.05,0.42 2.95,-0.85 2.01,-1.33 4.2,-0.66 3.51,-1.19 0.62,-0.37 0.4,-1.59 0.6,-6.35 1.13,-3.23 0.96,-1.35 0,0.11 9.73,0.11 8.13,2.45 19.31,11.52 z\"\r\n                        title=\"Qom\" />\r\n                    <path\r\n                        d=\"m 226.55043,180.9344 0,0 0.96,-0.2 0.94,-1.92 1.56,-0.14 1.57,1.96 0.87,1.69 0.02,2.91 -2.93,9.49 -0.96,1.35 -1.13,3.23 -0.6,6.35 -0.4,1.59 -0.62,0.37 -3.51,1.19 -4.2,0.66 -2.01,1.33 -2.95,0.85 -3.05,-0.42 -1.93,1.57 -0.05,2.69 0.7,0.99 -0.36,0.83 -3.16,1.78 -0.32,2.12 1.83,2.15 1.5,1.35 1.23,0.56 1.36,-0.12 1,0.61 0.99,1.17 0.51,1.21 -0.14,1.68 0.82,2.04 1.57,1.95 2.24,1.86 8.74,0.82 3.49,1.92 7.81,2.13 -0.4,2.44 -3.23,7.83 -0.91,1.61 -1.94,0.01 -2.13,0.68 -1.9,1.61 -2.12,1.31 -14.11,3.72 -5.38,3.2 -2.81,2.34 -0.3,-0.33 -2.16,-1.17 -0.24,-1.16 0.05,-1.19 -0.73,-0.76 -1.09,-0.84 -0.54,-0.97 -0.76,-0.46 -1.18,0.85 -0.67,1.32 -0.22,1.05 -0.79,0.54 -1.05,-0.83 -1.16,-1.23 -2.55,-1.29 -1.1,-0.94 -0.32,-0.95 0.36,-1.21 0.54,-1.17 -0.04,-1.08 -0.92,-1.58 -1.48,-1.8 -1.86,-0.6 -1.7,0.98 -1.87,0.63 -1.5,0.87 -1.16,3.55 -0.64,0.68 -2.71,1.72 -0.93,-0.35 -3.82,-0.33 -2.24,-0.83 -1.73,-1 -0.44,-0.86 0.18,-0.98 0.28,-0.9 1.36,-3.13 -0.12,-0.93 -0.42,-1.1 0.24,-1.33 0.53,-0.87 3.53,-3.18 0.6,-0.82 0.1,-0.96 -0.62,-2.64 -0.19,-2.24 -0.54,-2.24 -2.4,-4.73 -0.27,-4.33 -0.58,-2.59 -1.71,-0.68 -0.49,-1.16 1.18,-0.47 3.49,0.36 1.57,0.76 0.76,-0.18 -0.58,-3.18 0.12,-2.89 0.9,-1.47 0.4,-1.46 -0.38,-2.4 0.85,-1.29 6.16,-0.33 2.93,0.51 0.82,1.19 -0.72,1.53 0.51,1.88 1.34,1.59 1.09,1.01 1.49,0.14 0.82,-1.67 -0.73,-4.44 -0.85,-2.05 -1.63,-1.93 -1.73,-0.84 -3.64,-1 -1.52,-0.78 -0.78,-0.76 -0.09,-0.59 0.61,-0.69 1.03,-0.11 1.95,-0.61 1.63,-1.91 -0.42,-1.91 -1.51,-2.52 -0.64,-2.78 1.06,-1.35 0.92,-0.07 0.08,0.78 -0.04,1.05 0.66,0.95 1.16,0.21 1.14,-1.27 0.13,-1.59 -0.8,-1.06 -0.29,-1.48 0.02,-0.99 5.94,-0.16 1.02,-2.34 1.42,-1.06 5.96,-1.82 1.75,-0.87 1.87,-0.54 1.56,-0.09 6.07,-2.65 2.02,-0.12 1.01,0.15 1.46,0.34 3.42,0.22 3.32,0.97 1.95,1.76 0.85,0.51 0.35,-0.62 0,-0.7 -1.31,-1.82 0.43,-1.12 1.91,0.02 1.31,1.55 -0.01,2.31 0.24,1.39 z\"\r\n                        title=\"Markazi\" />\r\n                    <path\r\n                        d=\"m 133.80043,3.1044 0,0 0.46,0.12 0.66,0.45 2.07,1.95 5.69,6.85 2.32,2.15 0.96,1.31 0.75,1.59 -0.36,0.11 -0.88,0.29 -1.78,1.2 -2.12,0.43 -1.14,0.59 -0.98,0.94 -0.62,1.24 -0.07,1.51 0.46,1.17 0.83,1.17 1.92,1.88 1.94,0.8 0.51,0.5 1.02,2.2 0.18,0.55 -0.02,0.61 -0.16,0.59 0,0.02 -0.26,0.56 -0.31,0.46 -0.01,0 0,0 0,0.01 0,0 -1.39,0.87 -6.26,1.11 -0.11,0.28 0.01,0.33 -0.1,0.28 -1.78,1.1 -0.31,0.49 0.08,1.79 0.67,1.24 2.2,1.77 4.49,2.22 0.42,0.36 0.09,0.36 0.16,0.63 -0.14,0.85 0.06,0.73 1.65,1.32 0.53,0.79 0.61,0.58 1.04,0.03 1.72,-0.81 0.79,0 0.39,0.94 0.24,1.15 0.44,0.59 0.54,0.49 0.56,0.88 0.57,0.62 0.5,0.72 0.84,1.06 0.44,0.56 0.92,1.55 1.09,1.06 0.17,0.01 0.2,0.45 1.08,0.96 0.7,0.92 0.19,0.81 0.82,0.33 1.28,0.29 0.52,0.56 -0.3,0.79 -7.65,9.11 -0.7,1.66 -0.3,2.28 -1.08,1.68 -0.07,2.35 3.11,8.63 5.62,8.86 1.87,1.93 2.16,1.71 1.14,1.45 0.03,1.22 -0.15,1.86 0.29,2.23 0.37,1.05 -2.28,-1.22 -1.19,0.36 -1.34,0.92 -1.22,-0.16 -0.97,-0.55 -0.65,0.26 -0.41,0.73 0,0.72 -0.45,0.76 -1.05,0.22 -2.53,-2.7 -1.39,-0.51 -0.99,0.27 -0.47,-0.17 -0.47,-0.25 -0.3,0.04 -0.48,-0.97 -0.49,-0.26 -1.15,0.06 -0.51,0.18 -0.3,0.37 -0.26,0 0.17,-0.64 0.09,-0.23 -1.54,-1.26 -0.72,-0.74 -2.08,-1.38 -0.88,-2.08 -0.27,-3.09 -0.9,-0.79 -2.49,-1.3 -0.76,-0.15 -0.21,0.13 -3.31,-2.05 -1.01,-4.68 0.3,-3.9 0.77,-1.63 0.34,-1.19 -0.35,-0.77 -2.27,-2.09 -2.67,-3.66 -1.71,-4.24 -0.21,-3.42 -1.01,-3.16 -2.36,-1.18 -7.61,1.12 -0.99,-0.18 -0.47,-0.35 -1.07,-1.04 -2.16,0.26 -1.63,0.64 -0.4,-1.34 0.16,-2.21 0.69,-1.58 0.86,-1.12 1.07,-2.01 2.71,-1.98 1.42,-1.54 2.3,-0.68 2.43,0.39 1.65,-1.13 -0.64,-2.12 -1.78,-1.01 -0.02,-1.21 1.25,-1.69 0.36,-2.9 -1.96,-4.9 -0.09,-3.28 -0.52,-0.76 0.47,-4.96 -1.34,-0.5 -2.19,1.96 -2.28,1.37 -1.38,-0.12 -2.55,1.73 -3.88,6.77 0.46,0.71 0.51,0.19 -0.42,0.55 -2.12,1.6 -1.28,1.75 -1.42,1.15 -5.07,-1.44 -2.22,0.63 -2.32,1.26 -2.32,0.83 -1.73,-0.95 -0.96,-2.37 0.54,-2.71 1.36,-1.8 0.91,-0.53 0.34,-0.62 1.26,-0.14 1.81,0.44 0.46,-0.41 0.23,-1.21 0.02,-1.27 0.09,-0.66 0.7,-0.05 1.57,1.29 1.48,-0.28 1.36,-0.79 2.11,-0.29 2.94,-2.02 0.69,-0.96 0.23,-0.79 0.13,-0.87 -0.63,-2.66 -0.5,-0.88 -1.04,-0.51 -0.47,-0.53 -0.04,-0.45 -0.12,-0.09 -0.26,-0.86 0.23,-0.13 0.35,-0.42 0.18,-0.33 0.57,-1.66 1.22,-1.96 0.12,-0.44 0.33,-0.37 1.62,-1 3.37,-1.32 0.4,-0.22 1.01,-0.58 1.12,-1.15 0.01,0 1.68,-2.18 1.11,-0.93 1.41,-0.79 2.37,-0.81 0.76,-0.08 0.44,-0.3 1.79,-1.83 0.61,-0.34 4.08,-2.31 1.45,-1.49 0.53,-0.54 0.65,-0.45 0.81,-0.22 2.57,0.05 0.42,-0.11 0.35,-0.32 0.39,-0.59 0.02,0 z\"\r\n                        title=\"Ardebil\" />\r\n                    <path\r\n                        d=\"m 374.13043,563.2144 0,0 -0.27,0.23 -0.28,0.03 -0.19,0.11 -0.32,-0.3 -0.16,0.12 0.02,-0.23 -0.12,-0.23 -0.12,-0.37 0.49,-0.27 0.59,-0.15 0.16,0.26 0.04,0.37 0.16,0.43 z m -16.97,-1.33 0,0 -0.34,0.26 -0.46,-0.11 -0.54,-0.25 -0.14,-0.42 0.44,-0.24 0.81,-0.24 0.17,0.33 0.06,0.67 z m -0.91,-13.27 0,0 -0.19,0.04 -0.39,-0.13 -0.4,-0.21 -0.18,-0.22 -0.05,-0.49 -0.08,-0.38 -0.01,-0.35 0,0 0.14,-0.44 0.21,-0.29 0.28,-0.15 0.33,0.07 0.34,0.37 0.23,0.11 0.19,0.15 0.16,0.2 0.13,0.26 -0.71,1.46 z m -16.2,-9.15 0,0 -0.38,0.21 -2.5,-0.14 -0.26,-0.02 -1.09,-0.53 -0.69,-1.12 0.34,-0.53 0.5,-0.37 0.6,-0.19 0.66,0.03 0.57,0.2 1.26,0.13 0.48,0.19 0,0 0.06,0.17 0.03,0.08 0,0 -0.01,0.34 0,0 0,0.05 0.04,0.26 0,0 0.24,0.13 0.14,0.13 0.09,0.08 0.03,0.22 0.04,0.23 -0.08,0.23 -0.07,0.22 z m 62.36,-4.91 0,0 -0.69,0.4 -0.54,-0.3 0.08,-0.87 0.43,-0.85 0.55,-0.43 0.33,-0.06 0.26,0.4 0.07,0.89 -0.49,0.82 z m -75.53,-1.71 0,0 -0.44,0.44 -0.59,-0.08 -0.6,-0.3 -0.33,-0.47 0.27,-0.41 0.67,-0.03 0.35,0.09 0.4,0.19 0.27,0.57 z m -9.39,-5.09 0,0 -0.49,0.13 -1.3,-0.11 -0.4,0.09 -0.62,0.36 -0.65,0 -1.93,-0.34 -0.59,-0.25 -0.08,-0.05 -0.45,-0.29 -1.06,-0.89 -0.3,-0.35 0.13,-0.17 0.24,-0.05 0.27,-0.1 0.33,-0.02 2.85,0.88 2.54,0.19 0.79,0.31 0.44,0.4 0.28,0.26 z m 101.5,-1.35 0,0 -1.29,0.42 -0.64,-0.26 0.16,-1.01 0.48,-0.7 0.86,-0.39 1.28,-0.13 0.17,1.17 -1.02,0.9 z m -7.04,-2.59 0,0 -0.76,1.7 -0.39,0.66 -1.4,1.43 -0.22,0.51 -0.29,0.31 -1.29,0.65 -0.29,0.35 -0.29,0.19 -1.67,1.61 -0.99,0.58 -0.78,-0.33 -0.74,-0.75 -0.87,-0.69 -2.26,1.17 -0.63,0.54 -0.63,0.36 -0.72,-0.01 -1.54,-0.23 -0.69,0.16 -0.72,0.34 -1.83,1.31 -1.89,0.8 -1.15,0.85 -0.59,0.32 -2.09,0.24 -1.49,0.41 -0.63,0.39 -0.31,0.12 0,0 -0.1,-0.01 -0.19,-0.04 -0.38,-0.13 -0.34,0 -0.15,0.32 -0.15,0.26 -0.37,0.2 -0.42,0.13 -0.31,0.05 0,0 -0.14,-0.1 -0.13,-0.08 -0.17,-0.44 -0.16,-0.93 0.23,-0.67 0.06,-0.43 -0.18,-0.2 -0.34,-1.17 0.37,-0.4 1.59,0.57 0.37,-0.17 0.21,0.06 0.1,0.03 0,0 1.79,-1.01 4.53,-1.47 0.66,-0.08 0.42,-0.17 0.13,-0.05 0,0 1.57,-0.96 0.67,-0.55 2.22,-0.86 0.34,-0.03 0.71,0.06 0.34,-0.03 0.24,-0.11 0.35,-0.29 0.33,-0.12 -0.1,-0.25 -0.15,-0.26 0.52,-0.6 0.12,-0.71 -0.16,-1.7 -0.26,-0.65 -0.58,-0.55 -0.56,-0.44 -0.24,-0.3 0.86,-0.5 4.74,1.79 1.28,-0.3 3.57,-2.31 4.47,-1.02 1.33,-0.02 0.67,0.16 0.87,0.38 0.54,0.41 0.19,0.15 0.27,0.71 -0.54,0.32 -0.55,0.31 -2.09,0.54 -0.75,0.67 z m 10.52,-5.3 0,0 -0.53,0.09 -1.07,-0.41 0.07,-0.96 0.63,-0.87 0.6,-0.12 0.36,0.24 0.39,0.15 0.32,0.26 0.02,0.07 0.11,0.48 -0.13,0.49 -0.32,0.35 -0.24,0.12 -0.21,0.11 z m -30.81,-65.74 0,0 1.52,0.75 1.74,-0.45 6.77,-5.14 3.98,-1.87 1.02,-0.13 0.95,1.41 0.65,14.7 -0.84,2.86 0.71,3.76 3.02,3.91 2.91,2.68 3.48,2.11 4.03,0.62 2.17,-0.39 3.98,-1.97 3.67,-3.49 1.03,-1.27 1.56,-1.23 1.84,0.07 3.53,1.73 0.27,0.62 -0.3,3.93 1.23,5.97 0.49,0.81 0.68,0.57 1.04,0.13 1.76,0.96 1.35,1.76 0.79,1.52 1.54,1.69 1.53,2.33 0.23,1.92 -0.94,0.79 -0.59,1.18 0.77,1.11 0.91,0.46 0.92,1.88 1.02,2.99 1.07,14.26 0.68,2.21 10.47,5.56 2.29,1.69 1.02,0.32 1.6,-1.5 0.81,-1.13 1.39,-0.95 2.23,0.06 2.33,1.4 2.53,2.13 1.99,2.31 0.97,2.1 -0.29,0.72 -2.12,-1.29 -0.73,-0.04 -0.04,0.76 0.82,2.43 0.05,0.96 -0.19,0.63 -0.62,0.76 -0.47,1.17 -0.78,7.39 0.19,1.09 0,1.09 -0.4,2.11 -0.69,0.85 0.06,0.77 4.49,-0.32 2.78,0.5 1.83,-0.17 1.17,-0.55 1.19,0.27 1.3,0.59 2.11,0.33 0.64,0.4 -0.05,0.41 -0.32,0.7 0.08,0.73 0.34,0.84 0.1,1.17 0.57,1.01 1.4,0.32 1.68,0.06 1.45,-0.18 1,-1.05 0.99,-0.25 1.31,0.52 0.93,-0.01 0.49,0.41 1.38,2.09 -0.41,0.22 -0.61,0.93 -0.16,1.21 0.13,0.68 0.46,0.2 1.21,0.76 6.42,5.68 1.09,1.8 0.18,1.36 0.75,0.76 1.02,0.39 0.55,0.68 0.23,0.77 0.46,0.6 0.56,0.56 1.2,2.05 0.28,0.37 0.63,0.31 -0.09,0.6 -0.02,0.57 -0.89,0.39 0.15,0.89 0,0 -1.89,0.29 -1.93,0.92 -0.72,0.16 -0.28,-0.06 -0.25,-0.24 -0.25,-0.16 -0.29,0.07 -0.32,0.14 -0.31,0.09 -0.78,-0.04 -0.67,-0.14 -0.57,-0.24 -0.44,-0.37 -1.56,-2.51 -0.84,-1.01 -1.32,-0.61 -1.18,0.03 -0.31,-0.15 -0.21,-0.36 -0.12,-0.37 -0.19,-0.31 -0.38,-0.12 -2.91,0 -6.15,-1.12 -2.11,0.33 -1.81,-0.12 -0.64,-0.3 0.25,-0.6 -1,0.06 -1.08,0.22 -0.46,0.24 -0.78,0.65 -0.51,0.13 -0.24,-0.1 -0.11,-0.15 -0.17,0.01 -0.39,0.37 -0.27,0.19 -0.35,0.11 -0.3,-0.04 -0.12,-0.26 -0.2,0.09 -1.19,0.83 -1.25,0.2 -1.1,-0.22 -1.07,-0.34 -1.13,-0.18 -0.91,-0.42 -0.74,-1.01 -1.01,-2.16 -1.06,-1.27 -1.28,-0.31 -1.4,0.36 -1.37,0.71 -1.15,0.94 -0.75,0.47 -0.53,-0.01 0.14,-1.66 0.13,-0.43 0.09,-0.18 0.02,-0.14 -0.05,-0.29 -0.35,-0.86 -0.53,-0.47 -0.7,-0.18 -0.85,-0.03 -0.76,0.08 -1.88,0.43 -0.41,-0.08 -0.71,-0.35 -0.39,-0.08 -0.39,0.03 -0.67,0.18 -0.35,0.04 -0.84,-0.07 -2.31,-0.72 0.25,-0.23 -4.53,-0.3 -0.5,-0.27 -0.24,-0.59 -0.19,-1.84 -0.82,-1.91 -0.42,-1.52 -0.29,-0.72 -0.33,-0.31 -0.06,-0.14 -0.75,-0.91 -0.15,-0.03 -0.43,0.07 -0.14,-0.04 -0.06,-0.16 -0.09,-0.44 -0.46,-1.35 -0.14,-0.63 -0.33,-0.74 -0.07,-0.45 0.21,-0.78 1.06,-1.15 0.36,-0.76 -0.46,-1.2 -2.24,-2.48 0.18,-1.01 -0.25,-0.23 -0.19,-1.71 -0.24,-0.85 -0.38,-0.68 -0.65,-0.63 -0.16,-0.28 -0.1,-0.34 -0.12,-0.86 -0.01,-0.35 0.58,-4.72 -0.12,-1.77 -2.2,-8.8 -0.46,-0.68 -1.15,-1 -0.41,-0.6 0.04,-0.62 -1.04,-0.69 -0.35,-0.37 0.5,0.04 0.37,-0.15 0.34,-0.22 0.41,-0.19 -0.29,-0.25 -0.04,-0.36 0.12,-0.37 0.21,-0.31 -1.04,0.45 -0.35,0.07 -0.31,-0.08 -0.2,-0.18 -0.14,-0.18 -0.16,-0.08 -0.18,-0.13 -0.18,-0.25 -0.23,-0.16 -0.66,0.33 -0.2,-0.13 -0.09,-0.31 0.02,-0.39 -0.44,0.1 -0.23,-0.2 0.01,-0.28 0.32,-0.14 0.17,-0.13 0.59,-0.65 0.3,-0.24 0,-0.28 -1,-0.14 -0.81,-0.55 -0.54,-0.79 -0.22,-0.86 -0.39,0.39 -0.44,0.15 -0.91,0.01 -0.51,-0.17 -0.31,-0.36 -0.26,-0.37 -0.32,-0.16 -3.51,-0.05 -0.77,-0.24 -0.23,0.29 -0.82,-0.46 -1.02,-0.21 -2.11,-0.12 -1.01,-0.19 -1.77,-0.71 -1.05,-0.16 -2.1,0.12 -1.07,0.28 -0.78,0.53 -0.72,0.35 -2.21,0.1 -0.89,0.18 -0.28,0.19 -0.56,0.56 -0.11,0.18 -0.07,0.41 -0.19,0.12 -0.26,0.06 -0.29,0.19 -0.58,0.5 -2.28,1.38 -0.82,0.69 -0.01,0.16 -0.18,0.12 -0.62,0.54 -0.37,0.12 -1.51,0.18 -1.4,0.34 -0.36,0.04 -1.13,-0.04 -0.37,0.08 -0.51,0.36 -0.29,0.08 -1.27,0 -1.06,-0.25 -0.34,-0.01 -0.65,0.28 -1.13,1.06 -0.43,0.24 -0.38,0.29 -1.83,2.04 0.49,-0.16 0.21,-0.11 0.25,-0.25 0.13,0.93 -0.2,1.14 -0.4,1.08 -0.48,0.77 -1.11,0.98 -1.27,0.65 -1.42,0.29 -1.52,-0.09 -2.73,-0.95 -1.55,-0.2 -1.29,0.61 -0.4,0.72 -0.18,0.68 -0.33,0.5 -0.82,0.19 -0.67,0.08 -1.48,0.44 -0.51,0.24 -2.21,1.98 -0.38,0.24 -3.25,2.65 -3.68,2.15 -0.23,0.21 -0.22,0.25 -0.25,0.21 -0.35,0.09 -0.43,-0.08 -0.57,-0.34 -0.4,-0.08 -2.91,0.27 -1.49,-0.24 -0.57,-0.86 -0.42,-1.1 -0.99,-0.93 -1.52,-0.3 -3.08,0.12 -1.22,-0.6 -0.61,-0.97 -0.5,-1.21 -0.64,-1.16 -1.01,-0.82 -0.72,-0.14 -0.67,0.11 -0.66,0.19 -2.58,0.17 -0.71,-0.07 -2.32,-0.68 -0.59,-0.1 -0.36,-0.11 -0.65,-0.52 -0.28,-0.14 -0.35,-0.02 -0.7,0.15 -2.23,1.04 -1.56,0.22 -1.37,0.39 -0.75,0.03 -1.51,-0.49 -0.83,-0.07 -0.79,0.43 -0.42,-0.15 -1.76,-1.53 -2.55,-1.51 -3.29,-2.49 -0.48,-0.6 -0.2,-0.74 -0.08,-1.8 -0.27,-0.76 -0.58,-0.7 -1.08,-0.69 -11.52,-3.92 -0.74,-0.07 -0.72,-0.21 -0.46,-0.5 -0.35,-0.61 -0.43,-0.52 -2.02,-0.51 -0.31,-0.38 -0.29,-0.82 -0.69,-0.43 -1.56,-0.46 -2.73,-2.46 -1.2,-0.82 -1.81,-0.8 0.55,-1.07 0.19,-0.23 0.15,0.02 0.69,-0.3 0.37,0.02 2.21,-0.22 0.55,0.02 1.68,0.43 1.58,0.07 0.46,-0.17 1.46,-0.84 0.93,1.79 2.48,2.36 7.55,0.67 1.25,0.5 2.86,2.35 0.57,0.28 0.59,0.08 2.47,-0.63 0.87,0 10.36,1.84 3.53,-1.88 0.92,-1.48 -0.39,-1.12 0.01,-0.42 0.71,-2.09 0.5,-3.03 1.5,-1.83 3.5,-1.22 9.04,-0.83 2.06,0.27 1.6,0.56 1.68,-0.72 3.09,-0.72 9.03,1.28 4.23,-1.29 1.96,-1.87 1.11,-3.39 1.32,-2.1 4.62,-2.49 3.1,-0.8 1.96,0.11 1.02,-0.45 0.77,-0.55 0.58,-0.94 0.21,-2.17 -1.62,-2.65 -2.86,-2.34 -0.16,-1.24 0.16,-1.6 1.71,-6.27 0.4,-4.32 -0.9,-2.42 -10.18,-9.89 -0.18,-1.82 1.11,-0.81 -0.01,-1.09 -1.95,-5.89 2.87,0.21 6.12,1.74 3.03,2.38 1.48,1.94 1.48,1.04 z\"\r\n                        title=\"Hormozgan\" />\r\n                    <path\r\n                        d=\"m 114.44043,243.3144 0,0 0.47,0.64 0.77,1.8 0.3,2 -0.17,1.29 -0.46,0.92 -0.8,0.85 -1.89,1.27 -0.67,0.95 -11.86,3.35 -2.1,2 -0.74,1.84 -0.59,0.07 -0.59,0.25 -0.09,0.62 -0.52,1.57 0.04,0.31 0.53,0.31 0.76,1.35 1.06,0.56 0.89,1.13 0.71,0.26 1.85,1.13 0.35,0.15 0.13,0.34 -0.05,0.41 -0.39,0.71 0.09,0.34 0.45,0.54 0.44,0.39 0.61,0.29 1.28,0.4 0.06,0.11 0.05,0.2 0.11,0.19 0.24,0.08 0.18,-0.04 0.17,-0.19 0.23,-0.04 0.26,0.06 0.19,0.15 0.16,0.19 1.68,1.28 0.6,0.28 0,0.53 0.62,0.63 0.86,0.53 1.44,0.35 4.16,2.1 0.36,0.42 0.19,0.5 0.44,0.14 0.5,0.03 0.38,0.17 0.8,0.95 0.67,1.28 0.44,0.49 0.64,0.19 0.5,0.25 1.1,1.23 3.99,5.25 5.45,11.5 0.67,0.97 0.41,0.39 -3.11,7.27 -2.48,3.43 0.06,2.04 0.4,2.56 -1.21,1.98 -3.54,2.33 -0.9,0.36 -0.08,-0.11 -0.65,-0.27 -0.51,-0.07 -0.3,-0.34 -0.28,-0.41 -0.43,-0.27 -0.53,-0.16 -0.23,-0.18 -0.04,-0.31 0.07,-0.56 0.14,-0.44 0.2,-0.35 0.18,-0.39 0.05,-0.55 -0.18,-0.52 -0.66,-0.51 -0.18,-0.51 -0.33,-0.16 -0.21,-0.23 -0.6,-0.83 -0.13,-0.22 -0.16,-0.22 -1.01,-0.97 -0.15,-0.23 -0.23,-0.54 0.01,-0.2 0.13,-0.15 0.3,-0.74 0.19,-0.23 0.12,-0.26 -0.05,-0.46 -0.19,-0.3 -0.91,-0.69 -0.56,-0.73 -0.38,-0.62 -0.44,-0.5 -0.72,-0.38 -1.92,-0.66 -0.47,-0.03 -1.56,0.86 -0.59,0.22 -1.2,0.13 -1.07,-0.23 -1.03,-0.55 -1.08,-0.79 0,-0.01 -0.01,0 -10.19,-8.91 -1.41,-1.6 -2.21,-1.35 -1.56,-1.26 -0.13,-0.07 -3.16,-1.84 -0.95,-0.95 -3.37,-1.62 -3.6,-1.12 -3.99,0.45 -1.98,-0.24 -0.72,-1.61 0,-0.01 0.41,-0.49 0.57,-0.46 0.5,-0.52 0.22,-0.69 -0.19,-0.55 -0.49,-0.44 -0.64,-0.27 -1.48,-0.17 -0.48,-0.41 0.04,-0.49 0.68,-0.38 0.74,-0.07 0.57,0.04 0.55,-0.11 0.71,-0.54 0.92,-0.91 0.46,-0.57 0.24,-0.51 -0.02,-0.37 -0.39,-0.25 -0.15,-0.38 0.02,-0.33 0.21,-0.77 -0.01,-0.42 -0.3,-0.68 -0.47,-0.49 -1.08,-0.87 -1.35,-1.91 -1.13,-1.1 -0.18,-0.59 -0.02,-0.68 -0.1,-0.82 -0.27,-0.77 -0.39,-0.7 -1.13,-1.42 -0.11,-0.08 -0.1,-0.06 -0.13,-0.08 -0.04,-0.02 -0.18,-0.03 -0.17,0.03 -0.16,0.09 -0.63,0.6 -1.03,0.13 -1,-0.23 -0.58,-0.5 0.53,-0.7 1.6,-0.98 0.42,-0.62 -0.24,-0.89 -0.71,-0.5 -0.6,-0.61 0.13,-1.25 -0.73,0.18 -1.65,0.03 -0.61,0.26 -0.99,0.95 -0.56,0.38 -0.59,0.14 -0.23,-0.28 0.01,-1.44 -0.11,-0.31 0.76,-0.64 0.72,-5.9 1.29,-4.06 0.37,-2.63 -0.47,-1.56 0.62,-0.73 2,0.06 5.25,-0.66 5.07,2.08 2.73,0.2 2.74,0.63 2.27,1.4 2.49,2.16 8.5,2.75 3.96,0.32 5.76,-1.47 5.31,0.24 0.71,-1.39 0.47,-2.64 -0.5,-1.03 -0.93,-1.39 0,-1.25 5.43,-1.26 1.15,0.1 0.56,0.17 z\"\r\n                        title=\"Ilam\" />\r\n                    <path\r\n                        d=\"m 124.87043,230.5444 0,0 0.85,0.38 1.45,0.94 0.7,1.02 14.54,9.57 7.52,0.91 1.25,0.47 1.01,-0.26 1.78,-1.84 0.88,-0.24 1.8,0.11 2.22,-0.25 9.24,3.95 -0.53,0.87 -0.24,1.33 0.42,1.1 0.12,0.93 -1.36,3.13 -0.28,0.9 -0.18,0.98 0.44,0.86 1.73,1 2.24,0.83 3.82,0.33 0.93,0.35 2.71,-1.72 0.64,-0.68 1.16,-3.55 1.5,-0.87 1.87,-0.63 1.7,-0.98 1.86,0.6 1.48,1.8 0.92,1.58 0.04,1.08 -0.54,1.17 -0.36,1.21 0.32,0.95 1.1,0.94 2.55,1.29 1.16,1.23 1.05,0.83 0.79,-0.54 0.22,-1.05 0.67,-1.32 1.18,-0.85 0.76,0.46 0.54,0.97 1.09,0.84 0.73,0.76 -0.05,1.19 0.24,1.16 2.16,1.17 0.3,0.33 -0.76,1.62 -0.14,2.2 0.09,1.75 -3.43,6.9 -0.19,0.95 -0.07,0.75 -0.81,0.48 -5.03,1.42 -1.95,2.3 -0.61,4.78 -1.55,1.17 -2.7,0.9 -0.77,0.5 -0.46,0.82 -0.21,0.97 0.02,0.39 -2.48,0.53 -4.76,-0.46 -7.89,-5.44 -7.5,-0.76 -2.11,-0.65 -1.74,-1.69 -3.51,-1.05 -3.6,0.27 -2.38,0.74 -8.36,0.56 -1.83,1.4 -4.62,12.18 -1.86,2.71 -0.41,-0.39 -0.67,-0.97 -5.45,-11.5 -3.99,-5.25 -1.1,-1.23 -0.5,-0.25 -0.64,-0.19 -0.44,-0.49 -0.67,-1.28 -0.8,-0.95 -0.38,-0.17 -0.5,-0.03 -0.44,-0.14 -0.19,-0.5 -0.36,-0.42 -4.16,-2.1 -1.44,-0.35 -0.86,-0.53 -0.62,-0.63 0,-0.53 -0.6,-0.28 -1.68,-1.28 -0.16,-0.19 -0.19,-0.15 -0.26,-0.06 -0.23,0.04 -0.17,0.19 -0.18,0.04 -0.24,-0.08 -0.11,-0.19 -0.05,-0.2 -0.06,-0.11 -1.28,-0.4 -0.61,-0.29 -0.44,-0.39 -0.45,-0.54 -0.09,-0.34 0.39,-0.71 0.05,-0.41 -0.13,-0.34 -0.35,-0.15 -1.85,-1.13 -0.71,-0.26 -0.89,-1.13 -1.06,-0.56 -0.76,-1.35 -0.53,-0.31 -0.04,-0.31 0.52,-1.57 0.09,-0.62 0.59,-0.25 0.59,-0.07 0.74,-1.84 2.1,-2 11.86,-3.35 0.67,-0.95 1.89,-1.27 0.8,-0.85 0.46,-0.92 0.17,-1.29 -0.3,-2 -0.77,-1.8 -0.47,-0.64 0.59,-0.42 0.49,-0.79 -0.13,-0.31 -0.04,-0.44 0.1,-0.76 -0.06,-0.47 -0.17,-0.33 -0.23,-0.25 -0.21,-0.27 -0.08,-0.4 0.2,-0.58 1.96,-0.97 2.42,-0.12 1.64,-0.85 0.19,-2.3 -0.31,-2.21 0.11,-0.92 0.65,-0.43 0.98,-0.26 2.33,0.31 z\"\r\n                        title=\"Lorestan\" />\r\n                    <path\r\n                        d=\"m 181.96043,293.7144 0,0 2.48,-0.53 1.64,4.07 1.83,0.98 2.95,-0.2 3.39,1.29 1.41,1.91 -0.73,1.12 -0.91,3 0.13,1.18 0.56,2.43 5.1,8.09 1.06,2.69 0.83,1.08 0.84,0.61 0.49,0.56 1.6,0.52 0.56,0.56 0.45,1.06 0.92,3.33 1.02,2.4 1.04,1.65 1.68,1.54 0.66,1.15 2.88,3.11 0.99,2.21 -0.1,1.85 -1.84,2.31 -1.21,2.34 -2.26,3.02 -4.05,3.64 -2.61,1.1 -1.15,0.88 -0.86,1.14 -0.56,1.29 0.03,2.31 1.54,5.59 0.1,1.6 -0.17,0.59 -0.15,1.18 -0.34,1.29 0.23,0.97 5.78,-0.77 1.36,1.76 2.65,2.63 3.23,1.72 1.91,1.39 0.58,2.08 -1.96,4.61 0.24,2.04 1.08,1.23 0.64,2.61 0.58,6.16 -5.23,-0.27 -1.95,-0.95 -3.49,0.58 -2.18,1.09 -0.89,-0.35 -1.22,-0.14 -1.26,0.19 -1.23,0.43 -10.63,6.81 -1.23,0.52 -1.09,-0.24 -0.95,-1.4 -0.09,-0.63 -0.01,-1.77 -0.26,-0.68 -0.25,-0.35 -0.09,-0.22 -0.12,-0.16 -0.37,-0.22 -0.33,-0.14 -0.32,-0.08 -0.73,-0.05 -0.36,0.04 -0.73,0.18 -0.41,0.05 -0.38,-0.08 -0.49,-0.37 -0.28,-0.08 -0.7,0.11 -1.27,0.54 -0.7,0.15 -0.88,-0.07 -0.32,-0.34 0.04,-1.61 -0.1,-0.12 -0.47,-0.34 -0.14,-0.23 -0.02,-0.21 0.02,-0.59 0.05,-0.29 0.14,-0.25 -0.01,-0.25 -0.41,-0.27 -0.2,0.66 -0.35,0.66 -0.49,0.46 -0.58,0.08 -0.61,-0.38 -0.29,-0.5 -0.36,-0.39 -0.59,-0.06 -0.79,-0.27 -2.24,-1.32 -0.46,-0.43 -0.22,-1.27 -0.6,-0.79 -0.89,-0.46 -1.08,-0.28 0.36,-0.65 0.56,-0.15 1.39,0.24 0.72,-0.04 1.12,-0.38 0.62,-0.1 0.69,0.17 1.38,0.74 0.48,0.17 0.75,0.07 0.57,0.24 0.46,0.42 0.44,0.61 0.2,-0.53 0.64,-1.14 1,-1.29 0.19,-0.42 0.03,-0.67 -0.7,0.14 -0.5,-0.32 -0.32,-0.61 -0.26,-1.44 -0.4,0.19 -0.53,0.57 -0.53,0.4 0.05,-0.5 0.05,-0.14 0.13,-0.17 -0.28,-0.44 -0.29,0.07 -0.34,0.26 -0.47,0.11 -0.21,-0.14 -0.37,-0.54 -0.23,-0.12 -0.22,0.04 -0.32,0.18 -0.17,0.05 -0.68,-0.11 -0.61,-0.18 -0.57,-0.03 -0.58,0.32 -1.21,-0.18 -0.97,0.61 -0.24,0.8 0.91,0.4 1.08,0.22 0.84,0.54 0.27,0.7 -0.68,0.69 -0.57,-0.01 -1.83,-0.26 -0.39,0.12 -1.85,1.73 -0.14,0.18 -0.3,0.47 -0.17,0.49 0.39,0.35 -0.14,0.28 -0.22,0.31 -0.12,0.21 0.25,0.84 0.6,0.61 0.68,0.52 0.56,0.61 0.28,0.7 0.22,0.88 0.19,1.76 -0.07,0.5 -0.3,0.8 -0.09,0.44 0.02,0.42 0.19,0.74 0.02,0.45 -0.21,0.77 -0.45,0.7 -0.61,0.49 -0.7,0.2 -2.3,-0.27 -0.59,0.27 -0.66,-0.31 -2.37,0.02 -1.43,-0.8 -0.55,-0.12 -0.09,0.68 0.16,0.46 0.46,0.74 0.09,0.54 -0.1,0.39 -0.25,0.33 -0.31,0.28 -0.29,0.19 -0.77,0.24 -2.49,-0.24 0,-0.27 -0.18,0.24 -0.04,0.1 -0.23,-0.11 -1.05,-0.3 -0.51,-0.31 -0.47,-0.37 -0.22,-0.22 -0.15,-0.26 -0.3,-0.76 -0.07,-0.51 -0.62,-1.95 -0.09,-0.06 -0.2,-0.41 -0.67,-0.76 -0.43,-0.91 -0.06,-0.27 0.07,-0.44 0.27,-0.32 0.32,-0.3 0.25,-0.33 0.09,-0.42 -0.07,-0.43 -0.17,-0.39 -0.22,-0.34 -1.32,-1.2 -1.09,-1.25 -0.69,-1.15 -0.31,-0.27 -0.41,-0.14 -0.43,-0.02 -1.24,0.21 -0.41,0.02 -0.4,-0.06 -0.37,-0.17 -0.27,-0.29 -0.15,-0.38 -0.28,-1.72 -0.31,-0.86 -0.43,-0.77 -0.57,-0.61 -0.35,-0.22 -0.37,-0.13 -3.59,-0.52 -0.05,-1.2 0,0 0.11,-18.98 -0.1,-0.51 -0.37,-0.22 -11.12,0 0.11,-9.56 0.09,-6.8 5.16,-14.07 0.2,-0.9 -0.09,-0.85 -0.47,-0.71 -1.33,-1.01 -0.55,-0.6 -0.12,-0.31 -0.17,-0.69 -0.19,-0.36 -0.26,-0.25 -0.61,-0.4 -0.23,-0.32 -1.22,-2.18 -0.16,-0.7 0,-0.01 -0.33,-0.7 -1.18,-0.58 -0.52,-0.6 -0.77,-1.74 -0.5,-0.72 0.9,-0.36 3.54,-2.33 1.21,-1.98 -0.4,-2.56 -0.06,-2.04 2.48,-3.43 3.11,-7.27 1.86,-2.71 4.62,-12.18 1.83,-1.4 8.36,-0.56 2.38,-0.74 3.6,-0.27 3.51,1.05 1.74,1.69 2.11,0.65 7.5,0.76 7.89,5.44 4.76,0.46 z\"\r\n                        title=\"Khuzestan\" />\r\n                    <path\r\n                        d=\"m 247.35043,358.8644 0,0 -1.16,-0.09 -2.19,0.42 -1.68,1.48 -1.84,0.96 -3.88,-0.51 -1.16,0.02 -12.6,-11.23 -1.04,-0.13 -1.78,0.1 -5.94,-2.39 -2.4,-1.47 1.21,-2.34 1.84,-2.31 0.1,-1.85 -0.99,-2.21 -2.88,-3.11 -0.66,-1.15 -1.68,-1.54 -1.04,-1.65 -1.02,-2.4 -0.92,-3.33 -0.45,-1.06 -0.56,-0.56 -1.6,-0.52 -0.49,-0.56 -0.84,-0.61 -0.83,-1.08 -1.06,-2.69 -5.1,-8.09 -0.56,-2.43 -0.13,-1.18 6.68,-3.61 2.31,0.3 1.21,-0.21 1.06,-0.53 1.51,-0.32 2.07,1.14 2.07,1.72 2.2,0.27 1.67,-0.38 1.04,0.36 1.54,-0.33 3.77,-2.47 1.33,-0.24 4.45,-0.14 1.4,-0.47 0.75,-0.82 1.46,-0.25 1.32,1.15 0.34,1.83 0.33,0.98 0.89,0.23 0.52,0.58 0.29,1.16 0.73,1.17 -0.19,2.91 0.34,3.14 4.3,3.35 1.79,1.81 3.93,2.98 1.77,3.22 0.62,4.15 -1.07,2.11 -1.35,0.94 -0.15,1.23 0.67,1.22 1.02,1.31 0.08,1.21 -1.43,0.63 -1.16,0.82 -0.2,2.13 0.76,4.53 3.09,10.25 -0.09,3.08 -0.34,1.37 z\"\r\n                        title=\"Chahar Mahall and Bakhtiari\" />\r\n                    <path\r\n                        d=\"m 450.32043,261.0144 0,0 8.66,-2.02 1.45,1.85 1.34,2.59 2.53,17.12 2.2,5.05 2.88,1.65 0.81,0.63 2.19,0.99 2.87,1.8 2.74,4.3 0.89,0.64 0.17,3.08 -0.28,1.25 -0.91,1.48 -0.58,1.44 0.24,0.89 0.52,0.93 0.99,1.13 0.06,1.21 1.03,2.25 1.36,2.25 -0.08,2.2 -0.77,2.23 -0.3,1.97 -0.56,1.87 -4.51,6.05 -1.25,3.49 -3.48,5.4 -1.77,4.57 -0.48,0.78 -36.34,-15.66 -4.32,-0.76 -0.73,1.11 -1.56,1.69 -7.04,3.99 -2.4,2.55 -17.98,9.5 -1.5,3.23 -0.44,12.48 -0.51,2.75 -5.74,2.53 -6.38,0.87 -2.78,-0.56 -4.33,-0.17 -19.03,3.38 -2.98,3.33 -1.57,2.98 -0.75,2.87 0.09,1.95 1.89,3.58 2,5.27 0.81,3.92 1.09,1.34 1.09,0.75 -0.43,12.7 0.36,2.22 0.47,1.56 0.04,1.11 -1.07,0.76 -3.42,0.42 -0.34,0.29 -1.49,0.66 -6.88,-3.5 -5.26,-3.96 -0.97,-2.34 -1.2,-8.58 -1.48,-2.62 -5.4,-6.64 -5.63,-10.08 -7.9,-20 -4.35,-5.3 -5.13,-4.72 -8.61,-3.32 -1.48,-5.85 -0.1,-2.76 0.36,-0.99 0.65,-4.83 1.42,-5.62 0.31,-2.57 -0.98,-12.32 0.26,-1.33 1.35,-0.9 2.43,-0.72 2.2,-1.25 1.49,-1.26 2.04,-1.3 3.27,-1.27 2.47,-0.09 10.72,2.47 35.84,-12.38 3.58,-2.04 1.87,-2.28 1.3,-2.46 1.1,-3.01 1.54,-6.78 1.82,-2.26 3.37,-1.81 2.63,-0.28 1.94,-1.36 2.89,-5.03 0.9,-2.88 -0.38,-27.64 0,-0.1 0.6,-0.27 3.11,-0.58 8.68,0.2 3.72,-1.93 12.18,-20.53 13.84,-3.62 13.46,-6.4 8.52,-2.2 3.77,0.99 9.88,7.59 1.16,2.61 -0.46,2.64 -3.28,3.22 -13.42,9.52 -2.31,4.17 -4.26,12.86 -0.28,6.91 2.11,11.75 1.59,2.51 6.72,0.81 z\"\r\n                        title=\"Yazd\" />\r\n                    <path\r\n                        d=\"m 274.35043,171.9044 0,0 2.33,-0.95 4.4,-5.33 3.11,-2.46 2.24,0.3 2.41,1.01 3.05,0.57 3.87,2.1 2.58,0.54 1.79,-0.25 1.09,-0.65 1.47,0.34 3.04,2.11 1.07,4.68 0.44,4.2 -1.09,3.74 -5.38,4.91 -3.36,1.8 -3.86,1.28 -2.74,-0.11 -7.63,-2.22 -2.58,-0.06 -2.47,-0.85 -6.18,-3.78 -1.87,-1.63 -2.02,-0.11 -0.73,-0.26 -0.41,-0.41 -0.63,-0.29 -0.56,0.6 -0.46,3.82 -0.64,2.5 -0.21,1.9 0.26,1.77 3.82,5.08 1.53,2.79 -0.42,2.55 -1.74,2.69 -1.03,3.32 -0.13,1.77 -19.31,-11.52 -8.13,-2.45 -9.73,-0.11 0,-0.11 2.93,-9.49 -0.02,-2.91 -0.87,-1.69 -1.57,-1.96 0.89,-2.07 2.19,-1.35 1.77,-2.18 0.96,-2.53 3.01,-0.17 0.41,-2.02 0.13,-2.7 2.05,-2.36 2.73,-1.01 2.74,0.33 1.91,-1.18 0,-2.36 0.11,-1.77 3.66,2.16 5.19,0.44 4.61,1.81 3.46,3.74 1.96,3.69 1.22,1.4 1.01,0.6 1.66,0.6 2.67,0.16 z\"\r\n                        title=\"Tehran\" />\r\n                    <path\r\n                        d=\"m 409.19043,113.5144 0,0 1.33,-0.23 1.65,0.69 -0.35,0.97 -1.98,0.59 -0.87,0.7 -0.21,0.63 0.22,0.34 0.21,0.45 0.17,1.12 -0.17,2.88 -0.64,2.53 -0.12,0.85 0.63,1.34 4.01,4.51 3.85,3.31 1.9,0.64 3.23,0.55 1.68,0.65 5.16,-0.87 0.67,-0.19 1.08,0.04 1.37,0.82 0.83,3.32 -0.91,3.93 -1.37,2.62 -0.5,4.58 0.64,7.87 1.1,5.06 0.92,2.35 8.03,6.57 2.22,2.56 -0.52,2.91 -5.89,10.15 -1.44,3.35 -1.03,0.81 -7.15,2.69 -3.85,2.3 -4.37,4 -5.44,6.75 -12.18,20.53 -3.72,1.93 -8.68,-0.2 -3.11,0.58 -0.6,0.27 0,0.1 -0.31,-0.4 -0.83,-0.72 -1.86,-0.61 -80.82,2.43 -1.76,-0.28 -14.42,-4.76 -2.31,-0.36 -9.28,0.59 -3.31,-0.55 -6.55,-3.55 1.13,-1.62 1.49,-3.5 0.91,-3.61 0.09,-3.36 -0.45,-1.65 0.13,-1.77 1.03,-3.32 1.74,-2.69 0.42,-2.55 -1.53,-2.79 -3.82,-5.08 -0.26,-1.77 0.21,-1.9 0.64,-2.5 0.46,-3.82 0.56,-0.6 0.63,0.29 0.41,0.41 0.73,0.26 2.02,0.11 1.87,1.63 6.18,3.78 2.47,0.85 2.58,0.06 7.63,2.22 2.74,0.11 3.86,-1.28 3.36,-1.8 5.38,-4.91 1.09,-3.74 -0.44,-4.2 -1.07,-4.68 0.5,-0.22 3.43,-0.38 1.6,-0.45 2.15,-1.24 1.76,-0.6 1.1,0.61 1.69,-0.23 2.59,-0.84 2.4,-1.3 1.47,-1.31 0.8,-1.12 0.42,-1.05 0.78,-1.15 3.47,-3.1 1.34,-1.55 0.54,-3.38 0.75,-2.54 1.2,-2.33 2.54,-2.56 2.82,-1.66 3.41,-1.02 6.63,-0.12 2.65,0.43 2.36,-0.53 4.78,-2.26 2.09,-2.28 5.74,-4.5 5.92,-3.41 2.88,-0.34 12.11,1.66 1.71,-0.81 1.13,-2.92 0.67,-4.64 2.8,-6.23 6.3,-9.73 1.4,-1.15 5.12,6.83 2.41,1.7 z\"\r\n                        title=\"Semnan\" />\r\n                    <path\r\n                        d=\"m 328.44043,127.8244 0,0 0,0 0.05,0.55 0.38,1.05 1.18,2.05 7.48,4.53 3.58,3.7 1.38,2.11 -3.41,1.02 -2.82,1.66 -2.54,2.56 -1.2,2.33 -0.75,2.54 -0.54,3.38 -1.34,1.55 -3.47,3.1 -0.78,1.15 -0.42,1.05 -0.8,1.12 -1.47,1.31 -2.4,1.3 -2.59,0.84 -1.69,0.23 -1.1,-0.61 -1.76,0.6 -2.15,1.24 -1.6,0.45 -3.43,0.38 -0.5,0.22 -3.04,-2.11 -1.47,-0.34 -1.09,0.65 -1.79,0.25 -2.58,-0.54 -3.87,-2.1 -3.05,-0.57 -2.41,-1.01 -2.24,-0.3 -3.11,2.46 -4.4,5.33 -2.33,0.95 -2.67,-0.16 -1.66,-0.6 -1.01,-0.6 -1.22,-1.4 -1.96,-3.69 -3.46,-3.74 -4.61,-1.81 -5.19,-0.44 -3.66,-2.16 -2.2,-2.6 -5.55,-1.23 -1.42,-0.62 -1.29,-1.19 -0.61,-0.89 -2.16,-0.86 -5.59,-1.11 -0.04,-0.84 -0.39,-1.14 -5.49,-4.19 -1.87,-1.02 -9.03,-7.62 1.76,-1.15 2.08,-3.71 0.74,-3.51 1.36,-1.35 1.76,-0.95 1.16,-1.6 0.33,-1.08 0.02,-0.14 0,0 1.61,1.09 0.71,0.17 0.47,0.21 1,1.09 0.5,0.43 5.34,2.92 4.88,3.46 2.84,1.3 9.45,1.88 6.04,1.75 6.26,1.13 6.03,1.75 6.27,-0.83 5.57,-2.05 5.82,-1.44 6.03,-1.15 5.78,-1.18 5.8,-1.73 5.59,-1.73 11.24,-2.53 1.52,-0.25 13.33,-0.76 2.43,-0.59 1.65,-1.39 -0.08,1.61 -1.91,0.67 -2.41,0.3 -1.55,0.48 -0.43,0.21 -0.48,-0.07 -0.91,-0.29 -0.51,0.08 -0.93,0.37 -0.53,0.11 -1.98,-0.27 -1.74,0 0.27,0.48 0.47,0.15 1.12,-0.05 -0.68,0.23 -0.27,0.03 0.82,1.1 1.39,0.61 0.14,0.02 z\"\r\n                        title=\"Mazandaran\" />\r\n                    <path\r\n                        d=\"m 405.42043,74.5244 0,0 4.84,-0.89 1.37,0.18 0.17,0.07 0.22,3.01 -0.22,1.22 0.09,1.56 0.41,1.8 -0.03,1.02 -0.69,2.77 0.07,1.94 1.15,1.37 1.6,0.79 1.38,1.06 0.63,2.61 -1.86,2.6 -3.97,1.38 -0.91,0.14 -1.02,0.46 -1.03,0.95 -2.46,1.02 -2.47,4.4 -1.03,1 -1.4,1.15 -6.3,9.73 -2.8,6.23 -0.67,4.64 -1.13,2.92 -1.71,0.81 -12.11,-1.66 -2.88,0.34 -5.92,3.41 -5.74,4.5 -2.09,2.28 -4.78,2.26 -2.36,0.53 -2.65,-0.43 -6.63,0.12 -1.38,-2.11 -3.58,-3.7 -7.48,-4.53 -1.18,-2.05 -0.38,-1.05 -0.05,-0.55 0,0 5.12,0.45 0.53,0.3 0.58,0.21 4.24,-1.17 0.4,-0.33 0.23,-0.71 0.02,-4.38 -0.19,-0.72 -0.5,-0.29 -0.64,-0.26 0.1,-0.62 0.77,-1.44 -0.81,-1.25 -0.54,-1.56 -0.75,-3.59 -1.03,-2.78 -0.15,-0.6 -0.32,-3.61 9.24,0.81 0.67,-0.04 0.61,-0.26 0.63,-0.6 0.63,-0.42 0.73,-0.04 0.79,0.1 0.74,0 1.21,-0.4 5.73,-3.33 0.77,-0.12 2.06,0.45 0.75,-0.01 0.51,-0.24 0.83,-0.9 0.67,-0.27 0.42,-0.4 1.61,-1.06 0.86,-0.72 0.16,-0.31 0.1,-0.65 0.46,-1.07 0.11,-0.61 0.04,-1.03 -0.04,-0.3 -0.16,-0.28 -0.39,-0.36 -0.12,-0.23 -0.04,-0.9 0.56,-1.33 0.15,-0.85 0.18,-0.68 0.44,-0.71 1.02,-1.11 5.09,-3.51 1.58,-1.78 0.26,-0.44 0.18,-0.59 0.41,-0.22 0.48,-0.08 0.36,-0.14 0.25,-0.33 0.37,-0.78 0.29,-0.33 0.65,-0.22 1.96,-0.38 0.42,-0.16 0.3,-0.68 0.74,-0.41 1.54,-0.52 0.39,-0.06 0.7,-0.57 0.7,-0.36 2.51,-1.95 0.83,-0.34 2.15,-0.09 6.69,-1.41 1.01,0 2.1,0.46 1.32,0.77 0.5,0.17 1.72,0.02 0.57,0.18 0.92,0.49 0.48,0.15 0.52,0.03 z\"\r\n                        title=\"Golestan\" />\r\n                    <path\r\n                        d=\"m 286.04043,345.0244 0,0 2.52,-0.01 11.56,-3.35 0.06,0 8.61,3.32 5.13,4.72 4.35,5.3 7.9,20 5.63,10.08 5.4,6.64 1.48,2.62 1.2,8.58 0.97,2.34 5.26,3.96 6.88,3.5 -0.01,0.77 0.93,3.09 2.75,5.71 0.38,1.5 0.74,1.3 0.81,0.83 1.51,0.96 7.76,0.72 1.97,0.84 6.85,17.02 1.95,5.89 0.01,1.09 -1.11,0.81 0.18,1.82 10.18,9.89 0.9,2.42 -0.4,4.32 -1.71,6.27 -0.16,1.6 0.16,1.24 2.86,2.34 1.62,2.65 -0.21,2.17 -0.58,0.94 -0.77,0.55 -1.02,0.45 -1.96,-0.11 -3.1,0.8 -4.62,2.49 -1.32,2.1 -1.11,3.39 -1.96,1.87 -4.23,1.29 -9.03,-1.28 -3.09,0.72 -1.68,0.72 -1.6,-0.56 -2.06,-0.27 -9.04,0.83 -3.5,1.22 -1.5,1.83 -0.5,3.03 -0.71,2.09 -0.01,0.42 0.39,1.12 -0.92,1.48 -3.53,1.88 -10.36,-1.84 -0.87,0 -2.47,0.63 -0.59,-0.08 -0.57,-0.28 -2.86,-2.35 -1.25,-0.5 -7.55,-0.67 -2.48,-2.36 -0.93,-1.79 -6.77,-4.89 -4.34,-4.09 -4.47,-5.52 -4.59,-10.29 -2.55,-2.99 -1.13,-0.67 -1.5,-0.6 -0.85,-1.4 -4.96,-14.04 -0.78,-3.48 -15.2,-28.66 -3,-2.76 -2.7,-1.01 -2.18,-2.29 -2.39,-3.79 -1.82,-4.18 -2.27,-2.53 -4.65,-1.51 -7.48,-0.56 -1.93,-0.74 -2.07,-4.21 -1.7,-1.7 -0.91,-2.83 0,-2.01 0,-0.1 3.4,-0.84 5.68,0.35 1.44,-0.23 9.04,-5.29 0.72,-1.51 0.04,-2.03 -0.83,-1.39 -0.25,-0.86 0.47,-0.84 -0.07,-0.89 -1.07,-3 -0.56,-3.31 0.51,-0.59 2.76,0.69 3.88,1.89 0.86,0.19 0.76,0.96 1.26,0.77 3.59,0.93 1.88,-0.51 1.67,-0.99 0.86,-0.86 0.19,-0.39 -0.02,-1.88 -1,-4.92 2.57,-0.39 0.95,-0.31 -0.01,-1.27 -0.35,-2.34 0.27,-3.44 2.86,-7.16 0.69,-4.04 0.82,-2.7 -0.98,-2.68 -1.95,-1.49 -1.49,-0.28 -1.33,-0.51 -1.04,-1.06 -0.8,-1.87 0.13,-1.18 3.29,0.79 2.54,-0.36 4.56,-3.1 0.96,-0.43 0.66,-0.89 4.61,-2.54 0.59,0.09 0.52,1.08 0.32,3.68 1.57,1.42 7.54,1.67 z\"\r\n                        title=\"Fars\" />\r\n                    <path\r\n                        d=\"m 273.40043,226.7544 0,0 9.28,-0.59 2.31,0.36 14.42,4.76 1.76,0.28 80.82,-2.43 1.86,0.61 0.83,0.72 0.31,0.4 0.38,27.64 -0.9,2.88 -2.89,5.03 -1.94,1.36 -2.63,0.28 -3.37,1.81 -1.82,2.26 -1.54,6.78 -1.1,3.01 -1.3,2.46 -1.87,2.28 -3.58,2.04 -35.84,12.38 -10.72,-2.47 -2.47,0.09 -3.27,1.27 -2.04,1.3 -1.49,1.26 -2.2,1.25 -2.43,0.72 -1.35,0.9 -0.26,1.33 0.98,12.32 -0.31,2.57 -1.42,5.62 -0.65,4.83 -0.36,0.99 0.1,2.76 1.48,5.85 -0.06,0 -11.56,3.35 -2.52,0.01 -7.54,-1.67 -1.57,-1.42 -0.32,-3.68 -0.52,-1.08 -0.59,-0.09 -4.61,2.54 -0.66,0.89 -0.96,0.43 -4.56,3.1 -2.54,0.36 -3.29,-0.79 -0.13,1.18 0.8,1.87 1.04,1.06 1.33,0.51 1.49,0.28 1.95,1.49 0.98,2.68 -0.82,2.7 -0.69,4.04 -2.86,7.16 -0.27,3.44 0.35,2.34 0.01,1.27 -0.95,0.31 -2.57,0.39 -0.69,-0.67 -4.74,-3.42 -3.65,-3.89 -1.87,-4.85 -0.24,-2.64 0.34,-1.37 0.09,-3.08 -3.09,-10.25 -0.76,-4.53 0.2,-2.13 1.16,-0.82 1.43,-0.63 -0.08,-1.21 -1.02,-1.31 -0.67,-1.22 0.15,-1.23 1.35,-0.94 1.07,-2.11 -0.62,-4.15 -1.77,-3.22 -3.93,-2.98 -1.79,-1.81 -4.3,-3.35 -0.34,-3.14 0.19,-2.91 -0.73,-1.17 -0.29,-1.16 -0.52,-0.58 -0.89,-0.23 -0.33,-0.98 -0.34,-1.83 -1.32,-1.15 -1.46,0.25 -0.75,0.82 -1.4,0.47 -4.45,0.14 -1.33,0.24 -3.77,2.47 -1.54,0.33 -1.04,-0.36 -1.67,0.38 -2.2,-0.27 -2.07,-1.72 -2.07,-1.14 -1.51,0.32 -1.06,0.53 -1.21,0.21 -2.31,-0.3 -6.68,3.61 0.91,-3 0.73,-1.12 -1.41,-1.91 -3.39,-1.29 -2.95,0.2 -1.83,-0.98 -1.64,-4.07 -0.02,-0.39 0.21,-0.97 0.46,-0.82 0.77,-0.5 2.7,-0.9 1.55,-1.17 0.61,-4.78 1.95,-2.3 5.03,-1.42 0.81,-0.48 0.07,-0.75 0.19,-0.95 3.43,-6.9 -0.09,-1.75 0.14,-2.2 0.76,-1.62 2.81,-2.34 5.38,-3.2 14.11,-3.72 2.12,-1.31 1.9,-1.61 2.13,-0.68 1.94,-0.01 0.91,-1.61 3.23,-7.83 0.4,-2.44 -0.96,-0.51 -0.71,-1.77 1.02,-8.04 0.4,-1.2 1.27,-1.28 3.23,-1.41 7.31,-0.84 2.62,0.14 11.42,-2.97 6.55,3.55 3.31,0.55 z\"\r\n                        title=\"Esfahan\" />\r\n                    <path\r\n                        d=\"m 214.02043,435.4644 0,0 -0.34,0.05 -0.34,-0.31 -0.33,-0.85 -0.21,-0.76 -0.25,-0.46 0.4,-0.25 0.37,0.16 0.61,0.27 0.36,0.22 -0.15,0.67 0.1,0.67 -0.22,0.59 z m 34.53,-12.42 0,0 2.18,2.29 2.7,1.01 3,2.76 15.2,28.66 0.78,3.48 4.96,14.04 0.85,1.4 1.5,0.6 1.13,0.67 2.55,2.99 4.59,10.29 4.47,5.52 4.34,4.09 6.77,4.89 -1.46,0.84 -0.46,0.17 -1.58,-0.07 -1.68,-0.43 -0.55,-0.02 -2.21,0.22 -0.37,-0.02 -0.69,0.3 -0.15,-0.02 -0.19,0.23 -0.55,1.07 0,0 -2.63,-1.17 -0.69,-0.73 -0.06,-0.78 0.32,-0.49 0.57,-0.25 0.7,-0.07 0.64,0.02 0.73,-0.08 0.42,-0.37 -0.3,-0.9 -0.54,-0.46 -1.37,-0.53 -0.51,-0.43 -0.27,-0.45 -0.55,-1.25 -0.23,-0.39 -2.54,-2.63 -1.11,-0.88 -1.24,-0.54 -6.04,-1.33 -1.27,-0.64 -4,-3.72 -1.24,-0.84 -1.4,-0.59 -1.61,-0.22 -2.35,0.29 -0.54,-0.17 -0.63,-0.4 -1.21,0.09 -1.31,0.31 -2.12,0.39 -1.33,-0.21 -2.93,-0.61 -0.4,-0.1 -0.17,-0.25 -0.04,-0.37 -0.11,-0.28 -0.18,-0.19 -1.06,-0.15 -1.44,-0.44 -0.73,-0.78 -0.77,-1.31 -0.82,-0.52 -0.26,1.07 -0.69,0.06 -0.67,-2.29 -0.66,-0.96 -0.52,-1.39 -1.28,-2.09 -0.58,-0.55 -0.7,-0.73 -0.17,-0.77 0.75,-2.07 -0.05,-1.02 -0.7,-1.14 -1.18,-1.07 -0.41,-0.5 -1.2,-1.86 -1.11,-1.19 -0.26,-0.39 -2.07,-5.13 -0.28,-1.21 -0.03,-4.91 -0.43,-1.67 -0.76,-1.42 -0.86,-1.02 -1.1,-0.68 -1.42,-0.34 -1.38,-0.07 -0.67,-0.19 -0.29,-0.41 -0.25,-0.76 -1.6,-2.02 -0.27,-0.73 -0.21,-1.07 0.13,-0.96 0.7,-0.41 0.66,0.23 0.67,0.56 0.56,0.7 0.33,0.64 0.35,-0.31 -0.04,-0.28 -0.15,-0.32 0.05,-0.43 0.24,-0.28 0.68,-0.61 0.23,-0.41 0.12,-0.84 -0.09,-0.9 -0.33,-0.56 -0.62,0.16 -0.29,-1.12 -0.23,-0.4 -0.41,-0.35 -0.2,0.04 -0.31,0.17 -0.29,0.09 -0.12,-0.17 -0.04,-0.66 -0.07,-0.32 -0.12,-0.21 -0.81,-0.14 -2.65,0.16 -0.61,0.11 -0.9,0.53 -0.94,-0.11 -0.75,-0.66 -0.3,-1.08 -0.06,-0.94 0.09,-0.48 0.31,-0.46 0.24,-0.53 0.22,-0.64 0.31,-0.29 0.51,0.55 0.15,-1.58 0.08,-0.27 -0.33,-0.11 -0.21,-0.23 -0.41,-0.75 0.24,-0.95 -0.01,-1.51 -0.17,-1.55 -0.27,-1.05 -0.44,-0.81 -0.66,-0.9 -0.52,-0.25 -0.02,1.16 -0.19,-0.43 -0.96,-1.45 -1.79,-1.48 -0.29,-0.5 -0.23,-0.67 -0.54,-0.75 -1.1,-1.12 -2.01,-0.81 -0.3,-0.4 -0.22,-0.78 -0.49,-0.74 -0.91,-1.02 -0.91,-1.32 -1.54,-2.82 -0.81,-1.19 -0.64,-0.56 -1.39,-0.86 -1.32,-1.36 -0.12,-0.18 -0.1,-0.47 -0.03,-0.72 -0.12,-0.41 0.53,-0.06 0.12,-0.23 -0.2,-0.29 -0.45,-0.22 0.36,-1.33 -0.77,-2.21 0.2,-1.03 -0.48,-0.37 -0.53,-0.72 -0.45,-0.79 -0.18,-0.65 -0.2,-0.41 -0.5,-0.34 -0.27,-0.11 -0.01,0 2.18,-1.09 3.49,-0.58 1.95,0.95 5.23,0.27 3.96,1.43 1.26,0.91 0.59,0.56 0,2.01 0.91,2.83 1.7,1.7 2.07,4.21 1.93,0.74 7.48,0.56 4.65,1.51 2.27,2.53 1.82,4.18 2.39,3.79 z\"\r\n                        title=\"Bushehr\" />\r\n                    <path\r\n                        d=\"m 220.02043,349.8844 0,0 1.78,-0.1 1.04,0.13 12.6,11.23 1.16,-0.02 3.88,0.51 1.84,-0.96 1.68,-1.48 2.19,-0.42 1.16,0.09 0.24,2.64 1.87,4.85 3.65,3.89 4.74,3.42 0.69,0.67 1,4.92 0.02,1.88 -0.19,0.39 -0.86,0.86 -1.67,0.99 -1.88,0.51 -3.59,-0.93 -1.26,-0.77 -0.76,-0.96 -0.86,-0.19 -3.88,-1.89 -2.76,-0.69 -0.51,0.59 0.56,3.31 1.07,3 0.07,0.89 -0.47,0.84 0.25,0.86 0.83,1.39 -0.04,2.03 -0.72,1.51 -9.04,5.29 -1.44,0.23 -5.68,-0.35 -3.4,0.84 0,0.1 -0.59,-0.56 -1.26,-0.91 -3.96,-1.43 -0.58,-6.16 -0.64,-2.61 -1.08,-1.23 -0.24,-2.04 1.96,-4.61 -0.58,-2.08 -1.91,-1.39 -3.23,-1.72 -2.65,-2.63 -1.36,-1.76 -5.78,0.77 -0.23,-0.97 0.34,-1.29 0.15,-1.18 0.17,-0.59 -0.1,-1.6 -1.54,-5.59 -0.03,-2.31 0.56,-1.29 0.86,-1.14 1.15,-0.88 2.61,-1.1 4.05,-3.64 2.26,-3.02 2.4,1.47 5.94,2.39 z\"\r\n                        title=\"Kohgiluyeh and Buyer Ahmad\" />\r\n                </clipPath>\r\n            </defs>\r\n            <circle clip-path=\"url(#iran-clip)\" cx=\"0\" cy=\"0\" fill=\"#003366\" id=\"expanding-circle\"\r\n                style=\"transition: r 3s ease\" />\r\n            <g class=\"provinces\" fill=\"white\" stroke=\"black\" stroke-width=\"0.5\">\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 230.09043,148.8044 0,0 5.59,1.11 2.16,0.86 0.61,0.89 1.29,1.19 1.42,0.62 5.55,1.23 2.2,2.6 -0.11,1.77 0,2.36 -1.91,1.18 -2.74,-0.33 -2.73,1.01 -2.05,2.36 -0.13,2.7 -0.41,2.02 -3.01,0.17 -0.96,2.53 -1.77,2.18 -2.19,1.35 -0.89,2.07 -1.56,0.14 -0.94,1.92 -0.96,0.2 -0.24,-1.39 0.01,-2.31 -1.31,-1.55 -1.91,-0.02 -0.43,1.12 1.31,1.82 0,0.7 -0.35,0.62 -0.85,-0.51 -1.95,-1.76 -3.32,-0.97 -3.42,-0.22 -1.46,-0.34 -0.73,-1.21 -0.86,-1.92 -0.28,-1.29 0.42,-1.63 1.86,-1.8 6.86,-3.35 1.16,-1.11 0.4,-1.54 1.63,-3.39 1.07,-3.62 -1.57,-1.35 -2.4,-0.72 -1.25,-1.07 -1.73,-2.38 0.98,-1.49 3.84,-0.31 8.06,0.86 z\"\r\n                        title=\"Alborz\" id=\"IR-32\" data-fa=\"البرز\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 468.28043,340.0844 0,0 38.55,17.43 4.85,3.63 13.52,19.71 -6.95,32.33 -0.3,3.24 0.8,0.85 1.53,1.01 1.35,3.42 1.17,8.21 -0.1,3.39 -1.03,3.84 -2.84,4.34 -0.49,2.5 0.49,2.57 0.04,3.17 1,2.09 0.35,1.5 -0.06,1.43 -0.99,1.08 -1.53,1.2 -7.88,4.59 -3.85,1.31 -1.96,1.05 1.26,1.95 2.78,2.11 1.21,1.95 -1.05,3.48 -3.91,5.11 0.23,13.28 -0.45,4.38 -3.9,15.31 0.01,3.77 0.82,3.2 0.12,1.42 -0.1,2.44 0.7,2.59 2.58,2.97 1.78,3.63 -0.96,2.88 -0.95,1.63 0.55,0.87 1.08,0.99 0.04,1.29 -1.09,1.3 -0.84,1.74 0.63,2.2 1.17,1.39 0.29,1.45 -0.54,1.45 -0.64,0.78 0.06,1.23 -0.46,0.61 -0.41,0.98 0.02,2.33 -0.2,1.4 -0.67,1.65 -1.38,-2.09 -0.49,-0.41 -0.93,0.01 -1.31,-0.52 -0.99,0.25 -1,1.05 -1.45,0.18 -1.68,-0.06 -1.4,-0.32 -0.57,-1.01 -0.1,-1.17 -0.34,-0.84 -0.08,-0.73 0.32,-0.7 0.05,-0.41 -0.64,-0.4 -2.11,-0.33 -1.3,-0.59 -1.19,-0.27 -1.17,0.55 -1.83,0.17 -2.78,-0.5 -4.49,0.32 -0.06,-0.77 0.69,-0.85 0.4,-2.11 0,-1.09 -0.19,-1.09 0.78,-7.39 0.47,-1.17 0.62,-0.76 0.19,-0.63 -0.05,-0.96 -0.82,-2.43 0.04,-0.76 0.73,0.04 2.12,1.29 0.29,-0.72 -0.97,-2.1 -1.99,-2.31 -2.53,-2.13 -2.33,-1.4 -2.23,-0.06 -1.39,0.95 -0.81,1.13 -1.6,1.5 -1.02,-0.32 -2.29,-1.69 -10.47,-5.56 -0.68,-2.21 -1.07,-14.26 -1.02,-2.99 -0.92,-1.88 -0.91,-0.46 -0.77,-1.11 0.59,-1.18 0.94,-0.79 -0.23,-1.92 -1.53,-2.33 -1.54,-1.69 -0.79,-1.52 -1.35,-1.76 -1.76,-0.96 -1.04,-0.13 -0.68,-0.57 -0.49,-0.81 -1.23,-5.97 0.3,-3.93 -0.27,-0.62 -3.53,-1.73 -1.84,-0.07 -1.56,1.23 -1.03,1.27 -3.67,3.49 -3.98,1.97 -2.17,0.39 -4.03,-0.62 -3.48,-2.11 -2.91,-2.68 -3.02,-3.91 -0.71,-3.76 0.84,-2.86 -0.65,-14.7 -0.95,-1.41 -1.02,0.13 -3.98,1.87 -6.77,5.14 -1.74,0.45 -1.52,-0.75 -1.48,-1.04 -1.48,-1.94 -3.03,-2.38 -6.12,-1.74 -2.87,-0.21 -6.85,-17.02 -1.97,-0.84 -7.76,-0.72 -1.51,-0.96 -0.81,-0.83 -0.74,-1.3 -0.38,-1.5 -2.75,-5.71 -0.93,-3.09 0.01,-0.77 1.49,-0.66 0.34,-0.29 3.42,-0.42 1.07,-0.76 -0.04,-1.11 -0.47,-1.56 -0.36,-2.22 0.43,-12.7 -1.09,-0.75 -1.09,-1.34 -0.81,-3.92 -2,-5.27 -1.89,-3.58 -0.09,-1.95 0.75,-2.87 1.57,-2.98 2.98,-3.33 19.03,-3.38 4.33,0.17 2.78,0.56 6.38,-0.87 5.74,-2.53 0.51,-2.75 0.44,-12.48 1.5,-3.23 17.98,-9.5 2.4,-2.55 7.04,-3.99 1.56,-1.69 0.73,-1.11 4.32,0.76 36.34,15.66 z\"\r\n                        title=\"Kerman\" id=\"IR-15\"  data-fa=\"کرمان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 596.00043,349.9544 0,0 1.86,0.27 0.88,0.35 0.66,0.53 1.21,1.54 0.24,0.74 -0.24,1.7 0.02,0.79 0.32,0.8 0.91,1.51 0.29,0.89 0.05,1.16 0.09,0.41 0.59,1.26 0.41,1.29 0.17,0.78 0,0.78 -0.24,0.83 -0.65,1.29 0.15,0.46 0.13,2.69 -0.2,0.12 -0.09,0.27 -0.05,0.72 0.05,0.04 0.08,0.21 -0.58,0.62 -2.79,3.38 -4.28,5.18 -3.88,4.7 0,0 -2.76,3.31 -3.66,4.39 -1.91,2.3 -2.8,3.35 -5.24,6.25 -0.01,0.01 -2.57,3.02 -1.96,2.3 2.74,3.24 1.79,2.13 2.21,2.65 2.55,3.06 2.65,3.18 2.79,3.33 0.66,0.54 0.71,0.29 0.6,0.42 0.31,0.99 -0.06,0.76 -0.41,1.36 0,0.76 0.33,0.79 1.07,1.19 0.44,0.67 0.1,0.43 0.09,0.97 0.18,0.44 0.36,0.41 0.31,0.11 0.31,0.04 0.37,0.2 0.34,0.55 0.18,0.66 0.26,0.56 0.58,0.25 0.33,0.26 0.1,0.34 -0.12,0.35 -0.31,0.33 -0.24,0.25 -0.1,0.24 0.08,0.22 0.26,0.21 0.44,0.2 0.38,0.3 0.3,0.4 1.43,3.3 0.19,0.75 0.08,0.65 0.18,0.58 0.97,1.09 0.97,2.13 0.99,1.21 3.49,3.18 1.41,1.83 2.15,2 1.07,1.24 0.62,0.34 2.03,0.57 1.62,0.93 1.02,0.33 2.25,0.19 1.08,0.23 2.82,1.27 4.47,0.9 0.94,0.49 0.4,0.47 0.29,0.51 0.34,0.47 0.55,0.31 0.57,0.19 0.35,0.22 0.24,0.39 0.22,0.67 0.49,0.83 2.14,2.32 0.68,0.44 5.54,-1.13 0.76,0.46 0.16,1.34 -0.5,3.95 -0.54,4.36 0.63,2.65 0.88,3.69 0.21,2.27 0.28,3.09 0.17,1.92 0.33,3.53 0.18,1.99 -0.21,1.58 -1.78,4.02 0.67,0.81 0.16,0.41 -0.06,0.62 -0.16,0.54 -0.2,0.43 -0.33,0.25 -0.54,0.04 1.46,1.3 0.51,0.28 0.27,0 0.47,-0.28 0.23,-0.04 0.28,0.09 0.79,0.44 1.07,0.24 0.92,-0.05 1.97,-0.4 0.88,-0.13 1.78,-0.55 0.9,-0.05 0.56,0.06 0.44,-0.01 1.85,-0.59 0.34,0.01 0.42,0.15 0.88,0.81 0.38,0.23 0.84,0.31 0.31,0.2 0.36,0.39 0.48,0.72 1.16,2.56 -0.59,-0.23 -0.74,0 -0.66,0.29 -0.37,0.62 -0.13,0.38 -0.36,0.52 -0.14,0.38 -0.05,0.44 0.17,4.3 0.31,0.71 0.42,0.62 0.28,0.61 -0.11,0.69 -0.5,0.46 -1.38,0.23 -0.56,0.29 -0.24,0.6 -0.27,5.5 -0.36,1.52 -0.76,0.74 -0.34,-0.01 -0.27,-0.14 -0.24,-0.17 -0.29,-0.14 -0.33,-0.03 -0.98,0.22 -1.34,-0.03 -1.32,-0.21 -3.06,-0.07 -2.66,-0.07 -2.3,-0.06 -0.37,0.11 -0.26,0.35 -0.35,0.64 -0.23,0.18 -0.25,0.13 -0.29,0.11 -1.05,0.24 -0.29,-0.02 -0.37,-0.18 -0.37,-0.08 -0.29,0.18 -0.27,0.28 -0.28,0.22 -0.69,0.25 -5.67,0.6 -0.32,0.09 -0.27,0.21 -0.27,0.49 -0.2,0.18 -0.35,0.1 -0.71,-0.04 -0.32,0.04 -0.28,0.12 -0.44,0.32 -0.27,0.16 -0.67,0.26 -0.29,0.19 -0.21,0.29 -0.07,0.33 0.11,0.25 0.12,0.21 0.04,0.23 -0.35,0.66 -1.07,1.05 -0.24,0.47 0.19,0.87 0.33,0.69 0.03,0.54 -0.74,0.39 -1.27,-0.18 -1.5,-0.53 -1.28,-0.17 -0.57,0.92 -0.12,0.92 -0.31,0.39 -1.4,0.24 -0.7,0.21 -0.63,0.32 -1.22,0.81 -4.08,1.16 -0.82,0.64 -0.49,1.02 -0.29,1.17 -0.31,2.29 -0.27,2.03 -0.32,2.34 -0.43,3.14 -0.36,2.63 -0.19,0.66 -0.51,0.63 -0.59,0.13 -0.65,-0.01 -0.72,0.17 -0.71,0.99 0.16,1.38 0.38,1.49 -0.1,1.3 -0.21,0.29 -0.5,0.5 -0.2,0.36 -0.11,0.54 -0.14,2.19 -0.21,3.21 -0.24,3.73 -0.2,3.16 -1.07,3.12 -0.01,0 -0.21,-0.54 -0.07,-0.63 -0.59,-0.43 -0.11,-0.23 -0.16,-0.11 -0.33,0.22 -0.1,0.21 -0.05,0.6 -0.1,0.23 0.19,0.18 0.33,0.39 0.19,0.17 -0.72,-0.08 -0.55,-0.22 -0.56,-0.01 -0.73,0.57 0.8,0.26 0.33,0.18 0.27,0.33 -0.18,0.36 -0.53,0.68 -0.15,0.4 0,0.19 -0.04,0.15 -0.27,0.26 -0.49,0.26 -1.84,0.55 0.49,0.34 -0.79,1.06 -5.7,-1.96 -1.98,-0.43 0.01,-0.61 -0.51,-0.93 -4.73,-1.69 -5.55,-0.93 -4.71,-1.12 -3.19,-0.39 -0.56,-0.31 0.52,-0.49 -0.82,-1.18 -0.1,-0.5 -0.01,-2.1 -0.11,-0.33 -1.23,-1.23 -0.53,-0.31 -0.59,-0.07 -0.61,0.06 -2.32,0.71 -0.58,0.33 -0.32,0.51 -0.53,0.64 -0.28,0.41 0,0.25 0.1,0.23 0.13,0.76 0.17,0.11 0.23,0.02 0.38,0.19 0.29,-0.01 0.14,0.1 0.14,0.23 0.35,0.39 -0.37,-0.06 0,0.09 0.98,0.5 -0.1,0.48 -0.39,-0.09 -1.09,-0.46 -1.38,-0.57 -0.68,-0.39 -1.47,0.03 -0.98,-0.8 0.32,-0.6 0.14,-0.15 -0.49,-0.22 -0.62,-0.09 -1.22,0.06 -0.94,0.18 -0.2,0.07 -0.3,0.35 0,0.21 0.09,0.19 0.7,0.48 -0.23,0.7 -0.92,-0.01 -0.68,-0.45 -0.37,-0.12 -1.16,-0.17 -0.26,-0.2 -0.38,-0.49 -0.53,-0.29 -1.25,0.08 -1.72,0.26 -1.82,0.07 -1.25,0.94 -1.42,-0.49 -1.42,-1.36 -1.53,-0.4 -3.91,0.24 -1.53,-0.01 -2.58,-0.6 -1.61,-1.64 -1.23,-0.68 -1.92,0.37 -4,0.64 -0.95,0.15 -0.15,-0.89 0.89,-0.39 0.02,-0.57 0.09,-0.6 -0.63,-0.31 -0.28,-0.37 -1.2,-2.05 -0.56,-0.56 -0.46,-0.6 -0.23,-0.77 -0.55,-0.68 -1.02,-0.39 -0.75,-0.76 -0.18,-1.36 -1.09,-1.8 -6.42,-5.68 -1.21,-0.76 -0.46,-0.2 -0.13,-0.68 0.16,-1.21 0.61,-0.93 0.41,-0.22 0.67,-1.65 0.2,-1.4 -0.02,-2.33 0.41,-0.98 0.46,-0.61 -0.06,-1.23 0.64,-0.78 0.54,-1.45 -0.29,-1.45 -1.17,-1.39 -0.63,-2.2 0.84,-1.74 1.09,-1.3 -0.04,-1.29 -1.08,-0.99 -0.55,-0.87 0.95,-1.63 0.96,-2.88 -1.78,-3.63 -2.58,-2.97 -0.7,-2.59 0.1,-2.44 -0.12,-1.42 -0.82,-3.2 -0.01,-3.77 3.9,-15.31 0.45,-4.38 -0.23,-13.28 3.91,-5.11 1.05,-3.48 -1.21,-1.95 -2.78,-2.11 -1.26,-1.95 1.96,-1.05 3.85,-1.31 7.88,-4.59 1.53,-1.2 0.99,-1.08 0.06,-1.43 -0.35,-1.5 -1,-2.09 -0.04,-3.17 -0.49,-2.57 0.49,-2.5 2.84,-4.34 1.03,-3.84 0.1,-3.39 -1.17,-8.21 -1.35,-3.42 -1.53,-1.01 -0.8,-0.85 0.3,-3.24 6.95,-32.33 1.06,-0.51 25.41,-7.22 1.85,0.33 1.19,1.27 0.77,0.62 3.14,0.86 4.17,3.08 5.33,7.61 2.78,2.38 4.6,-0.16 1.15,-0.45 0.53,-0.82 0.06,-1.22 -1.72,-7.64 -0.14,-3 0.7,-10.31 1.61,-5.8 2.17,-5.22 0.47,-4.78 -0.62,-2.31 5.75,0.85 6.64,0.97 3.9,0.57 z\"\r\n                        title=\"Sistan and Baluchestan\" id=\"IR-13\"  data-fa=\"سیستان و بلوچستان\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 456.82043,80.6944 0,0 0.54,-0.08 0.52,-0.16 0.58,-0.09 0.57,0.07 1.72,0.5 1.65,-0.03 0.51,-0.13 0.51,0 0.46,0.29 0.42,0.37 0.43,0.27 0.17,0.02 -4.11,2.54 -1.28,1.3 0.01,1.87 -0.39,1.59 -0.55,1.48 1.29,0.93 15.19,0.72 0.64,0.8 0.43,1.46 0.78,1.78 3.07,2.88 0.93,1.91 0.21,1.71 -0.75,1.37 -0.89,1.1 -0.31,0.74 -0.03,0.85 -0.34,1.26 -1.22,1.71 -2.03,6.01 -1.38,1.71 0.16,1.48 1.66,1.15 0.94,1.04 0.61,1.19 0.9,-0.14 0.49,-1.28 0.44,-0.2 0.29,1.09 0.68,1.04 1.12,0.54 0.13,0.98 -2.01,2.17 -0.22,1.18 0.44,0.67 1.21,0.72 0.28,1.32 -1.13,3.3 -1.27,1.2 -2.56,0.63 -9.38,-1.44 -22.43,-12.47 -5.4,-0.26 -8.16,6.63 -1.95,2.61 -0.27,1.92 0.26,1.5 -0.11,1.15 -5.16,0.87 -1.68,-0.65 -3.23,-0.55 -1.9,-0.64 -3.85,-3.31 -4.01,-4.51 -0.63,-1.34 0.12,-0.85 0.64,-2.53 0.17,-2.88 -0.17,-1.12 -0.21,-0.45 -0.22,-0.34 0.21,-0.63 0.87,-0.7 1.98,-0.59 0.35,-0.97 -1.65,-0.69 -1.33,0.23 -2.41,-1.7 -5.12,-6.83 1.03,-1 2.47,-4.4 2.46,-1.02 1.03,-0.95 1.02,-0.46 0.91,-0.14 3.97,-1.38 1.86,-2.6 -0.63,-2.61 -1.38,-1.06 -1.6,-0.79 -1.15,-1.37 -0.07,-1.94 0.69,-2.77 0.03,-1.02 -0.41,-1.8 -0.09,-1.56 0.22,-1.22 -0.22,-3.01 1.05,0.43 0.55,0.08 2.9,-0.49 0.53,-0.4 0.34,-0.67 0.12,-0.8 -0.16,-0.75 -0.92,-1.06 0.21,-0.59 2.14,-1.99 1.14,-0.8 1.23,-0.47 3.11,-0.1 0.57,0.14 0.48,0.29 0.42,0.34 0.46,0.21 0.54,-0.1 2.72,-1.19 1.62,-0.28 0.33,0.06 1.32,1.09 1.16,0.67 0.53,0.17 5.09,0.96 1.35,0.55 0.69,0.11 0.61,-0.34 0.47,-0.42 1.1,-0.74 0.4,-0.43 0.68,-1.19 0.1,-0.12 0.3,-0.32 0.59,-0.28 0.37,-0.05 0.37,0.05 0.72,0.24 0.38,0.25 0.09,0.28 0.02,0.32 0.14,0.38 0.78,1.33 0.61,1.49 0.4,0.6 1.11,1.2 0.39,1.29 0.73,1.03 0.16,0.76 -0.08,0.71 -0.67,2.27 0.86,1.15 4.87,1.94 z\"\r\n                        title=\"North Khorasan\" id=\"IR-31\"  data-fa=\"خراسان شمالی\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n\r\n                    <path\r\n                        d=\"m 467.11043,83.0344 0,0 0.55,-0.04 0.57,-0.13 0.55,-0.05 1.18,0.32 5.31,2.56 2.23,0.53 1.14,0.09 0.55,0.13 0.57,0.28 0.25,0.29 0.01,0.3 -0.08,0.3 0.03,0.34 0.54,1 0.12,0.32 0.08,0.78 0.01,0.59 0.16,0.49 0.58,0.48 0.58,0.22 2.64,0.4 0.42,0.2 0.9,0.64 0.47,0.13 3.07,-0.31 0.58,-0.28 0.46,-0.71 0.31,-0.72 0.41,-0.6 0.52,-0.38 0.66,-0.05 0.56,0.29 1.7,1.51 1.46,0.6 0.77,0.12 0.76,-0.08 0.29,-0.18 0.22,-0.26 0.24,-0.2 0.38,0 0.72,0.14 0.35,-0.03 0.36,-0.12 0.45,-0.56 0.08,-0.64 0.19,-0.29 2.03,1.13 2.63,0.61 1.33,0.61 0.48,0.35 0.45,0.15 0.98,0.15 0.38,0.2 1.11,1.15 4.51,3.27 0.73,0.07 1.9,-0.88 0.78,0.21 0.68,0.65 0.65,0.91 0.16,0.56 -0.1,0.95 0.2,0.46 0.09,0.36 -0.14,0.38 -0.21,0.42 -0.11,0.47 0.08,0.9 0.67,2.93 0.39,0.59 2.12,1.77 0.64,0.71 0.2,0.28 -0.04,0.21 -0.13,0.14 -0.04,0.12 -0.05,0.29 -0.1,0.35 0.1,0.3 0.56,0.15 0.22,0.23 0.27,0.22 0.29,0.14 0.28,0.02 1.07,-0.43 0.5,0.09 0.57,0.61 0.24,0.66 0.16,0.81 0.24,0.7 0.45,0.36 0.32,-0.07 0.24,-0.25 0.4,-0.63 0.32,-0.17 0.36,0.02 4.87,1.6 2.22,1.88 1.25,0.73 2.78,0.5 1.27,0.55 1,1.35 1.27,2.71 1.57,2.4 3.59,4.39 0.71,1.15 0.98,2.59 0.7,1.23 1.12,0.63 5.38,-0.1 4.74,-0.09 7.22,-0.13 4.02,-0.07 3.47,-0.06 1.68,0.29 1.38,0.19 0.28,1.44 0.28,0.65 0.12,0.39 0.06,0.53 -0.05,0.51 -0.13,0.47 -0.19,0.41 -0.21,0.32 -0.14,0.45 0.05,0.5 0.21,0.63 -0.73,3.39 -0.2,2.07 0.48,1.2 -0.1,0.17 -0.06,0.12 -0.09,0.29 0.33,0.14 0.27,0.21 0.21,0.26 0.14,0.25 0.13,0.44 0.06,0.44 0.02,0.97 0.11,0.41 0.49,0.82 0.51,2.61 0.09,1.26 0.05,0.21 -0.06,0.26 -0.36,0.47 -0.17,0.29 -0.1,0.37 -0.06,0.41 -0.02,0.39 -0.13,0.45 -0.28,0.21 -0.32,0.13 -0.21,0.19 -0.1,0.51 0.12,0.84 -0.02,0.39 -0.42,0.45 -0.69,0.56 -0.39,0.5 0.47,0.21 0.83,0.13 0.68,0.37 0.59,0.55 0.55,0.66 0.35,0.58 0.3,0.71 0.21,0.73 0.15,1.5 0.13,0.63 0.02,0.68 -0.22,0.93 0.22,0.31 0,0.41 -0.22,0.99 -0.02,0.23 0.02,0.74 -0.1,0.29 -0.46,0.46 -0.14,0.25 0.09,1.11 0.46,0.94 0.83,1.29 0.24,0.38 0.36,1.71 0.09,0.84 -0.21,0.86 -0.46,0.79 -0.79,0.97 -0.37,0.8 -0.3,1.3 -0.18,0.43 -0.71,0.96 -0.2,0.46 -0.16,0.85 0.16,2.14 -0.27,0.73 -0.65,0.38 -0.81,0.13 -0.72,0.02 -0.49,0.4 -0.2,0.89 -0.02,0.88 0.02,0.4 0.19,0.18 0.16,0.4 -0.01,0.4 -0.34,0.18 -0.2,0.19 0.17,0.41 1.21,1.63 0.09,0.18 -0.07,0.47 -0.09,0.36 0.06,0.34 0.35,0.38 -0.82,1.16 -0.24,0.59 -0.2,1.71 -0.5,1.55 -0.11,0.81 -0.11,0.39 -0.47,0.78 -0.11,0.52 0.03,0.42 0.15,0.77 0.03,0.36 -0.15,1.45 -0.27,1.37 -1.04,0.34 -0.19,0.69 -0.66,1.18 -1.07,0.84 -0.61,0.72 -0.05,0.97 0.12,1.06 -0.14,1.01 -0.35,0.47 -0.4,0.09 -0.44,-0.03 -0.47,0.07 -0.46,0.26 -0.22,0.28 -0.17,0.33 -1.54,1.76 -0.66,0.45 -0.84,0.24 -1.86,0.25 -0.84,0.43 -0.5,0.87 0.36,0.05 0.29,0.16 0.22,0.29 0.29,0.98 0.3,0.28 0.83,0.38 0.41,0.38 0.33,0.47 0.54,1.07 2.51,3.28 0.38,0.77 -2.52,0.14 -3.44,0.22 -2.39,0.14 0.23,0.87 -0.53,0.58 -1.61,0.86 -1.18,1.24 -1.07,1.39 -0.95,1.92 -0.21,1.83 0.06,0.55 -0.01,0 -2.64,0.45 -21.07,0.06 -4.45,-1.58 -3.32,-5.44 -1.82,-1.56 -3.53,1.32 -3.14,1.81 -10.05,1.49 -0.97,1.08 -0.92,0.67 -3.48,-1.06 -5.39,-0.69 -1.82,0.7 -0.49,1.17 0.19,1.07 1.32,2.14 -0.32,2.71 -0.71,3 0.36,1.8 -0.13,1.62 -0.87,2.09 -0.51,2.31 0.16,1.74 0.95,0.92 0.79,0.58 0.35,0.96 0.29,1.17 5.13,3.75 -1.01,1.87 -0.2,1.16 -1.69,2.71 -1.51,1.54 -10.64,7.07 -4.7,7.14 -1.12,4.78 -1.45,2.49 -0.85,1.02 -0.89,-0.64 -2.74,-4.3 -2.87,-1.8 -2.19,-0.99 -0.81,-0.63 -2.88,-1.65 -2.2,-5.05 -2.53,-17.12 -1.34,-2.59 -1.45,-1.85 -8.66,2.02 -6.72,-0.81 -1.59,-2.51 -2.11,-11.75 0.28,-6.91 4.26,-12.86 2.31,-4.17 13.42,-9.52 3.28,-3.22 0.46,-2.64 -1.16,-2.61 -9.88,-7.59 -3.77,-0.99 -8.52,2.2 -13.46,6.4 -13.84,3.62 5.44,-6.75 4.37,-4 3.85,-2.3 7.15,-2.69 1.03,-0.81 1.44,-3.35 5.89,-10.15 0.52,-2.91 -2.22,-2.56 -8.03,-6.57 -0.92,-2.35 -1.1,-5.06 -0.64,-7.87 0.5,-4.58 1.37,-2.62 0.91,-3.93 -0.83,-3.32 -1.37,-0.82 -1.08,-0.04 -0.67,0.19 0.11,-1.15 -0.26,-1.5 0.27,-1.92 1.95,-2.61 8.16,-6.63 5.4,0.26 22.43,12.47 9.38,1.44 2.56,-0.63 1.27,-1.2 1.13,-3.3 -0.28,-1.32 -1.21,-0.72 -0.44,-0.67 0.22,-1.18 2.01,-2.17 -0.13,-0.98 -1.12,-0.54 -0.68,-1.04 -0.29,-1.09 -0.44,0.2 -0.49,1.28 -0.9,0.14 -0.61,-1.19 -0.94,-1.04 -1.66,-1.15 -0.16,-1.48 1.38,-1.71 2.03,-6.01 1.22,-1.71 0.34,-1.26 0.03,-0.85 0.31,-0.74 0.89,-1.1 0.75,-1.37 -0.21,-1.71 -0.93,-1.91 -3.07,-2.88 -0.78,-1.78 -0.43,-1.46 -0.64,-0.8 -15.19,-0.72 -1.29,-0.93 0.55,-1.48 0.39,-1.59 -0.01,-1.87 1.28,-1.3 4.11,-2.54 0.12,0.01 0.55,-0.13 0.28,0.07 0.24,0.24 0.31,0.65 0.2,0.26 0.51,0.21 z\"\r\n                        title=\"Razavi Khorasan\" id=\"IR-30\" data-fa=\"خراسان رضوی\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 534.43043,242.0644 0,0 21.07,-0.06 2.64,-0.45 0.01,0 0.37,3.54 0.97,6.24 -0.07,1.6 -1.05,2.36 -0.27,1.34 0.84,2.97 2.14,2.05 2.73,1.14 2.65,0.2 2.49,-0.13 1.31,0.1 1.14,0.28 0.52,0.31 0.57,0.52 0.3,0.58 -0.03,0.06 -0.26,0.45 -0.5,0.18 -1.61,0.11 -0.6,0.4 -0.1,0.58 0.12,0.68 0.06,0.7 -0.18,0.81 -0.36,0.46 -1.11,0.7 -0.97,0.87 -1.29,1.75 -1.65,2.24 -1.84,2.49 -1.64,2.22 -0.21,0.57 0.05,3.2 0.5,2.58 0.97,3.31 1.14,3.9 1.18,4.02 1.25,4.24 1.38,4.65 1.49,5.56 1.15,4.29 -0.07,3.26 -0.46,3.18 -0.2,0.67 -0.89,1.14 -0.26,0.62 0.12,0.24 0.28,0.17 0.2,0.22 -0.29,0.88 0.07,0.41 0.17,0.39 0.13,0.43 0.06,0.87 -0.25,2.46 0.07,1.93 0.47,3.69 -0.43,2.94 0.08,0.93 0.51,1.92 0.4,3.73 1.12,0.47 3.42,0.5 5.68,0.84 0.05,0 0.62,2.31 -0.47,4.78 -2.17,5.22 -1.61,5.8 -0.7,10.31 0.14,3 1.72,7.64 -0.06,1.22 -0.53,0.82 -1.15,0.45 -4.6,0.16 -2.78,-2.38 -5.33,-7.61 -4.17,-3.08 -3.14,-0.86 -0.77,-0.62 -1.19,-1.27 -1.85,-0.33 -25.41,7.22 -1.06,0.51 -13.52,-19.71 -4.85,-3.63 -38.55,-17.43 0.48,-0.78 1.77,-4.57 3.48,-5.4 1.25,-3.49 4.51,-6.05 0.56,-1.87 0.3,-1.97 0.77,-2.23 0.08,-2.2 -1.36,-2.25 -1.03,-2.25 -0.06,-1.21 -0.99,-1.13 -0.52,-0.93 -0.24,-0.89 0.58,-1.44 0.91,-1.48 0.28,-1.25 -0.17,-3.08 0.85,-1.02 1.45,-2.49 1.12,-4.78 4.7,-7.14 10.64,-7.07 1.51,-1.54 1.69,-2.71 0.2,-1.16 1.01,-1.87 -5.13,-3.75 -0.29,-1.17 -0.35,-0.96 -0.79,-0.58 -0.95,-0.92 -0.16,-1.74 0.51,-2.31 0.87,-2.09 0.13,-1.62 -0.36,-1.8 0.71,-3 0.32,-2.71 -1.32,-2.14 -0.19,-1.07 0.49,-1.17 1.82,-0.7 5.39,0.69 3.48,1.06 0.92,-0.67 0.97,-1.08 10.05,-1.49 3.14,-1.81 3.53,-1.32 1.82,1.56 3.32,5.44 4.45,1.58 z\"\r\n                        title=\"South Khorasan\" id=\"IR-29\"  data-fa=\"خراسان جنوبی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 -4.99,-2.73 -1.22,0.34 0.6,1.67 1,1.3 0.4,0.89 -0.01,1.05 -2.41,0.82 -0.97,0.95 -1.11,0.5 -1.05,-0.29 -1.6,-3.33 -0.78,0.08 -1.77,1.99 -0.53,1.05 2.36,3.5 3.65,8.17 1.66,2.03 1.39,0.87 1.93,1.92 0.93,3.83 -0.67,3.09 -1.19,1.91 -1.13,0.99 -0.73,-0.39 -1.09,-2.68 -0.63,0.16 -0.38,1.16 -1.23,0.67 -2.08,0.59 -1.03,0.56 -1.05,0.04 -1.46,-0.22 -5.2,-5.88 -3.88,-1.76 -1.33,-1.15 -0.99,-0.08 -0.36,0.79 0.61,1.23 -0.11,1.4 -1.16,1.07 -4.85,0.32 -0.35,0.8 -0.21,2.69 -0.68,0.39 -1.33,-0.09 -2.11,0.21 -2.04,2.13 -1.42,0.48 -0.44,0.91 0,1.19 -0.72,0.83 -1.11,0.18 -0.66,0.89 -0.16,1.36 -1.3,0.69 -2.29,0.33 -3.06,-0.36 -2.03,0.22 -1.12,-1.23 -0.04,-1.63 0.27,-1.21 -0.14,-0.87 -0.77,0.06 -1.45,-1.01 -8.14,-11.14 -6.44,-5.08 -0.94,-0.32 0.08,-0.17 -0.25,-1.22 -0.81,-0.94 -1.87,-1.68 -2.17,-3.48 -0.44,-1.2 -0.01,-0.38 0.08,-0.34 0.18,-0.27 0.27,-0.21 0.13,-0.16 0.05,-0.17 -0.05,-0.18 -0.13,-0.17 -0.38,-0.79 -0.3,-0.85 0.16,-0.04 0.16,0 1.04,0.32 0.09,-0.58 -0.33,-1.6 0,-0.69 0.12,-0.73 0.27,-0.66 0.43,-0.47 0.7,-0.25 2.37,0.07 0.69,-0.16 1.7,-0.9 1.33,0.07 0.71,-0.08 0.53,-0.51 0.46,-0.68 1.03,-0.66 0.53,-0.48 0.4,-0.69 0.07,-0.65 -0.25,-0.56 -0.57,-0.4 -0.73,-0.07 -0.6,0.3 -0.58,0.4 -0.65,0.24 -1.43,0.31 -0.73,0.03 -0.68,-0.29 -0.28,-0.23 -0.21,-0.23 -0.14,-0.29 -0.17,-0.85 -0.16,-0.15 -0.25,-0.04 -1.04,-0.4 -0.56,-0.01 -0.55,0.2 -0.65,0.38 -0.68,0.22 -2.16,-0.1 -1.09,0.38 -0.35,-0.04 -0.34,-0.11 -0.35,-0.01 -0.82,0.7 -0.65,0.33 -0.7,0.05 -0.55,-0.38 -0.38,-0.08 -1.28,0.39 -0.61,-0.17 -0.41,-0.55 -0.87,-2.16 -1.57,-2.23 -1.01,-0.93 -0.92,-0.17 -0.44,-0.28 -1.25,-1.16 -1.3,-0.48 0,0 0.02,-0.02 1.14,-0.7 1.33,-1.33 0.56,-1.37 1.88,-2.14 0.46,-2.04 0.75,-0.77 0.39,-0.67 1.02,-1.11 5.51,-1.78 1.63,-2.48 0.05,-2.03 0.75,-0.97 2.96,-1.18 8.52,1.22 17.52,-1.62 0.4,0.33 0.24,0.51 0.48,0.64 0.68,0.57 0.58,0.64 1.3,0.9 3.51,0.97 3.84,0.34 2.56,-1.13 1.43,-1.66 0.58,-1.16 0.18,-0.66 -0.24,-0.69 0.14,-0.83 1,-0.61 0.83,-0.26 0.98,0.99 17.06,3.4 0.12,0.18 1.07,1.19 0.23,0.45 0.13,0.81 0.33,0.94 0.38,0.82 0.32,0.47 -0.35,0.33 -0.07,0.37 0.21,1.02 -0.05,0.29 -0.14,0.26 -0.11,0.28 0.04,0.31 0.14,0.06 0.59,0.07 0.64,2.37 0,4.26 -0.75,3.07 -1.33,1.4 -0.56,1.51 0.47,1.11 9.32,5.68 0.62,0.58 0.67,1.14 0.3,0.9 z\"\r\n                        title=\"Kordestan\" id=\"IR-16\"  data-fa=\"کردستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 164.84043,58.6444 0,0 0.1,3.8 -0.39,1.26 0.24,0.92 0.07,2.28 0.64,1.59 0.47,5.27 1.4,5.01 -0.27,0.83 -0.03,0.97 0.15,0.93 0.26,0.66 1.19,1.95 0.01,0.45 -0.1,0.38 -0.05,0.31 0.35,1.68 0.71,1.61 1.71,2.58 2.28,2.38 2.48,1.78 5.46,2.85 2.54,0.85 13.01,1.77 1.4,-0.22 1.16,-0.47 1.09,-0.2 1.21,0.62 -0.32,0.06 -0.38,-0.11 -0.2,-0.03 -0.26,0.35 2.82,1.1 4.41,1.02 1.59,0.61 1.07,1.02 -0.14,1.54 0.3,0.59 0.44,1.54 0.31,0.62 0.49,0.76 0.8,2.3 1.01,1.68 1.19,1.14 2.44,1.85 1.68,2.03 0.51,0.31 0.66,0.19 2.13,1.45 0,0 -0.02,0.14 -0.33,1.08 -1.16,1.6 -1.76,0.95 -1.36,1.35 -0.74,3.51 -2.08,3.71 -1.76,1.15 -4.6,-0.46 -2.81,0.63 -0.75,0.4 -0.7,0.24 -6.36,3.46 -1.68,0.3 -3.13,-0.63 -0.73,-0.5 -1.04,-0.18 -1.73,0.07 -4.65,-1.39 -2.06,-1.94 -1.91,-2.43 -0.43,-1.35 -0.06,-0.71 -3.21,-1.55 -2,-6.96 -1.44,-2.33 -3.76,-3.97 -5.1,-3.26 -0.37,-1.05 -0.29,-2.23 0.15,-1.86 -0.03,-1.22 -1.14,-1.45 -2.16,-1.71 -1.87,-1.93 -5.62,-8.86 -3.11,-8.63 0.07,-2.35 1.08,-1.68 0.3,-2.28 0.7,-1.66 7.65,-9.11 0.3,-0.79 -0.52,-0.56 -1.28,-0.29 -0.82,-0.33 -0.19,-0.81 -0.7,-0.92 -1.08,-0.96 -0.2,-0.45 1.56,0.13 0.82,-0.23 0.91,-0.39 0.86,-0.54 0.67,-0.68 0.76,-0.41 1.08,0 2.19,0.46 z\"\r\n                        title=\"Gilan\" id=\"IR-19\"  data-fa=\"گیلان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 88.71043,209.5144 0,0 0.77,-0.06 0.14,0.87 -0.27,1.21 0.04,1.63 1.12,1.23 2.03,-0.22 3.06,0.36 2.29,-0.33 1.3,-0.69 0.16,-1.36 0.66,-0.89 1.11,-0.18 0.72,-0.83 0,-1.19 0.44,-0.91 1.42,-0.48 2.04,-2.13 2.11,-0.21 1.33,0.09 0.68,-0.39 0.21,-2.69 0.35,-0.8 4.85,-0.32 1.16,-1.07 0.11,-1.4 -0.61,-1.23 0.36,-0.79 0.99,0.08 1.33,1.15 3.88,1.76 5.2,5.88 1.46,0.22 1.05,-0.04 0.02,0.63 -0.18,1.15 -1.12,1.29 -1.34,3.02 -1.59,2.35 -3.39,0.39 -1.08,0.43 -0.49,0.64 0.33,1.64 1.72,1.4 2.49,1.36 1.11,0.22 0.92,0.49 0.5,1.7 0.86,1.31 2.89,-3.02 1.56,-0.69 0.78,-0.17 0.65,0.99 0.34,1.67 -0.37,2.72 0.08,1.91 -1.03,0.85 -3.8,-0.81 -3.36,0.24 -1.24,1.9 -0.59,1.15 -2.33,-0.31 -0.98,0.26 -0.65,0.43 -0.11,0.92 0.31,2.21 -0.19,2.3 -1.64,0.85 -2.42,0.12 -1.96,0.97 -0.2,0.58 0.08,0.4 0.21,0.27 0.23,0.25 0.17,0.33 0.06,0.47 -0.1,0.76 0.04,0.44 0.13,0.31 -0.49,0.79 -0.59,0.42 -0.56,-0.17 -1.15,-0.1 -5.43,1.26 0,1.25 0.93,1.39 0.5,1.03 -0.47,2.64 -0.71,1.39 -5.31,-0.24 -5.76,1.47 -3.96,-0.32 -8.5,-2.75 -2.49,-2.16 -2.27,-1.4 -2.74,-0.63 -2.73,-0.2 -5.07,-2.08 -5.25,0.66 -2,-0.06 -0.62,0.73 0.47,1.56 -0.37,2.63 -1.29,4.06 -0.72,5.9 -0.76,0.64 -0.12,-0.31 -1.6,-1.15 -0.51,-0.51 -0.47,-0.67 -0.33,-0.66 -0.24,-0.72 -0.14,-0.82 -0.25,-0.68 -0.44,-0.49 -0.52,-0.44 -0.46,-0.5 -3.01,-5.5 -0.07,-0.06 -0.07,-0.03 -0.08,-0.01 -1,0.15 -0.88,-0.05 -0.77,-0.44 -0.7,-0.98 0.72,-0.33 0.33,-0.23 0.28,-0.29 0.01,0 0,0 0.51,-1.14 0.29,-1.04 0.38,-0.91 0.83,-0.72 0.49,-0.54 1.37,-1.12 0.35,-0.47 0,-0.45 -0.2,-0.35 -0.25,-0.36 -0.16,-0.47 0.07,-0.37 0.48,-0.78 0.16,-0.37 0.46,-1.97 0.06,-1.01 -0.18,-0.93 -0.52,-0.8 -0.7,-0.45 -0.76,0 -0.67,0.55 -0.63,-0.47 -0.43,-0.89 -1.05,-3.37 0.33,-0.54 1.78,-0.4 0.24,-0.23 0.22,-0.26 0.2,-0.29 0.16,-0.33 0.04,-1.22 -0.28,-1.66 0.14,-1.13 1.32,0.39 1.16,0.62 1.05,0.25 2.33,0.18 0.74,0.27 0.2,-0.05 0.14,-0.26 0.09,-0.44 0.01,-0.44 -0.1,-0.27 -0.38,-0.53 -0.1,-0.7 -0.02,-0.77 -0.11,-0.78 -0.14,-0.29 -0.17,-0.2 -0.17,-0.25 -0.1,-0.44 -0.12,-0.33 -0.25,-0.3 -0.3,-0.24 -0.28,-0.16 -0.51,-0.57 0.26,-0.67 0.94,-1.08 0.11,-0.48 -0.08,-0.83 0.11,-0.49 0.33,-0.47 0.43,-0.18 0.96,-0.1 0.94,-0.66 0.17,-1 -0.07,-1.05 0.23,-0.8 0.78,-0.03 0.61,0.32 0.4,0.21 0.91,0.32 0.52,-0.69 0.26,-1.01 0.28,-0.75 0.09,-0.78 -0.31,-1.07 0,0 -0.1,-0.57 0.01,-0.55 0.16,-0.47 0.36,-0.36 0.23,-0.07 0.47,-0.05 0.2,-0.11 0.07,-0.19 -0.09,-0.51 0.03,-0.19 0.47,-0.78 0.24,-0.09 0.5,0.17 0.71,0.46 0.35,0.15 0.44,-0.04 1.01,0.45 0.54,-0.14 0.5,-0.47 0.91,-0.55 0.34,-0.04 0.6,0.16 0.86,-0.28 0.42,-0.09 0.37,-0.19 0.27,-0.5 -0.7,-0.82 0.45,-1.17 0.74,-1.26 0.12,-1.09 -0.51,-0.43 -1.31,0.01 -0.47,-0.33 -0.09,-0.65 0.3,-0.53 0.42,-0.5 0.17,-0.42 0.94,0.32 6.44,5.08 8.14,11.14 1.45,1.01 z\"\r\n                        title=\"Kermanshah\" id=\"IR-17\"  data-fa=\"کرمانشاه\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 95.95043,37.9044 0,0 -1.57,-1.29 -0.7,0.05 -0.09,0.66 -0.02,1.27 -0.23,1.21 -0.46,0.41 -1.81,-0.44 -1.26,0.14 -0.34,0.62 -0.91,0.53 -1.36,1.8 -0.54,2.71 0.96,2.37 1.73,0.95 2.32,-0.83 2.32,-1.26 2.22,-0.63 5.07,1.44 1.42,-1.15 1.28,-1.75 2.12,-1.6 0.42,-0.55 -0.51,-0.19 -0.46,-0.71 3.88,-6.77 2.55,-1.73 1.38,0.12 2.28,-1.37 2.19,-1.96 1.34,0.5 -0.47,4.96 0.52,0.76 0.09,3.28 1.96,4.9 -0.36,2.9 -1.25,1.69 0.02,1.21 1.78,1.01 0.64,2.12 -1.65,1.13 -2.43,-0.39 -2.3,0.68 -1.42,1.54 -2.71,1.98 -1.07,2.01 -0.86,1.12 -0.69,1.58 -0.16,2.21 0.4,1.34 1.63,-0.64 2.16,-0.26 1.07,1.04 0.47,0.35 0.99,0.18 7.61,-1.12 2.36,1.18 1.01,3.16 0.21,3.42 1.71,4.24 2.67,3.66 2.27,2.09 0.35,0.77 -0.34,1.19 -0.77,1.63 -0.3,3.9 1.01,4.68 3.31,2.05 0.21,-0.13 0.76,0.15 2.49,1.3 0.9,0.79 0.27,3.09 0.88,2.08 2.08,1.38 0.72,0.74 1.54,1.26 -0.09,0.23 -0.17,0.64 0.26,0 0.3,-0.37 0.51,-0.18 1.15,-0.06 0.49,0.26 0.48,0.97 0.3,-0.04 0.47,0.25 0.47,0.17 -0.39,0.23 -1.19,0.95 -2.52,0.99 -8.1,-0.84 -2.2,0.36 -3.21,-0.49 -10.65,1.24 -1.2,0.5 -1.17,0.7 -1.85,2.01 -2.24,1.07 -1.01,0.74 -1.42,2.37 -5.13,5.22 -0.65,1.33 0.01,2.05 0.2,1.37 -8.04,0.93 -3.3,-0.45 -1.22,-1.77 0.03,-2.82 -1.34,-3.92 0.44,-0.63 -0.15,-0.9 -1.07,-0.92 -1.72,-0.39 -1.35,-0.83 -1.07,-1.09 -1.57,-0.26 -1.42,0.94 -0.93,0.88 -0.82,-0.08 -1.68,0.35 -2.03,1.33 -1.11,1.38 -0.5,1.19 -0.11,0.38 -0.55,0.88 -1,0.69 -1.57,-0.66 -1.46,-1.36 -4.21,-2.38 -0.57,-1.14 -4.7,-4.28 -3.62,-0.06 -4.4,-0.78 -9.89,-6.5 -1.28,-1.93 -0.46,-2.29 0.38,-5.3 -0.84,-1.95 -2.27,-2.74 -0.22,-0.78 -0.46,-0.85 -0.26,-0.67 0.14,-0.48 0.32,-0.27 0.32,-0.18 0.15,-0.23 -0.27,-2.57 -0.05,-0.18 -0.15,-0.34 -0.68,-0.92 -1.19,-11.58 0.02,-1.43 0.11,-0.22 0.13,-0.21 -0.05,-0.47 -0.21,-0.77 -0.22,-0.35 -0.27,-0.23 -0.2,-0.32 0,-0.59 -0.23,0 -2.15,-2.92 -0.45,-1.44 0.37,-1.87 1.91,-3.23 5.81,-6.03 1.27,-2.3 0.01,-2.15 -0.86,-2.29 -0.47,-2.48 0.99,-4.61 0.74,-1.81 3.74,-4 0.21,-0.21 0.54,0.14 0.69,0.41 0.16,0.03 0.26,0.06 0.94,0.03 1.93,0.48 3.01,0.03 1.74,0.68 0.78,0.3 7.13,1.51 2.24,1.02 1.97,0.5 0.33,-0.05 2.26,-0.3 0.59,-0.28 1.76,-1.28 0.66,-0.32 0.44,-0.11 1.32,-0.05 0.82,-0.27 0.36,-0.04 0.46,0.1 3.53,1.58 0.61,0.17 0.61,-0.04 0.73,-0.3 0.55,-0.34 0.52,-0.43 0.47,-0.53 0.39,-0.62 0.96,-1.98 0.45,-0.59 0.61,-0.52 1.97,-1 0.55,-0.54 0.57,-1.32 0.41,-0.65 0.27,-0.21 0.56,-0.31 0.27,-0.22 0.19,-0.27 0.87,-1.51 0.46,-0.54 0.51,-0.43 0.01,0 0.56,-0.26 0.54,-0.02 0.94,0.43 0.51,0.14 0.41,-0.08 2.03,-1.15 0.26,0.86 0.12,0.09 0.04,0.45 0.47,0.53 1.04,0.51 0.5,0.88 0.63,2.66 -0.13,0.87 -0.23,0.79 -0.69,0.96 -2.94,2.02 -2.11,0.29 -1.36,0.79 -1.48,0.28 z\"\r\n                        title=\"East Azarbaijan\" id=\"IR-01\"  data-fa=\"آذربایجان شرقی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n\r\n                    <path\r\n                        d=\"m 27.10043,6.0744 0,0 0.09,0.12 0.48,0.29 0.14,0.07 0.72,0.14 0.78,0.03 -0.1,0.2 -0.13,0.13 0.71,0.51 0.41,0.95 1.01,4.22 0.42,0.88 0.71,0.63 -0.28,0.53 0.12,0.32 0.86,0.62 0.18,0.04 0.37,-0.01 0.26,0.07 0.12,0.17 0.08,0.2 0.12,0.16 1.2,0.82 0.02,0.01 0.18,0.23 0.11,0.31 0.28,0.46 0.34,0.41 0.32,0.18 0.27,0.42 0.62,1.39 0.2,0.45 0.29,0.43 0.24,0.47 0.35,2.18 0.22,0.66 0.89,-0.28 3.52,1.17 0.09,-0.08 0.24,-0.16 0.3,-0.12 0.32,0.04 0.1,0.27 -0.09,0.41 -0.01,0.38 0.34,0.16 0.47,0.09 0.45,0.29 0.19,0.46 -0.29,0.65 0.23,0.44 0.29,0.22 0.31,0.19 0.32,0.34 0.14,0.34 0.27,0.94 0.17,0.37 0.32,0.24 0.81,0.36 0.16,0.3 -0.07,0.45 -0.14,0.36 -0.1,0.37 0.06,0.47 0.39,0.46 0.72,0.49 0.77,0.38 0.4,0.11 -0.21,0.21 -3.74,4 -0.74,1.81 -0.99,4.61 0.47,2.48 0.86,2.29 -0.01,2.15 -1.27,2.3 -5.81,6.03 -1.91,3.23 -0.37,1.87 0.45,1.44 2.15,2.92 0.23,0 0,0.59 0.2,0.32 0.27,0.23 0.22,0.35 0.21,0.77 0.05,0.47 -0.13,0.21 -0.11,0.22 -0.02,1.43 1.19,11.58 0.68,0.92 0.15,0.34 0.05,0.18 0.27,2.57 -0.15,0.23 -0.32,0.18 -0.32,0.27 -0.14,0.48 0.26,0.67 0.46,0.85 0.22,0.78 2.27,2.74 0.84,1.95 -0.38,5.3 0.46,2.29 1.28,1.93 9.89,6.5 4.4,0.78 3.62,0.06 4.7,4.28 0.57,1.14 4.21,2.38 1.46,1.36 1.57,0.66 1,-0.69 0.55,-0.88 0.11,-0.38 0.5,-1.19 1.11,-1.38 2.03,-1.33 1.68,-0.35 0.82,0.08 0.93,-0.88 1.42,-0.94 1.57,0.26 1.07,1.09 1.35,0.83 1.72,0.39 1.07,0.92 0.15,0.9 -0.44,0.63 1.34,3.92 -0.03,2.82 1.22,1.77 3.3,0.45 8.04,-0.93 4.69,10.52 -0.83,0.26 -1,0.61 -0.14,0.83 0.24,0.69 -0.18,0.66 -0.58,1.16 -1.43,1.66 -2.56,1.13 -3.84,-0.34 -3.51,-0.97 -1.3,-0.9 -0.58,-0.64 -0.68,-0.57 -0.48,-0.64 -0.24,-0.51 -0.4,-0.33 -17.52,1.62 -8.52,-1.22 -2.96,1.18 -0.75,0.97 -0.05,2.03 -1.63,2.48 -5.51,1.78 -1.02,1.11 -0.39,0.67 -0.75,0.77 -0.46,2.04 -1.88,2.14 -0.56,1.37 -1.33,1.33 -1.14,0.7 -0.02,0.02 0,0 -0.75,-0.28 -0.89,0.02 -1.12,0.56 -0.6,0.17 -0.01,0 0,0.01 -0.01,0 0,0 -0.67,0.46 -0.76,0.25 -0.72,-0.1 -0.6,-0.61 -0.01,0 0,-0.01 0,0 0,0 -0.22,-0.68 0.2,-0.86 0.42,-0.86 0.41,-0.67 0.14,-0.84 -0.43,-0.85 -1.05,-1.37 -0.17,-0.88 0.08,-1.93 -0.15,-0.81 -0.5,-0.49 -0.63,-0.49 -0.19,-0.51 0.82,-0.53 -0.64,-0.82 -0.23,-0.73 -0.09,-1.81 -0.16,-0.97 -0.36,-1.06 -0.6,-0.75 -0.86,-0.06 -1.89,0.75 -0.99,0.08 -0.92,-0.43 -0.39,-0.45 -0.12,-0.38 -0.06,-0.41 -0.16,-0.55 -0.27,-0.4 -0.29,-0.29 -0.22,-0.34 -0.03,-0.6 -0.44,-0.47 -0.53,-0.46 -0.12,-0.11 -0.49,-0.63 0.06,-0.67 0.15,-0.11 0.42,-0.16 0.11,-0.08 0.03,-0.89 0.36,-1.44 0.66,-1.53 0.05,-0.79 -0.36,-0.91 -0.82,-1.52 -0.5,-0.68 -0.57,-0.31 -0.44,-0.01 -0.4,-0.13 -0.35,-0.25 -0.31,-0.37 -0.42,-0.37 -0.49,-0.09 -1.05,0.06 -0.88,-0.2 -0.68,-0.45 -0.26,-0.74 0.36,-1.04 1.2,-1.48 0.47,-0.76 0.18,-1.02 -0.16,-0.95 -0.31,-0.69 -0.19,-0.75 0.19,-1.13 0.37,-0.47 0.05,-0.46 -0.22,-0.38 -0.74,-0.39 -0.39,-0.42 -0.23,-0.13 -0.33,0.01 -0.67,0.21 -0.31,-0.07 -0.16,-0.21 -0.17,-0.65 -0.13,-0.27 -0.25,-0.18 -0.25,-0.08 -0.24,-0.11 -0.2,-0.29 -0.27,-0.75 0,-0.41 0.46,-1.23 0.21,-0.82 -0.21,-0.72 -0.32,-0.72 -0.11,-0.86 0.24,-0.76 0.42,-0.36 0.47,-0.27 0.39,-0.52 0.11,-1.38 -0.77,-0.9 -1.95,-1.25 -0.28,-0.58 -0.2,-0.6 -0.31,-0.39 -1.23,0.19 -0.32,-0.36 -0.48,-1.22 -0.52,-0.39 -1.26,-0.12 -0.45,-0.26 -0.21,-0.7 0.45,-1.27 -0.14,-0.72 0,-0.01 -0.18,-0.87 0.07,-1.06 0.22,-1.05 0.31,-0.86 -0.14,-0.73 -0.76,-0.58 -0.68,-0.78 0.15,-1.29 0.28,-0.38 1.17,-0.95 0.35,-0.55 -0.08,-0.4 -1.24,-1.53 -0.85,-0.74 -0.95,-0.43 -0.92,0.1 -0.43,0.25 -0.54,0.19 -0.48,-0.05 -0.25,-0.48 0.03,-0.26 0.13,-0.68 -0.02,-0.22 -0.26,-0.2 -0.22,0.05 -0.23,0.08 -0.26,-0.08 -0.38,-0.49 -0.19,-0.53 -0.13,-0.49 -0.2,-0.4 -0.36,-0.26 -1.22,-0.59 -0.41,-0.12 -2.19,0.26 -1.18,-0.2 -0.59,-0.93 0.09,-0.33 0.05,-0.15 0.35,-0.44 0.3,-0.46 -0.03,-0.55 -0.17,-0.6 0.06,-0.55 0.21,-0.52 0.29,-0.55 0,-0.01 0,0 0,0 0.31,-0.62 0.82,-0.93 0.3,-0.66 0.28,-0.9 0.31,-0.55 0.45,-0.35 0.65,-0.32 0.19,-0.27 -0.28,-0.81 0.05,-0.37 0.28,-0.25 0.6,-0.25 0.25,-0.34 0.22,-0.63 0.21,-0.85 0.12,-0.83 -0.15,-2.07 0.96,-1.09 1.22,-0.96 0.76,-1.1 -0.01,-0.68 -0.26,-0.68 -0.42,-0.59 -0.48,-0.41 -0.53,-0.2 -0.43,0.09 -1.11,0.65 -1.69,-0.31 -0.5,-0.23 -0.31,-0.22 -0.1,-0.38 0.11,-0.71 0.02,-0.39 -0.11,-1.1 0.01,-0.51 0.43,-1.74 0.04,-0.75 -0.31,-2.2 0.15,-1.71 0.01,-0.9 -0.24,-0.72 -0.25,-0.28 -0.26,-0.17 -0.61,-0.2 -0.42,-0.22 0.1,-0.26 0.29,-0.3 0.15,-0.32 -0.17,-0.78 -0.16,-0.52 -0.07,-0.54 0.14,-0.87 0.92,-3.15 -0.17,-1.27 -1.79,-0.87 -0.55,-0.53 -0.46,-0.66 -0.33,-0.97 -0.14,-0.33 -0.12,-0.33 0.02,-0.37 -0.02,-0.39 -0.26,-0.27 -0.31,-0.24 -0.2,-0.31 -0.14,-0.67 -0.11,-0.3 -0.18,-0.3 0,-0.01 0.48,-0.81 0.54,-0.46 0.33,-0.52 -0.31,-1.71 0.17,-0.7 0.67,-1.32 -0.28,-1.07 -1.3,-0.93 -1.51,-0.8 -0.88,-0.67 -0.04,-0.38 0.24,-0.79 -0.03,-0.39 -0.41,-0.87 -0.11,-0.37 -0.02,-0.39 0.09,-0.29 0,-0.32 -0.4,-0.87 -0.2,-0.93 -0.14,-0.42 -0.01,-0.01 -0.89,-1.06 -0.2,-0.53 0.37,-0.53 0.69,-0.43 0.51,-0.19 0.53,-0.01 0.75,0.09 0.78,-0.08 1.84,-0.49 0.81,0.09 2.34,1.17 0.86,0.07 0.75,-0.18 1.75,-0.8 0.65,-0.48 0.57,-0.87 0.01,-0.79 -0.11,-0.83 0.16,-0.98 0,0 0.01,0 0.34,-0.52 0.02,-0.53 -0.12,-0.56 -0.06,-0.62 0.06,-0.72 0.16,-0.59 1.12,-2.27 0.2,-0.56 0.02,-0.17 0.07,-0.53 -0.18,-1.43 0.15,-0.5 3.6,-2.97 0.84,-0.25 0.52,0.37 0.91,1.39 0.47,0.53 2.02,0.95 0.66,0.56 2.75,2 z\"\r\n                        title=\"West Azarbaijan\" id=\"IR-02\"  data-fa=\"آذربایجان غربی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 189.74043,137.3244 0,0 1.73,-0.07 1.04,0.18 0.73,0.5 3.13,0.63 1.68,-0.3 6.36,-3.46 0.7,-0.24 0.75,-0.4 2.81,-0.63 4.6,0.46 9.03,7.62 1.87,1.02 5.49,4.19 0.39,1.14 0.04,0.84 -8.06,-0.86 -3.84,0.31 -0.98,1.49 1.73,2.38 1.25,1.07 2.4,0.72 1.57,1.35 -1.07,3.62 -1.63,3.39 -0.4,1.54 -1.16,1.11 -6.86,3.35 -1.86,1.8 -0.42,1.63 0.28,1.29 0.86,1.92 0.73,1.21 -1.01,-0.15 -2.02,0.12 -6.07,2.65 -1.56,0.09 -1.87,0.54 -1.75,0.87 -5.96,1.82 -1.42,1.06 -1.02,2.34 -5.94,0.16 -0.83,-0.58 -4.81,-1.22 -0.95,0.25 -4.34,-0.74 -2.31,-1.77 1.03,-1.57 -1.29,-1.62 -2.82,-1.62 -3.7,-0.07 -1.58,0.7 -2.52,-3.71 -4.3,-3.88 -0.1,-1.3 0.71,-0.47 1.06,-0.24 1.45,-0.05 1.23,-0.25 1.89,-1.4 3.07,-0.85 2.22,0.15 3.09,1.43 -0.05,-0.46 0.18,-1.66 2.07,-2.35 3.42,-1.94 6.18,-1.67 0.78,-1.14 -0.54,-4.45 -0.78,-1.74 -1.06,-1.76 -0.56,-2.08 -0.63,-1.15 -0.88,-0.5 -0.64,-0.69 -0.65,-0.36 -1.03,-0.07 -1.68,-0.84 -1.13,-1.71 -1.09,-2.74 -1.82,-2.27 -0.7,-2.67 1.38,-3.2 3.68,-2.46 2.76,-0.95 3.21,1.55 0.06,0.71 0.43,1.35 1.91,2.43 2.06,1.94 4.65,1.39 z\"\r\n                        title=\"Qazvin\" id=\"IR-28\" data-fa=\"قزوین\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 165.12043,111.4344 0,0 5.1,3.26 3.76,3.97 1.44,2.33 2,6.96 -2.76,0.95 -3.68,2.46 -1.38,3.2 0.7,2.67 1.82,2.27 1.09,2.74 1.13,1.71 1.68,0.84 1.03,0.07 0.65,0.36 0.64,0.69 0.88,0.5 0.63,1.15 0.56,2.08 1.06,1.76 0.78,1.74 0.54,4.45 -0.78,1.14 -6.18,1.67 -3.42,1.94 -2.07,2.35 -0.18,1.66 0.05,0.46 -3.09,-1.43 -2.22,-0.15 -3.07,0.85 -1.89,1.4 -1.23,0.25 -1.45,0.05 -1.06,0.24 -0.71,0.47 0.1,1.3 4.3,3.88 2.52,3.71 0.02,0.73 -1.24,1.7 -2.56,0.9 -2.85,-0.7 -2.97,-1.62 -7.27,-0.25 -1.52,-0.95 -1.14,-2.08 -0.3,-0.9 -0.67,-1.14 -0.62,-0.58 -9.32,-5.68 -0.47,-1.11 0.56,-1.51 1.33,-1.4 0.75,-3.07 0,-4.26 -0.64,-2.37 -0.59,-0.07 -0.14,-0.06 -0.04,-0.31 0.11,-0.28 0.14,-0.26 0.05,-0.29 -0.21,-1.02 0.07,-0.37 0.35,-0.33 -0.32,-0.47 -0.38,-0.82 -0.33,-0.94 -0.13,-0.81 -0.23,-0.45 -1.07,-1.19 -0.12,-0.18 -17.06,-3.4 -0.98,-0.99 -4.69,-10.52 -0.2,-1.37 -0.01,-2.05 0.65,-1.33 5.13,-5.22 1.42,-2.37 1.01,-0.74 2.24,-1.07 1.85,-2.01 1.17,-0.7 1.2,-0.5 10.65,-1.24 3.21,0.49 2.2,-0.36 8.1,0.84 2.52,-0.99 1.19,-0.95 0.39,-0.23 0.99,-0.27 1.39,0.51 2.53,2.7 1.05,-0.22 0.45,-0.76 0,-0.72 0.41,-0.73 0.65,-0.26 0.97,0.55 1.22,0.16 1.34,-0.92 1.19,-0.36 2.28,1.22 z\"\r\n                        title=\"Zanjan\" id=\"IR-11\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 142.88043,175.1144 0,0 1.14,2.08 1.52,0.95 7.27,0.25 2.97,1.62 2.85,0.7 2.56,-0.9 1.24,-1.7 -0.02,-0.73 1.58,-0.7 3.7,0.07 2.82,1.62 1.29,1.62 -1.03,1.57 2.31,1.77 4.34,0.74 0.95,-0.25 4.81,1.22 0.83,0.58 -0.02,0.99 0.29,1.48 0.8,1.06 -0.13,1.59 -1.14,1.27 -1.16,-0.21 -0.66,-0.95 0.04,-1.05 -0.08,-0.78 -0.92,0.07 -1.06,1.35 0.64,2.78 1.51,2.52 0.42,1.91 -1.63,1.91 -1.95,0.61 -1.03,0.11 -0.61,0.69 0.09,0.59 0.78,0.76 1.52,0.78 3.64,1 1.73,0.84 1.63,1.93 0.85,2.05 0.73,4.44 -0.82,1.67 -1.49,-0.14 -1.09,-1.01 -1.34,-1.59 -0.51,-1.88 0.72,-1.53 -0.82,-1.19 -2.93,-0.51 -6.16,0.33 -0.85,1.29 0.38,2.4 -0.4,1.46 -0.9,1.47 -0.12,2.89 0.58,3.18 -0.76,0.18 -1.57,-0.76 -3.49,-0.36 -1.18,0.47 0.49,1.16 1.71,0.68 0.58,2.59 0.27,4.33 2.4,4.73 0.54,2.24 0.19,2.24 0.62,2.64 -0.1,0.96 -0.6,0.82 -3.53,3.18 -9.24,-3.95 -2.22,0.25 -1.8,-0.11 -0.88,0.24 -1.78,1.84 -1.01,0.26 -1.25,-0.47 -7.52,-0.91 -14.54,-9.57 -0.7,-1.02 -1.45,-0.94 -0.85,-0.38 0.59,-1.15 1.24,-1.9 3.36,-0.24 3.8,0.81 1.03,-0.85 -0.08,-1.91 0.37,-2.72 -0.34,-1.67 -0.65,-0.99 -0.78,0.17 -1.56,0.69 -2.89,3.02 -0.86,-1.31 -0.5,-1.7 -0.92,-0.49 -1.11,-0.22 -2.49,-1.36 -1.72,-1.4 -0.33,-1.64 0.49,-0.64 1.08,-0.43 3.39,-0.39 1.59,-2.35 1.34,-3.02 1.12,-1.29 0.18,-1.15 -0.02,-0.63 1.03,-0.56 2.08,-0.59 1.23,-0.67 0.38,-1.16 0.63,-0.16 1.09,2.68 0.73,0.39 1.13,-0.99 1.19,-1.91 0.67,-3.09 -0.93,-3.83 -1.93,-1.92 -1.39,-0.87 -1.66,-2.03 -3.65,-8.17 -2.36,-3.5 0.53,-1.05 1.77,-1.99 0.78,-0.08 1.6,3.33 1.05,0.29 1.11,-0.5 0.97,-0.95 2.41,-0.82 0.01,-1.05 -0.4,-0.89 -1,-1.3 -0.6,-1.67 1.22,-0.34 4.99,2.73 z\"\r\n                        title=\"Hamadan\" id=\"IR-24\"  data-fa=\"همدان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 266.71043,208.9144 0,0 0.45,1.65 -0.09,3.36 -0.91,3.61 -1.49,3.5 -1.13,1.62 -11.42,2.97 -2.62,-0.14 -7.31,0.84 -3.23,1.41 -1.27,1.28 -0.4,1.2 -1.02,8.04 0.71,1.77 0.96,0.51 -7.81,-2.13 -3.49,-1.92 -8.74,-0.82 -2.24,-1.86 -1.57,-1.95 -0.82,-2.04 0.14,-1.68 -0.51,-1.21 -0.99,-1.17 -1,-0.61 -1.36,0.12 -1.23,-0.56 -1.5,-1.35 -1.83,-2.15 0.32,-2.12 3.16,-1.78 0.36,-0.83 -0.7,-0.99 0.05,-2.69 1.93,-1.57 3.05,0.42 2.95,-0.85 2.01,-1.33 4.2,-0.66 3.51,-1.19 0.62,-0.37 0.4,-1.59 0.6,-6.35 1.13,-3.23 0.96,-1.35 0,0.11 9.73,0.11 8.13,2.45 19.31,11.52 z\"\r\n                        title=\"Qom\" id=\"IR-26\"  data-fa=\"قم\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 226.55043,180.9344 0,0 0.96,-0.2 0.94,-1.92 1.56,-0.14 1.57,1.96 0.87,1.69 0.02,2.91 -2.93,9.49 -0.96,1.35 -1.13,3.23 -0.6,6.35 -0.4,1.59 -0.62,0.37 -3.51,1.19 -4.2,0.66 -2.01,1.33 -2.95,0.85 -3.05,-0.42 -1.93,1.57 -0.05,2.69 0.7,0.99 -0.36,0.83 -3.16,1.78 -0.32,2.12 1.83,2.15 1.5,1.35 1.23,0.56 1.36,-0.12 1,0.61 0.99,1.17 0.51,1.21 -0.14,1.68 0.82,2.04 1.57,1.95 2.24,1.86 8.74,0.82 3.49,1.92 7.81,2.13 -0.4,2.44 -3.23,7.83 -0.91,1.61 -1.94,0.01 -2.13,0.68 -1.9,1.61 -2.12,1.31 -14.11,3.72 -5.38,3.2 -2.81,2.34 -0.3,-0.33 -2.16,-1.17 -0.24,-1.16 0.05,-1.19 -0.73,-0.76 -1.09,-0.84 -0.54,-0.97 -0.76,-0.46 -1.18,0.85 -0.67,1.32 -0.22,1.05 -0.79,0.54 -1.05,-0.83 -1.16,-1.23 -2.55,-1.29 -1.1,-0.94 -0.32,-0.95 0.36,-1.21 0.54,-1.17 -0.04,-1.08 -0.92,-1.58 -1.48,-1.8 -1.86,-0.6 -1.7,0.98 -1.87,0.63 -1.5,0.87 -1.16,3.55 -0.64,0.68 -2.71,1.72 -0.93,-0.35 -3.82,-0.33 -2.24,-0.83 -1.73,-1 -0.44,-0.86 0.18,-0.98 0.28,-0.9 1.36,-3.13 -0.12,-0.93 -0.42,-1.1 0.24,-1.33 0.53,-0.87 3.53,-3.18 0.6,-0.82 0.1,-0.96 -0.62,-2.64 -0.19,-2.24 -0.54,-2.24 -2.4,-4.73 -0.27,-4.33 -0.58,-2.59 -1.71,-0.68 -0.49,-1.16 1.18,-0.47 3.49,0.36 1.57,0.76 0.76,-0.18 -0.58,-3.18 0.12,-2.89 0.9,-1.47 0.4,-1.46 -0.38,-2.4 0.85,-1.29 6.16,-0.33 2.93,0.51 0.82,1.19 -0.72,1.53 0.51,1.88 1.34,1.59 1.09,1.01 1.49,0.14 0.82,-1.67 -0.73,-4.44 -0.85,-2.05 -1.63,-1.93 -1.73,-0.84 -3.64,-1 -1.52,-0.78 -0.78,-0.76 -0.09,-0.59 0.61,-0.69 1.03,-0.11 1.95,-0.61 1.63,-1.91 -0.42,-1.91 -1.51,-2.52 -0.64,-2.78 1.06,-1.35 0.92,-0.07 0.08,0.78 -0.04,1.05 0.66,0.95 1.16,0.21 1.14,-1.27 0.13,-1.59 -0.8,-1.06 -0.29,-1.48 0.02,-0.99 5.94,-0.16 1.02,-2.34 1.42,-1.06 5.96,-1.82 1.75,-0.87 1.87,-0.54 1.56,-0.09 6.07,-2.65 2.02,-0.12 1.01,0.15 1.46,0.34 3.42,0.22 3.32,0.97 1.95,1.76 0.85,0.51 0.35,-0.62 0,-0.7 -1.31,-1.82 0.43,-1.12 1.91,0.02 1.31,1.55 -0.01,2.31 0.24,1.39 z\"\r\n                        title=\"Markazi\" id=\"IR-22\"  data-fa=\"مرکزی\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 133.80043,3.1044 0,0 0.46,0.12 0.66,0.45 2.07,1.95 5.69,6.85 2.32,2.15 0.96,1.31 0.75,1.59 -0.36,0.11 -0.88,0.29 -1.78,1.2 -2.12,0.43 -1.14,0.59 -0.98,0.94 -0.62,1.24 -0.07,1.51 0.46,1.17 0.83,1.17 1.92,1.88 1.94,0.8 0.51,0.5 1.02,2.2 0.18,0.55 -0.02,0.61 -0.16,0.59 0,0.02 -0.26,0.56 -0.31,0.46 -0.01,0 0,0 0,0.01 0,0 -1.39,0.87 -6.26,1.11 -0.11,0.28 0.01,0.33 -0.1,0.28 -1.78,1.1 -0.31,0.49 0.08,1.79 0.67,1.24 2.2,1.77 4.49,2.22 0.42,0.36 0.09,0.36 0.16,0.63 -0.14,0.85 0.06,0.73 1.65,1.32 0.53,0.79 0.61,0.58 1.04,0.03 1.72,-0.81 0.79,0 0.39,0.94 0.24,1.15 0.44,0.59 0.54,0.49 0.56,0.88 0.57,0.62 0.5,0.72 0.84,1.06 0.44,0.56 0.92,1.55 1.09,1.06 0.17,0.01 0.2,0.45 1.08,0.96 0.7,0.92 0.19,0.81 0.82,0.33 1.28,0.29 0.52,0.56 -0.3,0.79 -7.65,9.11 -0.7,1.66 -0.3,2.28 -1.08,1.68 -0.07,2.35 3.11,8.63 5.62,8.86 1.87,1.93 2.16,1.71 1.14,1.45 0.03,1.22 -0.15,1.86 0.29,2.23 0.37,1.05 -2.28,-1.22 -1.19,0.36 -1.34,0.92 -1.22,-0.16 -0.97,-0.55 -0.65,0.26 -0.41,0.73 0,0.72 -0.45,0.76 -1.05,0.22 -2.53,-2.7 -1.39,-0.51 -0.99,0.27 -0.47,-0.17 -0.47,-0.25 -0.3,0.04 -0.48,-0.97 -0.49,-0.26 -1.15,0.06 -0.51,0.18 -0.3,0.37 -0.26,0 0.17,-0.64 0.09,-0.23 -1.54,-1.26 -0.72,-0.74 -2.08,-1.38 -0.88,-2.08 -0.27,-3.09 -0.9,-0.79 -2.49,-1.3 -0.76,-0.15 -0.21,0.13 -3.31,-2.05 -1.01,-4.68 0.3,-3.9 0.77,-1.63 0.34,-1.19 -0.35,-0.77 -2.27,-2.09 -2.67,-3.66 -1.71,-4.24 -0.21,-3.42 -1.01,-3.16 -2.36,-1.18 -7.61,1.12 -0.99,-0.18 -0.47,-0.35 -1.07,-1.04 -2.16,0.26 -1.63,0.64 -0.4,-1.34 0.16,-2.21 0.69,-1.58 0.86,-1.12 1.07,-2.01 2.71,-1.98 1.42,-1.54 2.3,-0.68 2.43,0.39 1.65,-1.13 -0.64,-2.12 -1.78,-1.01 -0.02,-1.21 1.25,-1.69 0.36,-2.9 -1.96,-4.9 -0.09,-3.28 -0.52,-0.76 0.47,-4.96 -1.34,-0.5 -2.19,1.96 -2.28,1.37 -1.38,-0.12 -2.55,1.73 -3.88,6.77 0.46,0.71 0.51,0.19 -0.42,0.55 -2.12,1.6 -1.28,1.75 -1.42,1.15 -5.07,-1.44 -2.22,0.63 -2.32,1.26 -2.32,0.83 -1.73,-0.95 -0.96,-2.37 0.54,-2.71 1.36,-1.8 0.91,-0.53 0.34,-0.62 1.26,-0.14 1.81,0.44 0.46,-0.41 0.23,-1.21 0.02,-1.27 0.09,-0.66 0.7,-0.05 1.57,1.29 1.48,-0.28 1.36,-0.79 2.11,-0.29 2.94,-2.02 0.69,-0.96 0.23,-0.79 0.13,-0.87 -0.63,-2.66 -0.5,-0.88 -1.04,-0.51 -0.47,-0.53 -0.04,-0.45 -0.12,-0.09 -0.26,-0.86 0.23,-0.13 0.35,-0.42 0.18,-0.33 0.57,-1.66 1.22,-1.96 0.12,-0.44 0.33,-0.37 1.62,-1 3.37,-1.32 0.4,-0.22 1.01,-0.58 1.12,-1.15 0.01,0 1.68,-2.18 1.11,-0.93 1.41,-0.79 2.37,-0.81 0.76,-0.08 0.44,-0.3 1.79,-1.83 0.61,-0.34 4.08,-2.31 1.45,-1.49 0.53,-0.54 0.65,-0.45 0.81,-0.22 2.57,0.05 0.42,-0.11 0.35,-0.32 0.39,-0.59 0.02,0 z\"\r\n                        title=\"Ardebil\" id=\"IR-03\" data-fa=\"اردبیل\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 374.13043,563.2144 0,0 -0.27,0.23 -0.28,0.03 -0.19,0.11 -0.32,-0.3 -0.16,0.12 0.02,-0.23 -0.12,-0.23 -0.12,-0.37 0.49,-0.27 0.59,-0.15 0.16,0.26 0.04,0.37 0.16,0.43 z m -16.97,-1.33 0,0 -0.34,0.26 -0.46,-0.11 -0.54,-0.25 -0.14,-0.42 0.44,-0.24 0.81,-0.24 0.17,0.33 0.06,0.67 z m -0.91,-13.27 0,0 -0.19,0.04 -0.39,-0.13 -0.4,-0.21 -0.18,-0.22 -0.05,-0.49 -0.08,-0.38 -0.01,-0.35 0,0 0.14,-0.44 0.21,-0.29 0.28,-0.15 0.33,0.07 0.34,0.37 0.23,0.11 0.19,0.15 0.16,0.2 0.13,0.26 -0.71,1.46 z m -16.2,-9.15 0,0 -0.38,0.21 -2.5,-0.14 -0.26,-0.02 -1.09,-0.53 -0.69,-1.12 0.34,-0.53 0.5,-0.37 0.6,-0.19 0.66,0.03 0.57,0.2 1.26,0.13 0.48,0.19 0,0 0.06,0.17 0.03,0.08 0,0 -0.01,0.34 0,0 0,0.05 0.04,0.26 0,0 0.24,0.13 0.14,0.13 0.09,0.08 0.03,0.22 0.04,0.23 -0.08,0.23 -0.07,0.22 z m 62.36,-4.91 0,0 -0.69,0.4 -0.54,-0.3 0.08,-0.87 0.43,-0.85 0.55,-0.43 0.33,-0.06 0.26,0.4 0.07,0.89 -0.49,0.82 z m -75.53,-1.71 0,0 -0.44,0.44 -0.59,-0.08 -0.6,-0.3 -0.33,-0.47 0.27,-0.41 0.67,-0.03 0.35,0.09 0.4,0.19 0.27,0.57 z m -9.39,-5.09 0,0 -0.49,0.13 -1.3,-0.11 -0.4,0.09 -0.62,0.36 -0.65,0 -1.93,-0.34 -0.59,-0.25 -0.08,-0.05 -0.45,-0.29 -1.06,-0.89 -0.3,-0.35 0.13,-0.17 0.24,-0.05 0.27,-0.1 0.33,-0.02 2.85,0.88 2.54,0.19 0.79,0.31 0.44,0.4 0.28,0.26 z m 101.5,-1.35 0,0 -1.29,0.42 -0.64,-0.26 0.16,-1.01 0.48,-0.7 0.86,-0.39 1.28,-0.13 0.17,1.17 -1.02,0.9 z m -7.04,-2.59 0,0 -0.76,1.7 -0.39,0.66 -1.4,1.43 -0.22,0.51 -0.29,0.31 -1.29,0.65 -0.29,0.35 -0.29,0.19 -1.67,1.61 -0.99,0.58 -0.78,-0.33 -0.74,-0.75 -0.87,-0.69 -2.26,1.17 -0.63,0.54 -0.63,0.36 -0.72,-0.01 -1.54,-0.23 -0.69,0.16 -0.72,0.34 -1.83,1.31 -1.89,0.8 -1.15,0.85 -0.59,0.32 -2.09,0.24 -1.49,0.41 -0.63,0.39 -0.31,0.12 0,0 -0.1,-0.01 -0.19,-0.04 -0.38,-0.13 -0.34,0 -0.15,0.32 -0.15,0.26 -0.37,0.2 -0.42,0.13 -0.31,0.05 0,0 -0.14,-0.1 -0.13,-0.08 -0.17,-0.44 -0.16,-0.93 0.23,-0.67 0.06,-0.43 -0.18,-0.2 -0.34,-1.17 0.37,-0.4 1.59,0.57 0.37,-0.17 0.21,0.06 0.1,0.03 0,0 1.79,-1.01 4.53,-1.47 0.66,-0.08 0.42,-0.17 0.13,-0.05 0,0 1.57,-0.96 0.67,-0.55 2.22,-0.86 0.34,-0.03 0.71,0.06 0.34,-0.03 0.24,-0.11 0.35,-0.29 0.33,-0.12 -0.1,-0.25 -0.15,-0.26 0.52,-0.6 0.12,-0.71 -0.16,-1.7 -0.26,-0.65 -0.58,-0.55 -0.56,-0.44 -0.24,-0.3 0.86,-0.5 4.74,1.79 1.28,-0.3 3.57,-2.31 4.47,-1.02 1.33,-0.02 0.67,0.16 0.87,0.38 0.54,0.41 0.19,0.15 0.27,0.71 -0.54,0.32 -0.55,0.31 -2.09,0.54 -0.75,0.67 z m 10.52,-5.3 0,0 -0.53,0.09 -1.07,-0.41 0.07,-0.96 0.63,-0.87 0.6,-0.12 0.36,0.24 0.39,0.15 0.32,0.26 0.02,0.07 0.11,0.48 -0.13,0.49 -0.32,0.35 -0.24,0.12 -0.21,0.11 z m -30.81,-65.74 0,0 1.52,0.75 1.74,-0.45 6.77,-5.14 3.98,-1.87 1.02,-0.13 0.95,1.41 0.65,14.7 -0.84,2.86 0.71,3.76 3.02,3.91 2.91,2.68 3.48,2.11 4.03,0.62 2.17,-0.39 3.98,-1.97 3.67,-3.49 1.03,-1.27 1.56,-1.23 1.84,0.07 3.53,1.73 0.27,0.62 -0.3,3.93 1.23,5.97 0.49,0.81 0.68,0.57 1.04,0.13 1.76,0.96 1.35,1.76 0.79,1.52 1.54,1.69 1.53,2.33 0.23,1.92 -0.94,0.79 -0.59,1.18 0.77,1.11 0.91,0.46 0.92,1.88 1.02,2.99 1.07,14.26 0.68,2.21 10.47,5.56 2.29,1.69 1.02,0.32 1.6,-1.5 0.81,-1.13 1.39,-0.95 2.23,0.06 2.33,1.4 2.53,2.13 1.99,2.31 0.97,2.1 -0.29,0.72 -2.12,-1.29 -0.73,-0.04 -0.04,0.76 0.82,2.43 0.05,0.96 -0.19,0.63 -0.62,0.76 -0.47,1.17 -0.78,7.39 0.19,1.09 0,1.09 -0.4,2.11 -0.69,0.85 0.06,0.77 4.49,-0.32 2.78,0.5 1.83,-0.17 1.17,-0.55 1.19,0.27 1.3,0.59 2.11,0.33 0.64,0.4 -0.05,0.41 -0.32,0.7 0.08,0.73 0.34,0.84 0.1,1.17 0.57,1.01 1.4,0.32 1.68,0.06 1.45,-0.18 1,-1.05 0.99,-0.25 1.31,0.52 0.93,-0.01 0.49,0.41 1.38,2.09 -0.41,0.22 -0.61,0.93 -0.16,1.21 0.13,0.68 0.46,0.2 1.21,0.76 6.42,5.68 1.09,1.8 0.18,1.36 0.75,0.76 1.02,0.39 0.55,0.68 0.23,0.77 0.46,0.6 0.56,0.56 1.2,2.05 0.28,0.37 0.63,0.31 -0.09,0.6 -0.02,0.57 -0.89,0.39 0.15,0.89 0,0 -1.89,0.29 -1.93,0.92 -0.72,0.16 -0.28,-0.06 -0.25,-0.24 -0.25,-0.16 -0.29,0.07 -0.32,0.14 -0.31,0.09 -0.78,-0.04 -0.67,-0.14 -0.57,-0.24 -0.44,-0.37 -1.56,-2.51 -0.84,-1.01 -1.32,-0.61 -1.18,0.03 -0.31,-0.15 -0.21,-0.36 -0.12,-0.37 -0.19,-0.31 -0.38,-0.12 -2.91,0 -6.15,-1.12 -2.11,0.33 -1.81,-0.12 -0.64,-0.3 0.25,-0.6 -1,0.06 -1.08,0.22 -0.46,0.24 -0.78,0.65 -0.51,0.13 -0.24,-0.1 -0.11,-0.15 -0.17,0.01 -0.39,0.37 -0.27,0.19 -0.35,0.11 -0.3,-0.04 -0.12,-0.26 -0.2,0.09 -1.19,0.83 -1.25,0.2 -1.1,-0.22 -1.07,-0.34 -1.13,-0.18 -0.91,-0.42 -0.74,-1.01 -1.01,-2.16 -1.06,-1.27 -1.28,-0.31 -1.4,0.36 -1.37,0.71 -1.15,0.94 -0.75,0.47 -0.53,-0.01 0.14,-1.66 0.13,-0.43 0.09,-0.18 0.02,-0.14 -0.05,-0.29 -0.35,-0.86 -0.53,-0.47 -0.7,-0.18 -0.85,-0.03 -0.76,0.08 -1.88,0.43 -0.41,-0.08 -0.71,-0.35 -0.39,-0.08 -0.39,0.03 -0.67,0.18 -0.35,0.04 -0.84,-0.07 -2.31,-0.72 0.25,-0.23 -4.53,-0.3 -0.5,-0.27 -0.24,-0.59 -0.19,-1.84 -0.82,-1.91 -0.42,-1.52 -0.29,-0.72 -0.33,-0.31 -0.06,-0.14 -0.75,-0.91 -0.15,-0.03 -0.43,0.07 -0.14,-0.04 -0.06,-0.16 -0.09,-0.44 -0.46,-1.35 -0.14,-0.63 -0.33,-0.74 -0.07,-0.45 0.21,-0.78 1.06,-1.15 0.36,-0.76 -0.46,-1.2 -2.24,-2.48 0.18,-1.01 -0.25,-0.23 -0.19,-1.71 -0.24,-0.85 -0.38,-0.68 -0.65,-0.63 -0.16,-0.28 -0.1,-0.34 -0.12,-0.86 -0.01,-0.35 0.58,-4.72 -0.12,-1.77 -2.2,-8.8 -0.46,-0.68 -1.15,-1 -0.41,-0.6 0.04,-0.62 -1.04,-0.69 -0.35,-0.37 0.5,0.04 0.37,-0.15 0.34,-0.22 0.41,-0.19 -0.29,-0.25 -0.04,-0.36 0.12,-0.37 0.21,-0.31 -1.04,0.45 -0.35,0.07 -0.31,-0.08 -0.2,-0.18 -0.14,-0.18 -0.16,-0.08 -0.18,-0.13 -0.18,-0.25 -0.23,-0.16 -0.66,0.33 -0.2,-0.13 -0.09,-0.31 0.02,-0.39 -0.44,0.1 -0.23,-0.2 0.01,-0.28 0.32,-0.14 0.17,-0.13 0.59,-0.65 0.3,-0.24 0,-0.28 -1,-0.14 -0.81,-0.55 -0.54,-0.79 -0.22,-0.86 -0.39,0.39 -0.44,0.15 -0.91,0.01 -0.51,-0.17 -0.31,-0.36 -0.26,-0.37 -0.32,-0.16 -3.51,-0.05 -0.77,-0.24 -0.23,0.29 -0.82,-0.46 -1.02,-0.21 -2.11,-0.12 -1.01,-0.19 -1.77,-0.71 -1.05,-0.16 -2.1,0.12 -1.07,0.28 -0.78,0.53 -0.72,0.35 -2.21,0.1 -0.89,0.18 -0.28,0.19 -0.56,0.56 -0.11,0.18 -0.07,0.41 -0.19,0.12 -0.26,0.06 -0.29,0.19 -0.58,0.5 -2.28,1.38 -0.82,0.69 -0.01,0.16 -0.18,0.12 -0.62,0.54 -0.37,0.12 -1.51,0.18 -1.4,0.34 -0.36,0.04 -1.13,-0.04 -0.37,0.08 -0.51,0.36 -0.29,0.08 -1.27,0 -1.06,-0.25 -0.34,-0.01 -0.65,0.28 -1.13,1.06 -0.43,0.24 -0.38,0.29 -1.83,2.04 0.49,-0.16 0.21,-0.11 0.25,-0.25 0.13,0.93 -0.2,1.14 -0.4,1.08 -0.48,0.77 -1.11,0.98 -1.27,0.65 -1.42,0.29 -1.52,-0.09 -2.73,-0.95 -1.55,-0.2 -1.29,0.61 -0.4,0.72 -0.18,0.68 -0.33,0.5 -0.82,0.19 -0.67,0.08 -1.48,0.44 -0.51,0.24 -2.21,1.98 -0.38,0.24 -3.25,2.65 -3.68,2.15 -0.23,0.21 -0.22,0.25 -0.25,0.21 -0.35,0.09 -0.43,-0.08 -0.57,-0.34 -0.4,-0.08 -2.91,0.27 -1.49,-0.24 -0.57,-0.86 -0.42,-1.1 -0.99,-0.93 -1.52,-0.3 -3.08,0.12 -1.22,-0.6 -0.61,-0.97 -0.5,-1.21 -0.64,-1.16 -1.01,-0.82 -0.72,-0.14 -0.67,0.11 -0.66,0.19 -2.58,0.17 -0.71,-0.07 -2.32,-0.68 -0.59,-0.1 -0.36,-0.11 -0.65,-0.52 -0.28,-0.14 -0.35,-0.02 -0.7,0.15 -2.23,1.04 -1.56,0.22 -1.37,0.39 -0.75,0.03 -1.51,-0.49 -0.83,-0.07 -0.79,0.43 -0.42,-0.15 -1.76,-1.53 -2.55,-1.51 -3.29,-2.49 -0.48,-0.6 -0.2,-0.74 -0.08,-1.8 -0.27,-0.76 -0.58,-0.7 -1.08,-0.69 -11.52,-3.92 -0.74,-0.07 -0.72,-0.21 -0.46,-0.5 -0.35,-0.61 -0.43,-0.52 -2.02,-0.51 -0.31,-0.38 -0.29,-0.82 -0.69,-0.43 -1.56,-0.46 -2.73,-2.46 -1.2,-0.82 -1.81,-0.8 0.55,-1.07 0.19,-0.23 0.15,0.02 0.69,-0.3 0.37,0.02 2.21,-0.22 0.55,0.02 1.68,0.43 1.58,0.07 0.46,-0.17 1.46,-0.84 0.93,1.79 2.48,2.36 7.55,0.67 1.25,0.5 2.86,2.35 0.57,0.28 0.59,0.08 2.47,-0.63 0.87,0 10.36,1.84 3.53,-1.88 0.92,-1.48 -0.39,-1.12 0.01,-0.42 0.71,-2.09 0.5,-3.03 1.5,-1.83 3.5,-1.22 9.04,-0.83 2.06,0.27 1.6,0.56 1.68,-0.72 3.09,-0.72 9.03,1.28 4.23,-1.29 1.96,-1.87 1.11,-3.39 1.32,-2.1 4.62,-2.49 3.1,-0.8 1.96,0.11 1.02,-0.45 0.77,-0.55 0.58,-0.94 0.21,-2.17 -1.62,-2.65 -2.86,-2.34 -0.16,-1.24 0.16,-1.6 1.71,-6.27 0.4,-4.32 -0.9,-2.42 -10.18,-9.89 -0.18,-1.82 1.11,-0.81 -0.01,-1.09 -1.95,-5.89 2.87,0.21 6.12,1.74 3.03,2.38 1.48,1.94 1.48,1.04 z\"\r\n                        title=\"Hormozgan\" id=\"IR-23\"  data-fa=\"هرمزگان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 114.44043,243.3144 0,0 0.47,0.64 0.77,1.8 0.3,2 -0.17,1.29 -0.46,0.92 -0.8,0.85 -1.89,1.27 -0.67,0.95 -11.86,3.35 -2.1,2 -0.74,1.84 -0.59,0.07 -0.59,0.25 -0.09,0.62 -0.52,1.57 0.04,0.31 0.53,0.31 0.76,1.35 1.06,0.56 0.89,1.13 0.71,0.26 1.85,1.13 0.35,0.15 0.13,0.34 -0.05,0.41 -0.39,0.71 0.09,0.34 0.45,0.54 0.44,0.39 0.61,0.29 1.28,0.4 0.06,0.11 0.05,0.2 0.11,0.19 0.24,0.08 0.18,-0.04 0.17,-0.19 0.23,-0.04 0.26,0.06 0.19,0.15 0.16,0.19 1.68,1.28 0.6,0.28 0,0.53 0.62,0.63 0.86,0.53 1.44,0.35 4.16,2.1 0.36,0.42 0.19,0.5 0.44,0.14 0.5,0.03 0.38,0.17 0.8,0.95 0.67,1.28 0.44,0.49 0.64,0.19 0.5,0.25 1.1,1.23 3.99,5.25 5.45,11.5 0.67,0.97 0.41,0.39 -3.11,7.27 -2.48,3.43 0.06,2.04 0.4,2.56 -1.21,1.98 -3.54,2.33 -0.9,0.36 -0.08,-0.11 -0.65,-0.27 -0.51,-0.07 -0.3,-0.34 -0.28,-0.41 -0.43,-0.27 -0.53,-0.16 -0.23,-0.18 -0.04,-0.31 0.07,-0.56 0.14,-0.44 0.2,-0.35 0.18,-0.39 0.05,-0.55 -0.18,-0.52 -0.66,-0.51 -0.18,-0.51 -0.33,-0.16 -0.21,-0.23 -0.6,-0.83 -0.13,-0.22 -0.16,-0.22 -1.01,-0.97 -0.15,-0.23 -0.23,-0.54 0.01,-0.2 0.13,-0.15 0.3,-0.74 0.19,-0.23 0.12,-0.26 -0.05,-0.46 -0.19,-0.3 -0.91,-0.69 -0.56,-0.73 -0.38,-0.62 -0.44,-0.5 -0.72,-0.38 -1.92,-0.66 -0.47,-0.03 -1.56,0.86 -0.59,0.22 -1.2,0.13 -1.07,-0.23 -1.03,-0.55 -1.08,-0.79 0,-0.01 -0.01,0 -10.19,-8.91 -1.41,-1.6 -2.21,-1.35 -1.56,-1.26 -0.13,-0.07 -3.16,-1.84 -0.95,-0.95 -3.37,-1.62 -3.6,-1.12 -3.99,0.45 -1.98,-0.24 -0.72,-1.61 0,-0.01 0.41,-0.49 0.57,-0.46 0.5,-0.52 0.22,-0.69 -0.19,-0.55 -0.49,-0.44 -0.64,-0.27 -1.48,-0.17 -0.48,-0.41 0.04,-0.49 0.68,-0.38 0.74,-0.07 0.57,0.04 0.55,-0.11 0.71,-0.54 0.92,-0.91 0.46,-0.57 0.24,-0.51 -0.02,-0.37 -0.39,-0.25 -0.15,-0.38 0.02,-0.33 0.21,-0.77 -0.01,-0.42 -0.3,-0.68 -0.47,-0.49 -1.08,-0.87 -1.35,-1.91 -1.13,-1.1 -0.18,-0.59 -0.02,-0.68 -0.1,-0.82 -0.27,-0.77 -0.39,-0.7 -1.13,-1.42 -0.11,-0.08 -0.1,-0.06 -0.13,-0.08 -0.04,-0.02 -0.18,-0.03 -0.17,0.03 -0.16,0.09 -0.63,0.6 -1.03,0.13 -1,-0.23 -0.58,-0.5 0.53,-0.7 1.6,-0.98 0.42,-0.62 -0.24,-0.89 -0.71,-0.5 -0.6,-0.61 0.13,-1.25 -0.73,0.18 -1.65,0.03 -0.61,0.26 -0.99,0.95 -0.56,0.38 -0.59,0.14 -0.23,-0.28 0.01,-1.44 -0.11,-0.31 0.76,-0.64 0.72,-5.9 1.29,-4.06 0.37,-2.63 -0.47,-1.56 0.62,-0.73 2,0.06 5.25,-0.66 5.07,2.08 2.73,0.2 2.74,0.63 2.27,1.4 2.49,2.16 8.5,2.75 3.96,0.32 5.76,-1.47 5.31,0.24 0.71,-1.39 0.47,-2.64 -0.5,-1.03 -0.93,-1.39 0,-1.25 5.43,-1.26 1.15,0.1 0.56,0.17 z\"\r\n                        title=\"Ilam\" id=\"IR-05\"  data-fa=\"ایلام\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 124.87043,230.5444 0,0 0.85,0.38 1.45,0.94 0.7,1.02 14.54,9.57 7.52,0.91 1.25,0.47 1.01,-0.26 1.78,-1.84 0.88,-0.24 1.8,0.11 2.22,-0.25 9.24,3.95 -0.53,0.87 -0.24,1.33 0.42,1.1 0.12,0.93 -1.36,3.13 -0.28,0.9 -0.18,0.98 0.44,0.86 1.73,1 2.24,0.83 3.82,0.33 0.93,0.35 2.71,-1.72 0.64,-0.68 1.16,-3.55 1.5,-0.87 1.87,-0.63 1.7,-0.98 1.86,0.6 1.48,1.8 0.92,1.58 0.04,1.08 -0.54,1.17 -0.36,1.21 0.32,0.95 1.1,0.94 2.55,1.29 1.16,1.23 1.05,0.83 0.79,-0.54 0.22,-1.05 0.67,-1.32 1.18,-0.85 0.76,0.46 0.54,0.97 1.09,0.84 0.73,0.76 -0.05,1.19 0.24,1.16 2.16,1.17 0.3,0.33 -0.76,1.62 -0.14,2.2 0.09,1.75 -3.43,6.9 -0.19,0.95 -0.07,0.75 -0.81,0.48 -5.03,1.42 -1.95,2.3 -0.61,4.78 -1.55,1.17 -2.7,0.9 -0.77,0.5 -0.46,0.82 -0.21,0.97 0.02,0.39 -2.48,0.53 -4.76,-0.46 -7.89,-5.44 -7.5,-0.76 -2.11,-0.65 -1.74,-1.69 -3.51,-1.05 -3.6,0.27 -2.38,0.74 -8.36,0.56 -1.83,1.4 -4.62,12.18 -1.86,2.71 -0.41,-0.39 -0.67,-0.97 -5.45,-11.5 -3.99,-5.25 -1.1,-1.23 -0.5,-0.25 -0.64,-0.19 -0.44,-0.49 -0.67,-1.28 -0.8,-0.95 -0.38,-0.17 -0.5,-0.03 -0.44,-0.14 -0.19,-0.5 -0.36,-0.42 -4.16,-2.1 -1.44,-0.35 -0.86,-0.53 -0.62,-0.63 0,-0.53 -0.6,-0.28 -1.68,-1.28 -0.16,-0.19 -0.19,-0.15 -0.26,-0.06 -0.23,0.04 -0.17,0.19 -0.18,0.04 -0.24,-0.08 -0.11,-0.19 -0.05,-0.2 -0.06,-0.11 -1.28,-0.4 -0.61,-0.29 -0.44,-0.39 -0.45,-0.54 -0.09,-0.34 0.39,-0.71 0.05,-0.41 -0.13,-0.34 -0.35,-0.15 -1.85,-1.13 -0.71,-0.26 -0.89,-1.13 -1.06,-0.56 -0.76,-1.35 -0.53,-0.31 -0.04,-0.31 0.52,-1.57 0.09,-0.62 0.59,-0.25 0.59,-0.07 0.74,-1.84 2.1,-2 11.86,-3.35 0.67,-0.95 1.89,-1.27 0.8,-0.85 0.46,-0.92 0.17,-1.29 -0.3,-2 -0.77,-1.8 -0.47,-0.64 0.59,-0.42 0.49,-0.79 -0.13,-0.31 -0.04,-0.44 0.1,-0.76 -0.06,-0.47 -0.17,-0.33 -0.23,-0.25 -0.21,-0.27 -0.08,-0.4 0.2,-0.58 1.96,-0.97 2.42,-0.12 1.64,-0.85 0.19,-2.3 -0.31,-2.21 0.11,-0.92 0.65,-0.43 0.98,-0.26 2.33,0.31 z\"\r\n                        title=\"Lorestan\" id=\"IR-20\"  data-fa=\"لرستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 181.96043,293.7144 0,0 2.48,-0.53 1.64,4.07 1.83,0.98 2.95,-0.2 3.39,1.29 1.41,1.91 -0.73,1.12 -0.91,3 0.13,1.18 0.56,2.43 5.1,8.09 1.06,2.69 0.83,1.08 0.84,0.61 0.49,0.56 1.6,0.52 0.56,0.56 0.45,1.06 0.92,3.33 1.02,2.4 1.04,1.65 1.68,1.54 0.66,1.15 2.88,3.11 0.99,2.21 -0.1,1.85 -1.84,2.31 -1.21,2.34 -2.26,3.02 -4.05,3.64 -2.61,1.1 -1.15,0.88 -0.86,1.14 -0.56,1.29 0.03,2.31 1.54,5.59 0.1,1.6 -0.17,0.59 -0.15,1.18 -0.34,1.29 0.23,0.97 5.78,-0.77 1.36,1.76 2.65,2.63 3.23,1.72 1.91,1.39 0.58,2.08 -1.96,4.61 0.24,2.04 1.08,1.23 0.64,2.61 0.58,6.16 -5.23,-0.27 -1.95,-0.95 -3.49,0.58 -2.18,1.09 -0.89,-0.35 -1.22,-0.14 -1.26,0.19 -1.23,0.43 -10.63,6.81 -1.23,0.52 -1.09,-0.24 -0.95,-1.4 -0.09,-0.63 -0.01,-1.77 -0.26,-0.68 -0.25,-0.35 -0.09,-0.22 -0.12,-0.16 -0.37,-0.22 -0.33,-0.14 -0.32,-0.08 -0.73,-0.05 -0.36,0.04 -0.73,0.18 -0.41,0.05 -0.38,-0.08 -0.49,-0.37 -0.28,-0.08 -0.7,0.11 -1.27,0.54 -0.7,0.15 -0.88,-0.07 -0.32,-0.34 0.04,-1.61 -0.1,-0.12 -0.47,-0.34 -0.14,-0.23 -0.02,-0.21 0.02,-0.59 0.05,-0.29 0.14,-0.25 -0.01,-0.25 -0.41,-0.27 -0.2,0.66 -0.35,0.66 -0.49,0.46 -0.58,0.08 -0.61,-0.38 -0.29,-0.5 -0.36,-0.39 -0.59,-0.06 -0.79,-0.27 -2.24,-1.32 -0.46,-0.43 -0.22,-1.27 -0.6,-0.79 -0.89,-0.46 -1.08,-0.28 0.36,-0.65 0.56,-0.15 1.39,0.24 0.72,-0.04 1.12,-0.38 0.62,-0.1 0.69,0.17 1.38,0.74 0.48,0.17 0.75,0.07 0.57,0.24 0.46,0.42 0.44,0.61 0.2,-0.53 0.64,-1.14 1,-1.29 0.19,-0.42 0.03,-0.67 -0.7,0.14 -0.5,-0.32 -0.32,-0.61 -0.26,-1.44 -0.4,0.19 -0.53,0.57 -0.53,0.4 0.05,-0.5 0.05,-0.14 0.13,-0.17 -0.28,-0.44 -0.29,0.07 -0.34,0.26 -0.47,0.11 -0.21,-0.14 -0.37,-0.54 -0.23,-0.12 -0.22,0.04 -0.32,0.18 -0.17,0.05 -0.68,-0.11 -0.61,-0.18 -0.57,-0.03 -0.58,0.32 -1.21,-0.18 -0.97,0.61 -0.24,0.8 0.91,0.4 1.08,0.22 0.84,0.54 0.27,0.7 -0.68,0.69 -0.57,-0.01 -1.83,-0.26 -0.39,0.12 -1.85,1.73 -0.14,0.18 -0.3,0.47 -0.17,0.49 0.39,0.35 -0.14,0.28 -0.22,0.31 -0.12,0.21 0.25,0.84 0.6,0.61 0.68,0.52 0.56,0.61 0.28,0.7 0.22,0.88 0.19,1.76 -0.07,0.5 -0.3,0.8 -0.09,0.44 0.02,0.42 0.19,0.74 0.02,0.45 -0.21,0.77 -0.45,0.7 -0.61,0.49 -0.7,0.2 -2.3,-0.27 -0.59,0.27 -0.66,-0.31 -2.37,0.02 -1.43,-0.8 -0.55,-0.12 -0.09,0.68 0.16,0.46 0.46,0.74 0.09,0.54 -0.1,0.39 -0.25,0.33 -0.31,0.28 -0.29,0.19 -0.77,0.24 -2.49,-0.24 0,-0.27 -0.18,0.24 -0.04,0.1 -0.23,-0.11 -1.05,-0.3 -0.51,-0.31 -0.47,-0.37 -0.22,-0.22 -0.15,-0.26 -0.3,-0.76 -0.07,-0.51 -0.62,-1.95 -0.09,-0.06 -0.2,-0.41 -0.67,-0.76 -0.43,-0.91 -0.06,-0.27 0.07,-0.44 0.27,-0.32 0.32,-0.3 0.25,-0.33 0.09,-0.42 -0.07,-0.43 -0.17,-0.39 -0.22,-0.34 -1.32,-1.2 -1.09,-1.25 -0.69,-1.15 -0.31,-0.27 -0.41,-0.14 -0.43,-0.02 -1.24,0.21 -0.41,0.02 -0.4,-0.06 -0.37,-0.17 -0.27,-0.29 -0.15,-0.38 -0.28,-1.72 -0.31,-0.86 -0.43,-0.77 -0.57,-0.61 -0.35,-0.22 -0.37,-0.13 -3.59,-0.52 -0.05,-1.2 0,0 0.11,-18.98 -0.1,-0.51 -0.37,-0.22 -11.12,0 0.11,-9.56 0.09,-6.8 5.16,-14.07 0.2,-0.9 -0.09,-0.85 -0.47,-0.71 -1.33,-1.01 -0.55,-0.6 -0.12,-0.31 -0.17,-0.69 -0.19,-0.36 -0.26,-0.25 -0.61,-0.4 -0.23,-0.32 -1.22,-2.18 -0.16,-0.7 0,-0.01 -0.33,-0.7 -1.18,-0.58 -0.52,-0.6 -0.77,-1.74 -0.5,-0.72 0.9,-0.36 3.54,-2.33 1.21,-1.98 -0.4,-2.56 -0.06,-2.04 2.48,-3.43 3.11,-7.27 1.86,-2.71 4.62,-12.18 1.83,-1.4 8.36,-0.56 2.38,-0.74 3.6,-0.27 3.51,1.05 1.74,1.69 2.11,0.65 7.5,0.76 7.89,5.44 4.76,0.46 z\"\r\n                        title=\"Khuzestan\" id=\"IR-10\"  data-fa=\"خوزستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 247.35043,358.8644 0,0 -1.16,-0.09 -2.19,0.42 -1.68,1.48 -1.84,0.96 -3.88,-0.51 -1.16,0.02 -12.6,-11.23 -1.04,-0.13 -1.78,0.1 -5.94,-2.39 -2.4,-1.47 1.21,-2.34 1.84,-2.31 0.1,-1.85 -0.99,-2.21 -2.88,-3.11 -0.66,-1.15 -1.68,-1.54 -1.04,-1.65 -1.02,-2.4 -0.92,-3.33 -0.45,-1.06 -0.56,-0.56 -1.6,-0.52 -0.49,-0.56 -0.84,-0.61 -0.83,-1.08 -1.06,-2.69 -5.1,-8.09 -0.56,-2.43 -0.13,-1.18 6.68,-3.61 2.31,0.3 1.21,-0.21 1.06,-0.53 1.51,-0.32 2.07,1.14 2.07,1.72 2.2,0.27 1.67,-0.38 1.04,0.36 1.54,-0.33 3.77,-2.47 1.33,-0.24 4.45,-0.14 1.4,-0.47 0.75,-0.82 1.46,-0.25 1.32,1.15 0.34,1.83 0.33,0.98 0.89,0.23 0.52,0.58 0.29,1.16 0.73,1.17 -0.19,2.91 0.34,3.14 4.3,3.35 1.79,1.81 3.93,2.98 1.77,3.22 0.62,4.15 -1.07,2.11 -1.35,0.94 -0.15,1.23 0.67,1.22 1.02,1.31 0.08,1.21 -1.43,0.63 -1.16,0.82 -0.2,2.13 0.76,4.53 3.09,10.25 -0.09,3.08 -0.34,1.37 z\"\r\n                        title=\"Chahar Mahall and Bakhtiari\" id=\"IR-08\" data-fa=\"چهار محال بختیاری\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 450.32043,261.0144 0,0 8.66,-2.02 1.45,1.85 1.34,2.59 2.53,17.12 2.2,5.05 2.88,1.65 0.81,0.63 2.19,0.99 2.87,1.8 2.74,4.3 0.89,0.64 0.17,3.08 -0.28,1.25 -0.91,1.48 -0.58,1.44 0.24,0.89 0.52,0.93 0.99,1.13 0.06,1.21 1.03,2.25 1.36,2.25 -0.08,2.2 -0.77,2.23 -0.3,1.97 -0.56,1.87 -4.51,6.05 -1.25,3.49 -3.48,5.4 -1.77,4.57 -0.48,0.78 -36.34,-15.66 -4.32,-0.76 -0.73,1.11 -1.56,1.69 -7.04,3.99 -2.4,2.55 -17.98,9.5 -1.5,3.23 -0.44,12.48 -0.51,2.75 -5.74,2.53 -6.38,0.87 -2.78,-0.56 -4.33,-0.17 -19.03,3.38 -2.98,3.33 -1.57,2.98 -0.75,2.87 0.09,1.95 1.89,3.58 2,5.27 0.81,3.92 1.09,1.34 1.09,0.75 -0.43,12.7 0.36,2.22 0.47,1.56 0.04,1.11 -1.07,0.76 -3.42,0.42 -0.34,0.29 -1.49,0.66 -6.88,-3.5 -5.26,-3.96 -0.97,-2.34 -1.2,-8.58 -1.48,-2.62 -5.4,-6.64 -5.63,-10.08 -7.9,-20 -4.35,-5.3 -5.13,-4.72 -8.61,-3.32 -1.48,-5.85 -0.1,-2.76 0.36,-0.99 0.65,-4.83 1.42,-5.62 0.31,-2.57 -0.98,-12.32 0.26,-1.33 1.35,-0.9 2.43,-0.72 2.2,-1.25 1.49,-1.26 2.04,-1.3 3.27,-1.27 2.47,-0.09 10.72,2.47 35.84,-12.38 3.58,-2.04 1.87,-2.28 1.3,-2.46 1.1,-3.01 1.54,-6.78 1.82,-2.26 3.37,-1.81 2.63,-0.28 1.94,-1.36 2.89,-5.03 0.9,-2.88 -0.38,-27.64 0,-0.1 0.6,-0.27 3.11,-0.58 8.68,0.2 3.72,-1.93 12.18,-20.53 13.84,-3.62 13.46,-6.4 8.52,-2.2 3.77,0.99 9.88,7.59 1.16,2.61 -0.46,2.64 -3.28,3.22 -13.42,9.52 -2.31,4.17 -4.26,12.86 -0.28,6.91 2.11,11.75 1.59,2.51 6.72,0.81 z\"\r\n                        title=\"Yazd\" id=\"IR-25\"  data-fa=\"یزد\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 274.35043,171.9044 0,0 2.33,-0.95 4.4,-5.33 3.11,-2.46 2.24,0.3 2.41,1.01 3.05,0.57 3.87,2.1 2.58,0.54 1.79,-0.25 1.09,-0.65 1.47,0.34 3.04,2.11 1.07,4.68 0.44,4.2 -1.09,3.74 -5.38,4.91 -3.36,1.8 -3.86,1.28 -2.74,-0.11 -7.63,-2.22 -2.58,-0.06 -2.47,-0.85 -6.18,-3.78 -1.87,-1.63 -2.02,-0.11 -0.73,-0.26 -0.41,-0.41 -0.63,-0.29 -0.56,0.6 -0.46,3.82 -0.64,2.5 -0.21,1.9 0.26,1.77 3.82,5.08 1.53,2.79 -0.42,2.55 -1.74,2.69 -1.03,3.32 -0.13,1.77 -19.31,-11.52 -8.13,-2.45 -9.73,-0.11 0,-0.11 2.93,-9.49 -0.02,-2.91 -0.87,-1.69 -1.57,-1.96 0.89,-2.07 2.19,-1.35 1.77,-2.18 0.96,-2.53 3.01,-0.17 0.41,-2.02 0.13,-2.7 2.05,-2.36 2.73,-1.01 2.74,0.33 1.91,-1.18 0,-2.36 0.11,-1.77 3.66,2.16 5.19,0.44 4.61,1.81 3.46,3.74 1.96,3.69 1.22,1.4 1.01,0.6 1.66,0.6 2.67,0.16 z\"\r\n                        title=\"Tehran\" id=\"IR-07\"  data-fa=\"تهران\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 409.19043,113.5144 0,0 1.33,-0.23 1.65,0.69 -0.35,0.97 -1.98,0.59 -0.87,0.7 -0.21,0.63 0.22,0.34 0.21,0.45 0.17,1.12 -0.17,2.88 -0.64,2.53 -0.12,0.85 0.63,1.34 4.01,4.51 3.85,3.31 1.9,0.64 3.23,0.55 1.68,0.65 5.16,-0.87 0.67,-0.19 1.08,0.04 1.37,0.82 0.83,3.32 -0.91,3.93 -1.37,2.62 -0.5,4.58 0.64,7.87 1.1,5.06 0.92,2.35 8.03,6.57 2.22,2.56 -0.52,2.91 -5.89,10.15 -1.44,3.35 -1.03,0.81 -7.15,2.69 -3.85,2.3 -4.37,4 -5.44,6.75 -12.18,20.53 -3.72,1.93 -8.68,-0.2 -3.11,0.58 -0.6,0.27 0,0.1 -0.31,-0.4 -0.83,-0.72 -1.86,-0.61 -80.82,2.43 -1.76,-0.28 -14.42,-4.76 -2.31,-0.36 -9.28,0.59 -3.31,-0.55 -6.55,-3.55 1.13,-1.62 1.49,-3.5 0.91,-3.61 0.09,-3.36 -0.45,-1.65 0.13,-1.77 1.03,-3.32 1.74,-2.69 0.42,-2.55 -1.53,-2.79 -3.82,-5.08 -0.26,-1.77 0.21,-1.9 0.64,-2.5 0.46,-3.82 0.56,-0.6 0.63,0.29 0.41,0.41 0.73,0.26 2.02,0.11 1.87,1.63 6.18,3.78 2.47,0.85 2.58,0.06 7.63,2.22 2.74,0.11 3.86,-1.28 3.36,-1.8 5.38,-4.91 1.09,-3.74 -0.44,-4.2 -1.07,-4.68 0.5,-0.22 3.43,-0.38 1.6,-0.45 2.15,-1.24 1.76,-0.6 1.1,0.61 1.69,-0.23 2.59,-0.84 2.4,-1.3 1.47,-1.31 0.8,-1.12 0.42,-1.05 0.78,-1.15 3.47,-3.1 1.34,-1.55 0.54,-3.38 0.75,-2.54 1.2,-2.33 2.54,-2.56 2.82,-1.66 3.41,-1.02 6.63,-0.12 2.65,0.43 2.36,-0.53 4.78,-2.26 2.09,-2.28 5.74,-4.5 5.92,-3.41 2.88,-0.34 12.11,1.66 1.71,-0.81 1.13,-2.92 0.67,-4.64 2.8,-6.23 6.3,-9.73 1.4,-1.15 5.12,6.83 2.41,1.7 z\"\r\n                        title=\"Semnan\" id=\"IR-12\"  data-fa=\"سمنان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 328.44043,127.8244 0,0 0,0 0.05,0.55 0.38,1.05 1.18,2.05 7.48,4.53 3.58,3.7 1.38,2.11 -3.41,1.02 -2.82,1.66 -2.54,2.56 -1.2,2.33 -0.75,2.54 -0.54,3.38 -1.34,1.55 -3.47,3.1 -0.78,1.15 -0.42,1.05 -0.8,1.12 -1.47,1.31 -2.4,1.3 -2.59,0.84 -1.69,0.23 -1.1,-0.61 -1.76,0.6 -2.15,1.24 -1.6,0.45 -3.43,0.38 -0.5,0.22 -3.04,-2.11 -1.47,-0.34 -1.09,0.65 -1.79,0.25 -2.58,-0.54 -3.87,-2.1 -3.05,-0.57 -2.41,-1.01 -2.24,-0.3 -3.11,2.46 -4.4,5.33 -2.33,0.95 -2.67,-0.16 -1.66,-0.6 -1.01,-0.6 -1.22,-1.4 -1.96,-3.69 -3.46,-3.74 -4.61,-1.81 -5.19,-0.44 -3.66,-2.16 -2.2,-2.6 -5.55,-1.23 -1.42,-0.62 -1.29,-1.19 -0.61,-0.89 -2.16,-0.86 -5.59,-1.11 -0.04,-0.84 -0.39,-1.14 -5.49,-4.19 -1.87,-1.02 -9.03,-7.62 1.76,-1.15 2.08,-3.71 0.74,-3.51 1.36,-1.35 1.76,-0.95 1.16,-1.6 0.33,-1.08 0.02,-0.14 0,0 1.61,1.09 0.71,0.17 0.47,0.21 1,1.09 0.5,0.43 5.34,2.92 4.88,3.46 2.84,1.3 9.45,1.88 6.04,1.75 6.26,1.13 6.03,1.75 6.27,-0.83 5.57,-2.05 5.82,-1.44 6.03,-1.15 5.78,-1.18 5.8,-1.73 5.59,-1.73 11.24,-2.53 1.52,-0.25 13.33,-0.76 2.43,-0.59 1.65,-1.39 -0.08,1.61 -1.91,0.67 -2.41,0.3 -1.55,0.48 -0.43,0.21 -0.48,-0.07 -0.91,-0.29 -0.51,0.08 -0.93,0.37 -0.53,0.11 -1.98,-0.27 -1.74,0 0.27,0.48 0.47,0.15 1.12,-0.05 -0.68,0.23 -0.27,0.03 0.82,1.1 1.39,0.61 0.14,0.02 z\"\r\n                        title=\"Mazandaran\" id=\"IR-21\" data-fa=\"مازندران\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 405.42043,74.5244 0,0 4.84,-0.89 1.37,0.18 0.17,0.07 0.22,3.01 -0.22,1.22 0.09,1.56 0.41,1.8 -0.03,1.02 -0.69,2.77 0.07,1.94 1.15,1.37 1.6,0.79 1.38,1.06 0.63,2.61 -1.86,2.6 -3.97,1.38 -0.91,0.14 -1.02,0.46 -1.03,0.95 -2.46,1.02 -2.47,4.4 -1.03,1 -1.4,1.15 -6.3,9.73 -2.8,6.23 -0.67,4.64 -1.13,2.92 -1.71,0.81 -12.11,-1.66 -2.88,0.34 -5.92,3.41 -5.74,4.5 -2.09,2.28 -4.78,2.26 -2.36,0.53 -2.65,-0.43 -6.63,0.12 -1.38,-2.11 -3.58,-3.7 -7.48,-4.53 -1.18,-2.05 -0.38,-1.05 -0.05,-0.55 0,0 5.12,0.45 0.53,0.3 0.58,0.21 4.24,-1.17 0.4,-0.33 0.23,-0.71 0.02,-4.38 -0.19,-0.72 -0.5,-0.29 -0.64,-0.26 0.1,-0.62 0.77,-1.44 -0.81,-1.25 -0.54,-1.56 -0.75,-3.59 -1.03,-2.78 -0.15,-0.6 -0.32,-3.61 9.24,0.81 0.67,-0.04 0.61,-0.26 0.63,-0.6 0.63,-0.42 0.73,-0.04 0.79,0.1 0.74,0 1.21,-0.4 5.73,-3.33 0.77,-0.12 2.06,0.45 0.75,-0.01 0.51,-0.24 0.83,-0.9 0.67,-0.27 0.42,-0.4 1.61,-1.06 0.86,-0.72 0.16,-0.31 0.1,-0.65 0.46,-1.07 0.11,-0.61 0.04,-1.03 -0.04,-0.3 -0.16,-0.28 -0.39,-0.36 -0.12,-0.23 -0.04,-0.9 0.56,-1.33 0.15,-0.85 0.18,-0.68 0.44,-0.71 1.02,-1.11 5.09,-3.51 1.58,-1.78 0.26,-0.44 0.18,-0.59 0.41,-0.22 0.48,-0.08 0.36,-0.14 0.25,-0.33 0.37,-0.78 0.29,-0.33 0.65,-0.22 1.96,-0.38 0.42,-0.16 0.3,-0.68 0.74,-0.41 1.54,-0.52 0.39,-0.06 0.7,-0.57 0.7,-0.36 2.51,-1.95 0.83,-0.34 2.15,-0.09 6.69,-1.41 1.01,0 2.1,0.46 1.32,0.77 0.5,0.17 1.72,0.02 0.57,0.18 0.92,0.49 0.48,0.15 0.52,0.03 z\"\r\n                        title=\"Golestan\" id=\"IR-27\"  data-fa=\"گلستان\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 286.04043,345.0244 0,0 2.52,-0.01 11.56,-3.35 0.06,0 8.61,3.32 5.13,4.72 4.35,5.3 7.9,20 5.63,10.08 5.4,6.64 1.48,2.62 1.2,8.58 0.97,2.34 5.26,3.96 6.88,3.5 -0.01,0.77 0.93,3.09 2.75,5.71 0.38,1.5 0.74,1.3 0.81,0.83 1.51,0.96 7.76,0.72 1.97,0.84 6.85,17.02 1.95,5.89 0.01,1.09 -1.11,0.81 0.18,1.82 10.18,9.89 0.9,2.42 -0.4,4.32 -1.71,6.27 -0.16,1.6 0.16,1.24 2.86,2.34 1.62,2.65 -0.21,2.17 -0.58,0.94 -0.77,0.55 -1.02,0.45 -1.96,-0.11 -3.1,0.8 -4.62,2.49 -1.32,2.1 -1.11,3.39 -1.96,1.87 -4.23,1.29 -9.03,-1.28 -3.09,0.72 -1.68,0.72 -1.6,-0.56 -2.06,-0.27 -9.04,0.83 -3.5,1.22 -1.5,1.83 -0.5,3.03 -0.71,2.09 -0.01,0.42 0.39,1.12 -0.92,1.48 -3.53,1.88 -10.36,-1.84 -0.87,0 -2.47,0.63 -0.59,-0.08 -0.57,-0.28 -2.86,-2.35 -1.25,-0.5 -7.55,-0.67 -2.48,-2.36 -0.93,-1.79 -6.77,-4.89 -4.34,-4.09 -4.47,-5.52 -4.59,-10.29 -2.55,-2.99 -1.13,-0.67 -1.5,-0.6 -0.85,-1.4 -4.96,-14.04 -0.78,-3.48 -15.2,-28.66 -3,-2.76 -2.7,-1.01 -2.18,-2.29 -2.39,-3.79 -1.82,-4.18 -2.27,-2.53 -4.65,-1.51 -7.48,-0.56 -1.93,-0.74 -2.07,-4.21 -1.7,-1.7 -0.91,-2.83 0,-2.01 0,-0.1 3.4,-0.84 5.68,0.35 1.44,-0.23 9.04,-5.29 0.72,-1.51 0.04,-2.03 -0.83,-1.39 -0.25,-0.86 0.47,-0.84 -0.07,-0.89 -1.07,-3 -0.56,-3.31 0.51,-0.59 2.76,0.69 3.88,1.89 0.86,0.19 0.76,0.96 1.26,0.77 3.59,0.93 1.88,-0.51 1.67,-0.99 0.86,-0.86 0.19,-0.39 -0.02,-1.88 -1,-4.92 2.57,-0.39 0.95,-0.31 -0.01,-1.27 -0.35,-2.34 0.27,-3.44 2.86,-7.16 0.69,-4.04 0.82,-2.7 -0.98,-2.68 -1.95,-1.49 -1.49,-0.28 -1.33,-0.51 -1.04,-1.06 -0.8,-1.87 0.13,-1.18 3.29,0.79 2.54,-0.36 4.56,-3.1 0.96,-0.43 0.66,-0.89 4.61,-2.54 0.59,0.09 0.52,1.08 0.32,3.68 1.57,1.42 7.54,1.67 z\"\r\n                        title=\"Fars\" id=\"IR-14\"  data-fa=\"فارس\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 273.40043,226.7544 0,0 9.28,-0.59 2.31,0.36 14.42,4.76 1.76,0.28 80.82,-2.43 1.86,0.61 0.83,0.72 0.31,0.4 0.38,27.64 -0.9,2.88 -2.89,5.03 -1.94,1.36 -2.63,0.28 -3.37,1.81 -1.82,2.26 -1.54,6.78 -1.1,3.01 -1.3,2.46 -1.87,2.28 -3.58,2.04 -35.84,12.38 -10.72,-2.47 -2.47,0.09 -3.27,1.27 -2.04,1.3 -1.49,1.26 -2.2,1.25 -2.43,0.72 -1.35,0.9 -0.26,1.33 0.98,12.32 -0.31,2.57 -1.42,5.62 -0.65,4.83 -0.36,0.99 0.1,2.76 1.48,5.85 -0.06,0 -11.56,3.35 -2.52,0.01 -7.54,-1.67 -1.57,-1.42 -0.32,-3.68 -0.52,-1.08 -0.59,-0.09 -4.61,2.54 -0.66,0.89 -0.96,0.43 -4.56,3.1 -2.54,0.36 -3.29,-0.79 -0.13,1.18 0.8,1.87 1.04,1.06 1.33,0.51 1.49,0.28 1.95,1.49 0.98,2.68 -0.82,2.7 -0.69,4.04 -2.86,7.16 -0.27,3.44 0.35,2.34 0.01,1.27 -0.95,0.31 -2.57,0.39 -0.69,-0.67 -4.74,-3.42 -3.65,-3.89 -1.87,-4.85 -0.24,-2.64 0.34,-1.37 0.09,-3.08 -3.09,-10.25 -0.76,-4.53 0.2,-2.13 1.16,-0.82 1.43,-0.63 -0.08,-1.21 -1.02,-1.31 -0.67,-1.22 0.15,-1.23 1.35,-0.94 1.07,-2.11 -0.62,-4.15 -1.77,-3.22 -3.93,-2.98 -1.79,-1.81 -4.3,-3.35 -0.34,-3.14 0.19,-2.91 -0.73,-1.17 -0.29,-1.16 -0.52,-0.58 -0.89,-0.23 -0.33,-0.98 -0.34,-1.83 -1.32,-1.15 -1.46,0.25 -0.75,0.82 -1.4,0.47 -4.45,0.14 -1.33,0.24 -3.77,2.47 -1.54,0.33 -1.04,-0.36 -1.67,0.38 -2.2,-0.27 -2.07,-1.72 -2.07,-1.14 -1.51,0.32 -1.06,0.53 -1.21,0.21 -2.31,-0.3 -6.68,3.61 0.91,-3 0.73,-1.12 -1.41,-1.91 -3.39,-1.29 -2.95,0.2 -1.83,-0.98 -1.64,-4.07 -0.02,-0.39 0.21,-0.97 0.46,-0.82 0.77,-0.5 2.7,-0.9 1.55,-1.17 0.61,-4.78 1.95,-2.3 5.03,-1.42 0.81,-0.48 0.07,-0.75 0.19,-0.95 3.43,-6.9 -0.09,-1.75 0.14,-2.2 0.76,-1.62 2.81,-2.34 5.38,-3.2 14.11,-3.72 2.12,-1.31 1.9,-1.61 2.13,-0.68 1.94,-0.01 0.91,-1.61 3.23,-7.83 0.4,-2.44 -0.96,-0.51 -0.71,-1.77 1.02,-8.04 0.4,-1.2 1.27,-1.28 3.23,-1.41 7.31,-0.84 2.62,0.14 11.42,-2.97 6.55,3.55 3.31,0.55 z\"\r\n                        title=\"Esfahan\" id=\"IR-04\" data-fa=\"اصفهان\"  />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 214.02043,435.4644 0,0 -0.34,0.05 -0.34,-0.31 -0.33,-0.85 -0.21,-0.76 -0.25,-0.46 0.4,-0.25 0.37,0.16 0.61,0.27 0.36,0.22 -0.15,0.67 0.1,0.67 -0.22,0.59 z m 34.53,-12.42 0,0 2.18,2.29 2.7,1.01 3,2.76 15.2,28.66 0.78,3.48 4.96,14.04 0.85,1.4 1.5,0.6 1.13,0.67 2.55,2.99 4.59,10.29 4.47,5.52 4.34,4.09 6.77,4.89 -1.46,0.84 -0.46,0.17 -1.58,-0.07 -1.68,-0.43 -0.55,-0.02 -2.21,0.22 -0.37,-0.02 -0.69,0.3 -0.15,-0.02 -0.19,0.23 -0.55,1.07 0,0 -2.63,-1.17 -0.69,-0.73 -0.06,-0.78 0.32,-0.49 0.57,-0.25 0.7,-0.07 0.64,0.02 0.73,-0.08 0.42,-0.37 -0.3,-0.9 -0.54,-0.46 -1.37,-0.53 -0.51,-0.43 -0.27,-0.45 -0.55,-1.25 -0.23,-0.39 -2.54,-2.63 -1.11,-0.88 -1.24,-0.54 -6.04,-1.33 -1.27,-0.64 -4,-3.72 -1.24,-0.84 -1.4,-0.59 -1.61,-0.22 -2.35,0.29 -0.54,-0.17 -0.63,-0.4 -1.21,0.09 -1.31,0.31 -2.12,0.39 -1.33,-0.21 -2.93,-0.61 -0.4,-0.1 -0.17,-0.25 -0.04,-0.37 -0.11,-0.28 -0.18,-0.19 -1.06,-0.15 -1.44,-0.44 -0.73,-0.78 -0.77,-1.31 -0.82,-0.52 -0.26,1.07 -0.69,0.06 -0.67,-2.29 -0.66,-0.96 -0.52,-1.39 -1.28,-2.09 -0.58,-0.55 -0.7,-0.73 -0.17,-0.77 0.75,-2.07 -0.05,-1.02 -0.7,-1.14 -1.18,-1.07 -0.41,-0.5 -1.2,-1.86 -1.11,-1.19 -0.26,-0.39 -2.07,-5.13 -0.28,-1.21 -0.03,-4.91 -0.43,-1.67 -0.76,-1.42 -0.86,-1.02 -1.1,-0.68 -1.42,-0.34 -1.38,-0.07 -0.67,-0.19 -0.29,-0.41 -0.25,-0.76 -1.6,-2.02 -0.27,-0.73 -0.21,-1.07 0.13,-0.96 0.7,-0.41 0.66,0.23 0.67,0.56 0.56,0.7 0.33,0.64 0.35,-0.31 -0.04,-0.28 -0.15,-0.32 0.05,-0.43 0.24,-0.28 0.68,-0.61 0.23,-0.41 0.12,-0.84 -0.09,-0.9 -0.33,-0.56 -0.62,0.16 -0.29,-1.12 -0.23,-0.4 -0.41,-0.35 -0.2,0.04 -0.31,0.17 -0.29,0.09 -0.12,-0.17 -0.04,-0.66 -0.07,-0.32 -0.12,-0.21 -0.81,-0.14 -2.65,0.16 -0.61,0.11 -0.9,0.53 -0.94,-0.11 -0.75,-0.66 -0.3,-1.08 -0.06,-0.94 0.09,-0.48 0.31,-0.46 0.24,-0.53 0.22,-0.64 0.31,-0.29 0.51,0.55 0.15,-1.58 0.08,-0.27 -0.33,-0.11 -0.21,-0.23 -0.41,-0.75 0.24,-0.95 -0.01,-1.51 -0.17,-1.55 -0.27,-1.05 -0.44,-0.81 -0.66,-0.9 -0.52,-0.25 -0.02,1.16 -0.19,-0.43 -0.96,-1.45 -1.79,-1.48 -0.29,-0.5 -0.23,-0.67 -0.54,-0.75 -1.1,-1.12 -2.01,-0.81 -0.3,-0.4 -0.22,-0.78 -0.49,-0.74 -0.91,-1.02 -0.91,-1.32 -1.54,-2.82 -0.81,-1.19 -0.64,-0.56 -1.39,-0.86 -1.32,-1.36 -0.12,-0.18 -0.1,-0.47 -0.03,-0.72 -0.12,-0.41 0.53,-0.06 0.12,-0.23 -0.2,-0.29 -0.45,-0.22 0.36,-1.33 -0.77,-2.21 0.2,-1.03 -0.48,-0.37 -0.53,-0.72 -0.45,-0.79 -0.18,-0.65 -0.2,-0.41 -0.5,-0.34 -0.27,-0.11 -0.01,0 2.18,-1.09 3.49,-0.58 1.95,0.95 5.23,0.27 3.96,1.43 1.26,0.91 0.59,0.56 0,2.01 0.91,2.83 1.7,1.7 2.07,4.21 1.93,0.74 7.48,0.56 4.65,1.51 2.27,2.53 1.82,4.18 2.39,3.79 z\"\r\n                        title=\"Bushehr\" id=\"IR-06\"  data-fa=\"بوشهر\" />\r\n                </a>\r\n                <a xmlns:xlink=\"http://www.w3.org/1999/xlink\">\r\n                    <path\r\n                        d=\"m 220.02043,349.8844 0,0 1.78,-0.1 1.04,0.13 12.6,11.23 1.16,-0.02 3.88,0.51 1.84,-0.96 1.68,-1.48 2.19,-0.42 1.16,0.09 0.24,2.64 1.87,4.85 3.65,3.89 4.74,3.42 0.69,0.67 1,4.92 0.02,1.88 -0.19,0.39 -0.86,0.86 -1.67,0.99 -1.88,0.51 -3.59,-0.93 -1.26,-0.77 -0.76,-0.96 -0.86,-0.19 -3.88,-1.89 -2.76,-0.69 -0.51,0.59 0.56,3.31 1.07,3 0.07,0.89 -0.47,0.84 0.25,0.86 0.83,1.39 -0.04,2.03 -0.72,1.51 -9.04,5.29 -1.44,0.23 -5.68,-0.35 -3.4,0.84 0,0.1 -0.59,-0.56 -1.26,-0.91 -3.96,-1.43 -0.58,-6.16 -0.64,-2.61 -1.08,-1.23 -0.24,-2.04 1.96,-4.61 -0.58,-2.08 -1.91,-1.39 -3.23,-1.72 -2.65,-2.63 -1.36,-1.76 -5.78,0.77 -0.23,-0.97 0.34,-1.29 0.15,-1.18 0.17,-0.59 -0.1,-1.6 -1.54,-5.59 -0.03,-2.31 0.56,-1.29 0.86,-1.14 1.15,-0.88 2.61,-1.1 4.05,-3.64 2.26,-3.02 2.4,1.47 5.94,2.39 z\"\r\n                        title=\"Kohgiluyeh and Buyer Ahmad\" id=\"IR-18\" data-fa=\"کهگلویه و بویراحمد\"  />\r\n                </a>\r\n            </g>\r\n\r\n        </svg>\r\n        <div class=\"loading-map\">\r\n            <svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1.5\"\r\n                stroke=\"currentColor\" width=\"24\" height=\"24\">\r\n                <path stroke-linecap=\"round\" stroke-linejoin=\"round\"\r\n                    d=\"M16.023 9.348h4.992v-.001M2.985 19.644v-4.992m0 0h4.992m-4.993 0 3.181 3.183a8.25 8.25 0 0 0 13.803-3.7M4.031 9.865a8.25 8.25 0 0 1 13.803-3.7l3.181 3.182m0-4.991v4.99\" />\r\n            </svg>\r\n            در حال بارگزاری\r\n        </div>\r\n		<div class=\"representative-info\"></div>\r\n    </div>\r\n	<!-- Script	 -->\r\n	<script>\r\nwindow.addEventListener(\"load\", () => {\r\n    const countrySvgElem = document.querySelector(\"#provinces-elem\");\r\n    const countrySvgWrapperElem = document.querySelector(\".representatives-map\")\r\n    const baseUrl = \"https://desing85.ir/\"\r\n\r\n    const fillInfoBox = (info, cityname) => {\r\n        return `\r\n            ${info.thumbnail ? `<img class=\"representative-img\"\r\n                src=\"${info.thumbnail}\"\r\n                alt=\"\">`: `<div class=\"info-image-placeholder\">\r\n                <svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1\" stroke=\"currentColor\" width=\"20px\" height=\"20px\">\r\n                    <path stroke-linecap=\"round\" stroke-linejoin=\"round\" d=\"m2.25 15.75 5.159-5.159a2.25 2.25 0 0 1 3.182 0l5.159 5.159m-1.5-1.5 1.409-1.409a2.25 2.25 0 0 1 3.182 0l2.909 2.909m-18 3.75h16.5a1.5 1.5 0 0 0 1.5-1.5V6a1.5 1.5 0 0 0-1.5-1.5H3.75A1.5 1.5 0 0 0 2.25 6v12a1.5 1.5 0 0 0 1.5 1.5Zm10.5-11.25h.008v.008h-.008V8.25Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z\" />\r\n                </svg>\r\n                </div>`}\r\n            <div class=\"representative-text\">\r\n                <div>\r\n                <h5 class=\"representative-title\">${info.title}</h5>\r\n                <span class=\"province-box\">\r\n                    <svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1.5\"\r\n                        stroke=\"#4d4d4d\" width=\"15\" height=\"15\">\r\n                        <path stroke-linecap=\"round\" stroke-linejoin=\"round\"\r\n                            d=\"M15 10.5a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z\" />\r\n                        <path stroke-linecap=\"round\" stroke-linejoin=\"round\"\r\n                            d=\"M19.5 10.5c0 7.142-7.5 11.25-7.5 11.25S4.5 17.642 4.5 10.5a7.5 7.5 0 1 1 15 0Z\" />\r\n                    </svg>\r\n                    <span class=\"province-label\">${cityname}</span>\r\n                </span>\r\n                </div>\r\n                <p class=\"representative-description\">${info?.description ?? \'\'}</p>\r\n            </div>`\r\n    }\r\n\r\n    const applyStylesInPath = async (provincesList) => {\r\n        let showTimeout;\r\n        let isInfoBoxVisible = false;\r\n        const linksElem = countrySvgElem.querySelectorAll(\".provinces path\")\r\n        const expandingCircleElem = countrySvgElem.querySelector(\"#expanding-circle\")\r\n        const infoBoxElem = countrySvgWrapperElem.querySelector(\".representative-info\")\r\n\r\n        countrySvgWrapperElem.classList.remove(\"loading\");\r\n        provincesList.forEach((linkElem) => {\r\n            const provinceElem = countrySvgElem.querySelector(`#${linkElem.province_id}`);\r\n            provinceElem.classList.add(\"is-representative\");\r\n            provinceElem.closest(\"a\").setAttributeNS(\"http://www.w3.org/1999/xlink\", \"xlink:href\", `${baseUrl}representatives/#namayandegan-${linkElem.id}`);\r\n            provinceElem.addEventListener(\'mouseenter\', e => {\r\n                showTimeout = setTimeout(() => {\r\n                    isInfoBoxVisible = true;\r\n                    infoBoxElem.classList.add(\"show\");\r\n                    infoBoxElem.innerHTML = fillInfoBox(linkElem,provinceElem.dataset.fa )\r\n                }, 700);\r\n            });\r\n\r\n            provinceElem.addEventListener(\'mouseleave\', () => {\r\n                clearTimeout(showTimeout);\r\n                if (isInfoBoxVisible) {\r\n                    infoBoxElem.classList.remove(\"show\");\r\n                    isTooltipVisible = false;\r\n                }\r\n            });\r\n        })\r\n\r\n        expandingCircleElem.style.r = 800;\r\n    }\r\n\r\n    const getActiveRepresentatives = async () => {\r\n        fetch(`${baseUrl}/wp-json/v1/representatives`)\r\n            .then(res => res.json())\r\n            .then(res => {\r\n                applyStylesInPath(res)\r\n            })\r\n    }\r\n\r\n    getActiveRepresentatives()\r\n\r\n})\r\n	</script>\r\n    <?php\r\n    return ob_get_clean();\r\n}\r\nadd_shortcode(\'representatives_map_shortcode\', \'representatives_map_shortcode\');\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:0:{}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-27 11:50:07\";}i:7;a:14:{s:2:\"id\";i:164;s:5:\"title\";s:23:\"Get Representatives Api\";s:4:\"code\";s:906:\"add_action(\'rest_api_init\', function () {\r\n  register_rest_route(\'v1\', \'/representatives\', [\r\n    \'methods\'  => \'GET\',\r\n    \'callback\' => \'get_representatives\',\r\n    \'permission_callback\' => \'__return_true\',\r\n  ]);\r\n});\r\n\r\nfunction get_representatives($request) {\r\n  $args = [\r\n    \'post_type\'      => \'representatives\',\r\n    \'posts_per_page\' => -1,\r\n    \'post_status\'    => \'publish\',\r\n  ];\r\n\r\n  $query = new WP_Query($args);\r\n  $data = [];\r\n\r\n  while ($query->have_posts()) {\r\n    $query->the_post();\r\n	  \r\n    $data[] = [\r\n	  \'id\'           => get_the_ID(),\r\n	  \'title\'        => get_the_title(),\r\n      \'province_id\' => get_post_meta(get_the_ID(), \'province\', true),\r\n      \'link\'        => get_permalink(),\r\n      \'thumbnail\' => get_the_post_thumbnail_url(get_the_ID(), \'full\'),\r\n	  \'description\' => get_the_excerpt(),\r\n    ];\r\n  }\r\n\r\n  wp_reset_postdata();\r\n\r\n  return rest_ensure_response($data);\r\n}\";s:9:\"code_type\";s:3:\"php\";s:8:\"location\";s:10:\"everywhere\";s:11:\"auto_insert\";i:1;s:13:\"insert_number\";i:1;s:9:\"use_rules\";b:0;s:5:\"rules\";a:2:{s:4:\"show\";s:4:\"show\";s:6:\"groups\";a:1:{i:0;a:1:{i:0;a:4:{s:4:\"type\";s:4:\"page\";s:6:\"option\";s:8:\"page_url\";s:8:\"relation\";s:8:\"contains\";s:5:\"value\";s:0:\"\";}}}}s:8:\"priority\";i:10;s:14:\"location_extra\";s:0:\"\";s:20:\"shortcode_attributes\";a:0:{}s:13:\"compiled_code\";s:0:\"\";s:8:\"modified\";s:19:\"2025-06-25 18:37:01\";}}}", "auto-off");
INSERT INTO `wp_options` VALUES("483", "wpcode_admin_notices", "a:2:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1749543954;s:9:\"dismissed\";b:1;}s:15:\"suggest_plugins\";a:2:{s:4:\"time\";i:1747858659;s:9:\"dismissed\";b:0;}}", "on");
INSERT INTO `wp_options` VALUES("489", "wpcode_notifications", "a:4:{s:6:\"update\";i:1751215197;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("501", "jet_engine_glossaries_orders", "a:1:{i:0;s:1:\"2\";}", "auto");
INSERT INTO `wp_options` VALUES("506", "wpcode_settings", "a:5:{s:21:\"facebook_pixel_events\";a:5:{s:9:\"page_view\";i:1;s:11:\"add_to_cart\";i:1;s:12:\"view_content\";i:1;s:14:\"begin_checkout\";i:1;s:8:\"purchase\";i:1;}s:19:\"google_pixel_events\";a:6:{s:9:\"page_view\";i:1;s:11:\"add_to_cart\";i:1;s:9:\"view_item\";i:1;s:14:\"begin_checkout\";i:1;s:8:\"purchase\";i:1;s:10:\"conversion\";i:1;}s:22:\"pinterest_pixel_events\";a:4:{s:17:\"pagevisit_product\";i:1;s:14:\"begin_checkout\";i:1;s:11:\"add_to_cart\";i:1;s:8:\"purchase\";i:1;}s:19:\"tiktok_pixel_events\";a:4:{s:12:\"view_content\";i:1;s:11:\"add_to_cart\";i:1;s:14:\"begin_checkout\";i:1;s:8:\"purchase\";i:1;}s:13:\"editor_height\";i:502;}", "auto");
INSERT INTO `wp_options` VALUES("614", "_transient_health-check-site-status-result", "{\"good\":19,\"recommended\":2,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("1743", "elementor_pro_tracker_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("1744", "elementor_allow_tracking", "no", "auto");
INSERT INTO `wp_options` VALUES("1745", "elementor_tracker_notice", "1", "auto");
INSERT INTO `wp_options` VALUES("1778", "_elementor_home_screen_data", "a:2:{s:7:\"timeout\";i:1751051862;s:5:\"value\";s:10885:\"{\"top_with_licences\":[{\"license\":[\"free\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Start building your website with Elementor\'s no code drag & drop editor.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s\",\"youtube_embed_id\":\"le72grP_Q6k?si=g2akyWNODL6usu6u\"},{\"license\":[\"pro\"],\"title_small\":\"Hi!\",\"title\":\"Unleash your imagination with Elementor\",\"description\":\"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.\",\"button_create_page_title\":\"Create a Page\",\"button_watch_title\":\"Watch a guide\",\"button_watch_url\":\"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs\",\"youtube_embed_id\":\"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5\"}],\"get_started\":[{\"license\":[\"free\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&page=popup_templates\",\"is_relative_url\":true,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"title_small_color\":\"text.tertiary\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\",\"title_small_color\":\"text.tertiary\"}]},{\"license\":[\"pro\"],\"header\":{\"title\":\"Jumpstart your web-creation\",\"description\":\"These quick actions will get your site airborne with a customized design.\"},\"repeater\":[{\"title\":\"Site Settings\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg\"},{\"title\":\"Site Logo\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"settings-site-identity\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg\"},{\"title\":\"Global Colors\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-colors\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg\"},{\"title\":\"Global Fonts\",\"title_small\":\"Customize\",\"url\":\"\",\"is_relative_url\":false,\"tab_id\":\"global-typography\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg\"},{\"title\":\"Theme Builder\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor-app\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg\"},{\"title\":\"Popups\",\"title_small\":\"Customize\",\"url\":\"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg\"},{\"title\":\"Custom Icons\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_icons\",\"is_relative_url\":false,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg\"},{\"title\":\"Custom Fonts\",\"title_small\":\"Customize\",\"url\":\"admin.php?page=elementor_custom_fonts\",\"is_relative_url\":true,\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg\"}]}],\"add_ons\":{\"header\":{\"title\":\"Expand your design toolkit\",\"description\":\"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity.\"},\"repeater\":[{\"file_path\":\"send-app\\/send-app.php\",\"title\":\"Send \\u2013 Marketing Automation\",\"url\":\"\",\"description\":\"Supercharge your WooCommerce store with Send\\u2014an all-in-one toolkit for emails, popups & more. Built for WordPress. No plugins, no hassle.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/send-logo.svg\",\"type\":\"wporg\"},{\"file_path\":\"site-mailer\\/site-mailer.php\",\"title\":\"Site Mailer\",\"url\":\"\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-mailer.svg\",\"type\":\"wporg\"},{\"file_path\":\"image-optimization\\/image-optimization.php\",\"title\":\"Image Optimizer\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/\",\"description\":\"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.\",\"button_label\":\"Install\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg\",\"type\":\"wporg\"},{\"title\":\"Elementor AI\",\"url\":\"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/\",\"description\":\"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.\",\"button_label\":\"Let\'s go\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg\",\"type\":\"link\",\"condition\":{\"key\":\"introduction_meta\",\"value\":\"ai_get_started\"}}],\"footer\":{\"label\":\"Explore more add-ons\",\"file_path\":\"wp-admin\\/admin.php?page=elementor-apps\"}},\"sidebar_upgrade\":[{\"license\":[\"free\"],\"show\":\"true\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]},{\"license\":[\"pro\"],\"show\":\"false\",\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}],\"sidebar_promotion_variants\":[{\"license\":[\"essential\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/essential-upgrade.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-advanced-home-sidebar-upgrade\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\"}},{\"license\":[\"expired\"],\"is_enabled\":\"true\",\"type\":\"banner\",\"data\":{\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/upgrade-free.svg\",\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-expired\\/\"}},{\"license\":[\"free\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}},{\"license\":[\"pro\"],\"is_enabled\":\"false\",\"type\":\"default\",\"data\":{\"header\":{\"title\":\"Bring your vision to life\",\"description\":\"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg\"},\"cta\":{\"label\":\"Upgrade Now\",\"url\":\"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg\"},\"repeater\":[{\"title\":\"Popup Builder\"},{\"title\":\"Custom Code & CSS\"},{\"title\":\"E-commerce Features\"},{\"title\":\"Collaborative Notes\"},{\"title\":\"Form Submission\"},{\"title\":\"Form Integrations\"},{\"title\":\"Custom Attributes\"},{\"title\":\"Role Manager\"}]}}],\"external_links\":[{\"label\":\"Help Center\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg\",\"url\":\"https:\\/\\/elementor.com\\/help\\/\"},{\"label\":\"Youtube\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg\",\"url\":\"https:\\/\\/www.youtube.com\\/@Elementor\"},{\"label\":\"Facebook Community\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg\",\"url\":\"https:\\/\\/www.facebook.com\\/groups\\/Elementors\"},{\"label\":\"Blog\",\"image\":\"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg\",\"url\":\"https:\\/\\/elementor.com\\/blog\\/\"}]}\";}", "off");
INSERT INTO `wp_options` VALUES("1787", "jet_engine_meta_boxes", "a:1:{s:6:\"meta-1\";a:3:{s:4:\"args\";a:7:{s:11:\"object_type\";s:4:\"post\";s:11:\"allowed_tax\";a:0:{}s:17:\"allowed_post_type\";a:1:{i:0;s:4:\"post\";}s:13:\"allowed_posts\";a:0:{}s:14:\"excluded_posts\";a:0:{}s:17:\"active_conditions\";a:0:{}s:4:\"name\";s:12:\"ReadBlogTime\";}s:11:\"meta_fields\";a:1:{i:0;a:13:{s:5:\"title\";s:21:\"زمان مطالعه\";s:4:\"name\";s:12:\"reading_time\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:15:\"repeater-fields\";a:0:{}s:4:\"type\";s:6:\"number\";s:2:\"id\";i:2033;s:8:\"isNested\";b:0;s:14:\"options_source\";s:6:\"manual\";s:11:\"description\";s:177:\"در این بخش زمانی که برای مطالعه این وبلاگ طول خواهد کشید را وارد نمایید.\nبر اساس دقیقه وارد نمایید.\";s:9:\"min_value\";s:1:\"0\";s:11:\"default_val\";s:1:\"5\";}}s:2:\"id\";s:6:\"meta-1\";}}", "auto");
INSERT INTO `wp_options` VALUES("1790", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("1985", "jet_smart_filters_version", "3.6.7", "off");
INSERT INTO `wp_options` VALUES("2009", "fbc_settings_options", "a:13:{s:21:\"breadcrumb_front_text\";s:17:\"صفحه اصلی\";s:20:\"breadcrumb_front_url\";s:19:\"https://desing85.ir\";s:20:\"breadcrumb_home_icon\";s:0:\"\";s:20:\"breadcrumb_separator\";s:225:\"<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"none\" viewBox=\"0 0 24 24\" stroke-width=\"1.5\" stroke=\"currentColor\" class=\"size-6\">   <path stroke-linecap=\"round\" stroke-linejoin=\"round\" d=\"M15.75 19.5 8.25 12l7.5-7.5\" /> </svg>\";s:22:\"breadcrumb_limit_style\";s:4:\"word\";s:21:\"breadcrumb_text_limit\";s:1:\"4\";s:19:\"breadcrumb_end_text\";s:3:\"...\";s:14:\"post_hierarchy\";s:13:\"post-category\";s:21:\"breadcrumb_text_color\";s:7:\"#27272a\";s:21:\"breadcrumb_link_color\";s:7:\"#337ab7\";s:25:\"breadcrumb_separate_color\";s:7:\"#cccccc\";s:27:\"breadcrumb_background_color\";s:7:\"#edeff0\";s:20:\"breadcrumb_font_size\";s:2:\"16\";}", "auto");
INSERT INTO `wp_options` VALUES("2206", "wpp_settings", "a:9:{s:12:\"persian_date\";s:6:\"enable\";s:12:\"enable_fonts\";s:6:\"enable\";s:12:\"conv_excerpt\";s:6:\"enable\";s:13:\"conv_comments\";s:6:\"enable\";s:18:\"conv_comment_count\";s:6:\"enable\";s:10:\"conv_dates\";s:6:\"enable\";s:11:\"news_source\";s:5:\"parsi\";s:17:\"date_in_admin_bar\";s:6:\"enable\";s:16:\"months_name_type\";s:7:\"persian\";}", "auto");
INSERT INTO `wp_options` VALUES("2207", "widget_parsidate_archive", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("2208", "widget_parsidate_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("2227", "_elementor_settings_update_time", "1750019263", "auto");
INSERT INTO `wp_options` VALUES("2228", "elementor_cpt_support", "a:5:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:17:\"business-partners\";i:3;s:15:\"representatives\";i:4;s:8:\"products\";}", "auto");
INSERT INTO `wp_options` VALUES("2229", "elementor_disable_color_schemes", "", "auto");
INSERT INTO `wp_options` VALUES("2230", "elementor_disable_typography_schemes", "", "auto");
INSERT INTO `wp_options` VALUES("2231", "elementor_google_maps_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("2232", "elementor_pro_recaptcha_site_key", "", "auto");
INSERT INTO `wp_options` VALUES("2233", "elementor_pro_recaptcha_secret_key", "", "auto");
INSERT INTO `wp_options` VALUES("2234", "elementor_pro_recaptcha_v3_site_key", "", "auto");
INSERT INTO `wp_options` VALUES("2235", "elementor_pro_recaptcha_v3_secret_key", "", "auto");
INSERT INTO `wp_options` VALUES("2236", "elementor_pro_recaptcha_v3_threshold", "0.5", "auto");
INSERT INTO `wp_options` VALUES("2237", "elementor_pro_facebook_app_id", "", "auto");
INSERT INTO `wp_options` VALUES("2238", "elementor_pro_mailchimp_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("2239", "elementor_validate_api_data", "", "auto");
INSERT INTO `wp_options` VALUES("2240", "elementor_pro_drip_api_token", "", "auto");
INSERT INTO `wp_options` VALUES("2241", "elementor_pro_activecampaign_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("2242", "elementor_pro_activecampaign_api_url", "", "auto");
INSERT INTO `wp_options` VALUES("2243", "elementor_pro_getresponse_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("2244", "elementor_pro_convertkit_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("2245", "elementor_pro_mailerlite_api_key", "", "auto");
INSERT INTO `wp_options` VALUES("2246", "elementor_typekit-kit-id", "", "auto");
INSERT INTO `wp_options` VALUES("2248", "elementor_pro_stripe_test_secret_key", "", "auto");
INSERT INTO `wp_options` VALUES("2249", "elementor_validate_stripe_api_test_secret_key_button", "", "auto");
INSERT INTO `wp_options` VALUES("2250", "elementor_pro_stripe_live_secret_key", "", "auto");
INSERT INTO `wp_options` VALUES("2251", "elementor_validate_stripe_api_live_secret_key_button", "", "auto");
INSERT INTO `wp_options` VALUES("2252", "elementor_stripe_legal_disclaimer", "", "auto");
INSERT INTO `wp_options` VALUES("2253", "elementor_editor_break_lines", "", "auto");
INSERT INTO `wp_options` VALUES("2254", "elementor_google_font", "1", "auto");
INSERT INTO `wp_options` VALUES("2255", "elementor_form-submissions", "", "auto");
INSERT INTO `wp_options` VALUES("2256", "elementor_load_fa4_shim", "", "auto");
INSERT INTO `wp_options` VALUES("2257", "elementor_meta_generator_tag", "", "auto");
INSERT INTO `wp_options` VALUES("2258", "elementor_css_print_method", "external", "auto");
INSERT INTO `wp_options` VALUES("2259", "elementor_optimized_image_loading", "1", "auto");
INSERT INTO `wp_options` VALUES("2260", "elementor_optimized_gutenberg_loading", "1", "auto");
INSERT INTO `wp_options` VALUES("2261", "elementor_lazy_load_background_images", "1", "auto");
INSERT INTO `wp_options` VALUES("2262", "elementor_element_cache_ttl", "24", "auto");
INSERT INTO `wp_options` VALUES("2263", "elementor_experiment-e_optimized_markup", "default", "auto");
INSERT INTO `wp_options` VALUES("2264", "elementor_experiment-e_element_cache", "default", "auto");
INSERT INTO `wp_options` VALUES("2265", "elementor_experiment-cloud-library", "default", "auto");
INSERT INTO `wp_options` VALUES("2266", "elementor_experiment-container", "default", "auto");
INSERT INTO `wp_options` VALUES("2267", "elementor_experiment-nested-elements", "default", "auto");
INSERT INTO `wp_options` VALUES("2268", "elementor_experiment-mega-menu", "default", "auto");
INSERT INTO `wp_options` VALUES("2269", "elementor_experiment-e_font_icon_svg", "default", "auto");
INSERT INTO `wp_options` VALUES("2270", "elementor_experiment-additional_custom_breakpoints", "active", "auto");
INSERT INTO `wp_options` VALUES("2271", "elementor_experiment-e_local_google_fonts", "default", "auto");
INSERT INTO `wp_options` VALUES("2272", "elementor_experiment-theme_builder_v2", "default", "auto");
INSERT INTO `wp_options` VALUES("2273", "elementor_experiment-hello-theme-header-footer", "default", "auto");
INSERT INTO `wp_options` VALUES("2274", "elementor_experiment-editor_v2", "default", "auto");
INSERT INTO `wp_options` VALUES("2369", "jet_engine_modules", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("2373", "price_list", "a:1:{s:10:\"list_items\";a:7:{s:6:\"item-0\";a:4:{s:4:\"slug\";s:8:\"ghalpagh\";s:5:\"title\";s:12:\"قالپاق\";s:5:\"price\";s:3:\"2.1\";s:10:\"show_place\";a:1:{i:0;s:9:\"top-items\";}}s:6:\"item-1\";a:4:{s:4:\"slug\";s:5:\"separ\";s:5:\"title\";s:6:\"سپر\";s:5:\"price\";s:1:\"3\";s:10:\"show_place\";a:2:{i:0;s:9:\"top-items\";i:1;s:11:\"right-table\";}}s:6:\"item-2\";a:4:{s:4:\"slug\";s:4:\"test\";s:5:\"title\";s:15:\"آیتم تست\";s:5:\"price\";s:3:\"5.4\";s:10:\"show_place\";a:3:{i:0;s:9:\"top-items\";i:1;s:11:\"right-table\";i:2;s:10:\"left-table\";}}s:6:\"item-3\";a:4:{s:4:\"slug\";s:4:\"test\";s:5:\"title\";s:15:\"آیتم تست\";s:5:\"price\";s:3:\"5.4\";s:10:\"show_place\";a:3:{i:0;s:9:\"top-items\";i:1;s:11:\"right-table\";i:2;s:10:\"left-table\";}}s:6:\"item-4\";a:4:{s:4:\"slug\";s:4:\"test\";s:5:\"title\";s:15:\"آیتم تست\";s:5:\"price\";s:3:\"5.4\";s:10:\"show_place\";a:3:{i:0;s:9:\"top-items\";i:1;s:11:\"right-table\";i:2;s:10:\"left-table\";}}s:6:\"item-5\";a:4:{s:4:\"slug\";s:4:\"test\";s:5:\"title\";s:15:\"آیتم تست\";s:5:\"price\";s:3:\"5.4\";s:10:\"show_place\";a:3:{i:0;s:9:\"top-items\";i:1;s:11:\"right-table\";i:2;s:10:\"left-table\";}}s:6:\"item-6\";a:4:{s:4:\"slug\";s:4:\"test\";s:5:\"title\";s:15:\"آیتم تست\";s:5:\"price\";s:3:\"5.4\";s:10:\"show_place\";a:1:{i:0;s:10:\"left-table\";}}}}", "auto");
INSERT INTO `wp_options` VALUES("2582", "recovery_mode_email_last_sent", "1750924642", "auto");
INSERT INTO `wp_options` VALUES("2847", "elementor_font_awesome_pro_kit_id", "", "auto");
INSERT INTO `wp_options` VALUES("3542", "_transient_wpcode_used_library_snippets", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("3738", "elementor_notes_db_version", "5", "auto");
INSERT INTO `wp_options` VALUES("3742", "elementor_pro_remote_info_api_data_3.29.2", "a:2:{s:7:\"timeout\";i:1753654797;s:5:\"value\";s:245157:\"{\"stable_version\":\"3.30.1\",\"last_updated\":\"2025-07-22 13:41:54\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:228924:\\\"<h2>Elementor Pro - by Elementor.com<\\/h2>\\n<h4>3.30.1 - 2025-07-22<\\/h4>\\n<ul>\\n<li>Security Fix: Improved content sanitization in multiple widgets<\\/li>\\n<li>Fix: UI issue in Hotspot widget when Optimized Markup experiment is enabled<\\/li>\\n<li>Fix: Taxonomy filter not working in the Editor when Optimized Markup experiment is enabled<\\/li>\\n<\\/ul>\\n<h4>3.30.0 - 2025-07-01<\\/h4>\\n<ul>\\n<li>New: Introduced Full Website Templates in the Cloud - export, manage, and reuse full site kits across all your websites from one place<\\/li>\\n<li>Tweak: Activated &quot;Optimized Markup&quot; feature on new sites<\\/li>\\n<li>Tweak: Activated &quot;Menu&quot; feature on new sites<\\/li>\\n<li>Tweak: Improved error handling for Theme Builder display conditions<\\/li>\\n<li>Tweak: Added styling controls to Post Excerpt widget<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> and <code>aria-label<\\/code> attributes Post Navigation widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Form widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Login widget<\\/li>\\n<li>Tweak: Arranged content as lists in Portfolio and Posts widgets<\\/li>\\n<li>Tweak: Added Box Shadow and Text Shadow controls in Countdown widget<\\/li>\\n<li>Tweak: Moved image resolution control to content tab in Price List widget<\\/li>\\n<li>Tweak: Renamed and reorganized style sections in Price List widget<\\/li>\\n<li>Tweak: Added conditional logic to controls in Price Table widget<\\/li>\\n<li>Tweak: Grouped layout controls under list section in Price List widget<\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.6<\\/li>\\n<li>Fix: Inline font icons support doesn\'t work in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24367\\\">#24367<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18343\\\">#18343<\\/a>)<\\/li>\\n<li>Fix: Page Title condition doesn\'t work on child pages in Widget Display Conditions<\\/li>\\n<li>Fix: Editor users with &quot;Access to edit content only&quot; are able to delete elements<\\/li>\\n<li>Fix: Links are not crawlable in Video Playlist widget<\\/li>\\n<li>Fix: Uses hardcoded admin fonts in Video Playlist widget<\\/li>\\n<li>Fix: Editor freezes when the Form widget is used with a high PHP upload size limit<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled in Slides widget<\\/li>\\n<li>Fix: Plugin dependency not enforced in Elementor Pro<\\/li>\\n<li>Fix: Console shows deprecation warning in Global Widgets<\\/li>\\n<\\/ul>\\n<h4>3.29.2 - 2025-06-04<\\/h4>\\n<ul>\\n<li>Tweak: Added selectors to Menu widget for compatibility with Optimized Markup experiment<\\/li>\\n<\\/ul>\\n<h4>3.29.1 - 2025-05-28<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Price Table widget<\\/li>\\n<\\/ul>\\n<h4>3.29.0 - 2025-05-19<\\/h4>\\n<ul>\\n<li>New: Introduced Cloud Templates - save, manage, and reuse your templates across all your sites from a single cloud library<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> attributes in Share Buttons widget<\\/li>\\n<li>Tweak: Improved accessibility by grouping content with <code>role=region<\\/code> in the Video Playlist widget<\\/li>\\n<li>Fix: Focus color is not applied correctly for accessibility in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24239\\\">#24239<\\/a>)<\\/li>\\n<li>Fix: Common scripts loaded late when using the Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.28.4 - 2025-05-05<\\/h4>\\n<ul>\\n<li>Fix: Empty results appeared on the frontend when using the Taxonomy Filter with the \'Avoid Duplicates\' option in Loop Grid widget<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled and the Optimized Markup experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.28.3 - 2025-04-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved sidebar navigation flow on the Elementor Home screen<\\/li>\\n<\\/ul>\\n<h4>3.28.2 - 2025-03-30<\\/h4>\\n<ul>\\n<li>Fix: Default Elementor animation shown for logged-out users when using an &quot;External URL&quot; source in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.28.1 - 2025-03-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline and Form widgets<\\/li>\\n<\\/ul>\\n<h4>3.28.0 - 2025-03-17<\\/h4>\\n<ul>\\n<li>Tweak: Ensured File Upload field styles are overridden by global styles in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11651\\\">#11651<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17223\\\">#17223<\\/a>)<\\/li>\\n<li>Tweak: Updated Scroll Snap description to clarify incompatibility with animations and motion effects<\\/li>\\n<li>Tweak: Prevented special characters from being encoded in the email subject field in Form widget<\\/li>\\n<li>Tweak: Loaded module styles within the module instead of registering them in <code>plugin.php<\\/code><\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.5<\\/li>\\n<li>Tweak: Improved keyboard accessibility for menus in Editor Top Bar<\\/li>\\n<li>Tweak: Made the edit button accessible in the Template widget<\\/li>\\n<li>Tweak: Optimized Form widget performance by caching field assets <code>using get_style_depends()<\\/code> and <code>get_script_depends()<\\/code> methods<\\/li>\\n<li>Tweak: Added Text Shadow control in Testimonial Carousel, Call to Action and Animated Headline widgets<\\/li>\\n<li>Fix: Button icon alignment breaks when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16077\\\">#16077<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16511\\\">#16511<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17692\\\">#17692<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17922\\\">#17922<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19253\\\">#19253<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19370\\\">#19370<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21236\\\">#21236<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21844\\\">#21844<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28080\\\">#28080<\\/a>)<\\/li>\\n<li>Fix: Dropdown caret color did not follow menu item color when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17500\\\">#17500<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18466\\\">#18466<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21664\\\">#21664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24929\\\">#24929<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28064\\\">#28064<\\/a>)<\\/li>\\n<li>Fix: Page doesn\'t scroll up when a coupon error notice appears in Checkout widget<\\/li>\\n<\\/ul>\\n<h4>3.27.7 - 2025-03-13<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.27.6 - 2025-03-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Template Condition<\\/li>\\n<\\/ul>\\n<h4>3.27.5 - 2025-03-03<\\/h4>\\n<ul>\\n<li>Fix: The <code>wp_trigger_error<\\/code> function causes the site to crash instead of triggering a warning when used with ACF text<\\/li>\\n<\\/ul>\\n<h4>3.27.4 - 2025-02-16<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Screenshots module<\\/li>\\n<li>Security Fix: Improved code security enforcement in Query control<\\/li>\\n<li>Fix: ACF <code>true_false<\\/code> field causing a fatal error when used as a dynamic tag with third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/30170\\\">#30170<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.27.3 - 2025-02-06<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Stripe Button widget<\\/li>\\n<\\/ul>\\n<h4>3.27.2 - 2025-02-03<\\/h4>\\n<ul>\\n<li>Fix: Value type configuration issue causing errors when using ACF<\\/li>\\n<li>Fix: Hide content on responsive breakpoint option is not working on WordPress Menu widget when Optimized Markup experiment is activated<\\/li>\\n<\\/ul>\\n<h4>3.27.1 - 2025-01-27<\\/h4>\\n<ul>\\n<li>Tweak: Increased the number of items allowed in Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<li>Security Fix: Improved code security enforcement in Global widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Admin settings<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Empty custom fields are missing in the Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<\\/ul>\\n<h4>3.27.0 - 2025-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Removed the <code>elementor-widget-container<\\/code> div from the Menu, Loop, Table of Contents, Form, and Hotspot widgets as part of the Optimized Markup experiment to improve HTML structure<\\/li>\\n<li>Tweak: Reduced DOM size by optimizing the submit button markup in Search widget<\\/li>\\n<li>Tweak: Moved style loading to the head instead of the footer to improve CLS<\\/li>\\n<li>Tweak: Enabled conditional loading of Swiper.js based on widget dependencies to reduce unnecessary assets and improve page load times<\\/li>\\n<li>Tweak: Standardized navigation elements like arrows and bullets across all carousel and slider widgets for improved accessibility<\\/li>\\n<li>Tweak: Improved accessibility when the submit button has only an icon and no text in Search widget<\\/li>\\n<li>Tweak: Removed <code>load_plugin_textdomain()<\\/code> function from Elementor Pro<\\/li>\\n<\\/ul>\\n<h4>3.26.3 - 2025-01-07<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Search widget<\\/li>\\n<li>Fix: Height issues cause slideshow thumbnails to display incorrectly in Media Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29663\\\">#29663<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.2 - 2024-12-22<\\/h4>\\n<ul>\\n<li>Fix: Menu items are not clickable in various scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29191\\\">#29191<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.1 - 2024-12-17<\\/h4>\\n<ul>\\n<li>Fix: Restore deprecated <code>Plugin::enqueue_styles()<\\/code> function to avoid errors with 3rd party plugins<\\/li>\\n<\\/ul>\\n<h4>3.26.0 - 2024-12-16<\\/h4>\\n<ul>\\n<li>New: Introducing dynamic content support for Off-canvas in Loop Grid widget templates - enabling seamless display of additional content dynamically (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29049\\\">#29049<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28935\\\">#28935<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7106\\\">#7106<\\/a>)<\\/li>\\n<li>New: AdBlock Detection trigger for Popups - display targeted popups for visitors using ad blockers<\\/li>\\n<li>New: Added Reload Page link action for Dynamic Tags<\\/li>\\n<li>Tweak: Added &quot;Space Between Dots&quot; control to Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2526\\\">#2526<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3277\\\">#3277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21697\\\">#21697<\\/a>)<\\/li>\\n<li>Tweak: Replaced hidden <code>elementor-screen-only<\\/code> div with <code>aria-label<\\/code> attributes<\\/li>\\n<li>Tweak: Removed <code>elementor-widget-container<\\/code> div from Elementor widgets as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Optimize popup styling by loading it only when necessary<\\/li>\\n<li>Tweak: Updated Gap between slides control to support only PX units in Carousel widget<\\/li>\\n<li>Tweak: Removed the dependency between the Tabs handler and the Menu handler<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> in Carousel widgets<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=carousel<\\/code> to carousel wrapper<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=slide<\\/code> to slide wrapper<\\/li>\\n<li>Tweak: Optimized carousel widgets markup as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n<li>Tweak: Facebook widgets are no longer supported on mobile due to Facebook functionality changes<\\/li>\\n<li>Fix: Motion Effects sticky feature is not working when Scroll Snap is enabled<\\/li>\\n<li>Fix: Custom Image Resolution option is not working in Gallery widget<\\/li>\\n<li>Fix: \'Reading Settings\' unexpectedly reduces the number of posts displayed when using the Archive with Pagination setting<\\/li>\\n<li>Fix: Step Form does not scroll to the top when the first field is not an input field in Form widget<\\/li>\\n<li>Fix: Display Condition feature is available without an active Elementor license in Floating Elements<\\/li>\\n<li>Fix: Background options of Flip Box in Loop Grid widget are not working when images are added using ACF Dynamic Tags<\\/li>\\n<li>Fix: Dropdown icon in the Select field of the Form widget is cut off when the Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Incompatibility between Form widget and WPML when using Nested Elements<\\/li>\\n<li>Fix: Performance issues when changing the title name in the Menu widget<\\/li>\\n<li>Fix: Warnings appear when Element Caching is set to Inactive in Carousel widgets<\\/li>\\n<li>Fix: Swiper styling missing from Lightbox inside Gallery widgets<\\/li>\\n<\\/ul>\\n<h4>3.25.5 - 2024-12-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Popup overlay shown for non-logged users even when disabled<\\/li>\\n<\\/ul>\\n<h4>3.25.4 - 2024-11-20<\\/h4>\\n<ul>\\n<li>Tweak: Improved Global Widget loading method to enhance performance<\\/li>\\n<\\/ul>\\n<h4>3.25.3 - 2024-11-13<\\/h4>\\n<ul>\\n<li>Fix: Nested Elements are activated even when the Container experiment is inactive<\\/li>\\n<\\/ul>\\n<h4>3.25.2 - 2024-11-03<\\/h4>\\n<ul>\\n<li>Fix: Styling issues affecting popup layout when using a Dynamic Tag to open the popup<\\/li>\\n<li>Fix: Image captions are not displaying for non-logged-in users in Media Carousel widget<\\/li>\\n<li>Fix: Custom Add to Cart widget with Quantity enabled causes critical error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29159\\\">#29159<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.25.1 - 2024-10-31<\\/h4>\\n<ul>\\n<li>Fix: Multiple Custom Add to Cart widgets on the same page are adding the same product<\\/li>\\n<\\/ul>\\n<h4>3.25.0 - 2024-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added pagination functionality to the Live Results in Search widget<\\/li>\\n<li>Tweak: Added Anchor Offset control to allow precise positioning when scrolling to anchor links on the page<\\/li>\\n<li>Tweak: Load motion effects styles only when they are in use<\\/li>\\n<li>Tweak: Load sticky styles only when they are in use<\\/li>\\n<li>Tweak: Load popup styles only when they are in use<\\/li>\\n<li>Tweak: Load theme builder styles only when they are in use<\\/li>\\n<li>Tweak: Load transition styles for Call to Action and Gallery widgets only when they are in use<\\/li>\\n<li>Tweak: Load styles for Form widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for WooCommerce widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Theme Elements widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Carousel widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Pricing widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Floating Elements separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Link in Bio widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load minified CSS in the Loop Builder\'s Call to Action button in the Editor<\\/li>\\n<li>Tweak: Removed &quot;Payments&quot; module styles<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Payapl widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Stripe widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Merged &quot;Form Submissions&quot; feature into the version and moved it to the Advanced tab<\\/li>\\n<li>Tweak: Merged &quot;Display Conditions&quot; into the version<\\/li>\\n<li>Fix: Missing translation string for the empty message in the Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27580\\\">#27580<\\/a>)<\\/li>\\n<li>Fix: Local Storage and Session Storage were being used even when popups were not in use (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7151\\\">#7151<\\/a>)<\\/li>\\n<li>Fix: Masonry layout is not working when pagination is set to &quot;Load More&quot; or &quot;Infinite Scroll&quot; in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23684\\\">#23684<\\/a>)<\\/li>\\n<li>Fix: Extra gap between widgets on the frontend when using Off-canvas widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27706\\\">#27706<\\/a>)<\\/li>\\n<li>Fix: Pagination and custom queries did not work when the Posts Widget was saved as a Global Widget or used via shortcode<\\/li>\\n<li>Fix: Lightbox videos are missing controls and displayed at the wrong size in Media Carousel widget<\\/li>\\n<li>Fix: Pagination options with Individual Pagination not working as expected in Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Justified or Masonry layouts for the Pro Gallery would not display images on the frontend when inserted via nested tabs<\\/li>\\n<li>Fix: Error issue in the Loop Grid widget when used in theme parts with the Taxonomy Filter<\\/li>\\n<li>Fix: Removed the focus ring after clicking to open the Off Canvas inside the Editor<\\/li>\\n<li>Fix: Background gradient colors from the dynamic color tag values are not rendering on the frontend<\\/li>\\n<li>Fix: Excessive database requests generated by the Loop Grid widget<\\/li>\\n<li>Fix: Colors from Dynamic Tags were not rendered on the frontend<\\/li>\\n<li>Fix: Display issue in the Menu widget caused by the \'Native Intersection Observer API<\\/li>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget<\\/li>\\n<li>Fix: Content Width control inside the Mega Menu is displaying an empty value<\\/li>\\n<\\/ul>\\n<h4>3.24.4 - 2024-10-09<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<\\/ul>\\n<h4>3.24.3 - 2024-10-01<\\/h4>\\n<ul>\\n<li>Fix: Floating Elements template not loading when Single Page template is set with All Singular condition<\\/li>\\n<li>Fix: Form field styles not loading properly in various scenarios<\\/li>\\n<\\/ul>\\n<h4>3.24.2 - 2024-09-18<\\/h4>\\n<ul>\\n<li>Fix: Icons not displaying when Inline SVG Icons experiment is active in Link In Bio widgets and Floating Elements<\\/li>\\n<\\/ul>\\n<h4>3.24.1 - 2024-09-12<\\/h4>\\n<ul>\\n<li>Fix: Widget styles not loading correctly on front causing alignment inconsistencies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28676\\\">#28676<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.24.0 - 2024-09-10<\\/h4>\\n<ul>\\n<li>New: Introducing support for Variable Fonts - allowing for more dynamic and flexible text styling (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6703\\\">#6703<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11333\\\">#11333<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19277\\\">#19277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25485\\\">#25485<\\/a>)<\\/li>\\n<li>Tweak: Added \'Structure\' indication for widgets with Display Conditions applied (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28027\\\">#28027<\\/a>)<\\/li>\\n<li>Tweak: Added a new option for setting the live search results width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28280\\\">#28280<\\/a>)<\\/li>\\n<li>Tweak: Improved Honeypot field functionality in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28480\\\">#28480<\\/a>)<\\/li>\\n<li>Tweak: Added options to \'Copy\', \'Paste\', and \'Clear\' Display Conditions in Context Menu<\\/li>\\n<li>Tweak: Improved performance of the Menu widget when using Dynamic Tags in the URL field<\\/li>\\n<li>Tweak: Improved performance when using Dynamic Tags in Nested Elements<\\/li>\\n<li>Tweak: Added the option for users to disable Akismet for specific Elementor forms<\\/li>\\n<li>Tweak: Adjusted URL structure when presenting the Search Archive page in Search widget<\\/li>\\n<li>Tweak: Added the \'Create Template\' button in Search widget<\\/li>\\n<li>Tweak: Added an option to enable the \'Loader\' animation while live results are loading in Search widget<\\/li>\\n<li>Tweak: Load share buttons compatibility styles only when they are in use<\\/li>\\n<li>Tweak: Load dialog styles only when they are in use<\\/li>\\n<li>Tweak: Load global widget styles only during Editor preview<\\/li>\\n<li>Tweak: Conditionally load widget styles only when the widgets are used<\\/li>\\n<li>Tweak: Load styles for CTA hover animations only when they are in use<\\/li>\\n<li>Tweak: Load notes styles only when the WordPress Toolbar is displayed<\\/li>\\n<li>Tweak: Split <code>animations.min.css<\\/code> into multiple CSS files and load them conditionally<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Stable status<\\/li>\\n<li>Tweak: Merged Taxonomy Filter feature into the version<\\/li>\\n<li>Tweak: Merged Search feature into the version<\\/li>\\n<li>Tweak: Added a note to \'Current Query\' explaining the impact of WordPress settings on pagination within Archives<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for the Off-Canvas widget<\\/li>\\n<li>Fix: Manual Selection option is not excluding sticky posts in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18689\\\">#18689<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23331\\\">#23331<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28179\\\">#28179<\\/a>)<\\/li>\\n<li>Fix: Template ID does not change according to the imported Loop Item (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21404\\\">#21404<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22202\\\">#22202<\\/a>)<\\/li>\\n<li>Fix: \'Editing Mode\' for the Off-canvas was not functioning correctly in certain scenarios<\\/li>\\n<li>Fix: Added definition to <code>clear_custom_image_sizes<\\/code> hook to prevent edge case issues<\\/li>\\n<li>Fix: Flickering issue with search result buttons when closing results using the keyboard escape key in Search widget<\\/li>\\n<li>Fix: Theme Style settings for buttons were overriding the text styling in Search widget<\\/li>\\n<li>Fix: Nesting menu inside another menu causes functionality issues in Menu widget<\\/li>\\n<li>Fix: Error when using array as custom fields value in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.23.3 - 2024-08-05<\\/h4>\\n<ul>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28194\\\">#28194<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.23.2 - 2024-07-29<\\/h4>\\n<ul>\\n<li>Fix: Horizontal scroll bar appearing on the page when using Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28087\\\">#28087<\\/a>)<\\/li>\\n<li>Fix: Dropdown area disappearing in certain scenarios in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.23.1 - 2024-07-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in link URL<\\/li>\\n<\\/ul>\\n<h4>3.23.0 - 2024-07-15<\\/h4>\\n<ul>\\n<li>New: Search Widget with Live Results - Display live search results as visitors type into the search box, enhancing user experience and engagement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27664\\\">#27664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24931\\\">#24931<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21459\\\">#21459<\\/a>)<\\/li>\\n<li>Tweak: Renamed <code>width<\\/code> to <code>Min width<\\/code> and added <code>Max width<\\/code> control to Hotspot tooltips (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18930\\\">#18930<\\/a>)<\\/li>\\n<li>Tweak: Applied a logical DOM order to the Mega Menu widget to improve accessibility<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for WordPress Menu widget<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for Menu widget<\\/li>\\n<li>Tweak: Added a bottom option to the Image Position control in Call to Action widget<\\/li>\\n<li>Fix: Missing version string in included CSS query string when Improved CSS Loading is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21879\\\">#21879<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23821\\\">#23821<\\/a>)<\\/li>\\n<li>Fix: Form submission icon message does not display correctly when Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Save and Close button position issues in the conditions screen in Theme Builder.<\\/li>\\n<li>Fix: Focus appears on the first element when using the mouse to open Off-Canvas <\\/li>\\n<li>Fix: Links to Elementor Settings are broken in various locations<\\/li>\\n<li>Fix: Conditions field not showing all relevant conditions in Theme Builder<\\/li>\\n<li>Fix: Off-Canvas flickering in sticky containers with exit animations triggered by sticky effects<\\/li>\\n<\\/ul>\\n<h4>3.22.1 - 2024-06-24<\\/h4>\\n<ul>\\n<li>Fix: Styling of Global widgets not loading when Element Caching experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27704\\\">#27704<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.22.0 - 2024-06-16<\\/h4>\\n<ul>\\n<li>New: Introducing Off-Canvas widget - create engaging and creative layers triggered by a link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6225\\\">#6225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21769\\\">#21769<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25770\\\">#25770<\\/a>)<\\/li>\\n<li>Tweak: Added option to remove \'User IP\' and \'User Agent\' from the form submissions metadata (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14285\\\">#14285<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>waypoints.js<\\/code> library with the native Intersection Observer API<\\/li>\\n<li>Tweak: Extended Alignment and Position capabilities in Form widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Flip Box widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Call to Action widget<\\/li>\\n<li>Tweak: Optimized Form widget to eliminate unnecessary markup when the button icon is empty<\\/li>\\n<li>Tweak: Optimized Posts widget to eliminate unnecessary markup when Load More button text is empty<\\/li>\\n<li>Tweak: Remove <code>placeholder<\\/code> arguments from URL controls<\\/li>\\n<li>Tweak: Implemented CSS logical properties to Icon Position in Form, Posts and Menu Cart widgets<\\/li>\\n<li>Tweak: Activated Display Conditions feature for existing sites<\\/li>\\n<li>Tweak: Activated Taxonomy Filter feature for existing sites<\\/li>\\n<li>Tweak: Added functionality to delay the running of the ready triggers on inner elements<\\/li>\\n<li>Fix: Icons are now part of the link in the Menu Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24298\\\">#24298<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25112\\\">#25112<\\/a>)<\\/li>\\n<li>Fix: <code>all: unset<\\/code> assigned to buttons cause focus issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24322\\\">#24322<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25448\\\">#25448<\\/a>)<\\/li>\\n<li>Fix: Menu cart SVG icon disappears on front when Optimized Control Loading experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27342\\\">#27342<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro auto-updates are not working on multisite networks (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12615\\\">#12615<\\/a>)<\\/li>\\n<li>Fix: PHP error appears in the editor when using Loop Grid in an archive template<\\/li>\\n<li>Fix: UI glitch on Icon Position control in Paypal and Stripe Buttons widgets<\\/li>\\n<li>Fix: Icon Position control RTL issue in Hotspot widget<\\/li>\\n<li>Fix: Manual Selection &quot;Include By&quot; Query doesn\'t work with product categories<\\/li>\\n<\\/ul>\\n<h4>3.21.3 - 2024-05-20<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Loop Grid widget<\\/li>\\n<li>Fix: License expired affects the Display Conditions functionality in the front end<\\/li>\\n<\\/ul>\\n<h4>3.21.2 - 2024-04-30<\\/h4>\\n<ul>\\n<li>Fix: Special characters are not displayed correctly when using the Excerpt widget in Loop template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25860\\\">#25860<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.21.1 - 2024-04-24<\\/h4>\\n<ul>\\n<li>Fix: Excerpt Length setting doesn\'t function correctly for languages with non-English characters in Post Excerpt widget<\\/li>\\n<\\/ul>\\n<h4>3.21.0 - 2024-04-15<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Taxonomy Query - Enabling the display of post and product categories and tags within Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21372\\\">#21372<\\/a>)<\\/li>\\n<li>Tweak: Optimized Hotspot widget to prevent rendering when no image is provided<\\/li>\\n<li>Tweak: Optimized Blockquote widget to eliminate unnecessary markup when devoid of content<\\/li>\\n<li>Tweak: Optimized Template widget to eliminate unnecessary markup when no template is selected<\\/li>\\n<li>Tweak: Optimized Code Highlight widget to eliminate unnecessary markup when there is no content<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Portfolio widget<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Author Avatar image alt text in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25440\\\">#25440<\\/a>)<\\/li>\\n<li>Tweak: Notes feature merged to version<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Profile Picture alt text in Author widget<\\/li>\\n<li>Fix: Display issue on hover state in WooCommerce Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.20.3 - 2024-04-10<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issue between the My Account widget and other third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20986\\\">#20986<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.20.2 - 2024-03-26<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Post Navigation widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Gallery widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.20.1 - 2024-03-20<\\/h4>\\n<ul>\\n<li>Fix: Strengthened code integrity in deprecated Woo Single Element widget<\\/li>\\n<li>Fix: PHP error notice appears when using Loop Grid with the Taxonomy Filter widgets<\\/li>\\n<\\/ul>\\n<h4>3.20.0 - 2024-03-11<\\/h4>\\n<ul>\\n<li>Tweak: Implemented OR logic in the Display Conditions feature<\\/li>\\n<li>Tweak: Added X and Threads social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25299\\\">#25299<\\/a>)<\\/li>\\n<li>Tweak: Added Archive Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Alt dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Caption dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Bio dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Email dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Website dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Page Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Post Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Comments Number rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Archive Author rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added support for WordPress Custom Fields in Display Conditions feature<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23875\\\">#23875<\\/a>)<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Login widget<\\/li>\\n<li>Tweak: Added additional style controls in the Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration option in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21295\\\">#21295<\\/a>)<\\/li>\\n<li>Tweak: Added Transition Duration to button in Flip Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Author Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to List in Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Login widget<\\/li>\\n<li>Tweak: Added Transition Duration in Post Navigation widget<\\/li>\\n<li>Tweak: Added Transition Duration Show More in Video Playlist widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Form widget<\\/li>\\n<li>Tweak: Removed separator-none argument from all Editor controls<\\/li>\\n<li>Tweak: Add <code>&lt;time&gt;<\\/code> wrapper for Date and Time items in Post Info widget<\\/li>\\n<li>Tweak: Page Transitions feature merged to version<\\/li>\\n<li>Tweak: Scroll Snap feature merged to version<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Beta status and activated for new sites<\\/li>\\n<li>Tweak: Promoted Taxonomy Filter feature to beta status and activated for new sites<\\/li>\\n<li>Fix: Page Transitions feature and Load Font Awesome 4 Support cause a console error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18885\\\">#18885<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19334\\\">#19334<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21082\\\">#21082<\\/a>)<\\/li>\\n<li>Fix: Added better output escaping in Taxonomy Filter widget<\\/li>\\n<\\/ul>\\n<h4>3.19.3 - 2024-02-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved Loop CSS loading structure in Loop Grid item<\\/li>\\n<li>Security Fix: Addressed security weaknesses in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.19.2 - 2024-02-07<\\/h4>\\n<ul>\\n<li>Fix: Export data inconsistencies when using form actions in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.19.1 - 2024-02-05<\\/h4>\\n<ul>\\n<li>Fix: Enqueuing non-existing Loop Template CSS file in Loop Item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24959\\\">#24959<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>3.19.0 - 2024-01-29<\\/h4>\\n<ul>\\n<li>New: Introducing Display Conditions for Elements - allowing users to customize content visibility based on specified criteria (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4246\\\">#4246<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21152\\\">#21152<\\/a>)<\\/li>\\n<li>New: Implemented Akismet Integration for enhanced spam protection and security in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11401\\\">#11401<\\/a>)<\\/li>\\n<li>New: Introducing Permissions functionality to Element Manager - providing users with enhanced control over access and management capabilities<\\/li>\\n<li>Tweak: Added styling option for dropdown indicator in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21907\\\">#21907<\\/a>)<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Implemented CSS logical properties in WordPress Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Reviews widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Countdown widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Updated <code>jquery.smartmenus.js<\\/code> version from 1.1.1 to 1.2.0<\\/li>\\n<li>Fix: Dynamic Background Image does not load on the first Loop Item in a Loop Grid (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21489\\\">#21489<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22368\\\">#22368<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23085\\\">#23085<\\/a>)<\\/li>\\n<li>Fix: History panel deprecation notices in console log<\\/li>\\n<li>Fix: Second Pro rollback installed the latest version instead of the specifically selected older version<\\/li>\\n<li>Fix: Incorrect position of the dropdown content when applying entrance animation in Menu Widget<\\/li>\\n<li>Fix: UX issues when using in-place editing in Menu widget<\\/li>\\n<li>Fix: Pagination with page reload is not working when used with the Taxonomy filter and Loop Grid widget in Archive template<\\/li>\\n<\\/ul>\\n<h4>3.18.2 - 2023-12-20<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Price List widget<\\/li>\\n<li>Fix: Error messages related to loop filter appear on front when using PHP 8.X and <code>WP_DEBUG<\\/code> is true<\\/li>\\n<\\/ul>\\n<h4>3.18.1 - 2023-12-06<\\/h4>\\n<ul>\\n<li>Fix: No results appeared when reloading the page with deep link and de-selecting terms in Taxonomy Filter widget<\\/li>\\n<li>Fix: No results appeared when filtering the Uncategorized category in Filter Taxonomy widget<\\/li>\\n<li>Fix: Notes still available when the Notes feature is deactivated<\\/li>\\n<\\/ul>\\n<h4>3.18.0 - 2023-12-04<\\/h4>\\n<ul>\\n<li>Tweak: Added the ability to upload files as attachments to emails in the File Upload field in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4868\\\">#4868<\\/a>)<\\/li>\\n<li>Tweak: Introduced the capability to design and edit the empty state in the Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24261\\\">#24261<\\/a>)<\\/li>\\n<li>Tweak: Implemented the option to close the menu content area with a click anywhere on the screen in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22686\\\">#22686<\\/a>)<\\/li>\\n<li>Tweak: Improve scrolling behavior inside the content area when there is not enough space in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22712\\\">#22712<\\/a>)<\\/li>\\n<li>Tweak: Expanded breakpoint options in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22488\\\">#22488<\\/a>)<\\/li>\\n<li>Tweak: Added Logical Combination control in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added additional units to Horizontal and Vertical padding for Dropdown in WordPress Menu widget<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in Loop Carousel and Carousel widgets<\\/li>\\n<li>Tweak: Added various HTML Tag controls in Video Playlist widget<\\/li>\\n<li>Tweak: Added responsive control to navigation size in Slides, Reviews, Media Carousel and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Search Form widget<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added Multiple Selection control in Taxonomy Filter widget<\\/li>\\n<li>Fix: Deprecated notice when using ${var} in strings instead of {$var} with PHP 8.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23927\\\">#23927<\\/a>)<\\/li>\\n<li>Fix: Dropdown indicator position issue in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23947\\\">#23947<\\/a>)<\\/li>\\n<li>Fix: Dynamic Tags are not available when choosing \'self-hosted\' source in Video widget<\\/li>\\n<li>Fix: Telephone field placeholder is aligned to the left in RTL websites in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.17.1 - 2023-11-01<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Code Highlight, Form, Lottie, Price List, and Video Playlist widgets<\\/li>\\n<\\/ul>\\n<h4>3.17.0 - 2023-10-25<\\/h4>\\n<ul>\\n<li>Tweak: Added AJAX pagination option or seamless page navigation between content in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>)<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Post widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Loop Grid widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Added a None option to the breakpoint options in Menu widget<\\/li>\\n<li>Tweak: Added a horizontal scrolling option in Menu widget<\\/li>\\n<li>Tweak: Upgraded minimum required PHP version to 7.3<\\/li>\\n<li>Tweak: Improved accessibility when minimize button is disabled in Table of Content widget<\\/li>\\n<li>Fix: Table of Content widget without icons displays <code>undefined<\\/code> error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17523\\\">#17523<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17768\\\">#17768<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18463\\\">#18463<\\/a>)<\\/li>\\n<li>Fix: Hover behavior issues on menu items in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23430\\\">#23430<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22431\\\">#22431<\\/a>)<\\/li>\\n<li>Fix: Links inside Loop Carousel are not working on initial load in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23705\\\">#23705<\\/a>)<\\/li>\\n<li>Fix: Popups accessible navigation adds outlines to the wrong first focusable element<\\/li>\\n<li>Fix: Dropdown area aligned to the left side of the screen if contains Tabs widget in Menu widget<\\/li>\\n<li>Fix: Content horizontal position not aligning correctly when used with carousel widgets in Menu widget<\\/li>\\n<li>Fix: Accessibility errors in PageSpeed Insights in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.16.2 - 2023-09-20<\\/h4>\\n<ul>\\n<li>Fix: Fit to Content dropdown position calculation is incorrect in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23808\\\">#23808<\\/a>)<\\/li>\\n<li>Fix: Reverted hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23804\\\">#23804<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.16.1 - 2023-09-14<\\/h4>\\n<ul>\\n<li>Fix: Dynamic tag for ACF image field is not working as expected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23757\\\">#23757<\\/a>)<\\/li>\\n<li>Fix: Sticky functionality affects padding values in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23758\\\">#23758<\\/a>)<\\/li>\\n<li>Fix: HTML list issues for padding and margin in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.16.0 - 2023-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23607\\\">#23607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22554\\\">#22554<\\/a>)<\\/li>\\n<li>Fix: \'Fallback: Recent Posts\' option malfunctions in the Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21436\\\">#21436<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23259\\\">#23259<\\/a>)<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22056\\\">#22056<\\/a>)<\\/li>\\n<li>Tweak: Used appropriate image <code>alt<\\/code> in Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17680\\\">#17680<\\/a>)<\\/li>\\n<li>Tweak: Optimized Scroll Snap functionality when using Container widget<\\/li>\\n<li>Tweak: Enhanced Elementor Role Manager functionality when using Containers<\\/li>\\n<li>Tweak: Added Notes feature to the Editor Top Bar<\\/li>\\n<li>Tweak: Replace CSS <code>float<\\/code> with other layouts in the Editor<\\/li>\\n<li>Tweak: Upgraded HTML Structure for the Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Carousel and Menu widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to a link in Posts widget<\\/li>\\n<li>Tweak: Loop Builder feature merged to version<\\/li>\\n<li>Fix: Addressed inconsistency in hover effect durations between icon, dropdown indicator colors, and text colors in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22376\\\">#22376<\\/a>)<\\/li>\\n<li>Fix: Slides break if the parent container is set to HTML A tag in Loop Carousel and Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22678\\\">#22678<\\/a>)<\\/li>\\n<li>Fix: The icon size setting is not affecting uploaded SVG icons in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22372\\\">#22372<\\/a>)<\\/li>\\n<li>Fix: Taxonomy filter does not work with slug in foreign characters (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23315\\\">#23315<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Dynamic Tags<\\/li>\\n<li>Fix: Sticky container incorrectly adjusts its width when transitioning from a smaller breakpoint to a larger one within the Editor<\\/li>\\n<\\/ul>\\n<h4>3.15.1 - 2023-08-09<\\/h4>\\n<ul>\\n<li>Fix: Improved code security enforcement in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.15.0 - 2023-07-31<\\/h4>\\n<ul>\\n<li>New: Introducing Taxonomy Filter widget - Empower visitors to seamlessly filter listings in Loop Grids based on taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3140\\\">#3140<\\/a>)<\\/li>\\n<li>Tweak: Added an &quot;Offset Sides&quot; functionality in Carousel and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21114\\\">#21114<\\/a>)<\\/li>\\n<li>Tweak: Modified the size of the Publish button in the Editor Top Bar feature (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22472\\\">#22472<\\/a>)<\\/li>\\n<li>Tweak: Improved Ajax permissions functionality for better security enforcement<\\/li>\\n<li>Tweak: Added option for pagination custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added option for navigation custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added additional styling options for navigation in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added labels to shortcode column in WordPress admin<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in Menu widget<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in My Account widget<\\/li>\\n<li>Tweak: Improved panel UI in Video Playlist widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Price List widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Slides widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Flip Box widget<\\/li>\\n<li>Tweak: Added &quot;Description HTML Tag&quot; in Call To Action widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Share Buttons widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: WooCommerce Status page failed to recognize Elementor WooCommerce widgets<\\/li>\\n<li>Fix: Pagination does not work inside single templates when using Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Incorrect saving of WooCommerce page settings in Elementor site settings under certain scenarios<\\/li>\\n<\\/ul>\\n<h4>3.14.1 - 2023-06-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved navigation on touch devices in Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22827\\\">#22827<\\/a>)<\\/li>\\n<li>Fix: Missing navigation arrows on lightbox in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22870\\\">#22870<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.14.0 - 2023-06-19<\\/h4>\\n<ul>\\n<li>New: Introducing Carousel widget - Infinite design possibilities, and nesting capabilities (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2587\\\">#2587<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>Tweak: Added Static Item Position functionality to Alternate template in Loop Grid widget<\\/li>\\n<li>Tweak: Added visual indication of Page Parts<\\/li>\\n<li>Tweak: Added dividers option between menu items in Menu widget<\\/li>\\n<li>Tweak: Changed the HTML structure of Pagination and Navigation in Loop Carousel and Nested Carousel widgets<\\/li>\\n<li>Tweak: Added shop page in WooCommerce Pages section in Site Settings<\\/li>\\n<li>Tweak: Added Text Shadow, Box Shadow and Padding control to button in Call to Action widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Video Playlist widget<\\/li>\\n<li>Tweak: Added <code>alt<\\/code> attribute to images in Video Playlist widget<\\/li>\\n<li>Tweak: Replaced select control with choose control for Flip Direction control in Flip Box widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Use <code>media_types<\\/code> array in Media controls<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11193\\\">#11193<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19871\\\">#19871<\\/a>)<\\/li>\\n<li>Fix: Responsive settings for templates don\'t work as expected when Additional Custom Breakpoints feature is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16819\\\">#16819<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19394\\\">#19394<\\/a>)<\\/li>\\n<li>Fix: Inner containers are not presented as expected in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21813\\\">#21813<\\/a>)<\\/li>\\n<li>Fix: Popup width does not support percentages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22413\\\">#22413<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x throws errors when using WooCommerce Ajax response (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22199\\\">#22199<\\/a>)<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22789\\\">#22789<\\/a>)<\\/li>\\n<li>Fix: Order by Price doesn\'t work for the Latest products or Manual Selection in Products widget<\\/li>\\n<li>Fix: Dropdown indicator icon is not vertically aligned to the text when using icon in Menu Widget<\\/li>\\n<li>Fix: Mixed content warning in the console for Video Playlist widget<\\/li>\\n<li>Fix: Preview settings are not presented as expected after first save in Loop Template<\\/li>\\n<li>Fix: Not-crawlable link error in Video Playlist widget<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Logo widget<\\/li>\\n<li>Fix: Focus state issue on page load when using Table of Content widget<\\/li>\\n<\\/ul>\\n<h4>3.13.2 - 2023-05-22<\\/h4>\\n<ul>\\n<li>Fix: Hover settings not working as expected on Touch-Enabled devices in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22258\\\">#22258<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.1 - 2023-05-11<\\/h4>\\n<ul>\\n<li>Security Fix: Addressed security weaknesses in access management related functions<\\/li>\\n<li>Fix: Excerpt content pulled from post content is showing with HTML tags in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22367\\\">#22367<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.0 - 2023-05-08<\\/h4>\\n<ul>\\n<li>Tweak: Provided an option to assign excerpt automatically from post content in Post Excerpt dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20256\\\">#20256<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21715\\\">#21715<\\/a>)<\\/li>\\n<li>Tweak: Added Display Conditions functionality in Editor Top bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21675\\\">#21675<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22050\\\">#22050<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor_page_id<\\/code> from request URLs in the WC AJAX calls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18675\\\">#18675<\\/a>)<\\/li>\\n<li>Tweak: Added icons to menu items in Mega Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/21602\\\">#21602<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility to Toggle Button in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/2348\\\">#2348<\\/a>)<\\/li>\\n<li>Tweak: Added \'Active item state\' to top-level menu items for anchor links in the Menu widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Loop Carousel widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Slides widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Media, Testimonial and Reviews Carousel widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to Table of Content widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Search Form widget<\\/li>\\n<li>Tweak: Added accessibility to images in Slides widget<\\/li>\\n<li>Tweak: Added accessibility to images in Call To Action widget<\\/li>\\n<li>Tweak: Added accessibility to images in Media Carousel widget<\\/li>\\n<li>Tweak: Added accessibility to images in Gallery widget<\\/li>\\n<li>Tweak: Added Lazy Load support for avatar image in Post Info widget<\\/li>\\n<li>Tweak: Added Lazy Load support to various Elementor Editor and Admin images<\\/li>\\n<li>Tweak: Added Lazy Load support for author image in Author Box widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Price List widget<\\/li>\\n<li>Fix: Content width is affected by the widget\'s width when Content Width is set to Fit to Content in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21842\\\">#21842<\\/a>)<\\/li>\\n<li>Fix: Empty value on Rows field causes an error in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21451\\\">#21451<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.2 - 2023-04-09<\\/h4>\\n<ul>\\n<li>Fix: Mini cart template appears as empty in various WordPress themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21836\\\">#21836<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.1 - 2023-04-02<\\/h4>\\n<ul>\\n<li>Fix: Default background colors are presented as transparent in Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21824\\\">#21824<\\/a>)<\\/li>\\n<li>Fix: Reverted the tweak of Form Submissions feature merged to the version (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21821\\\">#21821<\\/a>)<\\/li>\\n<li>Fix: Dropdown area is not closing when hovering outside of the content area in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.12.0 - 2023-03-29<\\/h4>\\n<ul>\\n<li>New: Introducing the Mega Menu with the new Menu widget - empowers you to achieve a much higher level of menu design, customization, and creativity<\\/li>\\n<li>New: Diversify your design with a Loop Alternate template - apply another template within your Loop Grid for design creativity<\\/li>\\n<li>New: Kickstart your workflow with predesigned Loop container-based templates<\\/li>\\n<li>Tweak: Added custom icon controls to various locations in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13678\\\">#13678<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17941\\\">#17941<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19295\\\">#19295<\\/a>)<\\/li>\\n<li>Tweak: Added a spacing control between navigation and slides in the Loop Carousel<\\/li>\\n<li>Tweak: Added responsive control to the \'Gap between slides\' control in the Loop Carousel<\\/li>\\n<li>Tweak: Added Custom CSS section in Loop Item template<\\/li>\\n<li>Tweak: Added an Article class metadata in Loop Item template<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in CTA widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in Flipbox widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Changed Nav Menu widget name to WordPress Menu widget<\\/li>\\n<li>Tweak: Added &quot;Form Validation&quot; control to Form widget<\\/li>\\n<li>Tweak: Updated custom messages in the Form widget<\\/li>\\n<li>Tweak: Improved accessibility in various elements in Gallery widget<\\/li>\\n<li>Tweak: Form Submissions feature merged to version<\\/li>\\n<li>Tweak: Loop feature promoted to Stable status<\\/li>\\n<li>Tweak: Page Transitions feature promoted to Stable status<\\/li>\\n<li>Tweak: Improved accessibility in filter bar in Gallery widget<\\/li>\\n<li>Tweak: Remove unused <code>aspect-ratio-*<\\/code> CSS classes<\\/li>\\n<li>Fix: Not all active breakpoints appear under &quot;Advanced Rules&quot; in popup publish settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17020\\\">#17020<\\/a>)<\\/li>\\n<li>Fix: Dynamic background image and video is not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.11.7 - 2023-03-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in WooCommerce components<\\/li>\\n<\\/ul>\\n<h4>3.11.6 - 2023-03-14<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in Author Box and Countdown widgets<\\/li>\\n<\\/ul>\\n<h4>3.11.5 - 2023-03-12<\\/h4>\\n<ul>\\n<li>Fix: Hamburger Menu Toggle not showing if breakpoint is set to Tablet Extra in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21003\\\">#21003<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.4 - 2023-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Prevented SVG file upload for better security enforcement in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.11.3 - 2023-02-26<\\/h4>\\n<ul>\\n<li>Fix: Error message appears when submitting a form placed below Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21432\\\">#21432<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x compatibility issues in various places<\\/li>\\n<\\/ul>\\n<h4>3.11.2 - 2023-02-22<\\/h4>\\n<ul>\\n<li>Fix: Save &amp; Back handle becomes inaccessible in various scenarios cases in Loop Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316\\\">#21316<\\/a>)<\\/li>\\n<li>Fix: Can\'t edit page when using \'Content Tabs\' and \'Section\' options in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.11.1 - 2023-02-15<\\/h4>\\n<ul>\\n<li>Fix: Featured Image dynamic tag is not working in Background images (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21313\\\">#21313<\\/a>)<\\/li>\\n<li>Fix: Time zone is not correct in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17485\\\">#17485<\\/a>)<\\/li>\\n<li>Fix: File upload field is not working in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21341\\\">#21341<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21314\\\">#21314<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.0 - 2023-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Carousel widget - Create powerful &amp; repeating loop templates and populate each one with dynamic content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>New: Added Date and Time Range option to Advanced Rules in Popup<\\/li>\\n<li>Tweak: Improved accessibility when opening and closing a popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9788\\\">#9788<\\/a>)<\\/li>\\n<li>Tweak: Improved accessibility of full-screen mode in Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19907\\\">#19907<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility support to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5861\\\">#5861<\\/a>)<\\/li>\\n<li>Tweak: Add <code>aria-label<\\/code> to read more link in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13784\\\">#13784<\\/a>)<\\/li>\\n<li>Tweak: Use <code>aspect-ratio<\\/code> property instead of CSS trick in Media Carousel widget<\\/li>\\n<li>Tweak: Updated translation string in Stripe widget<\\/li>\\n<li>Fix: Masonry and Columns controls are not working as expected with responsive in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20670\\\">#20670<\\/a>)<\\/li>\\n<li>Fix: Invalid attributes names in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17400\\\">#17400<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working as expected in various widgets<\\/li>\\n<li>Fix: Form fields order is not presented correctly when exported to CSV in Form Submissions<\\/li>\\n<li>Fix: Dynamic background image and video are not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.10.3 - 2023-01-29<\\/h4>\\n<ul>\\n<li>Tweak: Added introduction video to loop item information modal in Theme Builder<\\/li>\\n<li>Fix: PHP 8.x throws errors and notices in some cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21087\\\">#21087<\\/a>)<\\/li>\\n<li>Fix: Infinite Scroll and Load on click pagination are not working as expected in Archive template<\\/li>\\n<li>Fix: Show row even when values do not exist in Form Submissions<\\/li>\\n<\\/ul>\\n<h4>3.10.2 - 2023-01-17<\\/h4>\\n<ul>\\n<li>Fix: Updated compatibility tag for Elementor v3.10<\\/li>\\n<\\/ul>\\n<h4>3.10.1 - 2023-01-09<\\/h4>\\n<p>Fix: Preview Could not be loaded error message appears on pages containing the Loop Grid in a header or footer templates<\\/p>\\n<h4>3.10.0 - 2023-01-09<\\/h4>\\n<ul>\\n<li>New: Added new dynamic tag for due date in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7737\\\">#7737<\\/a>)<\\/li>\\n<li>Tweak: Added <code>modified<\\/code> and <code>comment_count<\\/code> to Order By in posts query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11159\\\">#11159<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>footer<\\/code> tag in Blockquote and Comments widgets for better semantics<\\/li>\\n<li>Fix: Compatibility issue in Imagify Media Library filters due to <code>_elementor_is_screenshot<\\/code> meta filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19988\\\">#19988<\\/a>)<\\/li>\\n<li>Fix: Hotspot Widget label icon height issues when Inline Font Icons experiment is active<\\/li>\\n<li>Fix: Editing glitch when using two loop grid widgets on the same page with the same loop item template<\\/li>\\n<li>Fix: Equal height is not working when using sections in Loop Grid widget<\\/li>\\n<li>Fix: Large amount of menu items are not appearing correctly on a mobile device in Nav Menu widget<\\/li>\\n<li>Fix: Featured Image does not change dynamically when using infinite\\/click pagination in Loop Grid widget<\\/li>\\n<li>Fix: Removed action call of non-existent <code>display_empty_cart_template()<\\/code> method in Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.9.2 - 2022-12-21<\\/h4>\\n<ul>\\n<li>Fix: JS events do not trigger in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20708\\\">#20708<\\/a>)<\\/li>\\n<li>Fix: PHP Errors appear when not using the toggle menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18636\\\">#18636<\\/a>)<\\/li>\\n<li>Fix: Popups\' backgrounds disappear when using Lazy Load Background Images experiment<\\/li>\\n<\\/ul>\\n<h4>3.9.1 - 2022-12-14<\\/h4>\\n<ul>\\n<li>Fix: WooCommerce Product Gallery dynamic tag is not working in Basic Gallery, Gallery and Image Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20678\\\">#20678<\\/a>)<\\/li>\\n<li>Fix: Hide Empty option is not working in Menu Cart widget<\\/li>\\n<li>Fix: The Stripe Button widget doesn\'t work in Templates<\\/li>\\n<\\/ul>\\n<h4>3.9.0 - 2022-12-06<\\/h4>\\n<ul>\\n<li>New: Added support for WooCommerce to Loop Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20020\\\">#20020<\\/a>)<\\/li>\\n<li>Tweak: Added more options to \'Show up to X times\' advanced rule in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8187\\\">#8187<\\/a>)<\\/li>\\n<li>Tweak: Allow saving and reloading a page while editing in-place loop item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19882\\\">#19882<\\/a>)<\\/li>\\n<li>Tweak: Added <code>$location param<\\/code> to <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18453\\\">#18453<\\/a>)<\\/li>\\n<li>Tweak: Removed redundant labels from group controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11666\\\">#11666<\\/a>)<\\/li>\\n<li>Tweak: Added support to use sections and columns as the layout structure of a Loop item template<\\/li>\\n<li>Tweak: Disabled movement when a repeater item is in focus in edit mode<\\/li>\\n<li>Tweak: Upgrade the autoprefixer package to better minify CSS files<\\/li>\\n<li>Tweak: Removed duplicate SQL queries on every page for better performance<\\/li>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Added more units options to Border Width control in various elements<\\/li>\\n<li>Tweak: Added <code>em<\\/code> units to Border Radius control in various elements<\\/li>\\n<li>Tweak: Added \'Equal height\' functionality to Loop Grid widget<\\/li>\\n<li>Fix: Issue with Related Products widget and WooCommerce Pixel Manager plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16934\\\">#16934<\\/a>)<\\/li>\\n<li>Fix: My Account widget gets hidden when using a single page template with post content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19627\\\">#19627<\\/a>)<\\/li>\\n<li>Fix: Cart is not updated when cache enabled in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19312\\\">#19312<\\/a>)<\\/li>\\n<li>Fix: Entrance animations are not working as expected with Infinite Loop and Load on CLick pagination in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20293\\\">#20293<\\/a>)<\\/li>\\n<li>Fix: Loading page issues in Form Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19973\\\">#19973<\\/a>)<\\/li>\\n<li>Fix: Recently Edited date and time not working as expected in Elementor Overview plugin in WordPress dashboard (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17966\\\">#17966<\\/a>)<\\/li>\\n<li>Fix: Recurring license mismatch error message when using translators plugins<\\/li>\\n<li>Fix: Submenu items triggers page transition instead of opening in Nav Menu widget<\\/li>\\n<li>Fix: Query values of Posts widget are not imported correctly when importing a Kit<\\/li>\\n<li>Fix: Loop items are exceeding the widget boundaries in Loop Grid widget<\\/li>\\n<li>Fix: Order by option is not working as expected when choosing Upsells, Cross-Sells and Related Products query in Products widget<\\/li>\\n<li>Fix: Various widgets disappear in certain scenarios when choosing direction Row or Column in Container<\\/li>\\n<\\/ul>\\n<h4>3.8.2 - 2022-11-20<\\/h4>\\n<ul>\\n<li>Fix: Z-index issues when applying sticky to Container<\\/li>\\n<li>Fix: Error message appears on front with Editor and Shop Manager roles when using the Loop Builder widget<\\/li>\\n<\\/ul>\\n<h4>3.8.1 - 2022-11-06<\\/h4>\\n<ul>\\n<li>Fix: Sticky inner section is not staying in the column when applying sticky option in Sections (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20203\\\">#20203<\\/a>)<\\/li>\\n<li>Fix: Post Title widget located in a loop item template disappears when enabling the hide title option inside page settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20207\\\">#20207<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20255\\\">#20255<\\/a>)<\\/li>\\n<li>Fix: ACF Dynamic data not rendering correctly in various scenarios (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20235\\\">#20235<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20258\\\">#20258<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20277\\\">#20277<\\/a>)<\\/li>\\n<li>Fix: Z-index issues when applying sticky to Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20227\\\">#20227<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.8.0 - 2022-10-30<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Builder as a beta status experiment - Create powerful &amp; repeating loop templates and populate each one with dynamic content and design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4440\\\">#4440<\\/a>)<\\/li>\\n<li>Tweak: Add <code>wp_body_open()<\\/code> to header in Header template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11562\\\">#11562<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15828\\\">#15828<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13089\\\">#13089<\\/a>)<\\/li>\\n<li>Tweak: Added support border-radius option to the Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14316\\\">#14316<\\/a>)<\\/li>\\n<li>Tweak: Import\\/Export CLI and UI mechanisms were merged into a unified service<\\/li>\\n<li>Tweak: User with no permission to Notes cannot be mentioned in a note<\\/li>\\n<li>Tweak: User with no permission to view a post cannot be mentioned in a note<\\/li>\\n<li>Tweak: Notes was added to the right click context-menu<\\/li>\\n<li>Tweak: Notes panel can be resizable<\\/li>\\n<li>Tweak: Notes panel can be dragged outside of the canvas in responsive mode in the editor<\\/li>\\n<li>Tweak: Updated form validation messages translation strings in Form widget<\\/li>\\n<li>Tweak: Updated translators comments<\\/li>\\n<li>Tweak: Theme Builder logo and Title should be clickable<\\/li>\\n<li>Tweak: Reduced API requests and DB calls on non-write setup<\\/li>\\n<li>Tweak: Added media queries to the Table of Contents widget<\\/li>\\n<li>Fix: Sticky option is not working as expected in various scenarios in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19540\\\">#19540<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19618\\\">#19618<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19777\\\">#19777<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19827\\\">#19827<\\/a>)<\\/li>\\n<li>Fix: Mixed Content errors on HTTPS in Video Playlist Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18895\\\">#18895<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18945\\\">#18945<\\/a>)<\\/li>\\n<li>Fix: Note\'s timestamp is being updated according to the last activity in Notes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19123\\\">#19123<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17582\\\">#17582<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in pagination in Posts widget<\\/li>\\n<li>Fix: Share buttons is accessible with keyboard but not clickable<\\/li>\\n<li>Fix: Sub-items icons style is missing in preview with Inline Font Icons experiment in Nav Menu widget<\\/li>\\n<li>Fix: Quotes are appearing as HTML when editing a note in Notes<\\/li>\\n<li>Fix: Label\'s Icon height increases when Inline Font Icons experiment is active in Hotspot Widget<\\/li>\\n<li>Fix: Sub conditions of templates are not overridden when importing a Kit<\\/li>\\n<li>Fix: X\\/Y Anchor Point controls were not visible for Scale and Rotate effects<\\/li>\\n<li>Fix: PHP warning notice appears in some situations when using motion effects<\\/li>\\n<\\/ul>\\n<h4>3.7.7 - 2022-09-20<\\/h4>\\n<ul>\\n<li>Fix: Default Flex Grow affects the layout when the container is set to direction Column in various widgets<\\/li>\\n<\\/ul>\\n<h4>3.7.6 - 2022-09-14<\\/h4>\\n<ul>\\n<li>Fix: Submissions menu item appears at the bottom of Elementor section in WordPress dashboard<\\/li>\\n<\\/ul>\\n<h4>3.7.5 - 2022-08-31<\\/h4>\\n<ul>\\n<li>Fix: Error message appears on front if WooCommerce is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553\\\">#19553<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.7.4 - 2022-08-29<\\/h4>\\n<ul>\\n<li>Tweak: PHP 5.6 Is deprecated<\\/li>\\n<li>Fix: Triangle icon is not being displayed in the Select field when Inline Font Icons Experiment is active in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18598\\\">#18598<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19495\\\">#19495<\\/a>)<\\/li>\\n<li>Fix: The page jumps or flickers to the video playlist on page reload in Video Playlist Widget<\\/li>\\n<\\/ul>\\n<h4>3.7.3 - 2022-07-31<\\/h4>\\n<ul>\\n<li>Tweak: Improved license mechanism for correct validation<\\/li>\\n<li>Fix: Sticky option causes unexpected results when using the Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>)<\\/li>\\n<li>Fix: Price list, Portfolio, Flip Box and Gallery widgets disappear when the direction is set to column in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18880\\\">#18880<\\/a>)<\\/li>\\n<li>Fix: Quotes character is showing up as <code>&amp;quot;<\\/code> when editing a note in Notes<\\/li>\\n<\\/ul>\\n<h4>3.7.2 - 2022-06-15<\\/h4>\\n<ul>\\n<li>Tweak: Applied optimized file handling in various modules<\\/li>\\n<li>Fix: Related posts query options are missing in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18633\\\">#18633<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18641\\\">#18641<\\/a>)<\\/li>\\n<li>Fix: Menu Cart Icon is not being displayed on all browsers when Inline Font Icons Experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17705\\\">#17705<\\/a>)<\\/li>\\n<li>Fix: Gallery widget is not working as expected in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18408\\\">#18408<\\/a>)<\\/li>\\n<li>Fix: Flip box is not visible when the direction is set to Row in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18413\\\">#18413<\\/a>)<\\/li>\\n<li>Fix: Portfolio widget is not visible when dragged into &quot;Row&quot; direction Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17653\\\">#17653<\\/a>)<\\/li>\\n<li>Fix: Menu cart is open automatically in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18629\\\">#18629<\\/a>)<\\/li>\\n<li>Fix: PHP error is being shown the license is expired in License screen<\\/li>\\n<\\/ul>\\n<h4>3.7.1 - 2022-05-16<\\/h4>\\n<ul>\\n<li>Fix: Notes icon appears as an empty square in admin top bar for users with permissions lower than Editor<\\/li>\\n<li>Fix: Notes experiment causes a PHP fatal error on some cases<\\/li>\\n<li>Fix: UI glitches in Notes feature<\\/li>\\n<\\/ul>\\n<h4>3.7.0 - 2022-05-10<\\/h4>\\n<ul>\\n<li>New: Introducing Notes - Work collaboratively directly within Elementor<\\/li>\\n<li>New: Stripe Button widget - Collect Stripe payments directly from your site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14748\\\">#14748<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Add to Cart dynamic tag - add products to cart from every widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10607\\\">#10607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11801\\\">#11801<\\/a>)<\\/li>\\n<li>New: Added WooCommerce Product Content dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16367\\\">#16367<\\/a>)<\\/li>\\n<li>Tweak: Added Related, Upsells and Cross-Sells query sources to Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8071\\\">#8071<\\/a>)<\\/li>\\n<li>Tweak: Added custom icon control to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18007\\\">#18007<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14357\\\">#14357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13151\\\">#13151<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11361\\\">#11361<\\/a>)<\\/li>\\n<li>Tweak: Added an option to minimize on Desktop device in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9933\\\">#9933<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10729\\\">#10729<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10314\\\">#10314<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6691\\\">#6691<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11774\\\">#11774<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9051\\\">#9051<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5760\\\">#5760<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9774\\\">#9774<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom option in various Product widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10263\\\">#10263<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom control in Posts and Archive Posts widgets<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added percentage unit to padding control in Additional Information customize section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added quick link to create new theme parts directly from the Finder<\\/li>\\n<li>Tweak: Added the option to add a custom template to Dashboard screen in My Account widget<\\/li>\\n<li>Tweak: Added spacing control to view cart button in various product widgets<\\/li>\\n<li>Tweak: Added the option to add a custom template to empty cart state in Cart widget<\\/li>\\n<li>Tweak: Adjusted the layout of the Payment Methods screen in the My Account widget<\\/li>\\n<li>Tweak: Added lazy load option to Media Carousel, Reviews and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added Site Identity quick link to Logo widget<\\/li>\\n<li>Tweak: Added Site Identity quick link to Site Title widget<\\/li>\\n<li>Tweak: Created an attribute that allows disabling page transition for specific links<\\/li>\\n<li>Tweak: Added dynamic tag controls to Gallery widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Countdown widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Portfolio widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Price Table widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Login widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Blockquote widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Facebook Comments widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post Navigation widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Search Form widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Author Box widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post info widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Posts widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Product Meta widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Products widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Sitemap widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Reviews widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Code Highlight widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to PayPal Button widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added missing PHP documentation to hooks<\\/li>\\n<li>Fix: Scrolling glitches on mobile devices when Sticky Effect is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17767\\\">#17767<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18330\\\">#18330<\\/a>)<\\/li>\\n<li>Fix: Only 1st honypot field is validated when using multiple honeypot fields in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18136\\\">#18136<\\/a>)<\\/li>\\n<li>Fix: Checkout button background color is not working as expected in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18289\\\">#18289<\\/a>)<\\/li>\\n<li>Fix: Button labels are not accessible for screen readers in Share buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<li>Fix: Downloads titles controls are not working in responsive in WooCommerce Purchase Summary widget<\\/li>\\n<li>Fix: Excerpt length is not working as expected in Posts and Archive Posts widgets<\\/li>\\n<li>Fix: Titles &amp; Totals weight is not working in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Product image is not appearing on Single Product Page on template load<\\/li>\\n<li>Fix: Additional Information title not editable in some scenarios in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in Cart widget<\\/li>\\n<li>Fix: UI Glitch in Masonry control in Portfolio widget<\\/li>\\n<li>Fix: Custom breakpoints experiment didn\'t work on Single post and page templates<\\/li>\\n<li>Fix: Testimonial carousel &amp; Reviews widgets disregards the <code>alt<\\/code> attribute<\\/li>\\n<li>Fix: Playlist widget deeplink didn\'t send user directly to the widget in the page<\\/li>\\n<li>Fix: Masonry option causes the images to disappear in the Editor in Posts widget<\\/li>\\n<li>Fix: Scrollbar appears after clicking on the dropdown toggle in Nav Menu widget<\\/li>\\n<li>Fix: Custom icons disappear on frontend if the pack name contains numbers<\\/li>\\n<li>Fix: Custom Font disappears if the name contains only numbers<\\/li>\\n<li>Fix: <code>end-section()<\\/code> is missing from Progress Tracker and Facebook Embed widgets<\\/li>\\n<li>Tweak: Added a filter for conditions cache query in Theme Builder<\\/li>\\n<li>Fix: Customizations lost on Ajax refresh in WooCommerce Cart widget<\\/li>\\n<li>Fix: Hello theme Header and Footer experiment is not working when WooCommerce plugin is active<\\/li>\\n<li>Fix: Color controls are not working as expected in Checkout widget<\\/li>\\n<li>Fix: Color controls are not working as expected in My Account widget<\\/li>\\n<li>Fix: Empty state widget preview in the editor is disappearing in various widgets<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in WooCommerce Cart widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-7-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.6.5 - 2022-04-12<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issues for several widgets in iOS 14 and macOS 13 devices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18090\\\">#18090<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15910\\\">#15910<\\/a>)<\\/li>\\n<li>Fix: Button Alignment doesn\'t work in Custom Add To Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17810\\\">#17810<\\/a>)<\\/li>\\n<li>Fix: PHP warning is thrown in some cases in PayPal button widget<\\/li>\\n<li>Fix: PHP 8.1 throws errors and notices in some cases<\\/li>\\n<li>Fix: PHP notice was thrown when Kit Import process initiated without display conditions<\\/li>\\n<li>Fix: Create Account button always opens on the Sign Up screen even if the user has an account in Onboarding process<\\/li>\\n<\\/ul>\\n<h4>3.6.4 - 2022-03-15<\\/h4>\\n<ul>\\n<li>Tweak: Kit import dynamic reference support for templates and dynamic tags<\\/li>\\n<li>Tweak: Updated tested up to version tag to <code>3.6.0<\\/code><\\/li>\\n<li>Fix: Sticky caused scrolling issues after clicking an element that expands the page height (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17821\\\">#17821<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17839\\\">#17839<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18069\\\">#18069<\\/a>)<\\/li>\\n<li>Fix: When saving Global widget JS error is being thrown and editor fails to load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17954\\\">#17954<\\/a>)<\\/li>\\n<li>Fix: Motion effects are missing from Background section under Style tab in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18063\\\">#18063<\\/a>)<\\/li>\\n<li>Fix: Imported Kit doesn\'t appear in the theme builder after successful import in some cases<\\/li>\\n<li>Fix: Added future Pro support to fix the Cart icon that shifted aside in Menu cart widget<\\/li>\\n<\\/ul>\\n<h4>3.6.3 - 2022-02-28<\\/h4>\\n<ul>\\n<li>Fix: Custom Code display conditions modal is not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17865\\\">#17865<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17942\\\">#17942<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17994\\\">#17994<\\/a>)<\\/li>\\n<li>Fix: Share buttons are not accessible for keyboard navigation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.6.2 - 2022-02-14<\\/h4>\\n<ul>\\n<li>Fix: Auto updates mechanism is not working as expected (this version might be also installed automatically)<\\/li>\\n<\\/ul>\\n<h4>3.6.1 - 2022-02-09<\\/h4>\\n<ul>\\n<li>Tweak: Allow connecting via generic source for future feature support<\\/li>\\n<li>Fix: Custom Code doesn\'t work when WooCommerce is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17675\\\">#17675<\\/a>)<\\/li>\\n<li>Fix: Content animation didn\'t work when Improved asset loading experiment is active Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17055\\\">#17055<\\/a>)<\\/li>\\n<li>Fix: PHP warning appears some times when trying to force-check for available updates<\\/li>\\n<li>Fix: Page transitions are being triggered when not needed<\\/li>\\n<li>Fix: Text alignment on Tablet responsive device affects base device in Testimonial Carousel widget<\\/li>\\n<li>Fix: Harden Submissions feature to prevent potential security issues<\\/li>\\n<li>Fix: Page Transitions Icon option Preloader doesn\'t work on frontend<\\/li>\\n<\\/ul>\\n<h4>3.6.0 - 2022-01-31<\\/h4>\\n<ul>\\n<li>New: WooCommerce Purchase Summary widget - Fully customize the content and style of your order summary page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5756\\\">#5756<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15862\\\">#15862<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices styling on Site Settings - Customize the appearance of WooCommerce notices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14570\\\">#14570<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15896\\\">#15896<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices widget - Set the position of WooCommerce notices on your shop pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8124\\\">#8124<\\/a>)<\\/li>\\n<li>Experiment: Page Transitions - Customize the page loading experience, and increase brand recognition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10576\\\">#10576<\\/a>)<\\/li>\\n<li>Tweak: Added WooCommerce &amp; Theme Elements widgets to Improved CSS Loading experiment to save up 126KB per page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17412\\\">#17412<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17337\\\">#17337<\\/a>)<\\/li>\\n<li>Tweak: Added new layout options in WooCommerce Add To Cart and WooCommerce Custom Add To Cart widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5437\\\">#5437<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10617\\\">#10617<\\/a>)<\\/li>\\n<li>Tweak: Added Stroke functionality for typography control in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11158\\\">#11158<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor-section-wrap<\\/code> by adding it to the Optimized DOM Output experiment (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16950\\\">#16950<\\/a>)<\\/li>\\n<li>Tweak: Added style controls for variations in WooCommerce Menu Cart widget<\\/li>\\n<li>Tweak: Added color control to navigation dots in Media Carousel, Reviews, and Slides widgets<\\/li>\\n<li>Tweak: Disabled Vimeo autoplay on edit mode when getting video data in Video Playlist widget<\\/li>\\n<li>Tweak: Added notice about Facebook\'s new EU consent policy in Facebook Button, Facebook Comments, Facebook Embed, and Facebook Page widgets<\\/li>\\n<li>Tweak: Refactor string translation calls to use native WP translation methods<\\/li>\\n<li>Tweak: Convert <code>home_url<\\/code> license API call to <code>get_site_url<\\/code> for better compatibility<\\/li>\\n<li>Tweak: Promoted Default to New Theme Builder and Scroll Snap experiments to Stable status in Experiments screen<\\/li>\\n<li>Tweak: Scroll Snap experiment set to active by default for all websites in Experiments screen<\\/li>\\n<li>Tweak: Scrolling Effects in Header and Section backgrounds are not working as expected when effects are relative to the entire page<\\/li>\\n<li>Tweak: Added &quot;Auto Updates&quot; capability to Pro versions<\\/li>\\n<li>Tweak: Removed sequenced animation hover effect option from Classic skin in Call to Action widget<\\/li>\\n<li>Tweak: Added &quot;Excerpt Length&quot; control in Post Excerpt widget<\\/li>\\n<li>Tweak: Deleted deprecated methods from Query Control module<\\/li>\\n<li>Tweak: Adjusted Inline-CSS Experiment to work with Additional Custom Breakpoints experiment<\\/li>\\n<li>Fix: Automatically open cart functionality didn\'t work in product page in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5921\\\">#5921<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16276\\\">#16276<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16879\\\">#16879<\\/a>)<\\/li>\\n<li>Fix: Buttons are not visible when there are too many products in the cart in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17283\\\">#17283<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13005\\\">#13005<\\/a>)<\\/li>\\n<li>Fix: Mini cart modal z-index is too low in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>)<\\/li>\\n<li>Fix: Side cart buttons are not visible at first glance on mobile in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>)<\\/li>\\n<li>Fix: Read More field recognizes inline HTML elements as plain text in Posts and Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16985\\\">#16985<\\/a>)<\\/li>\\n<li>Fix: Load More functionality caused JS error console in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17036\\\">#17036<\\/a>)<\\/li>\\n<li>Fix: Autoplay is not working as expected when the lazy load is active in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15304\\\">#15304<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16274\\\">#16274<\\/a>)<\\/li>\\n<li>Fix: Right navigation area wasn\'t 100% clickable in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14252\\\">#14252<\\/a>)<\\/li>\\n<li>Fix: Posts duplicate when there are two Posts widgets inside a page using pagination functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17056\\\">#17056<\\/a>)<\\/li>\\n<li>Fix: Global widget changes are not reflected on frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16820\\\">#16820<\\/a>)<\\/li>\\n<li>Fix: JS Error console message when using the Load More functionality and Post Per Page option in Posts widget<\\/li>\\n<li>Fix: Heading styling is not being loaded when Inline CSS experiment is active in Post and Page Title widgets<\\/li>\\n<li>Fix: Sticky offset not working as expected when changing device mode on the browser<\\/li>\\n<li>Fix: Scroll Snap functionality wasn\'t applied on Templates and Archives<\\/li>\\n<li>Fix: Toggle icon color didn\'t work on hover state when Inline Font Icons experiment is activated in Nav Menu widget<\\/li>\\n<li>Fix: Variations style controls are not working as expected in WooCommerce Add to Cart widget<\\/li>\\n<li>Fix: Display conditions module is not working as expected when using the new Theme Builder UI<\\/li>\\n<li>Fix: Edit header handles <code>z-index<\\/code> issues in Header document<\\/li>\\n<li>Fix: Panel icons UI glitch in Call To Action widget<\\/li>\\n<li>Fix: WordPress 5.9 <code>WP_User_query<\\/code> <code>who<\\/code> argument deprecation adjustments<\\/li>\\n<\\/ul>\\n<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815\\\">#16815<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplify the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.4.2 - 2021-10-12<\\/h4>\\n<ul>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: \\u201cSave &amp; Close \\u201cbutton in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-14<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475]\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor v3.1.0<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging  Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.10.3 - 2020-06-29<\\/h4>\\n<ul>\\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11596\\\">#11596<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11610\\\">#11610<\\/a>)<\\/li>\\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8646\\\">#8646<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.2 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11644\\\">#11644<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.1 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets<\\/li>\\n<li>Fix: Popup close button vertical position glitch (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10921\\\">#10921<\\/a>)<\\/li>\\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget<\\/li>\\n<li>Fix: Clicking <code>Enter<\\/code> key submits the form in Multi Step Form<\\/li>\\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues<\\/li>\\n<\\/ul>\\n<h4>2.10.0 - 2020-06-07<\\/h4>\\n<ul>\\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5975\\\">#5975<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3911\\\">#3911<\\/a>)<\\/li>\\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11026\\\">#11026<\\/a>)<\\/li>\\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5682\\\">#5682<\\/a>)<\\/li>\\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices<\\/li>\\n<li>Tweak: Added new Scroll Util for improved scrolling handling<\\/li>\\n<li>Tweak: Improved Motion Effects animation performance<\\/li>\\n<\\/ul>\\n<h4>2.9.5 - 2020-05-24<\\/h4>\\n<ul>\\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue<\\/li>\\n<\\/ul>\\n<h4>2.9.4 - 2020-05-07<\\/h4>\\n<ul>\\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability<\\/li>\\n<\\/ul>\\n<h4>2.9.3 - 2020-04-19<\\/h4>\\n<ul>\\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11023\\\">#11023<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10932\\\">#10932<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10967\\\">#10967<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11000\\\">#11000<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11049\\\">#11049<\\/a>)<\\/li>\\n<li>Fix: Escaped Form records metadata to prevent security vulnerability<\\/li>\\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading<\\/li>\\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget<\\/li>\\n<li>Fix: Document handles UI glitch<\\/li>\\n<\\/ul>\\n<h4>2.9.2 - 2020-03-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10745\\\">#10745<\\/a>)<\\/li>\\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10874\\\">#10874<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style<\\/li>\\n<li>Fix: PHP notice when using dynamic user info <code>id<\\/code><\\/li>\\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget<\\/li>\\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget<\\/li>\\n<li>Fix: Container includes Popup tags by default in Table of Contents widget<\\/li>\\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<\\/ul>\\n<h4>2.9.1 - 2020-03-16<\\/h4>\\n<ul>\\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page<\\/li>\\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles<\\/li>\\n<\\/ul>\\n<h4>2.9.0 - 2020-03-15<\\/h4>\\n<ul>\\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4985\\\">#4985<\\/a>)<\\/li>\\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3345\\\">#3345<\\/a>)<\\/li>\\n<li>New: Added Dynamic Colors tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6485\\\">#6485<\\/a>)<\\/li>\\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9293\\\">#9293<\\/a>)<\\/li>\\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5716\\\">#5716<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3642\\\">#3642<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9225\\\">#9225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9079\\\">#9079<\\/a>)<\\/li>\\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10564\\\">#10564<\\/a>)<\\/li>\\n<li>Tweak: Avoid creating empty Custom Font<\\/li>\\n<li>Tweak: Added <code>aria-expanded<\\/code> attribute to Menu Cart widget<\\/li>\\n<li>Tweak: Moved Link Actions module to Core plugin<\\/li>\\n<li>Tweak: Changed the name of \\u201cTypeKit Web Fonts by Adobe\\u201d to \\u201cAdobe Fonts\\u201d<\\/li>\\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets<\\/li>\\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated<\\/li>\\n<li>Tweak: Remove redundant <code>label_block<\\/code> parameters from several controls<\\/li>\\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget<\\/li>\\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7924\\\">#7924<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0<\\/li>\\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets<\\/li>\\n<li>Tweak: Expose external API for Swiper instances<\\/li>\\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget<\\/li>\\n<li>Tweak: Replaced nerd icons with new Elementor emojis<\\/li>\\n<li>Tweak: Added specific <code>color<\\/code> attribute to header title in Table of Contents widget<\\/li>\\n<li>Fix: Line break issues in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10585\\\">#10585<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color overrides the Table of Content list style<\\/li>\\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode<\\/li>\\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget<\\/li>\\n<li>Fix: Page Title widget render glitches in the Editor<\\/li>\\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget<\\/li>\\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget<\\/li>\\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v2-9-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.8.5 - 2020-03-08<\\/h4>\\n<ul>\\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration<\\/li>\\n<li>Fix: Missing closing bracket in Animated Headline widget<\\/li>\\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor<\\/li>\\n<\\/ul>\\n<h4>2.8.4 - 2020-02-16<\\/h4>\\n<ul>\\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget<\\/li>\\n<li>Tweak: Added RTL support for Slides widget<\\/li>\\n<li>Tweak: Display Lightbox images in Full size in Gallery widget<\\/li>\\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget<\\/li>\\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget<\\/li>\\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget<\\/li>\\n<li>Fix: Query Control throws <code>Undefined index: q<\\/code> error<\\/li>\\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget<\\/li>\\n<li>Fix: Discord forms integration fails to send submissions in some server configurations<\\/li>\\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget<\\/li>\\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget<\\/li>\\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser<\\/li>\\n<li>Fix: Missing eye icon in Single template footer preview button<\\/li>\\n<\\/ul>\\n<h4>2.8.3 - 2020-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Updated Table of Contents widget panel location<\\/li>\\n<li>Fix: ACF URL Dynamic field throws <code>undefined index<\\/code> PHP notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9929\\\">#9929<\\/a>)<\\/li>\\n<li>Fix: Gallery lightbox pagination shows images from all tabs<\\/li>\\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<li>Fix: Underline option not working in Table of Contents widget Normal state<\\/li>\\n<li>Fix: Query Control <code>Undefined index: autocomplete<\\/code> notice in some cases<\\/li>\\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.8.2 - 2019-12-19<\\/h4>\\n<ul>\\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget<\\/li>\\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive<\\/li>\\n<li>Fix: Redundant <code>&lt;br&gt;<\\/code> tags in Single theme template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9927\\\">#9927<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9928\\\">#9928<\\/a>)<\\/li>\\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown<\\/li>\\n<\\/ul>\\n<h4>2.8.1 - 2019-12-18<\\/h4>\\n<ul>\\n<li>Fix: Share Buttons widget not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9920\\\">#9920<\\/a>)<\\/li>\\n<li>Fix: Redundant <code>&lt;p&gt;<\\/code> tags added to Single Template posts<\\/li>\\n<\\/ul>\\n<h4>2.8.0 - 2019-12-18<\\/h4>\\n<ul>\\n<li>New: Table of Contents Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5171\\\">#5171<\\/a>)<\\/li>\\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9763\\\">#9763<\\/a>)<\\/li>\\n<li>Tweak: Added Random order option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9269\\\">#9269<\\/a>)<\\/li>\\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9324\\\">#9324<\\/a>)<\\/li>\\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9579\\\">#9579<\\/a>)<\\/li>\\n<li>Tweak: Major performance improvements to Gallery widget<\\/li>\\n<li>Tweak: Avoid non-existing images in Gallery widget<\\/li>\\n<li>Tweak: Added <code>tabindex<\\/code>, <code>aria-expanded<\\/code>, <code>aria-hidden<\\/code> and <code>role=\\\"navigation\\\"<\\/code> accessibility attributes to Nav Menu widget<\\/li>\\n<li>Tweak: Changed button HTML tag from <code>button<\\/code> to <code>span<\\/code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility<\\/li>\\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget<\\/li>\\n<li>Tweak: Added compatibility for Library Connect<\\/li>\\n<li>Tweak: Added i18n to Toolset date dynamic tag<\\/li>\\n<li>Tweak: Added external link support to Gallery widget<\\/li>\\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()<\\/code> in Gallery widget<\\/li>\\n<li>Tweak: Updated references to the new Schemes system location<\\/li>\\n<li>Tweak: Avoid running Gallery handler when the gallery is empty<\\/li>\\n<li>Tweak: UI Tweaks in Editor Panel<\\/li>\\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget<\\/li>\\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget<\\/li>\\n<li>Tweak: Refactor <code>register_controls()<\\/code> method in Posts widget skin trait<\\/li>\\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7646\\\">#7646<\\/a>)<\\/li>\\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9304\\\">#9304<\\/a>)<\\/li>\\n<li>Fix: <code>PHP Notice: Undefined index<\\/code> display for Author query (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9864\\\">#9864<\\/a>)<\\/li>\\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/broken-buttons-since-elementor-2-8\\/\\\">Topic<\\/a>)<\\/li>\\n<li>Fix: Avoid empty spaces in Post info widget<\\/li>\\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget<\\/li>\\n<li>Fix: Nav Menu item typography selector in Nav Menu widget<\\/li>\\n<li>Fix: Facebook Like Button widget causes flickering<\\/li>\\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain<\\/code> permalinks format<\\/li>\\n<li>Fix: Avoid running Popup triggers when set without conditions<\\/li>\\n<li>Fix: Removed &quot;Date&quot; query from Products widget<\\/li>\\n<li>Fix: Slides widget when used as a Shortcode and is hidden<\\/li>\\n<li>Fix: Custom URL being accessed on swipe in Media Carousel<\\/li>\\n<li>Fix: Media Carousel widget Cube effect glitch<\\/li>\\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page<\\/li>\\n<li>Fix: Image <code>alt<\\/code> Text not displayed on overlay in Gallery widget<\\/li>\\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin<\\/li>\\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable<\\/code><\\/li>\\n<li>Fix: Slides widget button wrapping breaks in mobile view<\\/li>\\n<li>Fix: Dynamic capabilities with the Reviews widget<\\/li>\\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget<\\/li>\\n<li>Fix: Posts widget Full Content skin not working on Single template<\\/li>\\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen<\\/li>\\n<li>Fix: Posts widget alignment issue<\\/li>\\n<li>Fix: Product Variations Clear button not working in edge cases<\\/li>\\n<li>Fix: Styling issues in Form widget submit button<\\/li>\\n<\\/ul>\\n<h4>2.7.3 - 2019-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added RTL support to Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9213\\\">#9213<\\/a>)<\\/li>\\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3<\\/li>\\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget<\\/li>\\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets<\\/li>\\n<li>Fix: Link-actions conflict with <code>?action=<\\/code> parameter in the URL<\\/li>\\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode<\\/li>\\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets<\\/li>\\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.7.2 - 2019-10-06<\\/h4>\\n<ul>\\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9209\\\">#9209<\\/a>)<\\/li>\\n<li>Fix: Content width glitch in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display<\\/code> CSS<\\/li>\\n<\\/ul>\\n<h4>2.7.1 - 2019-09-26<\\/h4>\\n<ul>\\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery<\\/li>\\n<\\/ul>\\n<h4>2.7.0 - 2019-09-24<\\/h4>\\n<ul>\\n<li>New: Enhanced Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1898\\\">#1898<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3103\\\">#3103<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4279\\\">#4279<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7631\\\">#7631<\\/a>)<\\/li>\\n<li>New: Dynamic Number (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5952\\\">#5952<\\/a>)<\\/li>\\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4617\\\">#4617<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets<\\/li>\\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5418\\\">#5418<\\/a>)<\\/li>\\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7947\\\">#7947<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8740\\\">#8740<\\/a>)<\\/li>\\n<li>Tweak: Added <code>font-display<\\/code> support to custom fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5993\\\">#5993<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-custom-fonts-font-display-support\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8800\\\">#8800<\\/a>)<\\/li>\\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8799\\\">#8799<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9030\\\">#9030<\\/a>)<\\/li>\\n<li>Tweak: Use <code>swiper.js<\\/code> instead of <code>slick.js<\\/code> in Slides widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-2-7-moving-sliders-from-slick-to-swiper\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/before_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/after_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic support for Custom field key (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7789\\\">#7789<\\/a>)<\\/li>\\n<li>Tweak: Increased expired license notice bar frequency<\\/li>\\n<li>Tweak: Changed the icon name of Slides widget<\\/li>\\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts<\\/li>\\n<li>Tweak: Use Ken Burns Effect as an external module<\\/li>\\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets<\\/li>\\n<li>Tweak: Editor Panel UI tweaks<\\/li>\\n<li>Tweak: Added DOM events on Popup show\\/hide (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-popup-events\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added option to change the variations field width in Add to Cart widget<\\/li>\\n<li>Tweak: Use select control instead of select2 in Menu Cart widget<\\/li>\\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget<\\/li>\\n<li>Tweak: Added Typography controls to HTML field in Forms widget<\\/li>\\n<li>Tweak: Allow edit selected Font file in Custom Font<\\/li>\\n<li>Tweak: Changed reCAPTCHA v3 error message<\\/li>\\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu<\\/li>\\n<li>Fix: Corrected selector for <code>removeControlSpinner()<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8790\\\">#8790<\\/a>)<\\/li>\\n<li>Fix: Slides widget navigation icons misplacement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8533\\\">#8533<\\/a>)<\\/li>\\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8527\\\">#8527<\\/a>)<\\/li>\\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1671\\\">#1671<\\/a>)<\\/li>\\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7347\\\">#7347<\\/a>)<\\/li>\\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs<\\/li>\\n<li>Fix: Removed unnecessary divider in Call to Action widget<\\/li>\\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity<\\/code> is enabled.<\\/li>\\n<li>Fix: Add support for Document\\/PageBase in Theme Builder (Core &gt;=2.7.0)<\\/li>\\n<li>Fix: Ampersand character breaks email link in Share Buttons widget<\\/li>\\n<li>Fix: Correct custom font attachment <code>mime-type<\\/code> to show uploaded Custom Fonts<\\/li>\\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget<\\/li>\\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated<\\/li>\\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving<\\/li>\\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen<\\/li>\\n<li>Fix: Translations and Strings in Share Buttons widget<\\/li>\\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control<\\/li>\\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget<\\/li>\\n<\\/ul>\\n<h4>2.6.5 - 2019-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Button style not working when <code>quantity<\\/code> is enabled in Custom Add To Cart widget<\\/li>\\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>2.6.4 - 2019-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility<\\/li>\\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget<\\/li>\\n<\\/ul>\\n<h4>2.6.3 - 2019-08-18<\\/h4>\\n<ul>\\n<li>Fix: Core version rollback to <code>&gt;2.6.0<\\/code> causes a fatal error<\\/li>\\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox<\\/li>\\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge<\\/li>\\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings<\\/li>\\n<\\/ul>\\n<h4>2.6.2 - 2019-07-30<\\/h4>\\n<ul>\\n<li>Tweak: Better accessibility support in Search Form widget<\\/li>\\n<li>Fix: UI glitched in Popup publish screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8616\\\">#8616<\\/a>)<\\/li>\\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8695\\\">#8695<\\/a>)<\\/li>\\n<li>Fix: Restored <code>library_widget_templates<\\/code> action hook for 3rd party compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8687\\\">#8687<\\/a>)<\\/li>\\n<li>Fix: Twitter Icon missing in Blockquote widget<\\/li>\\n<li>Fix: Form reCAPTCHA v3 badge position not working<\\/li>\\n<li>Fix: Renewal notice bar appears in wrong situations<\\/li>\\n<li>Fix: Draft Icon Set loads empty Icon Library<\\/li>\\n<\\/ul>\\n<h4>2.6.1 - 2019-07-24<\\/h4>\\n<ul>\\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8672\\\">#8672<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8661\\\">#8661<\\/a>)<\\/li>\\n<li>Fix: Price Table features section not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8660\\\">#8660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.6.0 - 2019-07-23<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/110\\\">#110<\\/a>)<\\/li>\\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4430\\\">#4430<\\/a>)<\\/li>\\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8213\\\">#8213<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6039\\\">#6039<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7165\\\">#7165<\\/a>)<\\/li>\\n<li>Tweak: Added Exit Animation for Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7063\\\">#7063<\\/a>)<\\/li>\\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5147\\\">#5147<\\/a>)<\\/li>\\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2180\\\">#2180<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7552\\\">#7552<\\/a>)<\\/li>\\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7928\\\">#7928<\\/a>)<\\/li>\\n<li>Tweak: Added <code>none<\\/code> breakpoint option to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7916\\\">#7916<\\/a>)<\\/li>\\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8366\\\">#8366<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor\\/query\\/query_results<\\/code> hook to Query Control to allow full control over results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7912\\\">#7912<\\/a>)<\\/li>\\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8090\\\">#8090<\\/a>)<\\/li>\\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups<\\/code> option is selected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8189\\\">#8189<\\/a>)<\\/li>\\n<li>Tweak: Added condition option to all of archive child pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8256\\\">#8256<\\/a>)<\\/li>\\n<li>Tweak: Added <code>Effects Relative To<\\/code> control to Scrolling Effects<\\/li>\\n<li>Tweak: Allow shortcodes in HTML Form field<\\/li>\\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability<\\/li>\\n<li>Tweak: Changed MailChimp <code>List<\\/code> label to <code>Audience<\\/code><\\/li>\\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup<\\/li>\\n<li>Tweak: Added <code>Deprecated Notice<\\/code> control to <code>Archive Products<\\/code> and <code>Woo Products<\\/code> widgets<\\/li>\\n<li>Tweak: Added default dynamic title for archives in Theme Builder<\\/li>\\n<li>Tweak: Added condition to show <code>Centered Slides<\\/code> control in Media Carousel widget<\\/li>\\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated<\\/li>\\n<li>Tweak: Replaced <code>select<\\/code> control with <code>choose<\\/code> control in Price List widget<\\/li>\\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor<\\/li>\\n<li>Tweak: Minor styling tweaks in the Popup publish modal<\\/li>\\n<li>Tweak: Hide ordering form in Products widget on front page<\\/li>\\n<li>Tweak: Removed page title markup when \'Hide Title\' is active<\\/li>\\n<li>Tweak: Added style controls for HTML field in Form widget<\\/li>\\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7240\\\">#7240<\\/a>)<\\/li>\\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7884\\\">#7884<\\/a>)<\\/li>\\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8497\\\">#8497<\\/a>)<\\/li>\\n<li>Fix: Missing Print icon in Share Buttons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8506\\\">#8506<\\/a>)<\\/li>\\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad<\\/li>\\n<li>Deprecated: <code>DB::save_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<li>Deprecated: <code>DB::get_plain_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.14 - 2019-07-14<\\/h4>\\n<ul>\\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8555\\\">#8555<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.13 - 2019-07-11<\\/h4>\\n<ul>\\n<li>Fix: Better WC grid support to various themes<\\/li>\\n<\\/ul>\\n<h4>2.5.12 - 2019-07-10<\\/h4>\\n<ul>\\n<li>Fix: Grid for WooCommerce Archive Product widget<\\/li>\\n<li>Fix: Remove redundant <code>whitespace<\\/code> CSS property causes style glitch in iPad<\\/li>\\n<li>Tweak: Added more compatibility for Elementor v2.6<\\/li>\\n<\\/ul>\\n<h4>2.5.11 - 2019-07-02<\\/h4>\\n<ul>\\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8460\\\">#8460<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8461\\\">#8461<\\/a>)<\\/li>\\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8396\\\">#8396<\\/a>)<\\/li>\\n<li>Fix: Missing dropdown icon in conditions screen<\\/li>\\n<\\/ul>\\n<h4>2.5.10 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6<\\/li>\\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8261\\\">#8261<\\/a>)<\\/li>\\n<li>Fix: Do not unset <code>product<\\/code> CPT if it\'s not from WooCommerce (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8160\\\">#8160<\\/a>)<\\/li>\\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8285\\\">#8285<\\/a>)<\\/li>\\n<li>Fix: Title styling not working in Products Categories widget<\\/li>\\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser<\\/li>\\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition<\\/li>\\n<\\/ul>\\n<h4>2.5.9 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>auto-confirm<\\/code> control from MailPoet to support new version of MailPoet<\\/li>\\n<li>Fix: Multiple Custom Fonts not rendered in the editor<\\/li>\\n<li>Fix: Products <code>sale<\\/code> query - handle exclude by manual selection.<\\/li>\\n<li>Fix: Product Categories grid row &amp; column style<\\/li>\\n<li>Fix: Form integration AJAX cache override<\\/li>\\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates<\\/li>\\n<\\/ul>\\n<h4>2.5.8 - 2019-05-06<\\/h4>\\n<ul>\\n<li>Fix: Popup entrance animation not working in frontend<\\/li>\\n<li>Fix: Popup Exit Intent trigger activated multiple times<\\/li>\\n<\\/ul>\\n<h4>2.5.7 - 2019-05-05<\\/h4>\\n<ul>\\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7875\\\">#7875<\\/a>)<\\/li>\\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7824\\\">#7824<\\/a>)<\\/li>\\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7395\\\">#7395<\\/a>)<\\/li>\\n<li>Fix: WC variations select style glitch in several themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8008\\\">#8008<\\/a>)<\\/li>\\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.5.6 - 2019-04-29<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>Shortcode<\\/code> dynamic from Image, Gallery and Media control<\\/li>\\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7809\\\">#7809<\\/a>)<\\/li>\\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control<\\/li>\\n<li>Fix: Query Control Related by author glitches in edge cases<\\/li>\\n<li>Fix: Query Control using terms for Products widget<\\/li>\\n<li>Fix: Posts cards style glitch in small screens<\\/li>\\n<li>Fix: Display conditions delete icon missing in small screens<\\/li>\\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor<\\/li>\\n<\\/ul>\\n<h4>2.5.5 - 2019-04-08<\\/h4>\\n<ul>\\n<li>Tweak: Allow text selection inside a Popup<\\/li>\\n<li>Fix: Added backwards compatibility for <code>tax_query<\\/code> in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7751\\\">#7751<\\/a>)<\\/li>\\n<li>Fix: Missing arguments for <code>widget_title<\\/code> filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7745\\\">#7745<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.4 - 2019-04-03<\\/h4>\\n<ul>\\n<li>Fix: Move Query from using <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<li>Fix: Offset manipulation hook removal in Query control<\\/li>\\n<li>Fix: Missing form field <code>ID<\\/code> in some edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7711\\\">#7711<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7660\\\">#7660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.3 - 2019-03-31<\\/h4>\\n<ul>\\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7673\\\">#7673<\\/a>)<\\/li>\\n<li>Fix: Missing form field names (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7651\\\">#7651<\\/a>)<\\/li>\\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7633\\\">#7633<\\/a>)<\\/li>\\n<li>Fix: <code>products_deprecated<\\/code> Query Control module compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7654\\\">#7654<\\/a>)<\\/li>\\n<li>Fix: Changed query method from <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.2 - 2019-03-27<\\/h4>\\n<ul>\\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7632\\\">#7632<\\/a>)<\\/li>\\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7635\\\">#7635<\\/a>)<\\/li>\\n<li>Fix: Manual Selection option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7634\\\">#7634<\\/a>)<\\/li>\\n<li>Fix: Incorrect condition caused handlers issues inside popup<\\/li>\\n<\\/ul>\\n<h4>2.5.1 - 2019-03-26<\\/h4>\\n<ul>\\n<li>Fix: Query Control invalid call to deprecated action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7619\\\">#7619<\\/a>)<\\/li>\\n<li>Tweak: Renamed action hook from <code>elementor_pro\\/{$widget_name}\\/query\\/{$query_id}<\\/code> to <code>elementor\\/query\\/{$query_id}<\\/code><\\/li>\\n<li>Tweak: Renamed filter hook from <code>elementor_pro\\/query_control\\/get_query_args\\/current_query<\\/code> to <code>elementor\\/query\\/get_query_args\\/current_query<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.5.0 - 2019-03-26<\\/h4>\\n<ul>\\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/72\\\">#72<\\/a>)<\\/li>\\n<li>New: Introducing Related Posts for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7306\\\">#7306<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7490\\\">#7490<\\/a>)<\\/li>\\n<li>New: Introducing Date query for Query Control<\\/li>\\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2501\\\">#2501<\\/a>)<\\/li>\\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6871\\\">#6871<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6876\\\">#6876<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule<\\/li>\\n<li>Tweak: Added full border radius control options inside Popup<\\/li>\\n<li>Tweak: Changed exit intent icon in Popups<\\/li>\\n<li>Tweak: Show only one popup in its own preview<\\/li>\\n<li>Tweak: Added responsive support to Popup entrance animation control<\\/li>\\n<li>Tweak: Conditions - Singular <code>All Pages<\\/code> string changed to <code>Pages<\\/code><\\/li>\\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7000\\\">#7000<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6779\\\">#6779<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6986\\\">#6986<\\/a>)<\\/li>\\n<li>Tweak: Decrease <code>z-index<\\/code> for Nav Menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6869\\\">#6869<\\/a>)<\\/li>\\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;<\\/li>\\n<li>Tweak: Use filter <code>get_meta_viewport<\\/code> for header templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7043\\\">#7043<\\/a>)<\\/li>\\n<li>Tweak: use filterable <code>Util::get_public_post_types()<\\/code> in Theme Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7172\\\">#7172<\\/a>)<\\/li>\\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7443\\\">#7443<\\/a>)<\\/li>\\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6913\\\">#6913<\\/a>)<\\/li>\\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling<\\/li>\\n<li>Fix: Custom ID reset to default when dragging repeater<\\/li>\\n<li>Fix: Conflict between archive-products widget and WC customizer<\\/li>\\n<li>Fix: Add to Cart widget <code>spacing<\\/code> and <code>space-between<\\/code><\\/li>\\n<li>Fix: Library view when creating a new Header or Footer<\\/li>\\n<li>Fix: Post types labels missing on Add New Template modal<\\/li>\\n<\\/ul>\\n<h4>2.4.8 - 2019-03-11<\\/h4>\\n<ul>\\n<li>Fix: Missing query section in Products widget<\\/li>\\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.7 - 2019-03-06<\\/h4>\\n<ul>\\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+<\\/li>\\n<\\/ul>\\n<h4>2.4.6 - 2019-03-04<\\/h4>\\n<ul>\\n<li>Fix: Pods gallery dynamic when empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7127\\\">#7127<\\/a>)<\\/li>\\n<li>Fix: Duplicate call for conditions screen issue<\\/li>\\n<li>Fix: Compatibility with Elementor v2.5.0<\\/li>\\n<\\/ul>\\n<h4>2.4.5 - 2019-02-18<\\/h4>\\n<ul>\\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7058\\\">#7058<\\/a>)<\\/li>\\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7083\\\">#7083<\\/a>)<\\/li>\\n<li>Fix: Show popup preview only on it\'s own preview<\\/li>\\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.4 - 2019-02-11<\\/h4>\\n<ul>\\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6690\\\">#6690<\\/a>)<\\/li>\\n<li>Tweak: Changed the term of <code>All Posts<\\/code> condition to <code>Posts<\\/code><\\/li>\\n<li>Fix: Added <code>&lt;IfModule&gt;<\\/code> to avoid 500 error when <code>mod-headers<\\/code> is missing (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7034\\\">#7034<\\/a>)<\\/li>\\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6856\\\">#6856<\\/a>)<\\/li>\\n<li>Fix: <code>Textarea<\\/code> default value in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6934\\\">#6934<\\/a>)<\\/li>\\n<li>Fix: MailPoet latest version caused fatal error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6996\\\">#6996<\\/a>)<\\/li>\\n<li>Fix: Fatal Error caused by calling MailPoet deleted method<\\/li>\\n<li>Notice: MailPoet <code>Auto Confirm<\\/code> option will now default to &quot;On&quot;<\\/li>\\n<\\/ul>\\n<h4>2.4.3 - 2019-01-30<\\/h4>\\n<ul>\\n<li>Fix: Custom Add to Cart widget responsive alignment settings<\\/li>\\n<li>Fix: Links in Post Info widget<\\/li>\\n<li>Fix: WooCommerce <code>View Cart<\\/code> string translate<\\/li>\\n<li>Fix: Wrapper classes for header\\/footer templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6884\\\">#6884<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.4.2 - 2019-01-25<\\/h4>\\n<ul>\\n<li>Tweak: Added pixel units to Close Button position control in Popups<\\/li>\\n<li>Fix: Exclude error in WC Products widget<\\/li>\\n<\\/ul>\\n<h4>2.4.1 - 2019-01-24<\\/h4>\\n<ul>\\n<li>Tweak: Added CSS classes control to Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6826\\\">#6826<\\/a>)<\\/li>\\n<li>Tweak: Added responsive image size to Testimonial Carousel widget<\\/li>\\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6842\\\">#6842<\\/a>)<\\/li>\\n<li>Fix: Support of exclude-ids in WC Products widget<\\/li>\\n<li>Fix: Popup close button not clickable<\\/li>\\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6749\\\">#6749<\\/a>)<\\/li>\\n<li>Fix: Bad anchors breaks the page JS<\\/li>\\n<li>Fix: Popup overlay shown when turned off<\\/li>\\n<\\/ul>\\n<h4>2.4.0 - 2019-01-21<\\/h4>\\n<ul>\\n<li>New: Introducing Popup Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/628\\\">#628<\\/a>)<\\/li>\\n<li>New: Added <code>Popup<\\/code> Dynamic Tag<\\/li>\\n<li>New: Added <code>Popup<\\/code> forms action after submit<\\/li>\\n<li>New: Added User Info dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6322\\\">#6322<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/theme_builder\\/archive\\/escape_nothing_found_message<\\/code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6053\\\">#6053<\\/a>)<\\/li>\\n<li>Tweak: Added <code>add_doc_to_location<\\/code> method to Allow insertion of a document to a location<\\/li>\\n<li>Fix: <code>z-index<\\/code> issue with CTA widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6486\\\">#6486<\\/a>)<\\/li>\\n<li>Fix: Hide the Post Content widget and show it only in a Single document<\\/li>\\n<li>Fix: <code>selector<\\/code> replacement in Custom CSS<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> on the real content only<\\/li>\\n<li>Fix: CSS for WC products selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6559\\\">#6559<\\/a>)<\\/li>\\n<li>Fix: Odnoklassniki share URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6638\\\">#6638<\\/a>)<\\/li>\\n<li>Fix: Custom link new tab in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5766\\\">#5766<\\/a>)<\\/li>\\n<li>Fix: <code>nofollow<\\/code> link in Flip Box &amp; CTA widgets<\\/li>\\n<li>Fix: Post Terms in Post Info widget<\\/li>\\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5386\\\">#5386<\\/a>)<\\/li>\\n<li>Fix: Accessibility labels in Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6630\\\">#6630<\\/a>)<\\/li>\\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active<\\/li>\\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget<\\/li>\\n<li>Fix: Sub-menu arrow position in Nav Menu widget<\\/li>\\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6648\\\">#6648<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.3.1 - 2018-12-19<\\/h4>\\n<ul>\\n<li>Fix: Template widget search functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6473\\\">#6473<\\/a>)<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> filter to post content in theme builder<\\/li>\\n<\\/ul>\\n<h4>2.3.0 - 2018-12-17<\\/h4>\\n<ul>\\n<li>New: Introducing Discord Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4218\\\">#4218<\\/a>)<\\/li>\\n<li>New: Introducing Slack Integration for Forms<\\/li>\\n<li>New: Introducing MailerLite Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4462\\\">#4462<\\/a>)<\\/li>\\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/utils\\/get_public_post_types<\\/code> filter hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5900\\\">#5900<\\/a>)<\\/li>\\n<li>Tweak: Added <code>loop_start<\\/code> &amp; <code>the_content<\\/code> hooks for Post Content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6173\\\">#6173<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from Page Settings<\\/li>\\n<li>Tweak: Always add the Custom CSS control to the Advanced tab<\\/li>\\n<li>Fix: In sub Term condition false positive in edge cases<\\/li>\\n<li>Fix: ToolSet Dynamic Image fallback<\\/li>\\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget<\\/li>\\n<li>Fix: Style glitch in the Conditions screen in Safari browser<\\/li>\\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6080\\\">#6080<\\/a>)<\\/li>\\n<li>Fix: The color of label won\'t change color in Widget login<\\/li>\\n<\\/ul>\\n<h4>2.2.5 - 2018-12-11<\\/h4>\\n<ul>\\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.<\\/li>\\n<li>Tweak: Added a better identifier for subpages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6362\\\">#6362<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from page settings<\\/li>\\n<li>Fix: Yahoo event URL date issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Allow timezone settings in Google event URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Avoid <code>z-index<\\/code> changes by <code>nanocss<\\/code> in build process<\\/li>\\n<li>Fix: Added missing WC upsells products CSS<\\/li>\\n<li>Fix: Nav Menu dropdown losing color on hover<\\/li>\\n<li>Fix: WC Product Add-ons CSS compatibility<\\/li>\\n<\\/ul>\\n<h4>2.2.4 - 2018-12-04<\\/h4>\\n<ul>\\n<li>Fix: Global widget not saving changes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6340\\\">#6340<\\/a>)<\\/li>\\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6334\\\">#6334<\\/a>)<\\/li>\\n<li>Fix: Forms Redirect URL action when using form field values with spaces<\\/li>\\n<\\/ul>\\n<h4>2.2.3 - 2018-11-29<\\/h4>\\n<ul>\\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu<\\/li>\\n<li>Fix: Show only supported templates in Template widget<\\/li>\\n<li>Fix: Revert conflicting fix for a default order for WC archive<\\/li>\\n<\\/ul>\\n<h4>2.2.2 - 2018-11-28<\\/h4>\\n<ul>\\n<li>Fix: Lightbox dynamic tag crashes the editor<\\/li>\\n<\\/ul>\\n<h4>2.2.1 - 2018-11-28<\\/h4>\\n<ul>\\n<li>New: Added <code>ACF File<\\/code> Dynamic tag to support text controls.<\\/li>\\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6223\\\">#6223<\\/a>)<\\/li>\\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags<\\/li>\\n<li>Tweak: Added filter <code>elementor_pro\\/dynamic_tags\\/shortcode\\/should_escape<\\/code> to avoid escaping in Shortcode dynamic tag<\\/li>\\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists<\\/li>\\n<li>Tweak: Added front-end max file size validation for upload fields<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> per Post-Type condition for theme builder<\\/li>\\n<li>Fix: Template widget panel not showing the selected template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag<\\/li>\\n<li>Fix: Add post classes only for the Single template<\\/li>\\n<li>Fix: Set document type as not editable for unsupported document like Global widget<\\/li>\\n<li>Fix: Avoid duplicate query for current WC product query<\\/li>\\n<li>Fix: Product Archive showing oldest products instead of latest<\\/li>\\n<li>Fix: CSS reset in Posts widget using cards skin<\\/li>\\n<\\/ul>\\n<h4>2.2.0 - 2018-11-19<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/290\\\">#290<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3990\\\">#3990<\\/a>)<\\/li>\\n<li>New: Added evergreen option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4459\\\">#4459<\\/a>)<\\/li>\\n<li>New: Added expire actions option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5242\\\">#5242<\\/a>)<\\/li>\\n<li>New: Introducing Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3854\\\">#3854<\\/a>)<\\/li>\\n<li>New: Introducing Sitemap widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5594\\\">#5594<\\/a>)<\\/li>\\n<li>New: Added Request Parameter dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4934\\\">#4934<\\/a>)<\\/li>\\n<li>New: Added Shortcode dynamic tag<\\/li>\\n<li>New: Added Image and Video Lightbox dynamic tag<\\/li>\\n<li>New: Added Contact URL dynamic tag<\\/li>\\n<li>New: Added Featured Image Data dynamic tag<\\/li>\\n<li>New: Added default value to each field in the Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4268\\\">#4268<\\/a>)<\\/li>\\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5321\\\">#5321<\\/a>)<\\/li>\\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5587\\\">#5587<\\/a>)<\\/li>\\n<li>Tweak: Added Form Redirect URL with form values (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2564\\\">#2564<\\/a>)<\\/li>\\n<li>Tweak: Added default post classes to template wrapper (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5959\\\">#5959<\\/a>)<\\/li>\\n<li>Tweak: Better labels for terms in Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6092\\\">#6092<\\/a>)<\\/li>\\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;<\\/li>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/condition_sub_id<\\/code> filter hook to allow template condition translations<\\/li>\\n<li>Tweak: Load the Template Library widget via Ajax for better performance<\\/li>\\n<li>Tweak: Added 404 page title for Page Title dynamic tag<\\/li>\\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6141\\\">#6141<\\/a>)<\\/li>\\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5790\\\">#5790<\\/a>)<\\/li>\\n<li>Fix: Avoid potential security risk in forms<\\/li>\\n<li>Fix: Template By Author condition conflicts with 404 page<\\/li>\\n<li>Fix: Restored WC Product Content widget in Single Product template<\\/li>\\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages<\\/li>\\n<li>Fix: Highlight active menu anchor items only when scrolled into view<\\/li>\\n<li>Fix: Carousel Pagination Progress style to support new Swiper version<\\/li>\\n<\\/ul>\\n<h4>2.1.13 - 2018-11-12<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0<\\/li>\\n<li>Fix: Settings conflict when there are multiple carousels in the page<\\/li>\\n<\\/ul>\\n<h4>2.1.12 - 2018-11-05<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3<\\/li>\\n<li>Tweak: Better performance for Template Library widget<\\/li>\\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6029\\\">#6029<\\/a>)<\\/li>\\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6001\\\">#6001<\\/a>)<\\/li>\\n<li>Fix: Custom CSS printed twice in the front-end<\\/li>\\n<li>Fix: ACF Image field PHP warning (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6051\\\">#6051<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.1.11 - 2018-10-22<\\/h4>\\n<ul>\\n<li>New: Added ACF local fields compatibility<\\/li>\\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration<\\/li>\\n<li>Fix: Exclude <code>is_embed<\\/code> from Singular condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5915\\\">#5915<\\/a>)<\\/li>\\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons<\\/li>\\n<li>Fix: Current date time dynamic tag now shows local time<\\/li>\\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink<\\/li>\\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration<\\/li>\\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF<\\/li>\\n<li>Fix: Respect password protected for a WC single product template<\\/li>\\n<li>Fix: Respect <code>order<\\/code> settings for WC archive also without pagination<\\/li>\\n<\\/ul>\\n<h4>2.1.10 - 2018-10-09<\\/h4>\\n<ul>\\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5821\\\">#5821<\\/a>)<\\/li>\\n<li>Tweak: Added link control to Animated Headline widget<\\/li>\\n<li>Fix: Mobile nav menu jump on RTL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5711\\\">#5711<\\/a>)<\\/li>\\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5830\\\">#5830<\\/a>)<\\/li>\\n<li>Fix: Added IE compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Post Content widget is now shown only on <code>Single<\\/code> templates<\\/li>\\n<li>Fix: Query Control Pagination with offset<\\/li>\\n<\\/ul>\\n<h4>2.1.9 - 2018-09-17<\\/h4>\\n<ul>\\n<li>Tweak: Added Centered Slides option for Slideshow carousel<\\/li>\\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5091\\\">#5091<\\/a>)<\\/li>\\n<li>Fix: ACF Gallery option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5740\\\">#5740<\\/a>)<\\/li>\\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5689\\\">#5689<\\/a>)<\\/li>\\n<li>Fix: Coverflow transition effect in Carousel<\\/li>\\n<li>Fix: Weird mobile behavior with Cube effect in Carousel<\\/li>\\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly<\\/li>\\n<\\/ul>\\n<h4>2.1.8 - 2018-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Added styling options for WC Additional Information widget<\\/li>\\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget<\\/li>\\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5338\\\">#5338<\\/a>)<\\/li>\\n<li>Fix: Layout of Related Product widget with WC native style<\\/li>\\n<\\/ul>\\n<h4>2.1.7 - 2018-09-03<\\/h4>\\n<ul>\\n<li>New: WC Archive Description widget<\\/li>\\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5555\\\">#5555<\\/a>)<\\/li>\\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget<\\/li>\\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5589\\\">#5589<\\/a>)<\\/li>\\n<li>Tweak: Added more blend mode options for CTA widget<\\/li>\\n<li>Tweak: Improved plugin updater method based on WordPress version<\\/li>\\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets<\\/li>\\n<li>Fix: Added default gap for products pagination<\\/li>\\n<li>Fix: Post thumbnail flickering in Safari browser<\\/li>\\n<li>Fix: Close mobile nav menu on click only in full-width mode<\\/li>\\n<li>Fix: Added trailing slash to pagination links in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.1.6 - 2018-08-28<\\/h4>\\n<ul>\\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5117\\\">#5117<\\/a>)<\\/li>\\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5491\\\">#5491<\\/a>)<\\/li>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Tweak: Deprecated Follow option in the Facebook Button widget<\\/li>\\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)<\\/li>\\n<li>Fix: Posts widget CSS when using cards skin in masonry mode<\\/li>\\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: WC product gallery links in RTL<\\/li>\\n<li>Fix: Dynamic tags in Call To Action widget<\\/li>\\n<\\/ul>\\n<h4>2.1.5 - 2018-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Fix: Posts Widget layout theme compatibility<\\/li>\\n<li>Fix: Added compatibility for WooCommerce native style<\\/li>\\n<\\/ul>\\n<h4>2.1.4 - 2018-08-19<\\/h4>\\n<ul>\\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5442\\\">#5442<\\/a>)<\\/li>\\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5460\\\">#5460<\\/a>)<\\/li>\\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget<\\/li>\\n<li>Fix: Selector specificity for WooCommerce Products widget<\\/li>\\n<li>Fix: WooCommerce conflicts in the editor in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.3 - 2018-08-15<\\/h4>\\n<ul>\\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5350\\\">#5350<\\/a>)<\\/li>\\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5375\\\">#5375<\\/a>)<\\/li>\\n<li>Fix: Added missing <code>setup_postdata<\\/code> for Product Data Tabs widget<\\/li>\\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5399\\\">#5399<\\/a>)<\\/li>\\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5254\\\">#5254<\\/a>)<\\/li>\\n<li>Fix: Carousel behavior when using a single slide<\\/li>\\n<\\/ul>\\n<h4>2.1.2 - 2018-08-12<\\/h4>\\n<ul>\\n<li>Fix: Error when ACF Pro is not installed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5367\\\">#5367<\\/a>)<\\/li>\\n<li>Fix: Edge cases in Inspector where document is a boolean<\\/li>\\n<li>Fix: Edge cases for incorrect file fields in PODS<\\/li>\\n<\\/ul>\\n<h4>2.1.1 - 2018-08-09<\\/h4>\\n<ul>\\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5345\\\">#5345<\\/a>)<\\/li>\\n<li>Fix: Flip Box effect issues<\\/li>\\n<li>Fix: ACF Options page fields support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5329\\\">#5329<\\/a>)<\\/li>\\n<li>Fix: Import Pro templates in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.0 - 2018-08-07<\\/h4>\\n<ul>\\n<li>New: Introducing WooCommerce Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1690\\\">#1690<\\/a>)<\\/li>\\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive<\\/li>\\n<li>New: Introducing Cart Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4220\\\">#4220<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4600\\\">#4600<\\/a>)<\\/li>\\n<li>New: Added integration with Toolset (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Added integration with Pods (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4129\\\">#4129<\\/a>)<\\/li>\\n<li>New: Added stick to bottom in scrolling effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4799\\\">#4799<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect to Widgets under advanced tab<\\/li>\\n<li>New: Introducing Internal URL Dynamic Tag<\\/li>\\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4597\\\">#4597<\\/a>)<\\/li>\\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4447\\\">#4447<\\/a>)<\\/li>\\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1878\\\">#1878<\\/a>)<\\/li>\\n<li>Tweak: Add Custom Query hook for Query control (<a href=\\\"https:\\/\\/developers.elementor.com\\/custom-query-filter\\/\\\">More Info<\\/a>) (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1748\\\">#1748<\\/a>)<\\/li>\\n<li>Tweak: Added form-message style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4767\\\">#4767<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4602\\\">#4602<\\/a>)<\\/li>\\n<li>Tweak: Added an support for <code>label|value<\\/code> in options field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4594\\\">#4594<\\/a>)<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> condition for theme builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4681\\\">#4681<\\/a>)<\\/li>\\n<li>Tweak: Added Activate\\/Deactivate license key via WP-CLI command (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4149\\\">#4149<\\/a>)<\\/li>\\n<li>Tweak: Added <code>is_scroll<\\/code> trigger to scrolling effect (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4340\\\">#4340<\\/a>)<\\/li>\\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4177\\\">#4177<\\/a>)<\\/li>\\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3697\\\">#3697<\\/a>)<\\/li>\\n<li>Tweak: Added style options for Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1335\\\">#1335<\\/a>)<\\/li>\\n<li>Tweak: Added button CSS ID for Forms widget<\\/li>\\n<li>Tweak: Added pixel units to Post-Info divider height control<\\/li>\\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs<\\/li>\\n<li>Tweak: Re-organize the panel categories per document type<\\/li>\\n<li>Tweak: Added ACF support for <code>options-page<\\/code> fields<\\/li>\\n<li>Tweak: Added dynamic tag for Animated headlines<\\/li>\\n<li>Tweak: Added dynamic tag for BlockQuote widget<\\/li>\\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4817\\\">#4817<\\/a>)<\\/li>\\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4324\\\">#4324<\\/a>)<\\/li>\\n<li>Fix: Initial slide in Carousel widget<\\/li>\\n<li>Fix: Stay on current slide while editing in Carousel widget<\\/li>\\n<li>Fix: Default slides per device in Carousel widget<\\/li>\\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.18 - 2018-07-27<\\/h4>\\n<ul>\\n<li>Fix: Global widget error on saving page<\\/li>\\n<\\/ul>\\n<h4>2.0.17 - 2018-07-26<\\/h4>\\n<ul>\\n<li>Fix: Sub menu indicator direction in Nav Menu widget<\\/li>\\n<li>Fix: Change the title and icon for Global Widget when is moving<\\/li>\\n<li>Fix: CSS wrapper selector for Page Document<\\/li>\\n<\\/ul>\\n<h4>2.0.16 - 2018-07-16<\\/h4>\\n<ul>\\n<li>Tweak: CSS Filter Control module is now included in Elementor<\\/li>\\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5077\\\">#5077<\\/a>)<\\/li>\\n<li>Fix: Restore current query after get Global Widget data<\\/li>\\n<li>Fix: Add action item in History on unlink Global widget<\\/li>\\n<\\/ul>\\n<h4>2.0.15 - 2018-07-10<\\/h4>\\n<ul>\\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4996\\\">#4996<\\/a>)<\\/li>\\n<li>Fix: GMT offset in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4997\\\">#4997<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.0.14 - 2018-07-08<\\/h4>\\n<ul>\\n<li>Tweak: Added set method to form record for developers (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4983\\\">#4983<\\/a>)<\\/li>\\n<li>Fix: Autoplay option for Carousels<\\/li>\\n<li>Fix: Close mobile menu on item click in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.13 - 2018-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for Elementor v2.1<\\/li>\\n<\\/ul>\\n<h4>2.0.12 - 2018-07-02<\\/h4>\\n<ul>\\n<li>Fix: Global widget PHP notices<\\/li>\\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs<\\/li>\\n<li>Fix: Form select field send all selected values on multiple selection<\\/li>\\n<li>Fix: Validate time field only if it\'s not empty<\\/li>\\n<li>Fix: ConvertKit API not saving name field<\\/li>\\n<\\/ul>\\n<h4>2.0.11 - 2018-06-12<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder <code>author<\\/code> archive condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4593\\\">#4593<\\/a>)<\\/li>\\n<li>Fix: Respect password protected posts in Post Content widget<\\/li>\\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.<\\/li>\\n<\\/ul>\\n<h4>2.0.10 - 2018-06-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> filter hook for multi-language plugins<\\/li>\\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)<\\/li>\\n<li>Fix: Fields shortcode missing after removing a field in Form widget<\\/li>\\n<li>Deprecated: <code>get_theme_templates_by_location<\\/code> is replaced by <code>get_location_templates<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.0.9 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Fix: Compatibility for PHP version 5.4<\\/li>\\n<\\/ul>\\n<h4>2.0.8 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added Active state for Nav Menu dropdown<\\/li>\\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget<\\/li>\\n<li>Tweak: Removed caption control in Site Logo widget<\\/li>\\n<li>Tweak: Added option to position currency symbol before\\/after In Price Table widget<\\/li>\\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4479\\\">#4479<\\/a>)<\\/li>\\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4342\\\">#4342<\\/a>)<\\/li>\\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4527\\\">#4527<\\/a>)<\\/li>\\n<li>Fix: Avoid rendering a template if it\'s not published<\\/li>\\n<li>Fix: 404 Page style not working<\\/li>\\n<li>Fix: Price Table button with hover animation not working in editor<\\/li>\\n<li>Fix: Styling conflict in Call to Action widget<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Adding parent wrapper class to Site Title widget<\\/li>\\n<\\/ul>\\n<h4>2.0.7 - 2018-05-16<\\/h4>\\n<ul>\\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;<\\/li>\\n<li>Fix: Open 404 template library for 404 page<\\/li>\\n<li>Tweak: Added CSS prefix for dev files<\\/li>\\n<li>Tweak: Removed product post type from display conditions<\\/li>\\n<\\/ul>\\n<h4>2.0.6 - 2018-05-15<\\/h4>\\n<ul>\\n<li>Tweak: Set type on create new single template<\\/li>\\n<li>Tweak: Always show the conditions dialog in the Draft status<\\/li>\\n<li>Tweak: Added document type <code>widget<\\/code><\\/li>\\n<li>Tweak: Added Post Custom Field tag to URL category<\\/li>\\n<li>Fix: When ACF Field Groups are Empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4428\\\">#4428<\\/a>)<\\/li>\\n<li>Fix: Links inside carousel in edge cases<\\/li>\\n<li>Fix: Responsive issue in My Templates area<\\/li>\\n<li>Fix: Image alignment for post content with text alignment<\\/li>\\n<li>Fix: Post Content widget when preview post is missing<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Style settings for Post \\/ Archive Title widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.5 - 2018-05-08<\\/h4>\\n<ul>\\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4203\\\">#4203<\\/a>)<\\/li>\\n<li>Fix: Added support for new version of reCAPTCHA<\\/li>\\n<li>Fix: Added fallback for controls after <code>post_status<\\/code><\\/li>\\n<li>Fix: Required field in forms widget<\\/li>\\n<li>Fix: Media Carousel in the Coverflow skin<\\/li>\\n<li>Fix: 404 Page show wrong template in edge cases<\\/li>\\n<li>Fix: Save the default menu in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.4 - 2018-05-02<\\/h4>\\n<ul>\\n<li>Tweak: Added parent\'s class for extended widgets<\\/li>\\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions<\\/li>\\n<li>Tweak: Initialize global model when it\'s needed<\\/li>\\n<li>Tweak: Removed some duplicate strings<\\/li>\\n<li>Tweak: Query control now includes empty terms<\\/li>\\n<li>Tweak: Design polish for conditions dialog<\\/li>\\n<li>Tweak: Decreasing <code>minimumInputLength<\\/code> to 1 of select2<\\/li>\\n<li>Fix: Editor not loading for single templates in edge cases<\\/li>\\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4310\\\">#4310<\\/a>)<\\/li>\\n<li>Fix: Slides per view not working for some effects<\\/li>\\n<li>Fix: New slides not showing in the editor<\\/li>\\n<li>Fix: Editor for section without a defined location, defaults to content area<\\/li>\\n<\\/ul>\\n<h4>2.0.3 - 2018-04-24<\\/h4>\\n<ul>\\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4214\\\">#4214<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4216\\\">#4216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4225\\\">#4225<\\/a>)<\\/li>\\n<li>Fix: Double render on frontend view in core locations<\\/li>\\n<li>Fix: Masonry not working in edge cases<\\/li>\\n<li>Fix: Added default setting for Author Info tag<\\/li>\\n<\\/ul>\\n<h4>2.0.2 - 2018-04-18<\\/h4>\\n<ul>\\n<li>Fix: Regenerate conditions to include all templates<\\/li>\\n<\\/ul>\\n<h4>2.0.1 - 2018-04-17<\\/h4>\\n<ul>\\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4136\\\">#4136<\\/a>)<\\/li>\\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4127\\\">#4127<\\/a>)<\\/li>\\n<li>Tweak: Added Divider control for Post Info widget<\\/li>\\n<li>Fix: Update admin links in Yoast Breadcrumbs widget<\\/li>\\n<li>Fix: Sticky element conflict with clearfix CSS<\\/li>\\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below<\\/li>\\n<li>Fix: Avoid running <code>wp_head<\\/code> hooks twice<\\/li>\\n<\\/ul>\\n<h4>2.0.0 - 2018-04-16<\\/h4>\\n<ul>\\n<li>New: Introducing Theme Builder - <a href=\\\"https:\\/\\/elementor.com\\/introducing-theme-builder\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/417\\\">#417<\\/a>)<\\/li>\\n<li>New: Introducing Locations API to inject custom location templates<\\/li>\\n<li>New: Introducing Display Conditions for all dynamic templates<\\/li>\\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design<\\/li>\\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/483\\\">#483<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/653\\\">#653<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/885\\\">#885<\\/a>)<\\/li>\\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Introducing Developers area with guides and API documentation - <a href=\\\"https:\\/\\/elementor.com\\/introducing-elementor-developer-api\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/451\\\">#451<\\/a>)<\\/li>\\n<li>New: Introducing <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor-hello-theme\\\">Elementor Hello Theme<\\/a> - A demonstration theme for developers<\\/li>\\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2761\\\">#2761<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2623\\\">#2623<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2109\\\">#2109<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2061\\\">#2061<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2439\\\">#2439<\\/a>)<\\/li>\\n<li>New: Design 404 page with Single template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1558\\\">#1558<\\/a>)<\\/li>\\n<li>New: Design Search Results with Archive template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3196\\\">#3196<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2590\\\">#2590<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element<\\/em> per device (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2412\\\">#2412<\\/a>)<\\/li>\\n<li>New: Integration with Custom Fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2054\\\">#2054<\\/a>)<\\/li>\\n<li>New: Partial support for Toolset integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Partial support for Pods integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2169\\\">#2169<\\/a>)<\\/li>\\n<li>New: Partial support for ACF integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2041\\\">#2041<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2059\\\">#2059<\\/a>)<\\/li>\\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3531\\\">#3531<\\/a>)<\\/li>\\n<li>Tweak: Allow brackets in Forms Tel field<\\/li>\\n<li>Tweak: Added currency format control for Price Table widget<\\/li>\\n<li>Tweak: Reduced API request for some servers<\\/li>\\n<li>Fix: Dropdown <code>border-radius<\\/code> in Nav Menu widget<\\/li>\\n<li>Fix: Price List widget layout breaks in edge cases<\\/li>\\n<li>Note: This version requires Elementor v2.0.6<\\/li>\\n<\\/ul>\\n<h4>1.15.6 - 2018-03-28<\\/h4>\\n<ul>\\n<li>Fix: Removed duplicate Custom CSS section (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3938\\\">#3938<\\/a>)<\\/li>\\n<li>Fix: <code>box-shadow<\\/code> issue with cards skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3940\\\">#3940<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.5 - 2018-03-27<\\/h4>\\n<ul>\\n<li>Fix: Added global widget compatibility for Elementor v2.0<\\/li>\\n<li>Fix: Reduced API request for some servers<\\/li>\\n<\\/ul>\\n<h4>1.15.4 - 2018-03-26<\\/h4>\\n<ul>\\n<li>Tweak: Allow brackets in phone field<\\/li>\\n<li>Tweak: Added compatibility with Yoast 7.0.+<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Support for multiple carousel setting in editor<\\/li>\\n<li>Fix: <code>on_export<\\/code> issue in forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3890\\\">#3890<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.3 - 2018-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Added unique class to field group div (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3595\\\">#3595<\\/a>)<\\/li>\\n<li>Fix: Screen Options missing when Pro is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3622\\\">#3622<\\/a>)<\\/li>\\n<li>Fix: Allow label styling even when <code>show labels<\\/code> is set hide (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3544\\\">#3544<\\/a>)<\\/li>\\n<li>Fix: Typography control not working in edge cases<\\/li>\\n<li>Fix: Safari compatibility for Search widget<\\/li>\\n<\\/ul>\\n<h4>1.15.2 - 2018-02-27<\\/h4>\\n<ul>\\n<li>Fix: Only add support mine-type if needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3543\\\">#3543<\\/a>)<\\/li>\\n<li>Fix: Better support for Old Typekit kits<\\/li>\\n<\\/ul>\\n<h4>1.15.1 - 2018-02-21<\\/h4>\\n<ul>\\n<li>Tweak: Custom font title placeholder is not <code>enter font family<\\/code><\\/li>\\n<li>Tweak: Custom font title set as required<\\/li>\\n<li>Fix: Custom font, <code>font-face<\\/code> enqueued only once if used in global (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3513\\\">#3513<\\/a>)<\\/li>\\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.<\\/li>\\n<\\/ul>\\n<h4>1.15.0 - 2018-02-19<\\/h4>\\n<ul>\\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/852\\\">#852<\\/a>)<\\/li>\\n<li>New: Integration with Adobe TypeKit fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/631\\\">#631<\\/a>)<\\/li>\\n<li>Tweak: Clear menu from Nav Menu widget on template export<\\/li>\\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle<\\/code><\\/li>\\n<\\/ul>\\n<h4>1.14.2 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Fix: Global widget content that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.14.1 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>none<\\/code> option to content animation in CTA widget<\\/li>\\n<li>Tweak: Added <code>form_id<\\/code> to ActiveCampaign integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3422\\\">#3422<\\/a>)<\\/li>\\n<li>Fix: Page crashed when Global widget not found.<\\/li>\\n<\\/ul>\\n<h4>1.14.0 - 2018-02-12<\\/h4>\\n<ul>\\n<li>New: Added Call to Action widget<\\/li>\\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Allow zero (0) to be accepted as a field value<\\/li>\\n<li>Fix: Login form when custom login URL is set<\\/li>\\n<li>Fix: Added Day of cycle control to GetResponse integration<\\/li>\\n<\\/ul>\\n<h4>1.13.2 - 2018-01-23<\\/h4>\\n<ul>\\n<li>Tweak: Added placeholder to Password field<\\/li>\\n<li>Tweak: Removed <code>subscriber_already_exists_message<\\/code> control to prevent potential data leakage<\\/li>\\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet<\\/li>\\n<li>Fix: Changed <code>imagesLoaded()<\\/code> to Vanilla JS to avoid compatibility issues with some themes<\\/li>\\n<li>Fix: Only validate Tel field if not empty<\\/li>\\n<li>Fix: Stop slider while editing<\\/li>\\n<\\/ul>\\n<h4>1.13.1 - 2018-01-16<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with old PHP versions<\\/li>\\n<\\/ul>\\n<h4>1.13.0 - 2018-01-16<\\/h4>\\n<ul>\\n<li>New: Added File Upload field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1482\\\">#1482<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Acceptance field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1693\\\">#1693<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Date field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1868\\\">#1868<\\/a>)<\\/li>\\n<li>New: Added Time field for Forms widget<\\/li>\\n<li>New: Added Password field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2164\\\">#2164<\\/a>)<\\/li>\\n<li>New: Added HTML field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1500\\\">#1500<\\/a>)<\\/li>\\n<li>Tweak: Added characters validation for Tel field<\\/li>\\n<li>Tweak: Added min &amp; max validation for Number field<\\/li>\\n<li>Tweak: Added multiple selection for Select field<\\/li>\\n<li>Tweak: Added donReach integration for Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.12.3 - 2018-01-09<\\/h4>\\n<ul>\\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget<\\/li>\\n<li>Fix: Apply <code>url-encoding<\\/code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text<\\/li>\\n<li>Fix: Removed My Account link from dashboard widget<\\/li>\\n<\\/ul>\\n<h4>1.12.2 - 2018-01-03<\\/h4>\\n<ul>\\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2964\\\">#2964<\\/a>)<\\/li>\\n<li>Fix: Active license button style<\\/li>\\n<\\/ul>\\n<h4>1.12.1 - 2018-01-02<\\/h4>\\n<ul>\\n<li>Tweak: Removed theme-element widgets from plain content<\\/li>\\n<li>Tweak: Set all theme-element widgets to extend same widget Base<\\/li>\\n<li>Tweak: Removed credit URL in forms meta data<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.9<\\/li>\\n<li>Fix: Validate Get response Error as real error<\\/li>\\n<li>Fix: Removed responsive height control from Facebook Page widget<\\/li>\\n<\\/ul>\\n<h4>1.12.0 - 2017-12-20<\\/h4>\\n<ul>\\n<li>New: Added Drip integration to Forms<\\/li>\\n<li>New: Added ActiveCampaign integration to Forms<\\/li>\\n<li>New: Added ConverKit integration to Forms<\\/li>\\n<li>New: Added GetResponse integration to Forms<\\/li>\\n<li>New: Added form <code>id<\\/code>, <code>name<\\/code> attributes to handle integration with auto collectors like HubSpot<\\/li>\\n<li>New: Added Global API key for MailChimp to improve the workflow<\\/li>\\n<li>Tweak: Better error handling and message display for Forms<\\/li>\\n<li>Fix: PHP notice Undefined variable <code>$cc_header<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2934\\\">#2934<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.11.0 - 2017-12-11<\\/h4>\\n<ul>\\n<li>New: Added a native Comments widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Added an Author Box widget<\\/li>\\n<li>New: Added a Post Navigation widget<\\/li>\\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2749\\\">#2749<\\/a>)<\\/li>\\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2762\\\">#2762<\\/a>)<\\/li>\\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric<\\/li>\\n<li>Fix: Edge cases when the nav menu is empty in a stretched section<\\/li>\\n<li>Fix: Added fallback when you remove the <code>space-between<\\/code> on Swiper carousel<\\/li>\\n<\\/ul>\\n<h4>1.10.2 - 2017-12-03<\\/h4>\\n<ul>\\n<li>Fix: Missing save widget icon (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2878\\\">#2878<\\/a>)<\\/li>\\n<li>Fix: Global widgets not saving edits (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2874\\\">#2874<\\/a>)<\\/li>\\n<li>Fix: Removed <code>white-space: nowrap;<\\/code> property from vertical menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2815\\\">#2815<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.10.1 - 2017-11-30<\\/h4>\\n<ul>\\n<li>Tweak: Added default value for search form<\\/li>\\n<li>Tweak: Order template list A-Z in the library widget<\\/li>\\n<li>Tweak: get_users\\/authors query is now done using AJAX only, for better performance in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2865\\\">#2865<\\/a>)<\\/li>\\n<li>Fix: When adding <code>.00<\\/code> it is not displayed on the front<\\/li>\\n<li>Fix: Make sure space between is numeric for carousel control<\\/li>\\n<li>Fix: Added space for radio &amp; checkbox fields in form widget<\\/li>\\n<\\/ul>\\n<h4>1.10.0 - 2017-11-15<\\/h4>\\n<ul>\\n<li>New: Added native Search form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2576\\\">#2576<\\/a>)<\\/li>\\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets<\\/li>\\n<li>Tweak: Added Inline editing to Blockquote widget<\\/li>\\n<li>Fix: Animated Headline color bug (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2516\\\">#2516<\\/a>)<\\/li>\\n<li>Fix: Animated Headline with Rotating skin<\\/li>\\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations<\\/li>\\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2662\\\">#2662<\\/a>)<\\/li>\\n<li>Fix: Custom CSS gone after reloading the editor<\\/li>\\n<\\/ul>\\n<h4>1.9.5 - 2017-10-27<\\/h4>\\n<ul>\\n<li>Fix: Broken Global widget with JS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2639\\\">#2639<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.9.4 - 2017-10-24<\\/h4>\\n<ul>\\n<li>Tweak: Improved UI for notices and license page<\\/li>\\n<li>Fix: Update system conflict with other EDD plugins<\\/li>\\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2577\\\">#2577<\\/a>)<\\/li>\\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2496\\\">#2496<\\/a>)<\\/li>\\n<li>Fix: Increased submenu max-width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2558\\\">#2558<\\/a>)<\\/li>\\n<li>Fix: Save global templates without their defaults<\\/li>\\n<li>Fix: Horizontal scrolling issue with posts grid<\\/li>\\n<\\/ul>\\n<h4>1.9.3 - 2017-10-03<\\/h4>\\n<ul>\\n<li>Fix: Condition slide style that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.9.2 - 2017-10-02<\\/h4>\\n<ul>\\n<li>New: Added integration with MailPoet 3 for Forms actions<\\/li>\\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode<\\/li>\\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel<\\/li>\\n<li>Fix: Added condition for slides style section in skin bubble mode<\\/li>\\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel<\\/li>\\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows<\\/li>\\n<\\/ul>\\n<h4>1.9.1 - 2017-09-28<\\/h4>\\n<ul>\\n<li>Fix: Slides per view for slideshow carousel<\\/li>\\n<li>Fix: Final polish for the new Testimonial Carousel widget<\\/li>\\n<li>Fix: Don\'t play video if slide type is not video<\\/li>\\n<li>Fix: Removed slides style section condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2497\\\">#2497<\\/a>)<\\/li>\\n<li>Fix: Set cursor as pointer for slideshow thumbnails<\\/li>\\n<\\/ul>\\n<h4>1.9.0 - 2017-09-26<\\/h4>\\n<ul>\\n<li>New: Added Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/216\\\">#216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/347\\\">#347<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2209\\\">#2209<\\/a>)<\\/li>\\n<li>New: Added Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/715\\\">#715<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.3 - 2017-09-24<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6<\\/li>\\n<li>Fix: Remove slashes from Form sent data<\\/li>\\n<\\/ul>\\n<h4>1.8.2 - 2017-09-19<\\/h4>\\n<ul>\\n<li>Tweak: Added target URL for the tweet message in Blockquote widget<\\/li>\\n<li>Tweak: Render the slide height before the slider is finished loading<\\/li>\\n<li>Fix: Space between words for Animated Headline widget<\\/li>\\n<li>Fix: RTL compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Italic font style for Animated Headline widget<\\/li>\\n<li>Fix: Excluded Menu widget from the WP Editor text rendering<\\/li>\\n<\\/ul>\\n<h4>1.8.1 - 2017-09-18<\\/h4>\\n<ul>\\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2391\\\">#2391<\\/a>)<\\/li>\\n<li>Fix: Print the main menu only when is necessary in Menu widget<\\/li>\\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2381\\\">#2381<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.0 - 2017-09-12<\\/h4>\\n<ul>\\n<li>New: Added Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1406\\\">#1406<\\/a>)<\\/li>\\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2279\\\">#2279<\\/a>)<\\/li>\\n<li>Fix: Style for Blockquote widget included<\\/li>\\n<\\/ul>\\n<h4>1.7.2 - 2017-09-07<\\/h4>\\n<ul>\\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins<\\/li>\\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2340\\\">#2340<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.7.1 - 2017-09-05<\\/h4>\\n<ul>\\n<li>Fix: Facebook SDK version<\\/li>\\n<\\/ul>\\n<h4>1.7.0 - 2017-09-05<\\/h4>\\n<ul>\\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow<\\/li>\\n<li>New: Added Facebook Embed widget for Post, Video and Comment<\\/li>\\n<li>New: Added Facebook Comments widget<\\/li>\\n<li>New: Added Facebook Page widget (Previously known as Like Box)<\\/li>\\n<li>New: Added Blockquote widget with Tweet button<\\/li>\\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets<\\/li>\\n<li>Fix: Animated headline rotating with long words<\\/li>\\n<\\/ul>\\n<h4>1.6.1 - 2017-08-28<\\/h4>\\n<ul>\\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set<\\/li>\\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser<\\/li>\\n<li>Fix: Animated headline with more than 1-word per rotation<\\/li>\\n<li>Fix: Animated Headline in two lines<\\/li>\\n<li>Fix: Some errors in Global widget<\\/li>\\n<\\/ul>\\n<h4>1.6.0 - 2017-08-22<\\/h4>\\n<ul>\\n<li>New: Added Animated Headline widget<\\/li>\\n<li>New: Added Hidden field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2038\\\">#2038<\\/a>)<\\/li>\\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher<\\/li>\\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts<\\/li>\\n<\\/ul>\\n<h4>1.5.9 - 2017-08-16<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.7<\\/li>\\n<li>Fix: Portfolio compatibility for GeneratePress theme<\\/li>\\n<li>Fix: Portfolio filter compatibility for RTL<\\/li>\\n<li>Fix: Pagination apply for all posts widget in the page<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.8 - 2017-07-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.6<\\/li>\\n<li>Fix: Improved backward compatibility for query control rename<\\/li>\\n<\\/ul>\\n<h4>1.5.7 - 2017-07-24<\\/h4>\\n<ul>\\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file<\\/li>\\n<li>Tweak: Display the label in the reCAPTCHA field for better experience<\\/li>\\n<li>Tweak: Rename <code>panel-posts-control<\\/code> to <code>query-control<\\/code> and added fallback support<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor with history feature<\\/li>\\n<li>Fix: reCAPTCHA preview on the editor<\\/li>\\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2000\\\">#2000<\\/a>)<\\/li>\\n<li>Fix: Added condition for icon size control in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.5.6 - 2017-07-12<\\/h4>\\n<ul>\\n<li>Fix: Query Control correction for taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1963\\\">#1963<\\/a>)<\\/li>\\n<li>Fix: Custom CSS override scheme color in the editor<\\/li>\\n<li>Fix: Added order by Menu Order for Query Control in WC widget<\\/li>\\n<li>Fix: Glitch with Flip Box background overlay<\\/li>\\n<\\/ul>\\n<h4>1.5.5 - 2017-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist<\\/li>\\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999<\\/li>\\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed<\\/li>\\n<li>Fix: Sorted items in filter bar by A-Z<\\/li>\\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1927\\\">#1927<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.5.4 - 2017-06-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved compatibility for Elementor v1.5<\\/li>\\n<li>Fix: URL default for Add To Cart widget<\\/li>\\n<li>Fix: Allowed <code>date<\\/code> and <code>birthday<\\/code> fields as text for MailChimp integration<\\/li>\\n<\\/ul>\\n<h4>1.5.3 - 2017-06-19<\\/h4>\\n<ul>\\n<li>Tweak: Make flip-box height responsive control<\\/li>\\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1829\\\">#1829<\\/a>)<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.2 - 2017-06-13<\\/h4>\\n<ul>\\n<li>Fix: Custom CSS panel location compatibility for the old versions<\\/li>\\n<\\/ul>\\n<h4>1.5.1 - 2017-06-12<\\/h4>\\n<ul>\\n<li>Fix: MailChimp update existing user registration<\\/li>\\n<li>Fix: Global widget with JS in the editor mode<\\/li>\\n<li>Fix: Label section condition in Login widget<\\/li>\\n<li>Fix: Changes to unlinked global widget do not appear in the editor<\\/li>\\n<\\/ul>\\n<h4>1.5.0 - 2017-05-23<\\/h4>\\n<ul>\\n<li>New: Added Cards, a new skin for Posts widget<\\/li>\\n<li>New: Added Exclude option to post query control group<\\/li>\\n<li>Tweak: Added <code>post_class()<\\/code> for each post in the loop<\\/li>\\n<li>Tweak: Added <code>.elementor-posts-masonry<\\/code> class when Masonry layout is enabled<\\/li>\\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0<\\/li>\\n<li>Tweak: CSS <code>autoprefixer<\\/code> now supports last 5 versions of browsers<\\/li>\\n<li>Tweak: Added <code>imageLoaded<\\/code> library for Posts &amp; Portfolio widgets<\\/li>\\n<\\/ul>\\n<h4>1.4.4 - 2017-05-18<\\/h4>\\n<ul>\\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1683\\\">#1683<\\/a>)<\\/li>\\n<li>Fix: Added <code>.elementor-form<\\/code> class to Login form to fix style glitch<\\/li>\\n<\\/ul>\\n<h4>1.4.3 - 2017-05-14<\\/h4>\\n<ul>\\n<li>Tweak: Added Redirect After Login option to Login widget<\\/li>\\n<li>Tweak: Stay in the current page after logout in Login widget<\\/li>\\n<li>Tweak: Preparation for Elementor settings tabs in future version<\\/li>\\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone<\\/li>\\n<li>Fix: Bug with <code>active<\\/code> class in portfolio filter item<\\/li>\\n<li>Fix: Higher specific list-style-type <code>none<\\/code> for filter items to override some theme style<\\/li>\\n<\\/ul>\\n<h4>1.4.2 - 2017-05-06<\\/h4>\\n<ul>\\n<li>Fix: Temporary patch for form field shortcode in some servers<\\/li>\\n<\\/ul>\\n<h4>1.4.1 - 2017-05-03<\\/h4>\\n<ul>\\n<li>Fix: Bug with custom success message in form widget<\\/li>\\n<li>Fix: Bug with meta data in email action<\\/li>\\n<\\/ul>\\n<h4>1.4.0 - 2017-05-03<\\/h4>\\n<ul>\\n<li>New: Forms: integration with MailChimp<\\/li>\\n<li>New: Forms: integration with MailPoet<\\/li>\\n<li>New: Forms: Added Email 2 action for email confirmation<\\/li>\\n<li>New: Forms: Added shortcodes for fields<\\/li>\\n<li>New: Forms: Added custom ID for fields<\\/li>\\n<li>New: Forms: Added option to edit email HTML template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>New: Added Login widget<\\/li>\\n<li>Tweak: Move <code>send_html<\\/code> control to <code>email_content_type<\\/code><\\/li>\\n<li>Fix: Email still sent even if validation failed in form widget<\\/li>\\n<\\/ul>\\n<h4>1.3.2 - 2017-05-01<\\/h4>\\n<ul>\\n<li>New: Added action <code>elementor_pro\\/init<\\/code> for better integration with Elementor Pro<\\/li>\\n<li>Fix: Posts without featured image in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1234\\\">#1234<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1382\\\">#1382<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method<\\/li>\\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser<\\/li>\\n<li>Fix: Border radius glitch on hover in Share Buttons<\\/li>\\n<\\/ul>\\n<h4>1.3.1 - 2017-04-25<\\/h4>\\n<ul>\\n<li>Fix: Conflict update with revision history module<\\/li>\\n<\\/ul>\\n<h4>1.3.0 - 2017-04-25<\\/h4>\\n<ul>\\n<li>New: Added Share Buttons widget (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/social-sharing-buttons-is-it-possible\\/\\\">Topic<\\/a>)<\\/li>\\n<li>New: Added Custom CSS for Page Settings<\\/li>\\n<li>New: Added Masonry layout for Portfolio widget<\\/li>\\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1181\\\">#1181<\\/a>)<\\/li>\\n<li>New: Introduced <code>ElementorProModulesFormsClassesAction_Base<\\/code> class for better 3rd party integration for forms<\\/li>\\n<li>Tweak: Debugger module now also shows errors from Pro<\\/li>\\n<li>Tweak: Added options for Elementor Library<\\/li>\\n<li>Tweak: New base posts module for optimized performance<\\/li>\\n<li>Tweak: Adjusting Posts \\/ Portfolio to the new structure<\\/li>\\n<li>Fix: Export for posts \\/ portfolio<\\/li>\\n<li>Fix: Duplicate repeater field with switcher control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1442\\\">#1442<\\/a>)<\\/li>\\n<li>Fix: Post per Page in the query control<\\/li>\\n<li>Fix: Metadata does not come through on form emails (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1566\\\">#1566<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.2.6 - 2017-04-19<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets<\\/li>\\n<\\/ul>\\n<h4>1.2.5 - 2017-04-18<\\/h4>\\n<ul>\\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)<\\/li>\\n<\\/ul>\\n<h4>1.2.4 - 2017-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added Indian Rupee sign to Price Table widget<\\/li>\\n<li>Fix: Portfolio grid for IE11<\\/li>\\n<li>Fix: Link target blank in Price List widget<\\/li>\\n<li>Fix: Active item for filter bar in Portfolio widget<\\/li>\\n<\\/ul>\\n<h4>1.2.3 - 2017-03-06<\\/h4>\\n<ul>\\n<li>Tweak: Fully compatible with Elementor v1.3.0<\\/li>\\n<li>Tweak: Added trigger for after form submission in Forms widget<\\/li>\\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms<\\/li>\\n<li>Fix: Portfolio filter syntax in Non-Latin languages<\\/li>\\n<li>Fix: Added <code>no-repeat<\\/code> property for slide with <code>background-size:contain<\\/code><\\/li>\\n<li>Fix: Condition control &amp; Import value in Posts widgets<\\/li>\\n<li>Fix: Offset and Pagination in WordPress (<a href=\\\"https:\\/\\/codex.wordpress.org\\/Making_Custom_Queries_using_Offset_and_Pagination\\\">More Info<\\/a>)<\\/li>\\n<li>Fix: Submit handler bubbling for custom events in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.2.2 - 2017-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Change name from Side A\\/B to Front and Back in Flip Box widget<\\/li>\\n<li>Fix: Error when saving third party widgets in the global widget<\\/li>\\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)<\\/li>\\n<li>Fix: Hide the pagination when there are no links<\\/li>\\n<\\/ul>\\n<h4>1.2.1 - 2017-02-21<\\/h4>\\n<ul>\\n<li>Fix: Firefox Flip Box 3D compatibility<\\/li>\\n<\\/ul>\\n<h4>1.2.0 - 2017-02-21<\\/h4>\\n<ul>\\n<li>New: Added Flip Box widget<\\/li>\\n<li>New: Added Ken Burns effect for slides<\\/li>\\n<li>New: Added Masonry layout for Posts widget<\\/li>\\n<li>New: Added Pagination option for Posts widget<\\/li>\\n<li>Tweak: Added background size contain to slides<\\/li>\\n<li>Tweak: Improve Query control by preload items<\\/li>\\n<li>Fix: Text color for Checkbox and Radio fields<\\/li>\\n<\\/ul>\\n<h4>1.1.2 - 2017-02-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>aria-required<\\/code> for better accessibility in forms widget<\\/li>\\n<li>Fix: Conflict Call to <code>undefined<\\/code> method in Posts &amp; Portfolio widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1271\\\">#1271<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1266\\\">#1266<\\/a>)<\\/li>\\n<li>Fix: Submit button HTML after error sending<\\/li>\\n<li>Fix: Success message for <code>skip_email<\\/code> function<\\/li>\\n<li>Notice: Elementor 1.2.0 or later now required<\\/li>\\n<\\/ul>\\n<h4>1.1.1 - 2017-01-24<\\/h4>\\n<ul>\\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG<\\/code> is <code>true<\\/code><\\/li>\\n<li>Fix: Undefined variable in WC widgets<\\/li>\\n<li>Fix: Removed duplicate strings<\\/li>\\n<\\/ul>\\n<h4>1.1.0 - 2017-01-24<\\/h4>\\n<ul>\\n<li>New: Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/102\\\">#102<\\/a>)<\\/li>\\n<li>New: WooCommerce Add to Cart widget<\\/li>\\n<li>New: WooCommerce Categories widget<\\/li>\\n<li>New: WooCommerce Elements widget<\\/li>\\n<li>New: Honeypot field for Forms widgets<\\/li>\\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items<\\/li>\\n<li>Tweak: Added Required Mark for fields in Forms widget<\\/li>\\n<li>Fix: CSS selectors priority in Slides widget<\\/li>\\n<li>Fix: CSS bug in Price List widget<\\/li>\\n<li>Fix: Update all Post CSS files that includes specific Global Widget<\\/li>\\n<\\/ul>\\n<h4>1.0.9 - 2017-01-18<\\/h4>\\n<ul>\\n<li>Fix: Auto complete bug in query controls<\\/li>\\n<li>Fix: Render template with escaping slashes<\\/li>\\n<li>Fix: Reply-to field in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.0.8 - 2017-01-11<\\/h4>\\n<ul>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Removed go pro link from plugins page in admin<\\/li>\\n<\\/ul>\\n<h4>1.0.7 - 2017-01-05<\\/h4>\\n<ul>\\n<li>Tweak: Added filter by featured \\/ sale for WC Products widget<\\/li>\\n<li>Tweak: Added author control in Portfolio widget<\\/li>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Added support for empty image ratio<\\/li>\\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself<\\/li>\\n<\\/ul>\\n<h4>1.0.6 - 2017-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Added Auto-updates for local translation files<\\/li>\\n<li>Fix: Custom CSS for Global widgets<\\/li>\\n<li>Fix: Remove <code>nonce<\\/code> field (Fix some cache plugins)<\\/li>\\n<\\/ul>\\n<h4>1.0.5 - 2016-12-27<\\/h4>\\n<ul>\\n<li>Fix: Slide element bug fix - \'Link apply on\' logic<\\/li>\\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1086\\\">#1086<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.0.4 - 2016-12-21<\\/h4>\\n<ul>\\n<li>Tweak: Mobile Editing for fields in the form widget<\\/li>\\n<li>Tweak: Mobile Editing for posts<\\/li>\\n<li>Tweak: Allow send form as HTML<\\/li>\\n<li>Tweak: Improved auto upgrades for Multisite installation<\\/li>\\n<li>Tweak: Improve editor rendering experience for Portfolio widget<\\/li>\\n<li>Fix: Posts widget check if image exist<\\/li>\\n<li>Fix: Changed the clone method for global widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1042\\\">#1042<\\/a>)<\\/li>\\n<li>Fix: Bug slides in RTL (removed direction control)<\\/li>\\n<li>Fix: Slides with no height jumps when changing slides<\\/li>\\n<\\/ul>\\n<h4>1.0.3 - 2016-12-13<\\/h4>\\n<ul>\\n<li>Fix: Added escape placeholder for HTML Entities in form widget<\\/li>\\n<li>Fix: Countdown widget RTL bug<\\/li>\\n<li>Fix: Remove redundant #elementor selector for control style<\\/li>\\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>1.0.2 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form<\\/li>\\n<\\/ul>\\n<h4>1.0.1 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active<\\/li>\\n<\\/ul>\\n<h4>1.0.0 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Initial release<\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.30.1\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.2\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzUzNTk2NzU3LCJleHAiOjE3NTM2ODMxNTd9.oVl2v-dOAEkXWYEF3-poTk0inA_VeRbHsk-XsGeiejQ\\/package_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzUzNTk2NzU3LCJleHAiOjE3NTM2ODMxNTd9.oVl2v-dOAEkXWYEF3-poTk0inA_VeRbHsk-XsGeiejQ\\/package_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.7.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.2\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ2ZXJzaW9uIjoiMy43LjAiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJpYXQiOjE3NTM1OTY3NTcsImV4cCI6MTc1MzY4MzE1N30.eL7FnQPHor4rcKFZUbaKYYZYnRc6Sb8promSPikJ6xg\\/previous_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ2ZXJzaW9uIjoiMy43LjAiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJpYXQiOjE3NTM1OTY3NTcsImV4cCI6MTc1MzY4MzE1N30.eL7FnQPHor4rcKFZUbaKYYZYnRc6Sb8promSPikJ6xg\\/previous_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"translations\":[{\"language\":\"fa_IR\",\"updated\":\"2024-04-29 14:12:39+0000\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/translation\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJsYW5ndWFnZSI6ImZhX0lSIiwiaWF0IjoxNzUzNTk2NzU3fQ.qU0J3ZOAk8zwjHilhcNlvjUomgYLb2ez2heYDBPOi8k\\/translation\"}],\"cloud\":false}\";}", "off");
INSERT INTO `wp_options` VALUES("3893", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("4031", "duplicator_version_plugin", "1.5.12", "auto");
INSERT INTO `wp_options` VALUES("4033", "duplicator_install_info", "a:3:{s:7:\"version\";s:6:\"1.5.12\";s:4:\"time\";i:1751090012;s:10:\"updateTime\";i:1751090012;}", "off");
INSERT INTO `wp_options` VALUES("4034", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("4035", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("4036", "duplicator_settings", "a:20:{s:7:\"version\";s:6:\"1.5.12\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:5;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("4037", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"MVtso1LNXi.Cl4kGHv.zGgedB2Y+m.w5b9&W9NFphv;J\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 4,\n    \"buildLastDate\": 1752485994,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 257.33,\n    \"siteNumFiles\": 13260,\n    \"siteDbSizeMB\": 12.73,\n    \"siteDbNumTables\": 25\n}", "auto");
INSERT INTO `wp_options` VALUES("4038", "duplicator_notifications", "a:4:{s:6:\"update\";i:1753598989;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("4039", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-27 06:50:33\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"31dbf334864cbca79181_20250727065033\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:60:\"/home/heqcbspg/public_html/en;/home/heqcbspg/public_html/en2\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:1;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:26:\"/home/heqcbspg/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2157;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11103;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-07-27 06:50:33\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250628_d981d8b1d988d8b4daafd8a7d987d8\";s:4:\"Hash\";s:35:\"31dbf334864cbca79181_20250727065033\";s:8:\"NameHash\";s:75:\"20250628_d981d8b1d988d8b4daafd8a7d987d8_31dbf334864cbca79181_20250727065033\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:40:\"/home/heqcbspg/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:35:\"/home/heqcbspg/public_html/wp-admin\";i:1;s:38:\"/home/heqcbspg/public_html/wp-includes\";i:2;s:47:\"/home/heqcbspg/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:26:\"/home/heqcbspg/public_html\";i:1;s:26:\"/home/heqcbspg/public_html\";i:2;s:37:\"/home/heqcbspg/public_html/wp-content\";i:3;s:45:\"/home/heqcbspg/public_html/wp-content/uploads\";i:4;s:45:\"/home/heqcbspg/public_html/wp-content/plugins\";i:5;s:48:\"/home/heqcbspg/public_html/wp-content/mu-plugins\";i:6;s:44:\"/home/heqcbspg/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:58:\"/home/heqcbspg/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wp_options` VALUES("4040", "duplicator_ui_view_state", "a:2:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";s:24:\"dup-pack-installer-panel\";s:1:\"0\";}", "auto");
INSERT INTO `wp_options` VALUES("4041", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_options` VALUES("4284", "wpcode_snippets_errors", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("4436", "updraft_lock_load-url-task", "0", "no");
INSERT INTO `wp_options` VALUES("4437", "updraft_lock_wpo_page_cache_preloader_creating_tasks", "0", "no");
INSERT INTO `wp_options` VALUES("4439", "updraft_lock_wpo_minify_preloader_creating_tasks", "0", "no");
INSERT INTO `wp_options` VALUES("4468", "_elementor_element_cache_unique_id", "0d387c325053230790e448b23b1cc8e1", "auto");
INSERT INTO `wp_options` VALUES("4487", "litespeed.conf._version", "7.2", "auto");
INSERT INTO `wp_options` VALUES("4488", "litespeed.conf.hash", "73SIqwS6LcZoWedImA1fi9LlrCqM6f62", "auto");
INSERT INTO `wp_options` VALUES("4489", "litespeed.conf.api_key", "", "auto");
INSERT INTO `wp_options` VALUES("4490", "litespeed.conf.auto_upgrade", "", "auto");
INSERT INTO `wp_options` VALUES("4491", "litespeed.conf.server_ip", "", "auto");
INSERT INTO `wp_options` VALUES("4492", "litespeed.conf.guest", "", "auto");
INSERT INTO `wp_options` VALUES("4493", "litespeed.conf.guest_optm", "", "auto");
INSERT INTO `wp_options` VALUES("4494", "litespeed.conf.news", "", "auto");
INSERT INTO `wp_options` VALUES("4495", "litespeed.conf.guest_uas", "[\"Lighthouse\",\"GTmetrix\",\"Google\",\"Pingdom\",\"bot\",\"spider\",\"PTST\",\"HeadlessChrome\"]", "auto");
INSERT INTO `wp_options` VALUES("4496", "litespeed.conf.guest_ips", "[\"208.70.247.157\",\"172.255.48.130\",\"172.255.48.131\",\"172.255.48.132\",\"172.255.48.133\",\"172.255.48.134\",\"172.255.48.135\",\"172.255.48.136\",\"172.255.48.137\",\"172.255.48.138\",\"172.255.48.139\",\"172.255.48.140\",\"172.255.48.141\",\"172.255.48.142\",\"172.255.48.143\",\"172.255.48.144\",\"172.255.48.145\",\"172.255.48.146\",\"172.255.48.147\",\"52.229.122.240\",\"104.214.72.101\",\"13.66.7.11\",\"13.85.24.83\",\"13.85.24.90\",\"13.85.82.26\",\"40.74.242.253\",\"40.74.243.13\",\"40.74.243.176\",\"104.214.48.247\",\"157.55.189.189\",\"104.214.110.135\",\"70.37.83.240\",\"65.52.36.250\",\"13.78.216.56\",\"52.162.212.163\",\"23.96.34.105\",\"65.52.113.236\",\"172.255.61.34\",\"172.255.61.35\",\"172.255.61.36\",\"172.255.61.37\",\"172.255.61.38\",\"172.255.61.39\",\"172.255.61.40\",\"104.41.2.19\",\"191.235.98.164\",\"191.235.99.221\",\"191.232.194.51\",\"52.237.235.185\",\"52.237.250.73\",\"52.237.236.145\",\"104.211.143.8\",\"104.211.165.53\",\"52.172.14.87\",\"40.83.89.214\",\"52.175.57.81\",\"20.188.63.151\",\"20.52.36.49\",\"52.246.165.153\",\"51.144.102.233\",\"13.76.97.224\",\"102.133.169.66\",\"52.231.199.170\",\"13.53.162.7\",\"40.123.218.94\"]", "auto");
INSERT INTO `wp_options` VALUES("4497", "litespeed.conf.cache", "1", "auto");
INSERT INTO `wp_options` VALUES("4498", "litespeed.conf.cache-priv", "1", "auto");
INSERT INTO `wp_options` VALUES("4499", "litespeed.conf.cache-commenter", "1", "auto");
INSERT INTO `wp_options` VALUES("4500", "litespeed.conf.cache-rest", "1", "auto");
INSERT INTO `wp_options` VALUES("4501", "litespeed.conf.cache-page_login", "", "auto");
INSERT INTO `wp_options` VALUES("4502", "litespeed.conf.cache-mobile", "", "auto");
INSERT INTO `wp_options` VALUES("4503", "litespeed.conf.cache-mobile_rules", "[\"Mobile\",\"Android\",\"Silk\\/\",\"Kindle\",\"BlackBerry\",\"Opera Mini\",\"Opera Mobi\"]", "auto");
INSERT INTO `wp_options` VALUES("4504", "litespeed.conf.cache-browser", "", "auto");
INSERT INTO `wp_options` VALUES("4505", "litespeed.conf.cache-exc_useragents", "[]", "auto");
INSERT INTO `wp_options` VALUES("4506", "litespeed.conf.cache-exc_cookies", "[]", "auto");
INSERT INTO `wp_options` VALUES("4507", "litespeed.conf.cache-exc_qs", "[]", "auto");
INSERT INTO `wp_options` VALUES("4508", "litespeed.conf.cache-exc_cat", "[]", "auto");
INSERT INTO `wp_options` VALUES("4509", "litespeed.conf.cache-exc_tag", "[]", "auto");
INSERT INTO `wp_options` VALUES("4510", "litespeed.conf.cache-force_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("4511", "litespeed.conf.cache-force_pub_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("4512", "litespeed.conf.cache-priv_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("4513", "litespeed.conf.cache-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4514", "litespeed.conf.cache-exc_roles", "[\"administrator\"]", "auto");
INSERT INTO `wp_options` VALUES("4515", "litespeed.conf.cache-drop_qs", "[\"fbclid\",\"gclid\",\"utm*\",\"_ga\"]", "auto");
INSERT INTO `wp_options` VALUES("4516", "litespeed.conf.cache-ttl_pub", "604800", "auto");
INSERT INTO `wp_options` VALUES("4517", "litespeed.conf.cache-ttl_priv", "1800", "auto");
INSERT INTO `wp_options` VALUES("4518", "litespeed.conf.cache-ttl_frontpage", "604800", "auto");
INSERT INTO `wp_options` VALUES("4519", "litespeed.conf.cache-ttl_feed", "604800", "auto");
INSERT INTO `wp_options` VALUES("4520", "litespeed.conf.cache-ttl_rest", "86400", "auto");
INSERT INTO `wp_options` VALUES("4521", "litespeed.conf.cache-ttl_browser", "31557600", "auto");
INSERT INTO `wp_options` VALUES("4522", "litespeed.conf.cache-ttl_status", "[\"404 3600\",\"500 600\"]", "auto");
INSERT INTO `wp_options` VALUES("4523", "litespeed.conf.cache-login_cookie", "", "auto");
INSERT INTO `wp_options` VALUES("4524", "litespeed.conf.cache-ajax_ttl", "[]", "auto");
INSERT INTO `wp_options` VALUES("4525", "litespeed.conf.cache-vary_cookies", "[]", "auto");
INSERT INTO `wp_options` VALUES("4526", "litespeed.conf.cache-vary_group", "{\"administrator\":\"99\",\"author\":\"0\",\"contributor\":\"0\",\"editor\":\"0\",\"subscriber\":\"0\"}", "auto");
INSERT INTO `wp_options` VALUES("4527", "litespeed.conf.purge-upgrade", "1", "auto");
INSERT INTO `wp_options` VALUES("4528", "litespeed.conf.purge-stale", "", "auto");
INSERT INTO `wp_options` VALUES("4529", "litespeed.conf.purge-post_all", "", "auto");
INSERT INTO `wp_options` VALUES("4530", "litespeed.conf.purge-post_f", "1", "auto");
INSERT INTO `wp_options` VALUES("4531", "litespeed.conf.purge-post_h", "1", "auto");
INSERT INTO `wp_options` VALUES("4532", "litespeed.conf.purge-post_p", "1", "auto");
INSERT INTO `wp_options` VALUES("4533", "litespeed.conf.purge-post_pwrp", "1", "auto");
INSERT INTO `wp_options` VALUES("4534", "litespeed.conf.purge-post_a", "", "auto");
INSERT INTO `wp_options` VALUES("4535", "litespeed.conf.purge-post_y", "", "auto");
INSERT INTO `wp_options` VALUES("4536", "litespeed.conf.purge-post_m", "", "auto");
INSERT INTO `wp_options` VALUES("4537", "litespeed.conf.purge-post_d", "", "auto");
INSERT INTO `wp_options` VALUES("4538", "litespeed.conf.purge-post_t", "1", "auto");
INSERT INTO `wp_options` VALUES("4539", "litespeed.conf.purge-post_pt", "1", "auto");
INSERT INTO `wp_options` VALUES("4540", "litespeed.conf.purge-timed_urls", "[]", "auto");
INSERT INTO `wp_options` VALUES("4541", "litespeed.conf.purge-timed_urls_time", "", "auto");
INSERT INTO `wp_options` VALUES("4542", "litespeed.conf.purge-hook_all", "[\"switch_theme\",\"wp_create_nav_menu\",\"wp_update_nav_menu\",\"wp_delete_nav_menu\",\"create_term\",\"edit_terms\",\"delete_term\",\"add_link\",\"edit_link\",\"delete_link\"]", "auto");
INSERT INTO `wp_options` VALUES("4543", "litespeed.conf.esi", "", "auto");
INSERT INTO `wp_options` VALUES("4544", "litespeed.conf.esi-cache_admbar", "", "auto");
INSERT INTO `wp_options` VALUES("4545", "litespeed.conf.esi-cache_commform", "", "auto");
INSERT INTO `wp_options` VALUES("4546", "litespeed.conf.esi-nonce", "[\"stats_nonce\",\"subscribe_nonce\"]", "auto");
INSERT INTO `wp_options` VALUES("4547", "litespeed.conf.util-instant_click", "", "auto");
INSERT INTO `wp_options` VALUES("4548", "litespeed.conf.util-no_https_vary", "", "auto");
INSERT INTO `wp_options` VALUES("4549", "litespeed.conf.debug-disable_all", "", "auto");
INSERT INTO `wp_options` VALUES("4550", "litespeed.conf.debug", "", "auto");
INSERT INTO `wp_options` VALUES("4551", "litespeed.conf.debug-ips", "[\"127.0.0.1\"]", "auto");
INSERT INTO `wp_options` VALUES("4552", "litespeed.conf.debug-level", "", "auto");
INSERT INTO `wp_options` VALUES("4553", "litespeed.conf.debug-filesize", "3", "auto");
INSERT INTO `wp_options` VALUES("4554", "litespeed.conf.debug-collapse_qs", "", "auto");
INSERT INTO `wp_options` VALUES("4555", "litespeed.conf.debug-inc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4556", "litespeed.conf.debug-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4557", "litespeed.conf.debug-exc_strings", "[]", "auto");
INSERT INTO `wp_options` VALUES("4558", "litespeed.conf.db_optm-revisions_max", "0", "auto");
INSERT INTO `wp_options` VALUES("4559", "litespeed.conf.db_optm-revisions_age", "0", "auto");
INSERT INTO `wp_options` VALUES("4560", "litespeed.conf.optm-css_min", "", "auto");
INSERT INTO `wp_options` VALUES("4561", "litespeed.conf.optm-css_comb", "", "auto");
INSERT INTO `wp_options` VALUES("4562", "litespeed.conf.optm-css_comb_ext_inl", "1", "auto");
INSERT INTO `wp_options` VALUES("4563", "litespeed.conf.optm-ucss", "", "auto");
INSERT INTO `wp_options` VALUES("4564", "litespeed.conf.optm-ucss_inline", "", "auto");
INSERT INTO `wp_options` VALUES("4565", "litespeed.conf.optm-ucss_whitelist", "[]", "auto");
INSERT INTO `wp_options` VALUES("4566", "litespeed.conf.optm-ucss_file_exc_inline", "[]", "auto");
INSERT INTO `wp_options` VALUES("4567", "litespeed.conf.optm-ucss_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4568", "litespeed.conf.optm-css_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4569", "litespeed.conf.optm-js_min", "", "auto");
INSERT INTO `wp_options` VALUES("4570", "litespeed.conf.optm-js_comb", "", "auto");
INSERT INTO `wp_options` VALUES("4571", "litespeed.conf.optm-js_comb_ext_inl", "1", "auto");
INSERT INTO `wp_options` VALUES("4572", "litespeed.conf.optm-js_delay_inc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4573", "litespeed.conf.optm-js_exc", "[\"jquery.js\",\"jquery.min.js\"]", "auto");
INSERT INTO `wp_options` VALUES("4574", "litespeed.conf.optm-html_min", "", "auto");
INSERT INTO `wp_options` VALUES("4575", "litespeed.conf.optm-html_lazy", "[]", "auto");
INSERT INTO `wp_options` VALUES("4576", "litespeed.conf.optm-html_skip_comment", "[]", "auto");
INSERT INTO `wp_options` VALUES("4577", "litespeed.conf.optm-qs_rm", "", "auto");
INSERT INTO `wp_options` VALUES("4578", "litespeed.conf.optm-ggfonts_rm", "", "auto");
INSERT INTO `wp_options` VALUES("4579", "litespeed.conf.optm-css_async", "", "auto");
INSERT INTO `wp_options` VALUES("4580", "litespeed.conf.optm-ccss_per_url", "", "auto");
INSERT INTO `wp_options` VALUES("4581", "litespeed.conf.optm-ccss_sep_posttype", "[\"page\"]", "auto");
INSERT INTO `wp_options` VALUES("4582", "litespeed.conf.optm-ccss_sep_uri", "[]", "auto");
INSERT INTO `wp_options` VALUES("4583", "litespeed.conf.optm-ccss_whitelist", "[]", "auto");
INSERT INTO `wp_options` VALUES("4584", "litespeed.conf.optm-css_async_inline", "1", "auto");
INSERT INTO `wp_options` VALUES("4585", "litespeed.conf.optm-css_font_display", "", "auto");
INSERT INTO `wp_options` VALUES("4586", "litespeed.conf.optm-js_defer", "", "auto");
INSERT INTO `wp_options` VALUES("4587", "litespeed.conf.optm-emoji_rm", "", "auto");
INSERT INTO `wp_options` VALUES("4588", "litespeed.conf.optm-noscript_rm", "", "auto");
INSERT INTO `wp_options` VALUES("4589", "litespeed.conf.optm-ggfonts_async", "", "auto");
INSERT INTO `wp_options` VALUES("4590", "litespeed.conf.optm-exc_roles", "[]", "auto");
INSERT INTO `wp_options` VALUES("4591", "litespeed.conf.optm-ccss_con", "", "auto");
INSERT INTO `wp_options` VALUES("4592", "litespeed.conf.optm-js_defer_exc", "[\"jquery.js\",\"jquery.min.js\",\"gtm.js\",\"analytics.js\"]", "auto");
INSERT INTO `wp_options` VALUES("4593", "litespeed.conf.optm-gm_js_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4594", "litespeed.conf.optm-dns_prefetch", "[]", "auto");
INSERT INTO `wp_options` VALUES("4595", "litespeed.conf.optm-dns_prefetch_ctrl", "", "auto");
INSERT INTO `wp_options` VALUES("4596", "litespeed.conf.optm-dns_preconnect", "[]", "auto");
INSERT INTO `wp_options` VALUES("4597", "litespeed.conf.optm-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4598", "litespeed.conf.optm-guest_only", "1", "auto");
INSERT INTO `wp_options` VALUES("4599", "litespeed.conf.object", "1", "auto");
INSERT INTO `wp_options` VALUES("4600", "litespeed.conf.object-kind", "1", "auto");
INSERT INTO `wp_options` VALUES("4601", "litespeed.conf.object-host", "localhost", "auto");
INSERT INTO `wp_options` VALUES("4602", "litespeed.conf.object-port", "6379", "auto");
INSERT INTO `wp_options` VALUES("4603", "litespeed.conf.object-life", "360", "auto");
INSERT INTO `wp_options` VALUES("4604", "litespeed.conf.object-persistent", "1", "auto");
INSERT INTO `wp_options` VALUES("4605", "litespeed.conf.object-admin", "", "auto");
INSERT INTO `wp_options` VALUES("4606", "litespeed.conf.object-transients", "1", "auto");
INSERT INTO `wp_options` VALUES("4607", "litespeed.conf.object-db_id", "0", "auto");
INSERT INTO `wp_options` VALUES("4608", "litespeed.conf.object-user", "", "auto");
INSERT INTO `wp_options` VALUES("4609", "litespeed.conf.object-pswd", "", "auto");
INSERT INTO `wp_options` VALUES("4610", "litespeed.conf.object-global_groups", "[\"users\",\"userlogins\",\"useremail\",\"userslugs\",\"usermeta\",\"user_meta\",\"site-transient\",\"site-options\",\"site-lookup\",\"site-details\",\"blog-lookup\",\"blog-details\",\"blog-id-cache\",\"rss\",\"global-posts\",\"global-cache-test\"]", "auto");
INSERT INTO `wp_options` VALUES("4611", "litespeed.conf.object-non_persistent_groups", "[\"comment\",\"counts\",\"plugins\",\"wc_session_id\"]", "auto");
INSERT INTO `wp_options` VALUES("4612", "litespeed.conf.discuss-avatar_cache", "", "auto");
INSERT INTO `wp_options` VALUES("4613", "litespeed.conf.discuss-avatar_cron", "", "auto");
INSERT INTO `wp_options` VALUES("4614", "litespeed.conf.discuss-avatar_cache_ttl", "604800", "auto");
INSERT INTO `wp_options` VALUES("4615", "litespeed.conf.optm-localize", "", "auto");
INSERT INTO `wp_options` VALUES("4616", "litespeed.conf.optm-localize_domains", "[\"### Popular scripts ###\",\"https:\\/\\/platform.twitter.com\\/widgets.js\",\"https:\\/\\/connect.facebook.net\\/en_US\\/fbevents.js\"]", "auto");
INSERT INTO `wp_options` VALUES("4617", "litespeed.conf.media-lazy", "", "auto");
INSERT INTO `wp_options` VALUES("4618", "litespeed.conf.media-lazy_placeholder", "", "auto");
INSERT INTO `wp_options` VALUES("4619", "litespeed.conf.media-placeholder_resp", "", "auto");
INSERT INTO `wp_options` VALUES("4620", "litespeed.conf.media-placeholder_resp_color", "#cfd4db", "auto");
INSERT INTO `wp_options` VALUES("4621", "litespeed.conf.media-placeholder_resp_svg", "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"{width}\" height=\"{height}\" viewBox=\"0 0 {width} {height}\"><rect width=\"100%\" height=\"100%\" style=\"fill:{color};fill-opacity: 0.1;\"/></svg>", "auto");
INSERT INTO `wp_options` VALUES("4622", "litespeed.conf.media-lqip", "", "auto");
INSERT INTO `wp_options` VALUES("4623", "litespeed.conf.media-lqip_qual", "4", "auto");
INSERT INTO `wp_options` VALUES("4624", "litespeed.conf.media-lqip_min_w", "150", "auto");
INSERT INTO `wp_options` VALUES("4625", "litespeed.conf.media-lqip_min_h", "150", "auto");
INSERT INTO `wp_options` VALUES("4626", "litespeed.conf.media-placeholder_resp_async", "1", "auto");
INSERT INTO `wp_options` VALUES("4627", "litespeed.conf.media-iframe_lazy", "", "auto");
INSERT INTO `wp_options` VALUES("4628", "litespeed.conf.media-add_missing_sizes", "", "auto");
INSERT INTO `wp_options` VALUES("4629", "litespeed.conf.media-lazy_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4630", "litespeed.conf.media-lazy_cls_exc", "[\"wmu-preview-img\"]", "auto");
INSERT INTO `wp_options` VALUES("4631", "litespeed.conf.media-lazy_parent_cls_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4632", "litespeed.conf.media-iframe_lazy_cls_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4633", "litespeed.conf.media-iframe_lazy_parent_cls_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4634", "litespeed.conf.media-lazy_uri_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4635", "litespeed.conf.media-lqip_exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4636", "litespeed.conf.media-vpi", "", "auto");
INSERT INTO `wp_options` VALUES("4637", "litespeed.conf.media-vpi_cron", "", "auto");
INSERT INTO `wp_options` VALUES("4638", "litespeed.conf.img_optm-auto", "", "auto");
INSERT INTO `wp_options` VALUES("4639", "litespeed.conf.img_optm-ori", "1", "auto");
INSERT INTO `wp_options` VALUES("4640", "litespeed.conf.img_optm-rm_bkup", "", "auto");
INSERT INTO `wp_options` VALUES("4641", "litespeed.conf.img_optm-webp", "", "auto");
INSERT INTO `wp_options` VALUES("4642", "litespeed.conf.img_optm-lossless", "", "auto");
INSERT INTO `wp_options` VALUES("4643", "litespeed.conf.img_optm-exif", "1", "auto");
INSERT INTO `wp_options` VALUES("4644", "litespeed.conf.img_optm-webp_attr", "[\"img.src\",\"div.data-thumb\",\"img.data-src\",\"img.data-lazyload\",\"div.data-large_image\",\"img.retina_logo_url\",\"div.data-parallax-image\",\"div.data-vc-parallax-image\",\"video.poster\"]", "auto");
INSERT INTO `wp_options` VALUES("4645", "litespeed.conf.img_optm-webp_replace_srcset", "", "auto");
INSERT INTO `wp_options` VALUES("4646", "litespeed.conf.img_optm-jpg_quality", "82", "auto");
INSERT INTO `wp_options` VALUES("4647", "litespeed.conf.crawler", "", "auto");
INSERT INTO `wp_options` VALUES("4648", "litespeed.conf.crawler-crawl_interval", "302400", "auto");
INSERT INTO `wp_options` VALUES("4649", "litespeed.conf.crawler-load_limit", "1", "auto");
INSERT INTO `wp_options` VALUES("4650", "litespeed.conf.crawler-sitemap", "", "auto");
INSERT INTO `wp_options` VALUES("4651", "litespeed.conf.crawler-roles", "[]", "auto");
INSERT INTO `wp_options` VALUES("4652", "litespeed.conf.crawler-cookies", "[]", "auto");
INSERT INTO `wp_options` VALUES("4653", "litespeed.conf.misc-heartbeat_front", "", "auto");
INSERT INTO `wp_options` VALUES("4654", "litespeed.conf.misc-heartbeat_front_ttl", "60", "auto");
INSERT INTO `wp_options` VALUES("4655", "litespeed.conf.misc-heartbeat_back", "", "auto");
INSERT INTO `wp_options` VALUES("4656", "litespeed.conf.misc-heartbeat_back_ttl", "60", "auto");
INSERT INTO `wp_options` VALUES("4657", "litespeed.conf.misc-heartbeat_editor", "", "auto");
INSERT INTO `wp_options` VALUES("4658", "litespeed.conf.misc-heartbeat_editor_ttl", "15", "auto");
INSERT INTO `wp_options` VALUES("4659", "litespeed.conf.cdn", "", "auto");
INSERT INTO `wp_options` VALUES("4660", "litespeed.conf.cdn-ori", "[]", "auto");
INSERT INTO `wp_options` VALUES("4661", "litespeed.conf.cdn-ori_dir", "[\"wp-content\",\"wp-includes\"]", "auto");
INSERT INTO `wp_options` VALUES("4662", "litespeed.conf.cdn-exc", "[]", "auto");
INSERT INTO `wp_options` VALUES("4663", "litespeed.conf.cdn-quic", "", "auto");
INSERT INTO `wp_options` VALUES("4664", "litespeed.conf.cdn-cloudflare", "", "auto");
INSERT INTO `wp_options` VALUES("4665", "litespeed.conf.cdn-cloudflare_email", "", "auto");
INSERT INTO `wp_options` VALU