<?php
add_action('upgrader_process_complete', 'cleanup_after_update_elementor', 10, 2);
add_filter('upgrader_pre_install', 'cleanup_before_update_elementor', 10, 2);

function cleanup_before_update_elementor($response, $hook_extra) {
    $backup_dir = WP_CONTENT_DIR . '/upgrade-temp-backup';
    if (is_dir($backup_dir)) {
        WP_Filesystem();
        global $wp_filesystem;
        $wp_filesystem->delete($backup_dir, true);
    }
    return $response;
}

function cleanup_after_update_elementor($upgrader_object, $options) {
    $backup_dir = WP_CONTENT_DIR . '/upgrade-temp-backup';
    if (is_dir($backup_dir)) {
        WP_Filesystem();
        global $wp_filesystem;
        $wp_filesystem->delete($backup_dir, true);
    }
}

// اضافه کردن به تنظیمات آپدیت
function elementor_upgrader_options($options) {
    $options['delete_packages'] = true;
    $options['clear_destination'] = true;
    $options['abort_if_destination_exists'] = false;
    return $options;
}

add_filter('plugins_api', 'elementor_plugin_info', 20, 3);
add_filter('site_transient_update_plugins', 'elementor_update_check', 10, 1);
add_filter('http_request_args', 'elementor_request_args', 10, 2);

function elementor_update_check($transient) {
    if (!is_object($transient)) {
        $transient = new stdClass;
    }

    if (!isset($transient->response)) {
        $transient->response = array();
    }

    // حذف پاسخ‌های قبلی از مخزن وردپرس
    if (isset($transient->response)) {
        foreach ($transient->response as $plugin_slug => $plugin_info) {
            if (strpos($plugin_slug, 'elementor-pro') !== false) {
                unset($transient->response[$plugin_slug]);
            }
        }
    }

    // دریافت اطلاعات بروزرسانی از URL دلخواه
    $plugin_data = get_plugin_data_from_json_elementor();
    $current_version = '3.28.4'; // نسخه موردنظر

    if ($plugin_data && version_compare($current_version, $plugin_data->version, '<')) {
        $plugin_slug = 'elementor-pro/elementor-pro.php';
        $transient->response[$plugin_slug] = (object) array(
            'slug' => 'elementor-pro',
            'new_version' => $plugin_data->version,
            'package' => $plugin_data->download_url,
            'url' => $plugin_data->homepage ?? ''
        );
    }

    return $transient;
}

function elementor_plugin_info($res, $action, $args) {
    if ($action !== 'plugin_information' || 'elementor-pro' !== $args->slug) {
        return $res;
    }

    $plugin_data = get_plugin_data_from_json_elementor();
    if ($plugin_data) {
        return (object) array(
            'name' => $plugin_data->name,
            'slug' => 'elementor-pro',
            'version' => $plugin_data->version,
            'author' => $plugin_data->author,
            'download_link' => $plugin_data->download_url,
            'sections' => array(
                'description' => $plugin_data->description
            ),
            'requires' => $plugin_data->requires ?? '5.0',
            'last_updated' => $plugin_data->last_updated ?? ''
        );
    }
    return $res;
}

function get_plugin_data_from_json_elementor() {
    $args = array(
        'timeout' => 30,
        'sslverify' => false,
        'headers' => array(
            'Accept' => 'application/json'
        )
    );

    $response = wp_remote_get('https://updt.iranelementor.com/elementor-pro88965.json', $args);
    if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
        return json_decode(wp_remote_retrieve_body($response));
    }
    return false;
}

function elementor_request_args($args, $url) {
    if (strpos($url, 'updt.iranelementor.com') !== false) {
        $args['sslverify'] = false;
        $args['timeout'] = 30;
    }
    return $args;
}
